/*
 * Decompiled with CFR 0.152.
 */
package holmes.clusters;

import holmes.clusters.Clustering;
import holmes.darkgui.GUIManager;
import holmes.files.clusters.ClusterReader;
import java.io.Serializable;
import java.util.ArrayList;

public class ClusteringInfoMatrix
implements Serializable {
    private static final long serialVersionUID = 5927650729868670543L;
    private ArrayList<ArrayList<Clustering>> bigTable;
    public int mainTablesNumber = 0;
    public boolean secondaryTablesSameSize = true;
    public int secondaryTablesMinNumber = 0;

    public int readDataDirectory(String path) {
        GUIManager.getDefaultGUIManager().log("Attempting to read cluster directory: " + path, "text", true);
        ClusterReader reader = new ClusterReader();
        ArrayList<ArrayList<Clustering>> receivedMatrix = reader.readDirectory(path);
        if (receivedMatrix == null) {
            GUIManager.getDefaultGUIManager().log("Reading operation failed. Clusters data matrix has not been created.", "error", true);
            return -1;
        }
        int tmp2ndSize = 0;
        for (int i = 0; i < receivedMatrix.size(); ++i) {
            ++this.mainTablesNumber;
            if (i == 0) {
                this.secondaryTablesMinNumber = tmp2ndSize = receivedMatrix.get(0).size();
                continue;
            }
            if (tmp2ndSize == receivedMatrix.get(i).size()) continue;
            this.secondaryTablesSameSize = false;
            if (this.secondaryTablesMinNumber <= receivedMatrix.get(i).size()) continue;
            this.secondaryTablesMinNumber = receivedMatrix.get(i).size();
        }
        this.setMatrix(receivedMatrix);
        return 0;
    }

    public Clustering getClustering(int id56, int idRow) {
        return this.bigTable.get(id56).get(idRow);
    }

    public void setMatrix(ArrayList<ArrayList<Clustering>> newTable) {
        this.bigTable = newTable;
    }

    public ArrayList<ArrayList<Clustering>> getMatrix() {
        return this.bigTable;
    }
}

