/*
 * Decompiled with CFR 0.152.
 */
package holmes.analyse.comparison.structures;

import holmes.petrinet.elements.Node;
import holmes.petrinet.elements.PetriNetElement;
import java.util.ArrayList;

public class BranchVertex {
    Node branchVertex;
    public ArrayList<Node> inEndpoints;
    public ArrayList<Node> outEndpoints;

    public BranchVertex(Node bv, ArrayList<Node> ei, ArrayList<Node> eo) {
        this.branchVertex = bv;
        this.inEndpoints = ei;
        this.outEndpoints = eo;
    }

    public void addInEndpoint(Node n) {
        this.inEndpoints.add(n);
    }

    public String getBVName() {
        return this.branchVertex.getName();
    }

    public long getNumberOfInTransitions() {
        return this.inEndpoints.stream().filter(x -> x.getType().equals((Object)PetriNetElement.PetriNetElementType.TRANSITION)).count();
    }

    public long getNumberOfOutTransitions() {
        return this.outEndpoints.stream().filter(x -> x.getType().equals((Object)PetriNetElement.PetriNetElementType.TRANSITION)).count();
    }

    public long getNumberOfInPlace() {
        return this.inEndpoints.stream().filter(x -> x.getType().equals((Object)PetriNetElement.PetriNetElementType.PLACE)).count();
    }

    public long getNumberOfOutPlace() {
        return this.outEndpoints.stream().filter(x -> x.getType().equals((Object)PetriNetElement.PetriNetElementType.PLACE)).count();
    }

    public void addOutEndpoint(Node n) {
        this.outEndpoints.add(n);
    }

    public int getDegreeOfBV() {
        return this.branchVertex.getNeighborsArcs().size();
    }

    public int getInDegreeOfBV() {
        return this.branchVertex.getInputArcs().size();
    }

    public int getOutDegreeOfBV() {
        return this.branchVertex.getOutputArcs().size();
    }

    public PetriNetElement.PetriNetElementType getTypeOfBV() {
        return this.branchVertex.getType();
    }

    public int getDegreeOfInEndpoint(int index) {
        return this.inEndpoints.get(index).getNeighborsArcs().size();
    }

    public int getInDegreeOfInEndpoint(int index) {
        return this.inEndpoints.get(index).getInputArcs().size();
    }

    public int getOutDegreeOfInEndpoint(int index) {
        return this.inEndpoints.get(index).getOutputArcs().size();
    }

    public PetriNetElement.PetriNetElementType getTypeOfInEndpoint(int index) {
        return this.inEndpoints.get(index).getType();
    }

    public int getDegreeOfOutEndpoint(int index) {
        return this.outEndpoints.get(index).getNeighborsArcs().size();
    }

    public int getInDegreeOfOutEndpoint(int index) {
        return this.outEndpoints.get(index).getInputArcs().size();
    }

    public int getOutDegreeOfOutEndpoint(int index) {
        return this.outEndpoints.get(index).getOutputArcs().size();
    }

    public PetriNetElement.PetriNetElementType getTypeOfOutEndpoint(int index) {
        return this.outEndpoints.get(index).getType();
    }
}

