/*
 * Decompiled with CFR 0.152.
 */
package holmes.analyse.comparison.structures;

import holmes.analyse.SubnetCalculator;
import holmes.petrinet.elements.Arc;
import holmes.petrinet.elements.Node;
import holmes.petrinet.elements.PetriNetElement;
import holmes.petrinet.elements.Place;
import holmes.petrinet.elements.Transition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.stream.Collectors;
import javax.swing.JOptionPane;

public class BranchBasedSubnet {
    public ArrayList<BranchVertex> branchVertices = new ArrayList();
    public ArrayList<Node> nodes = new ArrayList();
    public ArrayList<Transition> transitions = new ArrayList();
    public ArrayList<Place> places = new ArrayList();
    public ArrayList<Branch> pairs;
    public int[][] branchDirMatrix;
    public ArrayList<SubnetCalculator.Path> paths;
    ArrayList<Node> usedNodes = new ArrayList();

    public BranchBasedSubnet(SubnetCalculator.SubNet sn) {
        this.nodes = sn.getSubNode();
        this.places = sn.getSubPlaces();
        this.transitions = sn.getSubTransitions();
        for (Transition t : sn.getSubTransitions()) {
            if (t.getInputNodes().size() <= 1 && t.getOutputNodes().size() <= 1) continue;
            this.branchVertices.add(new BranchVertex(t, this));
        }
        this.paths = this.calculatePaths(this.nodes);
        this.pairs = this.generatePaits();
        this.branchDirMatrix = this.generateMatrix();
    }

    public BranchBasedSubnet(BranchVertex bv) {
        this.branchVertices.add(bv);
        for (Branch b : bv.tbranch) {
            for (Node n : b.branchElements) {
                if (!this.nodes.contains(n)) {
                    this.nodes.add(n);
                }
                if (n.getType().equals((Object)PetriNetElement.PetriNetElementType.PLACE) && !this.places.contains(n)) {
                    this.places.add((Place)n);
                }
                if (!n.getType().equals((Object)PetriNetElement.PetriNetElementType.TRANSITION) || this.transitions.contains(n)) continue;
                this.transitions.add((Transition)n);
            }
        }
        for (Branch b : bv.pbranches) {
            for (Node n : b.branchElements) {
                if (!this.nodes.contains(n)) {
                    this.nodes.add(n);
                }
                if (n.getType().equals((Object)PetriNetElement.PetriNetElementType.PLACE) && !this.places.contains(n)) {
                    this.places.add((Place)n);
                }
                if (!n.getType().equals((Object)PetriNetElement.PetriNetElementType.TRANSITION) || this.transitions.contains(n)) continue;
                this.transitions.add((Transition)n);
            }
        }
        this.paths = this.calculatePaths(this.nodes);
        this.pairs = this.generatePaits();
        this.branchDirMatrix = this.generateMatrix();
    }

    private ArrayList<SubnetCalculator.Path> calculatePaths(ArrayList<Node> allNodes) {
        ArrayList<Node> nodes;
        ArrayList<SubnetCalculator.Path> listOfPaths = new ArrayList<SubnetCalculator.Path>();
        for (Node n : allNodes) {
            if (n.getOutputNodes().size() <= 1 && n.getInputNodes().size() != 0 && (n.getInputNodes().size() <= 1 || n.getOutputNodes().size() == 0)) continue;
            if (n.getOutputNodes().size() > 1) {
                this.usedNodes.add(n);
                for (Node m : n.getOutputNodes()) {
                    if (!allNodes.contains(m)) continue;
                    ArrayList<Node> startPath = new ArrayList<Node>();
                    startPath.add(n);
                    ArrayList<Node> nodes2 = this.calculatePath(m, startPath, allNodes);
                    if (nodes2.get(nodes2.size() - 1).getOutputNodes().contains(nodes2.get(0))) {
                        listOfPaths.add(new SubnetCalculator.Path(nodes2.get(0), nodes2.get(nodes2.size() - 1), new ArrayList<Node>(nodes2), true));
                        continue;
                    }
                    listOfPaths.add(new SubnetCalculator.Path(nodes2.get(0), nodes2.get(nodes2.size() - 1), new ArrayList<Node>(nodes2)));
                }
                continue;
            }
            nodes = this.calculatePath(n, new ArrayList<Node>(), allNodes);
            listOfPaths.add(new SubnetCalculator.Path(nodes.get(0), nodes.get(nodes.size() - 1), new ArrayList<Node>(nodes)));
        }
        for (Node n : allNodes) {
            if (this.usedNodes.contains(n)) continue;
            nodes = this.calculatePath(n, new ArrayList<Node>(), allNodes);
            listOfPaths.add(new SubnetCalculator.Path(nodes.get(0), nodes.get(nodes.size() - 1), new ArrayList<Node>(nodes), true));
        }
        ArrayList<SubnetCalculator.Path> listToRemove = new ArrayList<SubnetCalculator.Path>();
        ArrayList<SubnetCalculator.Path> listToAdd = new ArrayList<SubnetCalculator.Path>();
        for (int i = 0; i < listOfPaths.size(); ++i) {
            for (int j = i + 1; j < listOfPaths.size(); ++j) {
                ArrayList<Node> toRemoveFirstElement;
                ArrayList<Node> newList;
                if (((SubnetCalculator.Path)listOfPaths.get((int)i)).startNode.getID() == ((SubnetCalculator.Path)listOfPaths.get((int)j)).endNode.getID()) {
                    newList = new ArrayList<Node>();
                    newList.addAll(listOfPaths.get((int)j).path);
                    toRemoveFirstElement = new ArrayList<Node>(listOfPaths.get((int)i).path);
                    toRemoveFirstElement.remove(0);
                    newList.addAll(toRemoveFirstElement);
                    listToAdd.add(new SubnetCalculator.Path((Node)newList.get(0), (Node)newList.get(newList.size() - 1), newList));
                    listToRemove.add(listOfPaths.get(i));
                    listToRemove.add(listOfPaths.get(j));
                    continue;
                }
                if (((SubnetCalculator.Path)listOfPaths.get((int)i)).endNode.getID() != listOfPaths.get((int)j).startNode.getID()) continue;
                newList = new ArrayList();
                newList.addAll(listOfPaths.get((int)i).path);
                toRemoveFirstElement = new ArrayList<Node>(listOfPaths.get((int)j).path);
                toRemoveFirstElement.remove(0);
                newList.addAll(toRemoveFirstElement);
                listToAdd.add(new SubnetCalculator.Path(newList.get(0), newList.get(newList.size() - 1), newList));
                listToRemove.add(listOfPaths.get(i));
                listToRemove.add(listOfPaths.get(j));
            }
        }
        listOfPaths.removeAll(listToRemove);
        listOfPaths.addAll(listToAdd);
        listToRemove = new ArrayList();
        for (SubnetCalculator.Path p : listOfPaths) {
            if (p.path.size() != 1 || listOfPaths.size() <= 1) continue;
            listToRemove.add(p);
        }
        listOfPaths.removeAll(listToRemove);
        return listOfPaths;
    }

    private ArrayList<Node> calculatePath(Node m, ArrayList<Node> path, ArrayList<Node> possibleNodes) {
        if (path.contains(m)) {
            return path;
        }
        this.usedNodes.add(m);
        path.add(m);
        if (m.getOutputNodes().size() > 0 && m.getOutputNodes().size() == 1 && possibleNodes.contains(m.getOutputNodes().get(0))) {
            this.calculatePath(m.getOutputNodes().get(0), path, possibleNodes);
        }
        return path;
    }

    private ArrayList<Branch> generatePaits() {
        ArrayList<Branch> bp = new ArrayList<Branch>();
        for (BranchVertex bv : this.branchVertices) {
            for (Branch bt : bv.tbranch) {
                if (!bp.stream().noneMatch(x -> x.branchElements.containsAll(bt.branchElements))) continue;
                bp.add(bt);
            }
        }
        return bp;
    }

    private int[][] generateMatrix() {
        int[][] bdm = new int[this.pairs.size()][this.transitions.size()];
        for (int b = 0; b < this.pairs.size(); ++b) {
            for (int t = 0; t < this.transitions.size(); ++t) {
                bdm[b][t] = this.transitions.get(t).getID() == this.pairs.get((int)b).startNode.getID() ? -1 : (this.transitions.get(t).getID() == this.pairs.get((int)b).endNode.getID() ? 1 : 0);
            }
        }
        return bdm;
    }

    public class BranchVertex {
        public Node root;
        public ArrayList<Branch> pbranches = new ArrayList();
        public ArrayList<Branch> tbranch = new ArrayList();
        public ArrayList<Branch> tbranchC = new ArrayList();
        public ArrayList<Branch> tbranchS = new ArrayList();

        public BranchVertex(Node r, BranchBasedSubnet bbs) {
            Branch br;
            this.root = r;
            for (Node n : r.getOutputNodes()) {
                br = new Branch(r, n, bbs);
                if (br.startNode.getType().equals((Object)PetriNetElement.PetriNetElementType.PLACE) || br.endNode.getType().equals((Object)PetriNetElement.PetriNetElementType.PLACE)) {
                    this.pbranches.add(br);
                    continue;
                }
                this.tbranch.add(br);
                if (br.startNode.equals(br.endNode)) {
                    this.tbranchC.add(br);
                    continue;
                }
                this.tbranchS.add(br);
            }
            for (Node n : r.getInputNodes()) {
                br = new Branch(r, n, bbs);
                if (br.startNode.getType().equals((Object)PetriNetElement.PetriNetElementType.TRANSITION) && br.endNode.getType().equals((Object)PetriNetElement.PetriNetElementType.PLACE)) {
                    br.reverseBranch();
                }
                if (br.startNode.getType().equals((Object)PetriNetElement.PetriNetElementType.PLACE) || br.endNode.getType().equals((Object)PetriNetElement.PetriNetElementType.PLACE)) {
                    this.pbranches.add(br);
                    continue;
                }
                this.tbranch.add(br);
                if (br.startNode.equals(br.endNode)) {
                    this.tbranchC.add(br);
                    continue;
                }
                this.tbranchS.add(br);
            }
        }

        public ArrayList<Branch> getSek() {
            return this.tbranch.stream().filter(x -> x.endNode.getNeighborsArcs().size() == 1 || x.startNode.getNeighborsArcs().size() == 1).collect(Collectors.toCollection(ArrayList::new));
        }

        public ArrayList<Branch> getLoop() {
            return this.tbranch.stream().filter(x -> x.startNode.equals(x.endNode)).collect(Collectors.toCollection(ArrayList::new));
        }
    }

    public static class Branch {
        public Node startNode;
        public Node endNode;
        public ArrayList<Node> internalBranchElements = new ArrayList();
        public ArrayList<Node> branchElements = new ArrayList();
        public ArrayList<Arc> branchArcs = new ArrayList();
        public BranchBasedSubnet parent;
        public HashMap<Node, Node> nodeMap = new HashMap();
        public HashMap<Arc, Arc> arcMap = new HashMap();
        public boolean isCycle = false;

        public Branch(Branch rew) {
            this.parent = rew.parent;
            this.branchElements.addAll(new ArrayList<Node>(rew.branchElements));
            this.branchArcs.addAll(new ArrayList<Arc>(rew.branchArcs));
            this.startNode = rew.startNode;
            this.endNode = rew.endNode;
            this.sortBranch();
            this.internalBranchElements = new ArrayList<Node>(rew.internalBranchElements);
            this.reverseBranch();
        }

        public Branch(ArrayList<Node> be, ArrayList<Arc> ba, BranchBasedSubnet parentNode) {
            this.parent = parentNode;
            this.branchElements.addAll(be);
            this.branchArcs.addAll(ba);
            this.startNode = be.get(0);
            this.endNode = be.get(be.size() - 1);
            this.sortBranch();
            ArrayList<Object> intEr = new ArrayList();
            if (be.size() > 2) {
                intEr = new ArrayList<Node>(be);
                intEr.remove(intEr.size() - 1);
                intEr.remove(0);
            }
            this.internalBranchElements = intEr;
            if (this.startNode.getID() == this.endNode.getID()) {
                this.isCycle = true;
            }
        }

        public Branch(ArrayList<Node> be, ArrayList<Arc> ba, BranchBasedSubnet parentNode, HashMap<Node, Node> nm, HashMap<Arc, Arc> am) {
            this.nodeMap = nm;
            this.arcMap = am;
            this.parent = parentNode;
            this.branchElements.addAll(be);
            this.branchArcs.addAll(ba);
            this.startNode = be.get(0);
            this.endNode = be.get(be.size() - 1);
            this.sortBranch();
            ArrayList<Object> intEr = new ArrayList();
            if (be.size() > 2) {
                intEr = new ArrayList<Node>(be);
                intEr.remove(intEr.size() - 1);
                intEr.remove(0);
            }
            this.internalBranchElements = intEr;
            if (this.startNode.getID() == this.endNode.getID()) {
                this.isCycle = true;
            }
        }

        private void sortBranch() {
            ArrayList<Node> tmp;
            ArrayList<Node> newOrdering = new ArrayList<Node>();
            ArrayList elements = this.branchElements.stream().filter(x -> x.getInputArcs().size() > 1 || x.getOutputArcs().size() > 1 || x.getOutputArcs().size() == 0 || x.getInputArcs().size() == 0).collect(Collectors.toCollection(ArrayList::new));
            Node start = null;
            Node end = null;
            for (Node nod : elements) {
                tmp = nod.getInputNodes();
                tmp.retainAll(this.branchElements);
                if (tmp.size() <= 0) continue;
                end = nod;
            }
            for (Node nod : elements) {
                tmp = nod.getOutputNodes();
                tmp.retainAll(this.branchElements);
                if (tmp.size() <= 0) continue;
                start = nod;
            }
            if (start == null) {
                newOrdering.add(end);
                while (newOrdering.size() != this.branchElements.size()) {
                    tmp = new ArrayList<Node>(this.branchElements);
                    tmp.retainAll(((Node)newOrdering.get(0)).getInputNodes());
                    if (tmp.size() != 0) {
                        if (tmp.size() == 1) {
                            newOrdering.add(0, tmp.get(0));
                            continue;
                        }
                        newOrdering.add(0, tmp.get(0));
                        System.out.println("Koniec sortowania cyklu w branchu");
                        continue;
                    }
                    break;
                }
            } else {
                newOrdering.add(start);
                while (newOrdering.size() != this.branchElements.size()) {
                    tmp = new ArrayList<Node>(this.branchElements);
                    tmp.retainAll(((Node)newOrdering.get(newOrdering.size() - 1)).getOutputNodes());
                    if (tmp.size() == 0) break;
                    if (tmp.size() == 1) {
                        newOrdering.add(tmp.get(0));
                    } else {
                        newOrdering.add(tmp.get(0));
                        System.out.println("Koniec sortowania cyklu w branchu");
                    }
                    if (newOrdering.size() <= 1 || !((Node)newOrdering.get(newOrdering.size() - 1)).equals(end)) continue;
                    break;
                }
            }
            if (newOrdering.size() == this.branchElements.size()) {
                this.branchElements = newOrdering;
            }
        }

        private void OldsortBranch() {
            ArrayList<Node> newOrdering = new ArrayList<Node>();
            Node n = this.branchElements.get(0);
            newOrdering.add(n);
            while (newOrdering.size() != this.branchElements.size()) {
                boolean noPrev = false;
                boolean noNext = false;
                ArrayList<Node> tmp = new ArrayList<Node>(this.branchElements);
                tmp.retainAll(((Node)newOrdering.get(0)).getInputNodes());
                if (tmp.size() == 0) {
                    noPrev = true;
                } else if (tmp.size() == 1) {
                    if (tmp.get(0).getOutputArcs().size() > 1 || tmp.get(0).getInputArcs().size() > 1) {
                        System.out.println("-> " + tmp.get(0).getName());
                    }
                    if (newOrdering.contains(tmp.get(0))) {
                        newOrdering.add(0, tmp.get(0));
                    }
                } else if (tmp.size() > 1) {
                    JOptionPane.showMessageDialog(null, "Co\u015b zjeba\u0142e\u015b nr 11", "WARNING MESSAGE", 2);
                }
                tmp = new ArrayList<Node>(this.branchElements);
                tmp.retainAll(((Node)newOrdering.get(newOrdering.size() - 1)).getOutputNodes());
                if (tmp.size() == 0) {
                    noNext = true;
                } else if (tmp.size() == 1) {
                    if (tmp.get(0).getOutputArcs().size() > 1 || tmp.get(0).getInputArcs().size() > 1) {
                        System.out.println("<- " + tmp.get(0).getName());
                    }
                    newOrdering.add(tmp.get(0));
                } else if (tmp.size() > 1) {
                    JOptionPane.showMessageDialog(null, "Co\u015b zjeba\u0142e\u015b nr 12", "WARNING MESSAGE", 2);
                }
                if (!noNext || !noPrev) continue;
                break;
            }
            this.branchElements.addAll(newOrdering);
        }

        Branch(Node s, Node nextNode, BranchBasedSubnet parentNode) {
            this.parent = parentNode;
            this.startNode = s;
            this.branchElements.add(s);
            for (Arc a : s.getNeighborsArcs()) {
                if (!a.getStartNode().equals(nextNode) && !a.getEndNode().equals(nextNode)) continue;
                this.branchArcs.add(a);
            }
            this.generateList(nextNode);
            if (this.internalBranchElements.size() > 0 && this.startNode.getID() != this.endNode.getID() && this.startNode.getInputNodes().contains(this.internalBranchElements.get(0))) {
                Collections.reverse(this.branchElements);
                Collections.reverse(this.internalBranchElements);
                Node tmp = this.endNode;
                this.endNode = this.startNode;
                this.startNode = tmp;
            }
            if (this.startNode.getID() == this.endNode.getID()) {
                this.isCycle = true;
            }
        }

        public ArrayList<Node> returnBorderNodes() {
            ArrayList<Node> list = new ArrayList<Node>();
            list.add(this.startNode);
            list.add(this.endNode);
            return list;
        }

        public int branchSize() {
            return this.branchElements.size();
        }

        public void reverseBranch() {
            Collections.reverse(this.branchElements);
            Collections.reverse(this.branchArcs);
            Collections.reverse(this.internalBranchElements);
            this.startNode = this.branchElements.get(0);
            this.endNode = this.branchElements.get(this.branchElements.size() - 1);
        }

        void generateList(Node n) {
            if (n.getOutputNodes().size() > 1 || n.getInputNodes().size() > 1 || n.getOutputNodes().size() == 0 || n.getInputNodes().size() == 0) {
                ArrayList<Node> list = new ArrayList<Node>(this.parent.nodes);
                list.retainAll(n.getNeighborsNodes());
                ArrayList<Node> listIn = new ArrayList<Node>(this.parent.nodes);
                listIn.retainAll(n.getInputNodes());
                ArrayList<Node> listOut = new ArrayList<Node>(this.parent.nodes);
                listOut.retainAll(n.getOutputNodes());
                if (list.size() > 1 && n.getType().equals((Object)PetriNetElement.PetriNetElementType.PLACE)) {
                    if (listIn.size() > 1 && listOut.size() == 0 || listOut.size() > 1 && listIn.size() == 0) {
                        this.branchElements.add(n);
                        this.endNode = n;
                    } else {
                        this.internalBranchElements.add(n);
                        this.branchElements.add(n);
                        if (this.branchElements.size() > 1) {
                            int counter = 0;
                            for (Node m : n.getNeighborsNodes()) {
                                if (!this.branchElements.contains(m) && this.parent.nodes.contains(m)) {
                                    ArrayList<Arc> arc1 = new ArrayList<Arc>(n.getNeighborsArcs());
                                    ArrayList<Arc> arc2 = new ArrayList<Arc>(m.getNeighborsArcs());
                                    arc1.retainAll(arc2);
                                    this.branchArcs.addAll(arc1);
                                    this.generateList(m);
                                    if (counter == 1) {
                                        System.out.println("tt1");
                                    }
                                    ++counter;
                                }
                                if (counter <= true) continue;
                                System.out.println("ADT STARTS HERE: " + this.startNode.getName());
                            }
                        }
                    }
                } else {
                    this.branchElements.add(n);
                    this.endNode = n;
                }
            } else {
                this.internalBranchElements.add(n);
                this.branchElements.add(n);
                if (this.branchElements.size() > 1) {
                    int counter = 0;
                    for (Node m : n.getNeighborsNodes()) {
                        if (!this.branchElements.contains(m) && !m.equals(this.startNode)) {
                            ArrayList<Arc> arc1 = new ArrayList<Arc>(n.getNeighborsArcs());
                            ArrayList<Arc> arc2 = new ArrayList<Arc>(m.getNeighborsArcs());
                            arc1.retainAll(arc2);
                            this.branchArcs.addAll(arc1);
                            this.generateList(m);
                            if (++counter == 2) {
                                System.out.println("tt");
                            }
                        }
                        if (counter <= true) continue;
                        JOptionPane.showMessageDialog(null, "Co\u015b zjeba\u0142e\u015b nr 2", "WARNING MESSAGE", 2);
                    }
                }
            }
            if (this.endNode == null && this.branchElements.get(this.branchElements.size() - 1).getNeighborsNodes().contains(this.startNode)) {
                for (Arc a : this.branchElements.get(this.branchElements.size() - 1).getNeighborsArcs()) {
                    if (!a.getStartNode().equals(this.startNode) && !a.getEndNode().equals(this.startNode)) continue;
                    this.branchArcs.add(a);
                }
                this.branchElements.add(this.startNode);
                this.endNode = this.startNode;
            } else if (this.endNode == null) {
                System.out.println("Tu powinno by\u0107 okno cos zjenales nr 3");
            }
        }

        public static class LenghtSort
        implements Comparator<Branch> {
            @Override
            public int compare(Branch o1, Branch o2) {
                return o1.branchElements.size() - o2.branchElements.size();
            }
        }
    }
}

