/*
 * Decompiled with CFR 0.152.
 */
package holmes.analyse.comparison.experiment;

import holmes.analyse.GraphletsCalculator;
import holmes.analyse.SubnetCalculator;
import holmes.darkgui.GUIManager;
import holmes.files.io.IOprotocols;
import holmes.petrinet.data.IdGenerator;
import holmes.petrinet.data.PetriNet;
import holmes.petrinet.elements.Arc;
import holmes.petrinet.elements.Node;
import holmes.petrinet.elements.PetriNetElement;
import holmes.petrinet.elements.Place;
import holmes.petrinet.elements.Transition;
import java.awt.Point;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import javax.swing.JOptionPane;

public class NetGenerator {
    boolean conservative = false;
    int x_p = 10;
    int y_p = 10;
    int x_t = 70;
    int y_t = 10;
    IOprotocols io = new IOprotocols();
    String directory = "/home/bszawulak/Dokumenty/Eksperyment/Wyniki-den-60";
    String pathToFiles = "/home/labnanobio-01/Dokumenty/Eksperyment/";

    private void setNewDirectory(String path) {
        try {
            Files.createDirectories(Paths.get(this.directory + path, new String[0]), new FileAttribute[0]);
        }
        catch (IOException erio) {
            System.out.println(erio.getMessage());
        }
    }

    public NetGenerator(boolean non) {
        int i = 0;
        int j = 35;
        int p = 32;
        this.setNewDirectory("/i" + i + "j" + j + "/i" + i + "j" + j + "p" + p);
        GraphletsCalculator.generateGraphlets();
        ArrayList<int[]> DGDV = new ArrayList<int[]>();
        SubnetCalculator.SubNet sn = new SubnetCalculator.SubNet(GUIManager.getDefaultGUIManager().getWorkspace().getProject().getArcs());
        SubnetCalculator.SubNet nsn = this.addStar4(this.cloneSubNet(sn));
        nsn = this.addStar4L(this.cloneSubNet(nsn));
        nsn = this.addStar4Lk(this.cloneSubNet(nsn));
        nsn = this.addCycle6(this.cloneSubNet(nsn));
        nsn = this.addEight2(this.cloneSubNet(nsn));
        nsn = this.addParallel3(this.cloneSubNet(nsn));
        String tmpdir = this.directory + "/i" + i + "j" + j + "/i" + i + "j" + j + "p" + p + "/i" + i + "j" + j + "p" + p + "-ALLVARIANT";
        this.io.writePNT(tmpdir + ".pnt", nsn.getSubPlaces(), nsn.getSubTransitions(), nsn.getSubArcs());
        DGDV = new ArrayList();
        for (Node startNode : nsn.getSubNode()) {
            int[] vectorOrbit = GraphletsCalculator.vectorOrbit(startNode, false);
            DGDV.add(vectorOrbit);
        }
        this.writeDGDV(tmpdir + "-DGDV.txt", DGDV);
        NetGenerator.writeDGDDA(tmpdir + "-DGDDA.txt", DGDV);
    }

    public NetGenerator(String s) {
        GraphletsCalculator.generateGraphlets();
        for (int i = 0; i < 41; i += 5) {
            System.out.print("i" + i);
            for (int j = 0; j < 41; j += 5) {
                System.out.print("j" + j);
                for (int p = 0; p < 100; ++p) {
                    PetriNet pn2 = this.compareSpecificType(i, j, p, this.directory, "P3OVARIANT");
                    ArrayList<int[]> DGDV = new ArrayList<int[]>();
                    SubnetCalculator.SubNet sn = new SubnetCalculator.SubNet(pn2.getArcs());
                    String tmpdir = this.directory + "/i" + i + "j" + j + "/i" + i + "j" + j + "p" + p + "/i" + i + "j" + j + "p" + p + "-P3OVARIANT";
                    DGDV = new ArrayList();
                    for (Node startNode : sn.getSubNode()) {
                        int[] vectorOrbit = GraphletsCalculator.vectorOrbit(startNode, false);
                        DGDV.add(vectorOrbit);
                    }
                    this.writeDGDV(tmpdir + "-DGDV.txt", DGDV);
                    NetGenerator.writeDGDDA(tmpdir + "-DGDDA.txt", DGDV);
                }
                System.out.println("p");
            }
        }
    }

    private PetriNet compareSpecificType(int i, int j, int p, String path, String type) {
        IOprotocols io = new IOprotocols();
        return io.serverReadPNT(path + "/i" + i + "j" + j + "/i" + i + "j" + j + "p" + p + "/i" + i + "j" + j + "p" + p + "-" + type + ".pnt", 99);
    }

    public NetGenerator(String[] st) {
        this.generateAllFuckingGraphlets();
    }

    private void generateAllFuckingGraphlets() {
        Transition t1 = new Transition(IdGenerator.getNextId(), 99, new Point(60, 270));
        Place p1 = new Place(IdGenerator.getNextId(), 99, new Point(100, 30));
        Arc a1 = new Arc(t1.getElementLocations().get(0), p1.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        ArrayList<Arc> listOfArc = new ArrayList<Arc>();
        listOfArc.add(a1);
        SubnetCalculator.SubNet sn1 = new SubnetCalculator.SubNet(listOfArc);
        this.io.writePNT("GRAFLETY/G2/GRAFLET-0.pnt", sn1.getSubPlaces(), sn1.getSubTransitions(), sn1.getSubArcs());
        Transition t2 = new Transition(IdGenerator.getNextId(), 99, new Point(60, 170));
        Place p2 = new Place(IdGenerator.getNextId(), 99, new Point(100, 30));
        Arc a2 = new Arc(p2.getElementLocations().get(0), t2.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        ArrayList<Arc> listOfArc2 = new ArrayList<Arc>();
        listOfArc2.add(a2);
        SubnetCalculator.SubNet sn2 = new SubnetCalculator.SubNet(listOfArc2);
        this.io.writePNT("GRAFLETY/G2/GRAFLET-1.pnt", sn2.getSubPlaces(), sn2.getSubTransitions(), sn2.getSubArcs());
        ArrayList<SubnetCalculator.SubNet> graphlets_2 = new ArrayList<SubnetCalculator.SubNet>();
        graphlets_2.add(sn1);
        graphlets_2.add(sn2);
        ArrayList graphlets_3 = new ArrayList();
        ArrayList graphlets_4 = new ArrayList();
        ArrayList graphlets_5 = new ArrayList();
        ArrayList graphlets = new ArrayList();
        graphlets.add(graphlets_2);
        graphlets.add(graphlets_3);
        graphlets.add(graphlets_4);
        graphlets.add(graphlets_5);
        int graphletCounter = 2;
        int graphletRead = 0;
        for (int i = 0; i < graphlets.size() - 1; ++i) {
            ArrayList gsn = (ArrayList)graphlets.get(i);
            for (int j = 0; j < gsn.size(); ++j) {
                PetriNet petriNet = this.io.serverReadPNT("GRAFLETY/G" + (i + 2) + "/GRAFLET-" + graphletRead + ".pnt", 99);
                SubnetCalculator.SubNet sn = new SubnetCalculator.SubNet(SubnetCalculator.SubNetType.Export, null, null, petriNet.getNodes(), null, null);
                for (int k = 0; k < sn.getSubNode().size(); ++k) {
                    SubnetCalculator.SubNet snNew;
                    ArrayList<Arc> arcs;
                    Arc arc;
                    Node t3;
                    if (sn.getSubNode().get(k).getType().equals((Object)PetriNetElement.PetriNetElementType.PLACE)) {
                        t3 = new Transition(IdGenerator.getNextId(), 99, new Point(60, 270));
                        arc = new Arc(sn.getSubNode().get(k).getElementLocations().get(0), t3.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
                        arcs = new ArrayList<Arc>(sn.getSubArcs());
                        arcs.add(arc);
                        snNew = new SubnetCalculator.SubNet(arcs, true);
                        if (this.doNotContain(snNew, (ArrayList)graphlets.get(i + 1))) {
                            ((ArrayList)graphlets.get(i + 1)).add(snNew);
                            this.io.writePNT("GRAFLETY/G" + (i + 3) + "/GRAFLET-" + graphletCounter + ".pnt", snNew.getSubPlaces(), snNew.getSubTransitions(), snNew.getSubArcs());
                            this.export(snNew.getSubNode(), i, graphletCounter);
                            ++graphletCounter;
                        }
                    }
                    if (sn.getSubNode().get(k).getType().equals((Object)PetriNetElement.PetriNetElementType.PLACE)) {
                        t3 = new Transition(IdGenerator.getNextId(), 99, new Point(60, 270));
                        arc = new Arc(t3.getElementLocations().get(0), sn.getSubNode().get(k).getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
                        arcs = new ArrayList<Arc>(sn.getSubArcs());
                        arcs.add(arc);
                        snNew = new SubnetCalculator.SubNet(arcs);
                        if (this.doNotContain(snNew, (ArrayList)graphlets.get(i + 1))) {
                            ((ArrayList)graphlets.get(i + 1)).add(snNew);
                            this.io.writePNT("GRAFLETY/G" + (i + 3) + "/GRAFLET-" + graphletCounter + ".pnt", snNew.getSubPlaces(), snNew.getSubTransitions(), snNew.getSubArcs());
                            this.export(snNew.getSubNode(), i, graphletCounter);
                            ++graphletCounter;
                        }
                    }
                    if (sn.getSubNode().get(k).getType().equals((Object)PetriNetElement.PetriNetElementType.TRANSITION)) {
                        t3 = new Place(IdGenerator.getNextId(), 99, new Point(60, 270));
                        arc = new Arc(sn.getSubNode().get(k).getElementLocations().get(0), t3.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
                        arcs = new ArrayList<Arc>(sn.getSubArcs());
                        arcs.add(arc);
                        snNew = new SubnetCalculator.SubNet(arcs);
                        if (this.doNotContain(snNew, (ArrayList)graphlets.get(i + 1))) {
                            ((ArrayList)graphlets.get(i + 1)).add(snNew);
                            this.io.writePNT("GRAFLETY/G" + (i + 3) + "/GRAFLET-" + graphletCounter + ".pnt", snNew.getSubPlaces(), snNew.getSubTransitions(), snNew.getSubArcs());
                            this.export(snNew.getSubNode(), i, graphletCounter);
                            ++graphletCounter;
                        }
                    }
                    if (sn.getSubNode().get(k).getType().equals((Object)PetriNetElement.PetriNetElementType.TRANSITION)) {
                        t3 = new Place(IdGenerator.getNextId(), 99, new Point(60, 270));
                        arc = new Arc(t3.getElementLocations().get(0), sn.getSubNode().get(k).getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
                        arcs = new ArrayList<Arc>(sn.getSubArcs());
                        arcs.add(arc);
                        snNew = new SubnetCalculator.SubNet(arcs);
                        if (this.doNotContain(snNew, (ArrayList)graphlets.get(i + 1))) {
                            ((ArrayList)graphlets.get(i + 1)).add(snNew);
                            this.io.writePNT("GRAFLETY/G" + (i + 3) + "/GRAFLET-" + graphletCounter + ".pnt", snNew.getSubPlaces(), snNew.getSubTransitions(), snNew.getSubArcs());
                            this.export(snNew.getSubNode(), i, graphletCounter);
                            ++graphletCounter;
                        }
                    }
                    for (int e = 0; e < ((ArrayList)graphlets.get(i + 1)).size(); ++e) {
                        SubnetCalculator.SubNet exNet = (SubnetCalculator.SubNet)((ArrayList)graphlets.get(i + 1)).get(e);
                        for (int p = 0; p < exNet.getSubPlaces().size(); ++p) {
                            for (int t = 0; t < exNet.getSubTransitions().size(); ++t) {
                                int finalP = p;
                                int finalT = t;
                                if (this.arcExist(exNet.getSubPlaces().get(p), exNet.getSubTransitions().get(t), exNet.getSubArcs())) continue;
                                arc = new Arc(exNet.getSubPlaces().get(p).getElementLocations().get(0), exNet.getSubTransitions().get(t).getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
                                ArrayList<Arc> arcs2 = new ArrayList<Arc>(exNet.getSubArcs());
                                arcs2.add(arc);
                                SubnetCalculator.SubNet snNew2 = new SubnetCalculator.SubNet(arcs2);
                                if (this.doNotContain(snNew2, (ArrayList)graphlets.get(i + 1))) {
                                    ((ArrayList)graphlets.get(i + 1)).add(snNew2);
                                    this.io.writePNT("GRAFLETY/G" + (i + 3) + "/GRAFLET-" + graphletCounter + ".pnt", snNew2.getSubPlaces(), snNew2.getSubTransitions(), snNew2.getSubArcs());
                                    this.export(snNew2.getSubNode(), i, graphletCounter);
                                    ++graphletCounter;
                                }
                                arc = new Arc(exNet.getSubTransitions().get(t).getElementLocations().get(0), exNet.getSubPlaces().get(p).getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
                                arcs2 = new ArrayList<Arc>(exNet.getSubArcs());
                                arcs2.add(arc);
                                snNew2 = new SubnetCalculator.SubNet(arcs2);
                                if (!this.doNotContain(snNew2, (ArrayList)graphlets.get(i + 1))) continue;
                                ((ArrayList)graphlets.get(i + 1)).add(snNew2);
                                this.io.writePNT("GRAFLETY/G" + (i + 3) + "/GRAFLET-" + graphletCounter + ".pnt", snNew2.getSubPlaces(), snNew2.getSubTransitions(), snNew2.getSubArcs());
                                this.export(snNew2.getSubNode(), i, graphletCounter);
                                ++graphletCounter;
                            }
                        }
                    }
                }
                ++graphletRead;
            }
        }
        System.out.println("Graphlets 2 : " + ((ArrayList)graphlets.get(0)).size());
        System.out.println("Graphlets 3 : " + ((ArrayList)graphlets.get(1)).size());
        System.out.println("Graphlets 4 : " + ((ArrayList)graphlets.get(2)).size());
        System.out.println("Graphlets 5 : " + ((ArrayList)graphlets.get(3)).size());
        boolean count = false;
        int countGroup = 0;
        for (ArrayList arrayList : graphlets) {
            ArrayList<Arc> combineArc = new ArrayList<Arc>();
            ArrayList<Place> combinePlaces = new ArrayList<Place>();
            ArrayList<Transition> combineTransitions = new ArrayList<Transition>();
            for (SubnetCalculator.SubNet toWriteNet : arrayList) {
                combineArc.addAll(toWriteNet.getSubArcs());
                combinePlaces.addAll(toWriteNet.getSubPlaces());
                combineTransitions.addAll(toWriteNet.getSubTransitions());
            }
            ArrayList<Node> nodes = new ArrayList<Node>();
            nodes.addAll(combinePlaces);
            nodes.addAll(combineTransitions);
            SubnetCalculator.SubNet doEzportu = new SubnetCalculator.SubNet(SubnetCalculator.SubNetType.Export, null, null, nodes, null, null);
            this.io.writePNT("GRAFLETY/GRAFLET_Group-" + countGroup + ".pnt", combinePlaces, combineTransitions, combineArc);
            ++countGroup;
        }
    }

    private boolean arcExist(Place place, Transition transition, ArrayList<Arc> subArcs) {
        for (Arc a : subArcs) {
            if ((!a.getStartNode().equals(place) || !a.getEndNode().equals(transition)) && (!a.getStartNode().equals(transition) || !a.getEndNode().equals(place))) continue;
            return true;
        }
        return false;
    }

    private void export(ArrayList<Node> listOfParentNodes, int number, int graphletCounter) {
        SubnetCalculator.SubNet sn = new SubnetCalculator.SubNet(SubnetCalculator.SubNetType.Export, null, null, listOfParentNodes, null, null);
        try {
            String path = "GRAFLETY/G" + (number + 3) + "/G-" + graphletCounter + ".xml";
            FileOutputStream out = new FileOutputStream(path);
            ObjectOutputStream oos = new ObjectOutputStream(out);
            oos.writeObject(sn);
            oos.flush();
        }
        catch (Exception e) {
            System.out.println("Problem serializing: " + String.valueOf(e));
        }
    }

    private boolean doNotContain(SubnetCalculator.SubNet snNew, ArrayList<SubnetCalculator.SubNet> subNets) {
        for (SubnetCalculator.SubNet snOld : subNets) {
            if (!this.isomorphisc(snNew, snOld)) continue;
            return false;
        }
        return true;
    }

    private boolean isomorphisc(SubnetCalculator.SubNet snNew, SubnetCalculator.SubNet snOld) {
        boolean isomorphic = false;
        if (snNew.getSubPlaces().size() == snOld.getSubPlaces().size() && snNew.getSubTransitions().size() == snOld.getSubTransitions().size() && snNew.getSubArcs().size() == snOld.getSubArcs().size()) {
            int countM = 0;
            for (Node m : snOld.getSubNode()) {
                boolean matched = false;
                for (Node n : snNew.getSubNode()) {
                    if (!n.getType().equals((Object)m.getType())) continue;
                    for (Node mIn : m.getInputNodes()) {
                        boolean in = false;
                        boolean out = false;
                        for (Node nIn : n.getInputNodes()) {
                            if (nIn.getInputNodes().size() != mIn.getInputNodes().size()) continue;
                            in = true;
                        }
                        for (Node nIn : n.getOutputNodes()) {
                            if (nIn.getOutputNodes().size() != mIn.getOutputNodes().size()) continue;
                            out = true;
                        }
                        if (!in || !out) continue;
                        matched = true;
                    }
                }
                if (!matched) continue;
                ++countM;
            }
            int countN = 0;
            for (Node n : snNew.getSubNode()) {
                boolean matched = false;
                for (Node m : snOld.getSubNode()) {
                    if (!n.getType().equals((Object)m.getType())) continue;
                    for (Node nIn : n.getInputNodes()) {
                        boolean in = false;
                        boolean out = false;
                        for (Node mIn : m.getInputNodes()) {
                            if (nIn.getInputNodes().size() != mIn.getInputNodes().size()) continue;
                            in = true;
                        }
                        for (Node mIn : m.getOutputNodes()) {
                            if (nIn.getOutputNodes().size() != mIn.getOutputNodes().size()) continue;
                            out = true;
                        }
                        if (!in || !out) continue;
                        matched = true;
                    }
                }
                if (!matched) continue;
                ++countN;
            }
            if (countN == snNew.getSubNode().size() && countN == countM) {
                isomorphic = true;
            }
        }
        return isomorphic;
    }

    public NetGenerator() {
        SubnetCalculator.SubNet nsn;
        String tmpdir;
        int t;
        GraphletsCalculator.generateGraphlets();
        PetriNet pn = this.io.serverReadPNT("/home/Szavislav/Eksperyment/Distortion/BASE.pnt", 99);
        ArrayList<Object> DGDV = new ArrayList<int[]>();
        SubnetCalculator.SubNet sn = new SubnetCalculator.SubNet(pn.getArcs());
        for (Node startNode : sn.getSubNode()) {
            int[] vectorOrbit = GraphletsCalculator.vectorOrbit(startNode, false);
            DGDV.add(vectorOrbit);
        }
        this.writeDGDV("/home/Szavislav/Eksperyment/Distortion/net-BASE-DGDV.txt", DGDV);
        NetGenerator.writeDGDDA("/home/Szavislav/Eksperyment/Distortion/net-BASE-DGDDA.txt", DGDV);
        for (t = 0; t < sn.getSubTransitions().size(); ++t) {
            tmpdir = "/home/Szavislav/Eksperyment/Distortion/net-" + t;
            nsn = this.addDistortion(this.cloneSubNet(sn), t, true);
            this.io = new IOprotocols();
            this.io.writePNT(tmpdir + "A.pnt", nsn.getSubPlaces(), nsn.getSubTransitions(), nsn.getSubArcs());
            DGDV = new ArrayList();
            for (Node startNode : nsn.getSubNode()) {
                int[] vectorOrbit = GraphletsCalculator.vectorOrbit(startNode, false);
                DGDV.add(vectorOrbit);
            }
            this.writeDGDV(tmpdir + "A-DGDV.txt", DGDV);
            NetGenerator.writeDGDDA(tmpdir + "A-DGDDA.txt", DGDV);
        }
        for (t = 0; t < sn.getSubTransitions().size(); ++t) {
            tmpdir = "/home/Szavislav/Eksperyment/Distortion/net-" + t;
            nsn = this.addDistortion(this.cloneSubNet(sn), t, false);
            IOprotocols io = new IOprotocols();
            io.writePNT(tmpdir + "B.pnt", nsn.getSubPlaces(), nsn.getSubTransitions(), nsn.getSubArcs());
            DGDV = new ArrayList();
            for (Node startNode : nsn.getSubNode()) {
                int[] vectorOrbit = GraphletsCalculator.vectorOrbit(startNode, false);
                DGDV.add(vectorOrbit);
            }
            this.writeDGDV(tmpdir + "B-DGDV.txt", DGDV);
            NetGenerator.writeDGDDA(tmpdir + "B-DGDDA.txt", DGDV);
        }
    }

    public NetGenerator(float f) {
        GraphletsCalculator.generateGraphlets();
        PetriNet pn = this.io.serverReadPNT("/home/Szavislav/Eksperyment/Distortion/BASE.pnt", 99);
        ArrayList<int[]> DGDV = new ArrayList<int[]>();
        SubnetCalculator.SubNet sn = new SubnetCalculator.SubNet(pn.getArcs());
        SubnetCalculator.SubNet nsn = this.addIndependentDistortion(sn);
        this.io.writePNT("/home/Szavislav/Eksperyment/Distortion/BASE+sub.pnt", nsn.getSubPlaces(), nsn.getSubTransitions(), nsn.getSubArcs());
        for (Node startNode : nsn.getSubNode()) {
            int[] vectorOrbit = GraphletsCalculator.vectorOrbit(startNode, false);
            DGDV.add(vectorOrbit);
        }
        this.writeDGDV("/home/Szavislav/Eksperyment/Distortion/net-BASE+sub-DGDV.txt", DGDV);
        NetGenerator.writeDGDDA("/home/Szavislav/Eksperyment/Distortion/net-BASE+sub-DGDDA.txt", DGDV);
    }

    private SubnetCalculator.SubNet addDistortion(SubnetCalculator.SubNet sn, int position, boolean direction) {
        ArrayList<Transition> listOfTransition = new ArrayList<Transition>();
        ArrayList<Place> listOfPlace = new ArrayList<Place>();
        ArrayList<Arc> listOfArc = new ArrayList<Arc>();
        Transition t1 = new Transition(IdGenerator.getNextId(), 99, new Point(60, 30));
        Transition t2 = new Transition(IdGenerator.getNextId(), 99, new Point(60, 60));
        Transition t3 = new Transition(IdGenerator.getNextId(), 99, new Point(60, 90));
        Transition t4 = new Transition(IdGenerator.getNextId(), 99, new Point(60, 120));
        Transition t5 = new Transition(IdGenerator.getNextId(), 99, new Point(60, 150));
        Transition t6 = new Transition(IdGenerator.getNextId(), 99, new Point(60, 180));
        Transition t7 = new Transition(IdGenerator.getNextId(), 99, new Point(60, 210));
        Transition t8 = new Transition(IdGenerator.getNextId(), 99, new Point(60, 240));
        Transition t9 = new Transition(IdGenerator.getNextId(), 99, new Point(60, 270));
        Place p1 = new Place(IdGenerator.getNextId(), 99, new Point(100, 30));
        Place p2 = new Place(IdGenerator.getNextId(), 99, new Point(100, 60));
        Place p3 = new Place(IdGenerator.getNextId(), 99, new Point(100, 90));
        Place p4 = new Place(IdGenerator.getNextId(), 99, new Point(100, 120));
        Place p5 = new Place(IdGenerator.getNextId(), 99, new Point(100, 150));
        Place p6 = new Place(IdGenerator.getNextId(), 99, new Point(100, 180));
        Place p7 = new Place(IdGenerator.getNextId(), 99, new Point(100, 210));
        Place p8 = new Place(IdGenerator.getNextId(), 99, new Point(100, 270));
        t1.setComment("4L");
        t2.setComment("4L");
        t3.setComment("4L");
        t4.setComment("4L");
        t5.setComment("4L");
        t6.setComment("4L");
        t7.setComment("4L");
        t8.setComment("4L");
        t9.setComment("4L");
        p1.setComment("4L");
        p2.setComment("4L");
        p3.setComment("4L");
        p4.setComment("4L");
        p5.setComment("4L");
        p6.setComment("4L");
        p7.setComment("4L");
        p8.setComment("4L");
        Arc a1 = new Arc(t1.getElementLocations().get(0), p1.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a2 = new Arc(p1.getElementLocations().get(0), t2.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a3 = new Arc(t1.getElementLocations().get(0), p2.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a4 = new Arc(p2.getElementLocations().get(0), t3.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a5 = new Arc(t1.getElementLocations().get(0), p3.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a6 = new Arc(p3.getElementLocations().get(0), t4.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a7 = new Arc(t1.getElementLocations().get(0), p4.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a8 = new Arc(p4.getElementLocations().get(0), t5.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a9 = new Arc(t2.getElementLocations().get(0), p5.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a10 = new Arc(p5.getElementLocations().get(0), t6.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a11 = new Arc(t3.getElementLocations().get(0), p6.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a12 = new Arc(p6.getElementLocations().get(0), t7.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a13 = new Arc(t4.getElementLocations().get(0), p7.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a14 = new Arc(p7.getElementLocations().get(0), t8.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a15 = new Arc(t5.getElementLocations().get(0), p8.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a16 = new Arc(p8.getElementLocations().get(0), t9.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        listOfTransition.add(t1);
        listOfTransition.add(t2);
        listOfTransition.add(t3);
        listOfTransition.add(t4);
        listOfTransition.add(t5);
        listOfTransition.add(t6);
        listOfTransition.add(t7);
        listOfTransition.add(t8);
        listOfTransition.add(t9);
        listOfPlace.add(p1);
        listOfPlace.add(p2);
        listOfPlace.add(p3);
        listOfPlace.add(p4);
        listOfPlace.add(p5);
        listOfPlace.add(p6);
        listOfPlace.add(p7);
        listOfPlace.add(p8);
        listOfArc.add(a1);
        listOfArc.add(a2);
        listOfArc.add(a3);
        listOfArc.add(a4);
        listOfArc.add(a5);
        listOfArc.add(a6);
        listOfArc.add(a7);
        listOfArc.add(a8);
        listOfArc.add(a9);
        listOfArc.add(a10);
        listOfArc.add(a11);
        listOfArc.add(a12);
        listOfArc.add(a13);
        listOfArc.add(a14);
        listOfArc.add(a15);
        listOfArc.add(a16);
        if (direction) {
            listOfArc.add(new Arc(p1.getLastLocation(), sn.getSubTransitions().get(position).getLastLocation(), Arc.TypeOfArc.NORMAL));
        } else {
            listOfArc.add(new Arc(sn.getSubTransitions().get(position).getLastLocation(), p1.getLastLocation(), Arc.TypeOfArc.NORMAL));
        }
        listOfTransition.addAll(new ArrayList<Transition>(sn.getSubTransitions()));
        listOfPlace.addAll(new ArrayList<Place>(sn.getSubPlaces()));
        listOfArc.addAll(new ArrayList<Arc>(sn.getSubArcs()));
        return new SubnetCalculator.SubNet(listOfArc);
    }

    private SubnetCalculator.SubNet addIndependentDistortion(SubnetCalculator.SubNet sn) {
        ArrayList<Transition> listOfTransition = new ArrayList<Transition>();
        ArrayList<Place> listOfPlace = new ArrayList<Place>();
        ArrayList<Arc> listOfArc = new ArrayList<Arc>();
        Transition t1 = new Transition(IdGenerator.getNextId(), 99, new Point(60, 30));
        Transition t2 = new Transition(IdGenerator.getNextId(), 99, new Point(60, 60));
        Transition t3 = new Transition(IdGenerator.getNextId(), 99, new Point(60, 90));
        Transition t4 = new Transition(IdGenerator.getNextId(), 99, new Point(60, 120));
        Transition t5 = new Transition(IdGenerator.getNextId(), 99, new Point(60, 150));
        Transition t6 = new Transition(IdGenerator.getNextId(), 99, new Point(60, 180));
        Transition t7 = new Transition(IdGenerator.getNextId(), 99, new Point(60, 210));
        Transition t8 = new Transition(IdGenerator.getNextId(), 99, new Point(60, 240));
        Transition t9 = new Transition(IdGenerator.getNextId(), 99, new Point(60, 270));
        Place p1 = new Place(IdGenerator.getNextId(), 99, new Point(100, 30));
        Place p2 = new Place(IdGenerator.getNextId(), 99, new Point(100, 60));
        Place p3 = new Place(IdGenerator.getNextId(), 99, new Point(100, 90));
        Place p4 = new Place(IdGenerator.getNextId(), 99, new Point(100, 120));
        Place p5 = new Place(IdGenerator.getNextId(), 99, new Point(100, 150));
        Place p6 = new Place(IdGenerator.getNextId(), 99, new Point(100, 180));
        Place p7 = new Place(IdGenerator.getNextId(), 99, new Point(100, 210));
        Place p8 = new Place(IdGenerator.getNextId(), 99, new Point(100, 270));
        t1.setComment("4L");
        t2.setComment("4L");
        t3.setComment("4L");
        t4.setComment("4L");
        t5.setComment("4L");
        t6.setComment("4L");
        t7.setComment("4L");
        t8.setComment("4L");
        t9.setComment("4L");
        p1.setComment("4L");
        p2.setComment("4L");
        p3.setComment("4L");
        p4.setComment("4L");
        p5.setComment("4L");
        p6.setComment("4L");
        p7.setComment("4L");
        p8.setComment("4L");
        Arc a1 = new Arc(t1.getElementLocations().get(0), p1.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a2 = new Arc(p1.getElementLocations().get(0), t2.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a3 = new Arc(t1.getElementLocations().get(0), p2.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a4 = new Arc(p2.getElementLocations().get(0), t3.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a5 = new Arc(t1.getElementLocations().get(0), p3.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a6 = new Arc(p3.getElementLocations().get(0), t4.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a7 = new Arc(t1.getElementLocations().get(0), p4.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a8 = new Arc(p4.getElementLocations().get(0), t5.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a9 = new Arc(t2.getElementLocations().get(0), p5.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a10 = new Arc(p5.getElementLocations().get(0), t6.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a11 = new Arc(t3.getElementLocations().get(0), p6.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a12 = new Arc(p6.getElementLocations().get(0), t7.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a13 = new Arc(t4.getElementLocations().get(0), p7.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a14 = new Arc(p7.getElementLocations().get(0), t8.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a15 = new Arc(t5.getElementLocations().get(0), p8.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a16 = new Arc(p8.getElementLocations().get(0), t9.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        listOfTransition.add(t1);
        listOfTransition.add(t2);
        listOfTransition.add(t3);
        listOfTransition.add(t4);
        listOfTransition.add(t5);
        listOfTransition.add(t6);
        listOfTransition.add(t7);
        listOfTransition.add(t8);
        listOfTransition.add(t9);
        listOfPlace.add(p1);
        listOfPlace.add(p2);
        listOfPlace.add(p3);
        listOfPlace.add(p4);
        listOfPlace.add(p5);
        listOfPlace.add(p6);
        listOfPlace.add(p7);
        listOfPlace.add(p8);
        listOfArc.add(a1);
        listOfArc.add(a2);
        listOfArc.add(a3);
        listOfArc.add(a4);
        listOfArc.add(a5);
        listOfArc.add(a6);
        listOfArc.add(a7);
        listOfArc.add(a8);
        listOfArc.add(a9);
        listOfArc.add(a10);
        listOfArc.add(a11);
        listOfArc.add(a12);
        listOfArc.add(a13);
        listOfArc.add(a14);
        listOfArc.add(a15);
        listOfArc.add(a16);
        listOfTransition.addAll(new ArrayList<Transition>(sn.getSubTransitions()));
        listOfPlace.addAll(new ArrayList<Place>(sn.getSubPlaces()));
        listOfArc.addAll(new ArrayList<Arc>(sn.getSubArcs()));
        return new SubnetCalculator.SubNet(listOfArc);
    }

    public NetGenerator(int i_min, int i_max, int j_min, int j_max, int p_min, int p_max, boolean a) {
        System.out.println("P3OVARIANT");
        for (int i = i_min; i < i_max; i += 5) {
            System.out.print("i" + i);
            for (int j = j_min; j < j_max; j += 5) {
                System.out.print("j" + j);
                for (int p = p_min; p < p_max; ++p) {
                    IOprotocols io = new IOprotocols();
                    PetriNet pn = io.serverReadPNT(this.directory + "/i" + i + "j" + j + "/i" + i + "j" + j + "p" + p + "/i" + i + "j" + j + "p" + p + "-BASE.pnt", 99);
                    ArrayList<Arc> listOfArcs = pn.getArcs();
                    SubnetCalculator.SubNet sn = new SubnetCalculator.SubNet(listOfArcs);
                    SubnetCalculator.SubNet nsn = this.addParallel3One(sn);
                    io.writePNT(this.directory + "/i" + i + "j" + j + "/i" + i + "j" + j + "p" + p + "/i" + i + "j" + j + "p" + p + "-P3OVARIANT.pnt", nsn.getSubPlaces(), nsn.getSubTransitions(), nsn.getSubArcs());
                }
                System.out.println("p100");
            }
        }
    }

    public NetGenerator(int i_min, int i_max, int j_min, int j_max, int p_min, int p_max) {
        for (int i = i_min; i < i_max; i += 5) {
            for (int j = j_min; j < j_max; j += 5) {
                this.setNewDirectory("/i" + i + "j" + j);
                for (int p = p_min; p < p_max; ++p) {
                    int[] vectorOrbit;
                    SubnetCalculator.SubNet sn = this.generateNet(10 + i, 10 + j, (int)((double)(i + j + 20) * 1.3));
                    this.setNewDirectory("/i" + i + "j" + j + "/i" + i + "j" + j + "p" + p);
                    String tmpdir = this.directory + "/i" + i + "j" + j + "/i" + i + "j" + j + "p" + p + "/i" + i + "j" + j + "p" + p + "-BASE";
                    this.io.writePNT(tmpdir + ".pnt", sn.getSubPlaces(), sn.getSubTransitions(), sn.getSubArcs());
                    GraphletsCalculator.generateGraphlets();
                    ArrayList<Object> DGDV = new ArrayList<int[]>();
                    for (Node startNode : sn.getSubNode()) {
                        int[] vectorOrbit2 = GraphletsCalculator.vectorOrbit(startNode, false);
                        DGDV.add(vectorOrbit2);
                    }
                    this.writeDGDV(tmpdir + "-DGDV.txt", DGDV);
                    NetGenerator.writeDGDDA(tmpdir + "-DGDDA.txt", DGDV);
                    SubnetCalculator.SubNet nsn = this.addStar4(this.cloneSubNet(sn));
                    tmpdir = this.directory + "/i" + i + "j" + j + "/i" + i + "j" + j + "p" + p + "/i" + i + "j" + j + "p" + p + "-S4VARIANT";
                    this.io.writePNT(tmpdir + ".pnt", nsn.getSubPlaces(), nsn.getSubTransitions(), nsn.getSubArcs());
                    DGDV = new ArrayList();
                    for (Node startNode : nsn.getSubNode()) {
                        vectorOrbit = GraphletsCalculator.vectorOrbit(startNode, false);
                        DGDV.add(vectorOrbit);
                    }
                    this.writeDGDV(tmpdir + "-DGDV.txt", DGDV);
                    NetGenerator.writeDGDDA(tmpdir + "-DGDDA.txt", DGDV);
                    nsn = this.addStar4L(this.cloneSubNet(sn));
                    tmpdir = this.directory + "/i" + i + "j" + j + "/i" + i + "j" + j + "p" + p + "/i" + i + "j" + j + "p" + p + "-K4LVARIANT";
                    this.io.writePNT(tmpdir + ".pnt", nsn.getSubPlaces(), nsn.getSubTransitions(), nsn.getSubArcs());
                    DGDV = new ArrayList();
                    for (Node startNode : nsn.getSubNode()) {
                        vectorOrbit = GraphletsCalculator.vectorOrbit(startNode, false);
                        DGDV.add(vectorOrbit);
                    }
                    this.writeDGDV(tmpdir + "-DGDV.txt", DGDV);
                    NetGenerator.writeDGDDA(tmpdir + "-DGDDA.txt", DGDV);
                    nsn = this.addStar4Lk(this.cloneSubNet(sn));
                    tmpdir = this.directory + "/i" + i + "j" + j + "/i" + i + "j" + j + "p" + p + "/i" + i + "j" + j + "p" + p + "-K4LkVARIANT";
                    this.io.writePNT(tmpdir + ".pnt", nsn.getSubPlaces(), nsn.getSubTransitions(), nsn.getSubArcs());
                    DGDV = new ArrayList();
                    for (Node startNode : nsn.getSubNode()) {
                        vectorOrbit = GraphletsCalculator.vectorOrbit(startNode, false);
                        DGDV.add(vectorOrbit);
                    }
                    this.writeDGDV(tmpdir + "-DGDV.txt", DGDV);
                    NetGenerator.writeDGDDA(tmpdir + "-DGDDA.txt", DGDV);
                    nsn = this.addEight2(this.cloneSubNet(sn));
                    tmpdir = this.directory + "/i" + i + "j" + j + "/i" + i + "j" + j + "p" + p + "/i" + i + "j" + j + "p" + p + "-E2VARIANT";
                    this.io.writePNT(tmpdir + ".pnt", nsn.getSubPlaces(), nsn.getSubTransitions(), nsn.getSubArcs());
                    DGDV = new ArrayList();
                    for (Node startNode : nsn.getSubNode()) {
                        vectorOrbit = GraphletsCalculator.vectorOrbit(startNode, false);
                        DGDV.add(vectorOrbit);
                    }
                    this.writeDGDV(tmpdir + "-DGDV.txt", DGDV);
                    NetGenerator.writeDGDDA(tmpdir + "-DGDDA.txt", DGDV);
                    nsn = this.addCycle6(this.cloneSubNet(sn));
                    tmpdir = this.directory + "/i" + i + "j" + j + "/i" + i + "j" + j + "p" + p + "/i" + i + "j" + j + "p" + p + "-C6VARIANT";
                    this.io.writePNT(tmpdir + ".pnt", nsn.getSubPlaces(), nsn.getSubTransitions(), nsn.getSubArcs());
                    DGDV = new ArrayList();
                    for (Node startNode : nsn.getSubNode()) {
                        vectorOrbit = GraphletsCalculator.vectorOrbit(startNode, false);
                        DGDV.add(vectorOrbit);
                    }
                    this.writeDGDV(tmpdir + "-DGDV.txt", DGDV);
                    NetGenerator.writeDGDDA(tmpdir + "-DGDDA.txt", DGDV);
                    nsn = this.addStar4(this.cloneSubNet(sn));
                    nsn = this.addStar4(this.cloneSubNet(nsn));
                    tmpdir = this.directory + "/i" + i + "j" + j + "/i" + i + "j" + j + "p" + p + "/i" + i + "j" + j + "p" + p + "-SS4VARIANT";
                    this.io.writePNT(tmpdir + ".pnt", nsn.getSubPlaces(), nsn.getSubTransitions(), nsn.getSubArcs());
                    DGDV = new ArrayList();
                    for (Node startNode : nsn.getSubNode()) {
                        vectorOrbit = GraphletsCalculator.vectorOrbit(startNode, false);
                        DGDV.add(vectorOrbit);
                    }
                    this.writeDGDV(tmpdir + "-DGDV.txt", DGDV);
                    NetGenerator.writeDGDDA(tmpdir + "-DGDDA.txt", DGDV);
                    nsn = this.addStar4(this.cloneSubNet(sn));
                    nsn = this.addStar4(this.cloneSubNet(nsn));
                    nsn = this.addStar4(this.cloneSubNet(nsn));
                    tmpdir = this.directory + "/i" + i + "j" + j + "/i" + i + "j" + j + "p" + p + "/i" + i + "j" + j + "p" + p + "-SSS4VARIANT";
                    this.io.writePNT(tmpdir + ".pnt", nsn.getSubPlaces(), nsn.getSubTransitions(), nsn.getSubArcs());
                    DGDV = new ArrayList();
                    for (Node startNode : nsn.getSubNode()) {
                        vectorOrbit = GraphletsCalculator.vectorOrbit(startNode, false);
                        DGDV.add(vectorOrbit);
                    }
                    this.writeDGDV(tmpdir + "-DGDV.txt", DGDV);
                    NetGenerator.writeDGDDA(tmpdir + "-DGDDA.txt", DGDV);
                    nsn = this.addParallel3(this.cloneSubNet(sn));
                    tmpdir = this.directory + "/i" + i + "j" + j + "/i" + i + "j" + j + "p" + p + "/i" + i + "j" + j + "p" + p + "-P3VARIANT";
                    this.io.writePNT(tmpdir + ".pnt", nsn.getSubPlaces(), nsn.getSubTransitions(), nsn.getSubArcs());
                    DGDV = new ArrayList();
                    for (Node startNode : nsn.getSubNode()) {
                        vectorOrbit = GraphletsCalculator.vectorOrbit(startNode, false);
                        DGDV.add(vectorOrbit);
                    }
                    this.writeDGDV(tmpdir + "-DGDV.txt", DGDV);
                    NetGenerator.writeDGDDA(tmpdir + "-DGDDA.txt", DGDV);
                    nsn = this.addStar4(this.cloneSubNet(sn));
                    nsn = this.addStar4L(this.cloneSubNet(nsn));
                    nsn = this.addStar4Lk(this.cloneSubNet(nsn));
                    nsn = this.addCycle6(this.cloneSubNet(nsn));
                    nsn = this.addEight2(this.cloneSubNet(nsn));
                    nsn = this.addParallel3(this.cloneSubNet(nsn));
                    tmpdir = this.directory + "/i" + i + "j" + j + "/i" + i + "j" + j + "p" + p + "/i" + i + "j" + j + "p" + p + "-ALLVARIANT";
                    this.io.writePNT(tmpdir + ".pnt", nsn.getSubPlaces(), nsn.getSubTransitions(), nsn.getSubArcs());
                    DGDV = new ArrayList();
                    for (Node startNode : nsn.getSubNode()) {
                        vectorOrbit = GraphletsCalculator.vectorOrbit(startNode, false);
                        DGDV.add(vectorOrbit);
                    }
                    this.writeDGDV(tmpdir + "-DGDV.txt", DGDV);
                    NetGenerator.writeDGDDA(tmpdir + "-DGDDA.txt", DGDV);
                }
            }
        }
    }

    public NetGenerator(int i_min, int i_max, int j_min, int j_max, int p_min, int p_max, int md, int density) {
        for (int d = md; d < density; ++d) {
            for (int i = i_min; i < i_max; i += 5) {
                for (int j = j_min; j < j_max; j += 5) {
                    this.setNewDirectory("/d" + d + "i" + i + "j" + j);
                    for (int p = p_min; p < p_max; ++p) {
                        SubnetCalculator.SubNet sn = this.generateNet(10 + i, 10 + j, d);
                        this.setNewDirectory("/d" + d + "i" + i + "j" + j + "/d" + d + "i" + i + "j" + j + "p" + p);
                        String tmpdir = this.directory + "/d" + d + "i" + i + "j" + j + "/d" + d + "i" + i + "j" + j + "p" + p + "/d" + d + "i" + i + "j" + j + "p" + p + "-BASE";
                        this.io.writePNT(tmpdir + ".pnt", sn.getSubPlaces(), sn.getSubTransitions(), sn.getSubArcs());
                        GraphletsCalculator.generateGraphlets();
                        ArrayList<int[]> DGDV = new ArrayList<int[]>();
                        for (Node startNode : sn.getSubNode()) {
                            int[] vectorOrbit = GraphletsCalculator.vectorOrbit(startNode, false);
                            DGDV.add(vectorOrbit);
                        }
                        this.writeDGDV(tmpdir + "-DGDV.txt", DGDV);
                        NetGenerator.writeDGDDA(tmpdir + "-DGDDA.txt", DGDV);
                    }
                }
            }
        }
    }

    private void cleanNetwork(SubnetCalculator.SubNet sn) {
        for (Node n : sn.getSubNode()) {
            ArrayList<Arc> tmp = new ArrayList<Arc>(n.getNeighborsArcs());
            for (Arc arc : tmp) {
                if (sn.getSubArcs().contains(arc)) continue;
                n.getNeighborsArcs().remove(arc);
            }
        }
    }

    private SubnetCalculator.SubNet addStar4L(SubnetCalculator.SubNet sn) {
        ArrayList<Transition> listOfTransition = new ArrayList<Transition>();
        ArrayList<Place> listOfPlace = new ArrayList<Place>();
        ArrayList<Arc> listOfArc = new ArrayList<Arc>();
        Transition t1 = new Transition(IdGenerator.getNextId(), 99, new Point(60, 30));
        Transition t2 = new Transition(IdGenerator.getNextId(), 99, new Point(60, 60));
        Transition t3 = new Transition(IdGenerator.getNextId(), 99, new Point(60, 90));
        Transition t4 = new Transition(IdGenerator.getNextId(), 99, new Point(60, 120));
        Transition t5 = new Transition(IdGenerator.getNextId(), 99, new Point(60, 150));
        Transition t6 = new Transition(IdGenerator.getNextId(), 99, new Point(60, 180));
        Transition t7 = new Transition(IdGenerator.getNextId(), 99, new Point(60, 210));
        Transition t8 = new Transition(IdGenerator.getNextId(), 99, new Point(60, 240));
        Transition t9 = new Transition(IdGenerator.getNextId(), 99, new Point(60, 270));
        Place p1 = new Place(IdGenerator.getNextId(), 99, new Point(100, 30));
        Place p2 = new Place(IdGenerator.getNextId(), 99, new Point(100, 60));
        Place p3 = new Place(IdGenerator.getNextId(), 99, new Point(100, 90));
        Place p4 = new Place(IdGenerator.getNextId(), 99, new Point(100, 120));
        Place p5 = new Place(IdGenerator.getNextId(), 99, new Point(100, 150));
        Place p6 = new Place(IdGenerator.getNextId(), 99, new Point(100, 180));
        Place p7 = new Place(IdGenerator.getNextId(), 99, new Point(100, 210));
        Place p8 = new Place(IdGenerator.getNextId(), 99, new Point(100, 270));
        t1.setComment("4L");
        t2.setComment("4L");
        t3.setComment("4L");
        t4.setComment("4L");
        t5.setComment("4L");
        t6.setComment("4L");
        t7.setComment("4L");
        t8.setComment("4L");
        t9.setComment("4L");
        p1.setComment("4L");
        p2.setComment("4L");
        p3.setComment("4L");
        p4.setComment("4L");
        p5.setComment("4L");
        p6.setComment("4L");
        p7.setComment("4L");
        p8.setComment("4L");
        Arc a1 = new Arc(t1.getElementLocations().get(0), p1.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a2 = new Arc(p1.getElementLocations().get(0), t2.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a3 = new Arc(t1.getElementLocations().get(0), p2.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a4 = new Arc(p2.getElementLocations().get(0), t3.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a5 = new Arc(t1.getElementLocations().get(0), p3.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a6 = new Arc(p3.getElementLocations().get(0), t4.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a7 = new Arc(t1.getElementLocations().get(0), p4.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a8 = new Arc(p4.getElementLocations().get(0), t5.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a9 = new Arc(t2.getElementLocations().get(0), p5.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a10 = new Arc(p5.getElementLocations().get(0), t6.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a11 = new Arc(t3.getElementLocations().get(0), p6.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a12 = new Arc(p6.getElementLocations().get(0), t7.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a13 = new Arc(t4.getElementLocations().get(0), p7.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a14 = new Arc(p7.getElementLocations().get(0), t8.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a15 = new Arc(t5.getElementLocations().get(0), p8.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a16 = new Arc(p8.getElementLocations().get(0), t9.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        listOfTransition.add(t1);
        listOfTransition.add(t2);
        listOfTransition.add(t3);
        listOfTransition.add(t4);
        listOfTransition.add(t5);
        listOfTransition.add(t6);
        listOfTransition.add(t7);
        listOfTransition.add(t8);
        listOfTransition.add(t9);
        listOfPlace.add(p1);
        listOfPlace.add(p2);
        listOfPlace.add(p3);
        listOfPlace.add(p4);
        listOfPlace.add(p5);
        listOfPlace.add(p6);
        listOfPlace.add(p7);
        listOfPlace.add(p8);
        listOfArc.add(a1);
        listOfArc.add(a2);
        listOfArc.add(a3);
        listOfArc.add(a4);
        listOfArc.add(a5);
        listOfArc.add(a6);
        listOfArc.add(a7);
        listOfArc.add(a8);
        listOfArc.add(a9);
        listOfArc.add(a10);
        listOfArc.add(a11);
        listOfArc.add(a12);
        listOfArc.add(a13);
        listOfArc.add(a14);
        listOfArc.add(a15);
        listOfArc.add(a16);
        int index = this.getBaseNetTtansitionIndex(sn);
        listOfArc.add(new Arc(p1.getLastLocation(), sn.getSubTransitions().get(index).getLastLocation(), Arc.TypeOfArc.NORMAL));
        listOfTransition.addAll(new ArrayList<Transition>(sn.getSubTransitions()));
        listOfPlace.addAll(new ArrayList<Place>(sn.getSubPlaces()));
        listOfArc.addAll(new ArrayList<Arc>(sn.getSubArcs()));
        return new SubnetCalculator.SubNet(listOfArc);
    }

    private int getBaseNetTtansitionIndex(SubnetCalculator.SubNet sn) {
        ArrayList list = sn.getSubTransitions().stream().filter(x -> x.getComment().equals("")).collect(Collectors.toCollection(ArrayList::new));
        Random r = new Random();
        int randomIndex = r.nextInt(list.size() - 1);
        return sn.getSubTransitions().indexOf(list.get(randomIndex));
    }

    public SubnetCalculator.SubNet cloneSubNet(SubnetCalculator.SubNet sn) {
        int i;
        ArrayList<Place> newPlaceList = new ArrayList<Place>();
        ArrayList<Transition> newTransitionList = new ArrayList<Transition>();
        ArrayList<Arc> newArcList = new ArrayList<Arc>();
        for (i = 0; i < sn.getSubPlaces().size(); ++i) {
            newPlaceList.add(new Place(IdGenerator.getNextId(), 0, new Point(0, 0)));
        }
        for (i = 0; i < sn.getSubTransitions().size(); ++i) {
            newTransitionList.add(new Transition(IdGenerator.getNextId(), 0, new Point(0, 0)));
        }
        for (i = 0; i < sn.getSubArcs().size(); ++i) {
            if (sn.getSubArcs().get(i).getStartNode().getType().equals((Object)PetriNetElement.PetriNetElementType.PLACE)) {
                newArcList.add(new Arc(((Place)newPlaceList.get(sn.getSubPlaces().indexOf(sn.getSubArcs().get(i).getStartNode()))).getLastLocation(), ((Transition)newTransitionList.get(sn.getSubTransitions().indexOf(sn.getSubArcs().get(i).getEndNode()))).getLastLocation(), Arc.TypeOfArc.NORMAL));
                continue;
            }
            newArcList.add(new Arc(((Transition)newTransitionList.get(sn.getSubTransitions().indexOf(sn.getSubArcs().get(i).getStartNode()))).getLastLocation(), ((Place)newPlaceList.get(sn.getSubPlaces().indexOf(sn.getSubArcs().get(i).getEndNode()))).getLastLocation(), Arc.TypeOfArc.NORMAL));
        }
        return new SubnetCalculator.SubNet(newArcList);
    }

    private SubnetCalculator.SubNet addStar4Lk(SubnetCalculator.SubNet sn) {
        ArrayList<Transition> listOfTransition = new ArrayList<Transition>();
        ArrayList<Place> listOfPlace = new ArrayList<Place>();
        ArrayList<Arc> listOfArc = new ArrayList<Arc>();
        Transition t1 = new Transition(IdGenerator.getNextId(), 99, new Point(60, 30));
        Transition t2 = new Transition(IdGenerator.getNextId(), 99, new Point(60, 60));
        Transition t3 = new Transition(IdGenerator.getNextId(), 99, new Point(60, 90));
        Transition t4 = new Transition(IdGenerator.getNextId(), 99, new Point(60, 120));
        Transition t5 = new Transition(IdGenerator.getNextId(), 99, new Point(60, 150));
        Transition t6 = new Transition(IdGenerator.getNextId(), 99, new Point(60, 180));
        Transition t7 = new Transition(IdGenerator.getNextId(), 99, new Point(60, 210));
        Transition t8 = new Transition(IdGenerator.getNextId(), 99, new Point(60, 240));
        Transition t9 = new Transition(IdGenerator.getNextId(), 99, new Point(60, 270));
        Place p1 = new Place(IdGenerator.getNextId(), 99, new Point(100, 30));
        Place p2 = new Place(IdGenerator.getNextId(), 99, new Point(100, 60));
        Place p3 = new Place(IdGenerator.getNextId(), 99, new Point(100, 90));
        Place p4 = new Place(IdGenerator.getNextId(), 99, new Point(100, 120));
        Place p5 = new Place(IdGenerator.getNextId(), 99, new Point(100, 150));
        Place p6 = new Place(IdGenerator.getNextId(), 99, new Point(100, 180));
        Place p7 = new Place(IdGenerator.getNextId(), 99, new Point(100, 210));
        Place p8 = new Place(IdGenerator.getNextId(), 99, new Point(100, 270));
        Arc a1 = new Arc(t1.getElementLocations().get(0), p1.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a2 = new Arc(p1.getElementLocations().get(0), t2.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a3 = new Arc(t1.getElementLocations().get(0), p2.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a4 = new Arc(p2.getElementLocations().get(0), t3.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a5 = new Arc(t1.getElementLocations().get(0), p3.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a6 = new Arc(p3.getElementLocations().get(0), t4.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a7 = new Arc(t1.getElementLocations().get(0), p4.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a8 = new Arc(p4.getElementLocations().get(0), t5.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a9 = new Arc(t2.getElementLocations().get(0), p5.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a10 = new Arc(p5.getElementLocations().get(0), t6.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a11 = new Arc(t6.getElementLocations().get(0), p6.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a12 = new Arc(p6.getElementLocations().get(0), t7.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a13 = new Arc(t7.getElementLocations().get(0), p7.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a14 = new Arc(p7.getElementLocations().get(0), t8.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a15 = new Arc(t8.getElementLocations().get(0), p8.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a16 = new Arc(p8.getElementLocations().get(0), t9.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        t1.setComment("4Lk");
        t2.setComment("4Lk");
        t3.setComment("4Lk");
        t4.setComment("4Lk");
        t5.setComment("4Lk");
        t6.setComment("4Lk");
        t7.setComment("4Lk");
        t8.setComment("4Lk");
        t9.setComment("4Lk");
        p1.setComment("4Lk");
        p2.setComment("4Lk");
        p3.setComment("4Lk");
        p4.setComment("4Lk");
        p5.setComment("4Lk");
        p6.setComment("4Lk");
        p7.setComment("4Lk");
        p8.setComment("4Lk");
        listOfTransition.add(t1);
        listOfTransition.add(t2);
        listOfTransition.add(t3);
        listOfTransition.add(t4);
        listOfTransition.add(t5);
        listOfTransition.add(t6);
        listOfTransition.add(t7);
        listOfTransition.add(t8);
        listOfTransition.add(t9);
        listOfPlace.add(p1);
        listOfPlace.add(p2);
        listOfPlace.add(p3);
        listOfPlace.add(p4);
        listOfPlace.add(p5);
        listOfPlace.add(p6);
        listOfPlace.add(p7);
        listOfPlace.add(p8);
        listOfArc.add(a1);
        listOfArc.add(a2);
        listOfArc.add(a3);
        listOfArc.add(a4);
        listOfArc.add(a5);
        listOfArc.add(a6);
        listOfArc.add(a7);
        listOfArc.add(a8);
        listOfArc.add(a9);
        listOfArc.add(a10);
        listOfArc.add(a11);
        listOfArc.add(a12);
        listOfArc.add(a13);
        listOfArc.add(a14);
        listOfArc.add(a15);
        listOfArc.add(a16);
        int index = this.getBaseNetTtansitionIndex(sn);
        listOfArc.add(new Arc(p1.getLastLocation(), sn.getSubTransitions().get(index).getLastLocation(), Arc.TypeOfArc.NORMAL));
        listOfTransition.addAll(new ArrayList<Transition>(sn.getSubTransitions()));
        listOfPlace.addAll(new ArrayList<Place>(sn.getSubPlaces()));
        listOfArc.addAll(new ArrayList<Arc>(sn.getSubArcs()));
        return new SubnetCalculator.SubNet(listOfArc);
    }

    public SubnetCalculator.SubNet addStar4a2(SubnetCalculator.SubNet sn) {
        ArrayList<Transition> listOfTransition = new ArrayList<Transition>();
        ArrayList<Place> listOfPlace = new ArrayList<Place>();
        ArrayList<Arc> listOfArc = new ArrayList<Arc>();
        Transition t1 = new Transition(IdGenerator.getNextId(), 99, new Point(60, 30));
        Transition t2 = new Transition(IdGenerator.getNextId(), 99, new Point(60, 60));
        Transition t3 = new Transition(IdGenerator.getNextId(), 99, new Point(60, 90));
        Transition t4 = new Transition(IdGenerator.getNextId(), 99, new Point(60, 120));
        Transition t5 = new Transition(IdGenerator.getNextId(), 99, new Point(60, 150));
        Place p1 = new Place(IdGenerator.getNextId(), 99, new Point(100, 30));
        Place p2 = new Place(IdGenerator.getNextId(), 99, new Point(100, 60));
        Place p3 = new Place(IdGenerator.getNextId(), 99, new Point(100, 90));
        Place p4 = new Place(IdGenerator.getNextId(), 99, new Point(100, 120));
        Arc a1 = new Arc(t1.getElementLocations().get(0), p1.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a2 = new Arc(p1.getElementLocations().get(0), t2.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a3 = new Arc(t1.getElementLocations().get(0), p2.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a4 = new Arc(p2.getElementLocations().get(0), t3.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a5 = new Arc(t1.getElementLocations().get(0), p3.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a6 = new Arc(p3.getElementLocations().get(0), t4.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a7 = new Arc(t1.getElementLocations().get(0), p4.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a8 = new Arc(p4.getElementLocations().get(0), t5.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        t1.setComment("4");
        t2.setComment("4");
        t3.setComment("4");
        t4.setComment("4");
        t5.setComment("4");
        p1.setComment("4");
        p2.setComment("4");
        p3.setComment("4");
        p4.setComment("4");
        listOfTransition.add(t1);
        listOfTransition.add(t2);
        listOfTransition.add(t3);
        listOfTransition.add(t4);
        listOfTransition.add(t5);
        listOfPlace.add(p1);
        listOfPlace.add(p2);
        listOfPlace.add(p3);
        listOfPlace.add(p4);
        listOfArc.add(a1);
        listOfArc.add(a2);
        listOfArc.add(a3);
        listOfArc.add(a4);
        listOfArc.add(a5);
        listOfArc.add(a6);
        listOfArc.add(a7);
        listOfArc.add(a8);
        int index = this.getBaseNetTtansitionIndex(sn);
        listOfArc.add(new Arc(p1.getLastLocation(), sn.getSubTransitions().get(index).getLastLocation(), Arc.TypeOfArc.NORMAL));
        int index2 = this.getBaseNetTtansitionIndex(sn);
        listOfArc.add(new Arc(sn.getSubTransitions().get(index2).getLastLocation(), p2.getLastLocation(), Arc.TypeOfArc.NORMAL));
        listOfTransition.addAll(new ArrayList<Transition>(sn.getSubTransitions()));
        listOfPlace.addAll(new ArrayList<Place>(sn.getSubPlaces()));
        listOfArc.addAll(new ArrayList<Arc>(sn.getSubArcs()));
        return new SubnetCalculator.SubNet(listOfArc);
    }

    public SubnetCalculator.SubNet addStar4(SubnetCalculator.SubNet sn) {
        ArrayList<Transition> listOfTransition = new ArrayList<Transition>();
        ArrayList<Place> listOfPlace = new ArrayList<Place>();
        ArrayList<Arc> listOfArc = new ArrayList<Arc>();
        Transition t1 = new Transition(IdGenerator.getNextId(), 99, new Point(60, 30));
        Transition t2 = new Transition(IdGenerator.getNextId(), 99, new Point(60, 60));
        Transition t3 = new Transition(IdGenerator.getNextId(), 99, new Point(60, 90));
        Transition t4 = new Transition(IdGenerator.getNextId(), 99, new Point(60, 120));
        Transition t5 = new Transition(IdGenerator.getNextId(), 99, new Point(60, 150));
        Place p1 = new Place(IdGenerator.getNextId(), 99, new Point(100, 30));
        Place p2 = new Place(IdGenerator.getNextId(), 99, new Point(100, 60));
        Place p3 = new Place(IdGenerator.getNextId(), 99, new Point(100, 90));
        Place p4 = new Place(IdGenerator.getNextId(), 99, new Point(100, 120));
        Arc a1 = new Arc(t1.getElementLocations().get(0), p1.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a2 = new Arc(p1.getElementLocations().get(0), t2.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a3 = new Arc(t1.getElementLocations().get(0), p2.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a4 = new Arc(p2.getElementLocations().get(0), t3.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a5 = new Arc(t1.getElementLocations().get(0), p3.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a6 = new Arc(p3.getElementLocations().get(0), t4.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a7 = new Arc(t1.getElementLocations().get(0), p4.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a8 = new Arc(p4.getElementLocations().get(0), t5.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        t1.setComment("4");
        t2.setComment("4");
        t3.setComment("4");
        t4.setComment("4");
        t5.setComment("4");
        p1.setComment("4");
        p2.setComment("4");
        p3.setComment("4");
        p4.setComment("4");
        listOfTransition.add(t1);
        listOfTransition.add(t2);
        listOfTransition.add(t3);
        listOfTransition.add(t4);
        listOfTransition.add(t5);
        listOfPlace.add(p1);
        listOfPlace.add(p2);
        listOfPlace.add(p3);
        listOfPlace.add(p4);
        listOfArc.add(a1);
        listOfArc.add(a2);
        listOfArc.add(a3);
        listOfArc.add(a4);
        listOfArc.add(a5);
        listOfArc.add(a6);
        listOfArc.add(a7);
        listOfArc.add(a8);
        int index = this.getBaseNetTtansitionIndex(sn);
        listOfArc.add(new Arc(p1.getLastLocation(), sn.getSubTransitions().get(index).getLastLocation(), Arc.TypeOfArc.NORMAL));
        listOfTransition.addAll(new ArrayList<Transition>(sn.getSubTransitions()));
        listOfPlace.addAll(new ArrayList<Place>(sn.getSubPlaces()));
        listOfArc.addAll(new ArrayList<Arc>(sn.getSubArcs()));
        return new SubnetCalculator.SubNet(listOfArc);
    }

    public SubnetCalculator.SubNet addStar4sec(SubnetCalculator.SubNet sn, SubnetCalculator.SubNet old) {
        ArrayList<Transition> listOfTransition = new ArrayList<Transition>();
        ArrayList<Place> listOfPlace = new ArrayList<Place>();
        ArrayList<Arc> listOfArc = new ArrayList<Arc>();
        Transition t1 = new Transition(IdGenerator.getNextId(), 99, new Point(60, 30));
        Transition t2 = new Transition(IdGenerator.getNextId(), 99, new Point(60, 60));
        Transition t3 = new Transition(IdGenerator.getNextId(), 99, new Point(60, 90));
        Transition t4 = new Transition(IdGenerator.getNextId(), 99, new Point(60, 120));
        Transition t5 = new Transition(IdGenerator.getNextId(), 99, new Point(60, 150));
        Place p1 = new Place(IdGenerator.getNextId(), 99, new Point(100, 30));
        Place p2 = new Place(IdGenerator.getNextId(), 99, new Point(100, 60));
        Place p3 = new Place(IdGenerator.getNextId(), 99, new Point(100, 90));
        Place p4 = new Place(IdGenerator.getNextId(), 99, new Point(100, 120));
        Arc a1 = new Arc(t1.getElementLocations().get(0), p1.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a2 = new Arc(p1.getElementLocations().get(0), t2.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a3 = new Arc(t1.getElementLocations().get(0), p2.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a4 = new Arc(p2.getElementLocations().get(0), t3.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a5 = new Arc(t1.getElementLocations().get(0), p3.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a6 = new Arc(p3.getElementLocations().get(0), t4.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a7 = new Arc(t1.getElementLocations().get(0), p4.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a8 = new Arc(p4.getElementLocations().get(0), t5.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        t1.setComment("4");
        t2.setComment("4");
        t3.setComment("4");
        t4.setComment("4");
        t5.setComment("4");
        p1.setComment("4");
        p2.setComment("4");
        p3.setComment("4");
        p4.setComment("4");
        listOfTransition.add(t1);
        listOfTransition.add(t2);
        listOfTransition.add(t3);
        listOfTransition.add(t4);
        listOfTransition.add(t5);
        listOfPlace.add(p1);
        listOfPlace.add(p2);
        listOfPlace.add(p3);
        listOfPlace.add(p4);
        listOfArc.add(a1);
        listOfArc.add(a2);
        listOfArc.add(a3);
        listOfArc.add(a4);
        listOfArc.add(a5);
        listOfArc.add(a6);
        listOfArc.add(a7);
        listOfArc.add(a8);
        int index = this.getBaseNetTtansitionIndex(old);
        listOfArc.add(new Arc(p1.getLastLocation(), sn.getSubTransitions().get(index).getLastLocation(), Arc.TypeOfArc.NORMAL));
        listOfTransition.addAll(new ArrayList<Transition>(sn.getSubTransitions()));
        listOfPlace.addAll(new ArrayList<Place>(sn.getSubPlaces()));
        listOfArc.addAll(new ArrayList<Arc>(sn.getSubArcs()));
        return new SubnetCalculator.SubNet(listOfArc);
    }

    public SubnetCalculator.SubNet addStar4c2(SubnetCalculator.SubNet sn) {
        ArrayList<Transition> listOfTransition = new ArrayList<Transition>();
        ArrayList<Place> listOfPlace = new ArrayList<Place>();
        ArrayList<Arc> listOfArc = new ArrayList<Arc>();
        Transition t1 = new Transition(IdGenerator.getNextId(), 99, new Point(60, 30));
        Transition t2 = new Transition(IdGenerator.getNextId(), 99, new Point(60, 60));
        Transition t3 = new Transition(IdGenerator.getNextId(), 99, new Point(60, 90));
        Transition t4 = new Transition(IdGenerator.getNextId(), 99, new Point(60, 120));
        Transition t5 = new Transition(IdGenerator.getNextId(), 99, new Point(60, 150));
        Place p1 = new Place(IdGenerator.getNextId(), 99, new Point(100, 30));
        Place p2 = new Place(IdGenerator.getNextId(), 99, new Point(100, 60));
        Place p3 = new Place(IdGenerator.getNextId(), 99, new Point(100, 90));
        Place p4 = new Place(IdGenerator.getNextId(), 99, new Point(100, 120));
        Arc a1 = new Arc(t1.getElementLocations().get(0), p1.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a2 = new Arc(p1.getElementLocations().get(0), t2.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a3 = new Arc(t1.getElementLocations().get(0), p2.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a4 = new Arc(p2.getElementLocations().get(0), t3.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a5 = new Arc(t1.getElementLocations().get(0), p3.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a6 = new Arc(p3.getElementLocations().get(0), t4.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a7 = new Arc(t1.getElementLocations().get(0), p4.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a8 = new Arc(p4.getElementLocations().get(0), t5.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        listOfTransition.add(t1);
        listOfTransition.add(t2);
        listOfTransition.add(t3);
        listOfTransition.add(t4);
        listOfTransition.add(t5);
        listOfPlace.add(p1);
        listOfPlace.add(p2);
        listOfPlace.add(p3);
        listOfPlace.add(p4);
        listOfArc.add(a1);
        listOfArc.add(a2);
        listOfArc.add(a3);
        listOfArc.add(a4);
        listOfArc.add(a5);
        listOfArc.add(a6);
        listOfArc.add(a7);
        listOfArc.add(a8);
        int index = this.getBaseNetTtansitionIndex(sn);
        listOfArc.add(new Arc(p1.getLastLocation(), sn.getSubTransitions().get(index).getLastLocation(), Arc.TypeOfArc.NORMAL));
        int index2 = this.getBaseNetTtansitionIndex(sn);
        listOfArc.add(new Arc(sn.getSubTransitions().get(index2).getLastLocation(), p2.getLastLocation(), Arc.TypeOfArc.NORMAL));
        listOfTransition.addAll(new ArrayList<Transition>(sn.getSubTransitions()));
        listOfPlace.addAll(new ArrayList<Place>(sn.getSubPlaces()));
        listOfArc.addAll(new ArrayList<Arc>(sn.getSubArcs()));
        return new SubnetCalculator.SubNet(listOfArc);
    }

    public SubnetCalculator.SubNet addEight2(SubnetCalculator.SubNet sn) {
        ArrayList<Transition> listOfTransition = new ArrayList<Transition>();
        ArrayList<Place> listOfPlace = new ArrayList<Place>();
        ArrayList<Arc> listOfArc = new ArrayList<Arc>();
        Transition t1 = new Transition(IdGenerator.getNextId(), 99, new Point(60, 30));
        Transition t2 = new Transition(IdGenerator.getNextId(), 99, new Point(60, 60));
        Transition t3 = new Transition(IdGenerator.getNextId(), 99, new Point(60, 90));
        Place p1 = new Place(IdGenerator.getNextId(), 99, new Point(100, 30));
        Place p2 = new Place(IdGenerator.getNextId(), 99, new Point(100, 60));
        Place p3 = new Place(IdGenerator.getNextId(), 99, new Point(100, 90));
        Place p4 = new Place(IdGenerator.getNextId(), 99, new Point(100, 120));
        Arc a1 = new Arc(t1.getElementLocations().get(0), p1.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a2 = new Arc(p1.getElementLocations().get(0), t2.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a3 = new Arc(t2.getElementLocations().get(0), p2.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a4 = new Arc(p2.getElementLocations().get(0), t1.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a5 = new Arc(t1.getElementLocations().get(0), p3.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a6 = new Arc(p3.getElementLocations().get(0), t3.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a7 = new Arc(t3.getElementLocations().get(0), p4.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a8 = new Arc(p4.getElementLocations().get(0), t1.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        t1.setComment("2E");
        t2.setComment("2E");
        t3.setComment("2E");
        p1.setComment("2E");
        p2.setComment("2E");
        p3.setComment("2E");
        p4.setComment("2E");
        listOfTransition.add(t1);
        listOfTransition.add(t2);
        listOfTransition.add(t3);
        listOfPlace.add(p1);
        listOfPlace.add(p2);
        listOfPlace.add(p3);
        listOfPlace.add(p4);
        listOfArc.add(a1);
        listOfArc.add(a2);
        listOfArc.add(a3);
        listOfArc.add(a4);
        listOfArc.add(a5);
        listOfArc.add(a6);
        listOfArc.add(a7);
        listOfArc.add(a8);
        int index = this.getBaseNetTtansitionIndex(sn);
        listOfArc.add(new Arc(p1.getLastLocation(), sn.getSubTransitions().get(index).getLastLocation(), Arc.TypeOfArc.NORMAL));
        listOfTransition.addAll(new ArrayList<Transition>(sn.getSubTransitions()));
        listOfPlace.addAll(new ArrayList<Place>(sn.getSubPlaces()));
        listOfArc.addAll(new ArrayList<Arc>(sn.getSubArcs()));
        return new SubnetCalculator.SubNet(listOfArc);
    }

    public SubnetCalculator.SubNet addEight2c2(SubnetCalculator.SubNet sn) {
        ArrayList<Transition> listOfTransition = new ArrayList<Transition>();
        ArrayList<Place> listOfPlace = new ArrayList<Place>();
        ArrayList<Arc> listOfArc = new ArrayList<Arc>();
        Transition t1 = new Transition(IdGenerator.getNextId(), 99, new Point(60, 30));
        Transition t2 = new Transition(IdGenerator.getNextId(), 99, new Point(60, 60));
        Transition t3 = new Transition(IdGenerator.getNextId(), 99, new Point(60, 90));
        Place p1 = new Place(IdGenerator.getNextId(), 99, new Point(100, 30));
        Place p2 = new Place(IdGenerator.getNextId(), 99, new Point(100, 60));
        Place p3 = new Place(IdGenerator.getNextId(), 99, new Point(100, 90));
        Place p4 = new Place(IdGenerator.getNextId(), 99, new Point(100, 120));
        Arc a1 = new Arc(t1.getElementLocations().get(0), p1.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a2 = new Arc(p1.getElementLocations().get(0), t2.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a3 = new Arc(t2.getElementLocations().get(0), p2.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a4 = new Arc(p2.getElementLocations().get(0), t1.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a5 = new Arc(t1.getElementLocations().get(0), p3.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a6 = new Arc(p3.getElementLocations().get(0), t3.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a7 = new Arc(t3.getElementLocations().get(0), p4.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a8 = new Arc(p4.getElementLocations().get(0), t1.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        listOfTransition.add(t1);
        listOfTransition.add(t2);
        listOfTransition.add(t3);
        listOfPlace.add(p1);
        listOfPlace.add(p2);
        listOfPlace.add(p3);
        listOfPlace.add(p4);
        listOfArc.add(a1);
        listOfArc.add(a2);
        listOfArc.add(a3);
        listOfArc.add(a4);
        listOfArc.add(a5);
        listOfArc.add(a6);
        listOfArc.add(a7);
        listOfArc.add(a8);
        listOfArc.add(new Arc(p1.getLastLocation(), sn.getSubTransitions().get(0).getLastLocation(), Arc.TypeOfArc.NORMAL));
        listOfArc.add(new Arc(sn.getSubTransitions().get(sn.getSubTransitions().size() - 1).getLastLocation(), p2.getLastLocation(), Arc.TypeOfArc.NORMAL));
        listOfTransition.addAll(new ArrayList<Transition>(sn.getSubTransitions()));
        listOfPlace.addAll(new ArrayList<Place>(sn.getSubPlaces()));
        listOfArc.addAll(new ArrayList<Arc>(sn.getSubArcs()));
        return new SubnetCalculator.SubNet(listOfArc);
    }

    public SubnetCalculator.SubNet addCycle6(SubnetCalculator.SubNet sn) {
        ArrayList<Transition> listOfTransition = new ArrayList<Transition>();
        ArrayList<Place> listOfPlace = new ArrayList<Place>();
        ArrayList<Arc> listOfArc = new ArrayList<Arc>();
        Transition t1 = new Transition(IdGenerator.getNextId(), 99, new Point(60, 30));
        Transition t2 = new Transition(IdGenerator.getNextId(), 99, new Point(60, 60));
        Transition t3 = new Transition(IdGenerator.getNextId(), 99, new Point(60, 90));
        Transition t4 = new Transition(IdGenerator.getNextId(), 99, new Point(60, 120));
        Transition t5 = new Transition(IdGenerator.getNextId(), 99, new Point(60, 150));
        Place p1 = new Place(IdGenerator.getNextId(), 99, new Point(100, 30));
        Place p2 = new Place(IdGenerator.getNextId(), 99, new Point(100, 60));
        Place p3 = new Place(IdGenerator.getNextId(), 99, new Point(100, 90));
        Place p4 = new Place(IdGenerator.getNextId(), 99, new Point(100, 120));
        Place p5 = new Place(IdGenerator.getNextId(), 99, new Point(100, 150));
        Arc a1 = new Arc(t1.getElementLocations().get(0), p1.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a2 = new Arc(p1.getElementLocations().get(0), t2.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a3 = new Arc(t2.getElementLocations().get(0), p2.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a4 = new Arc(p2.getElementLocations().get(0), t3.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a5 = new Arc(t3.getElementLocations().get(0), p3.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a6 = new Arc(p3.getElementLocations().get(0), t4.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a7 = new Arc(t4.getElementLocations().get(0), p4.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a8 = new Arc(p4.getElementLocations().get(0), t5.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a9 = new Arc(t5.getElementLocations().get(0), p5.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a10 = new Arc(p5.getElementLocations().get(0), t1.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        t1.setComment("6C");
        t2.setComment("6C");
        t3.setComment("6C");
        t4.setComment("6C");
        t5.setComment("6C");
        p1.setComment("6C");
        p2.setComment("6C");
        p3.setComment("6C");
        p4.setComment("6C");
        p5.setComment("6C");
        listOfTransition.add(t1);
        listOfTransition.add(t2);
        listOfTransition.add(t3);
        listOfTransition.add(t4);
        listOfTransition.add(t5);
        listOfPlace.add(p1);
        listOfPlace.add(p2);
        listOfPlace.add(p3);
        listOfPlace.add(p4);
        listOfPlace.add(p5);
        listOfArc.add(a1);
        listOfArc.add(a2);
        listOfArc.add(a3);
        listOfArc.add(a4);
        listOfArc.add(a5);
        listOfArc.add(a6);
        listOfArc.add(a7);
        listOfArc.add(a8);
        listOfArc.add(a9);
        listOfArc.add(a10);
        int index = this.getBaseNetTtansitionIndex(sn);
        listOfArc.add(new Arc(p1.getLastLocation(), sn.getSubTransitions().get(index).getLastLocation(), Arc.TypeOfArc.NORMAL));
        listOfTransition.addAll(new ArrayList<Transition>(sn.getSubTransitions()));
        listOfPlace.addAll(new ArrayList<Place>(sn.getSubPlaces()));
        listOfArc.addAll(new ArrayList<Arc>(sn.getSubArcs()));
        return new SubnetCalculator.SubNet(listOfArc);
    }

    public SubnetCalculator.SubNet addParallel3(SubnetCalculator.SubNet sn) {
        ArrayList<Transition> listOfTransition = new ArrayList<Transition>();
        ArrayList<Place> listOfPlace = new ArrayList<Place>();
        ArrayList<Arc> listOfArc = new ArrayList<Arc>();
        Transition t1 = new Transition(IdGenerator.getNextId(), 99, new Point(60, 30));
        Transition t2 = new Transition(IdGenerator.getNextId(), 99, new Point(60, 60));
        Place p1 = new Place(IdGenerator.getNextId(), 99, new Point(100, 30));
        Place p2 = new Place(IdGenerator.getNextId(), 99, new Point(100, 60));
        Place p3 = new Place(IdGenerator.getNextId(), 99, new Point(100, 90));
        Arc a1 = new Arc(t1.getElementLocations().get(0), p1.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a2 = new Arc(p1.getElementLocations().get(0), t2.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a3 = new Arc(t1.getElementLocations().get(0), p2.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a4 = new Arc(p2.getElementLocations().get(0), t2.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a5 = new Arc(t2.getElementLocations().get(0), p3.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a6 = new Arc(p3.getElementLocations().get(0), t1.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        t1.setComment("3P");
        t2.setComment("3P");
        p1.setComment("3P");
        p2.setComment("3P");
        p3.setComment("3P");
        listOfTransition.add(t1);
        listOfTransition.add(t2);
        listOfPlace.add(p1);
        listOfPlace.add(p2);
        listOfPlace.add(p3);
        listOfArc.add(a1);
        listOfArc.add(a2);
        listOfArc.add(a3);
        listOfArc.add(a4);
        listOfArc.add(a5);
        listOfArc.add(a6);
        int index = this.getBaseNetTtansitionIndex(sn);
        listOfArc.add(new Arc(p1.getLastLocation(), sn.getSubTransitions().get(index).getLastLocation(), Arc.TypeOfArc.NORMAL));
        int index2 = this.getBaseNetTtansitionIndex(sn);
        listOfArc.add(new Arc(sn.getSubTransitions().get(index2).getLastLocation(), p2.getLastLocation(), Arc.TypeOfArc.NORMAL));
        listOfTransition.addAll(new ArrayList<Transition>(sn.getSubTransitions()));
        listOfPlace.addAll(new ArrayList<Place>(sn.getSubPlaces()));
        listOfArc.addAll(new ArrayList<Arc>(sn.getSubArcs()));
        return new SubnetCalculator.SubNet(listOfArc);
    }

    public SubnetCalculator.SubNet addParallel3One(SubnetCalculator.SubNet sn) {
        ArrayList<Transition> listOfTransition = new ArrayList<Transition>();
        ArrayList<Place> listOfPlace = new ArrayList<Place>();
        ArrayList<Arc> listOfArc = new ArrayList<Arc>();
        Transition t1 = new Transition(IdGenerator.getNextId(), 99, new Point(60, 30));
        Transition t2 = new Transition(IdGenerator.getNextId(), 99, new Point(60, 60));
        Place p1 = new Place(IdGenerator.getNextId(), 99, new Point(100, 30));
        Place p2 = new Place(IdGenerator.getNextId(), 99, new Point(100, 60));
        Place p3 = new Place(IdGenerator.getNextId(), 99, new Point(100, 90));
        Arc a1 = new Arc(t1.getElementLocations().get(0), p1.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a2 = new Arc(p1.getElementLocations().get(0), t2.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a3 = new Arc(t1.getElementLocations().get(0), p2.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a4 = new Arc(p2.getElementLocations().get(0), t2.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a5 = new Arc(t2.getElementLocations().get(0), p3.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a6 = new Arc(p3.getElementLocations().get(0), t1.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        t1.setComment("3P");
        t2.setComment("3P");
        p1.setComment("3P");
        p2.setComment("3P");
        p3.setComment("3P");
        listOfTransition.add(t1);
        listOfTransition.add(t2);
        listOfPlace.add(p1);
        listOfPlace.add(p2);
        listOfPlace.add(p3);
        listOfArc.add(a1);
        listOfArc.add(a2);
        listOfArc.add(a3);
        listOfArc.add(a4);
        listOfArc.add(a5);
        listOfArc.add(a6);
        int index2 = this.getBaseNetTtansitionIndex(sn);
        listOfArc.add(new Arc(sn.getSubTransitions().get(index2).getLastLocation(), p2.getLastLocation(), Arc.TypeOfArc.NORMAL));
        listOfTransition.addAll(new ArrayList<Transition>(sn.getSubTransitions()));
        listOfPlace.addAll(new ArrayList<Place>(sn.getSubPlaces()));
        listOfArc.addAll(new ArrayList<Arc>(sn.getSubArcs()));
        return new SubnetCalculator.SubNet(listOfArc);
    }

    public SubnetCalculator.SubNet addCycle6c2(SubnetCalculator.SubNet sn) {
        ArrayList<Transition> listOfTransition = new ArrayList<Transition>();
        ArrayList<Place> listOfPlace = new ArrayList<Place>();
        ArrayList<Arc> listOfArc = new ArrayList<Arc>();
        Transition t1 = new Transition(IdGenerator.getNextId(), 99, new Point(60, 30));
        Transition t2 = new Transition(IdGenerator.getNextId(), 99, new Point(60, 60));
        Transition t3 = new Transition(IdGenerator.getNextId(), 99, new Point(60, 90));
        Transition t4 = new Transition(IdGenerator.getNextId(), 99, new Point(60, 120));
        Transition t5 = new Transition(IdGenerator.getNextId(), 99, new Point(60, 150));
        Place p1 = new Place(IdGenerator.getNextId(), 99, new Point(100, 30));
        Place p2 = new Place(IdGenerator.getNextId(), 99, new Point(100, 60));
        Place p3 = new Place(IdGenerator.getNextId(), 99, new Point(100, 90));
        Place p4 = new Place(IdGenerator.getNextId(), 99, new Point(100, 120));
        Place p5 = new Place(IdGenerator.getNextId(), 99, new Point(100, 150));
        Arc a1 = new Arc(t1.getElementLocations().get(0), p1.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a2 = new Arc(p1.getElementLocations().get(0), t2.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a3 = new Arc(t2.getElementLocations().get(0), p2.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a4 = new Arc(p2.getElementLocations().get(0), t3.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a5 = new Arc(t3.getElementLocations().get(0), p3.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a6 = new Arc(p3.getElementLocations().get(0), t4.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a7 = new Arc(t4.getElementLocations().get(0), p4.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a8 = new Arc(p4.getElementLocations().get(0), t5.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a9 = new Arc(t5.getElementLocations().get(0), p5.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        Arc a10 = new Arc(p5.getElementLocations().get(0), t1.getElementLocations().get(0), Arc.TypeOfArc.NORMAL);
        listOfTransition.add(t1);
        listOfTransition.add(t2);
        listOfTransition.add(t3);
        listOfTransition.add(t4);
        listOfTransition.add(t5);
        listOfPlace.add(p1);
        listOfPlace.add(p2);
        listOfPlace.add(p3);
        listOfPlace.add(p4);
        listOfPlace.add(p5);
        listOfArc.add(a1);
        listOfArc.add(a2);
        listOfArc.add(a3);
        listOfArc.add(a4);
        listOfArc.add(a5);
        listOfArc.add(a6);
        listOfArc.add(a7);
        listOfArc.add(a8);
        listOfArc.add(a9);
        listOfArc.add(a10);
        listOfArc.add(new Arc(p1.getLastLocation(), sn.getSubTransitions().get(0).getLastLocation(), Arc.TypeOfArc.NORMAL));
        listOfArc.add(new Arc(sn.getSubTransitions().get(sn.getSubTransitions().size() - 1).getLastLocation(), p2.getLastLocation(), Arc.TypeOfArc.NORMAL));
        listOfTransition.addAll(new ArrayList<Transition>(sn.getSubTransitions()));
        listOfPlace.addAll(new ArrayList<Place>(sn.getSubPlaces()));
        listOfArc.addAll(new ArrayList<Arc>(sn.getSubArcs()));
        return new SubnetCalculator.SubNet(listOfArc);
    }

    public static void writeDGDDA(String directory, ArrayList<int[]> DGDV) {
        FileWriter fileWriter;
        File file = new File(directory);
        try {
            FileWriter fileWriter2 = new FileWriter(file, true);
            fileWriter2.write("-d\r\n");
            fileWriter2.flush();
            fileWriter2.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int max = 0;
        for (int[] ints : DGDV) {
            int localMax = Arrays.stream(ints).max().getAsInt();
            if (localMax <= max) continue;
            max = localMax;
        }
        int orbitNumber = DGDV.get(0).length;
        int[][] d = new int[orbitNumber][max + 1];
        for (int[] ints : DGDV) {
            for (int m = 0; m < ints.length; ++m) {
                if (ints[m] <= 0) continue;
                int[] nArray = d[m];
                int n = ints[m];
                nArray[n] = nArray[n] + 1;
            }
        }
        for (Object ints : (Object)d) {
            try {
                FileWriter fileWriter3 = new FileWriter(file, true);
                fileWriter3.write(Arrays.toString((int[])ints) + "\r\n");
                fileWriter3.flush();
                fileWriter3.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            FileWriter fileWriter4 = new FileWriter(file, true);
            fileWriter4.write("-s\r\n");
            fileWriter4.flush();
            fileWriter4.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        double[][] s = new double[d.length][d[0].length];
        for (int orb = 0; orb < d.length; ++orb) {
            try {
                FileWriter fileWriter5 = new FileWriter(file, true);
                double[] ss = new double[d[orb].length];
                for (int k = 1; k < d[orb].length; ++k) {
                    double dd = d[orb][k];
                    ss[k] = dd / (double)k;
                    s[orb] = ss;
                }
                fileWriter5.write(Arrays.toString(ss) + "\r\n");
                fileWriter5.flush();
                fileWriter5.close();
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            FileWriter fileWriter6 = new FileWriter(file, true);
            fileWriter6.write("-t\r\n");
            fileWriter6.flush();
            fileWriter6.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        double[] t = new double[d.length];
        for (int orb = 0; orb < d.length; ++orb) {
            t[orb] = DoubleStream.of(s[orb]).sum();
        }
        try {
            fileWriter = new FileWriter(file, true);
            fileWriter.write(Arrays.toString(t) + "\r\n");
            fileWriter.flush();
            fileWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            fileWriter = new FileWriter(file, true);
            fileWriter.write("-n\r\n");
            fileWriter.flush();
            fileWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        double[][] n = new double[d.length][d[0].length];
        for (int orb = 0; orb < n.length; ++orb) {
            for (int k = 0; k < n[orb].length; ++k) {
                n[orb][k] = s[orb][k] / t[orb];
            }
            try {
                FileWriter fileWriter7 = new FileWriter(file, true);
                fileWriter7.write(Arrays.toString(n[orb]) + "\r\n");
                fileWriter7.flush();
                fileWriter7.close();
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void writeDGDV(String directory, ArrayList<int[]> DGDV) {
        File file = new File(directory);
        for (int[] ints : DGDV) {
            try {
                FileWriter fileWriter = new FileWriter(file, true);
                fileWriter.write(Arrays.toString(ints) + "\r\n");
                fileWriter.flush();
                fileWriter.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public SubnetCalculator.SubNet generateNet(int place_number, int transition_number, int arc_number) {
        if (place_number + transition_number - 1 <= arc_number) {
            Arc newArc;
            int index;
            ArrayList toChoose;
            Arc newArc2;
            int place_index = 0;
            int transition_index = 0;
            int arc_index = 0;
            ArrayList<Object> listOfPlaces = new ArrayList<Object>();
            ArrayList<Transition> listOfTransitions = new ArrayList<Transition>();
            ArrayList<Arc> listOfArcs = new ArrayList<Arc>();
            boolean isNewPlace = false;
            boolean isNewTransition = false;
            boolean switcher = false;
            Place start_place = new Place(IdGenerator.getNextId(), 0, new Point(this.x_p, this.y_p));
            Transition start_transition = new Transition(IdGenerator.getNextId(), 0, new Point(this.x_t, this.y_t));
            Arc first_arc = new Arc(start_place.getLastLocation(), start_transition.getLastLocation(), Arc.TypeOfArc.NORMAL);
            this.y_p += 30;
            this.y_t += 30;
            listOfPlaces.add(start_place);
            listOfTransitions.add(start_transition);
            listOfArcs.add(first_arc);
            ++place_index;
            ++transition_index;
            Random r = new Random();
            while (place_index < place_number || transition_index < transition_number) {
                Arc newArc3;
                void var18_19;
                Object new_place = null;
                isNewPlace = false;
                isNewTransition = false;
                Object var18_20 = null;
                if (place_index < place_number) {
                    new_place = new Place(IdGenerator.getNextId(), 0, new Point(this.x_p, this.y_p));
                    this.y_p += 30;
                    ++place_index;
                    listOfPlaces.add(new_place);
                    isNewPlace = true;
                }
                if (transition_index < transition_number) {
                    Transition transition = new Transition(IdGenerator.getNextId(), 0, new Point(this.x_t, this.y_t));
                    this.y_t += 30;
                    ++transition_index;
                    listOfTransitions.add(transition);
                    isNewTransition = true;
                }
                if (var18_19 == null) {
                    switcher = true;
                }
                if (new_place == null) {
                    switcher = false;
                }
                if (!isNewPlace && !isNewTransition) continue;
                if (isNewPlace) {
                    int index2 = r.nextInt(listOfTransitions.size());
                    if (var18_19 != null && ((Transition)listOfTransitions.get(index2)).getID() == var18_19.getID()) {
                        --index2;
                    }
                    if (r.nextBoolean()) {
                        Arc newArc32 = new Arc(((Node)new_place).getLastLocation(), ((Transition)listOfTransitions.get(index2)).getLastLocation(), Arc.TypeOfArc.NORMAL);
                        listOfArcs.add(newArc32);
                        switcher = false;
                    } else {
                        newArc3 = new Arc(((Transition)listOfTransitions.get(index2)).getLastLocation(), ((Node)new_place).getLastLocation(), Arc.TypeOfArc.NORMAL);
                        listOfArcs.add(newArc3);
                        switcher = false;
                    }
                    ++arc_index;
                }
                if (!isNewTransition) continue;
                int index2 = r.nextInt(listOfPlaces.size());
                if (new_place != null && ((Place)listOfPlaces.get(index2)).getID() == ((PetriNetElement)new_place).getID()) {
                    --index2;
                }
                if (r.nextBoolean()) {
                    newArc3 = new Arc(var18_19.getLastLocation(), ((Place)listOfPlaces.get(index2)).getLastLocation(), Arc.TypeOfArc.NORMAL);
                    listOfArcs.add(newArc3);
                    switcher = true;
                } else {
                    newArc3 = new Arc(((Place)listOfPlaces.get(index2)).getLastLocation(), var18_19.getLastLocation(), Arc.TypeOfArc.NORMAL);
                    listOfArcs.add(newArc3);
                    switcher = true;
                }
                ++arc_index;
            }
            for (Place place : listOfPlaces) {
                if (place.getInputArcs().size() == 0) {
                    ArrayList toChoose2 = new ArrayList(listOfTransitions);
                    toChoose2.removeAll(place.getOutputNodes());
                    int index3 = r.nextInt(toChoose2.size());
                    Arc newArc22 = new Arc(((Transition)toChoose2.get(index3)).getLastLocation(), place.getLastLocation(), Arc.TypeOfArc.NORMAL);
                    listOfArcs.add(newArc22);
                    ++arc_index;
                    continue;
                }
                if (place.getOutputArcs().size() != 0) continue;
                ArrayList toChoose2 = new ArrayList(listOfTransitions);
                toChoose2.removeAll(place.getInputNodes());
                int index3 = r.nextInt(toChoose2.size());
                newArc2 = new Arc(place.getLastLocation(), ((Transition)toChoose2.get(index3)).getLastLocation(), Arc.TypeOfArc.NORMAL);
                listOfArcs.add(newArc2);
                ++arc_index;
            }
            boolean sinkTRansition = listOfPlaces.stream().anyMatch(x -> x.getType().equals((Object)PetriNetElement.PetriNetElementType.TRANSITION) && x.getOutputArcs().size() == 0);
            boolean bl = listOfPlaces.stream().anyMatch(x -> x.getType().equals((Object)PetriNetElement.PetriNetElementType.TRANSITION) && x.getInputArcs().size() == 0);
            if (sinkTRansition && !bl) {
                ArrayList listToModify = listOfPlaces.stream().filter(x -> x.getType().equals((Object)PetriNetElement.PetriNetElementType.TRANSITION) && x.getOutputArcs().size() == 0).collect(Collectors.toCollection(ArrayList::new));
                for (Node n : listToModify) {
                    toChoose = new ArrayList(listOfPlaces);
                    toChoose.removeAll(n.getOutputNodes());
                    index = r.nextInt(toChoose.size());
                    newArc = new Arc(n.getLastLocation(), ((Place)toChoose.get(index)).getLastLocation(), Arc.TypeOfArc.NORMAL);
                    listOfArcs.add(newArc);
                    ++arc_index;
                }
            }
            if (!sinkTRansition && bl) {
                ArrayList listToModify = listOfPlaces.stream().filter(x -> x.getType().equals((Object)PetriNetElement.PetriNetElementType.TRANSITION) && x.getInputArcs().size() == 0).collect(Collectors.toCollection(ArrayList::new));
                for (Node n : listToModify) {
                    toChoose = new ArrayList(listOfPlaces);
                    toChoose.removeAll(n.getOutputNodes());
                    index = r.nextInt(toChoose.size());
                    newArc = new Arc(((Place)toChoose.get(index)).getLastLocation(), n.getLastLocation(), Arc.TypeOfArc.NORMAL);
                    listOfArcs.add(newArc);
                    ++arc_index;
                }
            }
            while (arc_index < arc_number) {
                Optional<Arc> arcToGainWeigjt;
                int indexOfPlace = r.nextInt(listOfPlaces.size());
                int indexOfTransition = r.nextInt(listOfTransitions.size());
                if (r.nextBoolean()) {
                    if (listOfArcs.stream().anyMatch(x -> x.getStartNode().getID() == ((Place)listOfPlaces.get(indexOfPlace)).getID() && x.getEndNode().getID() == ((Transition)listOfTransitions.get(indexOfTransition)).getID())) {
                        if (this.conservative) continue;
                        arcToGainWeigjt = listOfArcs.stream().filter(x -> x.getStartNode().getID() == ((Place)listOfPlaces.get(indexOfPlace)).getID() && x.getEndNode().getID() == ((Transition)listOfTransitions.get(indexOfTransition)).getID()).findFirst();
                        arcToGainWeigjt.get().setWeight(arcToGainWeigjt.get().getWeight() + 1);
                        ++arc_index;
                        continue;
                    }
                    if (listOfArcs.stream().anyMatch(x -> x.getEndNode().getID() == ((Place)listOfPlaces.get(indexOfPlace)).getID() && x.getStartNode().getID() == ((Transition)listOfTransitions.get(indexOfTransition)).getID())) continue;
                    newArc2 = new Arc(((Place)listOfPlaces.get(indexOfPlace)).getLastLocation(), ((Transition)listOfTransitions.get(indexOfTransition)).getLastLocation(), Arc.TypeOfArc.NORMAL);
                    listOfArcs.add(newArc2);
                    ++arc_index;
                    continue;
                }
                if (listOfArcs.stream().anyMatch(x -> x.getEndNode().getID() == ((Place)listOfPlaces.get(indexOfPlace)).getID() && x.getStartNode().getID() == ((Transition)listOfTransitions.get(indexOfTransition)).getID())) {
                    if (this.conservative) continue;
                    arcToGainWeigjt = listOfArcs.stream().filter(x -> x.getEndNode().getID() == ((Place)listOfPlaces.get(indexOfPlace)).getID() && x.getStartNode().getID() == ((Transition)listOfTransitions.get(indexOfTransition)).getID()).findFirst();
                    arcToGainWeigjt.get().setWeight(arcToGainWeigjt.get().getWeight() + 1);
                    ++arc_index;
                    continue;
                }
                if (listOfArcs.stream().anyMatch(x -> x.getStartNode().getID() == ((Place)listOfPlaces.get(indexOfPlace)).getID() && x.getEndNode().getID() == ((Transition)listOfTransitions.get(indexOfTransition)).getID())) continue;
                newArc2 = new Arc(((Transition)listOfTransitions.get(indexOfTransition)).getLastLocation(), ((Place)listOfPlaces.get(indexOfPlace)).getLastLocation(), Arc.TypeOfArc.NORMAL);
                listOfArcs.add(newArc2);
                ++arc_index;
            }
            return new SubnetCalculator.SubNet(listOfArcs);
        }
        JOptionPane.showMessageDialog(GUIManager.getDefaultGUIManager(), "Za ma\u0142o \u0142uk\u00f3w aby stworzy\u0107 sp\u00f3jny graf - p: " + place_number + " t:" + transition_number + " a:" + arc_number, "Error", 0);
        return null;
    }
}

