/*
 * Decompiled with CFR 0.152.
 */
package holmes.analyse.comparison;

import holmes.analyse.SubnetCalculator;
import holmes.analyse.comparison.structures.BranchBasedSubnet;
import holmes.analyse.comparison.structures.GreatCommonSubnet;
import holmes.darkgui.GUIManager;
import holmes.files.io.IOprotocols;
import holmes.petrinet.data.IdGenerator;
import holmes.petrinet.elements.Arc;
import holmes.petrinet.elements.ElementLocation;
import holmes.petrinet.elements.Node;
import holmes.petrinet.elements.PetriNetElement;
import holmes.petrinet.elements.Place;
import holmes.petrinet.elements.Transition;
import java.awt.Point;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;

public class SubnetComparator {
    ArrayList<BranchBasedSubnet> subnetsForFirstNet = new ArrayList();
    ArrayList<BranchBasedSubnet> subnetsForSecondNet = new ArrayList();
    int[][] founded;
    public boolean firstQuestion = false;
    public boolean secondQuestion = false;
    public boolean thirdQuestion = false;
    public boolean allNotMax = false;
    HashMap<Node, Node> listOfMapedFunctionalPlaces = new HashMap();
    private static ArrayList<ArrayList<Integer>> allFunBranchpermutations = new ArrayList();

    public SubnetComparator(ArrayList<SubnetCalculator.SubNet> firstNetList, ArrayList<SubnetCalculator.SubNet> secondNetList) {
        for (SubnetCalculator.SubNet sn : firstNetList) {
            this.subnetsForFirstNet.add(this.transformSubnet(sn));
        }
        for (SubnetCalculator.SubNet sn : secondNetList) {
            this.subnetsForSecondNet.add(this.transformSubnet(sn));
        }
    }

    public SubnetComparator(SubnetCalculator.SubNet firstNetList, SubnetCalculator.SubNet secondNetList) {
        this.subnetsForFirstNet.add(this.transformSubnet(firstNetList));
        this.subnetsForSecondNet.add(this.transformSubnet(secondNetList));
    }

    public SubnetComparator(SubnetCalculator.SubNet firstNetList, SubnetCalculator.SubNet secondNetList, boolean fq, boolean sq, boolean tq) {
        this.subnetsForFirstNet.add(this.transformSubnet(firstNetList));
        this.subnetsForSecondNet.add(this.transformSubnet(secondNetList));
        this.firstQuestion = fq;
        this.secondQuestion = sq;
        this.thirdQuestion = tq;
    }

    public SubnetComparator(ArrayList<SubnetCalculator.SubNet> firstNetList, ArrayList<SubnetCalculator.SubNet> secondNetList, boolean fq, boolean sq, boolean tq) {
        for (SubnetCalculator.SubNet sn : firstNetList) {
            this.subnetsForFirstNet.add(this.transformSubnet(sn));
        }
        for (SubnetCalculator.SubNet sn : secondNetList) {
            this.subnetsForSecondNet.add(this.transformSubnet(sn));
        }
        this.firstQuestion = fq;
        this.secondQuestion = sq;
        this.thirdQuestion = tq;
    }

    public ArrayList<ArrayList<GreatCommonSubnet>> compare() {
        boolean testy = false;
        ArrayList<ArrayList<GreatCommonSubnet>> resultMatrix = new ArrayList<ArrayList<GreatCommonSubnet>>();
        if (testy) {
            GreatCommonSubnet greatCommonSubnet = this.compareTwoSubnets(this.subnetsForFirstNet.get(0), this.subnetsForSecondNet.get(1));
        } else {
            for (int i = 0; i < this.subnetsForFirstNet.size(); ++i) {
                ArrayList<GreatCommonSubnet> list = new ArrayList<GreatCommonSubnet>();
                for (int j = 0; j < this.subnetsForSecondNet.size(); ++j) {
                    System.out.println("Por\u00f3wnywanie sieci nr: " + i + " z sieci\u00e6 : " + j);
                    if (i == 4 && j == 4) {
                        System.out.println("stop");
                    }
                    list.add(this.compareTwoSubnets(this.subnetsForFirstNet.get(i), this.subnetsForSecondNet.get(j)));
                    ((GreatCommonSubnet)list.get((int)j)).firstNetID = i;
                    ((GreatCommonSubnet)list.get((int)j)).secondNetID = j;
                    ((GreatCommonSubnet)list.get((int)j)).firstNetNodeSize = this.subnetsForFirstNet.get((int)i).nodes.size();
                    ((GreatCommonSubnet)list.get((int)j)).secondNetNodeSize = this.subnetsForSecondNet.get((int)j).nodes.size();
                }
                resultMatrix.add(list);
            }
        }
        return resultMatrix;
    }

    public ArrayList<ArrayList<GreatCommonSubnet>> compareInternalFirst() {
        ArrayList<ArrayList<GreatCommonSubnet>> resultMatrix = new ArrayList<ArrayList<GreatCommonSubnet>>();
        for (int i = 0; i < this.subnetsForFirstNet.size(); ++i) {
            ArrayList<GreatCommonSubnet> list = new ArrayList<GreatCommonSubnet>();
            for (int j = 0; j < this.subnetsForFirstNet.size(); ++j) {
                if (GUIManager.getDefaultGUIManager().accessComparisonWindow().decoType.getSelectedIndex() == 1) {
                    list.add(this.compareTwoSubnets(this.subnetsForFirstNet.get(i), this.subnetsForFirstNet.get(j)));
                }
                if (GUIManager.getDefaultGUIManager().accessComparisonWindow().decoType.getSelectedIndex() == 2) {
                    list.add(this.compareTwoFunctionalSubnets(this.subnetsForFirstNet.get(i), this.subnetsForFirstNet.get(j)));
                }
                if (GUIManager.getDefaultGUIManager().accessComparisonWindow().decoType.getSelectedIndex() == 3) {
                    list.add(this.compareTwoSubnets(this.subnetsForFirstNet.get(i), this.subnetsForFirstNet.get(j)));
                }
                if (GUIManager.getDefaultGUIManager().accessComparisonWindow().decoType.getSelectedIndex() == 4) {
                    list.add(this.compareTwoSubnets(this.subnetsForFirstNet.get(i), this.subnetsForFirstNet.get(j)));
                }
                ((GreatCommonSubnet)list.get((int)j)).firstNetID = i;
                ((GreatCommonSubnet)list.get((int)j)).secondNetID = j;
                ((GreatCommonSubnet)list.get((int)j)).firstNetNodeSize = this.subnetsForFirstNet.get((int)i).nodes.size();
                ((GreatCommonSubnet)list.get((int)j)).secondNetNodeSize = this.subnetsForFirstNet.get((int)j).nodes.size();
            }
            resultMatrix.add(list);
        }
        return resultMatrix;
    }

    public ArrayList<ArrayList<GreatCommonSubnet>> compareInternalSecond() {
        ArrayList<ArrayList<GreatCommonSubnet>> resultMatrix = new ArrayList<ArrayList<GreatCommonSubnet>>();
        for (int i = 0; i < this.subnetsForSecondNet.size(); ++i) {
            ArrayList<GreatCommonSubnet> list = new ArrayList<GreatCommonSubnet>();
            for (int j = 0; j < this.subnetsForSecondNet.size(); ++j) {
                if (GUIManager.getDefaultGUIManager().accessComparisonWindow().decoType.getSelectedIndex() == 1) {
                    list.add(this.compareTwoSubnets(this.subnetsForSecondNet.get(i), this.subnetsForSecondNet.get(j)));
                }
                if (GUIManager.getDefaultGUIManager().accessComparisonWindow().decoType.getSelectedIndex() == 2) {
                    list.add(this.compareTwoFunctionalSubnets(this.subnetsForSecondNet.get(i), this.subnetsForSecondNet.get(j)));
                }
                if (GUIManager.getDefaultGUIManager().accessComparisonWindow().decoType.getSelectedIndex() == 3) {
                    list.add(this.compareTwoSubnets(this.subnetsForSecondNet.get(i), this.subnetsForSecondNet.get(j)));
                }
                if (GUIManager.getDefaultGUIManager().accessComparisonWindow().decoType.getSelectedIndex() == 4) {
                    list.add(this.compareTwoSubnets(this.subnetsForSecondNet.get(i), this.subnetsForSecondNet.get(j)));
                }
                ((GreatCommonSubnet)list.get((int)j)).firstNetID = i;
                ((GreatCommonSubnet)list.get((int)j)).secondNetID = j;
                ((GreatCommonSubnet)list.get((int)j)).firstNetNodeSize = this.subnetsForSecondNet.get((int)i).nodes.size();
                ((GreatCommonSubnet)list.get((int)j)).secondNetNodeSize = this.subnetsForSecondNet.get((int)j).nodes.size();
            }
            resultMatrix.add(list);
        }
        return resultMatrix;
    }

    public ArrayList<ArrayList<GreatCommonSubnet>> compareFirstSecond() {
        ArrayList<ArrayList<GreatCommonSubnet>> resultMatrix = new ArrayList<ArrayList<GreatCommonSubnet>>();
        DecimalFormat df = new DecimalFormat("0.00");
        int progess = 0;
        for (int i = 0; i < this.subnetsForFirstNet.size(); ++i) {
            ArrayList<GreatCommonSubnet> list = new ArrayList<GreatCommonSubnet>();
            for (int j = 0; j < this.subnetsForSecondNet.size(); ++j) {
                if (i == 1 && j == 0) {
                    System.out.println("Tu");
                }
                if (GUIManager.getDefaultGUIManager().accessComparisonWindow().decoType.getSelectedIndex() == 1) {
                    list.add(this.compareTwoSubnets(this.subnetsForFirstNet.get(i), this.subnetsForSecondNet.get(j)));
                }
                if (GUIManager.getDefaultGUIManager().accessComparisonWindow().decoType.getSelectedIndex() == 2) {
                    list.add(this.compareTwoFunctionalSubnets(this.subnetsForFirstNet.get(i), this.subnetsForSecondNet.get(j)));
                }
                if (GUIManager.getDefaultGUIManager().accessComparisonWindow().decoType.getSelectedIndex() == 3) {
                    list.add(this.compareTwoSubnets(this.subnetsForFirstNet.get(i), this.subnetsForSecondNet.get(j)));
                }
                if (GUIManager.getDefaultGUIManager().accessComparisonWindow().decoType.getSelectedIndex() == 4) {
                    list.add(this.compareTwoSubnets(this.subnetsForFirstNet.get(i), this.subnetsForSecondNet.get(j)));
                }
                ((GreatCommonSubnet)list.get((int)j)).firstNetID = i;
                ((GreatCommonSubnet)list.get((int)j)).secondNetID = j;
                ((GreatCommonSubnet)list.get((int)j)).firstNetNodeSize = this.subnetsForFirstNet.get((int)i).nodes.size();
                ((GreatCommonSubnet)list.get((int)j)).secondNetNodeSize = this.subnetsForSecondNet.get((int)j).nodes.size();
                JTextArea result = GUIManager.getDefaultGUIManager().accessComparisonWindow().infoPaneDec;
                String content = null;
                try {
                    content = result.getDocument().getText(0, result.getDocument().getLength());
                    int lastLineBreak = content.lastIndexOf(10);
                    result.getDocument().remove(lastLineBreak, result.getDocument().getLength() - lastLineBreak);
                    double progress = (double)progess / (double)(this.subnetsForFirstNet.size() * this.subnetsForSecondNet.size());
                    result.append("\n" + df.format(progress * 100.0) + "%");
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
                ++progess;
            }
            resultMatrix.add(list);
        }
        System.out.println("Jak wyglada macierz 1 " + this.subnetsForFirstNet.size() + "   -   " + this.subnetsForSecondNet.size());
        return resultMatrix;
    }

    public ArrayList<ArrayList<GreatCommonSubnet>> compareSecondFirst() {
        ArrayList<ArrayList<GreatCommonSubnet>> resultMatrix = new ArrayList<ArrayList<GreatCommonSubnet>>();
        int progess = 0;
        DecimalFormat df = new DecimalFormat("0.00");
        for (int i = 0; i < this.subnetsForSecondNet.size(); ++i) {
            ArrayList<GreatCommonSubnet> list = new ArrayList<GreatCommonSubnet>();
            for (int j = 0; j < this.subnetsForFirstNet.size(); ++j) {
                if (GUIManager.getDefaultGUIManager().accessComparisonWindow().decoType.getSelectedIndex() == 1) {
                    list.add(this.compareTwoSubnets(this.subnetsForSecondNet.get(i), this.subnetsForFirstNet.get(j)));
                }
                if (GUIManager.getDefaultGUIManager().accessComparisonWindow().decoType.getSelectedIndex() == 2) {
                    list.add(this.compareTwoFunctionalSubnets(this.subnetsForSecondNet.get(i), this.subnetsForFirstNet.get(j)));
                }
                if (GUIManager.getDefaultGUIManager().accessComparisonWindow().decoType.getSelectedIndex() == 3) {
                    list.add(this.compareTwoSubnets(this.subnetsForSecondNet.get(i), this.subnetsForFirstNet.get(j)));
                }
                if (GUIManager.getDefaultGUIManager().accessComparisonWindow().decoType.getSelectedIndex() == 4) {
                    list.add(this.compareTwoSubnets(this.subnetsForSecondNet.get(i), this.subnetsForFirstNet.get(j)));
                }
                ((GreatCommonSubnet)list.get((int)j)).firstNetID = i;
                ((GreatCommonSubnet)list.get((int)j)).secondNetID = j;
                ((GreatCommonSubnet)list.get((int)j)).firstNetNodeSize = this.subnetsForSecondNet.get((int)i).nodes.size();
                ((GreatCommonSubnet)list.get((int)j)).secondNetNodeSize = this.subnetsForFirstNet.get((int)j).nodes.size();
                JTextArea result = GUIManager.getDefaultGUIManager().accessComparisonWindow().infoPaneDec;
                String content = null;
                try {
                    content = result.getDocument().getText(0, result.getDocument().getLength());
                    int lastLineBreak = content.lastIndexOf(10);
                    result.getDocument().remove(lastLineBreak, result.getDocument().getLength() - lastLineBreak);
                    double progress = (double)progess / (double)(this.subnetsForSecondNet.size() * this.subnetsForFirstNet.size());
                    result.append("\n" + df.format(progress * 100.0) + "%");
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
                ++progess;
            }
            resultMatrix.add(list);
        }
        System.out.println("Jak wyglada macierz 2 " + this.subnetsForFirstNet.size() + "   -   " + this.subnetsForSecondNet.size());
        return resultMatrix;
    }

    public GreatCommonSubnet compareFunctionalTest() {
        return this.compareTwoFunctionalSubnets(this.subnetsForFirstNet.get(0), this.subnetsForSecondNet.get(0));
    }

    private GreatCommonSubnet compareTwoFunctionalSubnets(BranchBasedSubnet sn1, BranchBasedSubnet sn2) {
        allFunBranchpermutations.clear();
        Object maxArcComparisons = null;
        if (sn1.transitions.size() >= sn2.transitions.size()) {
            this.allFuncBranchPermutations(sn1.transitions.size());
        } else {
            this.allFuncBranchPermutations(sn2.transitions.size());
        }
        ArrayList<PartialSubnetElements> results = new ArrayList<PartialSubnetElements>();
        for (ArrayList<Integer> matching : allFunBranchpermutations) {
            PartialSubnetElements tmp;
            Transition value;
            Transition key;
            this.listOfMapedFunctionalPlaces.clear();
            HashMap<Transition, Transition> map = new HashMap<Transition, Transition>();
            for (int i = 0; i < matching.size(); ++i) {
                int key2 = -1;
                int val = -1;
                key2 = i;
                val = matching.get(i);
                if (sn1.transitions.size() <= key2 || sn2.transitions.size() <= val) continue;
                map.put(sn1.transitions.get(key2), sn2.transitions.get(val));
            }
            ArrayList matchNodes = new ArrayList();
            ArrayList<Node> matchN = new ArrayList<Node>();
            ArrayList<Arc> matchA = new ArrayList<Arc>();
            for (Map.Entry entry : map.entrySet()) {
                key = (Transition)entry.getKey();
                value = (Transition)entry.getValue();
                tmp = this.checkPlaces(key, value, sn1, sn2, map);
                matchN.addAll(tmp.partialNodes);
                matchA.addAll(tmp.partialArcs);
            }
            for (Map.Entry entry : map.entrySet()) {
                key = (Transition)entry.getKey();
                value = (Transition)entry.getValue();
                tmp = this.checkLeftPlaces(key, value, sn1, sn2, map, matchN, matchA);
                matchN.addAll(tmp.partialNodes);
                matchA.addAll(tmp.partialArcs);
            }
            if (this.firstQuestion) {
                for (Map.Entry entry : map.entrySet()) {
                    key = (Transition)entry.getKey();
                    value = (Transition)entry.getValue();
                    tmp = this.getRestOfPlaces(key, value, matchN, map);
                    matchN.addAll(tmp.partialNodes);
                    matchA.addAll(tmp.partialArcs);
                }
            }
            results.add(new PartialSubnetElements(matchN, matchA));
        }
        ArrayList<PartialSubnetElements> maxNodes = new ArrayList<PartialSubnetElements>();
        int max = 0;
        for (int i = 0; i < results.size(); ++i) {
            if (((PartialSubnetElements)results.get((int)i)).partialNodes.size() == max) {
                maxNodes.add((PartialSubnetElements)results.get(i));
            }
            if (((PartialSubnetElements)results.get((int)i)).partialNodes.size() <= max) continue;
            max = ((PartialSubnetElements)results.get((int)i)).partialNodes.size();
            maxNodes.clear();
            maxNodes.add((PartialSubnetElements)results.get(i));
        }
        ArrayList<PartialSubnetElements> maxArcs = new ArrayList<PartialSubnetElements>();
        max = 0;
        for (int i = 0; i < maxNodes.size(); ++i) {
            if (((PartialSubnetElements)maxNodes.get((int)i)).partialArcs.size() == max) {
                maxArcs.add((PartialSubnetElements)maxNodes.get(i));
            }
            if (((PartialSubnetElements)maxNodes.get((int)i)).partialArcs.size() <= max) continue;
            max = ((PartialSubnetElements)maxNodes.get((int)i)).partialArcs.size();
            maxArcs.clear();
            maxArcs.add((PartialSubnetElements)maxNodes.get(i));
        }
        return new GreatCommonSubnet(maxArcs);
    }

    private PartialSubnetElements checkLeftPlaces(Transition key, Transition value, BranchBasedSubnet sn1, BranchBasedSubnet sn2, HashMap<Transition, Transition> map, ArrayList<Node> matchN, ArrayList<Arc> matchA) {
        int i;
        ArrayList<Node> common = new ArrayList<Node>();
        ArrayList outPlacesF = key.getOutputPlaces();
        outPlacesF = (ArrayList)outPlacesF.stream().filter(x -> x.getInputNodes().size() > 1).collect(Collectors.toList());
        ArrayList outPlacesS = value.getOutputPlaces();
        outPlacesS = (ArrayList)outPlacesS.stream().filter(x -> x.getInputNodes().size() > 1).collect(Collectors.toList());
        ArrayList inPlacesF = key.getInputPlaces();
        inPlacesF = (ArrayList)inPlacesF.stream().filter(x -> x.getOutputNodes().size() > 1).collect(Collectors.toList());
        ArrayList inPlacesS = value.getInputPlaces();
        inPlacesS = (ArrayList)inPlacesS.stream().filter(x -> x.getOutputNodes().size() > 1).collect(Collectors.toList());
        outPlacesF.removeAll(this.listOfMapedFunctionalPlaces.keySet());
        inPlacesF.removeAll(this.listOfMapedFunctionalPlaces.keySet());
        outPlacesS.removeAll(this.listOfMapedFunctionalPlaces.values());
        inPlacesS.removeAll(this.listOfMapedFunctionalPlaces.values());
        for (i = 0; i < outPlacesF.size() && i < outPlacesS.size(); ++i) {
            common.add((Node)outPlacesF.get(i));
            this.listOfMapedFunctionalPlaces.put((Node)outPlacesF.get(i), (Node)outPlacesS.get(i));
        }
        for (i = 0; i < inPlacesF.size() && i < inPlacesS.size(); ++i) {
            common.add((Node)inPlacesF.get(i));
            this.listOfMapedFunctionalPlaces.put((Node)inPlacesF.get(i), (Node)inPlacesS.get(i));
        }
        HashSet hset = new HashSet(common);
        ArrayList<Node> unique = new ArrayList<Node>(hset);
        ArrayList<Arc> uniqueArcs = new ArrayList<Arc>();
        for (Node n : unique) {
            if (n == key) continue;
            for (Arc a : n.getNeighborsArcs()) {
                if ((!a.getEndNode().equals(key) || !a.getStartNode().equals(n)) && (!a.getStartNode().equals(key) || !a.getEndNode().equals(n))) continue;
                uniqueArcs.add(a);
            }
        }
        return new PartialSubnetElements(unique, uniqueArcs);
    }

    private PartialSubnetElements checkPlaces(Transition key, Transition value, BranchBasedSubnet sn1, BranchBasedSubnet sn2, HashMap<Transition, Transition> map) {
        ArrayList<Node> inPlaces = this.getConInPlaces(key, value, map);
        ArrayList<Node> outPlaces = this.getConOutPlaces(key, value, map);
        ArrayList<Node> commonNodes = new ArrayList<Node>();
        if (!inPlaces.isEmpty() || !outPlaces.isEmpty()) {
            commonNodes.add(key);
            commonNodes.addAll(inPlaces);
            commonNodes.addAll(outPlaces);
            commonNodes.addAll(this.soloNodes(key, value, map));
        }
        if (inPlaces.isEmpty() || outPlaces.isEmpty()) {
            commonNodes.add(key);
            commonNodes.addAll(this.soloNodes(key, value, map));
        }
        HashSet hset = new HashSet(commonNodes);
        ArrayList<Node> unique = new ArrayList<Node>(hset);
        ArrayList<Arc> uniqueArcs = new ArrayList<Arc>();
        for (Node n : unique) {
            if (n == key) continue;
            for (Arc a : n.getNeighborsArcs()) {
                if ((!a.getEndNode().equals(key) || !a.getStartNode().equals(n)) && (!a.getStartNode().equals(key) || !a.getEndNode().equals(n))) continue;
                uniqueArcs.add(a);
            }
        }
        return new PartialSubnetElements(unique, uniqueArcs);
    }

    private PartialSubnetElements getRestOfPlaces(Transition key, Transition value, ArrayList<Node> commonNodes, HashMap<Transition, Transition> map) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        ArrayList<Arc> arcs = new ArrayList<Arc>();
        ArrayList<Place> inPlacesF = key.getInputPlaces();
        ArrayList<Place> outPlacesF = key.getOutputPlaces();
        ArrayList<Place> inPlacesS = value.getInputPlaces();
        ArrayList<Place> outPlacesS = value.getOutputPlaces();
        ArrayList<Node> thoseMaped = new ArrayList<Node>();
        for (Node n : commonNodes) {
            if (map.get(n) != null) {
                thoseMaped.add(map.get(n));
            }
            if (this.listOfMapedFunctionalPlaces.get(n) == null) continue;
            thoseMaped.add(this.listOfMapedFunctionalPlaces.get(n));
        }
        inPlacesF.removeAll(commonNodes);
        inPlacesS.removeAll(thoseMaped);
        outPlacesF.removeAll(commonNodes);
        outPlacesS.removeAll(thoseMaped);
        if (inPlacesF.size() > 0 && inPlacesS.size() > 0) {
            for (int i = 0; i < inPlacesF.size() && i < inPlacesS.size(); ++i) {
                if (this.listOfMapedFunctionalPlaces.keySet().contains(inPlacesF.get(i)) || this.listOfMapedFunctionalPlaces.values().contains(inPlacesS.get(i))) continue;
                nodes.add(inPlacesF.get(i));
                this.listOfMapedFunctionalPlaces.put(inPlacesF.get(i), inPlacesS.get(i));
            }
        }
        if (outPlacesF.size() > 0 && outPlacesS.size() > 0) {
            for (int i = 0; i < outPlacesF.size() && i < outPlacesS.size(); ++i) {
                if (this.listOfMapedFunctionalPlaces.keySet().contains(outPlacesF.get(i)) || this.listOfMapedFunctionalPlaces.values().contains(outPlacesS.get(i))) continue;
                nodes.add(outPlacesF.get(i));
                this.listOfMapedFunctionalPlaces.put(outPlacesF.get(i), outPlacesS.get(i));
            }
        }
        for (Node n : nodes) {
            if (n == key) continue;
            for (Arc a : n.getNeighborsArcs()) {
                if ((!a.getEndNode().equals(key) || !a.getStartNode().equals(n)) && (!a.getStartNode().equals(key) || !a.getEndNode().equals(n))) continue;
                arcs.add(a);
            }
        }
        return new PartialSubnetElements(nodes, arcs);
    }

    private ArrayList<Node> soloNodes(Transition key, Transition value, HashMap<Transition, Transition> map) {
        int i;
        ArrayList<Node> common = new ArrayList<Node>();
        ArrayList outPlacesF = key.getOutputPlaces();
        outPlacesF = (ArrayList)outPlacesF.stream().filter(x -> x.getInputNodes().size() == 1).collect(Collectors.toList());
        ArrayList outPlacesS = value.getOutputPlaces();
        outPlacesS = (ArrayList)outPlacesS.stream().filter(x -> x.getInputNodes().size() == 1).collect(Collectors.toList());
        ArrayList inPlacesF = key.getInputPlaces();
        inPlacesF = (ArrayList)inPlacesF.stream().filter(x -> x.getOutputNodes().size() == 1).collect(Collectors.toList());
        ArrayList inPlacesS = value.getInputPlaces();
        inPlacesS = (ArrayList)inPlacesS.stream().filter(x -> x.getOutputNodes().size() == 1).collect(Collectors.toList());
        for (i = 0; i < outPlacesF.size() && i < outPlacesS.size(); ++i) {
            common.add((Node)outPlacesF.get(i));
            this.listOfMapedFunctionalPlaces.put((Node)outPlacesF.get(i), (Node)outPlacesS.get(i));
        }
        for (i = 0; i < inPlacesF.size() && i < inPlacesS.size(); ++i) {
            common.add((Node)inPlacesF.get(i));
            this.listOfMapedFunctionalPlaces.put((Node)inPlacesF.get(i), (Node)inPlacesS.get(i));
        }
        return common;
    }

    private ArrayList<Node> getConOutPlaces(Transition key, Transition value, HashMap<Transition, Transition> map) {
        ArrayList outPlacesF = key.getOutputPlaces();
        outPlacesF = (ArrayList)outPlacesF.stream().filter(x -> x.getInputNodes().size() > 1).collect(Collectors.toList());
        ArrayList outPlacesS = value.getOutputPlaces();
        outPlacesS = (ArrayList)outPlacesS.stream().filter(x -> x.getInputNodes().size() > 1).collect(Collectors.toList());
        if (!outPlacesF.isEmpty() && !outPlacesS.isEmpty()) {
            ArrayList<Node> conectedF = new ArrayList<Node>();
            for (Object p : outPlacesF) {
                conectedF.addAll(((Node)p).getInputNodes());
                conectedF.remove(key);
            }
            ArrayList<Node> conectedS = new ArrayList<Node>();
            for (Place p : outPlacesS) {
                conectedS.addAll(p.getInputNodes());
                conectedS.remove(value);
            }
            HashSet hset = new HashSet(conectedF);
            conectedF = new ArrayList(hset);
            ArrayList<Node> maped = new ArrayList<Node>();
            for (Node n : conectedF) {
                maped.add(map.get(n));
            }
            maped.retainAll(conectedS);
            ArrayList<Place> places = new ArrayList<Place>();
            for (Node tran : maped) {
                Node RT = null;
                for (Map.Entry<Transition, Transition> entry : map.entrySet()) {
                    if (!entry.getValue().equals(tran)) continue;
                    RT = entry.getKey();
                }
                ArrayList<Place> lp = new ArrayList<Place>(key.getOutputPlaces());
                lp.retainAll(RT.getOutputNodes());
                places.addAll(lp);
                ArrayList<Node> revers = new ArrayList<Node>(map.get(RT).getOutputNodes());
                revers.retainAll(value.getOutputPlaces());
                for (int i = 0; i < lp.size() && i < revers.size(); ++i) {
                    this.listOfMapedFunctionalPlaces.put(lp.get(i), revers.get(i));
                }
            }
            if (this.listOfMapedFunctionalPlaces.size() > 0) {
                return new ArrayList<Node>(this.listOfMapedFunctionalPlaces.keySet());
            }
        }
        return new ArrayList<Node>();
    }

    private ArrayList<Node> getConInPlaces(Transition key, Transition value, HashMap<Transition, Transition> map) {
        ArrayList inPlacesF = key.getInputPlaces();
        inPlacesF = (ArrayList)inPlacesF.stream().filter(x -> x.getOutputNodes().size() > 1).collect(Collectors.toList());
        ArrayList inPlacesS = value.getInputPlaces();
        inPlacesS = (ArrayList)inPlacesS.stream().filter(x -> x.getOutputNodes().size() > 1).collect(Collectors.toList());
        if (!inPlacesF.isEmpty() && !inPlacesS.isEmpty()) {
            ArrayList<Node> conectedF = new ArrayList<Node>();
            for (Object p : inPlacesF) {
                conectedF.addAll(((Node)p).getOutputNodes());
                conectedF.remove(key);
            }
            ArrayList<Node> conectedS = new ArrayList<Node>();
            for (Place p : inPlacesS) {
                conectedS.addAll(p.getOutputNodes());
                conectedS.remove(value);
            }
            HashSet hset = new HashSet(conectedF);
            conectedF = new ArrayList(hset);
            ArrayList<Node> maped = new ArrayList<Node>();
            for (Node n : conectedF) {
                maped.add(map.get(n));
            }
            maped.retainAll(conectedS);
            ArrayList<Place> places = new ArrayList<Place>();
            for (Node tran : maped) {
                Node RT = null;
                for (Map.Entry<Transition, Transition> entry : map.entrySet()) {
                    if (!entry.getValue().equals(tran)) continue;
                    RT = entry.getKey();
                }
                ArrayList<Place> lp = new ArrayList<Place>(key.getInputPlaces());
                lp.retainAll(RT.getInputNodes());
                places.addAll(lp);
                ArrayList<Node> revers = new ArrayList<Node>(map.get(RT).getInputNodes());
                revers.retainAll(value.getInputPlaces());
                for (int i = 0; i < lp.size() && i < revers.size(); ++i) {
                    this.listOfMapedFunctionalPlaces.put(lp.get(i), revers.get(i));
                }
            }
            if (this.listOfMapedFunctionalPlaces.size() > 0) {
                return new ArrayList<Node>(this.listOfMapedFunctionalPlaces.keySet());
            }
        }
        return new ArrayList<Node>();
    }

    private void allFuncBranchPermutations(int n) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < n; ++i) {
            list.add(i);
        }
        SubnetComparator.permute(list, 0);
    }

    static void permute(List<Integer> arr, int k) {
        for (int i = k; i < arr.size(); ++i) {
            Collections.swap(arr, i, k);
            SubnetComparator.permute(arr, k + 1);
            Collections.swap(arr, k, i);
        }
        if (k == arr.size() - 1) {
            allFunBranchpermutations.add(new ArrayList<Integer>(arr));
        }
    }

    public GreatCommonSubnet compareTest() {
        return this.compareTwoSubnets(this.subnetsForFirstNet.get(0), this.subnetsForSecondNet.get(0));
    }

    private GreatCommonSubnet compareTwoSubnets(BranchBasedSubnet net1, BranchBasedSubnet net2) {
        ArrayList<PartialSubnetElements> psel = new ArrayList<PartialSubnetElements>();
        if (net1.branchVertices.size() == 0 && net2.branchVertices.size() == 0) {
            if (net1.paths.size() == 1 && net2.paths.size() == 1) {
                psel.addAll(this.comparePaths(net1.paths.get(0), net2.paths.get(0)));
                System.out.println("X1 - Obie sieci bez tranzycji branchowych");
            }
        } else if (net1.branchVertices.size() == 0 && net2.branchVertices.size() > 0) {
            psel.addAll(this.comparePathToBranch(net1, net2));
            System.out.println("X2 - pierwsza sie\u0107 bez branchowych, druga z branchowycmi");
        } else if (net2.branchVertices.size() == 0 && net1.branchVertices.size() > 0) {
            psel.addAll(this.comparePathToBranch(net2, net1));
        } else if (net1.branchVertices.size() == 1 && net2.branchVertices.size() == 1) {
            psel.addAll(this.comparePTBranches(net1, net2));
            System.out.println("X4 - obie sieci zawieraj\u00e6 dok\u0142adnie 1 tranzycje branchow\u00e6");
        } else if (net1.branchVertices.size() > 1 && net2.branchVertices.size() == 1) {
            psel.addAll(this.comparePTBranches(net1, net2));
            System.out.println("X7 - druga z 1 branchow\u00e6, pierwsza z wi\u011bcej ni\u017e jedn\u00e6 branchow\u00e6 - tbranch");
        } else if (net2.branchVertices.size() > 1 && net1.branchVertices.size() == 1) {
            psel.addAll(this.comparePTBranches(net2, net1));
            System.out.println("X8 - peirwsza z 1 branchow\u00e6, druga z wi\u011bcej ni\u017e jedn\u00e6 branchow\u00e6 - tbranch");
        } else if (net1.branchVertices.size() > 1 && net2.branchVertices.size() > 1) {
            psel.addAll(this.comparePTMultiBranches(net1, net2));
        } else {
            JOptionPane.showMessageDialog(null, "Nieprzewidziany przypadek podczas por\u00f3wnywania", "WARNING MESSAGE", 2);
        }
        ArrayList maxComparisons = new ArrayList();
        ArrayList maxArcComparisons = new ArrayList();
        for (PartialSubnetElements pse : psel) {
            pse.check();
        }
        if (psel.size() == 0) {
            return new GreatCommonSubnet(new ArrayList<PartialSubnetElements>());
        }
        double max = psel.stream().max(Comparator.comparing(PartialSubnetElements::matchingValueFunction)).get().matchingValueFunction();
        maxComparisons = (ArrayList)psel.stream().filter(x -> x.matchingValueFunction() == max).collect(Collectors.toList());
        double maxa = maxComparisons.stream().max(Comparator.comparing(PartialSubnetElements::matchingArcValueFunction)).get().matchingArcValueFunction();
        maxArcComparisons = (ArrayList)maxComparisons.stream().filter(x -> x.matchingArcValueFunction() == maxa).collect(Collectors.toList());
        return new GreatCommonSubnet(maxArcComparisons);
    }

    public void saveSubnet(GreatCommonSubnet gcs) {
        ArrayList<ElementLocation> listOfElements = new ArrayList<ElementLocation>();
        for (PartialSubnetElements pse : gcs.psel) {
            for (Arc a : pse.partialArcs) {
                if (!listOfElements.contains(a.getStartLocation())) {
                    listOfElements.add(a.getStartLocation());
                }
                if (listOfElements.contains(a.getEndLocation())) continue;
                listOfElements.add(a.getEndLocation());
            }
        }
        IOprotocols io = new IOprotocols();
        io.exportSubnet(listOfElements, gcs.psel.get((int)0).partialArcs);
    }

    private ArrayList<PartialSubnetElements> reductToConnectedStructure(ArrayList<PartialSubnetElements> maxComparisons) {
        ArrayList<PartialSubnetElements> result = new ArrayList<PartialSubnetElements>();
        PartialSubnetElements pse = maxComparisons.get(0);
        maxComparisons.remove(0);
        while (maxComparisons.size() > 0) {
            ArrayList<Integer> listOfIndexes = new ArrayList<Integer>();
            boolean next = false;
            for (int i = 0; i < maxComparisons.size(); ++i) {
                ArrayList<Node> common = new ArrayList<Node>(pse.partialNodes);
                common.retainAll(maxComparisons.get((int)i).partialNodes);
                if (common.isEmpty()) continue;
                listOfIndexes.add(i);
                next = true;
            }
        }
        return result;
    }

    private ArrayList<PartialSubnetElements> comparePathToBranch(BranchBasedSubnet net1, BranchBasedSubnet net2) {
        ArrayList<PartialSubnetElements> psel = new ArrayList<PartialSubnetElements>();
        if (net1.paths.size() == 1) {
            BranchBasedSubnet.Branch br;
            BranchBasedSubnet.Branch br2;
            ArrayList<BranchBasedSubnet.Branch> branchesList;
            int j;
            ArrayList<BranchBasedSubnet.Branch> brlr;
            ArrayList<BranchBasedSubnet.Branch> brl;
            Node oen;
            Node osn;
            BranchBasedSubnet.Branch brRev;
            BranchBasedSubnet.Branch br3;
            int i;
            SubnetCalculator.Path path = net1.paths.get(0);
            if (path.isCycle) {
                path.innerpath.add(path.endNode);
                path.endNode = path.startNode;
                path.path.add(path.endNode);
            }
            PartialSubnetElements pse = new PartialSubnetElements(new ArrayList<Node>(), new ArrayList<Arc>());
            if (path.startNode.getType() == PetriNetElement.PetriNetElementType.TRANSITION && path.endNode.getType() == PetriNetElement.PetriNetElementType.TRANSITION) {
                System.out.println("Typ 0");
                System.out.println("Kimkolwiek jeste\u015b, czemu to stworzy\u0142e\u015b? Jako to ma sens");
                for (i = 0; i < net2.branchVertices.size(); ++i) {
                    if (this.secondQuestion && net2.branchVertices.get((int)i).tbranch.size() == 0) {
                        ArrayList<BranchBasedSubnet.Branch> branchesList2 = new ArrayList<BranchBasedSubnet.Branch>();
                        branchesList2.addAll(net2.branchVertices.get((int)i).tbranch);
                        if (this.secondQuestion) {
                            branchesList2.addAll(net2.branchVertices.get((int)i).pbranches);
                        }
                        br3 = new BranchBasedSubnet.Branch(path.path, this.getArcList(path.path), null);
                        brRev = new BranchBasedSubnet.Branch(path.path, this.getArcList(path.path), null);
                        Collections.reverse(brRev.branchElements);
                        Collections.reverse(brRev.internalBranchElements);
                        Collections.reverse(brRev.branchArcs);
                        osn = brRev.startNode;
                        oen = brRev.endNode;
                        brRev.endNode = osn;
                        brRev.startNode = oen;
                        brl = new ArrayList();
                        brl.add(br3);
                        pse = this.comparePbranches(brl, branchesList2, brl.get((int)0).startNode, net2.branchVertices.get((int)i).root);
                        psel.add(pse);
                        brlr = new ArrayList<BranchBasedSubnet.Branch>();
                        brlr.add(brRev);
                        pse = this.comparePbranches(brlr, branchesList2, brl.get((int)0).startNode, net2.branchVertices.get((int)i).root);
                        psel.add(pse);
                    }
                    for (j = 0; j < net2.branchVertices.get((int)i).tbranch.size(); ++j) {
                        if (this.thirdQuestion && net2.branchVertices.get((int)i).tbranchC.contains(net2.branchVertices.get((int)i).tbranch.get(j))) continue;
                        branchesList = new ArrayList();
                        if (!this.thirdQuestion) {
                            branchesList.addAll(net2.branchVertices.get((int)i).tbranch);
                        } else {
                            branchesList.addAll(net2.branchVertices.get((int)i).tbranchS);
                        }
                        if (this.secondQuestion) {
                            branchesList.addAll(net2.branchVertices.get((int)i).pbranches);
                        }
                        br2 = new BranchBasedSubnet.Branch(path.path, this.getArcList(path.path), null);
                        BranchBasedSubnet.Branch brRev2 = new BranchBasedSubnet.Branch(path.path, this.getArcList(path.path), null);
                        Collections.reverse(brRev2.branchElements);
                        Collections.reverse(brRev2.internalBranchElements);
                        Collections.reverse(brRev2.branchArcs);
                        Node osn2 = brRev2.startNode;
                        Node oen2 = brRev2.endNode;
                        brRev2.endNode = osn2;
                        brRev2.startNode = oen2;
                        ArrayList<BranchBasedSubnet.Branch> brl2 = new ArrayList<BranchBasedSubnet.Branch>();
                        brl2.add(br2);
                        pse = this.comparePbranches(brl2, branchesList, ((BranchBasedSubnet.Branch)brl2.get((int)0)).startNode, net2.branchVertices.get((int)i).root);
                        psel.add(pse);
                        ArrayList<BranchBasedSubnet.Branch> brlr2 = new ArrayList<BranchBasedSubnet.Branch>();
                        brlr2.add(brRev2);
                        pse = this.comparePbranches(brlr2, branchesList, brl2.get((int)0).startNode, net2.branchVertices.get((int)i).root);
                        psel.add(pse);
                    }
                }
            }
            if (path.startNode.getType() == PetriNetElement.PetriNetElementType.TRANSITION && path.endNode.getType() == PetriNetElement.PetriNetElementType.PLACE) {
                System.out.println("Typ 1");
                for (i = 0; i < net2.branchVertices.size(); ++i) {
                    if (this.secondQuestion && net2.branchVertices.get((int)i).pbranches.size() == 0) {
                        ArrayList<BranchBasedSubnet.Branch> branchesList3 = new ArrayList<BranchBasedSubnet.Branch>();
                        branchesList3.addAll(net2.branchVertices.get((int)i).pbranches);
                        if (this.secondQuestion) {
                            branchesList3.addAll(net2.branchVertices.get((int)i).tbranch);
                        }
                        br3 = new BranchBasedSubnet.Branch(path.path, this.getArcList(path.path), null);
                        ArrayList<BranchBasedSubnet.Branch> brl3 = new ArrayList<BranchBasedSubnet.Branch>();
                        brl3.add(br3);
                        pse = this.comparePbranches(brl3, branchesList3, ((BranchBasedSubnet.Branch)brl3.get((int)0)).startNode, net2.branchVertices.get((int)i).root);
                        psel.add(pse);
                    }
                    for (j = 0; j < net2.branchVertices.get((int)i).pbranches.size(); ++j) {
                        branchesList = new ArrayList<BranchBasedSubnet.Branch>();
                        branchesList.addAll(net2.branchVertices.get((int)i).pbranches);
                        if (this.secondQuestion) {
                            branchesList.addAll(net2.branchVertices.get((int)i).tbranch);
                        }
                        br2 = new BranchBasedSubnet.Branch(path.path, this.getArcList(path.path), null);
                        ArrayList<BranchBasedSubnet.Branch> brl4 = new ArrayList<BranchBasedSubnet.Branch>();
                        brl4.add(br2);
                        pse = this.comparePbranches(brl4, branchesList, ((BranchBasedSubnet.Branch)brl4.get((int)0)).startNode, net2.branchVertices.get((int)i).root);
                        psel.add(pse);
                    }
                }
            }
            if (path.startNode.getType() == PetriNetElement.PetriNetElementType.PLACE && path.endNode.getType() == PetriNetElement.PetriNetElementType.TRANSITION) {
                System.out.println("Typ 1");
                for (i = 0; i < net2.branchVertices.size(); ++i) {
                    if (this.secondQuestion && net2.branchVertices.get((int)i).pbranches.size() == 0) {
                        ArrayList<BranchBasedSubnet.Branch> branchesList4 = new ArrayList<BranchBasedSubnet.Branch>();
                        branchesList4.addAll(net2.branchVertices.get((int)i).pbranches);
                        if (this.secondQuestion) {
                            branchesList4.addAll(net2.branchVertices.get((int)i).tbranch);
                        }
                        ArrayList<Node> reverPathNode = new ArrayList<Node>(path.path);
                        ArrayList<Arc> reversPathArc = new ArrayList<Arc>(this.getArcList(path.path));
                        br = new BranchBasedSubnet.Branch(reverPathNode, reversPathArc, null);
                        ArrayList<BranchBasedSubnet.Branch> brl5 = new ArrayList<BranchBasedSubnet.Branch>();
                        brl5.add(br);
                        pse = this.comparePbranches(brl5, branchesList4, ((BranchBasedSubnet.Branch)brl5.get((int)0)).startNode, net2.branchVertices.get((int)i).root);
                        psel.add(pse);
                    }
                    for (j = 0; j < net2.branchVertices.get((int)i).pbranches.size(); ++j) {
                        branchesList = new ArrayList();
                        branchesList.addAll(net2.branchVertices.get((int)i).pbranches);
                        if (this.secondQuestion) {
                            branchesList.addAll(net2.branchVertices.get((int)i).tbranch);
                        }
                        ArrayList<Node> reverPathNode = new ArrayList<Node>(path.path);
                        ArrayList<Arc> reversPathArc = new ArrayList<Arc>(this.getArcList(path.path));
                        BranchBasedSubnet.Branch br4 = new BranchBasedSubnet.Branch(reverPathNode, reversPathArc, null);
                        brl = new ArrayList<BranchBasedSubnet.Branch>();
                        brl.add(br4);
                        pse = this.comparePbranches(brl, branchesList, ((BranchBasedSubnet.Branch)brl.get((int)0)).startNode, net2.branchVertices.get((int)i).root);
                        psel.add(pse);
                    }
                }
            }
            if (path.startNode.getType() == PetriNetElement.PetriNetElementType.PLACE && path.endNode.getType() == PetriNetElement.PetriNetElementType.PLACE) {
                System.out.println("Typ 2");
                if (path.isCycle) {
                    System.out.println("Typ 0");
                    System.out.println("Kimkolwiek jeste\u015b, czemu to stworzy\u0142e\u015b? Jako to ma sens");
                    for (i = 0; i < net2.branchVertices.size(); ++i) {
                        if (this.secondQuestion && net2.branchVertices.get((int)i).tbranch.size() == 0) {
                            ArrayList<BranchBasedSubnet.Branch> branchesList5 = new ArrayList<BranchBasedSubnet.Branch>();
                            branchesList5.addAll(net2.branchVertices.get((int)i).tbranch);
                            if (this.secondQuestion) {
                                branchesList5.addAll(net2.branchVertices.get((int)i).pbranches);
                            }
                            br3 = new BranchBasedSubnet.Branch(path.path, this.getArcList(path.path), null);
                            brRev = new BranchBasedSubnet.Branch(path.path, this.getArcList(path.path), null);
                            Collections.reverse(brRev.branchElements);
                            Collections.reverse(brRev.internalBranchElements);
                            Collections.reverse(brRev.branchArcs);
                            osn = brRev.startNode;
                            oen = brRev.endNode;
                            brRev.endNode = osn;
                            brRev.startNode = oen;
                            brl = new ArrayList();
                            brl.add(br3);
                            pse = this.comparePbranches(brl, branchesList5, brl.get((int)0).startNode, net2.branchVertices.get((int)i).root);
                            psel.add(pse);
                            brlr = new ArrayList();
                            brlr.add(brRev);
                            pse = this.comparePbranches(brlr, branchesList5, brl.get((int)0).startNode, net2.branchVertices.get((int)i).root);
                            psel.add(pse);
                        }
                        for (j = 0; j < net2.branchVertices.get((int)i).tbranch.size(); ++j) {
                            ArrayList<BranchBasedSubnet.Branch> brl6;
                            Node oen3;
                            Node osn3;
                            BranchBasedSubnet.Branch brRev3;
                            ArrayList<Node> movedPath;
                            if (net2.branchVertices.get((int)i).tbranch.get((int)j).startNode.equals(net2.branchVertices.get((int)i).tbranch.get((int)j).endNode)) {
                                branchesList = new ArrayList();
                                branchesList.addAll(net2.branchVertices.get((int)i).tbranch);
                                if (this.secondQuestion) {
                                    branchesList.addAll(net2.branchVertices.get((int)i).pbranches);
                                }
                                movedPath = this.moveCycle(path.path);
                                br = new BranchBasedSubnet.Branch(movedPath, this.getArcList(movedPath), null);
                                brRev3 = new BranchBasedSubnet.Branch(movedPath, this.getArcList(movedPath), null);
                                Collections.reverse(brRev3.branchElements);
                                Collections.reverse(brRev3.internalBranchElements);
                                Collections.reverse(brRev3.branchArcs);
                                osn3 = brRev3.startNode;
                                oen3 = brRev3.endNode;
                                brRev3.endNode = osn3;
                                brRev3.startNode = oen3;
                                brl6 = new ArrayList<BranchBasedSubnet.Branch>();
                                brl6.add(br);
                                pse = this.comparePbranches(brl6, branchesList, ((BranchBasedSubnet.Branch)brl6.get((int)0)).startNode, net2.branchVertices.get((int)i).root);
                                psel.add(pse);
                                pse = this.comparePbranches(brl6, branchesList, brl6.get((int)0).endNode, net2.branchVertices.get((int)i).root);
                                psel.add(pse);
                                continue;
                            }
                            branchesList = new ArrayList();
                            branchesList.addAll(net2.branchVertices.get((int)i).tbranch);
                            if (this.secondQuestion) {
                                branchesList.addAll(net2.branchVertices.get((int)i).pbranches);
                            }
                            movedPath = this.movePath(path.path);
                            br = new BranchBasedSubnet.Branch(movedPath, this.getArcList(movedPath), null);
                            brRev3 = new BranchBasedSubnet.Branch(movedPath, this.getArcList(movedPath), null);
                            Collections.reverse(brRev3.branchElements);
                            Collections.reverse(brRev3.internalBranchElements);
                            Collections.reverse(brRev3.branchArcs);
                            osn3 = brRev3.startNode;
                            oen3 = brRev3.endNode;
                            brRev3.endNode = osn3;
                            brRev3.startNode = oen3;
                            brl6 = new ArrayList();
                            brl6.add(br);
                            pse = this.comparePbranches(brl6, branchesList, ((BranchBasedSubnet.Branch)brl6.get((int)0)).startNode, net2.branchVertices.get((int)i).root);
                            psel.add(pse);
                            ArrayList<BranchBasedSubnet.Branch> brlr3 = new ArrayList<BranchBasedSubnet.Branch>();
                            brlr3.add(brRev3);
                            pse = this.comparePbranches(brlr3, branchesList, brl6.get((int)0).startNode, net2.branchVertices.get((int)i).root);
                            psel.add(pse);
                        }
                    }
                }
            }
        } else {
            System.out.println("Exception in comparePathToBranch");
        }
        return psel;
    }

    private ArrayList<Node> moveCycle(ArrayList<Node> path) {
        ArrayList<Node> result = new ArrayList<Node>(path);
        result.remove(0);
        result.add(result.get(0));
        return result;
    }

    private ArrayList<Node> movePath(ArrayList<Node> path) {
        ArrayList<Node> result = new ArrayList<Node>(path);
        result.remove(0);
        return result;
    }

    private ArrayList<Arc> getArcList(ArrayList<Node> path) {
        ArrayList<Arc> arcList = new ArrayList<Arc>();
        for (int i = 0; i < path.size() - 1; ++i) {
            int finalI = i;
            Arc a = path.get(i).getNeighborsArcs().stream().filter(x -> x.getEndNode().getID() == ((Node)path.get(finalI + 1)).getID()).findFirst().orElse(null);
            if (a == null) continue;
            arcList.add(a);
        }
        return arcList;
    }

    private GreatCommonSubnet compareTwoSubnetsOLD(BranchBasedSubnet net1, BranchBasedSubnet net2) {
        ArrayList<PartialSubnetElements> psel = new ArrayList<PartialSubnetElements>();
        if (net1.branchVertices.size() == 0 && net2.branchVertices.size() == 0) {
            if (net1.paths.size() == 1 && net2.paths.size() == 1) {
                psel.addAll(this.comparePaths(net1.paths.get(0), net2.paths.get(0)));
                System.out.println("X1 - Obie sieci bez tranzycji branchowych");
            }
        } else if (net1.branchVertices.size() == 0 && net2.branchVertices.size() > 0) {
            for (p = 0; p < net2.paths.size(); ++p) {
                psel.addAll(this.comparePaths(net1.paths.get(0), net2.paths.get(p)));
                System.out.println("X2 - pierwsza sie\u0107 bez branchowych, druga z branchowycmi");
            }
        } else if (net2.branchVertices.size() == 0 && net1.branchVertices.size() > 0) {
            for (p = 0; p < net1.paths.size(); ++p) {
                psel.addAll(this.comparePaths(net1.paths.get(p), net2.paths.get(0)));
                System.out.println("X3 - druga sie\u0107 bez branchowych, pierwsza z branchowymi");
            }
        } else if (net1.branchVertices.size() == 1 && net2.branchVertices.size() == 1) {
            psel.addAll(this.comparePTBranches(net1, net2));
            System.out.println("X4 - obie sieci zawieraj\u00e6 dok\u0142adnie 1 tranzycje branchow\u00e6");
        } else if (net1.branchVertices.size() == 0 && net2.branchVertices.size() > 0) {
            for (p = 0; p < net2.paths.size(); ++p) {
                psel.addAll(this.comparePaths(net1.paths.get(0), net2.paths.get(p)));
                System.out.println("X5 - pierwsza bez branchowych, druga z wi\u011bcej ni\u017e jedn\u00e6 branchow\u00e6 - tbranch");
            }
        } else if (net2.branchVertices.size() == 0 && net1.branchVertices.size() > 0) {
            for (p = 0; p < net1.paths.size(); ++p) {
                psel.addAll(this.comparePaths(net1.paths.get(p), net2.paths.get(0)));
                System.out.println("X6 - druga bez branchowych, pierwsza z wi\u011bcej ni\u017e jedn\u00e6 branchow\u00e6 - tbranch");
            }
        } else if (net1.branchVertices.size() > 1 && net2.branchVertices.size() == 1) {
            psel.addAll(this.comparePTBranches(net1, net2));
            System.out.println("X7 - druga z 1 branchow\u00e6, pierwsza z wi\u011bcej ni\u017e jedn\u00e6 branchow\u00e6 - tbranch");
        } else if (net2.branchVertices.size() > 1 && net1.branchVertices.size() == 1) {
            psel.addAll(this.comparePTBranches(net2, net1));
            System.out.println("X8 - peirwsza z 1 branchow\u00e6, druga z wi\u011bcej ni\u017e jedn\u00e6 branchow\u00e6 - tbranch");
        } else if (net1.branchVertices.size() == 1 && net2.branchVertices.size() == 1) {
            psel.add(this.comparePbranches(net1.branchVertices.get((int)0).pbranches, net2.branchVertices.get((int)0).pbranches, net1.branchVertices.get((int)0).root, net2.branchVertices.get((int)0).root));
            System.out.println("X9 - obie z jedn\u00e6 branchow\u00e6");
        } else if (net1.branchVertices.size() > 1 && net2.branchVertices.size() > 1) {
            psel.addAll(this.comparePTMultiBranches(net1, net2));
        } else {
            JOptionPane.showMessageDialog(null, "Nieprzewidziany przypadek podczas por\u00f3wnywania", "WARNING MESSAGE", 2);
        }
        ArrayList maxComparisons = new ArrayList();
        if (psel.size() == 0) {
            return new GreatCommonSubnet(new ArrayList<PartialSubnetElements>());
        }
        double max = psel.stream().max(Comparator.comparing(x -> x.matchingValueFunction())).get().matchingValueFunction();
        maxComparisons = (ArrayList)psel.stream().filter(x -> x.matchingValueFunction() == max).collect(Collectors.toList());
        return new GreatCommonSubnet(maxComparisons);
    }

    private ArrayList<PartialSubnetElements> addToPSE(BranchBasedSubnet.Branch branch, ArrayList<PartialSubnetElements> pseList) {
        for (int i = 0; i < pseList.size(); ++i) {
            if (pseList.get((int)i).partialNodes.contains(branch.startNode)) {
                pseList.get((int)i).partialNodes.addAll(branch.internalBranchElements);
                pseList.get((int)i).partialNodes.add(branch.endNode);
                pseList.get((int)i).partialArcs.addAll(branch.branchArcs);
                continue;
            }
            if (pseList.get((int)i).partialNodes.contains(branch.endNode)) {
                pseList.get((int)i).partialNodes.addAll(branch.branchElements);
                pseList.get((int)i).partialNodes.add(branch.startNode);
                pseList.get((int)i).partialArcs.addAll(branch.branchArcs);
                continue;
            }
            JOptionPane.showMessageDialog(null, "You not suppose to be here... No one suppose to be here", "Hahaha... - b\u0142\u0105d przy tbranchach dla mergowanych branchy roz\u0142\u0105cznych", 0);
        }
        ArrayList ndup = new ArrayList();
        for (PartialSubnetElements pse : pseList) {
            pse.partialNodes = pse.partialNodes.stream().distinct().collect(Collectors.toCollection(ArrayList::new));
        }
        return pseList;
    }

    private ArrayList<PartialSubnetElements> mergeBranches(BranchBasedSubnet.Branch branch, ArrayList<PartialSubnetElements> pseList) {
        ArrayList<PartialSubnetElements> indexToMerge = new ArrayList<PartialSubnetElements>();
        for (int i = 0; i < pseList.size(); ++i) {
            if (!pseList.get((int)i).partialNodes.contains(branch.startNode) && !pseList.get((int)i).partialNodes.contains(branch.endNode)) continue;
            indexToMerge.add(pseList.get(i));
        }
        if (indexToMerge.size() == 2) {
            pseList.removeAll(indexToMerge);
            ((PartialSubnetElements)indexToMerge.get((int)0)).partialNodes.addAll(branch.branchElements);
            ((PartialSubnetElements)indexToMerge.get((int)0)).partialNodes = (ArrayList)((PartialSubnetElements)indexToMerge.get((int)0)).partialNodes.stream().distinct().collect(Collectors.toList());
            ((PartialSubnetElements)indexToMerge.get((int)0)).partialArcs.addAll(branch.branchArcs);
            PartialSubnetElements merged = this.mergePartialSubnetElements((PartialSubnetElements)indexToMerge.get(0), (PartialSubnetElements)indexToMerge.get(1));
            pseList.add(merged);
        } else if (indexToMerge.size() == 1) {
            pseList.removeAll(indexToMerge);
            ((PartialSubnetElements)indexToMerge.get((int)0)).partialNodes.addAll(branch.branchElements);
            ((PartialSubnetElements)indexToMerge.get((int)0)).partialNodes = (ArrayList)((PartialSubnetElements)indexToMerge.get((int)0)).partialNodes.stream().distinct().collect(Collectors.toList());
            ((PartialSubnetElements)indexToMerge.get((int)0)).partialArcs.addAll(branch.branchArcs);
            PartialSubnetElements merged = new PartialSubnetElements(((PartialSubnetElements)indexToMerge.get((int)0)).partialNodes, ((PartialSubnetElements)indexToMerge.get((int)0)).partialArcs);
            pseList.add(merged);
        } else if (indexToMerge.size() == 0) {
            pseList.add(new PartialSubnetElements(branch.branchElements, branch.branchArcs));
        } else {
            JOptionPane.showMessageDialog(null, "You not suppose to be here... No one suppose to be here", "Hahaha... - b\u0142\u0105d przy tbranchach dla mergowanych branchy", 0);
        }
        return pseList;
    }

    private ArrayList<BranchBasedSubnet.Branch> compareTbranch(BranchBasedSubnet.Branch firstNetBranch, BranchBasedSubnet.Branch secondNetBranch, BranchBasedSubnet bbs) {
        ArrayList<BranchBasedSubnet.Branch> listOfBranches = new ArrayList<BranchBasedSubnet.Branch>();
        ArrayList<Node> commonNodesIn = new ArrayList<Node>();
        ArrayList<Arc> commonArcsIn = new ArrayList<Arc>();
        if (firstNetBranch.branchElements.size() == secondNetBranch.branchElements.size() && !firstNetBranch.startNode.equals(firstNetBranch.endNode) && !secondNetBranch.startNode.equals(secondNetBranch.endNode)) {
            System.out.println("tbranche prawid\u0142owe");
            BranchBasedSubnet.Branch br = this.compareEqualSizeBranches(firstNetBranch, secondNetBranch, bbs, commonNodesIn, commonArcsIn);
            listOfBranches.add(br);
        } else {
            System.out.println("tbranche nieprawid\u0142owe");
            if (firstNetBranch.startNode.equals(firstNetBranch.endNode) && !secondNetBranch.startNode.equals(secondNetBranch.endNode)) {
                if (!this.thirdQuestion) {
                    BranchBasedSubnet.Branch loop = new BranchBasedSubnet.Branch(firstNetBranch.branchElements, firstNetBranch.branchArcs, firstNetBranch.parent);
                    loop.branchArcs.remove(loop.branchArcs.size() - 1);
                    BranchBasedSubnet.Branch br = this.compareBranchesSizeFromBeg(loop, secondNetBranch, bbs, commonNodesIn, commonArcsIn);
                    listOfBranches.add(br);
                    commonNodesIn = new ArrayList();
                    commonArcsIn = new ArrayList();
                    loop = new BranchBasedSubnet.Branch(firstNetBranch.branchElements, firstNetBranch.branchArcs, firstNetBranch.parent);
                    loop.branchArcs.remove(0);
                    br = this.compareBranchesSizeFromEnd(loop, secondNetBranch, bbs, commonNodesIn, commonArcsIn);
                    listOfBranches.add(br);
                    System.out.println("I");
                }
            } else if (!firstNetBranch.startNode.equals(firstNetBranch.endNode) && secondNetBranch.startNode.equals(secondNetBranch.endNode)) {
                if (!this.thirdQuestion) {
                    BranchBasedSubnet.Branch loop = new BranchBasedSubnet.Branch(secondNetBranch.branchElements, secondNetBranch.branchArcs, secondNetBranch.parent);
                    loop.branchArcs.remove(loop.branchArcs.size() - 1);
                    BranchBasedSubnet.Branch br = this.compareBranchesSizeFromBeg(firstNetBranch, loop, bbs, commonNodesIn, commonArcsIn);
                    listOfBranches.add(br);
                    commonNodesIn = new ArrayList();
                    commonArcsIn = new ArrayList();
                    loop = new BranchBasedSubnet.Branch(secondNetBranch.branchElements, secondNetBranch.branchArcs, secondNetBranch.parent);
                    loop.branchArcs.remove(0);
                    br = this.compareBranchesSizeFromEnd(firstNetBranch, loop, bbs, commonNodesIn, commonArcsIn);
                    listOfBranches.add(br);
                    System.out.println("II");
                }
            } else {
                BranchBasedSubnet.Branch br = this.compareBranchesSizeFromBeg(firstNetBranch, secondNetBranch, bbs, commonNodesIn, commonArcsIn);
                listOfBranches.add(br);
                commonNodesIn = new ArrayList();
                commonArcsIn = new ArrayList();
                br = this.compareBranchesSizeFromEnd(firstNetBranch, secondNetBranch, bbs, commonNodesIn, commonArcsIn);
                listOfBranches.add(br);
            }
        }
        return listOfBranches;
    }

    private BranchBasedSubnet.Branch compareEqualSizeBranchesLoops(BranchBasedSubnet.Branch firstNetBranch, BranchBasedSubnet.Branch secondNetBranch, BranchBasedSubnet bbs, ArrayList<Node> commonNodesIn, ArrayList<Arc> commonArcsIn) {
        BranchBasedSubnet.Branch fromBeg = this.compareBranchesSizeFromBeg(firstNetBranch, secondNetBranch, bbs, commonNodesIn, commonArcsIn);
        BranchBasedSubnet.Branch fromEnd = this.compareBranchesSizeFromEnd(firstNetBranch, secondNetBranch, bbs, commonNodesIn, commonArcsIn);
        BranchBasedSubnet.Branch br = fromBeg.branchElements.size() > fromEnd.branchElements.size() ? fromBeg : fromEnd;
        return br;
    }

    private BranchBasedSubnet.Branch compareBranchesSizeFromEnd(BranchBasedSubnet.Branch firstNetBranch, BranchBasedSubnet.Branch secondNetBranch, BranchBasedSubnet bbs, ArrayList<Node> commonNodesIn, ArrayList<Arc> commonArcsIn) {
        HashMap<Node, Node> nm = new HashMap<Node, Node>();
        HashMap<Arc, Arc> am = new HashMap<Arc, Arc>();
        for (int i = 0; i < firstNetBranch.branchArcs.size() && i < secondNetBranch.branchArcs.size(); ++i) {
            if (firstNetBranch.branchArcs.get(firstNetBranch.branchArcs.size() - 1 - i).getWeight() != secondNetBranch.branchArcs.get(secondNetBranch.branchArcs.size() - 1 - i).getWeight()) {
                int arcWeight = Math.min(firstNetBranch.branchArcs.get(firstNetBranch.branchArcs.size() - 1 - i).getWeight(), secondNetBranch.branchArcs.get(secondNetBranch.branchArcs.size() - 1 - i).getWeight());
                if (arcWeight == 0) continue;
                if (this.firstQuestion) {
                    firstNetBranch.branchArcs.get((int)(firstNetBranch.branchArcs.size() - 1 - i)).arcDecoBox.setMemoryOfArcWeight(arcWeight);
                    if (i == firstNetBranch.branchArcs.size() - 1 && i != secondNetBranch.branchArcs.size() - 1 || i != firstNetBranch.branchArcs.size() - 1 && i == secondNetBranch.branchArcs.size() - 1) {
                        firstNetBranch.branchArcs.get((int)(firstNetBranch.branchArcs.size() - 1 - i)).arcDecoBox.setBranchEnd(true);
                        continue;
                    }
                    commonArcsIn.add(firstNetBranch.branchArcs.get(firstNetBranch.branchArcs.size() - 1 - i));
                    am.put(firstNetBranch.branchArcs.get(firstNetBranch.branchArcs.size() - 1 - i), secondNetBranch.branchArcs.get(secondNetBranch.branchArcs.size() - 1 - i));
                    if (!commonNodesIn.contains(firstNetBranch.branchArcs.get(firstNetBranch.branchArcs.size() - 1 - i).getEndNode())) {
                        commonNodesIn.add(firstNetBranch.branchArcs.get(firstNetBranch.branchArcs.size() - 1 - i).getEndNode());
                        nm.put(firstNetBranch.branchArcs.get(firstNetBranch.branchArcs.size() - 1 - i).getEndNode(), secondNetBranch.branchArcs.get(secondNetBranch.branchArcs.size() - 1 - i).getEndNode());
                    }
                    if (commonNodesIn.contains(firstNetBranch.branchArcs.get(firstNetBranch.branchArcs.size() - 1 - i).getStartNode())) continue;
                    commonNodesIn.add(firstNetBranch.branchArcs.get(firstNetBranch.branchArcs.size() - 1 - i).getStartNode());
                    nm.put(firstNetBranch.branchArcs.get(firstNetBranch.branchArcs.size() - 1 - i).getStartNode(), secondNetBranch.branchArcs.get(secondNetBranch.branchArcs.size() - 1 - i).getStartNode());
                    continue;
                }
                firstNetBranch.branchArcs.get((int)(firstNetBranch.branchArcs.size() - 1 - i)).arcDecoBox.setMemoryOfArcWeight(arcWeight);
                if (i == firstNetBranch.branchArcs.size() - 1 && i != secondNetBranch.branchArcs.size() - 1 || i != firstNetBranch.branchArcs.size() - 1 && i == secondNetBranch.branchArcs.size() - 1) {
                    firstNetBranch.branchArcs.get((int)(firstNetBranch.branchArcs.size() - 1 - i)).arcDecoBox.setBranchEnd(true);
                }
                commonArcsIn.add(firstNetBranch.branchArcs.get(firstNetBranch.branchArcs.size() - 1 - i));
                am.put(firstNetBranch.branchArcs.get(firstNetBranch.branchArcs.size() - 1 - i), secondNetBranch.branchArcs.get(secondNetBranch.branchArcs.size() - 1 - i));
                if (!commonNodesIn.contains(firstNetBranch.branchArcs.get(firstNetBranch.branchArcs.size() - 1 - i).getEndNode())) {
                    commonNodesIn.add(firstNetBranch.branchArcs.get(firstNetBranch.branchArcs.size() - 1 - i).getEndNode());
                    nm.put(firstNetBranch.branchArcs.get(firstNetBranch.branchArcs.size() - 1 - i).getEndNode(), secondNetBranch.branchArcs.get(secondNetBranch.branchArcs.size() - 1 - i).getEndNode());
                }
                if (commonNodesIn.contains(firstNetBranch.branchArcs.get(firstNetBranch.branchArcs.size() - 1 - i).getStartNode())) continue;
                commonNodesIn.add(firstNetBranch.branchArcs.get(firstNetBranch.branchArcs.size() - 1 - i).getStartNode());
                nm.put(firstNetBranch.branchArcs.get(firstNetBranch.branchArcs.size() - 1 - i).getStartNode(), secondNetBranch.branchArcs.get(secondNetBranch.branchArcs.size() - 1 - i).getStartNode());
                continue;
            }
            if (this.firstQuestion) {
                if (i == firstNetBranch.branchArcs.size() - 1 && i != secondNetBranch.branchArcs.size() - 1 || i != firstNetBranch.branchArcs.size() - 1 && i == secondNetBranch.branchArcs.size() - 1) {
                    firstNetBranch.branchArcs.get((int)(firstNetBranch.branchArcs.size() - 1 - i)).arcDecoBox.setBranchEnd(true);
                    continue;
                }
                commonArcsIn.add(firstNetBranch.branchArcs.get(firstNetBranch.branchArcs.size() - 1 - i));
                am.put(firstNetBranch.branchArcs.get(firstNetBranch.branchArcs.size() - 1 - i), secondNetBranch.branchArcs.get(secondNetBranch.branchArcs.size() - 1 - i));
                if (!commonNodesIn.contains(firstNetBranch.branchArcs.get(firstNetBranch.branchArcs.size() - 1 - i).getEndNode())) {
                    commonNodesIn.add(firstNetBranch.branchArcs.get(firstNetBranch.branchArcs.size() - 1 - i).getEndNode());
                    nm.put(firstNetBranch.branchArcs.get(firstNetBranch.branchArcs.size() - 1 - i).getEndNode(), secondNetBranch.branchArcs.get(secondNetBranch.branchArcs.size() - 1 - i).getEndNode());
                }
                if (commonNodesIn.contains(firstNetBranch.branchArcs.get(firstNetBranch.branchArcs.size() - 1 - i).getStartNode())) continue;
                commonNodesIn.add(firstNetBranch.branchArcs.get(firstNetBranch.branchArcs.size() - 1 - i).getStartNode());
                nm.put(firstNetBranch.branchArcs.get(firstNetBranch.branchArcs.size() - 1 - i).getStartNode(), secondNetBranch.branchArcs.get(secondNetBranch.branchArcs.size() - 1 - i).getStartNode());
                continue;
            }
            if (i == firstNetBranch.branchArcs.size() - 1 && i != secondNetBranch.branchArcs.size() - 1 || i != firstNetBranch.branchArcs.size() - 1 && i == secondNetBranch.branchArcs.size() - 1) {
                firstNetBranch.branchArcs.get((int)(firstNetBranch.branchArcs.size() - 1 - i)).arcDecoBox.setBranchEnd(true);
            }
            commonArcsIn.add(firstNetBranch.branchArcs.get(firstNetBranch.branchArcs.size() - 1 - i));
            am.put(firstNetBranch.branchArcs.get(firstNetBranch.branchArcs.size() - 1 - i), secondNetBranch.branchArcs.get(secondNetBranch.branchArcs.size() - 1 - i));
            if (!commonNodesIn.contains(firstNetBranch.branchArcs.get(firstNetBranch.branchArcs.size() - 1 - i).getEndNode())) {
                commonNodesIn.add(firstNetBranch.branchArcs.get(firstNetBranch.branchArcs.size() - 1 - i).getEndNode());
                nm.put(firstNetBranch.branchArcs.get(firstNetBranch.branchArcs.size() - 1 - i).getEndNode(), secondNetBranch.branchArcs.get(secondNetBranch.branchArcs.size() - 1 - i).getEndNode());
            }
            if (commonNodesIn.contains(firstNetBranch.branchArcs.get(firstNetBranch.branchArcs.size() - 1 - i).getStartNode())) continue;
            commonNodesIn.add(firstNetBranch.branchArcs.get(firstNetBranch.branchArcs.size() - 1 - i).getStartNode());
            nm.put(firstNetBranch.branchArcs.get(firstNetBranch.branchArcs.size() - 1 - i).getStartNode(), secondNetBranch.branchArcs.get(secondNetBranch.branchArcs.size() - 1 - i).getStartNode());
        }
        BranchBasedSubnet.Branch br = new BranchBasedSubnet.Branch(commonNodesIn, commonArcsIn, bbs, nm, am);
        return br;
    }

    private BranchBasedSubnet.Branch compareBranchesSizeFromBeg(BranchBasedSubnet.Branch firstNetBranch, BranchBasedSubnet.Branch secondNetBranch, BranchBasedSubnet bbs, ArrayList<Node> commonNodesIn, ArrayList<Arc> commonArcsIn) {
        HashMap<Node, Node> nm = new HashMap<Node, Node>();
        HashMap<Arc, Arc> am = new HashMap<Arc, Arc>();
        for (int i = 0; i < firstNetBranch.branchArcs.size() && i < secondNetBranch.branchArcs.size(); ++i) {
            if (firstNetBranch.branchArcs.get(i).getWeight() != secondNetBranch.branchArcs.get(i).getWeight()) {
                int arcWeight = Math.min(firstNetBranch.branchArcs.get(i).getWeight(), secondNetBranch.branchArcs.get(i).getWeight());
                if (arcWeight == 0) continue;
                firstNetBranch.branchArcs.get((int)i).arcDecoBox.setMemoryOfArcWeight(arcWeight);
                if (this.firstQuestion) {
                    if (i == firstNetBranch.branchArcs.size() - 1 && i != secondNetBranch.branchArcs.size() - 1 || i != firstNetBranch.branchArcs.size() - 1 && i == secondNetBranch.branchArcs.size() - 1) {
                        firstNetBranch.branchArcs.get((int)i).arcDecoBox.setBranchEnd(true);
                        continue;
                    }
                    commonArcsIn.add(firstNetBranch.branchArcs.get(i));
                    am.put(firstNetBranch.branchArcs.get(i), secondNetBranch.branchArcs.get(i));
                    if (!commonNodesIn.contains(firstNetBranch.branchArcs.get(i).getEndNode())) {
                        commonNodesIn.add(firstNetBranch.branchArcs.get(i).getEndNode());
                        nm.put(firstNetBranch.branchArcs.get(i).getEndNode(), secondNetBranch.branchArcs.get(i).getEndNode());
                    }
                    if (commonNodesIn.contains(firstNetBranch.branchArcs.get(i).getStartNode())) continue;
                    commonNodesIn.add(firstNetBranch.branchArcs.get(i).getStartNode());
                    nm.put(firstNetBranch.branchArcs.get(i).getStartNode(), secondNetBranch.branchArcs.get(i).getStartNode());
                    continue;
                }
                if (i == firstNetBranch.branchArcs.size() - 1 && i != secondNetBranch.branchArcs.size() - 1 || i != firstNetBranch.branchArcs.size() - 1 && i == secondNetBranch.branchArcs.size() - 1) {
                    firstNetBranch.branchArcs.get((int)i).arcDecoBox.setBranchEnd(true);
                }
                commonArcsIn.add(firstNetBranch.branchArcs.get(i));
                am.put(firstNetBranch.branchArcs.get(i), secondNetBranch.branchArcs.get(i));
                if (!commonNodesIn.contains(firstNetBranch.branchArcs.get(i).getEndNode())) {
                    commonNodesIn.add(firstNetBranch.branchArcs.get(i).getEndNode());
                    nm.put(firstNetBranch.branchArcs.get(i).getEndNode(), secondNetBranch.branchArcs.get(i).getEndNode());
                }
                if (commonNodesIn.contains(firstNetBranch.branchArcs.get(i).getStartNode())) continue;
                commonNodesIn.add(firstNetBranch.branchArcs.get(i).getStartNode());
                nm.put(firstNetBranch.branchArcs.get(i).getStartNode(), secondNetBranch.branchArcs.get(i).getStartNode());
                continue;
            }
            if (this.firstQuestion) {
                if (i == firstNetBranch.branchArcs.size() - 1 && i != secondNetBranch.branchArcs.size() - 1 || i != firstNetBranch.branchArcs.size() - 1 && i == secondNetBranch.branchArcs.size() - 1) {
                    firstNetBranch.branchArcs.get((int)i).arcDecoBox.setBranchEnd(true);
                    continue;
                }
                commonArcsIn.add(firstNetBranch.branchArcs.get(i));
                am.put(firstNetBranch.branchArcs.get(i), secondNetBranch.branchArcs.get(i));
                if (!commonNodesIn.contains(firstNetBranch.branchArcs.get(i).getStartNode())) {
                    commonNodesIn.add(firstNetBranch.branchArcs.get(i).getStartNode());
                    nm.put(firstNetBranch.branchArcs.get(i).getStartNode(), secondNetBranch.branchArcs.get(i).getStartNode());
                }
                if (commonNodesIn.contains(firstNetBranch.branchArcs.get(i).getEndNode())) continue;
                commonNodesIn.add(firstNetBranch.branchArcs.get(i).getEndNode());
                nm.put(firstNetBranch.branchArcs.get(i).getEndNode(), secondNetBranch.branchArcs.get(i).getEndNode());
                continue;
            }
            if (i == firstNetBranch.branchArcs.size() - 1 && i != secondNetBranch.branchArcs.size() - 1 || i != firstNetBranch.branchArcs.size() - 1 && i == secondNetBranch.branchArcs.size() - 1) {
                firstNetBranch.branchArcs.get((int)i).arcDecoBox.setBranchEnd(true);
            }
            commonArcsIn.add(firstNetBranch.branchArcs.get(i));
            am.put(firstNetBranch.branchArcs.get(i), secondNetBranch.branchArcs.get(i));
            if (!commonNodesIn.contains(firstNetBranch.branchArcs.get(i).getStartNode())) {
                commonNodesIn.add(firstNetBranch.branchArcs.get(i).getStartNode());
                nm.put(firstNetBranch.branchArcs.get(i).getStartNode(), secondNetBranch.branchArcs.get(i).getStartNode());
            }
            if (commonNodesIn.contains(firstNetBranch.branchArcs.get(i).getEndNode())) continue;
            commonNodesIn.add(firstNetBranch.branchArcs.get(i).getEndNode());
            nm.put(firstNetBranch.branchArcs.get(i).getEndNode(), secondNetBranch.branchArcs.get(i).getEndNode());
        }
        return new BranchBasedSubnet.Branch(commonNodesIn, commonArcsIn, bbs, nm, am);
    }

    private BranchBasedSubnet.Branch compareEqualSizeBranches(BranchBasedSubnet.Branch firstNetBranch, BranchBasedSubnet.Branch secondNetBranch, BranchBasedSubnet bbs, ArrayList<Node> commonNodesIn, ArrayList<Arc> commonArcsIn) {
        int i;
        HashMap<Node, Node> nm = new HashMap<Node, Node>();
        HashMap<Arc, Arc> am = new HashMap<Arc, Arc>();
        for (i = 0; i < firstNetBranch.branchArcs.size(); ++i) {
            if (firstNetBranch.branchArcs.get(i).getWeight() != secondNetBranch.branchArcs.get(i).getWeight()) {
                int arcWeight = Math.min(firstNetBranch.branchArcs.get(i).getWeight(), secondNetBranch.branchArcs.get(i).getWeight());
                if (arcWeight == 0) continue;
                firstNetBranch.branchArcs.get((int)i).arcDecoBox.setMemoryOfArcWeight(arcWeight);
                am.put(firstNetBranch.branchArcs.get(i), secondNetBranch.branchArcs.get(i));
                if (i == firstNetBranch.branchArcs.size() - 1 && i != secondNetBranch.branchArcs.size() - 1 || i != firstNetBranch.branchArcs.size() - 1 && i == secondNetBranch.branchArcs.size() - 1) {
                    firstNetBranch.branchArcs.get((int)i).arcDecoBox.setBranchEnd(true);
                }
                commonArcsIn.add(firstNetBranch.branchArcs.get(i));
                continue;
            }
            commonArcsIn.add(firstNetBranch.branchArcs.get(i));
            am.put(firstNetBranch.branchArcs.get(i), secondNetBranch.branchArcs.get(i));
        }
        for (i = 0; i < firstNetBranch.branchElements.size(); ++i) {
            nm.put(firstNetBranch.branchElements.get(i), secondNetBranch.branchElements.get(i));
        }
        commonNodesIn.addAll(firstNetBranch.branchElements);
        return new BranchBasedSubnet.Branch(commonNodesIn, commonArcsIn, bbs, nm, am);
    }

    private ArrayList<PartialSubnetElements> comparePTBranches(BranchBasedSubnet net1, BranchBasedSubnet net2) {
        ArrayList<Object> pseList = new ArrayList<Object>();
        for (int i = 0; i < net1.branchVertices.size(); ++i) {
            for (int j = 0; j < net2.branchVertices.size(); ++j) {
                PartialSubnetElements psePb;
                ArrayList<BranchBasedSubnet.Branch> branchNet2;
                ArrayList<BranchBasedSubnet.Branch> branchNet1;
                Object maxNodeArcSizePse;
                ArrayList listOfMaxElemets;
                PartialSubnetElements maxNodeSizePse;
                PartialSubnetElements pseTbl;
                ArrayList<PartialSubnetElements> lopPse;
                ArrayList<ArrayList<BranchBasedSubnet.Branch>> lvl2;
                if (!this.secondQuestion) {
                    PartialSubnetElements pseAb;
                    PartialSubnetElements psePb2 = this.comparePbranches(net1.branchVertices.get((int)i).pbranches, net2.branchVertices.get((int)j).pbranches, net1.branchVertices.get((int)i).root, net2.branchVertices.get((int)j).root);
                    if (net1.branchVertices.get((int)i).tbranch.stream().anyMatch(x -> x.startNode.equals(x.endNode)) || net2.branchVertices.get((int)j).tbranch.stream().anyMatch(x -> x.startNode.equals(x.endNode))) {
                        if (!this.thirdQuestion) {
                            ArrayList<ArrayList<BranchBasedSubnet.Branch>> lvl1 = this.allPossibleLoopTransformations(net1.branchVertices.get((int)i).tbranch);
                            lvl2 = this.allPossibleLoopTransformations(net2.branchVertices.get((int)j).tbranch);
                            lopPse = new ArrayList<PartialSubnetElements>();
                            for (ArrayList<BranchBasedSubnet.Branch> l1 : lvl1) {
                                for (ArrayList<BranchBasedSubnet.Branch> l2 : lvl2) {
                                    if (!l1.stream().anyMatch(x -> x.startNode.equals(x.endNode)) || l2.stream().anyMatch(x -> x.startNode.equals(x.endNode))) {
                                        // empty if block
                                    }
                                    pseTbl = this.comparePbranches(l1, l2, net1.branchVertices.get((int)i).root, net2.branchVertices.get((int)j).root);
                                    lopPse.add(pseTbl);
                                }
                            }
                            maxNodeSizePse = lopPse.stream().max(Comparator.comparing(PartialSubnetElements::matchingValueFunction)).orElse(new PartialSubnetElements(new ArrayList<Node>()));
                            listOfMaxElemets = lopPse.stream().filter(x -> x.partialNodes.size() == maxNodeSizePse.partialNodes.size()).collect(Collectors.toCollection(ArrayList::new));
                            maxNodeArcSizePse = listOfMaxElemets.stream().max(Comparator.comparing(PartialSubnetElements::matchingArcValueFunction)).orElse(new PartialSubnetElements(new ArrayList<Node>()));
                            pseAb = this.mergePartialSubnetElements(psePb2, (PartialSubnetElements)maxNodeArcSizePse);
                        } else if (net1.branchVertices.get((int)i).tbranchC.size() > 0 && net2.branchVertices.get((int)j).tbranchC.size() > 0) {
                            ArrayList<BranchBasedSubnet.Branch> listOfNoLoopBranchesF = new ArrayList<BranchBasedSubnet.Branch>(net1.branchVertices.get((int)i).tbranch);
                            listOfNoLoopBranchesF.removeAll(net1.branchVertices.get((int)i).tbranchC);
                            ArrayList<BranchBasedSubnet.Branch> listOfNoLoopBranchesS = new ArrayList<BranchBasedSubnet.Branch>(net2.branchVertices.get((int)j).tbranch);
                            listOfNoLoopBranchesS.removeAll(net2.branchVertices.get((int)j).tbranchC);
                            PartialSubnetElements pseTbS = this.comparePbranches(listOfNoLoopBranchesF, listOfNoLoopBranchesS, net1.branchVertices.get((int)i).root, net2.branchVertices.get((int)j).root);
                            PartialSubnetElements pseTbC = this.comparePbranches(net1.branchVertices.get((int)i).tbranchC, net2.branchVertices.get((int)j).tbranchC, net1.branchVertices.get((int)i).root, net2.branchVertices.get((int)j).root);
                            PartialSubnetElements pseTb = this.mergePartialSubnetElements(pseTbS, pseTbC);
                            pseAb = this.mergePartialSubnetElements(psePb2, pseTb);
                        } else if (net1.branchVertices.get((int)i).tbranchC.size() > 0) {
                            listOfNoLoopBranches = new ArrayList<BranchBasedSubnet.Branch>(net1.branchVertices.get((int)i).tbranch);
                            listOfNoLoopBranches.removeAll(net1.branchVertices.get((int)i).tbranchC);
                            pseTb = this.comparePbranches(listOfNoLoopBranches, net2.branchVertices.get((int)j).tbranch, net1.branchVertices.get((int)i).root, net2.branchVertices.get((int)j).root);
                            pseAb = this.mergePartialSubnetElements(psePb2, pseTb);
                        } else if (net2.branchVertices.get((int)j).tbranchC.size() > 0) {
                            listOfNoLoopBranches = new ArrayList<BranchBasedSubnet.Branch>(net2.branchVertices.get((int)j).tbranch);
                            listOfNoLoopBranches.removeAll(net2.branchVertices.get((int)j).tbranchC);
                            pseTb = this.comparePbranches(net1.branchVertices.get((int)i).tbranch, listOfNoLoopBranches, net1.branchVertices.get((int)i).root, net2.branchVertices.get((int)j).root);
                            pseAb = this.mergePartialSubnetElements(psePb2, pseTb);
                        } else {
                            pseTb = this.comparePbranches(net1.branchVertices.get((int)i).tbranch, net2.branchVertices.get((int)j).tbranch, net1.branchVertices.get((int)i).root, net2.branchVertices.get((int)j).root);
                            pseAb = this.mergePartialSubnetElements(psePb2, pseTb);
                        }
                    } else {
                        pseTb = this.comparePbranches(net1.branchVertices.get((int)i).tbranch, net2.branchVertices.get((int)j).tbranch, net1.branchVertices.get((int)i).root, net2.branchVertices.get((int)j).root);
                        pseAb = this.mergePartialSubnetElements(psePb2, pseTb);
                    }
                    pseList.add(pseAb);
                    continue;
                }
                if (this.thirdQuestion) {
                    branchNet1 = new ArrayList<BranchBasedSubnet.Branch>();
                    branchNet1.addAll(net1.branchVertices.get((int)i).pbranches);
                    branchNet1.addAll(net1.branchVertices.get((int)i).tbranch);
                    branchNet2 = new ArrayList<BranchBasedSubnet.Branch>();
                    branchNet2.addAll(net2.branchVertices.get((int)j).pbranches);
                    branchNet2.addAll(net2.branchVertices.get((int)j).tbranch);
                    psePb = this.comparePbranches(branchNet1, branchNet2, net1.branchVertices.get((int)i).root, net2.branchVertices.get((int)j).root);
                    pseList.add(psePb);
                    continue;
                }
                if (net1.branchVertices.get((int)i).tbranch.stream().anyMatch(x -> x.startNode.equals(x.endNode)) || net2.branchVertices.get((int)j).tbranch.stream().anyMatch(x -> x.startNode.equals(x.endNode))) {
                    branchNet1 = new ArrayList();
                    branchNet1.addAll(net1.branchVertices.get((int)i).pbranches);
                    branchNet1.addAll(net1.branchVertices.get((int)i).tbranch);
                    ArrayList<ArrayList<BranchBasedSubnet.Branch>> lvl1 = this.allPossibleLoopTransformations(branchNet1);
                    ArrayList<BranchBasedSubnet.Branch> branchNet22 = new ArrayList<BranchBasedSubnet.Branch>();
                    branchNet22.addAll(net2.branchVertices.get((int)j).pbranches);
                    branchNet22.addAll(net2.branchVertices.get((int)j).tbranch);
                    lvl2 = this.allPossibleLoopTransformations(branchNet22);
                    lopPse = new ArrayList();
                    for (ArrayList<BranchBasedSubnet.Branch> l1 : lvl1) {
                        for (ArrayList<BranchBasedSubnet.Branch> l2 : lvl2) {
                            if (!l1.stream().anyMatch(x -> x.startNode.equals(x.endNode)) || l2.stream().anyMatch(x -> x.startNode.equals(x.endNode))) {
                                // empty if block
                            }
                            pseTbl = this.comparePbranches(l1, l2, net1.branchVertices.get((int)i).root, net2.branchVertices.get((int)j).root);
                            lopPse.add(pseTbl);
                        }
                    }
                    maxNodeSizePse = lopPse.stream().max(Comparator.comparing(PartialSubnetElements::matchingValueFunction)).orElse(new PartialSubnetElements(new ArrayList<Node>()));
                    listOfMaxElemets = lopPse.stream().filter(x -> x.partialNodes.size() == maxNodeSizePse.partialNodes.size()).collect(Collectors.toCollection(ArrayList::new));
                    maxNodeArcSizePse = listOfMaxElemets.stream().max(Comparator.comparing(PartialSubnetElements::matchingArcValueFunction)).orElse(new PartialSubnetElements(new ArrayList<Node>()));
                    pseList.add(maxNodeArcSizePse);
                    continue;
                }
                branchNet1 = new ArrayList();
                branchNet1.addAll(net1.branchVertices.get((int)i).pbranches);
                branchNet1.addAll(net1.branchVertices.get((int)i).tbranch);
                branchNet2 = new ArrayList();
                branchNet2.addAll(net2.branchVertices.get((int)j).pbranches);
                branchNet2.addAll(net2.branchVertices.get((int)j).tbranch);
                psePb = this.comparePbranches(branchNet1, branchNet2, net1.branchVertices.get((int)i).root, net2.branchVertices.get((int)j).root);
                pseList.add(psePb);
            }
        }
        double max = pseList.stream().max(Comparator.comparing(x -> x.matchingValueFunction())).get().matchingValueFunction();
        return (ArrayList)pseList.stream().filter(x -> x.matchingValueFunction() == max).collect(Collectors.toList());
    }

    private ArrayList<ArrayList<BranchBasedSubnet.Branch>> allPossibleLoopTransformations(ArrayList<BranchBasedSubnet.Branch> tbranch) {
        ArrayList<ArrayList<BranchBasedSubnet.Branch>> result = new ArrayList<ArrayList<BranchBasedSubnet.Branch>>();
        ArrayList nonLoopBranches = tbranch.stream().filter(x -> !x.startNode.equals(x.endNode)).collect(Collectors.toCollection(ArrayList::new));
        ArrayList loopBranches = tbranch.stream().filter(x -> x.startNode.equals(x.endNode)).collect(Collectors.toCollection(ArrayList::new));
        result.add(nonLoopBranches);
        ArrayList extensions = new ArrayList();
        extensions.add(new ArrayList());
        while (loopBranches.size() > 0) {
            BranchBasedSubnet.Branch b1 = (BranchBasedSubnet.Branch)loopBranches.get(0);
            loopBranches.remove(b1);
            BranchBasedSubnet.Branch branch = loopBranches.stream().filter(x -> x.branchElements.containsAll(b1.branchElements)).findFirst().orElseThrow(NoSuchElementException::new);
            loopBranches.remove(branch);
            ArrayList nb1 = new ArrayList();
            nb1.addAll(nonLoopBranches);
            ArrayList nb2 = new ArrayList();
            nb2.addAll(nonLoopBranches);
            ArrayList toExtend = new ArrayList();
            for (ArrayList arrayList : extensions) {
                ArrayList<BranchBasedSubnet.Branch> sum = new ArrayList<BranchBasedSubnet.Branch>();
                sum.addAll(arrayList);
                sum.add(b1);
                toExtend.add(sum);
                sum = new ArrayList();
                sum.addAll(arrayList);
                sum.add(branch);
                toExtend.add(sum);
            }
            extensions = toExtend;
        }
        for (ArrayList arrayList : extensions) {
            if (nonLoopBranches.size() > 0) {
                result.add(this.instertLoopsIntoList(nonLoopBranches, arrayList));
                continue;
            }
            result.add(arrayList);
        }
        result.removeIf(x -> x.size() == 0);
        return result;
    }

    private ArrayList<BranchBasedSubnet.Branch> instertLoopsIntoList(ArrayList<BranchBasedSubnet.Branch> nonLoopBranches, ArrayList<BranchBasedSubnet.Branch> extes) {
        ArrayList<BranchBasedSubnet.Branch> result = new ArrayList<BranchBasedSubnet.Branch>();
        while (extes.size() > 0) {
            BranchBasedSubnet.Branch br = extes.get(0);
            extes.remove(0);
            boolean added = false;
            for (int i = 0; i < nonLoopBranches.size(); ++i) {
                boolean incoming = this.getDirection(br);
                result.add(nonLoopBranches.get(i));
                if ((nonLoopBranches.get((int)i).branchElements.size() >= br.branchElements.size() || this.getDirection(nonLoopBranches.get(i))) && !added) {
                    result.add(br);
                    added = true;
                    continue;
                }
                if (nonLoopBranches.get((int)i).branchElements.size() > br.branchElements.size() && this.getDirection(nonLoopBranches.get(i)) || added) continue;
                result.add(br);
                added = true;
            }
        }
        return result;
    }

    private boolean getDirection(BranchBasedSubnet.Branch br) {
        return br.branchElements.get(0).getInputArcs().stream().anyMatch(x -> x.getStartNode().equals(br.branchElements.get(1)));
    }

    private void printElements(BranchBasedSubnet.Branch br) {
        System.out.println("Node:");
        for (Node n : br.branchElements) {
            System.out.println(n.getName());
        }
        System.out.println("Arcs:");
        for (Arc a : br.branchArcs) {
            System.out.println(a.getStartNode().getName() + "-->" + a.getEndNode().getName());
        }
    }

    private void printElements(PartialSubnetElements psel) {
        System.out.println("Node:");
        for (Node n : psel.partialNodes) {
            System.out.println(n.getName());
        }
        System.out.println("Arcs:");
        for (Arc a : psel.partialArcs) {
            System.out.println(a.getStartNode().getName() + "-->" + a.getEndNode().getName());
        }
    }

    private ArrayList<PartialSubnetElements> comparePTMultiBranches(BranchBasedSubnet net1, BranchBasedSubnet net2) {
        ArrayList<ArrayList<RowMatch>> bm = this.calcBranchMatrix(net1, net2);
        bm = this.parseParallelBranches(bm);
        ArrayList<PartialSubnetElements> pseList = new ArrayList<PartialSubnetElements>();
        for (int i = 0; i < bm.size(); ++i) {
            ArrayList<BranchBasedSubnet.Branch> list;
            int j;
            System.out.println("New Branch matrxi matching");
            ArrayList<BranchBasedSubnet.Branch> listofProperTbranches = new ArrayList<BranchBasedSubnet.Branch>();
            ArrayList<BranchBasedSubnet.Branch> listofProperTbranchesForSecond = new ArrayList<BranchBasedSubnet.Branch>();
            ArrayList<ArrayList<BranchBasedSubnet.Branch>> listofInroperTbranches = new ArrayList<ArrayList<BranchBasedSubnet.Branch>>();
            ArrayList<ArrayList<BranchBasedSubnet.Branch>> listofInroperTbranchesForSecond = new ArrayList<ArrayList<BranchBasedSubnet.Branch>>();
            HashMap<Integer, Integer> maping = this.getMaping(bm.get(i));
            for (j = 0; j < bm.get(i).size(); ++j) {
                list = this.compareTbranch(bm.get((int)i).get((int)j).firstNetBranch, bm.get((int)i).get((int)j).secondNetBranch, net1);
                if (list.size() == 1) {
                    listofProperTbranches.addAll(list);
                } else if (list.size() == 2) {
                    listofInroperTbranches.add(list);
                } else if (!this.thirdQuestion) {
                    JOptionPane.showMessageDialog(null, "Tbranch nie znalaz\u0142 \u017eadnych branchy albo za du\u017eo... tak czy siak klocek", "TO CHECK", 0);
                }
                ArrayList<PartialSubnetElements> arrayList = new ArrayList<PartialSubnetElements>(pseList);
            }
            for (j = 0; j < bm.get(i).size(); ++j) {
                list = this.compareTbranch(bm.get((int)i).get((int)j).secondNetBranch, bm.get((int)i).get((int)j).firstNetBranch, net2);
                if (list.size() == 1) {
                    listofProperTbranchesForSecond.addAll(list);
                    continue;
                }
                if (list.size() == 2) {
                    listofInroperTbranchesForSecond.add(list);
                    continue;
                }
                if (this.thirdQuestion) continue;
                JOptionPane.showMessageDialog(null, "Tbranch nie znalaz\u0142 \u017eadnych branchy albo za du\u017eo... tak czy siak klocek", "TO CHECK", 0);
            }
            ArrayList<BranchBasedSubnet.BranchVertex> tempBVList = new ArrayList<BranchBasedSubnet.BranchVertex>(net1.branchVertices);
            ArrayList<PartialSubnetElements> listOfPBranches = new ArrayList<PartialSubnetElements>();
            for (BranchBasedSubnet.BranchVertex bv : net1.branchVertices) {
                int net2BVindex = this.getBrenachVertexIndex(net1, net2, maping, bv);
                if (net2BVindex == -1) continue;
                ArrayList<BranchBasedSubnet.Branch> listforFirst = new ArrayList<BranchBasedSubnet.Branch>(bv.pbranches);
                ArrayList<BranchBasedSubnet.Branch> listOfSecond = new ArrayList<BranchBasedSubnet.Branch>(net2.branchVertices.get((int)net2BVindex).pbranches);
                if (this.secondQuestion) {
                    ArrayList<BranchBasedSubnet.Branch> listOfLonelyForFirst = new ArrayList<BranchBasedSubnet.Branch>(bv.tbranch);
                    listOfLonelyForFirst.removeAll(listofProperTbranches);
                    for (BranchBasedSubnet.Branch branch : listofProperTbranches) {
                        ArrayList<BranchBasedSubnet.Branch> arrayList = new ArrayList<BranchBasedSubnet.Branch>();
                        for (BranchBasedSubnet.Branch td : listOfLonelyForFirst) {
                            if (!td.internalBranchElements.containsAll(branch.internalBranchElements) || !branch.internalBranchElements.containsAll(td.internalBranchElements) || !td.startNode.equals(branch.startNode) || !td.endNode.equals(branch.endNode)) continue;
                            arrayList.add(td);
                        }
                        listOfLonelyForFirst.removeAll(arrayList);
                    }
                    for (ArrayList arrayList : listofInroperTbranches) {
                        for (BranchBasedSubnet.Branch toR : arrayList) {
                            ArrayList<BranchBasedSubnet.Branch> toDelate2 = new ArrayList<BranchBasedSubnet.Branch>();
                            for (BranchBasedSubnet.Branch branch : listOfLonelyForFirst) {
                                if (!branch.internalBranchElements.containsAll(toR.internalBranchElements) && !toR.internalBranchElements.containsAll(branch.internalBranchElements)) continue;
                                toDelate2.add(branch);
                            }
                            listOfLonelyForFirst.removeAll(toDelate2);
                        }
                    }
                    listforFirst.addAll(listOfLonelyForFirst);
                    Collections.sort(listforFirst, new BranchBasedSubnet.Branch.LenghtSort());
                    ArrayList<BranchBasedSubnet.Branch> listOfLonelyForSecond = new ArrayList<BranchBasedSubnet.Branch>(net2.branchVertices.get((int)net2BVindex).tbranch);
                    listOfLonelyForSecond.removeAll(listofProperTbranchesForSecond);
                    listOfLonelyForSecond.removeAll(listofProperTbranchesForSecond);
                    for (BranchBasedSubnet.Branch branch : listofProperTbranchesForSecond) {
                        ArrayList toDelate3 = new ArrayList();
                        for (BranchBasedSubnet.Branch td : listOfLonelyForSecond) {
                            if (!td.internalBranchElements.containsAll(branch.internalBranchElements) || !branch.internalBranchElements.containsAll(td.internalBranchElements) || !branch.internalBranchElements.containsAll(td.internalBranchElements) || !td.startNode.equals(branch.startNode) || !td.endNode.equals(branch.endNode)) continue;
                            toDelate3.add(td);
                        }
                        listOfLonelyForSecond.removeAll(toDelate3);
                    }
                    for (ArrayList arrayList : listofInroperTbranchesForSecond) {
                        for (BranchBasedSubnet.Branch toR : arrayList) {
                            ArrayList<BranchBasedSubnet.Branch> toDelate4 = new ArrayList<BranchBasedSubnet.Branch>();
                            for (BranchBasedSubnet.Branch td2 : listOfLonelyForSecond) {
                                if (!td2.internalBranchElements.containsAll(toR.internalBranchElements) && !toR.internalBranchElements.containsAll(td2.internalBranchElements)) continue;
                                toDelate4.add(td2);
                            }
                            listOfLonelyForSecond.removeAll(toDelate4);
                        }
                    }
                    listOfSecond.addAll(listOfLonelyForSecond);
                    Collections.sort(listOfSecond, new BranchBasedSubnet.Branch.LenghtSort());
                }
                PartialSubnetElements psePb = this.comparePbranches(listforFirst, listOfSecond, bv.root, net2.branchVertices.get((int)net2BVindex).root);
                if (psePb.partialNodes.size() > 0) {
                    this.printElements(psePb);
                    listOfPBranches.add(psePb);
                }
                listforFirst = new ArrayList<BranchBasedSubnet.Branch>(bv.getSek());
                listOfSecond = new ArrayList<BranchBasedSubnet.Branch>(net2.branchVertices.get(net2BVindex).getSek());
                if (bv.getLoop().size() > 0 && net2.branchVertices.get(net2BVindex).getLoop().size() > 0) {
                    System.out.print("A " + bv.getLoop().size() + "  B " + net2.branchVertices.get(net2BVindex).getLoop().size());
                } else {
                    listforFirst.addAll(bv.getLoop());
                    listOfSecond.addAll(net2.branchVertices.get(net2BVindex).getLoop());
                }
                if (listforFirst.size() == 0 || listOfSecond.size() == 0) continue;
                PartialSubnetElements pseTb = null;
                if (!this.thirdQuestion) {
                    pseTb = this.comparePbranches(listforFirst, listOfSecond, bv.root, net2.branchVertices.get((int)net2BVindex).root);
                } else {
                    ArrayList arrayList = listforFirst.stream().filter(x -> x.startNode.equals(x.endNode)).collect(Collectors.toCollection(ArrayList::new));
                    ArrayList arrayList2 = listOfSecond.stream().filter(x -> x.startNode.equals(x.endNode)).collect(Collectors.toCollection(ArrayList::new));
                    ArrayList<BranchBasedSubnet.Branch> pathsF = new ArrayList<BranchBasedSubnet.Branch>(listforFirst);
                    ArrayList<BranchBasedSubnet.Branch> pathsS = new ArrayList<BranchBasedSubnet.Branch>(listOfSecond);
                    pathsF.removeAll(arrayList);
                    pathsS.removeAll(arrayList2);
                    PartialSubnetElements pseTbS = this.comparePbranches(pathsF, pathsS, bv.root, net2.branchVertices.get((int)net2BVindex).root);
                    PartialSubnetElements partialSubnetElements = this.comparePbranches(arrayList, arrayList2, bv.root, net2.branchVertices.get((int)net2BVindex).root);
                    pseTb = this.mergePartialSubnetElements(pseTbS, partialSubnetElements);
                }
                if (this.secondQuestion || pseTb.partialNodes.size() <= 0) continue;
                System.out.println("Dodaj\u0119 s\u0119k: ");
                this.printElements(pseTb);
                listOfPBranches.add(pseTb);
            }
            boolean finished = false;
            PartialSubnetElements pse = new PartialSubnetElements(new ArrayList<Node>());
            if (listOfPBranches.size() > 0) {
                pse = (PartialSubnetElements)listOfPBranches.get(0);
                listOfPBranches.remove(0);
            }
            while (listOfPBranches.size() > 0 || listofProperTbranches.size() > 0) {
                if (finished) {
                    pse = listOfPBranches.size() > 0 ? (PartialSubnetElements)listOfPBranches.get(0) : new PartialSubnetElements(new ArrayList<Node>());
                }
                boolean tbranchAdded = false;
                ArrayList<BranchBasedSubnet.Branch> toDelate = new ArrayList<BranchBasedSubnet.Branch>();
                for (BranchBasedSubnet.Branch br : listofProperTbranches) {
                    if (pse.partialNodes.size() > 0) {
                        ArrayList<Node> tmpList = new ArrayList<Node>(pse.partialNodes);
                        tmpList.retainAll(br.returnBorderNodes());
                        if (tmpList.size() <= 0) continue;
                        System.out.println("Dodaj\u0119 Tbranch:");
                        this.printElements(br);
                        pse = this.mergePartialSubnetElements(pse, new PartialSubnetElements(br.branchElements, br.branchArcs, br.nodeMap, br.arcMap));
                        toDelate.add(br);
                        tbranchAdded = true;
                        continue;
                    }
                    System.out.println("Dodaj\u0119 Tbranch:");
                    this.printElements(br);
                    pse = this.mergePartialSubnetElements(pse, new PartialSubnetElements(br.branchElements, br.branchArcs, br.nodeMap, br.arcMap));
                    toDelate.add(br);
                    tbranchAdded = true;
                }
                listofProperTbranches.removeAll(toDelate);
                boolean pbranchAdded = false;
                ArrayList<PartialSubnetElements> toDelate2 = new ArrayList<PartialSubnetElements>();
                for (PartialSubnetElements partialSubnetElements : listOfPBranches) {
                    ArrayList<Node> arrayList = new ArrayList<Node>(pse.partialNodes);
                    arrayList.retainAll(partialSubnetElements.partialNodes);
                    if (arrayList.size() <= 0) continue;
                    System.out.println("Dodaj\u0119 Pbranch:");
                    this.printElements(partialSubnetElements);
                    pse = this.mergePartialSubnetElements(pse, partialSubnetElements);
                    toDelate2.add(partialSubnetElements);
                    pbranchAdded = true;
                }
                listOfPBranches.removeAll(toDelate2);
                if ((tbranchAdded || pbranchAdded) && (listOfPBranches.size() > 0 || listofProperTbranches.size() > 0)) {
                    finished = false;
                    continue;
                }
                if (this.secondQuestion) {
                    // empty if block
                }
                if (listofInroperTbranches.size() > 0) {
                    ArrayList<PartialSubnetElements> listaPse = new ArrayList<PartialSubnetElements>();
                    listaPse.add(pse);
                    if (listaPse.size() > 1) {
                        System.out.println("Warum");
                    }
                    for (ArrayList arrayList : listofInroperTbranches) {
                        ArrayList<PartialSubnetElements> tmpListPse = new ArrayList<PartialSubnetElements>(listaPse);
                        for (PartialSubnetElements tmpPSE : listaPse) {
                            for (BranchBasedSubnet.Branch inpropBranch : arrayList) {
                                ArrayList<Node> tmpList = new ArrayList<Node>(tmpPSE.partialNodes);
                                tmpList.retainAll(inpropBranch.returnBorderNodes());
                                if (tmpList.size() <= 0) continue;
                                PartialSubnetElements newPSE = this.mergePartialSubnetElements(tmpPSE, new PartialSubnetElements(inpropBranch.branchElements, inpropBranch.branchArcs, inpropBranch.nodeMap, inpropBranch.arcMap));
                                tmpListPse.add(newPSE);
                            }
                            this.cleanArcs(listaPse);
                        }
                        listaPse = tmpListPse;
                    }
                    finished = true;
                    pseList.addAll(listaPse);
                    if (!this.secondQuestion) continue;
                }
                finished = true;
                this.cleanArcs(pse);
                pseList.add(pse);
            }
        }
        pseList.addAll(this.findSingleBranchMatching(net1, net2));
        for (PartialSubnetElements pse : pseList) {
            pse.check();
        }
        if (pseList.size() == 0) {
            PartialSubnetElements pse = new PartialSubnetElements(new ArrayList<Node>(), new ArrayList<Arc>());
            pseList.add(pse);
            return pseList;
        }
        double max = pseList.stream().max(Comparator.comparing(x -> x.matchingValueFunction())).get().matchingValueFunction();
        return (ArrayList)pseList.stream().filter(x -> x.matchingValueFunction() == max).collect(Collectors.toList());
    }

    private ArrayList<PartialSubnetElements> findSingleBranchMatching(BranchBasedSubnet net1, BranchBasedSubnet net2) {
        ArrayList<PartialSubnetElements> psel = new ArrayList<PartialSubnetElements>();
        for (BranchBasedSubnet.BranchVertex bv1 : net1.branchVertices) {
            BranchBasedSubnet bns = new BranchBasedSubnet(bv1);
            psel.addAll(this.comparePTBranches(bns, net2));
        }
        return psel;
    }

    private PartialSubnetElements removeBrancheEndElements(PartialSubnetElements pse) {
        ArrayList toReduce = pse.partialArcs.stream().filter(x -> x.arcDecoBox.isBranchEnd()).collect(Collectors.toCollection(ArrayList::new));
        for (Arc a : toReduce) {
            int k = pse.partialArcs.stream().filter(x -> x.getStartNode().equals(a.getStartNode())).collect(Collectors.toCollection(ArrayList::new)).size();
            int l = pse.partialArcs.stream().filter(x -> x.getEndNode().equals(a.getEndNode())).collect(Collectors.toCollection(ArrayList::new)).size();
            if (k <= 1 && l <= 1) continue;
            pse.partialArcs.remove(a);
            ArrayList<Arc> arcsS = new ArrayList<Arc>(a.getStartNode().getNeighborsArcs());
            arcsS.retainAll(pse.partialArcs);
            ArrayList<Arc> arcsE = new ArrayList<Arc>(a.getEndNode().getNeighborsArcs());
            arcsE.retainAll(pse.partialArcs);
            if (arcsS.size() == 1 && k > 1) {
                pse.partialNodes.remove(a.getStartNode());
                pse.partialArcs.remove(a);
            }
            if (arcsE.size() != 1 || l <= 1) continue;
            pse.partialNodes.remove(a.getEndNode());
            pse.partialArcs.remove(a);
        }
        return pse;
    }

    private void cleanArcs(PartialSubnetElements pse) {
        for (Arc a : pse.partialArcs) {
            a.arcDecoBox.setBranchEnd(false);
        }
    }

    private void cleanArcs(ArrayList<PartialSubnetElements> psel) {
        for (PartialSubnetElements pse : psel) {
            for (Arc a : pse.partialArcs) {
                a.arcDecoBox.setBranchEnd(false);
            }
        }
    }

    private int getBrenachVertexIndex(BranchBasedSubnet net1, BranchBasedSubnet net2, HashMap<Integer, Integer> maping, BranchBasedSubnet.BranchVertex bv) {
        Integer net2TIndex = maping.get(net1.transitions.indexOf(bv.root));
        if (net2TIndex == null) {
            return -1;
        }
        Node jebanyNode = net2.transitions.get(net2TIndex);
        ArrayList tmp = net2.branchVertices.stream().filter(x -> x.root.getID() == jebanyNode.getID()).collect(Collectors.toCollection(ArrayList::new));
        if (tmp.size() == 0) {
            return -1;
        }
        int jebanyIndex = net2.branchVertices.indexOf(tmp.get(0));
        return jebanyIndex;
    }

    private HashMap<Integer, Integer> getMaping(ArrayList<RowMatch> rowMatches) {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        for (RowMatch rm : rowMatches) {
            map.put(rm.firstNetRowIndex, rm.mapOfFNR);
            map.put(rm.seconNetRowIndex, rm.mapOfSNR);
        }
        return map;
    }

    private ArrayList<ArrayList<RowMatch>> parseParallelBranches(ArrayList<ArrayList<RowMatch>> bm) {
        ArrayList<ArrayList<RowMatch>> parsed = new ArrayList<ArrayList<RowMatch>>();
        for (ArrayList<RowMatch> rm : bm) {
            ArrayList toParse = new ArrayList();
            int count = 0;
            System.out.println("RM - : " + rm.size());
            while (rm.size() > 0) {
                System.out.println("Count : - " + count);
                ++count;
                RowMatch sinleMatcg = rm.get(0);
                ArrayList parallel = rm.stream().filter(x -> x.startNodeNet2.equals(sinleMatcg.startNodeNet2) && x.endNodeNet2.equals(sinleMatcg.endNodeNet2)).collect(Collectors.toCollection(ArrayList::new));
                System.out.println("Parallel size - " + parallel.size());
                System.out.println("Znalezione - " + toParse.size());
                if (parallel.size() > 1) {
                    ArrayList<ArrayList<RowMatch>> packts = this.calcPacketsToAdd(parallel);
                    rm.removeAll(parallel);
                    ArrayList arrayList = new ArrayList();
                    if (toParse.size() != 0) {
                        for (ArrayList<RowMatch> para : packts) {
                            ArrayList multiple = new ArrayList(toParse);
                            for (ArrayList d : multiple) {
                                ArrayList<RowMatch> tmp = new ArrayList<RowMatch>(d);
                                tmp.addAll(para);
                                arrayList.add(tmp);
                            }
                        }
                        toParse = arrayList;
                        continue;
                    }
                    for (ArrayList<RowMatch> p : packts) {
                        ArrayList<RowMatch> pr = new ArrayList<RowMatch>();
                        pr.addAll(p);
                        toParse.add(pr);
                    }
                    continue;
                }
                rm.removeAll(parallel);
                if (toParse.size() != 0) {
                    for (ArrayList arrayList : toParse) {
                        arrayList.addAll(parallel);
                    }
                    continue;
                }
                toParse.add(new ArrayList(parallel));
            }
            parsed.addAll(toParse);
        }
        return parsed;
    }

    private ArrayList<ArrayList<RowMatch>> calcPacketsToAdd(ArrayList<RowMatch> parallel) {
        ArrayList<ArrayList<RowMatch>> result = new ArrayList<ArrayList<RowMatch>>();
        ArrayList<ArrayList> sorting = new ArrayList<ArrayList>();
        ArrayList sortingProp = new ArrayList();
        ArrayList<RowMatch> localCoppy = new ArrayList<RowMatch>(parallel);
        while (localCoppy.size() > 0) {
            ArrayList p = localCoppy.stream().filter(x -> x.firstNetBranch.equals(((RowMatch)localCoppy.get((int)0)).firstNetBranch)).collect(Collectors.toCollection(ArrayList::new));
            localCoppy.removeAll(p);
            sorting.add(p);
        }
        for (int j = 0; j < sorting.size(); ++j) {
            sortingProp.add(new ArrayList());
        }
        for (int i = 0; i < ((ArrayList)sorting.get(0)).size(); ++i) {
            BranchBasedSubnet.Branch branch = ((RowMatch)((ArrayList)sorting.get((int)0)).get((int)i)).secondNetBranch;
            for (int j = 0; j < sorting.size(); ++j) {
                RowMatch rm = (RowMatch)((ArrayList)sorting.get(j)).stream().filter(x -> x.secondNetBranch.equals(branch)).collect(Collectors.toCollection(ArrayList::new)).get(0);
                ((ArrayList)sortingProp.get(j)).add(rm);
            }
        }
        int[][] latin = this.calcLatin(Math.max(sortingProp.size(), ((ArrayList)sortingProp.get(0)).size()));
        System.out.println(sortingProp.size());
        System.out.println(((ArrayList)sortingProp.get(0)).size());
        for (int k = 0; k < sortingProp.size() || k < ((ArrayList)sortingProp.get(0)).size(); ++k) {
            ArrayList<RowMatch> list = new ArrayList<RowMatch>();
            for (int i = 0; i < sortingProp.size(); ++i) {
                for (int j = 0; j < ((ArrayList)sortingProp.get(i)).size(); ++j) {
                    if (latin[i][j] != k) continue;
                    list.add((RowMatch)((ArrayList)sortingProp.get(i)).get(j));
                }
            }
            result.add(list);
        }
        return result;
    }

    int[][] calcLatin(int n) {
        int[][] latin = new int[n][n];
        int k = n + 1;
        for (int i = 0; i < latin.length; ++i) {
            int counter = i;
            for (int j = 0; j < latin[i].length; ++j) {
                latin[i][j] = counter;
                System.out.print(counter);
                if (++counter < n) continue;
                counter = 0;
            }
            System.out.println("");
        }
        return latin;
    }

    private ArrayList<PartialSubnetElements> comparePaths(SubnetCalculator.Path path1, SubnetCalculator.Path path2) {
        ArrayList<SubnetCalculator.Path> allPaths;
        ArrayList<PartialSubnetElements> pseList = new ArrayList<PartialSubnetElements>();
        if (!path1.isCycle && !path2.isCycle) {
            pseList.addAll(this.findCommonPartsInPaths(path1, path2));
        }
        if (!path1.isCycle && path2.isCycle) {
            allPaths = this.calcPathsFromCycle(path2);
            for (SubnetCalculator.Path path : allPaths) {
                pseList.addAll(this.findCommonPartsInPaths(path1, path));
            }
        }
        if (path1.isCycle && !path2.isCycle) {
            allPaths = this.calcPathsFromCycle(path1);
            for (SubnetCalculator.Path path : allPaths) {
                pseList.addAll(this.findCommonPartsInPaths(path, path2));
            }
        }
        if (path1.isCycle && path2.isCycle) {
            ArrayList<SubnetCalculator.Path> allPaths1 = this.calcPathsFromCycle(path1);
            ArrayList<SubnetCalculator.Path> allPaths2 = this.calcPathsFromCycle(path2);
            for (SubnetCalculator.Path pathFrom1 : allPaths1) {
                for (SubnetCalculator.Path pathFrom2 : allPaths2) {
                    pseList.addAll(this.findCommonPartsInPaths(pathFrom1, pathFrom2));
                }
            }
        }
        return pseList;
    }

    private ArrayList<SubnetCalculator.Path> calcPathsFromCycle(SubnetCalculator.Path path2) {
        ArrayList<SubnetCalculator.Path> result = new ArrayList<SubnetCalculator.Path>();
        SubnetCalculator.Path firstPath = new SubnetCalculator.Path(path2.path.get(0), path2.path.get(0), path2.path);
        firstPath.path.add(path2.startNode);
        result.add(firstPath);
        for (int i = 1; i < path2.path.size() - 1; ++i) {
            int j;
            ArrayList<Node> newNodeList = new ArrayList<Node>();
            ArrayList twoParts = new ArrayList();
            ArrayList<Node> nl = new ArrayList<Node>();
            ArrayList<Node> nm = new ArrayList<Node>();
            for (j = i; j < path2.path.size(); ++j) {
                nl.add(path2.path.get(j));
            }
            for (j = 0; j < i; ++j) {
                nm.add(path2.path.get(j));
            }
            newNodeList.addAll(nl);
            newNodeList.addAll(nm);
            newNodeList.add((Node)nl.get(0));
            SubnetCalculator.Path newPath = new SubnetCalculator.Path(path2.path.get(i), path2.path.get(i), newNodeList);
            result.add(newPath);
        }
        return result;
    }

    private ArrayList<PartialSubnetElements> findCommonPartsInPaths(SubnetCalculator.Path path1, SubnetCalculator.Path path2) {
        ArrayList<PartialSubnetElements> pseList = new ArrayList<PartialSubnetElements>();
        ArrayList<ArrayList<Node>> commonNodes = new ArrayList<ArrayList<Node>>();
        ArrayList<ArrayList<Arc>> commonArcs = new ArrayList<ArrayList<Arc>>();
        ArrayList<Node> commonN = new ArrayList<Node>();
        ArrayList<Arc> commonA = new ArrayList<Arc>();
        if (!this.secondQuestion) {
            if (path1.path.get(0).getType().equals((Object)path2.path.get(0).getType()) && path1.path.get(path1.path.size() - 1).getType().equals((Object)path2.path.get(path2.path.size() - 1).getType()) || path1.path.get(0).getType().equals((Object)path2.path.get(path2.path.size() - 1).getType()) && path1.path.get(path1.path.size() - 1).getType().equals((Object)path2.path.get(0).getType())) {
                pseList.addAll(this.choleraJakToNazwe(path1, path2, commonNodes, commonArcs, commonN, commonA));
            }
        } else {
            pseList.addAll(this.choleraJakToNazwe(path1, path2, commonNodes, commonArcs, commonN, commonA));
        }
        return pseList;
    }

    private ArrayList<PartialSubnetElements> choleraJakToNazwe(SubnetCalculator.Path path1, SubnetCalculator.Path path2, ArrayList<ArrayList<Node>> commonNodes, ArrayList<ArrayList<Arc>> commonArcs, ArrayList<Node> commonN, ArrayList<Arc> commonA) {
        int j;
        ArrayList nml = new ArrayList();
        ArrayList aml = new ArrayList();
        HashMap<Node, Node> nm = new HashMap<Node, Node>();
        HashMap<Arc, Arc> am = new HashMap<Arc, Arc>();
        ArrayList<PartialSubnetElements> pseList = new ArrayList<PartialSubnetElements>();
        if (path1.path.get(0).getType().equals((Object)path2.path.get(0).getType())) {
            for (j = 0; j < path1.path.size() - 1 && j < path2.path.size() - 1; ++j) {
                int arcWeight = 0;
                ArrayList<Arc> arcFrom1 = this.getArc(path1.path.get(j), path1.path.get(j + 1));
                ArrayList<Arc> arcFrom2 = this.getArc(path2.path.get(j), path2.path.get(j + 1));
                if (!arcFrom1.isEmpty() && !arcFrom2.isEmpty()) {
                    arcWeight = Math.min(arcFrom1.get(0).getWeight(), arcFrom2.get(0).getWeight());
                }
                if (arcWeight == 0) break;
                arcFrom1.get((int)0).arcDecoBox.setMemoryOfArcWeight(arcWeight);
                if (!commonN.contains(path1.path.get(j))) {
                    commonN.add(path1.path.get(j));
                    nm.put(path1.path.get(j), path2.path.get(j));
                }
                if (!commonN.contains(path1.path.get(j + 1)) && !path2.path.get(j + 1).equals(path2.path.get(0))) {
                    commonN.add(path1.path.get(j + 1));
                    nm.put(path1.path.get(j + 1), path2.path.get(j + 1));
                    commonA.add(arcFrom1.get(0));
                    am.put(arcFrom1.get(0), arcFrom2.get(0));
                }
                if (!path1.path.get(0).equals(arcFrom1.get(0).getEndNode()) || !path2.path.get(0).equals(arcFrom2.get(0).getEndNode())) continue;
                commonA.add(arcFrom1.get(0));
                am.put(arcFrom1.get(0), arcFrom2.get(0));
            }
            nml.add(nm);
            aml.add(am);
            nm = new HashMap();
            am = new HashMap();
            commonNodes.add(commonN);
            commonArcs.add(commonA);
        } else {
            ArrayList<Node> shortPath1 = new ArrayList<Node>(path1.path);
            shortPath1.remove(0);
            if (!this.firstQuestion) {
                commonN.add(shortPath1.get(0));
                nm.put(shortPath1.get(0), path2.path.get(0));
            }
            for (int j2 = 0; j2 < shortPath1.size() - 1 && j2 < path2.path.size() - 1; ++j2) {
                int arcWeight = 0;
                ArrayList<Arc> arcFrom1 = this.getArc(shortPath1.get(j2), shortPath1.get(j2 + 1));
                ArrayList<Arc> arcFrom2 = this.getArc(path2.path.get(j2), path2.path.get(j2 + 1));
                if (!arcFrom1.isEmpty() && !arcFrom2.isEmpty()) {
                    arcWeight = Math.min(arcFrom1.get(0).getWeight(), arcFrom2.get(0).getWeight());
                }
                if (arcWeight == 0) break;
                arcFrom1.get((int)0).arcDecoBox.setMemoryOfArcWeight(arcWeight);
                if (!commonN.contains(shortPath1.get(j2))) {
                    commonN.add(shortPath1.get(j2));
                    nm.put(shortPath1.get(j2), path2.path.get(j2));
                }
                if (!commonN.contains(shortPath1.get(j2 + 1)) && !path2.path.get(j2 + 1).equals(path2.path.get(0))) {
                    commonN.add(shortPath1.get(j2 + 1));
                    nm.put(shortPath1.get(j2 + 1), path2.path.get(j2 + 1));
                    commonA.add(arcFrom1.get(0));
                    am.put(arcFrom1.get(0), arcFrom2.get(0));
                }
                if (!path1.path.get(0).equals(arcFrom1.get(0).getEndNode()) || !path2.path.get(0).equals(arcFrom2.get(0).getEndNode())) continue;
                commonA.add(arcFrom1.get(0));
                am.put(arcFrom1.get(0), arcFrom2.get(0));
            }
            commonNodes.add(commonN);
            commonArcs.add(commonA);
            nml.add(nm);
            aml.add(am);
            nm = new HashMap();
            am = new HashMap();
            commonN = new ArrayList();
            commonA = new ArrayList();
            ArrayList<Node> shortPath2 = new ArrayList<Node>(path2.path);
            shortPath2.remove(0);
            for (int j3 = 0; j3 < path1.path.size() - 1 && j3 < shortPath2.size() - 1; ++j3) {
                int arcWeight = 0;
                ArrayList<Arc> arcFrom1 = this.getArc(path1.path.get(j3), path1.path.get(j3 + 1));
                ArrayList<Arc> arcFrom2 = this.getArc(shortPath2.get(j3), shortPath2.get(j3 + 1));
                if (!arcFrom1.isEmpty() && !arcFrom2.isEmpty()) {
                    arcWeight = Math.min(arcFrom1.get(0).getWeight(), arcFrom2.get(0).getWeight());
                }
                if (arcWeight == 0) break;
                arcFrom1.get((int)0).arcDecoBox.setMemoryOfArcWeight(arcWeight);
                if (!commonN.contains(path1.path.get(j3))) {
                    commonN.add(path1.path.get(j3));
                    nm.put(path1.path.get(j3), shortPath2.get(j3));
                }
                if (!commonN.contains(path1.path.get(j3 + 1)) && !path2.path.get(j3 + 1).equals(path2.path.get(0))) {
                    commonN.add(path1.path.get(j3 + 1));
                    nm.put(path1.path.get(j3 + 1), shortPath2.get(j3 + 1));
                    commonA.add(arcFrom1.get(0));
                    am.put(arcFrom1.get(0), arcFrom2.get(0));
                }
                if (!path1.path.get(0).equals(arcFrom1.get(0).getEndNode()) || !path2.path.get(0).equals(arcFrom2.get(0).getEndNode())) continue;
                commonA.add(arcFrom1.get(0));
                am.put(arcFrom1.get(0), arcFrom2.get(0));
            }
            commonNodes.add(commonN);
            commonArcs.add(commonA);
            nml.add(nm);
            aml.add(am);
            nm = new HashMap();
            am = new HashMap();
        }
        commonN = new ArrayList();
        commonA = new ArrayList();
        if (path1.path.get(path1.path.size() - 1).getType().equals((Object)path2.path.get(path2.path.size() - 1).getType())) {
            for (j = Math.min(path1.path.size(), path2.path.size()) - 1; j > 0; --j) {
                int move = Math.abs(path1.path.size() - path2.path.size());
                int firstMove = 0;
                int secondMobe = 0;
                if (move != 0) {
                    if (path1.path.size() > path2.path.size()) {
                        firstMove = move;
                    } else {
                        secondMobe = move;
                    }
                }
                int arcWeight = 0;
                ArrayList<Arc> arcFrom1 = this.getArc(path1.path.get(j + firstMove - 1), path1.path.get(j + firstMove));
                ArrayList<Arc> arcFrom2 = this.getArc(path2.path.get(j + secondMobe - 1), path2.path.get(j + secondMobe));
                if (arcFrom1.isEmpty() || arcFrom2.isEmpty()) continue;
                arcWeight = Math.min(arcFrom1.get(0).getWeight(), arcFrom2.get(0).getWeight());
                if (arcWeight == 0) break;
                arcFrom1.get((int)0).arcDecoBox.setMemoryOfArcWeight(arcWeight);
                if (!commonN.contains(path1.path.get(j + firstMove))) {
                    commonN.add(path1.path.get(j + firstMove));
                    nm.put(path1.path.get(j + firstMove), path2.path.get(j + secondMobe));
                }
                if (!commonN.contains(path1.path.get(j + firstMove - 1)) && !path2.path.get(j + secondMobe - 1).equals(path2.path.get(0))) {
                    commonN.add(path1.path.get(j + firstMove - 1));
                    nm.put(path1.path.get(j + firstMove - 1), path2.path.get(j + secondMobe - 1));
                    commonA.add(arcFrom1.get(0));
                    am.put(arcFrom1.get(0), arcFrom2.get(0));
                }
                if (!path1.path.get(0).equals(arcFrom1.get(0).getEndNode()) || !path2.path.get(0).equals(arcFrom2.get(0).getEndNode())) continue;
                commonA.add(arcFrom1.get(0));
                am.put(arcFrom1.get(0), arcFrom2.get(0));
            }
            commonNodes.add(commonN);
            commonArcs.add(commonA);
            nml.add(nm);
            aml.add(am);
            nm = new HashMap();
            am = new HashMap();
        } else {
            ArrayList<Node> shortPath1 = new ArrayList<Node>(path1.path);
            shortPath1.remove(shortPath1.size() - 1);
            if (!this.firstQuestion) {
                commonN.add(shortPath1.get(shortPath1.size() - 1));
            }
            for (int j4 = Math.min(shortPath1.size(), path2.path.size()) - 1; j4 > 0; --j4) {
                int move = Math.abs(shortPath1.size() - path2.path.size());
                int firstMove = 0;
                int secondMobe = 0;
                if (move != 0) {
                    if (shortPath1.size() > path2.path.size()) {
                        firstMove = move;
                    } else {
                        secondMobe = move;
                    }
                }
                int arcWeight = 0;
                ArrayList<Arc> arcFrom1 = this.getArc(shortPath1.get(j4 + firstMove - 1), shortPath1.get(j4 + firstMove));
                ArrayList<Arc> arcFrom2 = this.getArc(path2.path.get(j4 + secondMobe - 1), path2.path.get(j4 + secondMobe));
                if (arcFrom1.isEmpty() || arcFrom2.isEmpty()) continue;
                arcWeight = Math.min(arcFrom1.get(0).getWeight(), arcFrom2.get(0).getWeight());
                if (arcWeight == 0) break;
                arcFrom1.get((int)0).arcDecoBox.setMemoryOfArcWeight(arcWeight);
                if (!commonN.contains(shortPath1.get(j4 + firstMove))) {
                    commonN.add(shortPath1.get(j4 + firstMove));
                    nm.put(shortPath1.get(j4 + firstMove), path2.path.get(j4 + secondMobe));
                }
                if (!commonN.contains(shortPath1.get(j4 + firstMove - 1)) && !path2.path.get(j4 + secondMobe - 1).equals(path2.path.get(0))) {
                    commonN.add(shortPath1.get(j4 + firstMove - 1));
                    nm.put(shortPath1.get(j4 + firstMove - 1), path2.path.get(j4 + secondMobe - 1));
                    commonA.add(arcFrom1.get(0));
                    am.put(arcFrom1.get(0), arcFrom2.get(0));
                }
                if (!path1.path.get(0).equals(arcFrom1.get(0).getEndNode()) || !path2.path.get(0).equals(arcFrom2.get(0).getEndNode())) continue;
                commonA.add(arcFrom1.get(0));
                am.put(arcFrom1.get(0), arcFrom2.get(0));
            }
            commonNodes.add(commonN);
            commonArcs.add(commonA);
            commonN = new ArrayList();
            commonA = new ArrayList();
            nml.add(nm);
            aml.add(am);
            nm = new HashMap();
            am = new HashMap();
            ArrayList<Node> shortPath2 = new ArrayList<Node>(path2.path);
            shortPath2.remove(shortPath2.size() - 1);
            for (int j5 = Math.min(path1.path.size(), shortPath2.size()) - 1; j5 > 0; --j5) {
                int move = Math.abs(path1.path.size() - shortPath2.size());
                int firstMove = 0;
                int secondMobe = 0;
                if (move != 0) {
                    if (path1.path.size() > shortPath2.size()) {
                        firstMove = move;
                    } else {
                        secondMobe = move;
                    }
                }
                int arcWeight = 0;
                ArrayList<Arc> arcFrom1 = this.getArc(path1.path.get(j5 + firstMove - 1), path1.path.get(j5 + firstMove));
                ArrayList<Arc> arcFrom2 = this.getArc(shortPath2.get(j5 + secondMobe - 1), shortPath2.get(j5 + secondMobe));
                if (arcFrom1.isEmpty() || arcFrom2.isEmpty()) continue;
                arcWeight = Math.min(arcFrom1.get(0).getWeight(), arcFrom2.get(0).getWeight());
                if (arcWeight == 0) break;
                arcFrom1.get((int)0).arcDecoBox.setMemoryOfArcWeight(arcWeight);
                if (!commonN.contains(path1.path.get(j5 + firstMove))) {
                    commonN.add(path1.path.get(j5 + firstMove));
                    nm.put(path1.path.get(j5 + firstMove), shortPath2.get(j5 + secondMobe));
                }
                if (!commonN.contains(path1.path.get(j5 + firstMove - 1)) && !shortPath2.get(j5 + secondMobe - 1).equals(shortPath2.get(0))) {
                    commonN.add(path1.path.get(j5 + firstMove - 1));
                    nm.put(path1.path.get(j5 + firstMove - 1), shortPath2.get(j5 + secondMobe - 1));
                    commonA.add(arcFrom1.get(0));
                    am.put(arcFrom1.get(0), arcFrom2.get(0));
                }
                if (!path1.path.get(0).equals(arcFrom1.get(0).getEndNode()) || !shortPath2.get(0).equals(arcFrom2.get(0).getEndNode())) continue;
                commonA.add(arcFrom1.get(0));
                am.put(arcFrom1.get(0), arcFrom2.get(0));
            }
            commonNodes.add(commonN);
            commonArcs.add(commonA);
            nml.add(nm);
            aml.add(am);
            nm = new HashMap();
            am = new HashMap();
        }
        for (int i = 0; i < commonNodes.size(); ++i) {
            PartialSubnetElements pse = new PartialSubnetElements(commonNodes.get(i), commonArcs.get(i));
            pse.nodesMap = (HashMap)nml.get(i);
            pse.arcsMap = (HashMap)aml.get(i);
            if (pse.partialNodes.size() <= 0) continue;
            pseList.add(pse);
        }
        return pseList;
    }

    private ArrayList<PartialSubnetElements> compareTbranches(ArrayList<BranchBasedSubnet.Branch> firstNetBranch, ArrayList<BranchBasedSubnet.Branch> secondNetBranch, Node root) {
        ArrayList<PartialSubnetElements> pseList = new ArrayList<PartialSubnetElements>();
        return pseList;
    }

    private PartialSubnetElements comparePbranches(ArrayList<BranchBasedSubnet.Branch> pbranches1, ArrayList<BranchBasedSubnet.Branch> pbranches2, Node root1, Node root2) {
        HashMap<Node, Node> nm = new HashMap<Node, Node>();
        HashMap<Arc, Arc> am = new HashMap<Arc, Arc>();
        Collections.sort(pbranches1, new BranchBasedSubnet.Branch.LenghtSort());
        Collections.sort(pbranches2, new BranchBasedSubnet.Branch.LenghtSort());
        Collections.reverse(pbranches1);
        Collections.reverse(pbranches2);
        ArrayList<BranchBasedSubnet.Branch> incomingBranches1 = this.getIncomingBranches(pbranches1, root1);
        ArrayList<BranchBasedSubnet.Branch> incomingBranches2 = this.getIncomingBranches(pbranches2, root2);
        ArrayList<BranchBasedSubnet.Branch> outgoingBranches1 = this.getOutgoingBranches(pbranches1, root1);
        ArrayList<BranchBasedSubnet.Branch> outgoingBranches2 = this.getOutgoingBranches(pbranches2, root2);
        PartialSubnetElements pse = this.getPartialSubnetElements(pbranches1, pbranches2, root1, root2, nm, am, incomingBranches1, incomingBranches2, outgoingBranches1, outgoingBranches2);
        return pse;
    }

    private PartialSubnetElements getPartialSubnetElements(ArrayList<BranchBasedSubnet.Branch> pbranches1, ArrayList<BranchBasedSubnet.Branch> pbranches2, Node root1, Node root2, HashMap<Node, Node> nm, HashMap<Arc, Arc> am, ArrayList<BranchBasedSubnet.Branch> incomingBranches1, ArrayList<BranchBasedSubnet.Branch> incomingBranches2, ArrayList<BranchBasedSubnet.Branch> outgoingBranches1, ArrayList<BranchBasedSubnet.Branch> outgoingBranches2) {
        ArrayList<Node> commonNodes = new ArrayList<Node>();
        ArrayList<Arc> commonArcs = new ArrayList<Arc>();
        if (pbranches1.size() == 0 && pbranches2.size() == 0) {
            commonNodes.add(root1);
            return new PartialSubnetElements(commonNodes, commonArcs);
        }
        if (pbranches1.size() == 0 && pbranches2.size() > 0) {
            commonNodes.add(root1);
            return new PartialSubnetElements(commonNodes, commonArcs);
        }
        if (pbranches1.size() > 0 && pbranches2.size() == 0) {
            commonNodes.add(root2);
            return new PartialSubnetElements(commonNodes, commonArcs);
        }
        ArrayList<Node> usedFromsecond = new ArrayList<Node>();
        int cF = 0;
        int cS = 0;
        int i = 0;
        while (i + cF < incomingBranches1.size() && i + cS < incomingBranches2.size()) {
            BranchBasedSubnet.Branch inf = incomingBranches1.get(i);
            BranchBasedSubnet.Branch ins = incomingBranches2.get(i);
            int move = Math.abs(inf.branchElements.size() - ins.branchElements.size());
            int firstMove = 0;
            int secondMobe = 0;
            if (move != 0) {
                if (inf.branchElements.size() > ins.branchElements.size()) {
                    firstMove = move;
                } else {
                    secondMobe = move;
                }
            }
            for (int k = 0; k < inf.branchElements.size(); ++k) {
                System.out.println(inf.branchElements.get(k).getName());
            }
            System.out.println("root " + root1.getName() + " z brancha " + inf.branchElements.get(0 + firstMove).getName());
            ArrayList inComing = new ArrayList();
            if (ins.branchArcs.get(0).getEndNode().equals(root2)) {
                // empty if block
            }
            for (int j = 0; j < Math.min(inf.branchArcs.size(), ins.branchArcs.size()); ++j) {
                int arcWeight = 0;
                ArrayList<Arc> arcFrom1 = new ArrayList<Arc>();
                ArrayList<Arc> arcFrom2 = new ArrayList<Arc>();
                arcFrom1.add(inf.branchArcs.get(j));
                arcFrom2.add(ins.branchArcs.get(j));
                if (!arcFrom1.isEmpty() && !arcFrom2.isEmpty()) {
                    arcWeight = Math.min(((Arc)arcFrom1.get(0)).getWeight(), ((Arc)arcFrom2.get(0)).getWeight());
                }
                if (arcWeight == 0) break;
                ((Arc)arcFrom1.get((int)0)).arcDecoBox.setMemoryOfArcWeight(arcWeight);
                System.out.println("Arc : " + String.valueOf((Object)((Arc)arcFrom1.get(0)).getStartNode().getType()) + " " + ((Arc)arcFrom1.get(0)).getStartNode().getName() + " - > " + String.valueOf((Object)((Arc)arcFrom1.get(0)).getEndNode().getType()) + " " + ((Arc)arcFrom1.get(0)).getEndNode().getName());
                System.out.println("Arc : " + String.valueOf((Object)((Arc)arcFrom2.get(0)).getStartNode().getType()) + " " + ((Arc)arcFrom2.get(0)).getStartNode().getName() + " - > " + String.valueOf((Object)((Arc)arcFrom2.get(0)).getEndNode().getType()) + " " + ((Arc)arcFrom2.get(0)).getEndNode().getName());
                if (!commonNodes.contains(inf.branchArcs.get(j).getStartNode()) && !usedFromsecond.contains(ins.branchArcs.get(j).getStartNode())) {
                    commonNodes.add(inf.branchArcs.get(j).getStartNode());
                    nm.put(inf.branchArcs.get(j).getStartNode(), ins.branchArcs.get(j).getStartNode());
                    usedFromsecond.add(ins.branchArcs.get(j).getStartNode());
                }
                if (!commonNodes.contains(inf.branchArcs.get(j).getEndNode()) && !usedFromsecond.contains(ins.branchArcs.get(j).getEndNode())) {
                    commonNodes.add(inf.branchArcs.get(j).getEndNode());
                    nm.put(inf.branchArcs.get(j).getEndNode(), ins.branchArcs.get(j).getEndNode());
                    usedFromsecond.add(ins.branchArcs.get(j).getEndNode());
                }
                boolean fnlc = false;
                boolean snlc = false;
                if (inf.branchArcs.get(j).getStartNode().equals(root1)) {
                    fnlc = true;
                }
                if (ins.branchArcs.get(j).getStartNode().equals(root2)) {
                    snlc = true;
                }
                if (commonArcs.contains(arcFrom1.get(0)) || !commonNodes.contains(((Arc)arcFrom1.get(0)).getStartNode()) || !commonNodes.contains(((Arc)arcFrom1.get(0)).getEndNode()) || !nm.values().contains(((Arc)arcFrom2.get(0)).getStartNode()) || !nm.values().contains(((Arc)arcFrom2.get(0)).getEndNode())) continue;
                System.out.println("in Arc : " + String.valueOf((Object)((Arc)arcFrom1.get(0)).getStartNode().getType()) + " " + ((Arc)arcFrom1.get(0)).getStartNode().getName() + " - > " + String.valueOf((Object)((Arc)arcFrom1.get(0)).getEndNode().getType()) + " " + ((Arc)arcFrom1.get(0)).getEndNode().getName());
                commonArcs.add((Arc)arcFrom1.get(0));
                am.put((Arc)arcFrom1.get(0), (Arc)arcFrom2.get(0));
            }
            if ((ins.isCycle || inf.isCycle) && commonNodes.size() > 1) {
                if (inf.isCycle) {
                    List used = outgoingBranches1.stream().filter(x -> x.branchElements.containsAll(inf.branchElements)).collect(Collectors.toList());
                    outgoingBranches1.removeAll(used);
                }
                if (ins.isCycle) {
                    List used = outgoingBranches2.stream().filter(x -> x.branchElements.containsAll(ins.branchElements)).collect(Collectors.toList());
                    outgoingBranches2.removeAll(used);
                }
            }
            ++i;
        }
        block3: for (i = 0; i < outgoingBranches1.size() && i < outgoingBranches2.size(); ++i) {
            BranchBasedSubnet.Branch onf = outgoingBranches1.get(i);
            BranchBasedSubnet.Branch ons = outgoingBranches2.get(i);
            for (int j = 0; j < Math.min(onf.branchArcs.size(), ons.branchArcs.size()); ++j) {
                int arcWeight = 0;
                ArrayList<Arc> arcFrom1 = new ArrayList<Arc>();
                ArrayList<Arc> arcFrom2 = new ArrayList<Arc>();
                arcFrom1.add(onf.branchArcs.get(j));
                arcFrom2.add(ons.branchArcs.get(j));
                if (!arcFrom1.isEmpty() && !arcFrom2.isEmpty()) {
                    arcWeight = Math.min(((Arc)arcFrom1.get(0)).getWeight(), ((Arc)arcFrom2.get(0)).getWeight());
                }
                if (arcWeight == 0) continue block3;
                if (!commonNodes.contains(onf.branchArcs.get(j).getStartNode()) && !usedFromsecond.contains(ons.branchArcs.get(j).getStartNode())) {
                    commonNodes.add(onf.branchArcs.get(j).getStartNode());
                    nm.put(onf.branchArcs.get(j).getStartNode(), ons.branchArcs.get(j).getStartNode());
                    usedFromsecond.add(ons.branchArcs.get(j).getStartNode());
                }
                if (!commonNodes.contains(onf.branchArcs.get(j).getEndNode()) && !usedFromsecond.contains(ons.branchArcs.get(j).getEndNode())) {
                    commonNodes.add(onf.branchArcs.get(j).getEndNode());
                    nm.put(onf.branchArcs.get(j).getEndNode(), ons.branchArcs.get(j).getEndNode());
                    usedFromsecond.add(ons.branchArcs.get(j).getEndNode());
                }
                boolean fnlc = false;
                boolean snlc = false;
                if (onf.branchArcs.get(j).getEndNode().equals(root1)) {
                    fnlc = true;
                }
                if (ons.branchArcs.get(j).getEndNode().equals(root2)) {
                    snlc = true;
                }
                ((Arc)arcFrom1.get((int)0)).arcDecoBox.setMemoryOfArcWeight(arcWeight);
                if (commonArcs.contains(arcFrom1.get(0)) || !commonNodes.contains(((Arc)arcFrom1.get(0)).getStartNode()) || !commonNodes.contains(((Arc)arcFrom1.get(0)).getEndNode()) || !nm.values().contains(((Arc)arcFrom2.get(0)).getStartNode()) || !nm.values().contains(((Arc)arcFrom2.get(0)).getEndNode())) continue;
                System.out.println("out Arc : " + String.valueOf((Object)((Arc)arcFrom1.get(0)).getStartNode().getType()) + " " + ((Arc)arcFrom1.get(0)).getStartNode().getName() + " - > " + String.valueOf((Object)((Arc)arcFrom1.get(0)).getEndNode().getType()) + " " + ((Arc)arcFrom1.get(0)).getEndNode().getName());
                if ((!snlc || !fnlc) && (snlc || fnlc)) continue;
                commonArcs.add((Arc)arcFrom1.get(0));
                am.put((Arc)arcFrom1.get(0), (Arc)arcFrom2.get(0));
            }
        }
        return new PartialSubnetElements(commonNodes, commonArcs, nm, am);
    }

    public <K, V> K getKey(Map<K, V> map, V value) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (!entry.getValue().equals(value)) continue;
            return entry.getKey();
        }
        return null;
    }

    private boolean isIncomingCycleBranch(BranchBasedSubnet.Branch branch) {
        return branch.branchArcs.get(0).getEndNode().equals(branch.startNode);
    }

    private boolean isCycle(BranchBasedSubnet.Branch branch) {
        return branch.startNode.equals(branch.endNode);
    }

    private PartialSubnetElements pBranchesCycyle(ArrayList<BranchBasedSubnet.Branch> pbranches1, ArrayList<BranchBasedSubnet.Branch> pbranches2, Node root1, Node root2) {
        int i;
        HashMap<Node, Node> nm = new HashMap<Node, Node>();
        HashMap<Arc, Arc> am = new HashMap<Arc, Arc>();
        Collections.sort(pbranches1, new BranchBasedSubnet.Branch.LenghtSort());
        Collections.sort(pbranches2, new BranchBasedSubnet.Branch.LenghtSort());
        Collections.reverse(pbranches1);
        Collections.reverse(pbranches2);
        ArrayList<BranchBasedSubnet.Branch> incomingBranches1 = this.getIncomingBranches(pbranches1, root1);
        ArrayList<BranchBasedSubnet.Branch> incomingBranches2 = this.getIncomingBranches(pbranches2, root2);
        ArrayList<BranchBasedSubnet.Branch> outgoingBranches1 = this.getOutgoingBranches(pbranches1, root1);
        ArrayList<BranchBasedSubnet.Branch> outgoingBranches2 = this.getOutgoingBranches(pbranches2, root2);
        ArrayList<Node> commonNodes = new ArrayList<Node>();
        ArrayList<Arc> commonArcs = new ArrayList<Arc>();
        if (pbranches1.size() == 0 && pbranches2.size() == 0) {
            commonNodes.add(root1);
            return new PartialSubnetElements(commonNodes, commonArcs);
        }
        if (pbranches1.size() == 0 && pbranches2.size() > 0) {
            commonNodes.add(root1);
            return new PartialSubnetElements(commonNodes, commonArcs);
        }
        if (pbranches1.size() > 0 && pbranches2.size() == 0) {
            commonNodes.add(root1);
            return new PartialSubnetElements(commonNodes, commonArcs);
        }
        ArrayList<Node> usedFromsecond = new ArrayList<Node>();
        block0: for (i = 0; i < incomingBranches1.size() && i < incomingBranches2.size(); ++i) {
            int move = Math.abs(incomingBranches1.get((int)i).branchElements.size() - incomingBranches2.get((int)i).branchElements.size());
            int firstMove = 0;
            int secondMobe = 0;
            if (move != 0) {
                if (incomingBranches1.get((int)i).branchElements.size() > incomingBranches2.get((int)i).branchElements.size()) {
                    firstMove = move;
                } else {
                    secondMobe = move;
                }
            }
            for (int k = 0; k < incomingBranches1.get((int)i).branchElements.size(); ++k) {
                System.out.println(incomingBranches1.get((int)i).branchElements.get(k).getName());
            }
            System.out.println("root " + root1.getName() + " z brancha " + incomingBranches1.get((int)i).branchElements.get(0 + firstMove).getName());
            for (int j = 0; j < Math.min(incomingBranches1.get((int)i).branchElements.size(), incomingBranches2.get((int)i).branchElements.size()) - 1; ++j) {
                int arcWeight = 0;
                ArrayList<Arc> arcFrom1 = this.getArc(incomingBranches1.get((int)i).branchElements.get(j + firstMove), incomingBranches1.get((int)i).branchElements.get(j + firstMove + 1));
                ArrayList<Arc> arcFrom2 = this.getArc(incomingBranches2.get((int)i).branchElements.get(j + secondMobe), incomingBranches2.get((int)i).branchElements.get(j + secondMobe + 1));
                if (!arcFrom1.isEmpty() && !arcFrom2.isEmpty()) {
                    arcWeight = Math.min(arcFrom1.get(0).getWeight(), arcFrom2.get(0).getWeight());
                }
                if (arcWeight == 0) continue block0;
                arcFrom1.get((int)0).arcDecoBox.setMemoryOfArcWeight(arcWeight);
                System.out.println("Arc : " + String.valueOf((Object)arcFrom1.get(0).getStartNode().getType()) + " " + arcFrom1.get(0).getStartNode().getName() + " - > " + String.valueOf((Object)arcFrom1.get(0).getEndNode().getType()) + " " + arcFrom1.get(0).getEndNode().getName());
                if (!commonNodes.contains(incomingBranches1.get((int)i).branchElements.get(j + firstMove)) && !usedFromsecond.contains(incomingBranches2.get((int)i).branchElements.get(j + secondMobe))) {
                    commonNodes.add(incomingBranches1.get((int)i).branchElements.get(j + firstMove));
                    nm.put(incomingBranches1.get((int)i).branchElements.get(j + firstMove), incomingBranches2.get((int)i).branchElements.get(j + secondMobe));
                    usedFromsecond.add(incomingBranches2.get((int)i).branchElements.get(j + secondMobe));
                }
                if (!commonNodes.contains(incomingBranches1.get((int)i).branchElements.get(j + firstMove + 1)) && !usedFromsecond.contains(incomingBranches2.get((int)i).branchElements.get(j + secondMobe + 1))) {
                    commonNodes.add(incomingBranches1.get((int)i).branchElements.get(j + firstMove + 1));
                    nm.put(incomingBranches1.get((int)i).branchElements.get(j + firstMove + 1), incomingBranches2.get((int)i).branchElements.get(j + secondMobe + 1));
                    usedFromsecond.add(incomingBranches2.get((int)i).branchElements.get(j + secondMobe + 1));
                }
                if (commonArcs.contains(arcFrom1.get(0)) || !commonNodes.contains(arcFrom1.get(0).getStartNode()) || !commonNodes.contains(arcFrom1.get(0).getEndNode())) continue;
                System.out.println("in Arc : " + String.valueOf((Object)arcFrom1.get(0).getStartNode().getType()) + " " + arcFrom1.get(0).getStartNode().getName() + " - > " + String.valueOf((Object)arcFrom1.get(0).getEndNode().getType()) + " " + arcFrom1.get(0).getEndNode().getName());
                commonArcs.add(arcFrom1.get(0));
                am.put(arcFrom1.get(0), arcFrom2.get(0));
            }
        }
        block3: for (i = 0; i < outgoingBranches1.size() && i < outgoingBranches2.size(); ++i) {
            System.out.println("out root " + root1.getName() + " z brancha " + outgoingBranches1.get((int)i).branchElements.get(0).getName());
            for (int j = 0; j < outgoingBranches1.get((int)i).branchElements.size() - 1 && j < outgoingBranches2.get((int)i).branchElements.size() - 1; ++j) {
                int arcWeight = 0;
                ArrayList<Arc> arcFrom1 = this.getArc(outgoingBranches1.get((int)i).branchElements.get(j), outgoingBranches1.get((int)i).branchElements.get(j + 1));
                ArrayList<Arc> arcFrom2 = this.getArc(outgoingBranches2.get((int)i).branchElements.get(j), outgoingBranches2.get((int)i).branchElements.get(j + 1));
                if (!arcFrom1.isEmpty() && !arcFrom2.isEmpty()) {
                    arcWeight = Math.min(arcFrom1.get(0).getWeight(), arcFrom2.get(0).getWeight());
                }
                if (arcWeight == 0) continue block3;
                if (!commonNodes.contains(outgoingBranches1.get((int)i).branchElements.get(j)) && !usedFromsecond.contains(outgoingBranches2.get((int)i).branchElements.get(j))) {
                    commonNodes.add(outgoingBranches1.get((int)i).branchElements.get(j));
                    nm.put(outgoingBranches1.get((int)i).branchElements.get(j), outgoingBranches2.get((int)i).branchElements.get(j));
                    usedFromsecond.add(outgoingBranches2.get((int)i).branchElements.get(j));
                }
                if (!commonNodes.contains(outgoingBranches1.get((int)i).branchElements.get(j + 1)) && !usedFromsecond.contains(outgoingBranches2.get((int)i).branchElements.get(j + 1))) {
                    commonNodes.add(outgoingBranches1.get((int)i).branchElements.get(j + 1));
                    nm.put(outgoingBranches1.get((int)i).branchElements.get(j + 1), outgoingBranches2.get((int)i).branchElements.get(j + 1));
                    usedFromsecond.add(outgoingBranches2.get((int)i).branchElements.get(j + 1));
                }
                arcFrom1.get((int)0).arcDecoBox.setMemoryOfArcWeight(arcWeight);
                if (commonArcs.contains(arcFrom1.get(0)) || !commonNodes.contains(arcFrom1.get(0).getStartNode()) || !commonNodes.contains(arcFrom1.get(0).getEndNode())) continue;
                System.out.println("out Arc : " + String.valueOf((Object)arcFrom1.get(0).getStartNode().getType()) + " " + arcFrom1.get(0).getStartNode().getName() + " - > " + String.valueOf((Object)arcFrom1.get(0).getEndNode().getType()) + " " + arcFrom1.get(0).getEndNode().getName());
                commonArcs.add(arcFrom1.get(0));
                am.put(arcFrom1.get(0), arcFrom2.get(0));
            }
        }
        return new PartialSubnetElements(commonNodes, commonArcs, nm, am);
    }

    private ArrayList<BranchBasedSubnet.Branch> getIncomingBranches(ArrayList<BranchBasedSubnet.Branch> list, Node root) {
        return list.stream().filter(x -> x.endNode.getID() == root.getID() && !x.startNode.equals(x.endNode) || x.startNode.equals(x.endNode) && this.getDirection((BranchBasedSubnet.Branch)x)).collect(Collectors.toCollection(ArrayList::new));
    }

    private ArrayList<BranchBasedSubnet.Branch> getOutgoingBranches(ArrayList<BranchBasedSubnet.Branch> list, Node root) {
        return list.stream().filter(x -> x.startNode.getID() == root.getID() && !x.startNode.equals(x.endNode) || x.startNode.equals(x.endNode) && !this.getDirection((BranchBasedSubnet.Branch)x)).collect(Collectors.toCollection(ArrayList::new));
    }

    private ArrayList<BranchBasedSubnet.Branch> getIncomingBranchesLoop(ArrayList<BranchBasedSubnet.Branch> list, Node root) {
        return list.stream().filter(x -> x.endNode.getID() == root.getID() && this.getDirection((BranchBasedSubnet.Branch)x)).collect(Collectors.toCollection(ArrayList::new));
    }

    private ArrayList<BranchBasedSubnet.Branch> getOutgoingBranchesLoop(ArrayList<BranchBasedSubnet.Branch> list, Node root) {
        return list.stream().filter(x -> x.startNode.getID() == root.getID() && !this.getDirection((BranchBasedSubnet.Branch)x)).collect(Collectors.toCollection(ArrayList::new));
    }

    private ArrayList<Arc> getArc(Node start, Node end) {
        ArrayList<Arc> sio = start.getNeighborsArcs();
        ArrayList<Arc> eio = end.getNeighborsArcs();
        ArrayList<Arc> listOfArcs = new ArrayList<Arc>(start.getOutputArcs());
        ArrayList<Arc> olistOfArcs = new ArrayList<Arc>(start.getInputArcs());
        listOfArcs.retainAll(end.getInputArcs());
        return listOfArcs;
    }

    private ArrayList<PartialSubnetElements> mergePartialSubnetElements(ArrayList<PartialSubnetElements> psePb, ArrayList<PartialSubnetElements> pseTb) {
        ArrayList allNodes = new ArrayList();
        ArrayList allArcs = new ArrayList();
        for (PartialSubnetElements pse : psePb) {
            allNodes.addAll(pse.partialNodes);
            allArcs.addAll(pse.partialArcs);
        }
        for (PartialSubnetElements pse : pseTb) {
            allNodes.addAll(pse.partialNodes);
            allArcs.addAll(pse.partialArcs);
        }
        allNodes = allNodes.stream().distinct().collect(Collectors.toCollection(ArrayList::new));
        allArcs = allArcs.stream().distinct().collect(Collectors.toCollection(ArrayList::new));
        PartialSubnetElements pse = new PartialSubnetElements(allNodes, allArcs);
        ArrayList<PartialSubnetElements> pseList = new ArrayList<PartialSubnetElements>();
        pseList.add(pse);
        return pseList;
    }

    private PartialSubnetElements mergePartialSubnetElements(PartialSubnetElements psePb, PartialSubnetElements pseTb) {
        ArrayList allNodes = new ArrayList();
        ArrayList allArcs = new ArrayList();
        HashMap<Node, Node> nm = new HashMap<Node, Node>();
        HashMap<Arc, Arc> am = new HashMap<Arc, Arc>();
        ArrayList<Node> annyConection = new ArrayList<Node>(psePb.partialNodes);
        annyConection.retainAll(pseTb.partialNodes);
        ArrayList<Node> annyConectionSecond = new ArrayList<Node>(psePb.nodesMap.values());
        annyConectionSecond.retainAll(pseTb.nodesMap.values());
        if (!this.secondQuestion) {
            if (annyConection.size() > 0) {
                allNodes.addAll(psePb.partialNodes);
                allArcs.addAll(psePb.partialArcs);
                allNodes.addAll(pseTb.partialNodes);
                allArcs.addAll(pseTb.partialArcs);
                allNodes = allNodes.stream().distinct().collect(Collectors.toCollection(ArrayList::new));
                allArcs = allArcs.stream().distinct().collect(Collectors.toCollection(ArrayList::new));
                nm.putAll(psePb.nodesMap);
                nm.putAll(pseTb.nodesMap);
                am.putAll(psePb.arcsMap);
                am.putAll(pseTb.arcsMap);
            } else if (psePb.partialNodes.size() > pseTb.partialNodes.size()) {
                allNodes.addAll(psePb.partialNodes);
                allArcs.addAll(psePb.partialArcs);
                nm.putAll(psePb.nodesMap);
                am.putAll(psePb.arcsMap);
            } else {
                allNodes.addAll(pseTb.partialNodes);
                allArcs.addAll(pseTb.partialArcs);
                nm.putAll(pseTb.nodesMap);
                am.putAll(pseTb.arcsMap);
            }
        } else if (annyConection.size() > 0 && (annyConectionSecond.size() == annyConection.size() || annyConectionSecond.size() + 1 == annyConection.size() || annyConectionSecond.size() == annyConection.size() + 1)) {
            allNodes.addAll(psePb.partialNodes);
            allArcs.addAll(psePb.partialArcs);
            allNodes.addAll(pseTb.partialNodes);
            allArcs.addAll(pseTb.partialArcs);
            allNodes = allNodes.stream().distinct().collect(Collectors.toCollection(ArrayList::new));
            allArcs = allArcs.stream().distinct().collect(Collectors.toCollection(ArrayList::new));
            nm.putAll(psePb.nodesMap);
            nm.putAll(pseTb.nodesMap);
            am.putAll(psePb.arcsMap);
            am.putAll(pseTb.arcsMap);
        } else if (psePb.partialNodes.size() > pseTb.partialNodes.size()) {
            allNodes.addAll(psePb.partialNodes);
            allArcs.addAll(psePb.partialArcs);
            nm.putAll(psePb.nodesMap);
            am.putAll(psePb.arcsMap);
        } else {
            allNodes.addAll(pseTb.partialNodes);
            allArcs.addAll(pseTb.partialArcs);
            nm.putAll(pseTb.nodesMap);
            am.putAll(pseTb.arcsMap);
        }
        return new PartialSubnetElements(allNodes, allArcs, nm, am);
    }

    private ArrayList<Transition> generateNewTransitions(ArrayList<Node> list, BranchBasedSubnet net) {
        ArrayList<Transition> result = new ArrayList<Transition>();
        for (Node n : list) {
            if (!n.getType().equals((Object)PetriNetElement.PetriNetElementType.TRANSITION)) continue;
            Transition t = new Transition(IdGenerator.getNextId(), 1, (Point)n.getNodePositions(0).get(0).clone());
            result.add(t);
        }
        return result;
    }

    private ArrayList<Node> generateNewNodes(ArrayList<Node> list, BranchBasedSubnet net, int sheetID) {
        ArrayList<Node> result = new ArrayList<Node>();
        for (Node n : list) {
            if (n.getType().equals((Object)PetriNetElement.PetriNetElementType.TRANSITION)) {
                Transition t = new Transition(IdGenerator.getNextId(), sheetID, (Point)n.getNodePositions(0).get(0).clone());
                result.add(t);
            }
            if (!n.getType().equals((Object)PetriNetElement.PetriNetElementType.PLACE)) continue;
            Place p = new Place(IdGenerator.getNextId(), sheetID, (Point)n.getNodePositions(0).get(0).clone());
            result.add(p);
        }
        return result;
    }

    private ArrayList<Place> generateNewPlaces(ArrayList<Node> list, BranchBasedSubnet net) {
        ArrayList<Place> result = new ArrayList<Place>();
        for (Node n : list) {
            if (!n.getType().equals((Object)PetriNetElement.PetriNetElementType.PLACE)) continue;
            Place t = new Place(IdGenerator.getNextId(), 1, (Point)n.getNodePositions(0).get(0).clone());
            result.add(t);
        }
        return result;
    }

    private ArrayList<ArrayList<RowMatch>> calcBranchMatrix(BranchBasedSubnet net1, BranchBasedSubnet net2) {
        RowMatch[][] bm = new RowMatch[net1.pairs.size()][net2.pairs.size()];
        for (int i = 0; i < net1.branchDirMatrix.length; ++i) {
            for (int j = 0; j < net2.branchDirMatrix.length; ++j) {
                bm[i][j] = this.matchRows(net1.branchDirMatrix[i], net2.branchDirMatrix[j], net1.pairs.get(i), net2.pairs.get(j), net1, net2);
            }
        }
        ArrayList<ArrayList<RowMatch>> listOfVerticesMatches = this.coloringTable(bm, net1, net2);
        int lenght = 0;
        for (ArrayList<RowMatch> tm : listOfVerticesMatches) {
            if (tm.size() <= lenght) continue;
            lenght = tm.size();
        }
        ArrayList<ArrayList<RowMatch>> max = new ArrayList<ArrayList<RowMatch>>();
        for (ArrayList<RowMatch> tm : listOfVerticesMatches) {
            if (tm.size() != lenght) continue;
            max.add(tm);
        }
        return max;
    }

    public static ArrayList<ArrayList<Integer>> listPermutations(ArrayList<Integer> list) {
        if (list.size() == 0) {
            ArrayList<ArrayList<Integer>> result = new ArrayList<ArrayList<Integer>>();
            result.add(new ArrayList());
            return result;
        }
        ArrayList<ArrayList<Integer>> returnMe = new ArrayList<ArrayList<Integer>>();
        Integer firstElement = list.remove(0);
        ArrayList<ArrayList<Integer>> recursiveReturn = SubnetComparator.listPermutations(list);
        for (List list2 : recursiveReturn) {
            for (int index = 0; index <= list2.size(); ++index) {
                ArrayList<Integer> temp = new ArrayList<Integer>(list2);
                temp.add(index, firstElement);
                returnMe.add(temp);
            }
        }
        return returnMe;
    }

    private ArrayList<ArrayList<RowMatch>> coloringTable(RowMatch[][] bm, BranchBasedSubnet net1, BranchBasedSubnet net2) {
        ArrayList<ArrayList<RowMatch>> results = new ArrayList<ArrayList<RowMatch>>();
        ArrayList<Integer> listaDoPermutacji = new ArrayList<Integer>();
        for (int i = 0; i < net2.branchVertices.size() || i < net1.branchVertices.size(); ++i) {
            if (i >= net2.branchVertices.size()) {
                listaDoPermutacji.add(-1);
                continue;
            }
            listaDoPermutacji.add(i);
        }
        ArrayList<ArrayList<Integer>> dopasowania = SubnetComparator.listPermutations(listaDoPermutacji);
        ArrayList<ArrayList<Node>> colorNet1 = new ArrayList<ArrayList<Node>>();
        for (int i = 0; i < net1.branchVertices.size(); ++i) {
            ArrayList<Node> list = new ArrayList<Node>();
            for (int j = 0; j < net1.pairs.size(); ++j) {
                if (!net1.branchVertices.get((int)i).tbranch.contains(net1.pairs.get(j))) continue;
                list.add(net1.branchVertices.get((int)i).root);
            }
            colorNet1.add(list);
        }
        ArrayList<ArrayList<Node>> colorNet2 = new ArrayList<ArrayList<Node>>();
        for (int i = 0; i < net2.branchVertices.size(); ++i) {
            ArrayList<Node> list = new ArrayList<Node>();
            for (int j = 0; j < net2.pairs.size(); ++j) {
                if (!net2.branchVertices.get((int)i).tbranch.contains(net2.pairs.get(j))) continue;
                list.add(net2.branchVertices.get((int)i).root);
            }
            colorNet2.add(list);
        }
        if (net2.branchVertices.size() > net1.branchVertices.size()) {
            dopasowania = this.trim(dopasowania, net2.branchVertices.size() - net1.branchVertices.size());
        }
        for (ArrayList<Integer> match : dopasowania) {
            ArrayList arrayList = new ArrayList();
            for (int j = 0; j < net1.branchVertices.size(); ++j) {
                net1.branchVertices.get(j);
            }
            ArrayList<RowMatch> arrayList2 = this.extractBranchesForMatchedBranchVertices(bm, match, colorNet1, colorNet2, net1, net2);
            results.add(arrayList2);
        }
        ArrayList<ArrayList> max = new ArrayList<ArrayList>();
        for (ArrayList arrayList : results) {
            if (max.size() == 0 || arrayList.size() > ((ArrayList)max.get(0)).size()) {
                max.clear();
                max.add(arrayList);
                continue;
            }
            if (arrayList.size() != ((ArrayList)max.get(0)).size()) continue;
            max.add(arrayList);
        }
        if (!this.allNotMax) {
            results.clear();
            results.addAll(max);
        }
        return results;
    }

    private ArrayList<RowMatch> extractBranchesForMatchedBranchVertices(RowMatch[][] bm, ArrayList<Integer> match, ArrayList<ArrayList<Node>> colorNet1, ArrayList<ArrayList<Node>> colorNet2, BranchBasedSubnet net1, BranchBasedSubnet net2) {
        int i;
        ArrayList results = new ArrayList();
        for (i = 0; i < bm.length; ++i) {
            for (int j = 0; j < bm[i].length; ++j) {
                boolean first = false;
                boolean secon = false;
                for (int k = 0; k < match.size(); ++k) {
                    if (match.get(k) == -1) continue;
                    if (bm[i][j].startNodeNet1.getID() == net1.branchVertices.get((int)k).root.getID() && bm[i][j].startNodeNet2.getID() == net2.branchVertices.get((int)match.get((int)k).intValue()).root.getID()) {
                        first = true;
                    }
                    if (bm[i][j].endNodeNet1.getID() != net1.branchVertices.get((int)k).root.getID() || bm[i][j].endNodeNet2.getID() != net2.branchVertices.get((int)match.get((int)k).intValue()).root.getID()) continue;
                    secon = true;
                }
                if (!first || !secon) continue;
                results.add(bm[i][j]);
            }
        }
        for (i = 0; i < colorNet1.size(); ++i) {
        }
        results = results.stream().distinct().collect(Collectors.toCollection(ArrayList::new));
        return results;
    }

    private ArrayList<ArrayList<Integer>> trim(ArrayList<ArrayList<Integer>> dopasowania, int i) {
        for (ArrayList<Integer> list : dopasowania) {
            for (int j = 0; j < i; ++j) {
                list.remove(list.size() - 1);
            }
        }
        return dopasowania;
    }

    private ArrayList<ArrayList<RowMatch>> calcMatching(ArrayList<ArrayList<RowMatch>> listOfVerticesMatches, RowMatch[][] bm) {
        ArrayList<ArrayList<RowMatch>> properMatchings = new ArrayList<ArrayList<RowMatch>>();
        for (ArrayList<RowMatch> lrm : listOfVerticesMatches) {
            ArrayList<RowMatch> used = new ArrayList<RowMatch>();
            for (int i = 0; i < bm.length; ++i) {
                for (int j = 0; j < bm[i].length; ++j) {
                    if (!lrm.contains(bm[i][j])) continue;
                    ArrayList<ArrayList<RowMatch>> foundedMatches = this.findNext(i, j, used, bm, lrm);
                    properMatchings.addAll(foundedMatches);
                }
            }
        }
        return properMatchings;
    }

    private ArrayList<ArrayList<RowMatch>> findNext(int i, int j, ArrayList<RowMatch> used, RowMatch[][] bm, ArrayList<RowMatch> lrm) {
        ArrayList<ArrayList<RowMatch>> result = new ArrayList<ArrayList<RowMatch>>();
        return result;
    }

    private ArrayList<ArrayList<RowMatch>> calcMaxMatches(RowMatch[][] rm) {
        this.founded = new int[rm.length][rm[0].length];
        ArrayList<ArrayList<RowMatch>> matches = new ArrayList<ArrayList<RowMatch>>();
        int type = 1;
        for (int i = 0; i < rm.length; ++i) {
            for (int j = 0; j < rm[i].length; ++j) {
                if (this.founded[i][j] != 0) continue;
                ArrayList<RowMatch> match = new ArrayList<RowMatch>();
                match.add(rm[i][j]);
                this.founded[i][j] = type;
                for (int k = 0; k < rm.length; ++k) {
                    for (int l = 0; l < rm[i].length; ++l) {
                        if (this.founded[k][l] != 0 || !this.matchPairs(match, rm[k][l])) continue;
                        this.founded[k][l] = type;
                        match.add(rm[k][l]);
                    }
                }
                matches.add(match);
                ++type;
            }
        }
        return matches;
    }

    private boolean matchPairs(ArrayList<RowMatch> match, RowMatch rowMatch) {
        boolean isMatch = false;
        boolean isConflict = false;
        for (RowMatch rm : match) {
            if (rm.verticesMap.containsAll(rowMatch.verticesMap)) {
                isMatch = true;
                continue;
            }
            if (Collections.disjoint(rm.verticesMap, rowMatch.verticesMap)) continue;
            ArrayList tmp = (ArrayList)rowMatch.verticesMap.clone();
            tmp.retainAll(rm.verticesMap);
            ArrayList<ArrayList<Integer>> allElements = new ArrayList<ArrayList<Integer>>();
            allElements.addAll(rm.verticesMap);
            allElements.addAll(rowMatch.verticesMap);
            allElements.removeAll(tmp);
            if (this.checConflict(allElements)) {
                isConflict = true;
            }
            isMatch = true;
        }
        if (isConflict) {
            return false;
        }
        return isMatch;
    }

    private boolean checConflict(ArrayList<ArrayList<Integer>> allElements) {
        boolean isConflict = false;
        HashMap hm = new HashMap();
        for (int i = 0; i < allElements.size(); ++i) {
            for (int j = i + 1; j < allElements.size() - 1; ++j) {
                if (!allElements.get(i).get(0).equals(allElements.get(j).get(0)) && !allElements.get(i).get(1).equals(allElements.get(j).get(1))) continue;
                isConflict = true;
            }
        }
        return isConflict;
    }

    private RowMatch matchRows(int[] rowN1, int[] rowN2, BranchBasedSubnet.Branch br1, BranchBasedSubnet.Branch br2, BranchBasedSubnet net1, BranchBasedSubnet net2) {
        int start1 = 0;
        int end1 = 0;
        for (int l = 0; l < rowN1.length; ++l) {
            if (rowN1[l] > 0) {
                end1 = l;
            }
            if (rowN1[l] >= 0) continue;
            start1 = l;
        }
        int start2 = 0;
        int end2 = 0;
        for (int k = 0; k < rowN2.length; ++k) {
            if (rowN2[k] > 0) {
                end2 = k;
            }
            if (rowN2[k] >= 0) continue;
            start2 = k;
        }
        ArrayList<ArrayList<Integer>> map = new ArrayList<ArrayList<Integer>>();
        ArrayList<Integer> rowStart = new ArrayList<Integer>();
        rowStart.add(start1);
        rowStart.add(start2);
        map.add(rowStart);
        ArrayList<Integer> rowEnd = new ArrayList<Integer>();
        rowEnd.add(end1);
        rowEnd.add(end2);
        map.add(rowEnd);
        return new RowMatch(start1, end1, map, br1, br2, net1, net2);
    }

    private void calcGCSs(char[][] branchMateix, BranchBasedSubnet net1, BranchBasedSubnet net2) {
    }

    private BranchBasedSubnet transformSubnet(SubnetCalculator.SubNet sn) {
        return new BranchBasedSubnet(sn);
    }

    public int connectedArcs(Node n, ArrayList<Arc> properArcs) {
        int counter = 0;
        for (Arc a : properArcs) {
            if (a.getEndNode().equals(n)) {
                ++counter;
            }
            if (!a.getStartNode().equals(n)) continue;
            ++counter;
        }
        return counter;
    }

    public <K, V> Set<K> getKeys(Map<K, V> map, V value) {
        HashSet<K> keys = new HashSet<K>();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (!entry.getValue().equals(value)) continue;
            keys.add(entry.getKey());
        }
        return keys;
    }

    public class PartialSubnetElements {
        public ArrayList<Node> partialNodes = new ArrayList();
        public ArrayList<Arc> partialArcs = new ArrayList();
        public HashMap<Node, Node> nodesMap = new HashMap();
        public HashMap<Arc, Arc> arcsMap = new HashMap();

        public PartialSubnetElements(ArrayList<Node> pratOfNodes) {
            this.partialNodes.addAll(pratOfNodes);
        }

        public PartialSubnetElements(ArrayList<Node> pratOfNodes, ArrayList<Arc> partOfArcs) {
            HashSet<Node> hset = new HashSet<Node>(pratOfNodes);
            ArrayList<Node> unique = new ArrayList<Node>(hset);
            this.partialNodes.addAll(unique);
            this.partialArcs.addAll(partOfArcs);
            if (this.partialNodes.size() == 0 || this.partialArcs.size() == 0) {
                System.out.println("COs nie tak");
            }
        }

        public PartialSubnetElements(ArrayList<Node> pratOfNodes, ArrayList<Arc> partOfArcs, HashMap<Node, Node> nm, HashMap<Arc, Arc> am) {
            this.partialNodes.addAll(pratOfNodes);
            this.partialArcs.addAll(partOfArcs);
            this.arcsMap = am;
            this.nodesMap = nm;
        }

        public PartialSubnetElements(PartialSubnetElements pse1, PartialSubnetElements pse2) {
            this.partialNodes.addAll(pse1.partialNodes);
            this.partialNodes.addAll(pse2.partialNodes);
            this.partialNodes.stream().distinct();
            this.partialArcs.addAll(pse1.partialArcs);
            this.partialArcs.addAll(pse2.partialArcs);
            this.partialArcs.stream().distinct();
            if (this.partialNodes.size() == 0 || this.partialArcs.size() == 0) {
                // empty if block
            }
        }

        public PartialSubnetElements(ArrayList<PartialSubnetElements> pseList, boolean mock) {
            for (PartialSubnetElements pse : pseList) {
                this.partialNodes.addAll(pse.partialNodes);
                this.partialArcs.addAll(pse.partialArcs);
            }
            this.partialNodes.stream().distinct();
            this.partialArcs.stream().distinct();
            if (this.partialNodes.size() == 0 || this.partialArcs.size() == 0) {
                System.out.println("COs nie tak");
            }
        }

        public int arcWeight() {
            return this.partialArcs.stream().mapToInt(x -> x.getWeight()).sum();
        }

        public double matchingValueFunction() {
            return this.partialNodes.size();
        }

        public double matchingArcValueFunction() {
            return this.partialArcs.size();
        }

        public void check() {
            System.out.println("new check");
            ArrayList<Node> toremove = new ArrayList<Node>();
            for (Node node : this.nodesMap.keySet()) {
                Set<Node> set = SubnetComparator.this.getKeys(this.nodesMap, this.nodesMap.get(node));
                if (set.size() <= 1) continue;
                for (Node m : set) {
                    if (SubnetComparator.this.connectedArcs(m, this.partialArcs) != 1) continue;
                    toremove.add(m);
                }
            }
            for (Node node : toremove) {
                this.nodesMap.remove(node);
                this.partialNodes.remove(node);
                ArrayList arrayList = this.partialArcs.stream().filter(x -> x.getStartNode().equals(node) || x.getEndNode().equals(node)).collect(Collectors.toCollection(ArrayList::new));
                this.partialArcs.removeAll(arrayList);
            }
            HashSet<Node> valuseSet = new HashSet<Node>(this.nodesMap.values());
            if (this.nodesMap.values().size() != valuseSet.size()) {
                System.out.println("Variant F");
            }
            for (Arc arc : this.arcsMap.keySet()) {
                if (!this.nodesMap.containsKey(arc.getStartNode())) {
                    System.out.println("A");
                }
                if (this.nodesMap.containsKey(arc.getEndNode())) continue;
                System.out.println("B");
            }
            ArrayList<Arc> arrayList = new ArrayList<Arc>();
            for (Arc a : this.arcsMap.values()) {
                if (!this.nodesMap.containsValue(a.getStartNode())) {
                    arrayList.add(a);
                    System.out.println("C");
                }
                if (this.nodesMap.containsValue(a.getEndNode())) continue;
                arrayList.add(a);
                System.out.println("D");
            }
            for (Arc a : arrayList) {
                Set<Arc> keySet = SubnetComparator.this.getKeys(this.arcsMap, a);
                for (Arc arc : keySet) {
                    if (arc.getStartNode().getNeighborsArcs().size() <= 1 || arc.getEndNode().getNeighborsArcs().size() <= 1) continue;
                    this.arcsMap.remove(arc);
                    this.partialArcs.remove(arc);
                }
            }
            ArrayList<Arc> arrayList2 = new ArrayList<Arc>(this.partialArcs);
            ArrayList podzialy = new ArrayList();
            ArrayList<Arc> podzial = new ArrayList<Arc>();
            if (!arrayList2.isEmpty()) {
                podzial.add(arrayList2.get(0));
                arrayList2.remove(0);
                while (arrayList2.size() > 0) {
                    ArrayList toExtend = new ArrayList();
                    for (Arc arc : podzial) {
                        toExtend.addAll(arrayList2.stream().filter(x -> x.getEndNode().equals(a.getEndNode()) || x.getEndNode().equals(a.getStartNode()) || x.getStartNode().equals(a.getStartNode()) || x.getStartNode().equals(a.getEndNode())).collect(Collectors.toCollection(ArrayList::new)));
                    }
                    if (toExtend.isEmpty()) {
                        podzialy.add(podzial);
                        podzial.clear();
                        podzial.add(arrayList2.get(0));
                        arrayList2.remove(0);
                    }
                    if (!toExtend.isEmpty()) {
                        podzial.add((Arc)toExtend.get(0));
                        arrayList2.remove(toExtend.get(0));
                    }
                    if (!toExtend.isEmpty() || !arrayList2.isEmpty()) continue;
                    podzialy.add(podzial);
                }
            }
            if (!podzial.isEmpty()) {
                podzialy.add(podzial);
            }
            if (podzialy.size() > 1) {
                ArrayList max = new ArrayList();
                for (ArrayList arrayList3 : podzialy) {
                    if (max.size() >= arrayList3.size()) continue;
                    max = arrayList3;
                }
                this.partialArcs = max;
                ArrayList<Node> arrayList4 = new ArrayList<Node>();
                for (Arc a : this.partialArcs) {
                    if (!arrayList4.contains(a.getEndNode())) {
                        arrayList4.add(a.getEndNode());
                    }
                    if (arrayList4.contains(a.getStartNode())) continue;
                    arrayList4.add(a.getStartNode());
                }
                this.partialNodes = arrayList4;
            }
        }
    }

    public class RowMatch {
        int firstNetRowIndex;
        int seconNetRowIndex;
        public Node startNodeNet1;
        public Node endNodeNet1;
        public Node startNodeNet2;
        public Node endNodeNet2;
        public int snn1ID;
        public int snn2ID;
        public int enn1ID;
        public int enn2ID;
        int mapOfFNR;
        int mapOfSNR;
        BranchBasedSubnet.Branch firstNetBranch;
        BranchBasedSubnet.Branch secondNetBranch;
        public ArrayList<ArrayList<Integer>> verticesMap = new ArrayList();

        RowMatch(int f, int s, ArrayList<ArrayList<Integer>> vm) {
            this.firstNetRowIndex = f;
            this.seconNetRowIndex = s;
            this.verticesMap = vm;
            this.mapOfFNR = vm.get(0).get(1);
            this.mapOfSNR = vm.get(1).get(1);
        }

        RowMatch(int f, int s, ArrayList<ArrayList<Integer>> vm, BranchBasedSubnet.Branch fnb, BranchBasedSubnet.Branch snb, BranchBasedSubnet net1, BranchBasedSubnet net2) {
            this.firstNetRowIndex = f;
            this.seconNetRowIndex = s;
            this.verticesMap = vm;
            this.firstNetBranch = fnb;
            this.secondNetBranch = snb;
            this.mapOfFNR = vm.get(0).get(1);
            this.mapOfSNR = vm.get(1).get(1);
            this.startNodeNet1 = net1.transitions.get(this.firstNetRowIndex);
            this.endNodeNet1 = net1.transitions.get(this.seconNetRowIndex);
            this.startNodeNet2 = net2.transitions.get(this.mapOfFNR);
            this.endNodeNet2 = net2.transitions.get(this.mapOfSNR);
        }
    }
}

