/*
 * Decompiled with CFR 0.152.
 */
package holmes.analyse.comparison;

import holmes.petrinet.data.PetriNetData;
import holmes.petrinet.elements.Arc;
import holmes.petrinet.elements.Node;
import java.util.ArrayList;
import java.util.stream.Collectors;

public class LabelNetComparator {
    public ArrayList<MatchedVertex> matchedVertices = new ArrayList();
    public PetriNetData fPND;
    public PetriNetData sPND;

    public LabelNetComparator(PetriNetData f, PetriNetData s) {
        this.fPND = f;
        this.sPND = s;
    }

    public void calcSimilarities() {
        for (int i = 0; i < this.fPND.nodes.size(); ++i) {
            for (int j = 0; j < this.sPND.nodes.size(); ++j) {
                if (!this.fPND.nodes.get(i).getName().equals(this.sPND.nodes.get(j).getName())) continue;
                this.matchedVertices.add(new MatchedVertex(this.fPND.nodes.get(i), this.sPND.nodes.get(j)));
            }
        }
    }

    public ArrayList<String> getDifferencesFromFirstNet() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("-Nodes only in first net-\n");
        for (Node n : this.fPND.nodes) {
            if (this.matchedVertices.stream().filter(x -> x.firstNetNode == n).collect(Collectors.toCollection(ArrayList::new)).size() >= 1) continue;
            result.add(String.valueOf((Object)n.getType()) + " - ID : " + n.getID() + " " + n.getName());
        }
        ArrayList<Arc> sumOfFirstNetArc = new ArrayList<Arc>();
        ArrayList<MatchedArc> sumOfMatchedNetArc = new ArrayList<MatchedArc>();
        for (MatchedVertex matchedVertex : this.matchedVertices) {
            for (MatchedArc a : matchedVertex.arclist) {
                if (sumOfFirstNetArc.contains(a.firstNetArc)) continue;
                sumOfFirstNetArc.add(a.firstNetArc);
                sumOfMatchedNetArc.add(a);
            }
        }
        result.add("-Arc only in first net-\n");
        for (Arc arc : this.fPND.arcs) {
            if (sumOfFirstNetArc.contains(arc)) continue;
            result.add(String.valueOf((Object)arc.getType()) + " - ID : " + arc.getID() + " From :" + arc.getStartNode().getID() + "To :" + arc.getEndNode().getID());
        }
        result.add("-Arc with different weight-\n");
        for (MatchedArc matchedArc : sumOfMatchedNetArc) {
            if (matchedArc.isWehightEqual.booleanValue()) continue;
            result.add(String.valueOf((Object)matchedArc.firstNetArc.getType()) + " - ID : " + matchedArc.firstNetArc.getID() + " From :" + matchedArc.firstNetArc.getStartNode().getID() + "To :" + matchedArc.firstNetArc.getEndNode().getID() + " Weight : " + matchedArc.firstNetArc.getWeight());
        }
        return result;
    }

    public ArrayList<String> getDifferencesFromSecondNet() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("-Nodes only in second net-\n");
        for (Node n : this.sPND.nodes) {
            if (this.matchedVertices.stream().filter(x -> x.secondNetNode == n).collect(Collectors.toCollection(ArrayList::new)).size() >= 1) continue;
            result.add(String.valueOf((Object)n.getType()) + " - ID : " + n.getID() + " " + n.getName());
        }
        ArrayList<Arc> sumOfFirstNetArc = new ArrayList<Arc>();
        ArrayList<MatchedArc> sumOfMatchedNetArc = new ArrayList<MatchedArc>();
        for (MatchedVertex matchedVertex : this.matchedVertices) {
            for (MatchedArc a : matchedVertex.arclist) {
                if (sumOfFirstNetArc.contains(a.secondNetArc)) continue;
                sumOfFirstNetArc.add(a.secondNetArc);
                sumOfMatchedNetArc.add(a);
            }
        }
        result.add("-Arc only in second net-\n");
        for (Arc arc : this.sPND.arcs) {
            if (sumOfFirstNetArc.contains(arc)) continue;
            result.add(String.valueOf((Object)arc.getType()) + " - ID : " + arc.getID() + " From :" + arc.getStartNode().getID() + "To :" + arc.getEndNode().getID());
        }
        result.add("-Arc with different weight-\n");
        for (MatchedArc matchedArc : sumOfMatchedNetArc) {
            if (matchedArc.isWehightEqual.booleanValue()) continue;
            result.add(String.valueOf((Object)matchedArc.secondNetArc.getType()) + " - ID : " + matchedArc.secondNetArc.getID() + " From :" + matchedArc.secondNetArc.getStartNode().getID() + "To :" + matchedArc.secondNetArc.getEndNode().getID() + " Weight : " + matchedArc.secondNetArc.getWeight());
        }
        return result;
    }

    public ArrayList<String> getSimilarities() {
        ArrayList<String> result = new ArrayList<String>();
        for (MatchedVertex mv : this.matchedVertices) {
            if (!this.fPND.nodes.contains(mv.firstNetNode)) continue;
            result.add(String.valueOf((Object)mv.firstNetNode.getType()) + " : " + mv.firstNetNode.getID() + " " + mv.firstNetNode.getName());
        }
        ArrayList<Arc> sumOfFirstNetArc = new ArrayList<Arc>();
        ArrayList<MatchedArc> sumOfMatchedNetArc = new ArrayList<MatchedArc>();
        for (MatchedVertex mv : this.matchedVertices) {
            for (MatchedArc a : mv.arclist) {
                if (sumOfFirstNetArc.contains(a.firstNetArc)) continue;
                sumOfFirstNetArc.add(a.firstNetArc);
                sumOfMatchedNetArc.add(a);
            }
        }
        for (MatchedArc a : sumOfMatchedNetArc) {
            if (!a.isWehightEqual.booleanValue()) continue;
            result.add(String.valueOf((Object)a.firstNetArc.getType()) + " : " + a.firstNetArc.getID() + "/" + a.secondNetArc.getID() + " From :" + a.firstNetArc.getStartNode().getID() + "To :" + a.firstNetArc.getEndNode().getID());
        }
        return result;
    }

    public class MatchedVertex {
        public Node firstNetNode;
        public Node secondNetNode;
        public Boolean isNeighbourhoodTheSame = true;
        public ArrayList<MatchedArc> arclist = new ArrayList();

        MatchedVertex(Node n1, Node n2) {
            this.firstNetNode = n1;
            this.secondNetNode = n2;
            this.checkNeighbourhood();
        }

        void checkNeighbourhood() {
            ArrayList<Arc> secondNetArc;
            ArrayList<Arc> firstNetArc;
            int j;
            boolean found;
            int i;
            for (i = 0; i < this.firstNetNode.getInputNodes().size(); ++i) {
                found = false;
                for (j = 0; j < this.secondNetNode.getInputNodes().size(); ++j) {
                    if (!this.firstNetNode.getInputNodes().get(i).getName().equals(this.secondNetNode.getInputNodes().get(j).getName())) continue;
                    found = true;
                    firstNetArc = this.firstNetNode.getInputArcs();
                    secondNetArc = this.secondNetNode.getInputArcs();
                    for (Arc a1 : firstNetArc) {
                        for (Arc a2 : secondNetArc) {
                            if (!a1.getStartNode().getName().equals(a2.getStartNode().getName())) continue;
                            this.arclist.add(new MatchedArc(a1, a2));
                        }
                    }
                }
                if (found) continue;
                this.isNeighbourhoodTheSame = false;
            }
            for (i = 0; i < this.firstNetNode.getOutputNodes().size(); ++i) {
                found = false;
                for (j = 0; j < this.secondNetNode.getOutputNodes().size(); ++j) {
                    if (!this.firstNetNode.getOutputNodes().get(i).getName().equals(this.secondNetNode.getOutputNodes().get(j).getName())) continue;
                    found = true;
                    firstNetArc = this.firstNetNode.getOutputArcs();
                    secondNetArc = this.secondNetNode.getOutputArcs();
                    for (Arc a1 : firstNetArc) {
                        for (Arc a2 : secondNetArc) {
                            if (!a1.getEndNode().getName().equals(a2.getEndNode().getName())) continue;
                            this.arclist.add(new MatchedArc(a1, a2));
                        }
                    }
                }
                if (found) continue;
                this.isNeighbourhoodTheSame = false;
            }
        }
    }

    public static class MatchedArc {
        Arc firstNetArc = null;
        Arc secondNetArc = null;
        Boolean isWehightEqual = true;
        int minimalWeight = -1;

        public MatchedArc(Arc a1, Arc a2) {
            this.firstNetArc = a1;
            this.secondNetArc = a2;
            if (this.firstNetArc.getWeight() != this.secondNetArc.getWeight()) {
                this.isWehightEqual = false;
                this.minimalWeight = Math.min(this.firstNetArc.getWeight(), this.secondNetArc.getWeight());
            }
        }
    }
}

