/*
 * Decompiled with CFR 0.152.
 */
package holmes.analyse.comparison;

import holmes.analyse.comparison.LevenshteinDistanceDP;
import holmes.darkgui.GUIManager;
import holmes.petrinet.data.PetriNet;
import holmes.petrinet.elements.Node;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JOptionPane;

public class InvariantComparator
implements Runnable {
    public PetriNet pn1;
    public PetriNet pn2;
    public HashMap<Node, Node> matchedVertices = new HashMap();
    public boolean mode = true;
    public boolean invariantType = true;

    public InvariantComparator(PetriNet p1, PetriNet p2) {
        this.pn1 = p1;
        this.pn2 = p2;
    }

    public HashMap<Integer, Integer> idealTInvariantMatching() {
        HashMap<Integer, Integer> ideallyMatchedInvariants = new HashMap<Integer, Integer>();
        for (int in1 = 0; in1 < this.pn1.getT_InvMatrix().size(); ++in1) {
            ArrayList<Integer> invariant1 = this.pn1.getT_InvMatrix().get(in1);
            for (int in2 = 0; in2 < this.pn2.getT_InvMatrix().size(); ++in2) {
                if (ideallyMatchedInvariants.values().contains(in2)) continue;
                ArrayList<Integer> invariant2 = this.pn2.getT_InvMatrix().get(in2);
                int invariantSize = 0;
                int invariantOverlap = 0;
                for (int i = 0; i < invariant1.size(); ++i) {
                    Node matched = this.matchedVertices.get(this.pn1.getTransitions().get(i));
                    int index = this.pn2.getTransitions().indexOf(matched);
                    if (invariant1.get(i) == 0) continue;
                    ++invariantSize;
                    if (index == -1 || invariant2.get(index) != invariant1.get(i)) continue;
                    ++invariantOverlap;
                }
                if (invariantSize != invariantOverlap || invariantSize == 0 || invariantOverlap == 0) continue;
                ideallyMatchedInvariants.put(in1, in2);
            }
        }
        return ideallyMatchedInvariants;
    }

    public HashMap<Integer, Integer> idealPInvariantMatching() {
        HashMap<Integer, Integer> ideallyMatchedInvariants = new HashMap<Integer, Integer>();
        for (int in1 = 0; in1 < this.pn1.getP_InvMatrix().size(); ++in1) {
            ArrayList<Integer> invariant1 = this.pn1.getP_InvMatrix().get(in1);
            for (int in2 = 0; in2 < this.pn2.getP_InvMatrix().size(); ++in2) {
                if (ideallyMatchedInvariants.values().contains(in2)) continue;
                ArrayList<Integer> invariant2 = this.pn2.getP_InvMatrix().get(in2);
                int invariantSize = 0;
                int invariantOverlap = 0;
                for (int i = 0; i < invariant1.size(); ++i) {
                    Node matched = this.matchedVertices.get(this.pn1.getPlaces().get(i));
                    int index = this.pn2.getPlaces().indexOf(matched);
                    if (invariant1.get(i) == 0) continue;
                    ++invariantSize;
                    if (index == -1 || invariant2.get(index) != invariant1.get(i)) continue;
                    ++invariantOverlap;
                }
                if (invariantSize != invariantOverlap || invariantSize == 0 || invariantOverlap == 0) continue;
                ideallyMatchedInvariants.put(in1, in2);
            }
        }
        return ideallyMatchedInvariants;
    }

    public HashMap<Integer, Integer> bestTInvariantMatching() {
        HashMap<Integer, Integer> bestMatchedInvariants = new HashMap<Integer, Integer>();
        for (int in1 = 0; in1 < this.pn1.getT_InvMatrix().size(); ++in1) {
            ArrayList<Integer> invariant1 = this.pn1.getT_InvMatrix().get(in1);
            ArrayList<Integer> resultsForOverlaping = new ArrayList<Integer>();
            for (int in2 = 0; in2 < this.pn2.getT_InvMatrix().size(); ++in2) {
                if (bestMatchedInvariants.values().contains(in2)) continue;
                ArrayList<Integer> invariant2 = this.pn2.getT_InvMatrix().get(in2);
                int invariantSize = 0;
                int invariantOverlap = 0;
                for (int i = 0; i < invariant1.size(); ++i) {
                    Node matched = this.matchedVertices.get(this.pn1.getTransitions().get(i));
                    int index = this.pn2.getTransitions().indexOf(matched);
                    if (invariant1.get(i) == 0) continue;
                    ++invariantSize;
                    if (index == -1 || invariant2.get(index) != invariant1.get(i)) continue;
                    ++invariantOverlap;
                }
                resultsForOverlaping.add(invariantOverlap);
            }
            int bestMatch = resultsForOverlaping.indexOf(Collections.max(resultsForOverlaping));
            bestMatchedInvariants.put(in1, bestMatch);
        }
        return bestMatchedInvariants;
    }

    public HashMap<Integer, Integer> bestPInvariantMatching() {
        HashMap<Integer, Integer> bestMatchedInvariants = new HashMap<Integer, Integer>();
        for (int in1 = 0; in1 < this.pn1.getP_InvMatrix().size(); ++in1) {
            ArrayList<Integer> invariant1 = this.pn1.getP_InvMatrix().get(in1);
            ArrayList<Integer> resultsForOverlaping = new ArrayList<Integer>();
            for (int in2 = 0; in2 < this.pn2.getP_InvMatrix().size(); ++in2) {
                if (bestMatchedInvariants.values().contains(in2)) continue;
                ArrayList<Integer> invariant2 = this.pn2.getP_InvMatrix().get(in2);
                int invariantSize = 0;
                int invariantOverlap = 0;
                for (int i = 0; i < invariant1.size(); ++i) {
                    Node matched = this.matchedVertices.get(this.pn1.getPlaces().get(i));
                    int index = this.pn2.getPlaces().indexOf(matched);
                    if (invariant1.get(i) == 0) continue;
                    ++invariantSize;
                    if (index == -1 || invariant2.get(index) != invariant1.get(i)) continue;
                    ++invariantOverlap;
                }
                resultsForOverlaping.add(invariantOverlap);
            }
            int bestMatch = resultsForOverlaping.indexOf(Collections.max(resultsForOverlaping));
            bestMatchedInvariants.put(in1, bestMatch);
        }
        return bestMatchedInvariants;
    }

    public HashMap<Node, Node> matchVertices(int type) {
        HashMap<Node, Node> mv = null;
        mv = this.invariantType ? this.matchTransitions(type) : this.matchPlaces(type);
        return mv;
    }

    private HashMap<Node, Node> matchPlaces(int type) {
        block8: {
            block9: {
                this.matchedVertices.clear();
                boolean dupication = false;
                for (Node node : this.pn1.getPlaces()) {
                    for (Node node2 : this.pn1.getPlaces()) {
                        if (node.getID() == node2.getID() || !node.getName().equals(node2.getName())) continue;
                        JOptionPane.showMessageDialog(null, "In the net 1 there exists at least 2 nodes with the same name", "ErrorBox: name duplication", 0);
                    }
                }
                for (Node node : this.pn2.getPlaces()) {
                    for (Node node3 : this.pn2.getPlaces()) {
                        if (node.getID() == node3.getID() || !node.getName().equals(node3.getName())) continue;
                        JOptionPane.showMessageDialog(null, "In the net 2 there exists at least 2 nodes with the same name", "ErrorBox: name duplication", 0);
                    }
                }
                if (dupication) break block8;
                if (type != 0) break block9;
                for (Node node : this.pn1.getPlaces()) {
                    for (Node node4 : this.pn2.getPlaces()) {
                        if (!node.getName().equals(node4.getName())) continue;
                        this.matchedVertices.put(node, node4);
                    }
                }
                break block8;
            }
            if (type != 1) break block8;
            for (Node node : this.pn1.getPlaces()) {
                ArrayList<Integer> distance = new ArrayList<Integer>();
                for (Node node5 : this.pn2.getPlaces()) {
                    distance.add(LevenshteinDistanceDP.compute_Levenshtein_distanceDP(node.getName(), node5.getName()));
                }
                int n = distance.indexOf(Collections.min(distance));
                this.matchedVertices.put(node, this.pn2.getPlaces().get(n));
            }
        }
        return this.matchedVertices;
    }

    public HashMap<Node, Node> matchTransitions(int type) {
        block8: {
            block9: {
                this.matchedVertices.clear();
                boolean dupication = false;
                for (Node node : this.pn1.getTransitions()) {
                    for (Node node2 : this.pn1.getTransitions()) {
                        if (node.getID() == node2.getID() || !node.getName().equals(node2.getName())) continue;
                        JOptionPane.showMessageDialog(null, "In the net 1 there exists at least 2 nodes with the same name", "ErrorBox: name duplication", 0);
                    }
                }
                for (Node node : this.pn2.getTransitions()) {
                    for (Node node3 : this.pn2.getTransitions()) {
                        if (node.getID() == node3.getID() || !node.getName().equals(node3.getName())) continue;
                        JOptionPane.showMessageDialog(null, "In the net 2 there exists at least 2 nodes with the same name", "ErrorBox: name duplication", 0);
                    }
                }
                if (dupication) break block8;
                if (type != 0) break block9;
                for (Node node : this.pn1.getTransitions()) {
                    for (Node node4 : this.pn2.getTransitions()) {
                        if (!node.getName().equals(node4.getName())) continue;
                        this.matchedVertices.put(node, node4);
                    }
                }
                break block8;
            }
            if (type != 1) break block8;
            for (Node node : this.pn1.getTransitions()) {
                ArrayList<Integer> distance = new ArrayList<Integer>();
                for (Node node5 : this.pn2.getTransitions()) {
                    distance.add(LevenshteinDistanceDP.compute_Levenshtein_distanceDP(node.getName(), node5.getName()));
                }
                int n = distance.indexOf(Collections.min(distance));
                this.matchedVertices.put(node, this.pn2.getTransitions().get(n));
            }
        }
        return this.matchedVertices;
    }

    @Override
    public void run() {
        if (this.mode) {
            if (this.invariantType) {
                HashMap<Integer, Integer> maping = this.idealTInvariantMatching();
                for (Map.Entry<Integer, Integer> ma : maping.entrySet()) {
                    GUIManager.getDefaultGUIManager().accessComparisonWindow().infoPaneInv.append(String.valueOf(ma.getKey()) + " - " + String.valueOf(ma.getValue()) + "\n\r");
                }
                GUIManager.getDefaultGUIManager().accessComparisonWindow().calcIdealScore(maping);
            } else {
                HashMap<Integer, Integer> maping = this.idealPInvariantMatching();
                for (Map.Entry<Integer, Integer> ma : maping.entrySet()) {
                    GUIManager.getDefaultGUIManager().accessComparisonWindow().infoPaneInv.append(String.valueOf(ma.getKey()) + " - " + String.valueOf(ma.getValue()) + "\n\r");
                }
                GUIManager.getDefaultGUIManager().accessComparisonWindow().calcIdealScore(maping);
            }
        } else if (this.invariantType) {
            this.bestTInvariantMatching();
        } else {
            this.bestPInvariantMatching();
        }
    }
}

