/*
 * Decompiled with CFR 0.152.
 */
package holmes.analyse.comparison;

import holmes.analyse.GraphletsCalculator;
import holmes.analyse.SubnetCalculator;
import holmes.files.io.IOprotocols;
import holmes.petrinet.data.PetriNet;
import holmes.petrinet.elements.Node;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Scanner;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;

public class GraphletComparator {
    int orbNumber = 98;
    int testNetExtensionsNumber = 6;

    public GraphletComparator(int orb) {
        this.orbNumber = orb;
    }

    public void compare() {
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 10; ++j) {
                for (int p = 0; p < 10; ++p) {
                    double[][] comparisonTable = new double[this.testNetExtensionsNumber][this.testNetExtensionsNumber];
                    for (int variant = 0; variant < this.testNetExtensionsNumber; ++variant) {
                        for (int variant2 = 0; variant2 < this.testNetExtensionsNumber; ++variant2) {
                            comparisonTable[variant][variant2] = variant != variant2 ? this.calcDGDDA(this.getPath(i, j, p, this.getName(variant)), this.getPath(i, j, p, this.getName(variant2))) : -1.0;
                        }
                    }
                    try {
                        FileWriter myWriter = new FileWriter(this.getPath(i, j, p, "WYNIK"));
                        for (double[] line : comparisonTable) {
                            for (int k = 0; k < line.length; ++k) {
                                Object str = String.valueOf(line[k]);
                                if (k + 1 < line.length) {
                                    str = (String)str + ",";
                                }
                                myWriter.write((String)str);
                            }
                            myWriter.write("\n");
                        }
                        myWriter.close();
                        System.out.println("Successfully wrote to the file - i:" + i + " j:" + j + " p:" + p);
                        continue;
                    }
                    catch (IOException e) {
                        System.out.println("An error occurred - i:" + i + " j:" + j + " p:" + p);
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public String getPath(int i, int j, int p, String name) {
        return "/home/Szavislav/Eksperyment/Wyniki/i" + i + "j" + j + "/i" + i + "j" + j + "p" + p + "/i" + i + "j" + j + "p" + p + "-" + name + "-DGDDA.txt";
    }

    public String getPath(int d, int i, int j, int p, String name) {
        return "/home/bartek/Eksperyment/Wyniki/d" + d + "i" + i + "j" + j + "/d" + d + "i" + i + "j" + j + "p" + p + "/d" + d + "i" + i + "j" + j + "p" + p + "-" + name + "-DGDDA.txt";
    }

    public void subNetcompare(String path) {
        for (int i = 0; i < 41; i += 5) {
            for (int j = 0; j < 41; j += 5) {
                for (int p = 0; p < 100; ++p) {
                    PetriNet pn1 = this.compareSpecificType(i, j, p, path, "BASE");
                    PetriNet petriNet = this.compareSpecificType(i, j, p, path, "P3OVARIANT");
                }
            }
        }
    }

    public void complexNDcompare(String path) {
        for (int i = 0; i < 41; i += 5) {
            for (int j = 0; j < 41; j += 5) {
                for (int p = 0; p < 100; ++p) {
                    PetriNet pn1 = this.compareSpecificType(i, j, p, path, "BASE");
                    PetriNet petriNet = this.compareSpecificType(i, j, p, path, "P3OVARIANT");
                }
            }
        }
    }

    private PetriNet compareSpecificType(int i, int j, int p, String path, String type) {
        IOprotocols io = new IOprotocols();
        return io.serverReadPNT(path + "/i" + i + "j" + j + "/i" + i + "j" + j + "p" + p + "/i" + i + "j" + j + "p" + p + "-" + type + ".pnt", 99);
    }

    public String compareNetdiv(int k, int deep, PetriNet pn1, PetriNet pn2) {
        ArrayList<SubnetCalculator.SubNet> egoPN2 = new ArrayList<SubnetCalculator.SubNet>();
        ArrayList<Object> orbitsPN2 = new ArrayList<Object>();
        ArrayList<long[]> graphletsPN2 = new ArrayList<long[]>();
        ArrayList<EgoNetwork> egs2 = new ArrayList<EgoNetwork>();
        for (Node n : pn2.getNodes()) {
            SubnetCalculator.SubNet sn = this.createEgoNetwork(n, deep);
            egoPN2.add(sn);
            GraphletsCalculator.GraphletsCalculator();
            GraphletsCalculator.getFoundGraphlets();
            ArrayList list = sn.getSubNode().stream().filter(x -> x.getName().equals(n.getName())).collect(Collectors.toCollection(ArrayList::new));
            Object orbits = GraphletsCalculator.vectorOrbit((Node)list.get(0), false);
            long[] singleDRGF = new long[GraphletsCalculator.graphetsList.size()];
            for (int i = 0; i < GraphletsCalculator.graphetsList.size(); ++i) {
                long val;
                int finalI = i;
                singleDRGF[i] = val = GraphletsCalculator.uniqGraphlets.stream().filter(x -> x.getGraphletID() == finalI).count();
            }
            orbitsPN2.add(orbits);
            graphletsPN2.add(singleDRGF);
            GraphletsCalculator.cleanAll();
            EgoNetwork eg = new EgoNetwork(sn.getSubNode().size(), (int[])orbits, singleDRGF, sn);
            egs2.add(eg);
        }
        ArrayList<SubnetCalculator.SubNet> egoPN1 = new ArrayList<SubnetCalculator.SubNet>();
        ArrayList<int[]> orbitsPN1 = new ArrayList<int[]>();
        ArrayList<long[]> graphletsPN1 = new ArrayList<long[]>();
        ArrayList<EgoNetwork> egs1 = new ArrayList<EgoNetwork>();
        for (Node n : pn1.getNodes()) {
            SubnetCalculator.SubNet sn = this.createEgoNetwork(n, deep);
            egoPN1.add(sn);
            GraphletsCalculator.GraphletsCalculator();
            GraphletsCalculator.getFoundGraphlets();
            ArrayList list = sn.getSubNode().stream().filter(x -> x.getName().equals(n.getName())).collect(Collectors.toCollection(ArrayList::new));
            int[] orbits = GraphletsCalculator.vectorOrbit((Node)list.get(0), false);
            long[] singleDRGF = new long[GraphletsCalculator.graphetsList.size()];
            for (int i = 0; i < GraphletsCalculator.graphetsList.size(); ++i) {
                long val;
                int finalI = i;
                singleDRGF[i] = val = GraphletsCalculator.uniqGraphlets.stream().filter(x -> x.getGraphletID() == finalI).count();
            }
            orbitsPN1.add(orbits);
            graphletsPN1.add(singleDRGF);
            GraphletsCalculator.cleanAll();
            EgoNetwork eg = new EgoNetwork(sn.getSubNode().size(), orbits, singleDRGF, sn);
            egs1.add(eg);
        }
        double m1 = 0.0;
        double m2 = 0.0;
        double m = 0.0;
        double ss = 0.0;
        GraphletsCalculator.generateGraphlets();
        for (int g = 0; g < GraphletsCalculator.graphetsList.size(); ++g) {
            if (GraphletsCalculator.graphetsList.get(g).getSubNode().size() != k) continue;
            int S_wG = 0;
            for (EgoNetwork eg : egs1) {
                S_wG = (int)((long)S_wG + eg.graphlets[g]);
            }
            int S_wH = 0;
            for (EgoNetwork eg : egs2) {
                S_wH = (int)((long)S_wH + eg.graphlets[g]);
            }
            if (S_wG == 0 && S_wH == 0) continue;
            m1 += (double)(S_wG ^ 2) / Math.sqrt(S_wG ^ 2 + S_wH ^ 2);
            m2 += (double)(S_wH ^ 2) / Math.sqrt(S_wG ^ 2 + S_wH ^ 2);
            ss += (double)S_wG * (double)S_wH / Math.sqrt(S_wG ^ 2 + S_wH ^ 2);
        }
        m = m1 * m2;
        double netD = ss / m;
        double netd = 0.5 * (1.0 - netD);
        return "k: " + k + " deep: " + deep + " netDiv: " + Double.toString(netd) + "\n\r";
    }

    private SubnetCalculator.SubNet createEgoNetwork(Node n, int i) {
        ArrayList<Node> listOfNodes = new ArrayList<Node>();
        listOfNodes.add(n);
        listOfNodes = this.deepDown(n, i, listOfNodes);
        if (n.getName().contains("srodek")) {
            System.out.println("ie " + i);
            System.out.println("how " + listOfNodes.size());
        }
        return new SubnetCalculator.SubNet(SubnetCalculator.SubNetType.Export, null, null, listOfNodes, null, null);
    }

    private ArrayList<Node> deepDown(Node n, int i, ArrayList<Node> listOfNodes) {
        if (--i < 0) {
            return listOfNodes;
        }
        for (Node m : n.getNeighborsNodes()) {
            if (listOfNodes.contains(m)) continue;
            listOfNodes.add(m);
            listOfNodes = this.addUnique(this.deepDown(m, i, listOfNodes), listOfNodes);
        }
        return listOfNodes;
    }

    private ArrayList<Node> addUnique(ArrayList<Node> l1, ArrayList<Node> l2) {
        for (Node n : l1) {
            if (l2.contains(n)) continue;
            l2.add(n);
        }
        return l2;
    }

    private String getName(int variant) {
        switch (variant) {
            case 0: {
                return "BASE";
            }
            case 1: {
                return "S4VARIANT";
            }
            case 2: {
                return "K4LVARIANT";
            }
            case 3: {
                return "K4LkVARIANT";
            }
            case 4: {
                return "E2VARIANT";
            }
            case 5: {
                return "C6VARIANT";
            }
            case 6: {
                return "P3VARIANT";
            }
            case 7: {
                return "P3OVARIANT";
            }
        }
        return "BASE";
    }

    public double calcDGDDA(String path1, String path2) {
        double[][] nG = this.lodaN(path1);
        double[][] nH = this.lodaN(path2);
        if (nH == null || nH.length == 0) {
            return -1.0;
        }
        int maxk = Math.max(nG[0].length, nH[0].length);
        double[] d = new double[this.orbNumber];
        for (int orb = 0; orb < this.orbNumber; ++orb) {
            double di = 0.0;
            for (int k = 0; k < maxk; ++k) {
                if (k >= nG[orb].length) {
                    di += Math.pow(0.0 - nH[orb][k], 2.0);
                    continue;
                }
                if (k >= nH[orb].length) {
                    di += Math.pow(nG[orb][k] - 0.0, 2.0);
                    continue;
                }
                di += Math.pow(nG[orb][k] - nH[orb][k], 2.0);
            }
            d[orb] = 1.0 - 1.0 / Math.sqrt(2.0) * Math.sqrt(di);
        }
        return DoubleStream.of(d).sum() / (double)this.orbNumber;
    }

    public double[] calcDGDDApartitioned(String path1, String path2) {
        double[][] nG = this.lodaN(path1);
        double[][] nH = this.lodaN(path2);
        if (nH == null || nH.length == 0) {
            return new double[0];
        }
        int maxk = Math.max(nG[0].length, nH[0].length);
        double[] d = new double[this.orbNumber];
        for (int orb = 0; orb < this.orbNumber; ++orb) {
            double di = 0.0;
            for (int k = 0; k < maxk; ++k) {
                if (k >= nG[orb].length) {
                    di += Math.pow(0.0 - nH[orb][k], 2.0);
                    continue;
                }
                if (k >= nH[orb].length) {
                    di += Math.pow(nG[orb][k] - 0.0, 2.0);
                    continue;
                }
                di += Math.pow(nG[orb][k] - nH[orb][k], 2.0);
            }
            d[orb] = 1.0 - 1.0 / Math.sqrt(2.0) * Math.sqrt(di);
        }
        return d;
    }

    private double[][] lodaN(String path) {
        Scanner scanner = null;
        try {
            scanner = new Scanner(new File(path));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        boolean startRead = false;
        ArrayList<double[]> result = new ArrayList<double[]>();
        if (scanner != null) {
            while (scanner.hasNext()) {
                String line = scanner.nextLine();
                if (line.contains("-n")) {
                    startRead = true;
                    line = scanner.nextLine();
                }
                if (!startRead) continue;
                line = line.replace("[", "");
                line = line.replace("]", "");
                line = line.replace("NaN", "0.0");
                String[] lin = line.split(",");
                double[] shortResult = new double[lin.length];
                for (int i = 0; i < lin.length; ++i) {
                    try {
                        shortResult[i] = Double.parseDouble(lin[i]);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                result.add(shortResult);
            }
        }
        scanner.close();
        double[][] matrix = new double[result.size()][];
        return (double[][])result.toArray((T[])matrix);
    }

    public class EgoNetwork {
        public int size = 0;
        public int[] orbits = new int[0];
        public long[] graphlets = new long[0];
        public SubnetCalculator.SubNet subNet;

        public EgoNetwork(int s, int[] o, long[] g, SubnetCalculator.SubNet sn) {
            this.size = s;
            this.orbits = o;
            this.graphlets = g;
            this.subNet = sn;
        }
    }
}

