/*
 * Decompiled with CFR 0.152.
 */
package holmes.analyse.comparison;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;

public class Benchmarker {
    HashMap<String, Date> map = new HashMap();

    public Benchmarker(String path) {
        this.getTimestamps(path);
        this.listFilesForFolder(new File("/home/bszawulak/Dokumenty/Eksperyment/Wyniki/i0j0"));
    }

    public Benchmarker() {
        int i;
        for (i = 0; i < 45; i += 5) {
            this.listFilesForFolder(new File("/home/bszawulak/Dokumenty/Eksperyment/Wyniki/i" + i + "j" + i));
        }
        for (i = 0; i < 45; i += 5) {
            for (int p = 0; p < 99; ++p) {
                int r = p + 1;
                Date n1 = this.map.get("i" + i + "j" + i + "p" + p + "-BASE-DGDDA.txt");
                Date n2 = this.map.get("i" + i + "j" + i + "p" + r + "-BASE-DGDDA.txt");
                long diffInMillies = Math.abs(n1.getTime() - n2.getTime());
                System.out.println("-> i" + i + "j" + i + "p" + r + "   ===== " + diffInMillies);
            }
        }
    }

    public void listFilesForFolder(File folder) {
        for (File fileEntry : folder.listFiles()) {
            if (fileEntry.isDirectory()) {
                this.listFilesForFolder(fileEntry);
                continue;
            }
            if (!fileEntry.getName().contains("-BASE-DGDDA.txt")) continue;
            System.out.print(fileEntry.getName() + " -> ");
            this.map.put(fileEntry.getName(), this.getTimestamps(fileEntry.getPath()));
        }
    }

    private Date getTimestamps(String pat) {
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
        Path path = Paths.get(pat, new String[0]);
        try {
            BasicFileAttributes attr = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
            System.out.println("File modified time - " + sdf.format(attr.lastModifiedTime().toMillis()));
            attr.lastModifiedTime().toMillis();
        }
        catch (IOException e) {
            System.out.println("Error while reading file attributes " + e.getMessage());
        }
        return new Date();
    }
}

