/*
 * Decompiled with CFR 0.152.
 */
package holmes.analyse.XTPN;

import holmes.analyse.XTPN.MathToolsXTPN;
import holmes.analyse.XTPN.PlaceNanoXTPN;
import holmes.analyse.XTPN.TransitionNanoXTPN;
import holmes.darkgui.GUIManager;
import holmes.petrinet.elements.Place;
import holmes.petrinet.elements.PlaceXTPN;
import holmes.petrinet.elements.Transition;
import holmes.petrinet.elements.TransitionXTPN;
import java.util.ArrayList;

public class AlgorithmsXTPN {
    private static final GUIManager overlord = GUIManager.getDefaultGUIManager();
    ArrayList<TransitionNanoXTPN> preTransitionsNanoA1 = new ArrayList();
    ArrayList<TransitionNanoXTPN> postTransitionsNanoA1 = new ArrayList();
    PlaceNanoXTPN placeNanoA1 = null;
    TransitionXTPN transLifeA2 = null;
    ArrayList<TransitionNanoXTPN> preTransitionsNanoA2;
    ArrayList<TransitionNanoXTPN> compTransitionsNanoA2;
    ArrayList<PlaceNanoXTPN> prePlacesA2;
    long maxSteps = 0L;
    boolean areReadArcs = false;
    boolean Alg1ReadyToProceed = false;

    public int getTokensPerPlaceAlg1(PlaceXTPN placeXTPN, int digits, int minMaxAvg, boolean considerOutputTransitions) {
        if (!this.Alg1ReadyToProceed) {
            return -1;
        }
        int result = 0;
        for (long time = 1L; time < this.maxSteps; ++time) {
            if (!this.areReadArcs) {
                AlgorithmsXTPN.shuffleElements(this.preTransitionsNanoA1);
            }
            if (time == 22L) {
                boolean bl = true;
            }
            AlgorithmsXTPN.processInputTransitions(this.preTransitionsNanoA1, this.placeNanoA1);
            if (considerOutputTransitions) {
                AlgorithmsXTPN.shuffleElements(this.preTransitionsNanoA1);
                AlgorithmsXTPN.processOutputTransitions(this.postTransitionsNanoA1, this.placeNanoA1);
            }
            this.placeNanoA1.updateTokensSet_N(1);
            if (this.placeNanoA1.tokens_N.size() <= result) continue;
            result = this.placeNanoA1.tokens_N.size();
        }
        return result;
    }

    public long calculateMaxStepsNumberPreAlg1(PlaceXTPN placeXTPN, int digits, int minMaxAvg, boolean considerOutputTransitions) {
        TransitionNanoXTPN.PlaceArcWeight paw;
        TransitionNanoXTPN nt;
        ArrayList<Transition> preTransitions = placeXTPN.getInputTransitions();
        ArrayList<Transition> postTransitions = placeXTPN.getOutputTransitions();
        ArrayList<Transition> transitions = overlord.getWorkspace().getProject().getTransitions();
        boolean areRational = AlgorithmsXTPN.areRationalsAlg1(preTransitions, placeXTPN, digits);
        if (!areRational) {
            areRational = AlgorithmsXTPN.areRationalsAlg1(postTransitions, placeXTPN, digits);
        }
        int multiplier = 1;
        if (areRational) {
            multiplier = digits;
        }
        this.placeNanoA1 = new PlaceNanoXTPN(placeXTPN, overlord.getWorkspace().getProject().getPlaces().indexOf(placeXTPN));
        this.placeNanoA1.gammaL_N = (int)(this.placeNanoA1.gammaL * (double)multiplier);
        this.placeNanoA1.gammaU_N = (int)(this.placeNanoA1.gammaU * (double)multiplier);
        ArrayList<Integer> lcmCandidates = new ArrayList<Integer>();
        for (Transition t : preTransitions) {
            nt = new TransitionNanoXTPN((TransitionXTPN)t, transitions.indexOf(t));
            if (((TransitionXTPN)t).isAlphaModeActive()) {
                nt.isAlphaType = true;
                nt.alphaL_N = (int)(nt.alphaL * (double)multiplier);
                nt.alphaU_N = (int)(nt.alphaU * (double)multiplier);
            } else {
                nt.isAlphaType = false;
                nt.alphaL = 0.0;
                nt.alphaU = 0.0;
            }
            if (((TransitionXTPN)t).isBetaModeActive()) {
                nt.isBetaType = true;
                nt.betaL_N = (int)(nt.betaL * (double)multiplier);
                nt.betaU_N = (int)(nt.betaU * (double)multiplier);
            } else {
                nt.isBetaType = false;
                nt.betaL = 0.0;
                nt.betaU = 0.0;
            }
            paw = new TransitionNanoXTPN.PlaceArcWeight(nt);
            paw.place = this.placeNanoA1;
            paw.weight = t.getOutputArcWeightTo(placeXTPN);
            nt.postPlaces.add(paw);
            switch (minMaxAvg) {
                case -1: {
                    nt.tauAlphaLimit = nt.alphaL_N;
                    nt.tauBetaLimit = nt.betaL_N;
                    break;
                }
                case 0: {
                    nt.tauAlphaLimit = (nt.alphaL_N + nt.alphaU_N) / 2;
                    nt.tauBetaLimit = (nt.betaL_N + nt.betaU_N) / 2;
                    break;
                }
                case 1: {
                    nt.tauAlphaLimit = nt.alphaU_N;
                    nt.tauBetaLimit = nt.betaU_N;
                }
            }
            lcmCandidates.add(nt.tauAlphaLimit + nt.tauBetaLimit);
            if (postTransitions.contains(t)) {
                nt.hasReadArcToPlace = true;
                this.areReadArcs = true;
                postTransitions.remove(t);
            }
            this.preTransitionsNanoA1.add(nt);
        }
        if (considerOutputTransitions) {
            for (Transition t : postTransitions) {
                nt = new TransitionNanoXTPN((TransitionXTPN)t, transitions.indexOf(t));
                if (((TransitionXTPN)t).isAlphaModeActive()) {
                    nt.isAlphaType = true;
                    nt.alphaL_N = (int)(nt.alphaL * (double)multiplier);
                    nt.alphaU_N = (int)(nt.alphaU * (double)multiplier);
                } else {
                    nt.isAlphaType = false;
                    nt.alphaL = 0.0;
                    nt.alphaU = 0.0;
                }
                if (((TransitionXTPN)t).isBetaModeActive()) {
                    nt.isBetaType = true;
                    nt.betaL_N = (int)(nt.betaL * (double)multiplier);
                    nt.betaU_N = (int)(nt.betaU * (double)multiplier);
                } else {
                    nt.isBetaType = false;
                    nt.betaL = 0.0;
                    nt.betaU = 0.0;
                }
                paw = new TransitionNanoXTPN.PlaceArcWeight(nt);
                paw.place = this.placeNanoA1;
                paw.weight = t.getInputArcWeightFrom(placeXTPN);
                nt.prePlaces.add(paw);
                switch (minMaxAvg) {
                    case -1: {
                        nt.tauAlphaLimit = nt.alphaU_N;
                        nt.tauBetaLimit = nt.betaU_N;
                        break;
                    }
                    case 0: {
                        nt.tauAlphaLimit = (nt.alphaL_N + nt.alphaU_N) / 2;
                        nt.tauBetaLimit = (nt.betaL_N + nt.betaU_N) / 2;
                        break;
                    }
                    case 1: {
                        nt.tauAlphaLimit = nt.alphaL_N;
                        nt.tauBetaLimit = nt.betaL_N;
                    }
                }
                this.postTransitionsNanoA1.add(nt);
            }
        }
        int[] arr = lcmCandidates.stream().mapToInt(i -> i).toArray();
        this.maxSteps = MathToolsXTPN.lcm_of_array_elements(arr);
        this.maxSteps += (long)this.placeNanoA1.gammaU_N;
        for (TransitionNanoXTPN t : this.preTransitionsNanoA1) {
            t.tauAlpha_N = t.hasReadArcToPlace ? -1 : 0;
            t.tauBeta_N = -1;
        }
        for (TransitionNanoXTPN t : this.postTransitionsNanoA1) {
            t.tauAlpha_N = -1;
            t.tauBeta_N = -1;
        }
        this.Alg1ReadyToProceed = true;
        return this.maxSteps;
    }

    public int getTokensPerPlaceAlg2(PlaceXTPN placeXTPN, int digits, int minMaxAvg, boolean considerOutputTransitions) {
        if (!this.Alg1ReadyToProceed) {
            return -1;
        }
        int result = 0;
        for (long time = 1L; time < this.maxSteps; ++time) {
            if (!this.areReadArcs) {
                AlgorithmsXTPN.shuffleElements(this.preTransitionsNanoA1);
            }
            if (time == 22L) {
                boolean bl = true;
            }
            AlgorithmsXTPN.processInputTransitions(this.preTransitionsNanoA1, this.placeNanoA1);
            if (considerOutputTransitions) {
                AlgorithmsXTPN.shuffleElements(this.preTransitionsNanoA1);
                AlgorithmsXTPN.processOutputTransitions(this.postTransitionsNanoA1, this.placeNanoA1);
            }
            this.placeNanoA1.updateTokensSet_N(1);
            if (this.placeNanoA1.tokens_N.size() <= result) continue;
            result = this.placeNanoA1.tokens_N.size();
        }
        return result;
    }

    public long calculateLifenessPreAlg2(TransitionXTPN t_x, int digits, int inputTransSpeed, int competingTransSpeed) {
        TransitionNanoXTPN.PlaceArcWeight paw;
        TransitionNanoXTPN nt;
        ArrayList<Place> prePlaces = t_x.getInputPlaces();
        ArrayList<Transition> preTransitions = new ArrayList<Transition>();
        ArrayList<Transition> compTransitions = new ArrayList<Transition>();
        ArrayList<Transition> transitions = overlord.getWorkspace().getProject().getTransitions();
        for (Place p : prePlaces) {
            for (Transition transition : p.getInputTransitions()) {
                if (preTransitions.contains(transition)) continue;
                preTransitions.add(transition);
            }
        }
        for (Place p : prePlaces) {
            for (Transition transition : p.getOutputTransitions()) {
                if (compTransitions.contains(transition) || t_x.equals(transition)) continue;
                compTransitions.add(transition);
            }
        }
        ArrayList<Transition> transitionsPrePost = new ArrayList<Transition>();
        transitionsPrePost.addAll(preTransitions);
        transitionsPrePost.addAll(compTransitions);
        transitionsPrePost.add(t_x);
        boolean areRational = AlgorithmsXTPN.areRationalsAlg2(transitionsPrePost, prePlaces, digits);
        int multiplier = 1;
        if (areRational) {
            multiplier = digits;
        }
        for (Place place : prePlaces) {
            PlaceNanoXTPN placeNano = new PlaceNanoXTPN((PlaceXTPN)place, overlord.getWorkspace().getProject().getPlaces().indexOf(place));
            placeNano.gammaL_N = (int)(placeNano.gammaL * (double)multiplier);
            placeNano.gammaU_N = (int)(placeNano.gammaU * (double)multiplier);
            this.prePlacesA2.add(placeNano);
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (Transition t : preTransitions) {
            nt = new TransitionNanoXTPN((TransitionXTPN)t, transitions.indexOf(t));
            if (((TransitionXTPN)t).isAlphaModeActive()) {
                nt.isAlphaType = true;
                nt.alphaL_N = (int)(nt.alphaL * (double)multiplier);
                nt.alphaU_N = (int)(nt.alphaU * (double)multiplier);
            } else {
                nt.isAlphaType = false;
                nt.alphaL = 0.0;
                nt.alphaU = 0.0;
            }
            if (((TransitionXTPN)t).isBetaModeActive()) {
                nt.isBetaType = true;
                nt.betaL_N = (int)(nt.betaL * (double)multiplier);
                nt.betaU_N = (int)(nt.betaU * (double)multiplier);
            } else {
                nt.isBetaType = false;
                nt.betaL = 0.0;
                nt.betaU = 0.0;
            }
            paw = new TransitionNanoXTPN.PlaceArcWeight(nt);
            paw.place = this.placeNanoA1;
            nt.postPlaces.add(paw);
            switch (inputTransSpeed) {
                case -1: {
                    nt.tauAlphaLimit = nt.alphaL_N;
                    nt.tauBetaLimit = nt.betaL_N;
                    break;
                }
                case 0: {
                    nt.tauAlphaLimit = (nt.alphaL_N + nt.alphaU_N) / 2;
                    nt.tauBetaLimit = (nt.betaL_N + nt.betaU_N) / 2;
                    break;
                }
                case 1: {
                    nt.tauAlphaLimit = nt.alphaU_N;
                    nt.tauBetaLimit = nt.betaU_N;
                }
            }
            arrayList.add(nt.tauAlphaLimit + nt.tauBetaLimit);
            if (compTransitions.contains(t)) {
                nt.hasReadArcToPlace = true;
                this.areReadArcs = true;
                compTransitions.remove(t);
            }
            this.preTransitionsNanoA1.add(nt);
        }
        for (Transition t : compTransitions) {
            nt = new TransitionNanoXTPN((TransitionXTPN)t, transitions.indexOf(t));
            if (((TransitionXTPN)t).isAlphaModeActive()) {
                nt.isAlphaType = true;
                nt.alphaL_N = (int)(nt.alphaL * (double)multiplier);
                nt.alphaU_N = (int)(nt.alphaU * (double)multiplier);
            } else {
                nt.isAlphaType = false;
                nt.alphaL = 0.0;
                nt.alphaU = 0.0;
            }
            if (((TransitionXTPN)t).isBetaModeActive()) {
                nt.isBetaType = true;
                nt.betaL_N = (int)(nt.betaL * (double)multiplier);
                nt.betaU_N = (int)(nt.betaU * (double)multiplier);
            } else {
                nt.isBetaType = false;
                nt.betaL = 0.0;
                nt.betaU = 0.0;
            }
            paw = new TransitionNanoXTPN.PlaceArcWeight(nt);
            paw.place = this.placeNanoA1;
            nt.prePlaces.add(paw);
            switch (competingTransSpeed) {
                case -1: {
                    nt.tauAlphaLimit = nt.alphaU_N;
                    nt.tauBetaLimit = nt.betaU_N;
                    break;
                }
                case 0: {
                    nt.tauAlphaLimit = (nt.alphaL_N + nt.alphaU_N) / 2;
                    nt.tauBetaLimit = (nt.betaL_N + nt.betaU_N) / 2;
                    break;
                }
                case 1: {
                    nt.tauAlphaLimit = nt.alphaL_N;
                    nt.tauBetaLimit = nt.betaL_N;
                }
            }
            this.postTransitionsNanoA1.add(nt);
        }
        int[] nArray = arrayList.stream().mapToInt(i -> i).toArray();
        this.maxSteps = MathToolsXTPN.lcm_of_array_elements(nArray);
        this.maxSteps += (long)this.placeNanoA1.gammaU_N;
        for (TransitionNanoXTPN t : this.preTransitionsNanoA1) {
            t.tauAlpha_N = t.hasReadArcToPlace ? -1 : 0;
            t.tauBeta_N = -1;
        }
        for (TransitionNanoXTPN t : this.postTransitionsNanoA1) {
            t.tauAlpha_N = -1;
            t.tauBeta_N = -1;
        }
        this.Alg1ReadyToProceed = true;
        return this.maxSteps;
    }

    private static void processInputTransitions(ArrayList<TransitionNanoXTPN> transitions, PlaceNanoXTPN place) {
        for (TransitionNanoXTPN inputTrans : transitions) {
            if (inputTrans.hasReadArcToPlace) {
                if (inputTrans.tauBeta_N != -1) {
                    ++inputTrans.tauBeta_N;
                    if (inputTrans.tauBeta_N == inputTrans.tauBetaLimit) {
                        for (TransitionNanoXTPN.PlaceArcWeight paw : inputTrans.postPlaces) {
                            paw.place.addTokens_N(paw.weight);
                        }
                        inputTrans.tauBeta_N = -1;
                        if (AlgorithmsXTPN.canActivate(inputTrans)) {
                            inputTrans.tauAlpha_N = 0;
                            continue;
                        }
                        inputTrans.tauAlpha_N = -1;
                        continue;
                    }
                    if (inputTrans.tauBeta_N <= inputTrans.tauBetaLimit) continue;
                    int error = 1;
                    ++error;
                    continue;
                }
                if (AlgorithmsXTPN.canActivate(inputTrans)) {
                    if (inputTrans.tauAlpha_N == -1) {
                        inputTrans.tauAlpha_N = 0;
                        if (inputTrans.tauAlpha_N != inputTrans.tauAlphaLimit) continue;
                        inputTrans.tauBeta_N = 0;
                        for (TransitionNanoXTPN.PlaceArcWeight paw : inputTrans.prePlaces) {
                            paw.place.removeTokens_N(paw.weight);
                        }
                        continue;
                    }
                    ++inputTrans.tauAlpha_N;
                    if (inputTrans.tauAlpha_N != inputTrans.tauAlphaLimit) continue;
                    inputTrans.tauBeta_N = 0;
                    for (TransitionNanoXTPN.PlaceArcWeight paw : inputTrans.prePlaces) {
                        paw.place.removeTokens_N(paw.weight);
                    }
                    continue;
                }
                inputTrans.tauAlpha_N = -1;
                continue;
            }
            ++inputTrans.tauAlpha_N;
            if (inputTrans.tauAlpha_N != inputTrans.tauAlphaLimit + inputTrans.tauBetaLimit) continue;
            for (TransitionNanoXTPN.PlaceArcWeight paw : inputTrans.postPlaces) {
                paw.place.addTokens_N(paw.weight);
            }
            inputTrans.tauAlpha_N = 0;
        }
    }

    private static void processOutputTransitions(ArrayList<TransitionNanoXTPN> transitions, PlaceNanoXTPN place) {
        for (TransitionNanoXTPN outputTrans : transitions) {
            if (outputTrans.tauBeta_N != -1) {
                ++outputTrans.tauBeta_N;
                if (outputTrans.tauBeta_N == outputTrans.tauBetaLimit) {
                    outputTrans.tauBeta_N = -1;
                    if (AlgorithmsXTPN.canActivate(outputTrans)) {
                        outputTrans.tauAlpha_N = 0;
                        continue;
                    }
                    outputTrans.tauAlpha_N = -1;
                    continue;
                }
                if (outputTrans.tauBeta_N <= outputTrans.tauBetaLimit) continue;
                int error = 1;
                ++error;
                continue;
            }
            if (AlgorithmsXTPN.canActivate(outputTrans)) {
                if (outputTrans.tauAlpha_N == -1) {
                    outputTrans.tauAlpha_N = 0;
                    if (outputTrans.tauAlpha_N != outputTrans.tauAlphaLimit) continue;
                    outputTrans.tauBeta_N = 0;
                    for (TransitionNanoXTPN.PlaceArcWeight paw : outputTrans.prePlaces) {
                        paw.place.removeTokens_N(paw.weight);
                    }
                    continue;
                }
                ++outputTrans.tauAlpha_N;
                if (outputTrans.tauAlpha_N != outputTrans.tauAlphaLimit) continue;
                outputTrans.tauBeta_N = 0;
                outputTrans.tauAlpha_N = -1;
                for (TransitionNanoXTPN.PlaceArcWeight paw : outputTrans.prePlaces) {
                    paw.place.removeTokens_N(paw.weight);
                }
                continue;
            }
            outputTrans.tauAlpha_N = -1;
        }
    }

    private static boolean canActivate(TransitionNanoXTPN outputTransition) {
        for (TransitionNanoXTPN.PlaceArcWeight paw : outputTransition.prePlaces) {
            if (paw.place.tokens_N.isEmpty() || paw.place.tokens_N.size() < paw.weight) {
                return false;
            }
            boolean placeOK = false;
            int neededTokens = paw.weight;
            for (int token : paw.place.tokens_N) {
                if (token >= paw.place.gammaL_N) {
                    --neededTokens;
                }
                if (neededTokens != 0) continue;
                placeOK = true;
                break;
            }
            if (placeOK) continue;
            return false;
        }
        return true;
    }

    private static boolean areRationalsAlg1(ArrayList<Transition> transitions, PlaceXTPN placeXTPN, int digits) {
        long checkIfRationals = 0L;
        boolean isRational = false;
        for (Transition t : transitions) {
            checkIfRationals = (long)(((TransitionXTPN)t).getAlphaMinValue() * (double)digits);
            if (checkIfRationals % (long)digits != 0L) {
                isRational = true;
                break;
            }
            checkIfRationals = (long)(((TransitionXTPN)t).getAlphaMaxValue() * (double)digits);
            if (checkIfRationals % (long)digits != 0L) {
                isRational = true;
                break;
            }
            checkIfRationals = (long)(((TransitionXTPN)t).getAlphaMinValue() * (double)digits);
            if (checkIfRationals % (long)digits != 0L) {
                isRational = true;
                break;
            }
            checkIfRationals = (long)(((TransitionXTPN)t).getAlphaMaxValue() * (double)digits);
            if (checkIfRationals % (long)digits == 0L) continue;
            isRational = true;
            break;
        }
        if ((checkIfRationals = (long)(placeXTPN.getGammaMaxValue() * (double)digits)) % (long)digits != 0L) {
            isRational = true;
        }
        if ((checkIfRationals = (long)(placeXTPN.getGammaMinValue() * (double)digits)) % (long)digits != 0L) {
            isRational = true;
        }
        return isRational;
    }

    private static boolean areRationalsAlg2(ArrayList<Transition> transitions, ArrayList<Place> places, int digits) {
        long checkIfRationals = 0L;
        boolean isRational = false;
        for (Transition t : transitions) {
            checkIfRationals = (long)(((TransitionXTPN)t).getAlphaMinValue() * (double)digits);
            if (checkIfRationals % (long)digits != 0L) {
                isRational = true;
                break;
            }
            checkIfRationals = (long)(((TransitionXTPN)t).getAlphaMaxValue() * (double)digits);
            if (checkIfRationals % (long)digits != 0L) {
                isRational = true;
                break;
            }
            checkIfRationals = (long)(((TransitionXTPN)t).getAlphaMinValue() * (double)digits);
            if (checkIfRationals % (long)digits != 0L) {
                isRational = true;
                break;
            }
            checkIfRationals = (long)(((TransitionXTPN)t).getAlphaMaxValue() * (double)digits);
            if (checkIfRationals % (long)digits == 0L) continue;
            isRational = true;
            break;
        }
        for (Place p : places) {
            checkIfRationals = (long)(((PlaceXTPN)p).getGammaMaxValue() * (double)digits);
            if (checkIfRationals % (long)digits != 0L) {
                isRational = true;
                break;
            }
            checkIfRationals = (long)(((PlaceXTPN)p).getGammaMinValue() * (double)digits);
            if (checkIfRationals % (long)digits == 0L) continue;
            isRational = true;
            break;
        }
        return isRational;
    }

    private static void shuffleElements(ArrayList<TransitionNanoXTPN> preTransitionsNano) {
        for (int i = 0; i < preTransitionsNano.size(); ++i) {
            int randomIndex = (int)(Math.random() * (double)preTransitionsNano.size());
            TransitionNanoXTPN temp = preTransitionsNano.get(i);
            preTransitionsNano.set(i, preTransitionsNano.get(randomIndex));
            preTransitionsNano.set(randomIndex, temp);
        }
    }

    public class ResultTokensAvg {
        public double avg;
        public double stdDev;
        public double min;
        public double max;
    }
}

