/*
 * Decompiled with CFR 0.152.
 */
package holmes.analyse;

import holmes.darkgui.GUIManager;
import holmes.darkgui.LanguageManager;
import holmes.petrinet.data.PetriNet;
import holmes.petrinet.elements.Arc;
import holmes.petrinet.elements.ElementLocation;
import holmes.petrinet.elements.MetaNode;
import holmes.petrinet.elements.Node;
import holmes.petrinet.elements.Place;
import holmes.petrinet.elements.Transition;
import java.util.ArrayList;

public class NetPropertiesAnalyzer {
    private static final GUIManager overlord = GUIManager.getDefaultGUIManager();
    private static final LanguageManager lang = GUIManager.getLanguageManager();
    private ArrayList<Arc> arcs;
    private ArrayList<Place> places;
    private ArrayList<Transition> transitions;
    private ArrayList<Node> nodes;
    private ArrayList<MetaNode> metaNodes;
    ArrayList<Node> checked = new ArrayList();

    public NetPropertiesAnalyzer() {
        PetriNet pn = overlord.getWorkspace().getProject();
        this.places = pn.getPlaces();
        this.transitions = pn.getTransitions();
        this.arcs = pn.getArcs();
        this.nodes = pn.getNodes();
        this.metaNodes = pn.getMetaNodes();
    }

    /*
     * WARNING - void declaration
     */
    public ArrayList<ArrayList<Object>> propAnalyze() {
        int n;
        boolean bl;
        int n2;
        boolean bl2;
        boolean bl3;
        boolean arcOut;
        boolean arcIn;
        ArrayList<ArrayList<Object>> NetProps = new ArrayList<ArrayList<Object>>();
        ArrayList<Object> purProp = new ArrayList<Object>();
        purProp.add("PUR");
        purProp.add(false);
        String[] purTxt = new String[]{lang.getText("NPA_entry001"), lang.getText("NPA_entry001d1"), lang.getText("NPA_entry001d2")};
        purProp.add(purTxt);
        NetProps.add(purProp);
        ArrayList<Object> ordProp = new ArrayList<Object>();
        ordProp.add("ORD");
        ordProp.add(false);
        String[] ordTxt = new String[]{lang.getText("NPA_entry002"), lang.getText("NPA_entry002d1"), lang.getText("NPA_entry002d2")};
        ordProp.add(ordTxt);
        NetProps.add(ordProp);
        ArrayList<Object> homProp = new ArrayList<Object>();
        homProp.add("HOM");
        homProp.add(false);
        String[] homTxt = new String[]{lang.getText("NPA_entry003"), lang.getText("NPA_entry003d1"), lang.getText("NPA_entry003d2")};
        homProp.add(homTxt);
        NetProps.add(homProp);
        ArrayList<Object> conProp = new ArrayList<Object>();
        conProp.add("CON");
        conProp.add(false);
        String[] conTxt = new String[]{lang.getText("NPA_entry004"), lang.getText("NPA_entry004d1") + lang.getText("NPA_entry004d2"), lang.getText("NPA_entry004d2")};
        conProp.add(conTxt);
        NetProps.add(conProp);
        ArrayList<Object> scProp = new ArrayList<Object>();
        scProp.add("SC");
        scProp.add(false);
        String[] scTxt = new String[]{lang.getText("NPA_entry005"), lang.getText("NPA_entry005d1") + lang.getText("NPA_entry005d2"), lang.getText("NPA_entry005d2")};
        scProp.add(scTxt);
        NetProps.add(scProp);
        ArrayList<Object> nbmProp = new ArrayList<Object>();
        nbmProp.add("NBM");
        nbmProp.add(false);
        String[] nbmTxt = new String[]{lang.getText("NPA_entry006"), lang.getText("NPA_entry006d1"), lang.getText("NPA_entry006d2")};
        nbmProp.add(nbmTxt);
        NetProps.add(nbmProp);
        ArrayList<Object> csvProp = new ArrayList<Object>();
        csvProp.add("CSV");
        csvProp.add(false);
        String[] csvTxt = new String[]{lang.getText("NPA_entry007"), lang.getText("NPA_entry007d1"), lang.getText("NPA_entry007d2")};
        csvProp.add(csvTxt);
        NetProps.add(csvProp);
        ArrayList<Object> scfProp = new ArrayList<Object>();
        scfProp.add("SCF");
        scfProp.add(false);
        String[] scfTxt = new String[]{lang.getText("NPA_entry008"), lang.getText("NPA_entry008d1"), lang.getText("NPA_entry008d2")};
        scfProp.add(scfTxt);
        NetProps.add(scfProp);
        ArrayList<Object> ft0Prop = new ArrayList<Object>();
        ft0Prop.add("Ft0");
        ft0Prop.add(false);
        String[] ft0Txt = new String[]{lang.getText("NPA_entry009"), lang.getText("NPA_entry009d1"), lang.getText("NPA_entry009d2")};
        ft0Prop.add(ft0Txt);
        NetProps.add(ft0Prop);
        ArrayList<Object> tf0Prop = new ArrayList<Object>();
        tf0Prop.add("tF0");
        tf0Prop.add(false);
        String[] tf0Txt = new String[]{lang.getText("NPA_entry010"), lang.getText("NPA_entry010d1"), lang.getText("NPA_entry010d2")};
        tf0Prop.add(tf0Txt);
        NetProps.add(tf0Prop);
        ArrayList<Object> fp0Prop = new ArrayList<Object>();
        fp0Prop.add("Fp0");
        fp0Prop.add(false);
        String[] fp0Txt = new String[]{lang.getText("NPA_entry011"), lang.getText("NPA_entry011d1"), lang.getText("NPA_entry011d2")};
        fp0Prop.add(fp0Txt);
        NetProps.add(fp0Prop);
        ArrayList<Object> pf0Prop = new ArrayList<Object>();
        pf0Prop.add("pF0");
        pf0Prop.add(false);
        String[] pf0Txt = new String[]{lang.getText("NPA_entry012"), lang.getText("NPA_entry012d1"), lang.getText("NPA_entry012d2")};
        pf0Prop.add(pf0Txt);
        NetProps.add(pf0Prop);
        if (this.places.isEmpty() || this.transitions.isEmpty() || this.arcs.isEmpty()) {
            return NetProps;
        }
        boolean isFT0 = false;
        boolean isTF0 = false;
        boolean isFP0 = false;
        boolean isPF0 = false;
        for (Transition transition : this.transitions) {
            arcIn = false;
            arcOut = false;
            for (ElementLocation elementLocation : transition.getElementLocations()) {
                if (!elementLocation.getInArcs().isEmpty() && !arcIn) {
                    arcIn = true;
                }
                if (elementLocation.getOutArcs().isEmpty() || arcOut) continue;
                arcOut = true;
            }
            if (!arcIn && arcOut) {
                isFT0 = true;
            }
            if (!arcIn || arcOut) continue;
            isTF0 = true;
        }
        for (Place place : this.places) {
            arcIn = false;
            arcOut = false;
            for (ElementLocation elementLocation : place.getElementLocations()) {
                if (!elementLocation.getInArcs().isEmpty() && !arcIn) {
                    arcIn = true;
                }
                if (elementLocation.getOutArcs().isEmpty() || arcOut) continue;
                arcOut = true;
            }
            if (!arcIn && arcOut) {
                isFP0 = true;
            }
            if (!arcIn || arcOut) continue;
            isPF0 = true;
        }
        ft0Prop.set(1, isFT0);
        tf0Prop.set(1, isTF0);
        fp0Prop.set(1, isFP0);
        pf0Prop.set(1, isPF0);
        boolean isPure = true;
        for (Transition t : this.transitions) {
            for (ElementLocation elementLocation : t.getElementLocations()) {
                for (Arc arc : elementLocation.getInArcs()) {
                    for (ElementLocation elementLocation2 : arc.getStartNode().getElementLocations()) {
                        for (Arc arc2 : elementLocation2.getInArcs()) {
                            if (arc2.getStartNode().getID() != t.getID()) continue;
                            isPure = false;
                        }
                    }
                }
            }
        }
        purProp.set(1, isPure);
        boolean bl4 = true;
        for (Arc a : this.arcs) {
            if (a.getWeight() == 1) continue;
            bl3 = false;
            break;
        }
        ordProp.set(1, bl3);
        boolean isHomogenous = true;
        for (Place place : this.places) {
            int n3 = 0;
            for (ElementLocation el : place.getElementLocations()) {
                for (Arc arc : el.getOutArcs()) {
                    if (n3 == 0) {
                        n3 = arc.getWeight();
                        continue;
                    }
                    if (n3 == arc.getWeight()) continue;
                    isHomogenous = false;
                }
            }
        }
        homProp.set(1, isHomogenous);
        boolean isNonBlockingMulti = true;
        for (Place place : this.places) {
            int n4;
            int n5 = Integer.MAX_VALUE;
            int valOut = 0;
            for (ElementLocation elementLocation : place.getElementLocations()) {
                for (Arc arc : elementLocation.getInArcs()) {
                    if (arc.getWeight() >= n4) continue;
                    n4 = arc.getWeight();
                }
                for (Arc arc : elementLocation.getOutArcs()) {
                    if (arc.getWeight() <= valOut) continue;
                    valOut = arc.getWeight();
                }
            }
            if (valOut <= n4) continue;
            isNonBlockingMulti = false;
            break;
        }
        nbmProp.set(1, isNonBlockingMulti);
        boolean bl5 = true;
        for (Transition transition : this.transitions) {
            void var38_86;
            int arcIn2 = 0;
            boolean bl6 = false;
            for (ElementLocation elementLocation : transition.getElementLocations()) {
                for (Arc a : elementLocation.getInArcs()) {
                    arcIn2 += a.getWeight();
                }
                for (Arc a : elementLocation.getOutArcs()) {
                    var38_86 += a.getWeight();
                }
            }
            if (arcIn2 == var38_86) continue;
            bl2 = false;
            break;
        }
        csvProp.set(1, bl2);
        boolean bl7 = false;
        Node node = this.nodes.get(0);
        int tNo = this.transitions.size();
        int n6 = this.places.size();
        int n7 = this.metaNodes.size();
        int n8 = this.nodes.size();
        if (tNo + n6 != n8 - n7) {
            overlord.log(lang.getText("NPA_entry013") + " " + n6 + " " + lang.getText("NPA_entry013a") + " " + tNo + " " + lang.getText("NPA_entry013b") + " " + n8 + " " + lang.getText("NPA_entry013c") + " " + n7 + ".", "warning", true);
        }
        if ((n2 = this.checkNetConnectivity(node, new ArrayList<Node>())) == n8) {
            bl = true;
        }
        conProp.set(1, bl);
        boolean isStronglyConnected = false;
        if (this.fastStrongConnectivityTest() && (n = this.checkNetStrongConnectivity(node, new ArrayList<Node>())) == n8) {
            isStronglyConnected = true;
        }
        scProp.set(1, isStronglyConnected);
        boolean isStaticConFree = true;
        for (Transition t : this.transitions) {
            for (ElementLocation el : t.getElementLocations()) {
                for (Arc a1 : el.getInArcs()) {
                    for (Transition t2 : this.transitions) {
                        if (t.getID() == t2.getID()) continue;
                        for (ElementLocation el2 : t2.getElementLocations()) {
                            for (Arc a2 : el2.getInArcs()) {
                                if (a1.getStartNode().getID() != a2.getStartNode().getID()) continue;
                            }
                        }
                    }
                }
            }
        }
        isStaticConFree = false;
        scfProp.set(1, isStaticConFree);
        return NetProps;
    }

    private boolean checkStronglyConnectionExist(Node n1, Node n2, Node last, boolean mode) {
        if (mode && n1.getID() == n2.getID()) {
            return false;
        }
        if (n1.getInputArcs() != null) {
            for (Arc a : n1.getInputArcs()) {
                if (a.getStartNode().getID() != last.getID()) continue;
                return true;
            }
            for (Arc a : n1.getInputArcs()) {
                if (!this.checkStronglyConnectionExist(a.getStartNode(), n2, last, true)) continue;
                return true;
            }
        } else {
            return false;
        }
        return false;
    }

    private int checkNetConnectivity(Node start, ArrayList<Node> reachable) {
        Node nod;
        if (!reachable.contains(start)) {
            reachable.add(start);
        }
        if (start.getInputArcs() != null) {
            for (Arc a : start.getInputArcs()) {
                nod = a.getStartNode();
                if (reachable.contains(nod)) continue;
                reachable.add(nod);
                this.checkNetConnectivity(nod, reachable);
            }
        }
        if (start.getOutputArcs() != null) {
            for (Arc a : start.getOutputArcs()) {
                nod = a.getEndNode();
                if (reachable.contains(nod)) continue;
                reachable.add(nod);
                this.checkNetConnectivity(nod, reachable);
            }
        }
        return reachable.size();
    }

    private int checkNetStrongConnectivity(Node start, ArrayList<Node> reachable) {
        if (!reachable.contains(start)) {
            reachable.add(start);
        }
        if (start.getOutputArcs() != null) {
            for (Arc a : start.getOutputArcs()) {
                Node nod = a.getEndNode();
                if (reachable.contains(nod)) continue;
                reachable.add(nod);
                this.checkNetStrongConnectivity(nod, reachable);
            }
        }
        return reachable.size();
    }

    private boolean fastStrongConnectivityTest() {
        for (Node n : this.nodes) {
            if (!n.getInputArcs().isEmpty() && !n.getOutputArcs().isEmpty()) continue;
            return false;
        }
        return true;
    }
}

