/*
 * Decompiled with CFR 0.152.
 */
package holmes.analyse;

import holmes.analyse.InvariantsTools;
import holmes.darkgui.GUIManager;
import holmes.darkgui.LanguageManager;
import holmes.petrinet.elements.Transition;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class MDTSCalculator {
    private static final GUIManager overlord = GUIManager.getDefaultGUIManager();
    private static final LanguageManager lang = GUIManager.getLanguageManager();
    ArrayList<ArrayList<Integer>> tmpInvariantsMatrix;
    ArrayList<Transition> calc_transitions;
    int invariantsNumber;
    int transitionsNumber;

    public MDTSCalculator() {
        ArrayList<ArrayList<Integer>> invariants = overlord.getWorkspace().getProject().getT_InvMatrix();
        if (invariants == null || invariants.isEmpty()) {
            overlord.log(lang.getText("MDTS_entry001"), "errer", true);
        } else {
            this.invariantsNumber = invariants.size();
            this.tmpInvariantsMatrix = InvariantsTools.transposeMatrix(invariants);
            this.calc_transitions = overlord.getWorkspace().getProject().getTransitions();
            this.transitionsNumber = this.calc_transitions.size();
        }
    }

    public ArrayList<Set<Integer>> calculateMDTS() {
        ArrayList<Set<Integer>> resultList = new ArrayList<Set<Integer>>();
        ArrayList<Integer> unassignedRows = new ArrayList<Integer>();
        for (int i = 0; i < this.tmpInvariantsMatrix.size(); ++i) {
            unassignedRows.add(i);
        }
        this.tmpInvariantsMatrix = InvariantsTools.returnBinaryMatrix(this.tmpInvariantsMatrix);
        while (!unassignedRows.isEmpty()) {
            HashSet<Integer> mdts = new HashSet<Integer>();
            int rowValue = (Integer)unassignedRows.get(0);
            mdts.add(rowValue);
            unassignedRows.remove(0);
            ArrayList<Integer> removeList = new ArrayList<Integer>();
            Iterator iterator = unassignedRows.iterator();
            while (iterator.hasNext()) {
                int otherRow = (Integer)iterator.next();
                if (!this.tmpInvariantsMatrix.get(rowValue).equals(this.tmpInvariantsMatrix.get(otherRow))) continue;
                mdts.add(otherRow);
                removeList.add(unassignedRows.indexOf(otherRow));
            }
            resultList.add(mdts);
            int removedSoFar = 0;
            Iterator iterator2 = removeList.iterator();
            while (iterator2.hasNext()) {
                int el = (Integer)iterator2.next();
                int index = el - removedSoFar;
                unassignedRows.remove(index);
                ++removedSoFar;
            }
        }
        return resultList;
    }
}

