/*
 * Decompiled with CFR 0.152.
 */
package holmes.analyse;

import holmes.analyse.InvariantsTools;
import holmes.darkgui.GUIManager;
import holmes.darkgui.LanguageManager;
import holmes.petrinet.data.MCSDataMatrix;
import holmes.petrinet.elements.Node;
import holmes.petrinet.elements.Transition;
import holmes.windows.HolmesMCS;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JTextArea;

public class MCSCalculator
implements Runnable {
    private static final GUIManager overlord = GUIManager.getDefaultGUIManager();
    private static final LanguageManager lang = GUIManager.getLanguageManager();
    private ArrayList<ArrayList<Integer>> em_obR;
    private ArrayList<Integer> em_obRinvID;
    private ArrayList<Integer> transitions;
    private ArrayList<Set<Integer>> mcs;
    private List<Set<Integer>> precutsets;
    private int maxCutSetSize;
    private boolean ready = false;
    private boolean askBeforeAdd = true;
    private HolmesMCS masterWindow = null;
    private int objective_Reaction;
    private int maxSetsNumber;
    private boolean terminate = false;

    public MCSCalculator(int objR, ArrayList<ArrayList<Integer>> invariants, ArrayList<Transition> transitionsList, int MAX_CUTSETSIZE, int maxNumber, HolmesMCS mstWindow, boolean safe) {
        if (invariants == null || invariants.isEmpty()) {
            return;
        }
        this.em_obR = new ArrayList();
        this.transitions = new ArrayList();
        this.mcs = new ArrayList();
        this.precutsets = new ArrayList<Set<Integer>>();
        this.objective_Reaction = objR;
        this.masterWindow = mstWindow;
        this.askBeforeAdd = safe;
        this.maxSetsNumber = maxNumber;
        this.em_obRinvID = new ArrayList();
        int counter = 0;
        for (ArrayList<Integer> inv : invariants) {
            if (this.transInInvariant(inv, this.objective_Reaction)) {
                this.em_obR.add(this.binaryInv(inv));
                this.em_obRinvID.add(counter);
            }
            ++counter;
        }
        for (Transition t : transitionsList) {
            this.transitions.add(transitionsList.indexOf(t));
        }
        Iterator<Serializable> iterator = this.transitions.iterator();
        while (iterator.hasNext()) {
            int t = (Integer)iterator.next();
            HashSet<Integer> tSet = new HashSet<Integer>();
            tSet.add(t);
            if (this.transitionCoverabilityTest(t)) {
                this.mcs.add(tSet);
                continue;
            }
            this.precutsets.add(tSet);
        }
        this.maxCutSetSize = MAX_CUTSETSIZE;
        this.ready = true;
    }

    @Override
    public void run() {
        try {
            this.logInternal(lang.getText("MCSC_entry001"), true);
            ArrayList<Set<Integer>> results = this.findMcs();
            this.addNewDataVector(results);
            if (this.masterWindow != null) {
                this.logInternal(lang.getText("MCSC_entry002"), true);
                this.showMCS();
                this.masterWindow.resetMCSGenerator();
            }
        }
        catch (OutOfMemoryError e) {
            this.precutsets = null;
            overlord.log(lang.getText("LOG_entry0071_exception"), "error", true);
            this.addNewDataVector(this.mcs);
            this.showMCS();
            this.masterWindow.resetMCSGenerator();
        }
        catch (Exception e) {
            this.logInternal(lang.getText("LOG_entry0072_exception") + e.getMessage(), true);
            this.addNewDataVector(this.mcs);
            this.showMCS();
            this.masterWindow.resetMCSGenerator();
        }
    }

    private ArrayList<Integer> binaryInv(ArrayList<Integer> inv) {
        ArrayList<Integer> binaryInvariant = new ArrayList<Integer>();
        for (Integer integer : inv) {
            if (integer > 0) {
                binaryInvariant.add(1);
                continue;
            }
            binaryInvariant.add(0);
        }
        return binaryInvariant;
    }

    private boolean transitionCoverabilityTest(int trans) {
        for (ArrayList<Integer> invariant : this.em_obR) {
            if (this.transInInvariant(invariant, trans)) continue;
            return false;
        }
        return true;
    }

    public ArrayList<Set<Integer>> findMcs() {
        if (!this.ready) {
            return null;
        }
        int k = 1;
        while (++k <= this.maxCutSetSize) {
            ArrayList<Set<Integer>> newPrecutsets = new ArrayList<Set<Integer>>();
            this.logInternal(lang.getText("MCSC_entry005") + " " + k + ": ", false);
            long currTime = System.currentTimeMillis();
            int oldPrecutSetsSize = this.precutsets.size();
            for (int j : this.transitions) {
                this.logInternal("*", false);
                if (this.terminate) {
                    return this.mcs;
                }
                this.removeSetsContainingTransition2(j);
                if (this.terminate) {
                    return this.mcs;
                }
                List<Set<Integer>> temp_precutsets = this.calculatePreliminaryCutsets(this.precutsets, j);
                if (this.terminate) {
                    return this.mcs;
                }
                this.removeNonMinimalSets(temp_precutsets);
                if (this.terminate) {
                    return this.mcs;
                }
                newPrecutsets.addAll(this.identifyNewMCSs2(temp_precutsets));
                temp_precutsets = null;
            }
            this.logInternal("\n", false);
            int sizePre = newPrecutsets.size();
            int sizeMCS = this.mcs.size();
            float incFactor = (float)sizePre / (float)oldPrecutSetsSize;
            long currTimeNow = System.currentTimeMillis();
            long diffTime = currTimeNow - currTime;
            this.logInternal(lang.getText("MCSC_entry006a") + " " + sizeMCS + " " + lang.getText("MCSC_entry006b") + " " + sizePre + " \n", false);
            this.logInternal(lang.getText("MCSC_entry007a") + " " + String.format("%.2f", Float.valueOf(incFactor)) + " " + lang.getText("MCSC_entry007b") + " " + (diffTime /= 1000L) + " " + lang.getText("MCSC_entry007c"), false);
            if (newPrecutsets.isEmpty() || this.maxSetsNumber < this.mcs.size()) break;
            this.precutsets = newPrecutsets;
        }
        return this.mcs;
    }

    public HashSet<HashSet<Integer>> findMcs2() {
        HashSet result = new HashSet();
        int invSize = this.transitions.size();
        for (ArrayList<Integer> integers : this.em_obR) {
            for (int j = 0; j < invSize; ++j) {
                int n = integers.get(j);
                if (n == 0) continue;
                HashSet<Integer> newSet = new HashSet<Integer>();
                newSet.add(j);
                result.add(newSet);
                for (HashSet hashSet : result) {
                    if (hashSet.size() > invSize) continue;
                    hashSet.add(j);
                }
            }
        }
        HashSet<HashSet<Integer>> minimal = new HashSet<HashSet<Integer>>();
        boolean found = false;
        for (HashSet hashSet : result) {
            found = false;
            for (HashSet hashSet2 : result) {
                if (hashSet.equals(hashSet2) || !hashSet.containsAll(hashSet2)) continue;
                found = true;
                break;
            }
            if (found) continue;
            minimal.add(hashSet);
        }
        return minimal;
    }

    private void removeSetsContainingTransition2(int trans) {
        int size = this.precutsets.size();
        for (int s = 0; s < size; ++s) {
            Set<Integer> set = this.precutsets.get(s);
            if (!set.contains(trans)) continue;
            this.precutsets.remove(s);
            --s;
            --size;
        }
    }

    private List<Set<Integer>> calculatePreliminaryCutsets(List<Set<Integer>> precutsets, int trans) {
        ArrayList<Set<Integer>> newPrecutsets = new ArrayList<Set<Integer>>();
        for (Set<Integer> precutset : precutsets) {
            if (this.terminate) {
                return newPrecutsets;
            }
            boolean correct = false;
            for (ArrayList<Integer> invariant : this.em_obR) {
                if (!this.transInInvariant(invariant, trans) || !this.commonSubset(invariant, precutset).isEmpty()) continue;
                correct = true;
                break;
            }
            if (!correct) continue;
            HashSet<Integer> newPrecutset = new HashSet<Integer>(precutset);
            newPrecutset.add(trans);
            newPrecutsets.add(newPrecutset);
        }
        return newPrecutsets;
    }

    private Set<Integer> commonSubset(ArrayList<Integer> invariant, Set<Integer> precutset) {
        HashSet<Integer> result = new HashSet<Integer>();
        for (int el : precutset) {
            if (invariant.get(el) <= 0) continue;
            result.add(el);
        }
        return result;
    }

    private void removeNonMinimalSets(List<Set<Integer>> precutsets) {
        int size = precutsets.size();
        block0: for (int s = 0; s < size; ++s) {
            Set<Integer> precutset = precutsets.get(s);
            for (Set<Integer> minimal : this.mcs) {
                if (!precutset.containsAll(minimal)) continue;
                precutsets.remove(s);
                --s;
                --size;
                continue block0;
            }
        }
    }

    private List<Set<Integer>> identifyNewMCSs2(List<Set<Integer>> precutsets) {
        int size = precutsets.size();
        for (int s = 0; s < size; ++s) {
            Set<Integer> precutset = precutsets.get(s);
            if (!this.coversAllTInvariants(precutset)) continue;
            this.mcs.add(precutset);
            precutsets.remove(s);
            --s;
            --size;
        }
        return precutsets;
    }

    private boolean coversAllTInvariants(Set<Integer> set) {
        for (ArrayList<Integer> invariant : this.em_obR) {
            if (!this.commonSubset(invariant, set).isEmpty()) continue;
            return false;
        }
        return true;
    }

    private boolean transInInvariant(ArrayList<Integer> invariant, int transition) {
        return invariant.get(transition) > 0;
    }

    public void emergencyStop() {
        this.terminate = true;
    }

    private void addNewDataVector(ArrayList<Set<Integer>> results) {
        ArrayList<Transition> transitions = overlord.getWorkspace().getProject().getTransitions();
        ArrayList<ArrayList<Integer>> mcsInfoMatrix = new ArrayList<ArrayList<Integer>>();
        ArrayList<ArrayList<Integer>> mcsDataMatrix = new ArrayList<ArrayList<Integer>>();
        if (overlord.getSettingsManager().getValue("analysisMCSReduction").equals("1")) {
            for (Set<Integer> mcsSet : results) {
                ArrayList<Integer> mcsSetData = new ArrayList<Integer>(mcsSet);
                Collections.sort(mcsSetData);
                ArrayList<Integer> mcsInfo = new ArrayList<Integer>();
                boolean cancel = false;
                for (int element : mcsSetData) {
                    Transition target;
                    Transition setTransition = transitions.get(element);
                    int distance = InvariantsTools.calculateNodesDistance(setTransition, target = transitions.get(this.objective_Reaction), new ArrayList<Node>());
                    if (distance < 0) {
                        cancel = true;
                        break;
                    }
                    mcsInfo.add(distance);
                }
                if (cancel) continue;
                mcsDataMatrix.add(mcsSetData);
                mcsInfoMatrix.add(mcsInfo);
            }
            this.logInternal(lang.getText("MCSC_entry008") + " " + mcsDataMatrix.size() + "\n", false);
        } else {
            for (Set<Integer> mcsSet : results) {
                ArrayList<Integer> mcsSetData = new ArrayList<Integer>(mcsSet);
                Collections.sort(mcsSetData);
                ArrayList<Integer> mcsInfo = new ArrayList<Integer>();
                for (int element : mcsSetData) {
                    Transition setTransition = transitions.get(element);
                    Transition target = transitions.get(this.objective_Reaction);
                    int distance = InvariantsTools.calculateNodesDistance(setTransition, target, new ArrayList<Node>());
                    mcsInfo.add(distance);
                }
                mcsDataMatrix.add(mcsSetData);
                mcsInfoMatrix.add(mcsInfo);
            }
        }
        MCSDataMatrix mcsd = overlord.getWorkspace().getProject().getMCSdataCore();
        mcsd.insertMCS(mcsDataMatrix, mcsInfoMatrix, this.objective_Reaction, this.askBeforeAdd);
    }

    private void showMCS() {
        int mcsSize = this.mcs.size();
        this.logInternal(lang.getText("MCSC_entry009") + " " + mcsSize, false);
        for (int s = 0; s < mcsSize; ++s) {
            StringBuilder msg = new StringBuilder("Set " + s + ": [");
            Set<Integer> mcsSet = this.mcs.get(s);
            for (int el : mcsSet) {
                msg.append(el).append(", ");
            }
            msg.append("]\n");
            StringBuilder stringBuilder = new StringBuilder(msg.toString().replace(", ]", "]"));
        }
    }

    private void logInternal(String msg, boolean date) {
        String timeStamp = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(Calendar.getInstance().getTime());
        if (this.masterWindow != null) {
            if (!date) {
                JTextArea jta = this.masterWindow.accessLogField();
                jta.append(msg);
                jta.setCaretPosition(jta.getDocument().getLength());
            } else {
                JTextArea jta = this.masterWindow.accessLogField();
                jta.append("[" + timeStamp + "] " + msg);
                jta.setCaretPosition(jta.getDocument().getLength());
            }
        }
    }
}

