/*
 * Decompiled with CFR 0.152.
 */
package holmes.analyse;

import holmes.darkgui.GUIManager;
import holmes.darkgui.LanguageManager;
import holmes.petrinet.elements.Place;
import holmes.petrinet.elements.Transition;
import java.util.ArrayList;

public class KnockoutCalculator {
    private static final GUIManager overlord = GUIManager.getDefaultGUIManager();
    private static final LanguageManager lang = GUIManager.getLanguageManager();
    ArrayList<ArrayList<Integer>> calc_invariants;
    ArrayList<Transition> calc_transitions;
    ArrayList<Place> calc_places;

    public KnockoutCalculator() {
        ArrayList<ArrayList<Integer>> invariants = overlord.getWorkspace().getProject().getT_InvMatrix();
        if (invariants == null || invariants.isEmpty()) {
            return;
        }
        this.calc_invariants = invariants;
        this.calc_transitions = overlord.getWorkspace().getProject().getTransitions();
        this.calc_places = overlord.getWorkspace().getProject().getPlaces();
    }

    public ArrayList<Transition> calculateKnockout(ArrayList<Transition> knockout) {
        ArrayList<Transition> resultSet = new ArrayList<Transition>();
        int invNumber = this.calc_invariants.size();
        int transNumber = this.calc_transitions.size();
        for (Transition trans : knockout) {
            int transLocation = this.calc_transitions.indexOf(trans);
            for (int i = 0; i < invNumber; ++i) {
                if (this.calc_invariants.get(i).get(transLocation) <= 0) continue;
                for (int t = 0; t < transNumber; ++t) {
                    Transition knockedout;
                    if (this.calc_invariants.get(i).get(t) <= 0 || resultSet.contains(knockedout = this.calc_transitions.get(t))) continue;
                    resultSet.add(knockedout);
                }
            }
        }
        for (Transition trans : knockout) {
            resultSet.remove(trans);
        }
        return resultSet;
    }
}

