/*
 * Decompiled with CFR 0.152.
 */
package holmes.analyse;

import holmes.analyse.InvariantsCalculator;
import holmes.darkgui.GUIManager;
import holmes.darkgui.LanguageManager;
import holmes.petrinet.data.InvariantTransition;
import holmes.petrinet.elements.Arc;
import holmes.petrinet.elements.ElementLocation;
import holmes.petrinet.elements.Node;
import holmes.petrinet.elements.Place;
import holmes.petrinet.elements.Transition;
import holmes.utilities.Tools;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import javax.swing.JOptionPane;

public final class InvariantsTools {
    private static final GUIManager overlord = GUIManager.getDefaultGUIManager();
    private static final LanguageManager lang = GUIManager.getLanguageManager();

    private InvariantsTools() {
    }

    public static ArrayList<ArrayList<Integer>> transposeMatrix(ArrayList<ArrayList<Integer>> matrix) {
        if (matrix == null || matrix.isEmpty()) {
            return null;
        }
        int columns = matrix.get(0).size();
        ArrayList<ArrayList<Integer>> resultMatrix = new ArrayList<ArrayList<Integer>>();
        for (int c = 0; c < columns; ++c) {
            ArrayList<Integer> transposedRow = new ArrayList<Integer>();
            for (ArrayList<Integer> integers : matrix) {
                transposedRow.add(integers.get(c));
            }
            resultMatrix.add(transposedRow);
        }
        return resultMatrix;
    }

    public static ArrayList<ArrayList<Integer>> returnBinaryMatrix(ArrayList<ArrayList<Integer>> matrix) {
        if (matrix == null || matrix.isEmpty()) {
            return null;
        }
        int columns = matrix.get(0).size();
        ArrayList<ArrayList<Integer>> resultMatrix = new ArrayList<ArrayList<Integer>>();
        for (ArrayList<Integer> integers : matrix) {
            ArrayList<Integer> binaryRow = new ArrayList<Integer>();
            for (int c = 0; c < columns; ++c) {
                if (integers.get(c) != 0) {
                    binaryRow.add(1);
                    continue;
                }
                binaryRow.add(0);
            }
            resultMatrix.add(binaryRow);
        }
        return resultMatrix;
    }

    public static ArrayList<ArrayList<Integer>> isT_invariantSet(ArrayList<ArrayList<Integer>> CMatrix, ArrayList<ArrayList<Integer>> invSet) {
        ArrayList<ArrayList<Integer>> noInv = new ArrayList<ArrayList<Integer>>();
        for (ArrayList<Integer> inv : invSet) {
            if (InvariantsTools.checkT_invariant(CMatrix, inv, true) == 0) continue;
            noInv.add(inv);
        }
        return noInv;
    }

    public static int countNonT_invariants(ArrayList<ArrayList<Integer>> CMatrix, ArrayList<ArrayList<Integer>> invSet) {
        int result = 0;
        for (ArrayList<Integer> inv : invSet) {
            if (InvariantsTools.checkT_invariant(CMatrix, inv, true) == 0) continue;
            ++result;
        }
        return result;
    }

    public static ArrayList<Integer> markInvariantsTypes(ArrayList<ArrayList<Integer>> CMatrix, ArrayList<ArrayList<Integer>> invSet) {
        ArrayList<Integer> resVector = new ArrayList<Integer>();
        for (ArrayList<Integer> inv : invSet) {
            if (InvariantsTools.checkT_invariant(CMatrix, inv, true) == 1) {
                resVector.add(1);
                continue;
            }
            if (InvariantsTools.checkT_invariant(CMatrix, inv, true) == -1) {
                resVector.add(-1);
                continue;
            }
            if (InvariantsTools.checkT_invariant(CMatrix, inv, true) == 11) {
                resVector.add(11);
                continue;
            }
            resVector.add(0);
        }
        return resVector;
    }

    public static ArrayList<ArrayList<Integer>> analyseInvariantDetails(ArrayList<ArrayList<Integer>> CMatrix, ArrayList<ArrayList<Integer>> invSet, boolean t_inv) {
        ArrayList<ArrayList<Integer>> results = new ArrayList<ArrayList<Integer>>();
        int subInv = 0;
        int surInv = 0;
        int nonInv = 0;
        int zeroInvariants = 0;
        ArrayList<Integer> surPlacesVector = new ArrayList<Integer>();
        ArrayList<Integer> subPlacesVector = new ArrayList<Integer>();
        ArrayList<Integer> nonInvPlacesVector = new ArrayList<Integer>();
        ArrayList<Integer> markingVector = new ArrayList<Integer>();
        ArrayList<Integer> invTypes = new ArrayList<Integer>();
        int elementsNumber = t_inv ? overlord.getWorkspace().getProject().getPlaces().size() : overlord.getWorkspace().getProject().getTransitions().size();
        for (int i = 0; i < elementsNumber; ++i) {
            surPlacesVector.add(0);
            subPlacesVector.add(0);
            nonInvPlacesVector.add(0);
        }
        for (ArrayList<Integer> inv : invSet) {
            ArrayList<Integer> vector = t_inv ? InvariantsTools.check_invariantV2(CMatrix, inv) : InvariantsTools.check_invariantV2(InvariantsTools.transposeMatrix(CMatrix), inv);
            assert (vector != null);
            if (vector.get(0) == 0) {
                ++zeroInvariants;
                markingVector.add(0);
                invTypes.add(0);
                continue;
            }
            if (vector.get(0) == -1) {
                ++subInv;
                subPlacesVector = InvariantsTools.quickSumT_inv(subPlacesVector, vector);
                markingVector.add(-1);
                invTypes.add(-1);
                continue;
            }
            if (vector.get(0) == 1) {
                ++surInv;
                surPlacesVector = InvariantsTools.quickSumT_inv(surPlacesVector, vector);
                markingVector.add(1);
                invTypes.add(1);
                continue;
            }
            ++nonInv;
            nonInvPlacesVector = InvariantsTools.quickSumT_inv(nonInvPlacesVector, vector);
            markingVector.add(11);
            invTypes.add(11);
        }
        ArrayList<Integer> summaryVector = new ArrayList<Integer>();
        summaryVector.add(zeroInvariants);
        summaryVector.add(surInv);
        summaryVector.add(subInv);
        summaryVector.add(nonInv);
        results.add(summaryVector);
        results.add(surPlacesVector);
        results.add(subPlacesVector);
        results.add(nonInvPlacesVector);
        results.add(markingVector);
        overlord.getWorkspace().getProject().setT_InvTypes(invTypes);
        overlord.getWorkspace().getProject().setT_invTypesComputed(true);
        return results;
    }

    public static void analyseInvariantTypes(ArrayList<ArrayList<Integer>> CMatrix, ArrayList<ArrayList<Integer>> invSet, boolean t_inv) {
        ArrayList<Integer> invTypes = new ArrayList<Integer>();
        for (ArrayList<Integer> inv : invSet) {
            ArrayList<Integer> vector = t_inv ? InvariantsTools.check_invariantV2(CMatrix, inv) : InvariantsTools.check_invariantV2(InvariantsTools.transposeMatrix(CMatrix), inv);
            assert (vector != null);
            if (vector.get(0) == 0) {
                invTypes.add(0);
                continue;
            }
            if (vector.get(0) == -1) {
                invTypes.add(-1);
                continue;
            }
            if (vector.get(0) == 1) {
                invTypes.add(1);
                continue;
            }
            invTypes.add(11);
        }
        overlord.getWorkspace().getProject().setT_InvTypes(invTypes);
        overlord.getWorkspace().getProject().setT_invTypesComputed(true);
    }

    public static ArrayList<ArrayList<Integer>> getOnlyRealInvariants(ArrayList<ArrayList<Integer>> CMatrix, ArrayList<ArrayList<Integer>> invSet, boolean t_inv) {
        ArrayList<ArrayList<Integer>> results = new ArrayList<ArrayList<Integer>>();
        for (ArrayList<Integer> inv : invSet) {
            ArrayList<Integer> vector = t_inv ? InvariantsTools.check_invariantV2(CMatrix, inv) : InvariantsTools.check_invariantV2(InvariantsTools.transposeMatrix(CMatrix), inv);
            assert (vector != null);
            if (vector.get(0) == 0) {
                results.add(inv);
                continue;
            }
            if (vector.get(0) != -1 && vector.get(0) != 1) continue;
        }
        return results;
    }

    public static ArrayList<Integer> getT_invariantsClassVector(ArrayList<ArrayList<Integer>> invSet) {
        ArrayList<Integer> results = new ArrayList<Integer>();
        InvariantsCalculator ic = new InvariantsCalculator(true);
        ArrayList<ArrayList<Integer>> incMatrix = ic.getCMatrix();
        for (ArrayList<Integer> inv : invSet) {
            ArrayList<Integer> vector = InvariantsTools.check_invariantV2(incMatrix, inv);
            assert (vector != null);
            if (vector.get(0) == 0) {
                results.add(0);
                continue;
            }
            if (vector.get(0) == -1) {
                results.add(-1);
                continue;
            }
            if (vector.get(0) == 1) {
                results.add(1);
                continue;
            }
            results.add(-99);
        }
        return results;
    }

    private static ArrayList<Integer> quickSumT_inv(ArrayList<Integer> base, ArrayList<Integer> resultVector) {
        int size = resultVector.size();
        int baseSize = base.size();
        if (baseSize + 1 != size) {
            return base;
        }
        for (int i = 0; i < baseSize; ++i) {
            if (resultVector.get(i + 1) == 0) continue;
            int oldV = base.get(i);
            base.set(i, oldV + 1);
        }
        return base;
    }

    public static int checkT_invariant(ArrayList<ArrayList<Integer>> CMatrix, ArrayList<Integer> invariant, boolean tInv) {
        if (tInv && !CMatrix.isEmpty()) {
            ArrayList<Integer> placesSumVector = new ArrayList<Integer>();
            if (invariant.size() != CMatrix.size()) {
                return -99;
            }
            int placesNumber = CMatrix.get(0).size();
            int transitionsNumber = invariant.size();
            for (int p = 0; p < placesNumber; ++p) {
                int sumForPlace = 0;
                for (int t = 0; t < transitionsNumber; ++t) {
                    sumForPlace += CMatrix.get(t).get(p) * invariant.get(t);
                }
                placesSumVector.add(sumForPlace);
            }
            int adds = 0;
            int subs = 0;
            for (int p = 0; p < placesNumber; ++p) {
                if ((Integer)placesSumVector.get(p) > 0) {
                    ++adds;
                    continue;
                }
                if ((Integer)placesSumVector.get(p) >= 0) continue;
                ++subs;
            }
            if (adds > 0 && subs > 0) {
                return 11;
            }
            if (adds > 0) {
                return 1;
            }
            if (subs > 0) {
                return -1;
            }
            return 0;
        }
        return -99;
    }

    public static ArrayList<Integer> check_invariantV2(ArrayList<ArrayList<Integer>> CMatrix, ArrayList<Integer> inv) {
        ArrayList<Integer> results = new ArrayList<Integer>();
        if (CMatrix.isEmpty()) {
            return null;
        }
        ArrayList<Integer> invSupport = InvariantsTools.getSupport(inv);
        ArrayList<Integer> elementsSumVector = new ArrayList<Integer>();
        if (inv.size() != CMatrix.size()) {
            return null;
        }
        int transNumber = CMatrix.get(0).size();
        for (int i = 0; i < transNumber; ++i) {
            elementsSumVector.add(0);
        }
        for (int sup : invSupport) {
            ArrayList<Integer> row = CMatrix.get(sup);
            int multFactor = inv.get(sup);
            for (int p = 0; p < transNumber; ++p) {
                int oldVal = (Integer)elementsSumVector.get(p);
                elementsSumVector.set(p, oldVal += row.get(p) * multFactor);
            }
        }
        int positives = 0;
        int negatives = 0;
        int zeroes = 0;
        results.add(0);
        for (int t = 0; t < transNumber; ++t) {
            int value = (Integer)elementsSumVector.get(t);
            if (value == 0) {
                ++zeroes;
            } else if (value > 0) {
                ++positives;
            } else {
                ++negatives;
            }
            results.add(value);
        }
        if (positives > 0 && negatives > 0) {
            results.set(0, -50);
            return results;
        }
        if (zeroes == transNumber) {
            results.set(0, 0);
            return results;
        }
        if (positives > 0) {
            results.set(0, 1);
            return results;
        }
        if (negatives > 0) {
            results.set(0, -1);
            return results;
        }
        return null;
    }

    public static ArrayList<Integer> getSupport(ArrayList<Integer> invariant) {
        ArrayList<Integer> supports = new ArrayList<Integer>();
        int size = invariant.size();
        for (int i = 0; i < size; ++i) {
            if (invariant.get(i) == 0) continue;
            supports.add(i);
        }
        return supports;
    }

    private static int checkCoverability(ArrayList<Integer> refInv, ArrayList<Integer> refSupport, ArrayList<Integer> candidateInv, ArrayList<Integer> candSupport) {
        int sizeCan;
        int sizeRef = refInv.size();
        if (sizeRef != (sizeCan = candidateInv.size())) {
            return 1;
        }
        int CanInRef = 0;
        int CanInRefStrong = 0;
        int RefInCan = 0;
        int RefInCanStrong = 0;
        int refSuppSize = refSupport.size();
        int candSuppSize = candSupport.size();
        for (int ind = 0; ind < sizeRef; ++ind) {
            int refElement = refInv.get(ind);
            int canElement = candidateInv.get(ind);
            if (refElement > 0 && refElement >= canElement) {
                ++CanInRef;
                if (refElement > canElement) {
                    ++CanInRefStrong;
                }
            }
            if (canElement > 0 && canElement >= refElement) {
                ++RefInCan;
                if (canElement > refElement) {
                    ++RefInCanStrong;
                }
            }
            if (CanInRefStrong <= 0 || RefInCanStrong <= 0) continue;
            return 3;
        }
        if (CanInRef == refSuppSize && RefInCan == candSuppSize && CanInRefStrong == 0 && RefInCanStrong == 0) {
            return 0;
        }
        if (RefInCan == candSuppSize && RefInCanStrong > 0) {
            return 0;
        }
        if (CanInRef == refSuppSize && CanInRefStrong > 0) {
            return 2;
        }
        overlord.log(lang.getText("LOGentry00535critError"), "error", true);
        return 3;
    }

    public static void finalSupportMinimalityTest(ArrayList<ArrayList<Integer>> invariantsMatrix) {
        int invNumber = invariantsMatrix.size();
        ArrayList<Integer> getRidOfMatrix = new ArrayList<Integer>();
        boolean justGotHere = true;
        double interval = (double)invNumber / 10.0;
        int steps = 0;
        for (int i = 0; i < invNumber; ++i) {
            if (justGotHere) {
                System.out.println();
                justGotHere = false;
            }
            if (steps == (int)interval) {
                steps = 0;
                System.out.print("*");
            } else {
                ++steps;
            }
            ArrayList<Integer> inv = invariantsMatrix.get(i);
            ArrayList<Integer> invSupport = InvariantsTools.getSupport(inv);
            for (int j = 0; j < invNumber; ++j) {
                if (i == j) continue;
                ArrayList<Integer> ref = invariantsMatrix.get(j);
                ArrayList<Integer> refSupport = InvariantsTools.getSupport(ref);
                int x = InvariantsTools.checkCoverability(ref, refSupport, inv, invSupport);
                if (invSupport.equals(refSupport) && !getRidOfMatrix.contains(i)) {
                    getRidOfMatrix.add(i);
                }
                if (InvariantsTools.supportInclusionCheck(invSupport, refSupport) && !getRidOfMatrix.contains(i)) {
                    getRidOfMatrix.add(i);
                }
                if (x == 0 || x == 1) {
                    if (getRidOfMatrix.contains(i)) continue;
                    getRidOfMatrix.add(i);
                    continue;
                }
                if (x != 2 || getRidOfMatrix.contains(j)) continue;
                getRidOfMatrix.add(j);
            }
        }
        Collections.sort(getRidOfMatrix);
        int removedSoFar = 0;
        Iterator iterator = getRidOfMatrix.iterator();
        while (iterator.hasNext()) {
            int el = (Integer)iterator.next();
            int index = el - removedSoFar;
            invariantsMatrix.remove(index);
            ++removedSoFar;
        }
    }

    public static boolean supportInclusionCheck(ArrayList<Integer> invSupp, ArrayList<Integer> refSupp) {
        for (int el : refSupp) {
            if (invSupp.contains(el)) continue;
            return false;
        }
        return true;
    }

    public static int checkCanonity(ArrayList<ArrayList<Integer>> invMatrix) {
        int nonCardinal = 0;
        for (ArrayList<Integer> inv : invMatrix) {
            int nextT = 0;
            int result = 0;
            for (int t = 0; t < inv.size(); ++t) {
                int value = inv.get(t);
                if (value == 0) continue;
                result = InvariantsTools.bezwzgledna(value);
                nextT = t;
                break;
            }
            boolean card = false;
            for (int t = nextT + 1; t < inv.size(); ++t) {
                int value = inv.get(t);
                if (value == 0 || (result = InvariantsTools.nwd(result, value = InvariantsTools.bezwzgledna(value))) != 1) continue;
                card = true;
                break;
            }
            if (card) continue;
            ++nonCardinal;
        }
        return nonCardinal;
    }

    public static boolean checkCanonitySingle(ArrayList<Integer> invariant) {
        int value;
        int t;
        int nextT = 0;
        int result = 0;
        for (t = 0; t < invariant.size(); ++t) {
            value = invariant.get(t);
            if (value == 0) continue;
            result = InvariantsTools.bezwzgledna(value);
            nextT = t;
            break;
        }
        for (t = nextT + 1; t < invariant.size(); ++t) {
            value = invariant.get(t);
            if (value == 0 || (result = InvariantsTools.nwd(result, value = InvariantsTools.bezwzgledna(value))) != 1) continue;
            return true;
        }
        return false;
    }

    public static ArrayList<Integer> getCanonicalInfo(ArrayList<ArrayList<Integer>> invSet) {
        ArrayList<Integer> results = new ArrayList<Integer>();
        for (ArrayList<Integer> invariant : invSet) {
            boolean status = InvariantsTools.checkCanonitySingle(invariant);
            if (status) {
                results.add(0);
                continue;
            }
            results.add(-1);
        }
        return results;
    }

    public static int checkSupportMinimality(ArrayList<ArrayList<Integer>> invMatrix) {
        int nonMinimal = 0;
        int invSize = invMatrix.size();
        ArrayList<ArrayList<Integer>> supportMatrix = new ArrayList<ArrayList<Integer>>();
        for (ArrayList<Integer> matrix : invMatrix) {
            supportMatrix.add(InvariantsTools.getSupport(matrix));
        }
        block1: for (int i = 0; i < invSize; ++i) {
            for (int j = 0; j < invSize; ++j) {
                if (j == i || !InvariantsTools.supportInclusionCheck((ArrayList)supportMatrix.get(i), (ArrayList)supportMatrix.get(j))) continue;
                ++nonMinimal;
                continue block1;
            }
        }
        return nonMinimal;
    }

    public static ArrayList<ArrayList<Integer>> checkSupportMinimalityThorough(ArrayList<ArrayList<Integer>> invMatrix) {
        ArrayList<ArrayList<Integer>> resNonMinimal = new ArrayList<ArrayList<Integer>>();
        int invSize = invMatrix.size();
        ArrayList<ArrayList<Integer>> supportMatrix = new ArrayList<ArrayList<Integer>>();
        for (ArrayList<Integer> matrix : invMatrix) {
            supportMatrix.add(InvariantsTools.getSupport(matrix));
        }
        for (int i = 0; i < invSize; ++i) {
            ArrayList<Integer> nonMinimalInfo = new ArrayList<Integer>();
            for (int j = 0; j < invSize; ++j) {
                if (j == i || !InvariantsTools.supportInclusionCheck((ArrayList)supportMatrix.get(i), (ArrayList)supportMatrix.get(j))) continue;
                nonMinimalInfo.add(j);
            }
            resNonMinimal.add(nonMinimalInfo);
        }
        return resNonMinimal;
    }

    public static ArrayList<ArrayList<Integer>> compareTwoInvariantsSets(ArrayList<ArrayList<Integer>> refInvMatrix, ArrayList<ArrayList<Integer>> invLoadedMatrix) {
        int loadedInvSize = invLoadedMatrix.size();
        int refInvSize = refInvMatrix.size();
        ArrayList<Integer> loadedFoundInRef = new ArrayList<Integer>();
        ArrayList<Integer> loadedNotInRef = new ArrayList<Integer>();
        ArrayList<Integer> refNotInCore = new ArrayList<Integer>();
        ArrayList<Integer> refFoundInLoaded = new ArrayList<Integer>();
        ArrayList<ArrayList<Integer>> result = new ArrayList<ArrayList<Integer>>();
        ArrayList<ArrayList<Integer>> invLoadedRepetition = new ArrayList<ArrayList<Integer>>();
        int foundRepetitions = 0;
        int totalRepetitions = 0;
        for (int invMy = 0; invMy < loadedInvSize; ++invMy) {
            boolean presentInReferenceSet = false;
            ArrayList<Integer> loadedInvariant = invLoadedMatrix.get(invMy);
            if (!invLoadedRepetition.contains(loadedInvariant)) {
                invLoadedRepetition.add(loadedInvariant);
            } else {
                ++totalRepetitions;
            }
            for (int invRefID = 0; invRefID < refInvSize; ++invRefID) {
                if (!refInvMatrix.get(invRefID).equals(loadedInvariant)) continue;
                loadedFoundInRef.add(invMy);
                if (refFoundInLoaded.contains(invRefID)) {
                    ++foundRepetitions;
                } else {
                    refFoundInLoaded.add(invRefID);
                }
                presentInReferenceSet = true;
                break;
            }
            if (presentInReferenceSet) continue;
            loadedNotInRef.add(invMy);
        }
        for (int i = 0; i < refInvSize; ++i) {
            if (refFoundInLoaded.contains(i)) continue;
            refNotInCore.add(i);
        }
        ArrayList<Integer> repeatedVector = new ArrayList<Integer>();
        repeatedVector.add(foundRepetitions);
        repeatedVector.add(totalRepetitions);
        result.add(loadedFoundInRef);
        result.add(loadedNotInRef);
        result.add(refNotInCore);
        result.add(repeatedVector);
        return result;
    }

    public static void printMatrix(ArrayList<ArrayList<Integer>> matrix) {
        StringBuilder colNames = new StringBuilder();
        for (int jo = 0; jo < matrix.get(0).size(); ++jo) {
            colNames.append(Tools.setToSize("" + jo, 3, true));
        }
        System.out.println(colNames);
        for (int it = 0; it < matrix.size(); ++it) {
            StringBuilder msg = new StringBuilder();
            msg.append(Tools.setToSize("t" + it, 4, true));
            for (int jo = 0; jo < matrix.get(0).size(); ++jo) {
                msg.append(Tools.setToSize(String.valueOf(matrix.get(it).get(jo)), 3, true));
            }
            System.out.println(msg);
        }
    }

    public static ArrayList<Integer> detectCovered(ArrayList<ArrayList<Integer>> invMatrix) {
        ArrayList<Integer> coveredTransSet = new ArrayList<Integer>();
        ArrayList<Integer> typesVector = overlord.getWorkspace().getProject().accessT_InvTypesVector();
        int invNumber = 0;
        if (!invMatrix.isEmpty()) {
            int invSize = invMatrix.get(0).size();
            for (ArrayList<Integer> inv : invMatrix) {
                if (typesVector.size() != invMatrix.size()) {
                    overlord.log(lang.getText("LOGentry00536critError"), "error", true);
                }
                if (typesVector.get(invNumber++) != 0) continue;
                for (int t = 0; t < invSize; ++t) {
                    if (inv.get(t) == 0 || coveredTransSet.contains(t)) continue;
                    coveredTransSet.add(t);
                }
                if (coveredTransSet.size() != invSize) continue;
                break;
            }
        }
        Collections.sort(coveredTransSet);
        return coveredTransSet;
    }

    public static ArrayList<Integer> detectUncovered(ArrayList<ArrayList<Integer>> invMatrix, boolean t_inv) {
        ArrayList<Integer> uncoveredTransSet;
        block5: {
            block6: {
                block4: {
                    uncoveredTransSet = null;
                    ArrayList<Integer> coveredSet = InvariantsTools.detectCovered(invMatrix);
                    if (invMatrix == null || invMatrix.isEmpty()) break block4;
                    int invSize = invMatrix.get(0).size();
                    uncoveredTransSet = new ArrayList<Integer>();
                    for (int t = 0; t < invSize; ++t) {
                        if (coveredSet.contains(t)) continue;
                        uncoveredTransSet.add(t);
                    }
                    break block5;
                }
                if (!t_inv) break block6;
                ArrayList<Transition> trans = overlord.getWorkspace().getProject().getTransitions();
                if (trans == null || trans.isEmpty()) break block5;
                int transSize = trans.size();
                uncoveredTransSet = new ArrayList();
                for (int t = 0; t < transSize; ++t) {
                    uncoveredTransSet.add(t);
                }
                break block5;
            }
            ArrayList<Place> places = overlord.getWorkspace().getProject().getPlaces();
            if (places != null && !places.isEmpty()) {
                int placesSize = places.size();
                uncoveredTransSet = new ArrayList();
                for (int p = 0; p < placesSize; ++p) {
                    uncoveredTransSet.add(p);
                }
            }
        }
        return uncoveredTransSet;
    }

    public static ArrayList<ArrayList<InvariantTransition>> compute2ndFormInv(ArrayList<ArrayList<Integer>> invMatrix) {
        ArrayList<ArrayList<InvariantTransition>> invariants2ndForm = null;
        ArrayList<Transition> transitions = overlord.getWorkspace().getProject().getTransitions();
        if (invMatrix != null && !invMatrix.isEmpty()) {
            invariants2ndForm = new ArrayList<ArrayList<InvariantTransition>>();
            if (transitions != null && invMatrix.get(0).size() == transitions.size()) {
                for (ArrayList<Integer> binaryInvariant : invMatrix) {
                    ArrayList<InvariantTransition> currentInvariant = new ArrayList<InvariantTransition>();
                    int i = 0;
                    for (Integer amountOfFirings : binaryInvariant) {
                        if (amountOfFirings > 0) {
                            InvariantTransition currentTransition = new InvariantTransition(transitions.get(i), amountOfFirings);
                            currentInvariant.add(currentTransition);
                        }
                        ++i;
                    }
                    invariants2ndForm.add(currentInvariant);
                }
            } else {
                JOptionPane.showMessageDialog(null, lang.getText("ITwin_entry001"), lang.getText("ITwin_entry001t"), 0);
                overlord.log(lang.getText("ITwin_entry001"), "error", true);
            }
        } else {
            JOptionPane.showMessageDialog(null, lang.getText("ITwin_entry002"), lang.getText("ITwin_entry002t"), 0);
            overlord.log(lang.getText("ITwin_entry002"), "error", true);
        }
        return invariants2ndForm;
    }

    private static int bezwzgledna(int i) {
        if (i < 0) {
            return -i;
        }
        return i;
    }

    public static int nwd(int x, int y) {
        while (y != 0) {
            int temp = y;
            y = x % y;
            x = temp;
        }
        return x;
    }

    public static ArrayList<ArrayList<Integer>> returnT_invWithTransition(ArrayList<ArrayList<Integer>> globalInv, int transLoc) {
        ArrayList<ArrayList<Integer>> result = new ArrayList<ArrayList<Integer>>();
        for (ArrayList<Integer> vector : globalInv) {
            if (vector.get(transLoc) == 0) continue;
            result.add(new ArrayList<Integer>(vector));
        }
        return result;
    }

    public static ArrayList<Integer> returnInvIndicesWithTransition(ArrayList<ArrayList<Integer>> globalInv, int transLoc) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int i = 0; i < globalInv.size(); ++i) {
            if (globalInv.get(i).get(transLoc) == 0) continue;
            result.add(i);
        }
        return result;
    }

    public static ArrayList<ArrayList<Integer>> returnT_invWithoutTransition(ArrayList<ArrayList<Integer>> globalInv, int transLoc) {
        ArrayList<ArrayList<Integer>> result = new ArrayList<ArrayList<Integer>>();
        for (ArrayList<Integer> vector : globalInv) {
            if (vector.get(transLoc) != 0) continue;
            result.add(new ArrayList<Integer>(vector));
        }
        return result;
    }

    public static ArrayList<Integer> getFrequency(ArrayList<ArrayList<Integer>> invariants, boolean mmMode) {
        ArrayList<Integer> frequency = new ArrayList<Integer>();
        if (invariants == null || invariants.isEmpty()) {
            return frequency;
        }
        int invSize = invariants.get(0).size();
        if (mmMode) {
            --invSize;
        }
        for (int column = 0; column < invSize; ++column) {
            int freq = 0;
            for (ArrayList<Integer> invariant : invariants) {
                if (invariant.get(column) == 0) continue;
                ++freq;
            }
            frequency.add(freq);
        }
        return frequency;
    }

    public static ArrayList<Integer> getFrequencyRealInvariants(ArrayList<ArrayList<Integer>> invariants, boolean mmMode) {
        ArrayList<Integer> frequency = new ArrayList<Integer>();
        if (invariants == null || invariants.isEmpty()) {
            return frequency;
        }
        ArrayList<Integer> typesVector = overlord.getWorkspace().getProject().accessT_InvTypesVector();
        int invNumber = invariants.size();
        int invSize = invariants.get(0).size();
        if (mmMode) {
            --invSize;
        }
        for (int column = 0; column < invSize; ++column) {
            int freq = 0;
            for (int row = 0; row < invNumber; ++row) {
                if (typesVector.get(row) != 0 && typesVector.get(row) != 99999 || invariants.get(row).get(column) == 0) continue;
                ++freq;
            }
            frequency.add(freq);
        }
        return frequency;
    }

    public static ArrayList<Integer> getActiveTransitions(ArrayList<ArrayList<Integer>> invMatrix) {
        ArrayList<Integer> trans = new ArrayList<Integer>();
        block0: for (int i = 0; i < invMatrix.get(0).size(); ++i) {
            for (ArrayList<Integer> matrix : invMatrix) {
                if (matrix.get(i) <= 0) continue;
                trans.add(i);
                continue block0;
            }
        }
        return trans;
    }

    public static ArrayList<ArrayList<Integer>> getExtendedT_invariantsInfo(ArrayList<ArrayList<Integer>> invMatrix, boolean searchDoubleArcs) {
        ArrayList<ArrayList<Integer>> results = new ArrayList<ArrayList<Integer>>();
        ArrayList<Transition> transitions = overlord.getWorkspace().getProject().getTransitions();
        ArrayList<Integer> transIDdouble = new ArrayList<Integer>();
        if (searchDoubleArcs) {
            InvariantsCalculator ic = new InvariantsCalculator(true);
            ArrayList<ArrayList<Integer>> doubleArcs = ic.getDoubleArcs();
            for (int i = 0; i < transitions.size(); ++i) {
                transIDdouble.add(0);
            }
            for (ArrayList<Integer> vector : doubleArcs) {
                int value = (Integer)transIDdouble.get(vector.get(1));
                transIDdouble.set(vector.get(1), value + 1);
            }
        }
        for (ArrayList<Integer> invariant : invMatrix) {
            int readArcs = 0;
            int inhibitors = 0;
            int resets = 0;
            int equals = 0;
            int invSize = invariant.size();
            for (int e = 0; e < invSize; ++e) {
                int supp = invariant.get(e);
                if (supp == 0) continue;
                Transition transition = transitions.get(e);
                for (ElementLocation el : transition.getElementLocations()) {
                    for (Arc arc : el.getInArcs()) {
                        if (arc.getArcType() == Arc.TypeOfArc.NORMAL) continue;
                        if (arc.getArcType() == Arc.TypeOfArc.READARC) {
                            ++readArcs;
                            continue;
                        }
                        if (arc.getArcType() == Arc.TypeOfArc.INHIBITOR) {
                            ++inhibitors;
                            continue;
                        }
                        if (arc.getArcType() == Arc.TypeOfArc.RESET) {
                            ++resets;
                            continue;
                        }
                        if (arc.getArcType() != Arc.TypeOfArc.EQUAL) continue;
                        ++equals;
                    }
                }
                if (!searchDoubleArcs || (Integer)transIDdouble.get(e) <= 0) continue;
                readArcs += ((Integer)transIDdouble.get(e)).intValue();
            }
            ArrayList<Integer> invInfo = new ArrayList<Integer>();
            invInfo.add(readArcs);
            invInfo.add(inhibitors);
            invInfo.add(resets);
            invInfo.add(equals);
            results.add(invInfo);
        }
        return results;
    }

    public static ArrayList<ArrayList<Integer>> getT_invInOutTransInfo(ArrayList<ArrayList<Integer>> invMatrix) {
        ArrayList<ArrayList<Integer>> results = new ArrayList<ArrayList<Integer>>();
        ArrayList<Transition> transitions = overlord.getWorkspace().getProject().getTransitions();
        for (ArrayList<Integer> invariant : invMatrix) {
            int inTrans = 0;
            int pureInTrans = 0;
            int outTrans = 0;
            int invSize = invariant.size();
            for (int e = 0; e < invSize; ++e) {
                int supp = invariant.get(e);
                if (supp == 0) continue;
                Transition transition = transitions.get(e);
                int inArcs = 0;
                int extInArcs = 0;
                int outArcs = 0;
                for (ElementLocation el : transition.getElementLocations()) {
                    for (Arc a : el.getInArcs()) {
                        if (a.getArcType() == Arc.TypeOfArc.INHIBITOR || a.getArcType() == Arc.TypeOfArc.READARC) {
                            ++extInArcs;
                            continue;
                        }
                        ++inArcs;
                    }
                    for (Arc a : el.getOutArcs()) {
                        if (a.getArcType() == Arc.TypeOfArc.READARC) continue;
                        ++outArcs;
                    }
                }
                if (inArcs == 0 && extInArcs == 0) {
                    ++pureInTrans;
                }
                if (inArcs == 0 && extInArcs > 0) {
                    ++inTrans;
                }
                if (outArcs != 0) continue;
                ++outTrans;
            }
            ArrayList<Integer> transInfo = new ArrayList<Integer>();
            transInfo.add(pureInTrans);
            transInfo.add(inTrans);
            transInfo.add(outTrans);
            results.add(transInfo);
        }
        return results;
    }

    public static ArrayList<Integer> getT_invFeasibilityClassesStatic(ArrayList<ArrayList<Integer>> invariants) {
        ArrayList<Integer> results = new ArrayList<Integer>();
        ArrayList<Integer> readArcTransLocations = InvariantsTools.getReadArcTransitionsStatic();
        ArrayList<Transition> transitions = overlord.getWorkspace().getProject().getTransitions();
        for (ArrayList<Integer> invariant : invariants) {
            ArrayList<Integer> support = InvariantsTools.getSupport(invariant);
            if (InvariantsTools.isT_invNonFeasibleStatic(support, readArcTransLocations, transitions)) {
                results.add(-1);
                continue;
            }
            results.add(1);
        }
        return results;
    }

    private static boolean isT_invNonFeasibleStatic(ArrayList<Integer> support, ArrayList<Integer> readArcTransLocations, ArrayList<Transition> transitions) {
        ArrayList<Integer> readarcTransitions = new ArrayList<Integer>();
        for (int trans : readArcTransLocations) {
            if (!support.contains(trans)) continue;
            readarcTransitions.add(trans);
        }
        if (!readarcTransitions.isEmpty()) {
            for (int tID : readarcTransitions) {
                Transition transition = transitions.get(tID);
                ArrayList<Place> connPlaces = new ArrayList<Place>();
                for (ElementLocation el : transition.getElementLocations()) {
                    for (Arc arc : el.getInArcs()) {
                        Place p;
                        if (arc.getArcType() != Arc.TypeOfArc.READARC || (p = (Place)arc.getStartNode()).getTokensNumber() != 0 || connPlaces.contains(p)) continue;
                        connPlaces.add(p);
                    }
                }
                ArrayList<ArrayList<Integer>> connectedTransitions = new ArrayList<ArrayList<Integer>>();
                for (Place place : connPlaces) {
                    connectedTransitions.add(InvariantsTools.getConnectedTransitionsSet(place, transitions));
                }
                for (ArrayList arrayList : connectedTransitions) {
                    ArrayList test = new ArrayList(arrayList);
                    test.retainAll(support);
                    if (!test.isEmpty()) continue;
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public static ArrayList<Integer> getReadArcTransitionsStatic() {
        ArrayList<Integer> raTrans = new ArrayList<Integer>();
        ArrayList<Arc> arcs = overlord.getWorkspace().getProject().getArcs();
        ArrayList<Transition> transitions = overlord.getWorkspace().getProject().getTransitions();
        for (Arc a : arcs) {
            int position;
            Place p;
            Node node;
            if (a.getArcType() != Arc.TypeOfArc.READARC || !((node = a.getEndNode()) instanceof Transition) || (p = (Place)a.getStartNode()).getTokensNumber() > 0 || raTrans.contains(position = transitions.indexOf((Transition)node))) continue;
            raTrans.add(position);
        }
        return raTrans;
    }

    private static ArrayList<Integer> getConnectedTransitionsSet(Place place, ArrayList<Transition> transitions) {
        ArrayList<Integer> connectedTransitions = new ArrayList<Integer>();
        for (ElementLocation el : place.getElementLocations()) {
            for (Arc a : el.getInArcs()) {
                Transition trans;
                int pos;
                if (a.getArcType() == Arc.TypeOfArc.READARC || a.getArcType() == Arc.TypeOfArc.INHIBITOR || connectedTransitions.contains(pos = transitions.indexOf(trans = (Transition)a.getStartNode()))) continue;
                connectedTransitions.add(pos);
            }
        }
        return connectedTransitions;
    }

    public static int calculateNodesDistance(Node currentNode, Node target, ArrayList<Node> visited) {
        if (!visited.contains(currentNode)) {
            visited.add(currentNode);
        }
        if (currentNode.equals(target)) {
            return 0;
        }
        if (currentNode.getOutputArcs() != null) {
            for (Arc a : currentNode.getOutputArcs()) {
                Node node = a.getEndNode();
                if (visited.contains(node)) continue;
                visited.add(node);
                if (currentNode.equals(target)) {
                    return 0;
                }
                int path = InvariantsTools.calculateNodesDistance(node, target, visited);
                if (path <= -1) continue;
                return ++path;
            }
        }
        return -1;
    }

    public static ArrayList<Integer> transInT_invariants() {
        ArrayList<Integer> results = new ArrayList<Integer>();
        ArrayList<Transition> transitions = overlord.getWorkspace().getProject().getTransitions();
        for (int t = 0; t < transitions.size(); ++t) {
            results.add(0);
        }
        ArrayList<ArrayList<Integer>> invariantsMatrix = overlord.getWorkspace().getProject().getT_InvMatrix();
        if (invariantsMatrix == null || invariantsMatrix.isEmpty()) {
            return results;
        }
        for (ArrayList<Integer> matrix : invariantsMatrix) {
            for (int t = 0; t < invariantsMatrix.get(0).size(); ++t) {
                if (matrix.get(t) <= 0) continue;
                int oldVal = results.get(t);
                results.set(t, ++oldVal);
            }
        }
        return results;
    }

    public static boolean isDoubleArc(Arc arc) {
        Node startN = arc.getStartNode();
        Node endN = arc.getEndNode();
        for (Arc a : endN.getOutputArcs()) {
            if (a.getEndNode() != startN) continue;
            return true;
        }
        return false;
    }

    public static Arc getPairedArc(Arc arc) {
        Node startN = arc.getStartNode();
        Node endN = arc.getEndNode();
        for (Arc a : endN.getOutputArcs()) {
            if (a.getEndNode() != startN) continue;
            return a;
        }
        return null;
    }

    public static ArrayList<Integer> singleT_invAnalysis(ArrayList<ArrayList<Integer>> invMatrix, int invIndex, ArrayList<Transition> transitions, ArrayList<Integer> readArcTransLocations, ArrayList<ArrayList<Integer>> incidenceMatrix, ArrayList<ArrayList<Integer>> supportMatrix) {
        ArrayList<Integer> results = new ArrayList<Integer>();
        int containedSupportCounter = 0;
        int inTrans = 0;
        int pureInTrans = 0;
        int outTrans = 0;
        int readArcs = 0;
        int inhibitors = 0;
        int resets = 0;
        int equals = 0;
        int invariantsNumber = invMatrix.size();
        ArrayList<Integer> invariant = invMatrix.get(invIndex);
        int invSize = invariant.size();
        ArrayList<Integer> supportVector = InvariantsTools.getSupport(invariant);
        for (int j = 0; j < invariantsNumber; ++j) {
            if (InvariantsTools.supportInclusionCheck(supportVector, supportMatrix.get(j))) {
                ++containedSupportCounter;
            }
            if (containedSupportCounter > 0) break;
        }
        int feasibleInv = InvariantsTools.isT_invNonFeasibleStatic(supportVector, readArcTransLocations, transitions) ? -1 : 1;
        ArrayList<Integer> vector = InvariantsTools.check_invariantV2(incidenceMatrix, invariant);
        assert (vector != null);
        int invClass = vector.get(0) == 0 ? 0 : (vector.get(0) == -1 ? -1 : (vector.get(0) == 1 ? 1 : -99));
        int canonical = InvariantsTools.checkCanonitySingle(invariant) ? 1 : -1;
        ArrayList<Integer> transIDdouble = new ArrayList<Integer>();
        InvariantsCalculator ic = new InvariantsCalculator(true);
        ArrayList<ArrayList<Integer>> doubleArcs = ic.getDoubleArcs();
        for (int i = 0; i < transitions.size(); ++i) {
            transIDdouble.add(0);
        }
        for (ArrayList<Integer> pair : doubleArcs) {
            int value = (Integer)transIDdouble.get(pair.get(1));
            transIDdouble.set(pair.get(1), value + 1);
        }
        for (int e = 0; e < invSize; ++e) {
            int supp = invariant.get(e);
            if (supp == 0) continue;
            Transition transition = transitions.get(e);
            int inArcs = 0;
            int extInArcs = 0;
            int outArcs = 0;
            for (ElementLocation el : transition.getElementLocations()) {
                for (Arc arc : el.getInArcs()) {
                    if (arc.getArcType() == Arc.TypeOfArc.INHIBITOR || arc.getArcType() == Arc.TypeOfArc.READARC) {
                        ++extInArcs;
                    } else {
                        ++inArcs;
                    }
                    if (arc.getArcType() == Arc.TypeOfArc.NORMAL) continue;
                    if (arc.getArcType() == Arc.TypeOfArc.READARC) {
                        ++readArcs;
                        continue;
                    }
                    if (arc.getArcType() == Arc.TypeOfArc.INHIBITOR) {
                        ++inhibitors;
                        continue;
                    }
                    if (arc.getArcType() == Arc.TypeOfArc.RESET) {
                        ++resets;
                        continue;
                    }
                    if (arc.getArcType() != Arc.TypeOfArc.EQUAL) continue;
                    ++equals;
                }
                for (Arc a : el.getOutArcs()) {
                    if (a.getArcType() == Arc.TypeOfArc.READARC) continue;
                    ++outArcs;
                }
            }
            if ((Integer)transIDdouble.get(e) > 0) {
                readArcs += ((Integer)transIDdouble.get(e)).intValue();
            }
            if (inArcs == 0 && extInArcs == 0) {
                ++pureInTrans;
            }
            if (inArcs == 0 && extInArcs > 0) {
                ++inTrans;
            }
            if (outArcs != 0) continue;
            ++outTrans;
        }
        results.add(containedSupportCounter);
        results.add(feasibleInv);
        results.add(invClass);
        results.add(canonical);
        results.add(inTrans);
        results.add(pureInTrans);
        results.add(outTrans);
        results.add(readArcs);
        results.add(inhibitors);
        results.add(resets);
        results.add(equals);
        return results;
    }

    public static boolean areSameInvariants(ArrayList<Integer> inv1, ArrayList<Integer> inv2) {
        if (inv1.size() != inv2.size()) {
            return false;
        }
        for (int i = 0; i < inv1.size(); ++i) {
            if (Objects.equals(inv1.get(i), inv2.get(i))) continue;
            return false;
        }
        return true;
    }
}

