/*
 * Decompiled with CFR 0.152.
 */
package holmes.analyse;

import holmes.darkgui.GUIManager;
import holmes.darkgui.LanguageManager;
import holmes.petrinet.data.InvariantTransition;
import holmes.petrinet.data.PetriNet;
import holmes.petrinet.elements.Arc;
import holmes.petrinet.elements.Place;
import holmes.petrinet.elements.Transition;
import holmes.petrinet.simulators.GraphicalSimulator;
import holmes.petrinet.simulators.SimulationStep;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.Random;
import java.util.Stack;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.Timer;

public class InvariantsSimulator {
    private static final GUIManager overlord = GUIManager.getDefaultGUIManager();
    private static final LanguageManager lang = GUIManager.getLanguageManager();
    private NetType simulationType;
    private SimulatorMode mode;
    private SimulatorMode previousMode = SimulatorMode.STOPPED;
    private SimulatorType simType = SimulatorType.TIME;
    private PetriNet petriNet;
    private Integer delay = 0;
    private boolean simulationActive = false;
    private Timer timer;
    private ArrayList<Transition> launchingTransitions;
    private Stack<SimulationStep> actionStack;
    private boolean maximumMode = false;
    public static int DEFAULT_COUNTER = 50;
    public int stepValue;
    public JFrame timeFrame = new JFrame("Zegar");
    public double timeNetStepCounter = 0.0;
    public double timeNetPartStepCounter = 0.0;
    private ArrayList<ArrayList<InvariantTransition>> invariants;
    private ArrayList<Integer[]> generatedInvariants;
    private ArrayList<Integer> foundInvariants = new ArrayList();
    private ArrayList<Integer> lastTransition = new ArrayList();
    private InvariantsWriter invariantsWriter = new InvariantsWriter();

    public InvariantsSimulator(NetType type, PetriNet net, ArrayList<ArrayList<InvariantTransition>> inv, int st, int simV) {
        this.simulationType = type;
        this.petriNet = net;
        this.invariants = inv;
        this.mode = SimulatorMode.LOOP;
        if (st == 0) {
            this.simType = SimulatorType.TIME;
        }
        if (st == 1) {
            this.simType = SimulatorType.STEP;
        }
        if (st == 2) {
            this.simType = SimulatorType.CYCLE;
        }
        this.stepValue = simV;
        this.launchingTransitions = new ArrayList();
        this.actionStack = new Stack();
        this.clearGenInvariants();
    }

    private boolean isPossibleStep() {
        for (Transition transition : this.petriNet.getTransitions()) {
            if (!transition.isActive()) continue;
            return true;
        }
        return false;
    }

    public void setSimulatorNetType(int type) {
        switch (type) {
            case 0: {
                this.simulationType = NetType.BASIC;
                break;
            }
            case 1: {
                this.simulationType = NetType.TIME;
            }
        }
    }

    public void startSimulation(SimulatorMode simulatorMode) {
        this.timeFrame.setBounds(185, 115, 80, 30);
        this.timeFrame.getContentPane().add((Component)new JLabel(String.valueOf(this.timeNetStepCounter)), "Center");
        this.timeFrame.pack();
        this.timeFrame.setVisible(true);
        this.previousMode = this.getMode();
        this.setMode(simulatorMode);
        this.setSimulationActive(true);
        SimulationPerformer taskPerformer = new SimulationPerformer();
        overlord.getSimulatorBox().getCurrentDockWindow().allowOnlySimulationDisruptButtons();
        switch (this.getMode()) {
            case LOOP: {
                taskPerformer = new StepPerformer(true, this.simType, this.stepValue);
                break;
            }
            case SINGLE_TRANSITION_LOOP: {
                taskPerformer = new SingleTransitionPerformer(true);
                break;
            }
            case SINGLE_TRANSITION: {
                taskPerformer = new SingleTransitionPerformer();
                break;
            }
            case STEP: {
                taskPerformer = new StepPerformer();
                break;
            }
            case ACTION_BACK: {
                taskPerformer = new StepBackPerformer();
                break;
            }
            case LOOP_BACK: {
                this.launchingTransitions.clear();
                taskPerformer = new StepBackPerformer(true);
            }
        }
        this.setTimer(new Timer(this.getDelay(), taskPerformer));
        this.getTimer().start();
    }

    private ArrayList<Transition> generateValidLaunchingTransitions() {
        boolean generated = false;
        ArrayList<Transition> launchingTransitions = new ArrayList<Transition>();
        while (!generated) {
            launchingTransitions = this.generateLaunchingTransitions();
            if (launchingTransitions.size() <= 0) continue;
            generated = true;
        }
        return launchingTransitions;
    }

    private ArrayList<Transition> generateLaunchingTransitions() {
        Random randomLaunch = new Random();
        ArrayList<Transition> launchableTransitions = new ArrayList<Transition>();
        ArrayList<Transition> allTransitions = this.petriNet.getTransitions();
        ArrayList<Integer> indexList = new ArrayList<Integer>();
        int i = 0;
        for (Transition ignored : allTransitions) {
            indexList.add(i);
            ++i;
        }
        Collections.shuffle(indexList);
        if (this.simulationType == NetType.BASIC) {
            for (i = 0; i < allTransitions.size(); ++i) {
                Transition transition = allTransitions.get((Integer)indexList.get(i));
                if (!transition.isActive() || randomLaunch.nextInt(100) >= 50 && !this.maximumMode) continue;
                transition.bookRequiredTokens();
                launchableTransitions.add(transition);
            }
        }
        for (Transition transition : launchableTransitions) {
            transition.returnBookedTokens();
        }
        return launchableTransitions;
    }

    public ArrayList<Transition> searchConflict(Transition t, ArrayList<Transition> list) {
        return null;
    }

    public void launchSubtractPhase(ArrayList<Transition> transitions, boolean backtracking) {
        for (Transition transition : transitions) {
            transition.setLaunching(true);
            ArrayList<Arc> arcs = !backtracking ? transition.getInputArcs() : transition.getOutputArcs();
            for (Arc arc : arcs) {
                arc.setSimulationForwardDirection(!backtracking);
                arc.setTransportingTokens(true);
                Place place = !backtracking ? (Place)arc.getStartNode() : (Place)arc.getEndNode();
                place.addTokensNumber(-arc.getWeight());
            }
        }
    }

    public boolean launchSingleSubtractPhase(ArrayList<Transition> transitions, boolean backtracking, Transition chosenTransition) {
        ArrayList<Arc> arcs;
        Transition tran;
        if (transitions.size() < 1) {
            return false;
        }
        if (!backtracking) {
            tran = transitions.get(0);
            arcs = tran.getInputArcs();
        } else {
            tran = chosenTransition;
            arcs = tran.getOutputArcs();
        }
        tran.setLaunching(true);
        for (Arc arc : arcs) {
            arc.setSimulationForwardDirection(!backtracking);
            arc.setTransportingTokens(true);
            Place place = !backtracking ? (Place)arc.getStartNode() : (Place)arc.getEndNode();
            place.addTokensNumber(-arc.getWeight());
        }
        return true;
    }

    public void launchAddPhaseGraphics(ArrayList<Transition> transitions, boolean backtracking) {
        for (Transition tran : transitions) {
            tran.setLaunching(true);
            ArrayList<Arc> arcs = !backtracking ? tran.getOutputArcs() : tran.getInputArcs();
            for (Arc arc : arcs) {
                arc.setSimulationForwardDirection(!backtracking);
                arc.setTransportingTokens(true);
            }
        }
    }

    public boolean launchSingleAddPhaseGraphics(ArrayList<Transition> transitions, boolean backtracking, Transition chosenTransition) {
        ArrayList<Arc> arcs;
        Transition tran;
        if (transitions.size() < 1) {
            return false;
        }
        if (!backtracking) {
            tran = transitions.get(0);
            arcs = tran.getOutputArcs();
        } else {
            tran = chosenTransition;
            arcs = tran.getInputArcs();
        }
        tran.setLaunching(true);
        for (Arc arc : arcs) {
            arc.setSimulationForwardDirection(!backtracking);
            arc.setTransportingTokens(true);
        }
        return true;
    }

    public void launchAddPhase(ArrayList<Transition> transitions, boolean backtracking) {
        for (Transition transition : transitions) {
            ArrayList<Arc> arcs = !backtracking ? transition.getOutputArcs() : transition.getInputArcs();
            for (Arc arc : arcs) {
                Place place = !backtracking ? (Place)arc.getEndNode() : (Place)arc.getStartNode();
                place.addTokensNumber(arc.getWeight());
            }
        }
        transitions.clear();
    }

    public boolean launchSingleAddPhase(ArrayList<Transition> transitions, boolean backtracking, Transition chosenTransition) {
        ArrayList<Arc> arcs;
        Transition tran;
        if (transitions.size() < 1) {
            return false;
        }
        if (!backtracking) {
            tran = transitions.get(0);
            arcs = tran.getOutputArcs();
        } else {
            tran = chosenTransition;
            arcs = tran.getInputArcs();
        }
        for (Arc arc : arcs) {
            Place place = !backtracking ? (Place)arc.getEndNode() : (Place)arc.getStartNode();
            place.addTokensNumber(arc.getWeight());
        }
        transitions.remove(tran);
        return true;
    }

    public void stop() {
        ((SimulationPerformer)this.getTimer().getActionListeners()[0]).scheduleStop();
    }

    public void pause() {
        if (this.getMode() != SimulatorMode.PAUSED && this.getMode() != SimulatorMode.STOPPED) {
            this.pauseSimulation();
        } else if (this.getMode() == SimulatorMode.PAUSED) {
            this.unpauseSimulation();
        } else if (this.getMode() == SimulatorMode.STOPPED) {
            JOptionPane.showMessageDialog(null, "Can't pause a stopped simulation!", "The simulator is already stopped!", 0);
        }
    }

    private void stopSimulation() {
        overlord.getSimulatorBox().getCurrentDockWindow().allowOnlySimulationInitiateButtons();
        this.timer.stop();
        this.previousMode = this.mode;
        this.setMode(SimulatorMode.STOPPED);
    }

    private void pauseSimulation() {
        overlord.getSimulatorBox().getCurrentDockWindow().allowOnlyUnpauseButton();
        this.timer.stop();
        this.previousMode = this.mode;
        this.setMode(SimulatorMode.PAUSED);
    }

    private void unpauseSimulation() {
        overlord.getSimulatorBox().getCurrentDockWindow().allowOnlySimulationDisruptButtons();
        if (this.previousMode != SimulatorMode.STOPPED) {
            this.timer.start();
            this.setMode(this.previousMode);
        }
    }

    public boolean isSimulationActive() {
        return this.simulationActive;
    }

    public void setSimulationActive(boolean simulationActive) {
        this.simulationActive = simulationActive;
        overlord.getWorkspace().getProject().setSimulationActive(this.isSimulationActive());
    }

    public int getNodesAmount() {
        return this.petriNet.getNodes().size();
    }

    public int getPlacesAmount() {
        return this.petriNet.getPlaces().size();
    }

    public int getTransitionsAmount() {
        return this.petriNet.getTransitions().size();
    }

    public int getArcsAmount() {
        return this.petriNet.getArcs().size();
    }

    public int getTokensAmount() {
        int tokenAmount = 0;
        for (Place place : this.petriNet.getPlaces()) {
            tokenAmount += place.getTokensNumber();
        }
        return tokenAmount;
    }

    public Timer getTimer() {
        return this.timer;
    }

    private void setTimer(Timer timer) {
        this.timer = timer;
    }

    public Integer getDelay() {
        return this.delay;
    }

    public void setDelay(Integer delay) {
        if (this.timer != null) {
            this.timer.setDelay(delay);
        }
        this.delay = delay;
    }

    public SimulatorMode getMode() {
        return this.mode;
    }

    public void setMode(SimulatorMode mode) {
        this.mode = mode;
    }

    private ArrayList<Transition> cloneTransitionArray(ArrayList<Transition> transitions) {
        ArrayList<Transition> newArray = new ArrayList<Transition>();
        for (Transition transition : transitions) {
            newArray.add(transition);
        }
        return newArray;
    }

    public boolean isMaximumMode() {
        return this.maximumMode;
    }

    public void setMaximumMode(boolean maximumMode) {
        this.maximumMode = maximumMode;
    }

    private void clearGenInvariants() {
        for (ArrayList<InvariantTransition> invariant : this.invariants) {
            this.lastTransition.add(Integer.MAX_VALUE);
            this.foundInvariants.add(0);
        }
        this.generatedInvariants = new ArrayList();
        for (ArrayList<InvariantTransition> in : this.invariants) {
            this.generatedInvariants.add(new Integer[999]);
        }
        for (int i = 0; i < this.invariants.size(); ++i) {
            for (int j = 0; j < this.invariants.get(i).size(); ++j) {
                this.generatedInvariants.get((int)i)[j] = 0;
            }
        }
    }

    public static enum SimulatorMode {
        LOOP,
        SINGLE_TRANSITION_LOOP,
        SINGLE_TRANSITION,
        STEP,
        STOPPED,
        PAUSED,
        ACTION_BACK,
        LOOP_BACK;

    }

    public static enum SimulatorType {
        TIME,
        CYCLE,
        STEP;

    }

    public static class InvariantsWriter {
        String zawartoscPliku = "";

        public void write(ArrayList<ArrayList<InvariantTransition>> invariants, ArrayList<Integer> counterOfInvariants) {
            try {
                SimpleDateFormat df = new SimpleDateFormat("MM_dd_yyyy_HH_mm_ss");
                Date today = Calendar.getInstance().getTime();
                String saveDate = df.format(today);
                PrintWriter zapis = new PrintWriter("invariants_generation_" + saveDate + ".isr");
                this.zawartoscPliku = this.zawartoscPliku + "------Invariants Simulation Result------\n\n";
                for (int i = 0; i < invariants.size(); ++i) {
                    this.zawartoscPliku = this.zawartoscPliku + i + " : cycle = " + String.valueOf(counterOfInvariants.get(i)) + ": invariant = ";
                    for (int j = 0; j < invariants.get(i).size(); ++j) {
                        this.zawartoscPliku = this.zawartoscPliku + invariants.get(i).get(j).getTransition().getName();
                        if (j >= invariants.get(i).size() - 1) continue;
                        this.zawartoscPliku = this.zawartoscPliku + ", ";
                    }
                    this.zawartoscPliku = this.zawartoscPliku + ";\n";
                }
                this.zawartoscPliku = this.zawartoscPliku + "\n";
                zapis.println(this.zawartoscPliku);
                zapis.close();
            }
            catch (Exception e) {
                System.err.println("Error: " + e.getMessage());
                JOptionPane.showMessageDialog(null, "Program cannot write invariants into file", "Error", 0);
                overlord.log(e.getMessage(), "error", true);
            }
        }
    }

    public static enum NetType {
        BASIC,
        COLORED,
        TIME;

    }

    public class SimulationPerformer
    implements ActionListener {
        protected int counter = DEFAULT_COUNTER;
        protected boolean subtractPhase = true;
        protected boolean finishedAddPhase = true;
        protected boolean scheduledStop = false;
        protected int remainingTransitionsAmount;

        public SimulationPerformer() {
            this.remainingTransitionsAmount = InvariantsSimulator.this.launchingTransitions.size();
        }

        protected void updateStep() {
            overlord.getWorkspace().getProject().incrementGraphicalSimulationStep();
        }

        public void scheduleStop() {
            this.scheduledStop = true;
        }

        public void executeScheduledStop() {
            InvariantsSimulator.this.stopSimulation();
            this.scheduledStop = false;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            this.updateStep();
        }
    }

    public class StepPerformer
    extends SimulationPerformer {
        private boolean loop;
        private long time;
        SimulatorType simulatorType = SimulatorType.TIME;
        int cycle = 0;
        int steps = 0;
        int stepCounter = 0;

        public StepPerformer() {
            InvariantsSimulator.this.timeFrame.setVisible(false);
            this.loop = false;
            Date date = new Date();
            long t = date.getTime();
            this.time = t + 300000L;
        }

        public StepPerformer(boolean looping, SimulatorType st, int value) {
            this.loop = looping;
            this.simulatorType = st;
            Date date = new Date();
            long t = date.getTime();
            if (this.simulatorType == SimulatorType.TIME) {
                this.time = t + (long)value * 60000L;
            }
            if (this.simulatorType == SimulatorType.CYCLE) {
                this.cycle = value;
            }
            if (this.simulatorType == SimulatorType.STEP) {
                this.steps = value;
            }
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Date date = new Date();
            if (this.simulatorType == SimulatorType.TIME && date.getTime() > this.time) {
                this.loop = false;
            }
            if (this.simulatorType == SimulatorType.STEP && this.steps >= this.stepCounter) {
                this.loop = false;
            }
            if (this.simulatorType == SimulatorType.CYCLE) {
                Iterator<Serializable> iterator = InvariantsSimulator.this.foundInvariants.iterator();
                while (iterator.hasNext()) {
                    int in = iterator.next();
                    if (in != this.cycle) continue;
                    this.loop = false;
                }
            }
            this.updateStep();
            if (this.counter == DEFAULT_COUNTER && this.subtractPhase) {
                if (this.scheduledStop) {
                    this.executeScheduledStop();
                } else if (InvariantsSimulator.this.isPossibleStep()) {
                    if (this.remainingTransitionsAmount == 0) {
                        InvariantsSimulator.this.launchingTransitions = InvariantsSimulator.this.generateValidLaunchingTransitions();
                        this.remainingTransitionsAmount = InvariantsSimulator.this.launchingTransitions.size();
                    }
                    if (InvariantsSimulator.this.launchingTransitions.size() > 0) {
                        for (Transition lau_tran : InvariantsSimulator.this.launchingTransitions) {
                            for (int invariant = 0; invariant < InvariantsSimulator.this.invariants.size(); ++invariant) {
                                for (int tran = 0; tran < InvariantsSimulator.this.invariants.get(invariant).size(); ++tran) {
                                    if (lau_tran.getID() != InvariantsSimulator.this.invariants.get(invariant).get(tran).getTransition().getID()) continue;
                                    if (InvariantsSimulator.this.lastTransition.get(invariant) != Integer.MAX_VALUE) {
                                        int j;
                                        boolean connectionExist = false;
                                        for (Arc arc : InvariantsSimulator.this.invariants.get(invariant).get(tran).getTransition().getInputArcs()) {
                                            for (Arc arcPlace : arc.getStartNode().getInputArcs()) {
                                                if (arcPlace.getStartNode().getID() != InvariantsSimulator.this.lastTransition.get(invariant).intValue()) continue;
                                                connectionExist = true;
                                            }
                                        }
                                        if (connectionExist) {
                                            InvariantsSimulator.this.lastTransition.set(invariant, InvariantsSimulator.this.invariants.get(invariant).get(tran).getTransition().getID());
                                            Integer[] integerArray = InvariantsSimulator.this.generatedInvariants.get(invariant);
                                            int arc = tran;
                                            Integer n = integerArray[arc];
                                            integerArray[arc] = integerArray[arc] + 1;
                                        }
                                        boolean ready = true;
                                        boolean toomany = false;
                                        for (int tr = 0; tr < InvariantsSimulator.this.invariants.get(invariant).size(); ++tr) {
                                            if (InvariantsSimulator.this.generatedInvariants.get(invariant)[tr] != InvariantsSimulator.this.invariants.get(invariant).get(tr).getAmountOfFirings()) {
                                                ready = false;
                                            }
                                            if (InvariantsSimulator.this.generatedInvariants.get(invariant)[tr] <= InvariantsSimulator.this.invariants.get(invariant).get(tr).getAmountOfFirings()) continue;
                                            toomany = true;
                                        }
                                        if (ready) {
                                            InvariantsSimulator.this.foundInvariants.set(invariant, InvariantsSimulator.this.foundInvariants.get(invariant) + 1);
                                            for (j = 0; j < InvariantsSimulator.this.invariants.get(invariant).size(); ++j) {
                                                InvariantsSimulator.this.generatedInvariants.get((int)invariant)[j] = 0;
                                            }
                                            InvariantsSimulator.this.lastTransition.set(invariant, Integer.MAX_VALUE);
                                        }
                                        if (!toomany) continue;
                                        for (j = 0; j < InvariantsSimulator.this.invariants.get(invariant).size(); ++j) {
                                            InvariantsSimulator.this.generatedInvariants.get((int)invariant)[j] = 0;
                                        }
                                        InvariantsSimulator.this.lastTransition.set(invariant, Integer.MAX_VALUE);
                                        continue;
                                    }
                                    InvariantsSimulator.this.lastTransition.set(invariant, InvariantsSimulator.this.invariants.get(invariant).get(tran).getTransition().getID());
                                    Integer[] integerArray = InvariantsSimulator.this.generatedInvariants.get(invariant);
                                    int n = tran;
                                    Integer n2 = integerArray[n];
                                    integerArray[n] = integerArray[n] + 1;
                                }
                            }
                        }
                    }
                    InvariantsSimulator.this.actionStack.push(new SimulationStep(GraphicalSimulator.SimulatorMode.STEP, InvariantsSimulator.this.cloneTransitionArray(InvariantsSimulator.this.launchingTransitions)));
                    if (InvariantsSimulator.this.actionStack.peek().getPendingTransitions() == null) {
                        overlord.log("Uknown problem in actionPerformed(ActionEvent event) in InvariantsSimulator class", "error", true);
                    }
                    InvariantsSimulator.this.launchSubtractPhase(InvariantsSimulator.this.launchingTransitions, false);
                    this.subtractPhase = false;
                } else {
                    InvariantsSimulator.this.setSimulationActive(false);
                    InvariantsSimulator.this.stopSimulation();
                    JOptionPane.showMessageDialog(null, "Simulation ended", "No more available steps!", 1);
                    overlord.log("Simulation ended, no more available steps.", "text", true);
                }
                this.counter = 0;
            } else if (this.counter == DEFAULT_COUNTER && !this.subtractPhase) {
                InvariantsSimulator.this.launchAddPhaseGraphics(InvariantsSimulator.this.launchingTransitions, false);
                this.finishedAddPhase = false;
                this.counter = 0;
            } else if (this.counter == DEFAULT_COUNTER - 5 && !this.finishedAddPhase) {
                InvariantsSimulator.this.launchAddPhase(InvariantsSimulator.this.launchingTransitions, false);
                this.finishedAddPhase = true;
                this.subtractPhase = true;
                this.remainingTransitionsAmount = 0;
                if (!this.loop) {
                    this.scheduleStop();
                    for (int i = 0; i < InvariantsSimulator.this.invariants.size(); ++i) {
                        for (int j = 0; j < InvariantsSimulator.this.invariants.get(i).size(); ++j) {
                            System.out.println(InvariantsSimulator.this.generatedInvariants.get(i)[j].toString());
                        }
                    }
                    System.out.println("Znalezione Invarianty");
                    for (Integer invar : InvariantsSimulator.this.foundInvariants) {
                        System.out.println(invar);
                    }
                    InvariantsSimulator.this.invariantsWriter.write(InvariantsSimulator.this.invariants, InvariantsSimulator.this.foundInvariants);
                }
                ++this.counter;
            } else {
                ++this.counter;
            }
            ++this.stepCounter;
        }
    }

    public class SingleTransitionPerformer
    extends SimulationPerformer {
        private boolean loop;

        public SingleTransitionPerformer() {
            this.loop = false;
        }

        public SingleTransitionPerformer(boolean looping) {
            this.loop = looping;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            this.updateStep();
            if (this.counter == DEFAULT_COUNTER && this.subtractPhase) {
                if (this.scheduledStop) {
                    this.executeScheduledStop();
                } else if (InvariantsSimulator.this.isPossibleStep()) {
                    if (this.remainingTransitionsAmount == 0) {
                        InvariantsSimulator.this.launchingTransitions = InvariantsSimulator.this.generateValidLaunchingTransitions();
                        this.remainingTransitionsAmount = InvariantsSimulator.this.launchingTransitions.size();
                    }
                    InvariantsSimulator.this.actionStack.push(new SimulationStep(GraphicalSimulator.SimulatorMode.SINGLE_TRANSITION, InvariantsSimulator.this.launchingTransitions.get(0), InvariantsSimulator.this.cloneTransitionArray(InvariantsSimulator.this.launchingTransitions)));
                    InvariantsSimulator.this.launchSingleSubtractPhase(InvariantsSimulator.this.launchingTransitions, false, null);
                    this.subtractPhase = false;
                } else {
                    InvariantsSimulator.this.setSimulationActive(false);
                    InvariantsSimulator.this.stopSimulation();
                    JOptionPane.showMessageDialog(null, "Simulation ended", "No more available steps!", 1);
                    overlord.log("Simulation ended, no more available steps.", "text", true);
                }
                this.counter = 0;
            } else if (this.counter == DEFAULT_COUNTER && !this.subtractPhase) {
                InvariantsSimulator.this.launchSingleAddPhaseGraphics(InvariantsSimulator.this.launchingTransitions, false, null);
                this.finishedAddPhase = false;
                this.counter = 0;
            } else if (this.counter == DEFAULT_COUNTER - 5 && !this.finishedAddPhase) {
                InvariantsSimulator.this.launchSingleAddPhase(InvariantsSimulator.this.launchingTransitions, false, null);
                this.remainingTransitionsAmount = InvariantsSimulator.this.launchingTransitions.size();
                this.finishedAddPhase = true;
                this.subtractPhase = true;
                if (!this.loop) {
                    this.scheduleStop();
                }
                ++this.counter;
            } else {
                ++this.counter;
            }
        }
    }

    public class StepBackPerformer
    extends SimulationPerformer {
        private boolean loop;
        ArrayList<Transition> currentTransitions = new ArrayList();
        SimulationStep currentStep;

        public StepBackPerformer() {
            this.loop = false;
        }

        public StepBackPerformer(boolean looping) {
            this.loop = looping;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            this.updateStep();
            if (this.counter == DEFAULT_COUNTER && this.subtractPhase) {
                if (this.scheduledStop) {
                    this.executeScheduledStop();
                } else if (!InvariantsSimulator.this.actionStack.empty()) {
                    this.currentStep = InvariantsSimulator.this.actionStack.pop();
                    if (this.currentStep.getType() == GraphicalSimulator.SimulatorMode.STEP) {
                        InvariantsSimulator.this.launchSubtractPhase(this.currentStep.getPendingTransitions(), true);
                    } else if (this.currentStep.getType() == GraphicalSimulator.SimulatorMode.SINGLE_TRANSITION) {
                        InvariantsSimulator.this.launchSingleSubtractPhase(this.currentStep.getPendingTransitions(), true, this.currentStep.getLaunchedTransition());
                    }
                    this.subtractPhase = false;
                } else {
                    InvariantsSimulator.this.setSimulationActive(false);
                    InvariantsSimulator.this.stopSimulation();
                    JOptionPane.showMessageDialog(null, "Backtracking ended", "No more available actions to backtrack!", 1);
                    overlord.log("Backtracking ended, no more available actions to backtrack.", "text", true);
                }
                this.counter = 0;
            } else if (this.counter == DEFAULT_COUNTER && !this.subtractPhase) {
                if (this.currentStep.getType() == GraphicalSimulator.SimulatorMode.STEP) {
                    InvariantsSimulator.this.launchAddPhaseGraphics(this.currentStep.getPendingTransitions(), true);
                } else if (this.currentStep.getType() == GraphicalSimulator.SimulatorMode.SINGLE_TRANSITION) {
                    InvariantsSimulator.this.launchSingleAddPhaseGraphics(this.currentStep.getPendingTransitions(), true, this.currentStep.getLaunchedTransition());
                }
                this.finishedAddPhase = false;
                this.counter = 0;
            } else if (this.counter == DEFAULT_COUNTER - 5 && !this.finishedAddPhase) {
                if (this.currentStep.getType() == GraphicalSimulator.SimulatorMode.STEP) {
                    InvariantsSimulator.this.launchAddPhase(this.currentStep.getPendingTransitions(), true);
                } else if (this.currentStep.getType() == GraphicalSimulator.SimulatorMode.SINGLE_TRANSITION) {
                    InvariantsSimulator.this.launchSingleAddPhase(this.currentStep.getPendingTransitions(), true, this.currentStep.getLaunchedTransition());
                }
                this.finishedAddPhase = true;
                this.subtractPhase = true;
                if (!this.loop) {
                    this.scheduleStop();
                }
                ++this.counter;
            } else {
                ++this.counter;
            }
        }
    }
}

