/*
 * Decompiled with CFR 0.152.
 */
package holmes.analyse;

import holmes.analyse.InvariantsTools;
import holmes.darkgui.GUIManager;
import holmes.darkgui.LanguageManager;
import holmes.petrinet.elements.Arc;
import holmes.petrinet.elements.ElementLocation;
import holmes.petrinet.elements.Node;
import holmes.petrinet.elements.Place;
import holmes.petrinet.elements.Transition;
import holmes.varia.Check;
import holmes.windows.HolmesInvariantsGenerator;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import javax.swing.JOptionPane;

public class InvariantsCalculatorFeasible {
    private static final GUIManager overlord = GUIManager.getDefaultGUIManager();
    private static final LanguageManager lang = GUIManager.getLanguageManager();
    private HolmesInvariantsGenerator masterWindow = overlord.accessInvariantsWindow();
    private String status = "";
    private boolean success = false;
    private ArrayList<ArrayList<Integer>> invariants;
    private ArrayList<ArrayList<Integer>> feasibleInv;
    private ArrayList<ArrayList<Integer>> non_feasibleInv;
    private ArrayList<ArrayList<Integer>> f_invariantsCreated;
    private ArrayList<Transition> transitions;
    private ArrayList<Integer> readArcTransLocations;
    private boolean tInv;
    private boolean allowSelfPropelledInvariants = true;
    private int selfPropInvariants = 0;

    public InvariantsCalculatorFeasible(ArrayList<ArrayList<Integer>> invariants, boolean isTInv) {
        this.invariants = invariants;
        this.tInv = isTInv;
        this.f_invariantsCreated = new ArrayList();
    }

    public ArrayList<ArrayList<Integer>> getMinFeasible(int mode) {
        ArrayList<Integer> arcClassCount = Check.getArcClassCount();
        if (arcClassCount.get(1) == 0 && arcClassCount.get(5) == 0) {
            this.status = "No read arcs. All invariants are feasible.";
            this.success = false;
            return this.invariants;
        }
        if (this.tInv) {
            this.transitions = overlord.getWorkspace().getProject().getTransitions();
            this.readArcTransLocations = this.getReadArcTransitions();
            this.allowSelfPropelledInvariants = overlord.getSettingsManager().getValue("analysisFeasibleSelfPropAccepted").equals("1");
            if (mode == 0) {
                this.searchFTInvSimple();
            } else {
                this.searchFTInvAdvanced();
            }
            this.status = lang.getText("ICF_entry001");
            this.success = true;
            this.logInternal(lang.getText("ICF_entry002") + " " + this.f_invariantsCreated.size() + "\n", false);
            this.logInternal(lang.getText("ICF_entry003") + " " + this.selfPropInvariants + "\n", false);
            return this.makeFeasibleSet();
        }
        JOptionPane.showMessageDialog(null, lang.getText("ICF_entry004"), "Warning", 2);
        this.status = lang.getText("ICF_entry005");
        this.success = false;
        return this.invariants;
    }

    private void searchFTInvSimple() {
        this.partitionInvariants();
        for (ArrayList<Integer> integers : this.non_feasibleInv) {
            ArrayList<ArrayList<Integer>> invToCombine = new ArrayList<ArrayList<Integer>>();
            ArrayList<Integer> nonFInvSupport = InvariantsTools.getSupport(integers);
            ArrayList<Integer> trans_RA = this.getInfeasibleTransitions(integers);
            ArrayList<Place> places_RA = this.getRA_Places(trans_RA);
            for (Place pl : places_RA) {
                ArrayList<Integer> minimalFeasibleInvariant;
                ArrayList<Integer> connectedTransitions = this.getConnectedTransitionsSet(pl);
                if (this.allowSelfPropelledInvariants && !this.intersection(nonFInvSupport, connectedTransitions).isEmpty() || invToCombine.contains(minimalFeasibleInvariant = this.findMinFeasibleSimple(connectedTransitions))) continue;
                invToCombine.add(minimalFeasibleInvariant);
            }
            invToCombine.add(integers);
            if (invToCombine.size() == 1) {
                this.feasibleInv.add(integers);
                ++this.selfPropInvariants;
                continue;
            }
            ArrayList<Integer> newFeasible = this.createFeasibleInvariant(invToCombine);
            this.f_invariantsCreated.add(newFeasible);
        }
    }

    private void searchFTInvAdvanced() {
        this.partitionInvariants();
        this.f_invariantsCreated = new ArrayList();
        for (ArrayList<Integer> integers : this.non_feasibleInv) {
            ArrayList<ArrayList<Integer>> invToCombine = new ArrayList<ArrayList<Integer>>();
            ArrayList<Integer> trans_RA = this.getInfeasibleTransitions(integers);
            ArrayList<Place> places_RA = this.getRA_Places(trans_RA);
            ArrayList<ArrayList<Integer>> connectedTransitionsSet = new ArrayList<ArrayList<Integer>>();
            for (Place pl : places_RA) {
                ArrayList<Integer> connectedTransitions = this.getConnectedTransitionsSet(pl);
                connectedTransitionsSet.add(connectedTransitions);
            }
            int oldSize = connectedTransitionsSet.size();
            ArrayList<ArrayList<Integer>> connectedTransitionsSetNew = this.checkSelfPropelledInv(integers, connectedTransitionsSet);
            int newSize = connectedTransitionsSetNew.size();
            if (this.allowSelfPropelledInvariants) {
                connectedTransitionsSet = connectedTransitionsSetNew;
            }
            int setsNumber = connectedTransitionsSet.size();
            int found = 0;
            int upperSearchBound = setsNumber;
            while (found != setsNumber) {
                ArrayList<Integer> foundVectors = this.searchCandidate(connectedTransitionsSet, upperSearchBound);
                if (foundVectors == null) {
                    --upperSearchBound;
                } else {
                    found += upperSearchBound;
                    if (upperSearchBound > connectedTransitionsSet.size()) {
                        upperSearchBound = connectedTransitionsSet.size();
                    }
                    if (!invToCombine.contains(foundVectors)) {
                        invToCombine.add(foundVectors);
                    }
                }
                if (upperSearchBound != 0 && !connectedTransitionsSet.isEmpty()) continue;
                break;
            }
            invToCombine.add(integers);
            if (invToCombine.size() == 1) {
                this.feasibleInv.add(integers);
                ++this.selfPropInvariants;
                continue;
            }
            ArrayList<Integer> newFeasible = this.createFeasibleInvariant(invToCombine);
            int feasibleNumber = this.feasibleInv.size();
            if (oldSize != newSize) {
                this.logInternal(lang.getText("ICF_entry006a") + " " + (feasibleNumber + this.f_invariantsCreated.size()) + lang.getText("ICF_entry006b") + " " + (oldSize - newSize) + " " + lang.getText("ICF_entry006c") + " " + oldSize + ".\n", false);
            }
            if (!InvariantsTools.checkCanonitySingle(newFeasible)) {
                this.logInternal(lang.getText("ICF_entry007a") + " " + (feasibleNumber + this.f_invariantsCreated.size()) + " " + lang.getText("ICF_entry007b"), false);
            }
            this.f_invariantsCreated.add(newFeasible);
        }
    }

    private ArrayList<ArrayList<Integer>> checkSelfPropelledInv(ArrayList<Integer> nonFInvariant, ArrayList<ArrayList<Integer>> connectedTransitionsSet) {
        ArrayList<ArrayList<Integer>> newConnTransSet = new ArrayList<ArrayList<Integer>>();
        ArrayList<Integer> support = InvariantsTools.getSupport(nonFInvariant);
        for (ArrayList<Integer> set : connectedTransitionsSet) {
            if (!this.intersection(support, set).isEmpty()) continue;
            newConnTransSet.add(set);
        }
        return newConnTransSet;
    }

    private ArrayList<Integer> searchCandidate(ArrayList<ArrayList<Integer>> connectedTransitionsSet, int upperSearchBound) {
        Iterator f_inv_support;
        int connSetsSize = connectedTransitionsSet.size();
        int fCandidatesFound = 0;
        ArrayList<ArrayList<Integer>> results = new ArrayList<ArrayList<Integer>>();
        ArrayList forWhichConnSets = new ArrayList();
        block0: for (ArrayList<Integer> f_invariant : this.feasibleInv) {
            int currentFound = 0;
            int currentNotFound = 0;
            f_inv_support = InvariantsTools.getSupport(f_invariant);
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (int cs = 0; cs < connSetsSize; ++cs) {
                ArrayList<Integer> connectedSet = connectedTransitionsSet.get(cs);
                if (!this.intersection((ArrayList<Integer>)((Object)f_inv_support), connectedSet).isEmpty()) {
                    arrayList.add(cs);
                    if (++currentFound != upperSearchBound) continue;
                    results.add(f_invariant);
                    forWhichConnSets.add(arrayList);
                    ++fCandidatesFound;
                    continue block0;
                }
                if (connSetsSize - ++currentNotFound < upperSearchBound) continue block0;
            }
        }
        if (fCandidatesFound == 0) {
            return null;
        }
        if (fCandidatesFound == 1) {
            ArrayList sets = (ArrayList)forWhichConnSets.get(0);
            ArrayList<ArrayList<Integer>> setsToRemove = new ArrayList<ArrayList<Integer>>();
            f_inv_support = sets.iterator();
            while (f_inv_support.hasNext()) {
                int n = (Integer)f_inv_support.next();
                ArrayList<Integer> setToRemove = connectedTransitionsSet.get(n);
                setsToRemove.add(setToRemove);
            }
            for (ArrayList arrayList : setsToRemove) {
                connectedTransitionsSet.remove(arrayList);
            }
            return (ArrayList)results.get(0);
        }
        int minSupportCardinality = ((ArrayList)results.get(0)).size();
        int minSupportSum = 9999999;
        int indexFound = -1;
        int n = results.size();
        for (int i = 0; i < n; ++i) {
            ArrayList cand_invariant = (ArrayList)results.get(i);
            int minSC = 0;
            int n2 = 0;
            boolean dontBother = false;
            Iterator iterator = cand_invariant.iterator();
            while (iterator.hasNext()) {
                int el = (Integer)iterator.next();
                if (el == 0) continue;
                n2 += el;
                if (++minSC <= minSupportCardinality) continue;
                dontBother = true;
                break;
            }
            if (dontBother) continue;
            if (minSC < minSupportCardinality) {
                minSupportCardinality = minSC;
                minSupportSum = n2;
                indexFound = i;
                continue;
            }
            if (minSC != minSupportCardinality || n2 >= minSupportSum) continue;
            minSupportCardinality = minSC;
            minSupportSum = n2;
            indexFound = i;
        }
        ArrayList sets = (ArrayList)forWhichConnSets.get(indexFound);
        ArrayList<ArrayList<Integer>> setsToRemove = new ArrayList<ArrayList<Integer>>();
        Iterator iterator = sets.iterator();
        while (iterator.hasNext()) {
            int n3 = (Integer)iterator.next();
            ArrayList<Integer> setToRemove = connectedTransitionsSet.get(n3);
            setsToRemove.add(setToRemove);
        }
        for (ArrayList arrayList : setsToRemove) {
            connectedTransitionsSet.remove(arrayList);
        }
        return (ArrayList)results.get(indexFound);
    }

    public ArrayList<Integer> intersection(ArrayList<Integer> list1, ArrayList<Integer> list2) {
        ArrayList<Integer> result = new ArrayList<Integer>(list1);
        result.retainAll(list2);
        return result;
    }

    private ArrayList<Integer> findMinFeasibleSimple(ArrayList<Integer> connectedTransitions) {
        int minSupportCardinality = this.feasibleInv.get(0).size();
        int minSupportSum = 9999999;
        int indexFound = -1;
        int feasibleSize = this.feasibleInv.size();
        for (int transLoc : connectedTransitions) {
            for (int i = 0; i < feasibleSize; ++i) {
                ArrayList<Integer> f_invariant = this.feasibleInv.get(i);
                if (f_invariant.get(transLoc) == 0) continue;
                int minSC = 0;
                int minSS = 0;
                boolean dontBother = false;
                for (int el : f_invariant) {
                    if (el == 0) continue;
                    minSS += el;
                    if (++minSC <= minSupportCardinality) continue;
                    dontBother = true;
                    break;
                }
                if (dontBother) continue;
                if (minSC < minSupportCardinality) {
                    minSupportCardinality = minSC;
                    minSupportSum = minSS;
                    indexFound = i;
                    continue;
                }
                if (minSC != minSupportCardinality || minSS >= minSupportSum) continue;
                minSupportCardinality = minSC;
                minSupportSum = minSS;
                indexFound = i;
            }
        }
        return this.feasibleInv.get(indexFound);
    }

    private ArrayList<ArrayList<Integer>> makeFeasibleSet() {
        ArrayList<ArrayList<Integer>> resultSet = new ArrayList<ArrayList<Integer>>(this.feasibleInv);
        resultSet.addAll(this.f_invariantsCreated);
        return resultSet;
    }

    private ArrayList<Integer> createFeasibleInvariant(ArrayList<ArrayList<Integer>> invToCombine) {
        ArrayList<Integer> vector = new ArrayList<Integer>();
        int invSize = invToCombine.get(0).size();
        for (int i = 0; i < invSize; ++i) {
            vector.add(0);
        }
        for (ArrayList<Integer> invariant : invToCombine) {
            ArrayList<Integer> support = InvariantsTools.getSupport(invariant);
            for (int el : support) {
                int oldValue = vector.get(el);
                vector.set(el, oldValue += invariant.get(el).intValue());
            }
        }
        return vector;
    }

    private ArrayList<Integer> getConnectedTransitionsSet(Place place) {
        ArrayList<Integer> connectedTransitions = new ArrayList<Integer>();
        for (ElementLocation el : place.getElementLocations()) {
            for (Arc a : el.getInArcs()) {
                if (a.getArcType() == Arc.TypeOfArc.READARC || a.getArcType() == Arc.TypeOfArc.INHIBITOR) continue;
                Transition trans = (Transition)a.getStartNode();
                int pos = this.transitions.indexOf(trans);
                if (!connectedTransitions.contains(pos)) {
                    connectedTransitions.add(pos);
                    continue;
                }
                overlord.log("Internal error, net structure not canonical.", "error", true);
            }
        }
        return connectedTransitions;
    }

    private ArrayList<Place> getRA_Places(ArrayList<Integer> trans_RA) {
        ArrayList<Place> resultPlaces = new ArrayList<Place>();
        for (int tr : trans_RA) {
            Transition transition = this.transitions.get(tr);
            for (ElementLocation el : transition.getElementLocations()) {
                for (Arc a : el.getOutArcs()) {
                    if (a.getArcType() != Arc.TypeOfArc.READARC && (a.getArcType() != Arc.TypeOfArc.NORMAL || !InvariantsTools.isDoubleArc(a))) continue;
                    Place p = (Place)a.getEndNode();
                    if (!resultPlaces.contains(p)) {
                        resultPlaces.add(p);
                        continue;
                    }
                    overlord.log("Internal error, multiple readarcs, net not canonical. Place: " + p.getName(), "error", true);
                }
            }
        }
        return resultPlaces;
    }

    private void partitionInvariants() {
        this.non_feasibleInv = new ArrayList();
        this.feasibleInv = new ArrayList();
        for (ArrayList<Integer> invariant : this.invariants) {
            ArrayList<Integer> support = InvariantsTools.getSupport(invariant);
            if (this.isNonFeasible(support)) {
                this.non_feasibleInv.add(invariant);
                continue;
            }
            this.feasibleInv.add(invariant);
        }
    }

    private ArrayList<Integer> getReadArcTransitions() {
        ArrayList<Integer> raTrans = new ArrayList<Integer>();
        ArrayList<Arc> arcs = overlord.getWorkspace().getProject().getArcs();
        for (Arc a : arcs) {
            int position;
            if (a.getArcType() == Arc.TypeOfArc.READARC) {
                int position2;
                Place p;
                Node node = a.getEndNode();
                if (!(node instanceof Transition) || (p = (Place)a.getStartNode()).getTokensNumber() > 0 || raTrans.contains(position2 = this.transitions.indexOf((Transition)node))) continue;
                raTrans.add(position2);
                continue;
            }
            if (a.getArcType() != Arc.TypeOfArc.NORMAL || !InvariantsTools.isDoubleArc(a)) continue;
            Node n = a.getEndNode();
            if (n instanceof Place) {
                int position3;
                if (((Place)n).getTokensNumber() > 0 || raTrans.contains(position3 = this.transitions.indexOf((Transition)a.getStartNode()))) continue;
                raTrans.add(position3);
                continue;
            }
            n = a.getStartNode();
            if (((Place)n).getTokensNumber() > 0 || raTrans.contains(position = this.transitions.indexOf((Transition)a.getEndNode()))) continue;
            raTrans.add(position);
        }
        return raTrans;
    }

    private boolean isNonFeasible(ArrayList<Integer> support) {
        for (int trans : this.readArcTransLocations) {
            if (!support.contains(trans)) continue;
            return true;
        }
        return false;
    }

    private ArrayList<Integer> getInfeasibleTransitions(ArrayList<Integer> invariant) {
        ArrayList<Integer> vector = new ArrayList<Integer>();
        ArrayList<Integer> support = InvariantsTools.getSupport(invariant);
        for (int trans : support) {
            if (!this.readArcTransLocations.contains(trans)) continue;
            vector.add(trans);
        }
        return vector;
    }

    public boolean getStatus() {
        return this.success;
    }

    private void logInternal(String msg, boolean date) {
        String timeStamp = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(Calendar.getInstance().getTime());
        if (this.masterWindow != null) {
            if (!date) {
                this.masterWindow.accessLogFieldTinv().append(msg);
            } else {
                this.masterWindow.accessLogFieldTinv().append("[" + timeStamp + "] " + msg);
            }
        }
    }
}

