/*
 * Decompiled with CFR 0.152.
 */
package holmes.analyse;

import holmes.analyse.InvariantsTools;
import holmes.analyse.MCTCalculator;
import holmes.darkgui.GUIManager;
import holmes.darkgui.LanguageManager;
import holmes.petrinet.data.PetriNet;
import holmes.petrinet.elements.Arc;
import holmes.petrinet.elements.PetriNetElement;
import holmes.petrinet.elements.Place;
import holmes.petrinet.elements.Transition;
import holmes.varia.Check;
import holmes.windows.HolmesInvariantsGenerator;
import holmes.windows.HolmesNotepad;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import javax.swing.JTextArea;

public class InvariantsCalculator
implements Runnable {
    private static final GUIManager overlord = GUIManager.getDefaultGUIManager();
    private static final LanguageManager lang = GUIManager.getLanguageManager();
    private ArrayList<Arc> arcs;
    private ArrayList<Place> places;
    private ArrayList<Transition> transitions;
    private ArrayList<ArrayList<Integer>> t_invariantsList = new ArrayList();
    private ArrayList<ArrayList<Integer>> p_invariantsList = new ArrayList();
    private ArrayList<ArrayList<Integer>> globalIncidenceMatrix;
    private ArrayList<Integer> GLOBAL_INC_VECTOR;
    private int IDENT_MATRIX_ROW_SIZE;
    private ArrayList<ArrayList<Integer>> globalIdentityMatrix;
    private ArrayList<ArrayList<Integer>> CMatrix;
    private ArrayList<Integer> removalList;
    private ArrayList<Integer> nonZeroColumnVector;
    private ArrayList<ArrayList<Integer>> doubleArcs;
    private boolean t_InvMode;
    private int newRejected = 0;
    private int oldReplaced = 0;
    private int notCanonical = 0;
    private boolean showInvSetsDifference = false;
    private HolmesInvariantsGenerator masterWindow = null;
    private ArrayList<ArrayList<Integer>> invBackupMatrix = null;

    public InvariantsCalculator(boolean transCal) {
        this.masterWindow = overlord.accessInvariantsWindow();
        this.t_InvMode = transCal;
        this.places = overlord.getWorkspace().getProject().getPlaces();
        this.transitions = overlord.getWorkspace().getProject().getTransitions();
        this.arcs = overlord.getWorkspace().getProject().getArcs();
        this.nonZeroColumnVector = new ArrayList();
    }

    public InvariantsCalculator(PetriNet pn) {
        this.t_InvMode = true;
        this.places = pn.getPlaces();
        this.transitions = pn.getTransitions();
        this.arcs = pn.getArcs();
        this.nonZeroColumnVector = new ArrayList();
    }

    public InvariantsCalculator(ArrayList<Place> places, ArrayList<Transition> transitions, ArrayList<Arc> arcs, boolean transCal) {
        this.t_InvMode = transCal;
        this.places = places;
        this.transitions = transitions;
        this.arcs = arcs;
        this.nonZeroColumnVector = new ArrayList();
    }

    public void generateInvariantsForTest(PetriNet project) {
        try {
            if (this.t_InvMode) {
                if (this.showInvSetsDifference) {
                    this.invBackupMatrix = project.getT_InvMatrix();
                }
                this.createTPIncidenceAndIdentityMatrix(false, this.t_InvMode);
                this.calculateInvariants();
            } else {
                if (this.showInvSetsDifference) {
                    this.invBackupMatrix = project.getP_InvMatrix();
                }
                this.createTPIncidenceAndIdentityMatrix(false, this.t_InvMode);
                this.calculateInvariants();
            }
        }
        catch (Exception e) {
            overlord.log(lang.getText("LOGentry00052"), "warning", true);
            this.logInternal(lang.getText("IC_entry002"), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.logInternal(lang.getText("IC_entry001"), true);
            if (this.t_InvMode) {
                PetriNet project = overlord.getWorkspace().getProject();
                if (this.showInvSetsDifference) {
                    this.invBackupMatrix = project.getT_InvMatrix();
                }
                this.createTPIncidenceAndIdentityMatrix(false, this.t_InvMode);
                this.calculateInvariants();
                if (overlord.getSettingsManager().getValue("analysisRemoveNonInv").equals("1")) {
                    this.logInternal("\n", false);
                    this.logInternal(lang.getText("IC_entry003") + "\n", false);
                    InvariantsCalculator minion_ic = new InvariantsCalculator(true);
                    ArrayList<ArrayList<Integer>> cleanInv = InvariantsTools.getOnlyRealInvariants(minion_ic.getCMatrix(), this.getInvariants(true), true);
                    if (this.getInvariants(true).size() != cleanInv.size()) {
                        this.logInternal(this.getInvariants(true).size() - cleanInv.size() + " " + lang.getText("IC_entry004") + " " + cleanInv.size() + " " + lang.getText("IC_entry005") + " " + this.getInvariants(true).size() + "\n", false);
                    }
                    this.t_invariantsList = cleanInv;
                }
                if (overlord.getSettingsManager().getValue("analysisRemoveSingleElementInv").equals("1")) {
                    this.logInternal("\n", false);
                    this.logInternal(lang.getText("IC_entry006") + "\n", false);
                    int size = this.t_invariantsList.size();
                    int removed = 0;
                    for (int i = 0; i < size; ++i) {
                        ArrayList<Integer> inv = this.t_invariantsList.get(i);
                        int supportSum = 0;
                        for (int j : inv) {
                            supportSum += j;
                        }
                        if (supportSum != true) continue;
                        this.t_invariantsList.remove(i);
                        --i;
                        --size;
                        ++removed;
                    }
                    this.logInternal(removed + " " + lang.getText("IC_entry007") + " " + this.t_invariantsList.size() + "\n", false);
                }
                project.setT_InvMatrix(this.getInvariants(true), true);
                overlord.getT_invBox().showT_invBoxWindow(this.getInvariants(true));
                InvariantsCalculator.overlord.reset.setT_invariantsStatus(true);
                overlord.accessNetTablesWindow().resetT_invData();
                this.logInternal(lang.getText("IC_entry008") + " " + this.getInvariants(true).size() + "\n", true);
                ArrayList<Integer> arcClasses = Check.getArcClassCount();
                if (arcClasses.get(1) > 0) {
                    this.logInternal("\n", false);
                    this.logInternal(lang.getText("IC_entry009") + " " + arcClasses.get(1) / 2 + " " + lang.getText("IC_entry010"), false);
                    this.logInternal(lang.getText("IC_entry011"), false);
                }
                if (!this.doubleArcs.isEmpty()) {
                    this.logInternal("\n", false);
                    this.logInternal(lang.getText("IC_entry012"), false);
                    for (ArrayList<Integer> trouble : this.doubleArcs) {
                        this.logInternal(lang.getText("IC_entry013") + String.valueOf(trouble.get(0)) + " " + lang.getText("IC_entry014") + String.valueOf(trouble.get(1)) + "\n", false);
                    }
                    this.logInternal(lang.getText("IC_entry015"), false);
                }
                this.logInternal("\n", false);
                this.logInternal("=====================================================================\n", false);
                this.logInternal(lang.getText("IC_entry016") + " " + this.t_invariantsList.size() + " " + lang.getText("IC_entry017"), false);
                InvariantsCalculator ic = new InvariantsCalculator(true);
                ArrayList<ArrayList<Integer>> results = InvariantsTools.analyseInvariantDetails(ic.getCMatrix(), this.t_invariantsList, true);
                this.logInternal(lang.getText("IC_entry018") + " " + String.valueOf(results.get(0).get(0)) + "\n", false);
                this.logInternal(lang.getText("IC_entry019") + " " + String.valueOf(results.get(0).get(1)) + "\n", false);
                this.logInternal(lang.getText("IC_entry020") + " " + String.valueOf(results.get(0).get(2)) + "\n", false);
                this.logInternal(lang.getText("IC_entry021") + " " + String.valueOf(results.get(0).get(3)) + "\n", false);
                this.logInternal("=====================================================================\n", false);
                overlord.markNetChange();
                overlord.getT_invBox().getCurrentDockWindow().refreshSubSurCombos();
                MCTCalculator analyzer = overlord.getWorkspace().getProject().getMCTanalyzer();
                ArrayList<ArrayList<Transition>> mct = analyzer.generateMCT();
                overlord.getWorkspace().getProject().setMCTMatrix(mct, true);
                overlord.getMctBox().showMCT(mct);
                if (this.showInvSetsDifference && this.invBackupMatrix != null && !this.invBackupMatrix.isEmpty()) {
                    this.logInternal(lang.getText("IC_entry022"), false);
                    this.logInternal("", false);
                    int size = this.getInvariants(true).size();
                    int step = size / 50;
                    if (step == 0) {
                        step = 1;
                    }
                    int counter = -1;
                    int removed = 0;
                    block8: for (ArrayList<Integer> invariant : this.getInvariants(true)) {
                        if (++counter % step == 0 && this.masterWindow != null) {
                            this.masterWindow.accessLogField(this.t_InvMode).append("*");
                        }
                        for (int i = 0; i < this.invBackupMatrix.size(); ++i) {
                            if (!InvariantsTools.areSameInvariants(invariant, this.invBackupMatrix.get(i))) continue;
                            this.invBackupMatrix.remove(i);
                            ++removed;
                            continue block8;
                        }
                    }
                    HolmesNotepad notePad = new HolmesNotepad(900, 600);
                    notePad.setVisible(true);
                    notePad.addTextLineNL(lang.getText("IC_entry023") + " " + this.invBackupMatrix.size(), "text");
                    notePad.addTextLineNL(lang.getText("IC_entry024") + " " + removed + " " + lang.getText("IC_entry025"), "text");
                    notePad.addTextLineNL(lang.getText("IC_entry026"), "text");
                    notePad.addTextLineNL(lang.getText("IC_entry027"), "text");
                    notePad.addTextLineNL("", "text");
                    for (int i = 0; i < this.invBackupMatrix.size(); ++i) {
                        StringBuilder csvVector = new StringBuilder(i + ";");
                        for (int supp : this.invBackupMatrix.get(i)) {
                            csvVector.append(supp).append(";");
                        }
                        csvVector = new StringBuilder(csvVector.substring(0, csvVector.length() - 1));
                        notePad.addTextLineNL(csvVector.toString(), "text");
                    }
                }
            } else {
                this.createTPIncidenceAndIdentityMatrix(false, this.t_InvMode);
                this.calculateInvariants();
                if (overlord.getSettingsManager().getValue("analysisRemoveNonInv").equals("1")) {
                    this.logInternal("\n", false);
                    this.logInternal(lang.getText("IC_entry028") + "\n", false);
                    InvariantsCalculator minion_ic = new InvariantsCalculator(false);
                    ArrayList<ArrayList<Integer>> cleanInv = InvariantsTools.getOnlyRealInvariants(minion_ic.getCMatrix(), this.getInvariants(false), false);
                    if (this.getInvariants(false).size() != cleanInv.size()) {
                        this.logInternal(this.getInvariants(false).size() - cleanInv.size() + " " + lang.getText("IC_entry029") + " " + cleanInv.size() + " " + lang.getText("IC_entry030") + " " + this.getInvariants(false).size() + "\n", false);
                    }
                    this.p_invariantsList = cleanInv;
                }
                PetriNet project = overlord.getWorkspace().getProject();
                overlord.getP_invBox().showP_invBoxWindow(this.getInvariants(false));
                project.setP_InvMatrix(this.getInvariants(false));
                InvariantsCalculator.overlord.reset.setP_invariantsStatus(true);
                this.logInternal(lang.getText("IC_entry031") + " " + this.getInvariants(false).size() + "\n", true);
                ArrayList<Integer> arcClasses = Check.getArcClassCount();
                if (arcClasses.get(1) > 0) {
                    this.logInternal("\n", false);
                    this.logInternal(lang.getText("IC_entry032") + " " + arcClasses.get(1) / 2 + " " + lang.getText("IC_entry033"), false);
                }
                if (!this.doubleArcs.isEmpty()) {
                    this.logInternal("\n", false);
                    this.logInternal(lang.getText("IC_entry034"), false);
                    for (ArrayList<Integer> trouble : this.doubleArcs) {
                        this.logInternal(lang.getText("IC_entry035") + String.valueOf(trouble.get(0)) + " " + lang.getText("IC_entry036") + String.valueOf(trouble.get(1)) + "\n", false);
                    }
                }
                this.logInternal("\n", false);
                this.logInternal("=====================================================================\n", false);
                this.logInternal(lang.getText("IC_entry037") + " " + this.p_invariantsList.size() + " " + lang.getText("IC_entry038"), false);
                InvariantsCalculator ic = new InvariantsCalculator(true);
                ArrayList<ArrayList<Integer>> results = InvariantsTools.analyseInvariantDetails(ic.getCMatrix(), this.p_invariantsList, false);
                this.logInternal(lang.getText("IC_entry039") + " " + String.valueOf(results.get(0).get(0)) + "\n", false);
                this.logInternal(lang.getText("IC_entry040") + " " + String.valueOf(results.get(0).get(1)) + "\n", false);
                this.logInternal(lang.getText("IC_entry041") + " " + String.valueOf(results.get(0).get(2)) + "\n", false);
                this.logInternal(lang.getText("IC_entry042") + " " + String.valueOf(results.get(0).get(3)) + "\n", false);
                this.logInternal("=====================================================================\n", false);
                overlord.markNetChange();
            }
        }
        catch (Exception e) {
            overlord.log(lang.getText("LOGentry00053"), "warning", true);
            this.logInternal(lang.getText("IC_entry043"), true);
        }
        finally {
            this.masterWindow.resetInvariantGenerator();
        }
    }

    public ArrayList<ArrayList<Integer>> getCMatrix() {
        this.createTPIncidenceAndIdentityMatrix(true, true);
        return this.CMatrix;
    }

    public void createTPIncidenceAndIdentityMatrix(boolean silence, boolean tInvMode) {
        int i;
        HashMap<Place, Integer> placesMap = new HashMap<Place, Integer>();
        HashMap<Transition, Integer> transitionsMap = new HashMap<Transition, Integer>();
        for (i = 0; i < this.places.size(); ++i) {
            placesMap.put(this.places.get(i), i);
        }
        for (i = 0; i < this.transitions.size(); ++i) {
            transitionsMap.put(this.transitions.get(i), i);
        }
        this.globalIncidenceMatrix = new ArrayList();
        this.globalIdentityMatrix = new ArrayList();
        this.CMatrix = new ArrayList();
        this.removalList = new ArrayList();
        this.doubleArcs = new ArrayList();
        for (int trans = 0; trans < this.transitions.size(); ++trans) {
            ArrayList<Integer> transRow = new ArrayList<Integer>();
            for (int place = 0; place < this.places.size(); ++place) {
                transRow.add(0);
            }
            this.globalIncidenceMatrix.add(transRow);
            this.CMatrix.add(new ArrayList(transRow));
        }
        for (Arc oneArc : this.arcs) {
            int incidenceValue;
            int pPosition;
            int tPosition;
            if (oneArc.getArcType() != Arc.TypeOfArc.NORMAL && oneArc.getArcType() != Arc.TypeOfArc.READARC || oneArc.getStartNode().isInvisible() || oneArc.getEndNode().isInvisible()) continue;
            if (oneArc.getStartNode().getType() == PetriNetElement.PetriNetElementType.TRANSITION) {
                tPosition = (Integer)transitionsMap.get((Transition)oneArc.getStartNode());
                pPosition = (Integer)placesMap.get((Place)oneArc.getEndNode());
                incidenceValue = oneArc.getWeight();
            } else {
                tPosition = (Integer)transitionsMap.get((Transition)oneArc.getEndNode());
                pPosition = (Integer)placesMap.get((Place)oneArc.getStartNode());
                incidenceValue = -1 * oneArc.getWeight();
            }
            int oldValue = this.globalIncidenceMatrix.get(tPosition).get(pPosition);
            if (oldValue != 0) {
                ArrayList<Integer> hiddenReadArc = new ArrayList<Integer>();
                hiddenReadArc.add(pPosition);
                hiddenReadArc.add(tPosition);
                this.doubleArcs.add(hiddenReadArc);
            }
            this.globalIncidenceMatrix.get(tPosition).set(pPosition, oldValue + incidenceValue);
            this.CMatrix.get(tPosition).set(pPosition, oldValue + incidenceValue);
        }
        if (!silence) {
            this.logInternal(lang.getText("IC_entry044") + " " + this.transitions.size() + " " + lang.getText("IC_entry045") + " " + this.places.size() + " " + lang.getText("IC_entry046"), false);
        }
        if (tInvMode) {
            for (int t = 0; t < this.transitions.size(); ++t) {
                ArrayList<Integer> identRow = new ArrayList<Integer>();
                for (int t2 = 0; t2 < this.transitions.size(); ++t2) {
                    if (t == t2) {
                        identRow.add(1);
                        continue;
                    }
                    identRow.add(0);
                }
                this.globalIdentityMatrix.add(identRow);
            }
            int INC_MATRIX_ROW_SIZE = this.globalIncidenceMatrix.get(0).size();
            this.IDENT_MATRIX_ROW_SIZE = this.transitions.size();
            this.GLOBAL_INC_VECTOR = new ArrayList();
            for (int i2 = 0; i2 < INC_MATRIX_ROW_SIZE; ++i2) {
                this.GLOBAL_INC_VECTOR.add(0);
            }
        } else {
            this.globalIncidenceMatrix = InvariantsTools.transposeMatrix(this.globalIncidenceMatrix);
            this.CMatrix = InvariantsTools.transposeMatrix(this.CMatrix);
            for (int p = 0; p < this.places.size(); ++p) {
                ArrayList<Integer> identRow = new ArrayList<Integer>();
                for (int p2 = 0; p2 < this.places.size(); ++p2) {
                    if (p == p2) {
                        identRow.add(1);
                        continue;
                    }
                    identRow.add(0);
                }
                this.globalIdentityMatrix.add(identRow);
            }
            int INC_MATRIX_ROW_SIZE = this.globalIncidenceMatrix.get(0).size();
            this.IDENT_MATRIX_ROW_SIZE = this.places.size();
            this.GLOBAL_INC_VECTOR = new ArrayList();
            for (int i3 = 0; i3 < INC_MATRIX_ROW_SIZE; ++i3) {
                this.GLOBAL_INC_VECTOR.add(0);
            }
        }
        if (!silence) {
            this.logInternal(lang.getText("IC_entry047") + " " + this.transitions.size() + " " + lang.getText("IC_entry048"), false);
        }
    }

    public void calculateInvariants() {
        ArrayList<ArrayList<Integer>> generatedRows;
        if (this.globalIncidenceMatrix == null) {
            this.logInternal(lang.getText("IC_entry049"), false);
            return;
        }
        this.logInternal(lang.getText("IC_entry050"), false);
        int columnsNumber = this.globalIncidenceMatrix.get(0).size();
        for (int p = 0; p < columnsNumber; ++p) {
            this.nonZeroColumnVector.add(p);
        }
        for (int col = 0; col < columnsNumber; ++col) {
            if (!this.isSimpleColumn(this.globalIncidenceMatrix, col)) continue;
            this.logInternal(lang.getText("IC_entry051") + " " + col + "\n", false);
            generatedRows = this.findNewRows(col);
            this.rewriteIncidenceIntegrityMatrices(generatedRows, col);
            this.nonZeroColumnVector.remove((Object)col);
        }
        while (!this.nonZeroColumnVector.isEmpty()) {
            int stepsToFinish = this.nonZeroColumnVector.size();
            int[] res = this.chooseNextColumn();
            int cand = res[0];
            int rowsChange = res[1];
            int oldSize = this.globalIncidenceMatrix.size();
            this.logInternal(lang.getText("IC_entry052") + " " + cand + lang.getText("IC_entry053") + " " + (oldSize + rowsChange) + lang.getText("IC_entry054") + " " + stepsToFinish, false);
            generatedRows = this.findNewRows(cand);
            this.rewriteIncidenceIntegrityMatrices(generatedRows, cand);
            this.nonZeroColumnVector.remove((Object)cand);
            int newSize = this.globalIncidenceMatrix.size();
            this.logInternal(lang.getText("IC_entry055") + " " + newSize + " " + lang.getText("IC_entry056") + " " + this.newRejected + " " + lang.getText("IC_entry057") + " " + this.oldReplaced + " " + lang.getText("IC_entry058") + " " + this.notCanonical + "\n", false);
        }
        this.setInvariants(this.globalIdentityMatrix);
    }

    public void calculateSecondNetInvariants() {
        ArrayList<ArrayList<Integer>> generatedRows;
        this.logInternal(lang.getText("IC_entry059"), false);
        int columnsNumber = this.globalIncidenceMatrix.get(0).size();
        for (int p = 0; p < columnsNumber; ++p) {
            this.nonZeroColumnVector.add(p);
        }
        for (int col = 0; col < columnsNumber; ++col) {
            if (!this.isSimpleColumn(this.globalIncidenceMatrix, col)) continue;
            this.logInternal(lang.getText("IC_entry060") + " " + col + "\n", false);
            generatedRows = this.findNewRows(col);
            this.rewriteIncidenceIntegrityMatrices(generatedRows, col);
            this.nonZeroColumnVector.remove((Object)col);
        }
        while (!this.nonZeroColumnVector.isEmpty()) {
            int stepsToFinish = this.nonZeroColumnVector.size();
            int[] res = this.chooseNextColumn();
            int cand = res[0];
            int rowsChange = res[1];
            int oldSize = this.globalIncidenceMatrix.size();
            this.logInternal(lang.getText("IC_entry052") + " " + cand + lang.getText("IC_entry053") + " " + (oldSize + rowsChange) + lang.getText("IC_entry054") + " " + stepsToFinish, false);
            generatedRows = this.findNewRows(cand);
            this.rewriteIncidenceIntegrityMatrices(generatedRows, cand);
            this.nonZeroColumnVector.remove((Object)cand);
            int newSize = this.globalIncidenceMatrix.size();
            this.logInternal(lang.getText("IC_entry055") + " " + newSize + " " + lang.getText("IC_entry056") + " " + this.newRejected + " " + lang.getText("IC_entry057") + " " + this.oldReplaced + " " + lang.getText("IC_entry058") + " " + this.notCanonical + "\n", false);
        }
        this.setInvariants(this.globalIdentityMatrix);
    }

    private boolean isSimpleColumn(ArrayList<ArrayList<Integer>> incidenceMatrix, int column) {
        int input = 0;
        int output = 0;
        for (ArrayList<Integer> matrix : incidenceMatrix) {
            if (matrix.get(column) > 0) {
                ++input;
            }
            if (matrix.get(column) < 0) {
                ++output;
            }
            if (input != 2 && output != 2) continue;
            return false;
        }
        if (input == 0 && output == 0) {
            return true;
        }
        return input == 1 && output == 1;
    }

    private int[] chooseNextColumn() {
        ArrayList<Integer> numberOfNewRows = new ArrayList<Integer>();
        ArrayList<Integer> positives = new ArrayList<Integer>();
        ArrayList<Integer> negatives = new ArrayList<Integer>();
        int nonZeroColSize = this.nonZeroColumnVector.size();
        for (int col : this.nonZeroColumnVector) {
            int posCounter = 0;
            int negCounter = 0;
            for (ArrayList<Integer> incidenceMatrix : this.globalIncidenceMatrix) {
                if (incidenceMatrix.get(col) > 0) {
                    ++posCounter;
                }
                if (incidenceMatrix.get(col) >= 0) continue;
                ++negCounter;
            }
            int growthFactor = posCounter * negCounter - (posCounter + negCounter);
            if (growthFactor < 0) {
                int[] res = new int[]{col, growthFactor, posCounter, negCounter};
                return res;
            }
            numberOfNewRows.add(growthFactor);
            positives.add(posCounter);
            negatives.add(negCounter);
        }
        int cand = this.nonZeroColumnVector.get(0);
        int nOfRows = (Integer)numberOfNewRows.get(0);
        int poss = (Integer)positives.get(0);
        int negg = (Integer)negatives.get(0);
        for (int i = 0; i < nonZeroColSize; ++i) {
            if ((Integer)numberOfNewRows.get(i) >= nOfRows) continue;
            nOfRows = (Integer)numberOfNewRows.get(i);
            cand = this.nonZeroColumnVector.get(i);
            poss = (Integer)positives.get(i);
            negg = (Integer)negatives.get(i);
        }
        int[] tab = new int[]{cand, nOfRows, poss, negg};
        return tab;
    }

    private ArrayList<ArrayList<Integer>> findNewRows(int columnIndex) {
        int sizeM = this.globalIncidenceMatrix.size();
        ArrayList<ArrayList<Integer>> newRows = new ArrayList<ArrayList<Integer>>();
        for (int row1 = 0; row1 < sizeM; ++row1) {
            int val1 = this.globalIncidenceMatrix.get(row1).get(columnIndex);
            if (val1 == 0) continue;
            int l1 = this.bezwzgledna(val1);
            for (int row2 = row1; row2 < sizeM; ++row2) {
                int val2 = this.globalIncidenceMatrix.get(row2).get(columnIndex);
                if (val2 == 0 || row2 == row1 || (val1 <= 0 || val2 >= 0) && (val1 >= 0 || val2 <= 0)) continue;
                int l2 = this.bezwzgledna(val2);
                int nww = l1 * l2 / InvariantsCalculator.nwd(l1, l2);
                ArrayList<Integer> rowsTransformation = new ArrayList<Integer>();
                rowsTransformation.add(row1);
                rowsTransformation.add(row2);
                rowsTransformation.add(nww / l1);
                rowsTransformation.add(nww / l2);
                rowsTransformation.add(columnIndex);
                newRows.add(rowsTransformation);
                if (!this.removalList.contains(row1)) {
                    this.removalList.add(row1);
                }
                if (this.removalList.contains(row2)) continue;
                this.removalList.add(row2);
            }
        }
        return newRows;
    }

    private void addNewRowsToMatrix(ArrayList<Integer> newRowData) {
        ArrayList<Integer> incMatrixNewRow = new ArrayList<Integer>(this.GLOBAL_INC_VECTOR);
        int row1 = newRowData.get(0);
        int row2 = newRowData.get(1);
        int multFactorT1 = newRowData.get(2);
        int multFactorT2 = newRowData.get(3);
        for (int validIndex : this.nonZeroColumnVector) {
            int value = this.globalIncidenceMatrix.get(row1).get(validIndex) * multFactorT1 + this.globalIncidenceMatrix.get(row2).get(validIndex) * multFactorT2;
            incMatrixNewRow.set(validIndex, value);
        }
        ArrayList<Integer> invCandidate = new ArrayList<Integer>();
        for (int b = 0; b < this.IDENT_MATRIX_ROW_SIZE; ++b) {
            invCandidate.add(this.globalIdentityMatrix.get(row1).get(b) * multFactorT1 + this.globalIdentityMatrix.get(row2).get(b) * multFactorT2);
        }
        this.addOrNot(incMatrixNewRow, invCandidate, row1, row2);
    }

    private void addOrNot(ArrayList<Integer> incMatrixNewRow, ArrayList<Integer> invCandidate, int t1, int t2) {
        boolean fmtResult;
        ArrayList<Integer> candidateSupport = InvariantsTools.getSupport(invCandidate);
        int canonicalNWD = this.checkCanonityNWD(invCandidate, candidateSupport);
        if (canonicalNWD > 1) {
            int matrixNWD;
            ++this.notCanonical;
            this.canonize(invCandidate, canonicalNWD);
            ArrayList<Integer> matrixSupport = InvariantsTools.getSupport(incMatrixNewRow);
            if (!matrixSupport.isEmpty() && (matrixNWD = this.checkCanonityNWD(incMatrixNewRow, matrixSupport)) > 1) {
                this.canonize(incMatrixNewRow, canonicalNWD);
            }
        }
        if (fmtResult = this.fastMinimalityTest(invCandidate, candidateSupport)) {
            ArrayList<Integer> resList = this.supportMinimalityTest(invCandidate, candidateSupport, t1, t2);
            boolean added = false;
            if (resList.get(0) == -1) {
                this.globalIncidenceMatrix.add(incMatrixNewRow);
                this.globalIdentityMatrix.add(invCandidate);
                added = true;
            }
            resList.remove(0);
            if (resList.size() > 1) {
                if (!added) {
                    overlord.log(lang.getText("LOGentry00054critErr"), "error", true);
                }
                while (!resList.isEmpty()) {
                    int remCandidate = resList.get(0);
                    if (!this.removalList.contains(remCandidate)) {
                        this.removalList.add(remCandidate);
                    }
                    resList.remove(0);
                }
            }
        } else {
            ++this.newRejected;
        }
    }

    private ArrayList<Integer> supportMinimalityTest(ArrayList<Integer> invCandidate, ArrayList<Integer> invSupport, int t1, int t2) {
        ArrayList<Integer> removeList = new ArrayList<Integer>();
        removeList.add(-1);
        int matrixSize = this.globalIdentityMatrix.size();
        int successCounter = 0;
        for (int vector = 0; vector < matrixSize; ++vector) {
            if (vector == t1 || vector == t2) continue;
            ArrayList<Integer> refSupport = InvariantsTools.getSupport(this.globalIdentityMatrix.get(vector));
            if (invSupport.equals(refSupport)) {
                ++this.newRejected;
                removeList.set(0, -99);
                return removeList;
            }
            if (InvariantsTools.supportInclusionCheck(invSupport, refSupport)) {
                ++this.newRejected;
                removeList.set(0, -99);
                return removeList;
            }
            int result = this.checkCoverability(this.globalIdentityMatrix.get(vector), refSupport, invCandidate, invSupport);
            if (result == 0 || result == -1) {
                ++this.newRejected;
                removeList.set(0, -99);
                return removeList;
            }
            if (result == 2) {
                ++successCounter;
                ++this.oldReplaced;
                if (removeList.contains(vector)) continue;
                removeList.add(vector);
                continue;
            }
            if (result != 3) continue;
            ++successCounter;
        }
        if (successCounter == matrixSize - 2) {
            return removeList;
        }
        return removeList;
    }

    private int checkCoverability(ArrayList<Integer> refInv, ArrayList<Integer> refSupport, ArrayList<Integer> candidateInv, ArrayList<Integer> candSupport) {
        int sizeCan;
        int sizeRef = refInv.size();
        if (sizeRef != (sizeCan = candidateInv.size())) {
            return 1;
        }
        int CanInRef = 0;
        int CanInRefStrong = 0;
        int RefInCan = 0;
        int RefInCanStrong = 0;
        int refSuppSize = refSupport.size();
        int candSuppSize = candSupport.size();
        ArrayList<Integer> sumOfSupport = new ArrayList<Integer>(refSupport);
        for (int el : candSupport) {
            if (sumOfSupport.contains(el)) continue;
            sumOfSupport.add(el);
        }
        for (int ind : sumOfSupport) {
            int refElement = refInv.get(ind);
            int canElement = candidateInv.get(ind);
            if (refElement > 0 && refElement >= canElement) {
                ++CanInRef;
                if (refElement > canElement) {
                    ++CanInRefStrong;
                }
            }
            if (canElement > 0 && canElement >= refElement) {
                ++RefInCan;
                if (canElement > refElement) {
                    ++RefInCanStrong;
                }
            }
            if (CanInRefStrong <= 0 || RefInCanStrong <= 0) continue;
            return 3;
        }
        if (CanInRef == refSuppSize && RefInCan == candSuppSize && CanInRefStrong == 0 && RefInCanStrong == 0) {
            return 0;
        }
        if (RefInCan == candSuppSize && RefInCanStrong > 0) {
            return 0;
        }
        if (CanInRef == refSuppSize && CanInRefStrong > 0) {
            return 2;
        }
        overlord.log(lang.getText("LOGentry00055critErr"), "error", true);
        return 3;
    }

    private void rewriteIncidenceIntegrityMatrices(ArrayList<ArrayList<Integer>> newRowsMatrix, int columnIndex) {
        int n;
        if (newRowsMatrix.isEmpty()) {
            return;
        }
        int size = newRowsMatrix.size();
        double interval = (double)size / 50.0;
        int steps = 0;
        if (size > 1000) {
            if (this.masterWindow != null) {
                this.masterWindow.accessLogField(this.t_InvMode).append("\n");
            }
            for (ArrayList<Integer> arrayList : newRowsMatrix) {
                this.addNewRowsToMatrix(arrayList);
                if (steps == (int)interval) {
                    steps = 0;
                    if (this.masterWindow == null) continue;
                    this.masterWindow.accessLogField(this.t_InvMode).append("*");
                    continue;
                }
                ++steps;
            }
        } else {
            for (ArrayList<Integer> arrayList : newRowsMatrix) {
                this.addNewRowsToMatrix(arrayList);
            }
        }
        int removedSoFar = 0;
        Collections.sort(this.removalList);
        for (int el : this.removalList) {
            int index = el - removedSoFar;
            this.globalIncidenceMatrix.remove(index);
            this.globalIdentityMatrix.remove(index);
            ++removedSoFar;
        }
        this.removalList.clear();
        int n2 = this.globalIncidenceMatrix.size();
        for (int row = 0; row < n; ++row) {
            if (this.globalIncidenceMatrix.get(row).get(columnIndex) == 0) continue;
            this.globalIncidenceMatrix.remove(row);
            this.globalIdentityMatrix.remove(row);
            --row;
            --n;
        }
    }

    private boolean fastMinimalityTest(ArrayList<Integer> invCandidate, ArrayList<Integer> supports) {
        int supportSize = supports.size();
        int nonZeroColumn = 0;
        int CMrowSize = this.CMatrix.get(0).size();
        block0: for (int column = 0; column < CMrowSize; ++column) {
            for (int s : supports) {
                if (this.CMatrix.get(s).get(column) == 0) continue;
                ++nonZeroColumn;
                continue block0;
            }
        }
        return supportSize <= nonZeroColumn + 1;
    }

    private void canonize(ArrayList<Integer> invCandidate, int nwd) {
        invCandidate.replaceAll(integer -> integer / nwd);
    }

    private int checkCanonityNWD(ArrayList<Integer> invCandidate, ArrayList<Integer> supports) {
        int result = this.bezwzgledna(invCandidate.get(supports.get(0)));
        for (int number : supports) {
            int value = this.bezwzgledna(invCandidate.get(number));
            if ((result = InvariantsCalculator.nwd(result, value)) != 1) continue;
            return 1;
        }
        return result;
    }

    public static int nwd(int x, int y) {
        while (y != 0) {
            int temp = y;
            y = x % y;
            x = temp;
        }
        return x;
    }

    public int bezwzgledna(int i) {
        if (i < 0) {
            return -i;
        }
        return i;
    }

    public ArrayList<ArrayList<Integer>> getInvariants(boolean tinv) {
        if (tinv) {
            return this.t_invariantsList;
        }
        return this.p_invariantsList;
    }

    public void setInvariants(ArrayList<ArrayList<Integer>> invMatrix) {
        if (this.t_InvMode) {
            this.t_invariantsList = invMatrix;
        } else {
            this.p_invariantsList = invMatrix;
        }
    }

    public ArrayList<ArrayList<Integer>> getDoubleArcs() {
        this.createTPIncidenceAndIdentityMatrix(true, true);
        return this.doubleArcs;
    }

    public void setShowInvDiff(boolean value) {
        this.showInvSetsDifference = value;
    }

    private void logInternal(String msg, boolean date) {
        String timeStamp = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(Calendar.getInstance().getTime());
        if (this.masterWindow != null) {
            JTextArea jta = this.masterWindow.accessLogField(this.t_InvMode);
            if (!date) {
                jta.append(msg);
                jta.setCaretPosition(jta.getDocument().getLength());
            } else {
                jta.append("[" + timeStamp + "] " + msg);
                jta.setCaretPosition(jta.getDocument().getLength());
            }
        }
    }
}

