/*
 * Decompiled with CFR 0.152.
 */
package holmes.analyse;

import holmes.analyse.GraphletsCalculator;
import holmes.darkgui.GUIManager;
import holmes.darkgui.LanguageManager;
import holmes.petrinet.data.PetriNet;
import holmes.windows.decompositions.HolmesComparisonModule;
import java.awt.Color;
import java.awt.Paint;
import java.text.DecimalFormat;
import java.util.Arrays;
import javax.swing.table.DefaultTableModel;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.SymbolAxis;
import org.jfree.chart.plot.DefaultDrawingSupplier;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYBarPainter;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.data.xy.XYSeries;

public class GRDFcalculator
implements Runnable {
    private static final GUIManager overlord = GUIManager.getDefaultGUIManager();
    private static final LanguageManager lang = GUIManager.getLanguageManager();
    private HolmesComparisonModule masterWindow = GUIManager.getDefaultGUIManager().accessComparisonWindow();

    @Override
    public void run() {
        int chiisenGraohletSize = this.masterWindow.getChoosenGraohletSize(this.masterWindow.graphletSize.getSelectedIndex());
        this.masterWindow.infoPaneDRGF.append(lang.getText("GRDF_entry001"));
        this.masterWindow.infoPaneDRGF.append(lang.getText("GRDF_entry002"));
        long[] firstSingleDRGF = this.calcDRGF(GUIManager.getDefaultGUIManager().getWorkspace().getProject());
        this.masterWindow.infoPaneDRGF.append(lang.getText("GRDF_entry003"));
        long[] secondSingleDRGF = this.calcDRGF(this.masterWindow.secondNet);
        long firstSum = Arrays.stream(firstSingleDRGF).sum();
        long secondSum = Arrays.stream(secondSingleDRGF).sum();
        long[] distanceDRGF = new long[chiisenGraohletSize];
        double result = 0.0;
        for (int i = 0; i < chiisenGraohletSize; ++i) {
            distanceDRGF[i] = Math.abs(firstSingleDRGF[i] - secondSingleDRGF[i]);
            double f1 = -Math.log((double)firstSingleDRGF[i] / (double)firstSum);
            double f2 = -Math.log((double)secondSingleDRGF[i] / (double)secondSum);
            if (firstSingleDRGF[i] == 0L) {
                f1 = 0.0;
            }
            if (secondSingleDRGF[i] == 0L) {
                f2 = 0.0;
            }
            result += Math.abs(f1 - f2);
        }
        int nodeN = this.masterWindow.graphletSize.getSelectedIndex() + 1;
        this.masterWindow.infoPaneDRGF.append("\nGRDF (" + nodeN + "-node) : " + result);
        XYSeries series1 = new XYSeries((Comparable)((Object)"Number of graphlets of net 1"));
        XYSeries series2 = new XYSeries((Comparable)((Object)"Number of graphlets of net 2"));
        this.masterWindow.dataDRGF = new Object[chiisenGraohletSize][4];
        Object[] colNames = new String[]{"Graphlets", "First net", "Second net", "Distance"};
        for (int i = 0; i < chiisenGraohletSize; ++i) {
            this.masterWindow.dataDRGF[i][0] = "G " + i;
            this.masterWindow.dataDRGF[i][1] = firstSingleDRGF[i];
            this.masterWindow.dataDRGF[i][2] = secondSingleDRGF[i];
            this.masterWindow.dataDRGF[i][3] = distanceDRGF[i];
            series1.add((double)i, firstSingleDRGF[i]);
            series2.add((double)i, secondSingleDRGF[i]);
        }
        DefaultTableModel model = new DefaultTableModel(this.masterWindow.dataDRGF, colNames);
        this.masterWindow.drgfTable.setModel(model);
        this.masterWindow.grdfSeriesDataSet.removeAllSeries();
        this.masterWindow.grdfSeriesDataSet.addSeries(series1);
        this.masterWindow.grdfSeriesDataSet.addSeries(series2);
        XYPlot xyplot = (XYPlot)this.masterWindow.grdfChart.getPlot();
        xyplot.setForegroundAlpha(0.85f);
        XYBarRenderer xybarrenderer = (XYBarRenderer)xyplot.getRenderer();
        xybarrenderer.setBarPainter(new StandardXYBarPainter());
        Paint[] paintArray = new Paint[]{new Color(-2130771968, true), new Color(-2147483393, true)};
        String[] axisX = new String[151];
        for (int i = 0; i < 151; ++i) {
            axisX[i] = String.valueOf(i + 1);
        }
        SymbolAxis rangeAxis = new SymbolAxis("Graphlets", axisX);
        rangeAxis.setVerticalTickLabels(true);
        xyplot.setDomainAxis(rangeAxis);
        NumberAxis yAxis = (NumberAxis)xyplot.getRangeAxis();
        DecimalFormat format = new DecimalFormat("0");
        yAxis.setNumberFormatOverride(format);
        double max = series1.getMaxY();
        if (max < series2.getMaxY()) {
            max = series2.getMaxY();
        }
        int tick = (int)max / 10;
        yAxis.setTickUnit(new NumberTickUnit(tick));
        xyplot.setDrawingSupplier(new DefaultDrawingSupplier(paintArray, DefaultDrawingSupplier.DEFAULT_FILL_PAINT_SEQUENCE, DefaultDrawingSupplier.DEFAULT_OUTLINE_PAINT_SEQUENCE, DefaultDrawingSupplier.DEFAULT_STROKE_SEQUENCE, DefaultDrawingSupplier.DEFAULT_OUTLINE_STROKE_SEQUENCE, DefaultDrawingSupplier.DEFAULT_SHAPE_SEQUENCE));
        this.masterWindow.grdfChartPanel.setVisible(true);
        this.masterWindow.drgfTable.revalidate();
        this.masterWindow.infoPaneDRGF.append(lang.getText("GRDF_entry004"));
    }

    private long[] calcDRGF(PetriNet project) {
        GraphletsCalculator.cleanAll();
        GraphletsCalculator.generateGraphlets();
        GraphletsCalculator.getFoundServerGraphlets(project, this.masterWindow.infoPaneDRGF);
        long[] singleDRGF = new long[GraphletsCalculator.graphetsList.size()];
        for (int k = 0; k < GraphletsCalculator.graphetsList.size(); ++k) {
            long val;
            int finalI = k;
            singleDRGF[k] = val = GraphletsCalculator.uniqGraphlets.stream().filter(x -> x.getGraphletID() == finalI).count();
        }
        return singleDRGF;
    }
}

