/*
 * Decompiled with CFR 0.152.
 */
package holmes.adam.mct;

import holmes.adam.mct.MCTPetriNet;
import holmes.adam.mct.MCTSet;
import holmes.adam.mct.MCTTransition;
import holmes.adam.mct.TInvariant;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class Utils {
    public static SortedSet<MCTSet> buildMCT(Set<TInvariant> tiSet, Map<String, String> renameMap) {
        Set<TInvariant> supportSet;
        HashSet<MCTTransition> all = new HashSet<MCTTransition>();
        SortedSet<MCTSet> result = new TreeSet<MCTSet>();
        for (TInvariant tInvariant : tiSet) {
            all.addAll(tInvariant.getTransitionMap().keySet());
        }
        TreeMap contained = new TreeMap();
        for (MCTTransition t : all) {
            supportSet = new HashSet();
            contained.put(t, supportSet);
            for (TInvariant tInvariant : tiSet) {
                if (!tInvariant.getTransitionMap().containsKey(t)) continue;
                supportSet.add(tInvariant);
            }
        }
        while (contained.size() > 0) {
            MCTSet mCTSet = new MCTSet();
            MCTTransition transition = (MCTTransition)contained.firstKey();
            mCTSet.getTransitionSet().add(transition);
            supportSet = (Set)contained.get(transition);
            contained.remove(transition);
            for (Map.Entry entry : contained.entrySet()) {
                Set supportSeti = (Set)entry.getValue();
                if (!supportSet.equals(supportSeti)) continue;
                mCTSet.getTransitionSet().add((MCTTransition)entry.getKey());
            }
            for (MCTTransition mCTTransition : mCTSet.getTransitionSet()) {
                contained.remove(mCTTransition);
            }
            result.add(mCTSet);
        }
        if (renameMap != null) {
            MCTSet.renameMctSets(result, renameMap);
        }
        result = MCTSet.rebuildMctOrder(result, MCTSet.COMP_BY_SIZE_DESCENDING);
        for (MCTSet mct : result) {
            for (MCTTransition t : mct.getTransitionSet()) {
                t.setMCTSet(mct);
            }
        }
        return result;
    }

    public static SortedSet<TInvariant> readTInvariants(InputStream is, boolean firstColumnTID, MCTPetriNet petriNet) throws IOException {
        String line;
        TreeSet<TInvariant> result = new TreeSet<TInvariant>();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        HashMap<String, MCTTransition> transitions = new HashMap<String, MCTTransition>();
        int minWidth = firstColumnTID ? 2 : 1;
        int rcount = 0;
        while ((line = br.readLine()) != null) {
            String[] items = line.split("[, \\t;]+");
            if (items.length < minWidth) continue;
            TInvariant tInv = new TInvariant(firstColumnTID ? items[0] : String.valueOf(++rcount), petriNet);
            for (int i = minWidth - 1; i < items.length; ++i) {
                int colon = items[i].indexOf(58);
                int count = 1;
                String tId = colon < 0 ? items[i] : items[i].substring(0, colon);
                String tCount = colon < 0 ? "1" : items[i].substring(colon + 1);
                try {
                    count = Integer.parseInt(tCount);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                MCTTransition t = (MCTTransition)transitions.get(tId);
                if (t == null) {
                    t = new MCTTransition(tId, petriNet);
                    transitions.put(tId, t);
                }
                tInv.getTransitionMap().put(t, count);
            }
            result.add(tInv);
        }
        is.close();
        return result;
    }

    public static SortedSet<TInvariant> readFromCSV(InputStream is, MCTPetriNet petriNet) throws IOException {
        TreeSet<TInvariant> result = new TreeSet<TInvariant>();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        String line = br.readLine();
        String[] transitionIDs = line.split("[, \\t;]+");
        int vectorLength = transitionIDs.length;
        for (int i = 1; i < transitionIDs.length; ++i) {
            petriNet.getOrCreateTransition(transitionIDs[i]);
        }
        while ((line = br.readLine()) != null) {
            String[] items = line.split("[, \\t;]+");
            if (items.length < vectorLength) continue;
            TInvariant tInv = new TInvariant(items[0], petriNet);
            for (int i = 1; i < vectorLength; ++i) {
                int count = 0;
                String tCount = items[i];
                try {
                    count = Integer.parseInt(tCount);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                MCTTransition t = petriNet.getOrCreateTransition(transitionIDs[i]);
                if (count <= 0) continue;
                tInv.getTransitionMap().put(t, count);
            }
            result.add(tInv);
        }
        is.close();
        return result;
    }

    public static SortedSet<TInvariant> readFromCharlie(InputStream is, MCTPetriNet petriNet) throws IOException {
        String line;
        TreeSet<TInvariant> result = new TreeSet<TInvariant>();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        br.readLine();
        TInvariant tInv = null;
        LineReader lr = new LineReader(br);
        while ((line = lr.readLine()) != null) {
            String[] items = line.split("\\|");
            if (items.length != 2) continue;
            for (int i = 0; i < items.length; ++i) {
                items[i] = items[i].trim();
            }
            if (items[0].length() > 0) {
                if (Utils.validateTInvariant(tInv)) {
                    result.add(tInv);
                }
                tInv = new TInvariant(items[0], petriNet);
            }
            if (tInv == null) continue;
            int colon = items[1].indexOf(58);
            int count = 1;
            String tId = (colon < 0 ? items[1] : items[1].substring(0, colon)).trim();
            tId = tId.replaceFirst("", "");
            String tCount = (colon < 0 ? "1" : items[1].substring(colon + 1)).trim().replaceAll(",", "");
            try {
                count = Integer.parseInt(tCount);
            }
            catch (Exception exception) {
                // empty catch block
            }
            MCTTransition t = petriNet.getOrCreateTransition(tId);
            tInv.getTransitionMap().put(t, count);
        }
        if (Utils.validateTInvariant(tInv)) {
            result.add(tInv);
        }
        is.close();
        return result;
    }

    private static boolean validateTInvariant(TInvariant tInv) {
        if (tInv == null) {
            return false;
        }
        for (MCTTransition t : tInv.getTransitionMap().keySet()) {
            if ((Integer)tInv.getTransitionMap().get(t) >= 0) continue;
            return false;
        }
        return true;
    }

    public static SortedSet<TInvariantTrasitionDescriptor> getInvariantsWith(SortedSet<TInvariant> tinvs, String[] tids, boolean containing) {
        TreeSet<TInvariantTrasitionDescriptor> result = new TreeSet<TInvariantTrasitionDescriptor>();
        for (TInvariant tinv : tinvs) {
            TInvariantTrasitionDescriptor titd = new TInvariantTrasitionDescriptor();
            titd.tinv = tinv;
            for (String id : tids) {
                MCTTransition t = tinv.petriNet.getTransition(id);
                if (!tinv.contains(t)) continue;
                titd.transitions.add(t);
            }
            if ((titd.transitions.size() <= 0 || !containing) && (titd.transitions.size() != 0 || containing)) continue;
            result.add(titd);
        }
        return result;
    }

    public static String invariantsToString(SortedSet<TInvariant> tinv) {
        StringBuilder sb = new StringBuilder();
        for (TInvariant ti : tinv) {
            sb.append(ti.toString());
            sb.append("\r\n");
        }
        return sb.toString();
    }

    public static String invariantsToCsvVectors(SortedSet<TInvariant> tinv, boolean boolValues, boolean includeId, boolean latexMode) {
        return Utils.invariantsWithMCT(tinv, null, includeId, true, boolValues, latexMode, null);
    }

    public static String invariantsWithMCT(SortedSet<TInvariant> tinvs, SortedSet<MCTSet> mctSets, boolean includeId, boolean includeVectors, boolean boolValues, boolean latexMode, List<SortedSet<String>> clusters) {
        StringBuilder sb = new StringBuilder();
        String separator = latexMode ? "\t\t&\t\t" : ";";
        HashMap<String, Integer> firstInCluster = new HashMap<String, Integer>();
        HashMap<String, Integer> lastInCluster = new HashMap<String, Integer>();
        if (clusters != null) {
            int ccnt = 1;
            for (SortedSet<String> cluster : clusters) {
                firstInCluster.put(cluster.first(), ccnt);
                lastInCluster.put(cluster.last(), ccnt);
                ++ccnt;
            }
        }
        for (TInvariant tinv : tinvs) {
            if (latexMode && mctSets != null) {
                if (firstInCluster.containsKey(tinv.id)) {
                    sb.append("$c_{").append(firstInCluster.get(tinv.id)).append("}$");
                } else {
                    sb.append("\t");
                }
                sb.append("\t&\t\t");
            }
            if (includeId) {
                sb.append(latexMode ? "$x_{" : "");
                sb.append(tinv.id);
                sb.append(latexMode ? "}$" : ".");
                sb.append(separator);
            }
            if (includeVectors) {
                sb.append(tinv.toVector(boolValues));
                if (mctSets != null) {
                    sb.append(separator);
                }
            }
            if (mctSets != null) {
                sb.append(tinv.toMCTString(mctSets, latexMode));
                if (lastInCluster.containsKey(tinv.id)) {
                    sb.append("\t\\\\ \\cline{1-4} \r\n\r\n");
                } else {
                    sb.append("\t\\\\ \\cline{2-4}");
                }
            }
            sb.append("\r\n");
        }
        return sb.toString();
    }

    public static Map<String, String> readMCTNameMap(String file) throws FileNotFoundException, IOException {
        Properties props = new Properties();
        props.load(new InputStreamReader(new FileInputStream(file)));
        HashMap<String, String> renameMap = new HashMap<String, String>();
        for (Object key : props.keySet()) {
            renameMap.put(String.valueOf(key), (String)props.get(key));
        }
        return renameMap;
    }

    public static List<SortedMap<MCTTransition, Integer>> computeTransitionCoverance(List<SortedSet<String>> clusters, SortedSet<TInvariant> tInvariants) {
        ArrayList<SortedMap<MCTTransition, Integer>> result = new ArrayList<SortedMap<MCTTransition, Integer>>(clusters.size());
        MCTPetriNet pn = tInvariants.first().petriNet;
        HashMap<String, TInvariant> tInvMap = new HashMap<String, TInvariant>();
        for (TInvariant tInvariant : tInvariants) {
            tInvMap.put(tInvariant.id, tInvariant);
        }
        for (SortedSet sortedSet : clusters) {
            TreeMap<MCTTransition, Integer> transitionCountInCluster = new TreeMap<MCTTransition, Integer>();
            for (MCTTransition t : pn.getTransitions()) {
                transitionCountInCluster.put(t, 0);
            }
            for (String tInvariantId : sortedSet) {
                TInvariant tInvariant = (TInvariant)tInvMap.get(tInvariantId);
                if (tInvariant == null) continue;
                for (MCTTransition t : tInvariant.getTransitionMap().keySet()) {
                    transitionCountInCluster.put(t, (Integer)transitionCountInCluster.get(t) + 1);
                }
            }
            result.add(transitionCountInCluster);
        }
        return result;
    }

    static class LineReader {
        private String[] lines;
        private int index;
        private final BufferedReader br;

        public LineReader(BufferedReader br) {
            this.br = br;
        }

        public String readLine() throws IOException {
            if (this.lines == null) {
                String brLine = this.br.readLine();
                if (brLine == null) {
                    return null;
                }
                if ((brLine = brLine.trim()).indexOf(44) == brLine.length() - 1) {
                    return brLine;
                }
                this.lines = brLine.replaceAll(",", ",\n").split("\n[\\t ]*");
                this.index = 0;
            }
            String result = this.lines[this.index++];
            if (this.index == this.lines.length) {
                this.lines = null;
            }
            return result;
        }
    }

    public static class TInvariantTrasitionDescriptor
    implements Comparable<TInvariantTrasitionDescriptor> {
        public TInvariant tinv;
        public List<MCTTransition> transitions = new ArrayList<MCTTransition>();

        @Override
        public int compareTo(TInvariantTrasitionDescriptor o) {
            return this.tinv.compareTo(o.tinv);
        }
    }

    public static class HybridStringNumberComparator
    implements Comparator<String> {
        @Override
        public int compare(String o1, String o2) {
            try {
                Integer n1 = Integer.parseInt(o1);
                Integer n2 = Integer.parseInt(o2);
                return n1.compareTo(n2);
            }
            catch (NumberFormatException nfe) {
                return o1.compareTo(o2);
            }
        }
    }
}

