/*
 * Decompiled with CFR 0.152.
 */
package holmes.adam.mct;

import holmes.adam.mct.MCTPetriNet;
import holmes.adam.mct.MCTSet;
import holmes.adam.mct.MCTTransition;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;

public class TInvariant
implements Comparable<TInvariant> {
    public final String id;
    public final MCTPetriNet petriNet;
    private SortedMap<MCTTransition, Integer> map = new TreeMap<MCTTransition, Integer>();

    public TInvariant(String id, MCTPetriNet petriNet) {
        this.id = id;
        this.petriNet = petriNet;
    }

    public SortedMap<MCTTransition, Integer> getTransitionMap() {
        return this.map;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.id);
        sb.append("=");
        for (MCTTransition t : this.map.keySet()) {
            Integer count = (Integer)this.map.get(t);
            sb.append(t.id);
            if (count > 1) {
                sb.append(":");
                sb.append(count);
            }
            sb.append(",");
        }
        return sb.toString();
    }

    public String toVector(boolean boolValues) {
        SortedSet<MCTTransition> transitions = this.petriNet.getTransitions();
        StringBuilder sb = new StringBuilder();
        int c = 0;
        for (MCTTransition transition : transitions) {
            Integer cnt = (Integer)this.map.get(transition);
            if (cnt == null) {
                cnt = 0;
            } else if (boolValues) {
                cnt = 1;
            }
            sb.append(cnt);
            if (++c >= transitions.size()) continue;
            sb.append(";");
        }
        return sb.toString();
    }

    @Override
    public int compareTo(TInvariant o) {
        try {
            int thisid = Integer.parseInt(this.id);
            int cid = Integer.parseInt(o.id);
            return thisid - cid;
        }
        catch (Exception e) {
            return this.id.compareTo(o.id);
        }
    }

    public boolean contains(MCTTransition tr) {
        return this.map.get(tr) != null;
    }

    public String toMCTString(SortedSet<MCTSet> mctSets, boolean latexMode) {
        StringBuilder sb = new StringBuilder();
        String separator = latexMode ? "\t\t&\t\t" : ";";
        sb.append(latexMode ? "" : "[");
        for (MCTSet mct : mctSets) {
            if (!this.contains(mct.getTransitionSet().first())) continue;
            sb.append(mct.getPrintName(latexMode));
            sb.append(", ");
        }
        if (sb.length() > 1 && sb.charAt(sb.length() - 2) == ',') {
            sb.deleteCharAt(sb.length() - 2);
        }
        sb.append(latexMode ? "" : "]");
        sb.append(separator);
        for (MCTTransition t : this.map.keySet()) {
            boolean inMCT = false;
            for (MCTSet mct : mctSets) {
                if (!mct.getTransitionSet().contains(t)) continue;
                inMCT = true;
                break;
            }
            if (inMCT) continue;
            sb.append(t.getNodeShort(latexMode));
            sb.append(", ");
        }
        return sb.toString().replaceFirst(", $", "");
    }
}

