/*
 * Decompiled with CFR 0.152.
 */
package rcaller;

import graphics.GraphicsTheme;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import rcaller.EventHandler;
import rcaller.Globals;
import rcaller.RCode;
import rcaller.ROutputParser;
import rcaller.RStreamHandler;
import rcaller.TempFileService;
import rcaller.exception.ExecutionException;
import rcaller.exception.ParseException;
import rcaller.exception.RExecutableNotFoundException;
import rcaller.exception.RscriptExecutableNotFoundException;

public class RCaller {
    protected String RscriptExecutable;
    protected String RExecutable;
    protected RCode rcode = new RCode();
    protected ROutputParser parser = new ROutputParser();
    protected Process process;
    protected RStreamHandler rOutput = null;
    protected RStreamHandler rError = null;
    protected OutputStream rInput = null;
    protected FailurePolicy failPolicy = FailurePolicy.RETRY_5;
    protected int retries = 0;
    protected long maxWaitTime = Long.MAX_VALUE;
    protected TempFileService tempFileService = null;

    public RCaller() {
        this.rOutput = new RStreamHandler(null, "Output");
        this.rError = new RStreamHandler(null, "Error");
        this.tempFileService = new TempFileService();
        this.cleanRCode();
    }

    public long getMaxWaitTime() {
        return this.maxWaitTime;
    }

    public void setMaxWaitTime(long maxWaitTime) {
        this.maxWaitTime = maxWaitTime;
    }

    public boolean stopStreamConsumers() {
        this.rOutput.setCloseSignal(true);
        this.rError.setCloseSignal(true);
        return this.rOutput.isAlive() && this.rError.isAlive();
    }

    public void setRExecutable(String RExecutable) {
        File file = new File(RExecutable);
        if (!file.exists()) {
            throw new RExecutableNotFoundException("R Executable " + RExecutable + " not found");
        }
        this.RExecutable = RExecutable;
    }

    public String getCranRepos() {
        return Globals.cranRepos;
    }

    public ROutputParser getParser() {
        return this.parser;
    }

    public RCode getRCode() {
        return this.rcode;
    }

    public void setRCode(RCode rcode) {
        this.rcode = rcode;
    }

    public void setRscriptExecutable(String RscriptExecutable) {
        File file = new File(RscriptExecutable);
        if (!file.exists()) {
            throw new RscriptExecutableNotFoundException("R executable " + RscriptExecutable + " not found");
        }
        this.RscriptExecutable = RscriptExecutable;
    }

    public void setGraphicsTheme(GraphicsTheme theme) {
        Globals.theme = theme;
    }

    public final void cleanRCode() {
        this.rcode.clear();
    }

    public void deleteTempFiles() {
        this.tempFileService.deleteRCallerTempFiles();
        this.rcode.deleteTempFiles();
    }

    private File createRSourceFile() throws ExecutionException {
        File f = null;
        BufferedWriter writer = null;
        try {
            f = this.tempFileService.createTempFile("rcaller", "");
        }
        catch (IOException e) {
            throw new ExecutionException("Can not open a temporary file for storing the R Code: " + e.toString());
        }
        try {
            writer = new BufferedWriter(new FileWriter(f));
            writer.write(this.rcode.toString());
            writer.flush();
        }
        catch (IOException e) {
            throw new ExecutionException("Can not write to temporary file for storing the R Code: " + e.toString());
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException einner) {}
        }
        return f;
    }

    public void runOnly() throws ExecutionException {
        if (this.RscriptExecutable == null) {
            throw new ExecutionException("RscriptExecutable is not defined. Please set this variable to full path of Rscript executable binary file.");
        }
        this.rcode.getCode().append("q(").append("\"").append("yes").append("\"").append(")\n");
        File rSourceFile = this.createRSourceFile();
        try {
            this.process = Runtime.getRuntime().exec(this.RscriptExecutable + " " + rSourceFile.toString());
            this.rOutput.setStream(this.process.getInputStream());
            this.rError.setStream(this.process.getErrorStream());
            this.rOutput.start();
            this.rError.start();
            this.process.waitFor();
        }
        catch (Exception e) {
            throw new ExecutionException("Can not run " + this.RscriptExecutable + ". Reason: " + e.toString());
        }
        this.stopStreamConsumers();
    }

    public void runAndReturnResultOnline(String var) throws ExecutionException {
        this.retries = 0;
        boolean done = false;
        do {
            if (this.getRetries() > 0) {
                System.out.println("Retrying online R execution");
            }
            String commandline = null;
            File outputFile = null;
            if (this.RExecutable == null && this.handleRFailure("RExecutable is not defined.Please set this variable to full path of R executable binary file.")) continue;
            try {
                outputFile = this.tempFileService.createTempFile("Routput", "");
            }
            catch (IOException e) {
                if (this.handleRFailure("Can not create a tempopary file for storing the R results: " + e.toString())) continue;
            }
            this.rcode.getCode().append("cat(makexml(obj=").append(var).append(", name=\"").append(var).append("\"), file=\"").append(outputFile.toString().replace("\\", "/")).append("\")\n");
            if (this.rInput == null || this.rOutput == null || this.rError == null || this.process == null) {
                try {
                    commandline = this.RExecutable + " --vanilla";
                    this.process = Runtime.getRuntime().exec(commandline);
                    this.rInput = this.process.getOutputStream();
                    this.rOutput.setStream(this.process.getInputStream());
                    this.rOutput.start();
                    this.rError.setStream(this.process.getErrorStream());
                    this.rError.start();
                }
                catch (Exception e) {
                    if (this.handleRFailure("Can not run " + this.RExecutable + ". Reason: " + e.toString())) continue;
                }
            }
            try {
                this.rInput.write(this.rcode.toString().getBytes());
                this.rInput.flush();
            }
            catch (IOException e) {
                if (this.handleRFailure("Can not send the source code to R file due to: " + e.toString())) continue;
            }
            long slept = 0L;
            boolean processKilled = false;
            try {
                while (!processKilled && outputFile.length() < 1L) {
                    Thread.sleep(1L);
                    if (++slept <= this.maxWaitTime) continue;
                    this.process.destroy();
                    this.stopStreamConsumers();
                    processKilled = true;
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.parser.setXMLFile(outputFile);
            try {
                this.parser.parse();
            }
            catch (ParseException e) {
                if (this.handleRFailure("Can not handle R results due to : " + e.toString())) continue;
            }
            done = true;
        } while (!done);
    }

    public void StopRCallerOnline() {
        if (this.process != null) {
            try {
                this.process.getOutputStream().write("q(\"no\")\n".getBytes());
                this.process.getOutputStream().flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.process.destroy();
        }
    }

    private boolean handleRFailure(String reason) throws ExecutionException {
        int maxFailures = 0;
        if (this.failPolicy == FailurePolicy.CONTINUE) {
            maxFailures = -1;
        }
        if (this.failPolicy == FailurePolicy.RETRY_1) {
            maxFailures = 1;
        }
        if (this.failPolicy == FailurePolicy.RETRY_5) {
            maxFailures = 5;
        }
        if (this.failPolicy == FailurePolicy.RETRY_10) {
            maxFailures = 10;
        }
        if (this.failPolicy == FailurePolicy.RETRY_FOREVER) {
            maxFailures = Integer.MAX_VALUE;
        }
        if (this.getRetries() < maxFailures) {
            ++this.retries;
            return true;
        }
        throw new ExecutionException(reason + " Maximum number of retries exceeded.");
    }

    public void runAndReturnResult(String var) throws ExecutionException {
        File outputFile;
        String commandline = null;
        Object result = null;
        if (this.RscriptExecutable == null) {
            throw new ExecutionException("RscriptExecutable is not defined. Please set this variable to full path of Rscript executable binary file.");
        }
        try {
            outputFile = this.tempFileService.createTempFile("Routput", "");
        }
        catch (Exception e) {
            throw new ExecutionException("Can not create a tempopary file for storing the R results: " + e.toString());
        }
        this.rcode.getCode().append("cat(makexml(obj=").append(var).append(", name=\"").append(var).append("\"), file=\"").append(outputFile.toString().replace("\\", "/")).append("\")\n");
        File rSourceFile = this.createRSourceFile();
        try {
            commandline = this.RscriptExecutable + " " + rSourceFile.toString();
            Process process = Runtime.getRuntime().exec(commandline);
            this.rOutput.setStream(process.getInputStream());
            this.rError.setStream(process.getErrorStream());
            this.rOutput.start();
            this.rError.start();
            process.waitFor();
        }
        catch (Exception e) {
            throw new ExecutionException("Can not run " + this.RscriptExecutable + ". Reason: " + e.toString());
        }
        this.parser.setXMLFile(outputFile);
        try {
            this.parser.parse();
        }
        catch (Exception e) {
            System.out.println(this.rcode.toString());
            throw new ParseException("Can not handle R results due to : " + e.toString());
        }
        this.stopStreamConsumers();
    }

    public void redirectROutputToConsole() {
        this.redirectROutputToStream(System.out);
    }

    public void redirectROutputToFile(String name, boolean appendToExisting) throws FileNotFoundException {
        FileOutputStream fstream = new FileOutputStream(name, appendToExisting);
        this.redirectROutputToStream(fstream);
    }

    public void redirectROutputToStream(final OutputStream o) {
        EventHandler eh = new EventHandler(o){

            public void messageReceived(String senderName, String msg) {
                try {
                    o.write(senderName.getBytes());
                    o.write(":".getBytes());
                    o.write(msg.getBytes());
                    o.write("\n".getBytes());
                    o.flush();
                }
                catch (IOException ex) {
                    Logger.getLogger(RCaller.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        };
        this.rOutput.addEventHandler(eh);
        this.rError.addEventHandler(eh);
    }

    public void setFailurePolicy(FailurePolicy f) {
        this.failPolicy = f;
    }

    public int getRetries() {
        return this.retries;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FailurePolicy {
        RETRY_1,
        RETRY_5,
        RETRY_10,
        RETRY_FOREVER,
        CONTINUE;

    }
}

