/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.transform;

import org.simpleframework.xml.transform.Transform;

class ClassTransform
implements Transform<Class> {
    ClassTransform() {
    }

    @Override
    public Class read(String target) throws Exception {
        ClassLoader loader = ClassTransform.getClassLoader();
        if (loader == null) {
            loader = this.getCallerClassLoader();
        }
        return loader.loadClass(target);
    }

    @Override
    public String write(Class target) throws Exception {
        return target.getName();
    }

    private ClassLoader getCallerClassLoader() {
        return this.getClass().getClassLoader();
    }

    private static ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }
}

