/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.utils.filters;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.jvnet.substance.api.SubstanceColorScheme;
import org.jvnet.substance.utils.HashMapKey;
import org.jvnet.substance.utils.LazyResettableHashMap;
import org.jvnet.substance.utils.SubstanceColorUtilities;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.filters.AbstractFilter;

public class ColorSchemeFilter
extends AbstractFilter {
    private int[] interpolated;
    public static final int MAPSTEPS = 512;
    protected static LazyResettableHashMap<ColorSchemeFilter> filters = new LazyResettableHashMap("ColorSchemeFilter");

    public static ColorSchemeFilter getColorSchemeFilter(SubstanceColorScheme scheme) {
        HashMapKey key = SubstanceCoreUtilities.getHashKey(scheme.getDisplayName());
        if (filters.containsKey(key)) {
            return filters.get(key);
        }
        ColorSchemeFilter result = new ColorSchemeFilter(scheme);
        filters.put(key, result);
        return result;
    }

    private ColorSchemeFilter(SubstanceColorScheme scheme) {
        if (scheme == null) {
            throw new IllegalArgumentException("mixColor cannot be null");
        }
        TreeMap<Integer, Color> schemeColorMapping = new TreeMap<Integer, Color>();
        schemeColorMapping.put(SubstanceColorUtilities.getColorBrightness(scheme.getUltraLightColor().getRGB()), scheme.getUltraLightColor());
        schemeColorMapping.put(SubstanceColorUtilities.getColorBrightness(scheme.getExtraLightColor().getRGB()), scheme.getExtraLightColor());
        schemeColorMapping.put(SubstanceColorUtilities.getColorBrightness(scheme.getLightColor().getRGB()), scheme.getLightColor());
        schemeColorMapping.put(SubstanceColorUtilities.getColorBrightness(scheme.getMidColor().getRGB()), scheme.getMidColor());
        schemeColorMapping.put(SubstanceColorUtilities.getColorBrightness(scheme.getDarkColor().getRGB()), scheme.getDarkColor());
        schemeColorMapping.put(SubstanceColorUtilities.getColorBrightness(scheme.getUltraDarkColor().getRGB()), scheme.getUltraDarkColor());
        ArrayList schemeBrightness = new ArrayList();
        schemeBrightness.addAll(schemeColorMapping.keySet());
        Collections.sort(schemeBrightness);
        int lowestSchemeBrightness = (Integer)schemeBrightness.get(0);
        int highestSchemeBrightness = (Integer)schemeBrightness.get(schemeBrightness.size() - 1);
        TreeMap stretchedColorMapping = new TreeMap();
        for (Map.Entry entry : schemeColorMapping.entrySet()) {
            int brightness = (Integer)entry.getKey();
            int stretched = 255 - 255 * (highestSchemeBrightness - brightness) / (highestSchemeBrightness - lowestSchemeBrightness);
            stretchedColorMapping.put(stretched, entry.getValue());
        }
        schemeBrightness = new ArrayList();
        schemeBrightness.addAll(stretchedColorMapping.keySet());
        Collections.sort(schemeBrightness);
        this.interpolated = new int[512];
        block1: for (int i = 0; i < 512; ++i) {
            int brightness = (int)(256.0 * (double)i / 512.0);
            if (schemeBrightness.contains(brightness)) {
                this.interpolated[i] = ((Color)stretchedColorMapping.get(brightness)).getRGB();
                continue;
            }
            int currIndex = 0;
            while (true) {
                int currStopValue = (Integer)schemeBrightness.get(currIndex);
                int nextStopValue = (Integer)schemeBrightness.get(currIndex + 1);
                if (brightness > currStopValue && brightness < nextStopValue) {
                    Color currStopColor = (Color)stretchedColorMapping.get(currStopValue);
                    Color nextStopColor = (Color)stretchedColorMapping.get(nextStopValue);
                    this.interpolated[i] = SubstanceColorUtilities.getInterpolatedRGB(currStopColor, nextStopColor, 1.0 - (double)(brightness - currStopValue) / (double)(nextStopValue - currStopValue));
                    continue block1;
                }
                ++currIndex;
            }
        }
    }

    @Override
    public BufferedImage filter(BufferedImage src, BufferedImage dst) {
        if (dst == null) {
            dst = this.createCompatibleDestImage(src, null);
        }
        int width = src.getWidth();
        int height = src.getHeight();
        int[] pixels = new int[width * height];
        this.getPixels(src, 0, 0, width, height, pixels);
        this.mixColor(pixels);
        this.setPixels(dst, 0, 0, width, height, pixels);
        return dst;
    }

    private void mixColor(int[] pixels) {
        for (int i = 0; i < pixels.length; ++i) {
            int argb = pixels[i];
            int brightness = SubstanceColorUtilities.getColorBrightness(argb);
            int pixelColor = this.interpolated[brightness * 512 / 256];
            pixels[i] = argb & 0xFF000000 | (pixelColor >> 16 & 0xFF) << 16 | (pixelColor >> 8 & 0xFF) << 8 | pixelColor & 0xFF;
        }
    }
}

