/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.utils.border;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import javax.swing.JToolBar;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.UIResource;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.api.ComponentState;
import org.jvnet.substance.api.SubstanceColorScheme;
import org.jvnet.substance.utils.SubstanceColorSchemeUtilities;
import org.jvnet.substance.utils.SubstanceImageCreator;
import org.jvnet.substance.utils.SubstanceSizeUtils;

public class SubstanceToolBarBorder
extends AbstractBorder
implements UIResource {
    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
        if (!SubstanceLookAndFeel.isCurrentLookAndFeel()) {
            return;
        }
        Graphics2D graphics = (Graphics2D)g;
        graphics.translate(x, y);
        if (((JToolBar)c).isFloatable()) {
            SubstanceColorScheme scheme = SubstanceColorSchemeUtilities.getColorScheme(c, ComponentState.DEFAULT);
            int dragBumpsWidth = (int)(0.75 * (double)SubstanceSizeUtils.getToolBarDragInset(SubstanceSizeUtils.getComponentFontSize(c)));
            if (((JToolBar)c).getOrientation() == 0) {
                int height = c.getHeight() - 4;
                if (height > 0) {
                    if (c.getComponentOrientation().isLeftToRight()) {
                        graphics.drawImage((Image)SubstanceImageCreator.getDragImage(c, scheme, dragBumpsWidth, height, 2), 2, 1, null);
                    } else {
                        graphics.drawImage((Image)SubstanceImageCreator.getDragImage(c, scheme, dragBumpsWidth, height, 2), c.getBounds().width - dragBumpsWidth - 2, 1, null);
                    }
                }
            } else {
                int width = c.getWidth() - 4;
                if (width > 0) {
                    graphics.drawImage((Image)SubstanceImageCreator.getDragImage(c, scheme, width, dragBumpsWidth, 2), 2, 2, null);
                }
            }
        }
        graphics.translate(-x, -y);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
    }

    @Override
    public Insets getBorderInsets(Component c, Insets newInsets) {
        Insets margin;
        Insets defaultInsets = SubstanceSizeUtils.getToolBarInsets(SubstanceSizeUtils.getComponentFontSize(c));
        newInsets.set(defaultInsets.top, defaultInsets.left, defaultInsets.bottom, defaultInsets.right);
        JToolBar toolbar = (JToolBar)c;
        if (toolbar.isFloatable()) {
            int dragInset = SubstanceSizeUtils.getToolBarDragInset(SubstanceSizeUtils.getComponentFontSize(c));
            if (toolbar.getOrientation() == 0) {
                if (toolbar.getComponentOrientation().isLeftToRight()) {
                    newInsets.left = dragInset;
                } else {
                    newInsets.right = dragInset;
                }
            } else {
                newInsets.top = dragInset;
            }
        }
        if ((margin = toolbar.getMargin()) != null) {
            newInsets.left += margin.left;
            newInsets.top += margin.top;
            newInsets.right += margin.right;
            newInsets.bottom += margin.bottom;
        }
        return newInsets;
    }
}

