/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.utils;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Formatter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.UIResource;
import org.jvnet.lafwidget.LafWidgetUtilities;
import org.jvnet.lafwidget.animation.effects.GhostPaintingUtils;
import org.jvnet.lafwidget.utils.RenderingUtils;
import org.jvnet.lafwidget.utils.TrackableThread;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.SubstanceRootPaneUI;
import org.jvnet.substance.api.ComponentState;
import org.jvnet.substance.api.SubstanceColorScheme;
import org.jvnet.substance.api.SubstanceConstants;
import org.jvnet.substance.painter.decoration.DecorationAreaType;
import org.jvnet.substance.painter.decoration.SubstanceDecorationUtilities;
import org.jvnet.substance.skin.SkinInfo;
import org.jvnet.substance.utils.SubstanceColorSchemeUtilities;
import org.jvnet.substance.utils.SubstanceColorUtilities;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceImageCreator;
import org.jvnet.substance.utils.SubstanceSizeUtils;
import org.jvnet.substance.utils.SubstanceTextUtilities;
import org.jvnet.substance.utils.SubstanceTitleButton;
import org.jvnet.substance.utils.SubstanceWidgetManager;
import org.jvnet.substance.utils.icon.SubstanceIconFactory;
import org.jvnet.substance.utils.icon.TransitionAwareIcon;

public class SubstanceTitlePane
extends JComponent {
    private PropertyChangeListener propertyChangeListener;
    protected JMenuBar menuBar;
    private Action closeAction;
    private Action iconifyAction;
    private Action restoreAction;
    private Action maximizeAction;
    protected JButton toggleButton;
    protected JButton minimizeButton;
    protected JButton closeButton;
    private WindowListener windowListener;
    protected Window window;
    protected JRootPane rootPane;
    private int state;
    private SubstanceRootPaneUI rootPaneUI;
    protected static String heapStatusLogfileName;
    protected HeapStatusPanel heapStatusPanel;
    protected JCheckBoxMenuItem heapStatusMenuItem;
    protected PropertyChangeListener propertyListener;
    protected static final String EXTRA_COMPONENT_KIND = "substancelaf.internal.titlePane.extraComponentKind";

    public SubstanceTitlePane(JRootPane root, SubstanceRootPaneUI ui) {
        this.rootPane = root;
        this.rootPaneUI = ui;
        this.state = -1;
        this.installSubcomponents();
        this.installDefaults();
        this.setLayout(this.createLayout());
        this.setToolTipText(this.getTitle());
        SubstanceLookAndFeel.setDecorationType(this, DecorationAreaType.PRIMARY_TITLE_PANE);
        this.setForeground(SubstanceColorUtilities.getForegroundColor(SubstanceColorSchemeUtilities.getColorScheme(this, ComponentState.ACTIVE)));
    }

    public void uninstall() {
        this.uninstallListeners();
        this.window = null;
        HeapStatusThread.unregisterPanel(this.heapStatusPanel);
        if (this.menuBar != null && this.menuBar.getMenuCount() > 0) {
            this.menuBar.getUI().uninstallUI(this.menuBar);
            SubstanceCoreUtilities.uninstallMenu(this.menuBar.getMenu(0));
        }
        if (this.heapStatusPanel != null) {
            for (MouseListener listener : this.heapStatusPanel.getMouseListeners()) {
                this.heapStatusPanel.removeMouseListener(listener);
            }
            HeapStatusThread.unregisterPanel(this.heapStatusPanel);
            this.remove(this.heapStatusPanel);
        }
        if (this.menuBar != null) {
            this.menuBar.removeAll();
        }
        this.removeAll();
    }

    private void installListeners() {
        if (this.window != null) {
            this.windowListener = new WindowHandler();
            this.window.addWindowListener(this.windowListener);
            this.propertyChangeListener = new PropertyChangeHandler();
            this.window.addPropertyChangeListener(this.propertyChangeListener);
        }
        this.propertyListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(final PropertyChangeEvent evt) {
                if ("windowModified".equals(evt.getPropertyName())) {
                    SubstanceTitlePane.this.syncCloseButtonTooltip();
                }
                if ("componentOrientation".equals(evt.getPropertyName())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (SubstanceTitlePane.this.menuBar != null) {
                                SubstanceTitlePane.this.menuBar.applyComponentOrientation((ComponentOrientation)evt.getNewValue());
                            }
                        }
                    });
                }
            }
        };
        this.rootPane.addPropertyChangeListener(this.propertyListener);
        if (this.getFrame() != null) {
            this.getFrame().addPropertyChangeListener(this.propertyListener);
        }
    }

    private void uninstallListeners() {
        if (this.window != null) {
            this.window.removeWindowListener(this.windowListener);
            this.windowListener = null;
            this.window.removePropertyChangeListener(this.propertyChangeListener);
            this.propertyChangeListener = null;
        }
        this.rootPane.removePropertyChangeListener(this.propertyListener);
        if (this.getFrame() != null) {
            this.getFrame().removePropertyChangeListener(this.propertyListener);
        }
        this.propertyListener = null;
    }

    @Override
    public JRootPane getRootPane() {
        return this.rootPane;
    }

    protected int getWindowDecorationStyle() {
        return this.getRootPane().getWindowDecorationStyle();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.uninstallListeners();
        this.window = SwingUtilities.getWindowAncestor(this);
        if (this.window != null) {
            this.setActive(this.window.isActive());
            if (this.window instanceof Frame) {
                this.setState(((Frame)this.window).getExtendedState());
            } else {
                this.setState(0);
            }
            if (this.getComponentCount() == 0) {
                this.installSubcomponents();
            }
            this.installListeners();
        }
        this.setToolTipText(this.getTitle());
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.uninstall();
        this.window = null;
    }

    private void installSubcomponents() {
        int decorationStyle = this.getWindowDecorationStyle();
        if (decorationStyle == 1) {
            this.createActions();
            this.menuBar = this.createMenuBar();
            if (this.menuBar != null) {
                this.add(this.menuBar);
            }
            this.createButtons();
            this.add(this.minimizeButton);
            this.add(this.toggleButton);
            this.add(this.closeButton);
            this.heapStatusPanel = new HeapStatusPanel();
            this.markExtraComponent(this.heapStatusPanel, ExtraComponentKind.TRAILING);
            this.add(this.heapStatusPanel);
            boolean isHeapStatusPanelShowing = SubstanceWidgetManager.getInstance().isAllowed(this.rootPane, SubstanceConstants.SubstanceWidgetType.TITLE_PANE_HEAP_STATUS);
            this.heapStatusPanel.setVisible(isHeapStatusPanelShowing);
            this.heapStatusPanel.setPreferredSize(new Dimension(80, this.getPreferredSize().height));
            this.heapStatusPanel.setToolTipText(SubstanceCoreUtilities.getResourceBundle(this.rootPane).getString("Tooltip.heapStatusPanel"));
            this.heapStatusPanel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    System.gc();
                }
            });
            HeapStatusThread.registerPanel(this.heapStatusPanel);
        } else if (decorationStyle == 2 || decorationStyle == 3 || decorationStyle == 4 || decorationStyle == 5 || decorationStyle == 6 || decorationStyle == 7 || decorationStyle == 8) {
            this.createActions();
            this.createButtons();
            this.add(this.closeButton);
        }
    }

    private void installDefaults() {
        this.setFont(UIManager.getFont("InternalFrame.titleFont", this.getLocale()));
    }

    protected JMenuBar createMenuBar() {
        this.menuBar = new SubstanceMenuBar();
        this.menuBar.setFocusable(false);
        this.menuBar.setBorderPainted(true);
        this.menuBar.add(this.createMenu());
        this.menuBar.setOpaque(false);
        this.menuBar.applyComponentOrientation(this.rootPane.getComponentOrientation());
        this.markExtraComponent(this.menuBar, ExtraComponentKind.LEADING);
        return this.menuBar;
    }

    private void createActions() {
        this.closeAction = new CloseAction();
        if (this.getWindowDecorationStyle() == 1) {
            this.iconifyAction = new IconifyAction();
            this.restoreAction = new RestoreAction();
            this.maximizeAction = new MaximizeAction();
        }
    }

    private JMenu createMenu() {
        JMenu menu = new JMenu("");
        menu.setOpaque(false);
        menu.setBackground(null);
        if (this.getWindowDecorationStyle() == 1) {
            this.addMenuItems(menu);
        }
        return menu;
    }

    private void addMenuItems(JMenu menu) {
        menu.add(this.restoreAction);
        menu.add(this.iconifyAction);
        if (Toolkit.getDefaultToolkit().isFrameStateSupported(6)) {
            menu.add(this.maximizeAction);
        }
        if (SubstanceCoreUtilities.toShowExtraWidgets(this.rootPane)) {
            menu.addSeparator();
            JMenu skinMenu = new JMenu(SubstanceCoreUtilities.getResourceBundle(this.rootPane).getString("SystemMenu.skins"));
            Map<String, SkinInfo> allSkins = SubstanceLookAndFeel.getAllSkins();
            for (Map.Entry<String, SkinInfo> skinEntry : allSkins.entrySet()) {
                final String skinClassName = skinEntry.getValue().getClassName();
                JMenuItem jmiSkin = new JMenuItem(skinEntry.getKey());
                jmiSkin.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                SubstanceLookAndFeel.setSkin(skinClassName);
                            }
                        });
                    }
                });
                skinMenu.add(jmiSkin);
            }
            menu.add(skinMenu);
        }
        menu.addSeparator();
        menu.add(this.closeAction);
    }

    private JButton createTitleButton() {
        SubstanceTitleButton button = new SubstanceTitleButton();
        button.setFocusPainted(false);
        button.setFocusable(false);
        button.setOpaque(true);
        this.markExtraComponent(button, ExtraComponentKind.TRAILING);
        return button;
    }

    private void createButtons() {
        this.closeButton = this.createTitleButton();
        this.closeButton.setAction(this.closeAction);
        this.closeButton.setText(null);
        this.closeButton.putClientProperty("paintActive", Boolean.TRUE);
        this.closeButton.setBorder(null);
        TransitionAwareIcon closeIcon = new TransitionAwareIcon(this.closeButton, new TransitionAwareIcon.Delegate(){

            @Override
            public Icon getColorSchemeIcon(SubstanceColorScheme scheme) {
                return SubstanceIconFactory.getTitlePaneIcon(SubstanceIconFactory.IconKind.CLOSE, scheme);
            }
        });
        this.closeButton.setIcon(closeIcon);
        this.closeButton.setFocusable(false);
        this.closeButton.putClientProperty("substancelaf.componentFlat", Boolean.TRUE);
        this.closeButton.putClientProperty("substancelaf.internal.isTitleCloseButton", Boolean.TRUE);
        if (this.getWindowDecorationStyle() == 1) {
            this.minimizeButton = this.createTitleButton();
            this.minimizeButton.setAction(this.iconifyAction);
            this.minimizeButton.setText(null);
            this.minimizeButton.putClientProperty("paintActive", Boolean.TRUE);
            this.minimizeButton.setBorder(null);
            TransitionAwareIcon minIcon = new TransitionAwareIcon(this.minimizeButton, new TransitionAwareIcon.Delegate(){

                @Override
                public Icon getColorSchemeIcon(SubstanceColorScheme scheme) {
                    return SubstanceIconFactory.getTitlePaneIcon(SubstanceIconFactory.IconKind.MINIMIZE, scheme);
                }
            });
            this.minimizeButton.setIcon(minIcon);
            this.minimizeButton.setFocusable(false);
            this.minimizeButton.putClientProperty("substancelaf.componentFlat", Boolean.TRUE);
            this.minimizeButton.setToolTipText(SubstanceCoreUtilities.getResourceBundle(this.rootPane).getString("SystemMenu.iconify"));
            this.toggleButton = this.createTitleButton();
            this.toggleButton.setAction(this.restoreAction);
            this.toggleButton.putClientProperty("paintActive", Boolean.TRUE);
            this.toggleButton.setBorder(null);
            this.toggleButton.setText(null);
            TransitionAwareIcon maxIcon = new TransitionAwareIcon(this.toggleButton, new TransitionAwareIcon.Delegate(){

                @Override
                public Icon getColorSchemeIcon(SubstanceColorScheme scheme) {
                    return SubstanceIconFactory.getTitlePaneIcon(SubstanceIconFactory.IconKind.MAXIMIZE, scheme);
                }
            });
            this.toggleButton.setIcon(maxIcon);
            this.toggleButton.setToolTipText(SubstanceCoreUtilities.getResourceBundle(this.rootPane).getString("SystemMenu.maximize"));
            this.toggleButton.setFocusable(false);
            this.toggleButton.putClientProperty("substancelaf.componentFlat", Boolean.TRUE);
        }
        this.syncCloseButtonTooltip();
    }

    protected LayoutManager createLayout() {
        return new TitlePaneLayout();
    }

    private void setActive(boolean isActive) {
        Boolean activeB;
        Boolean bl = activeB = isActive ? Boolean.TRUE : Boolean.FALSE;
        if (this.getWindowDecorationStyle() == 1) {
            this.closeButton.putClientProperty("paintActive", activeB);
            this.minimizeButton.putClientProperty("paintActive", activeB);
            this.toggleButton.putClientProperty("paintActive", activeB);
        }
        this.getRootPane().repaint();
    }

    private void setState(int state) {
        this.setState(state, false);
    }

    private void setState(int state, boolean updateRegardless) {
        Window w = this.getWindow();
        if (w != null && this.getWindowDecorationStyle() == 1) {
            if (this.state == state && !updateRegardless) {
                return;
            }
            Frame frame = this.getFrame();
            if (frame != null) {
                JRootPane rootPane = this.getRootPane();
                if ((state & 6) != 0 && (rootPane.getBorder() == null || rootPane.getBorder() instanceof UIResource) && frame.isShowing()) {
                    rootPane.setBorder(null);
                } else if ((state & 6) == 0) {
                    this.rootPaneUI.installBorder(rootPane);
                }
                if (frame.isResizable()) {
                    if ((state & 6) != 0) {
                        TransitionAwareIcon restoreIcon = new TransitionAwareIcon(this.toggleButton, new TransitionAwareIcon.Delegate(){

                            @Override
                            public Icon getColorSchemeIcon(SubstanceColorScheme scheme) {
                                return SubstanceIconFactory.getTitlePaneIcon(SubstanceIconFactory.IconKind.RESTORE, scheme);
                            }
                        });
                        this.updateToggleButton(this.restoreAction, restoreIcon);
                        this.toggleButton.setToolTipText(SubstanceCoreUtilities.getResourceBundle(rootPane).getString("SystemMenu.restore"));
                        this.maximizeAction.setEnabled(false);
                        this.restoreAction.setEnabled(true);
                    } else {
                        TransitionAwareIcon maxIcon = new TransitionAwareIcon(this.toggleButton, new TransitionAwareIcon.Delegate(){

                            @Override
                            public Icon getColorSchemeIcon(SubstanceColorScheme scheme) {
                                return SubstanceIconFactory.getTitlePaneIcon(SubstanceIconFactory.IconKind.MAXIMIZE, scheme);
                            }
                        });
                        this.updateToggleButton(this.maximizeAction, maxIcon);
                        this.toggleButton.setToolTipText(SubstanceCoreUtilities.getResourceBundle(rootPane).getString("SystemMenu.maximize"));
                        this.maximizeAction.setEnabled(true);
                        this.restoreAction.setEnabled(false);
                    }
                    if (this.toggleButton.getParent() == null || this.minimizeButton.getParent() == null) {
                        this.add(this.toggleButton);
                        this.add(this.minimizeButton);
                        this.revalidate();
                        this.repaint();
                    }
                    this.toggleButton.setText(null);
                } else {
                    this.maximizeAction.setEnabled(false);
                    this.restoreAction.setEnabled(false);
                    if (this.toggleButton.getParent() != null) {
                        this.remove(this.toggleButton);
                        this.revalidate();
                        this.repaint();
                    }
                }
            } else {
                this.maximizeAction.setEnabled(false);
                this.restoreAction.setEnabled(false);
                this.iconifyAction.setEnabled(false);
                this.remove(this.toggleButton);
                this.remove(this.minimizeButton);
                this.revalidate();
                this.repaint();
            }
            this.closeAction.setEnabled(true);
            this.state = state;
        }
    }

    private void updateToggleButton(Action action, Icon icon) {
        this.toggleButton.setAction(action);
        this.toggleButton.setIcon(icon);
        this.toggleButton.setText(null);
    }

    private Frame getFrame() {
        Window window = this.getWindow();
        if (window instanceof Frame) {
            return (Frame)window;
        }
        return null;
    }

    private Window getWindow() {
        return this.window;
    }

    private String getTitle() {
        Window w = this.getWindow();
        if (w instanceof Frame) {
            return ((Frame)w).getTitle();
        }
        if (w instanceof Dialog) {
            return ((Dialog)w).getTitle();
        }
        return null;
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.getFrame() != null) {
            this.setState(this.getFrame().getExtendedState());
        }
        JRootPane rootPane = this.getRootPane();
        Window window = this.getWindow();
        boolean leftToRight = window == null ? rootPane.getComponentOrientation().isLeftToRight() : window.getComponentOrientation().isLeftToRight();
        int width = this.getWidth();
        int height = this.getHeight();
        SubstanceColorScheme scheme = SubstanceCoreUtilities.getSkin(rootPane).getMainDefaultColorScheme(DecorationAreaType.PRIMARY_TITLE_PANE);
        int xOffset = 0;
        String theTitle = this.getTitle();
        if (theTitle != null) {
            int titleWidth;
            Rectangle titleTextRect = this.getTitleTextRectangle();
            FontMetrics fm = rootPane.getFontMetrics(g.getFont());
            String clippedTitle = SubstanceCoreUtilities.clipString(fm, titleWidth = titleTextRect.width - 20, theTitle);
            if (theTitle.equals(clippedTitle)) {
                this.setToolTipText(null);
            } else {
                this.setToolTipText(theTitle);
            }
            theTitle = clippedTitle;
            xOffset = leftToRight ? titleTextRect.x : titleTextRect.x + titleTextRect.width - fm.stringWidth(theTitle);
        }
        Graphics2D graphics = (Graphics2D)g.create();
        FontUIResource font = SubstanceLookAndFeel.getFontPolicy().getFontSet("Substance", null).getWindowTitleFont();
        graphics.setFont(font);
        SubstanceDecorationUtilities.paintDecorationBackground(graphics, this, false);
        if (theTitle != null) {
            FontMetrics fm = rootPane.getFontMetrics(graphics.getFont());
            int yOffset = (height - fm.getHeight()) / 2 + fm.getAscent();
            SubstanceTextUtilities.paintTextWithDropShadow(this, graphics, SubstanceColorUtilities.getForegroundColor(scheme), theTitle, width, height, xOffset, yOffset);
        }
        GhostPaintingUtils.paintGhostImages(this, graphics);
        graphics.dispose();
    }

    protected Rectangle getTitleTextRectangle() {
        boolean leftToRight;
        JRootPane rootPane = this.getRootPane();
        Window window = this.getWindow();
        boolean bl = leftToRight = window == null ? rootPane.getComponentOrientation().isLeftToRight() : window.getComponentOrientation().isLeftToRight();
        if (leftToRight) {
            int maxLeadingX = 0;
            int minTrailingX = this.getWidth();
            for (int i = 0; i < this.getComponentCount(); ++i) {
                int cx;
                Component child = this.getComponent(i);
                if (!child.isVisible() || !(child instanceof JComponent)) continue;
                ExtraComponentKind kind = (ExtraComponentKind)((Object)((JComponent)child).getClientProperty(EXTRA_COMPONENT_KIND));
                if (kind == null) {
                    throw new IllegalStateException("Title pane child " + child.getClass().getName() + " is not marked as leading or trailing");
                }
                if (kind == ExtraComponentKind.LEADING) {
                    cx = child.getX() + child.getWidth();
                    if (cx <= maxLeadingX) continue;
                    maxLeadingX = cx;
                    continue;
                }
                cx = child.getX();
                if (cx >= minTrailingX) continue;
                minTrailingX = cx;
            }
            int start = maxLeadingX + 10;
            int end = minTrailingX - 5;
            return new Rectangle(start, 0, end - start, this.getHeight());
        }
        int minLeadingX = this.getWidth();
        int maxTrailingX = 0;
        for (int i = 0; i < this.getComponentCount(); ++i) {
            int cx;
            Component child = this.getComponent(i);
            if (!child.isVisible() || !(child instanceof JComponent)) continue;
            ExtraComponentKind kind = (ExtraComponentKind)((Object)((JComponent)child).getClientProperty(EXTRA_COMPONENT_KIND));
            if (kind == null) {
                throw new IllegalStateException("Title pane child " + child.getClass().getName() + " is not marked as leading or trailing");
            }
            if (kind == ExtraComponentKind.LEADING) {
                cx = child.getX();
                if (cx >= minLeadingX) continue;
                minLeadingX = cx;
                continue;
            }
            cx = child.getX() + child.getWidth();
            if (cx <= maxTrailingX) continue;
            maxTrailingX = cx;
        }
        int start = maxTrailingX + 5;
        int end = minLeadingX - 10;
        return new Rectangle(start, 0, end - start, this.getHeight());
    }

    public static void setHeapStatusLogfileName(String heapStatusLogfileName) {
        SubstanceTitlePane.heapStatusLogfileName = heapStatusLogfileName;
    }

    protected void syncCloseButtonTooltip() {
        if (SubstanceCoreUtilities.isRootPaneModified(this.getRootPane())) {
            this.closeButton.setToolTipText(SubstanceCoreUtilities.getResourceBundle(this.rootPane).getString("SystemMenu.close") + " [" + SubstanceCoreUtilities.getResourceBundle(this.rootPane).getString("Tooltip.contentsNotSaved") + "]");
        } else {
            this.closeButton.setToolTipText(SubstanceCoreUtilities.getResourceBundle(this.rootPane).getString("SystemMenu.close"));
        }
        this.closeButton.repaint();
    }

    protected void markExtraComponent(JComponent comp, ExtraComponentKind kind) {
        comp.putClientProperty(EXTRA_COMPONENT_KIND, (Object)kind);
    }

    private class WindowHandler
    extends WindowAdapter {
        private WindowHandler() {
        }

        @Override
        public void windowActivated(WindowEvent ev) {
            SubstanceTitlePane.this.setActive(true);
        }

        @Override
        public void windowDeactivated(WindowEvent ev) {
            SubstanceTitlePane.this.setActive(false);
        }
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent pce) {
            String name = pce.getPropertyName();
            if ("resizable".equals(name) || "state".equals(name)) {
                Frame frame = SubstanceTitlePane.this.getFrame();
                if (frame != null) {
                    SubstanceTitlePane.this.setState(frame.getExtendedState(), true);
                }
                if ("resizable".equals(name)) {
                    SubstanceTitlePane.this.getRootPane().repaint();
                }
            } else if ("title".equals(name)) {
                SubstanceTitlePane.this.repaint();
                SubstanceTitlePane.this.setToolTipText((String)pce.getNewValue());
            } else if ("componentOrientation".equals(name) || "iconImage".equals(name)) {
                SubstanceTitlePane.this.revalidate();
                SubstanceTitlePane.this.repaint();
            }
        }
    }

    protected class TitlePaneLayout
    implements LayoutManager {
        protected TitlePaneLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component c) {
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            int height = this.computeHeight();
            return new Dimension(height, height);
        }

        private int computeHeight() {
            FontMetrics fm = SubstanceTitlePane.this.rootPane.getFontMetrics(SubstanceTitlePane.this.getFont());
            int fontHeight = fm.getHeight();
            fontHeight += 7;
            int iconHeight = 0;
            if (SubstanceTitlePane.this.getWindowDecorationStyle() == 1) {
                iconHeight = SubstanceSizeUtils.getTitlePaneIconSize();
            }
            int finalHeight = Math.max(fontHeight, iconHeight);
            return finalHeight;
        }

        @Override
        public Dimension minimumLayoutSize(Container c) {
            return this.preferredLayoutSize(c);
        }

        @Override
        public void layoutContainer(Container c) {
            int buttonWidth;
            int buttonHeight;
            boolean leftToRight = SubstanceTitlePane.this.window == null ? SubstanceTitlePane.this.getRootPane().getComponentOrientation().isLeftToRight() : SubstanceTitlePane.this.window.getComponentOrientation().isLeftToRight();
            int w = SubstanceTitlePane.this.getWidth();
            int y = 3;
            if (SubstanceTitlePane.this.closeButton != null && SubstanceTitlePane.this.closeButton.getIcon() != null) {
                buttonHeight = SubstanceTitlePane.this.closeButton.getIcon().getIconHeight();
                buttonWidth = SubstanceTitlePane.this.closeButton.getIcon().getIconWidth();
            } else {
                buttonHeight = SubstanceSizeUtils.getTitlePaneIconSize();
                buttonWidth = SubstanceSizeUtils.getTitlePaneIconSize();
            }
            y = (SubstanceTitlePane.this.getHeight() - buttonHeight) / 2;
            int x = leftToRight ? w : 0;
            int spacing = 5;
            int n = x = leftToRight ? spacing : w - buttonWidth - spacing;
            if (SubstanceTitlePane.this.menuBar != null) {
                SubstanceTitlePane.this.menuBar.setBounds(x, y, buttonWidth, buttonHeight);
            }
            x = leftToRight ? w : 0;
            spacing = 4;
            x += leftToRight ? -spacing - buttonWidth : spacing;
            if (SubstanceTitlePane.this.closeButton != null) {
                SubstanceTitlePane.this.closeButton.setBounds(x, y, buttonWidth, buttonHeight);
            }
            if (!leftToRight) {
                x += buttonWidth;
            }
            if (SubstanceTitlePane.this.getWindowDecorationStyle() == 1) {
                if (Toolkit.getDefaultToolkit().isFrameStateSupported(6) && SubstanceTitlePane.this.toggleButton.getParent() != null) {
                    spacing = 10;
                    SubstanceTitlePane.this.toggleButton.setBounds(x += leftToRight ? -spacing - buttonWidth : spacing, y, buttonWidth, buttonHeight);
                    if (!leftToRight) {
                        x += buttonWidth;
                    }
                }
                if (SubstanceTitlePane.this.minimizeButton != null && SubstanceTitlePane.this.minimizeButton.getParent() != null) {
                    spacing = 2;
                    SubstanceTitlePane.this.minimizeButton.setBounds(x += leftToRight ? -spacing - buttonWidth : spacing, y, buttonWidth, buttonHeight);
                    if (!leftToRight) {
                        x += buttonWidth;
                    }
                }
                if (SubstanceTitlePane.this.heapStatusPanel != null && SubstanceTitlePane.this.heapStatusPanel.isVisible()) {
                    spacing = 5;
                    SubstanceTitlePane.this.heapStatusPanel.setBounds(x += leftToRight ? -spacing - SubstanceTitlePane.this.heapStatusPanel.getPreferredWidth() : spacing, 1, SubstanceTitlePane.this.heapStatusPanel.getPreferredWidth(), SubstanceTitlePane.this.getHeight() - 3);
                }
            }
        }
    }

    public class SubstanceMenuBar
    extends JMenuBar {
        @Override
        public void paint(Graphics g) {
            Image image;
            Frame frame = SubstanceTitlePane.this.getFrame();
            Image image2 = image = frame != null ? frame.getIconImage() : null;
            if (image != null) {
                int iSize = SubstanceSizeUtils.getTitlePaneIconSize();
                double coef = Math.max((double)iSize / (double)image.getWidth(null), (double)iSize / (double)image.getHeight(null));
                if (coef < 1.0) {
                    BufferedImage bi = SubstanceCoreUtilities.getBlankImage(image.getWidth(null), image.getHeight(null));
                    bi.getGraphics().drawImage(image, 0, 0, null);
                    g.drawImage(LafWidgetUtilities.createThumbnail(bi, iSize), 0, 0, null);
                } else {
                    g.drawImage(image, 0, 0, null);
                }
            } else {
                Icon icon = UIManager.getIcon("InternalFrame.icon");
                if (icon != null) {
                    icon.paintIcon(this, g, 0, 0);
                }
            }
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            int iSize = SubstanceSizeUtils.getTitlePaneIconSize();
            return new Dimension(Math.max(iSize, size.width), Math.max(size.height, iSize));
        }
    }

    private class MaximizeAction
    extends AbstractAction {
        public MaximizeAction() {
            super(SubstanceCoreUtilities.getResourceBundle(SubstanceTitlePane.this.rootPane).getString("SystemMenu.maximize"), SubstanceImageCreator.getMaximizeIcon(SubstanceCoreUtilities.getSkin(SubstanceTitlePane.this.rootPane).getMainActiveColorScheme(DecorationAreaType.PRIMARY_TITLE_PANE)));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Frame frame = SubstanceTitlePane.this.getFrame();
            if (frame != null) {
                if (frame instanceof JFrame) {
                    SubstanceRootPaneUI rpUI = (SubstanceRootPaneUI)((JFrame)frame).getRootPane().getUI();
                    rpUI.setMaximized();
                }
                frame.setExtendedState(SubstanceTitlePane.this.state | 6);
            }
        }
    }

    private class RestoreAction
    extends AbstractAction {
        public RestoreAction() {
            super(SubstanceCoreUtilities.getResourceBundle(SubstanceTitlePane.this.rootPane).getString("SystemMenu.restore"), SubstanceImageCreator.getRestoreIcon(SubstanceCoreUtilities.getSkin(SubstanceTitlePane.this.rootPane).getMainActiveColorScheme(DecorationAreaType.PRIMARY_TITLE_PANE)));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Frame frame = SubstanceTitlePane.this.getFrame();
            if (frame == null) {
                return;
            }
            if ((SubstanceTitlePane.this.state & 1) != 0) {
                frame.setExtendedState(SubstanceTitlePane.this.state & 0xFFFFFFFE);
            } else {
                frame.setExtendedState(SubstanceTitlePane.this.state & 0xFFFFFFF9);
            }
        }
    }

    private class IconifyAction
    extends AbstractAction {
        public IconifyAction() {
            super(SubstanceCoreUtilities.getResourceBundle(SubstanceTitlePane.this.rootPane).getString("SystemMenu.iconify"), SubstanceImageCreator.getMinimizeIcon(SubstanceCoreUtilities.getSkin(SubstanceTitlePane.this.rootPane).getMainActiveColorScheme(DecorationAreaType.PRIMARY_TITLE_PANE)));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Frame frame = SubstanceTitlePane.this.getFrame();
            if (frame != null) {
                frame.setExtendedState(SubstanceTitlePane.this.state | 1);
            }
        }
    }

    private class CloseAction
    extends AbstractAction {
        public CloseAction() {
            super(SubstanceCoreUtilities.getResourceBundle(SubstanceTitlePane.this.rootPane).getString("SystemMenu.close"), SubstanceImageCreator.getCloseIcon(SubstanceCoreUtilities.getSkin(SubstanceTitlePane.this.rootPane).getMainActiveColorScheme(DecorationAreaType.PRIMARY_TITLE_PANE)));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Window window = SubstanceTitlePane.this.getWindow();
            if (window != null) {
                window.dispatchEvent(new WindowEvent(window, 201));
            }
        }
    }

    public static class HeapStatusThread
    extends TrackableThread {
        private int heapSizeKB;
        private int takenHeapSizeKB;
        private static Set<WeakReference<HeapStatusPanel>> panels = new HashSet<WeakReference<HeapStatusPanel>>();
        private static HeapStatusThread instance;
        private SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss.SSS");
        private boolean isStopRequested = false;

        private HeapStatusThread() {
            this.setName("Substance heap status");
        }

        public static synchronized HeapStatusThread getInstance() {
            if (instance == null) {
                instance = new HeapStatusThread();
                instance.start();
            }
            return instance;
        }

        public static synchronized void registerPanel(HeapStatusPanel panel) {
            panels.add(new WeakReference<HeapStatusPanel>(panel));
        }

        public static synchronized void unregisterPanel(HeapStatusPanel panel) {
            Iterator<WeakReference<HeapStatusPanel>> it = panels.iterator();
            while (it.hasNext()) {
                WeakReference<HeapStatusPanel> ref = it.next();
                HeapStatusPanel currPanel = (HeapStatusPanel)ref.get();
                if (panel != currPanel) continue;
                it.remove();
                return;
            }
        }

        private synchronized void updateHeapCounts() {
            long heapSize = Runtime.getRuntime().totalMemory();
            long heapFreeSize = Runtime.getRuntime().freeMemory();
            this.heapSizeKB = (int)(heapSize / 1024L);
            this.takenHeapSizeKB = (int)((heapSize - heapFreeSize) / 1024L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.isStopRequested) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                if (!SubstanceWidgetManager.getInstance().isAllowedAnywhere(SubstanceConstants.SubstanceWidgetType.TITLE_PANE_HEAP_STATUS)) continue;
                this.updateHeapCounts();
                Iterator<WeakReference<HeapStatusPanel>> it = panels.iterator();
                while (it.hasNext()) {
                    WeakReference<HeapStatusPanel> refPanel = it.next();
                    HeapStatusPanel panel = (HeapStatusPanel)refPanel.get();
                    if (panel == null) {
                        panels.remove(it);
                        continue;
                    }
                    panel.updateStatus(this.heapSizeKB, this.takenHeapSizeKB);
                }
                if (heapStatusLogfileName == null) continue;
                PrintWriter pw = null;
                try {
                    pw = new PrintWriter(new FileWriter(heapStatusLogfileName, true));
                    pw.println(this.format.format(new Date()) + " " + this.takenHeapSizeKB + "KB / " + this.heapSizeKB + "KB");
                }
                catch (IOException iOException) {}
                continue;
                finally {
                    if (pw == null) continue;
                    pw.close();
                }
            }
        }

        @Override
        protected void requestStop() {
            this.isStopRequested = true;
            instance = null;
        }
    }

    public static class HeapStatusPanel
    extends JPanel {
        private int currHeapSizeKB;
        private int currTakenHeapSizeKB;
        private LinkedList<Double> graphValues = new LinkedList();

        public HeapStatusPanel() {
            HeapStatusThread.getInstance();
        }

        public synchronized void updateStatus(int currHeapSizeKB, int currTakenHeapSizeKB) {
            this.currHeapSizeKB = currHeapSizeKB;
            this.currTakenHeapSizeKB = currTakenHeapSizeKB;
            double newGraphValue = (double)currTakenHeapSizeKB / (double)currHeapSizeKB;
            this.graphValues.addLast(newGraphValue);
            this.repaint();
        }

        @Override
        public synchronized void paint(Graphics g) {
            Graphics2D graphics = (Graphics2D)g.create();
            SubstanceColorScheme scheme = SubstanceCoreUtilities.getSkin(this).getMainActiveColorScheme(DecorationAreaType.PRIMARY_TITLE_PANE);
            graphics.setColor(scheme.getDarkColor());
            int w = this.getWidth();
            int h = this.getHeight();
            graphics.drawRect(0, 0, w - 1, h - 1);
            graphics.setColor(scheme.getExtraLightColor());
            graphics.fillRect(1, 1, w - 2, h - 2);
            while (this.graphValues.size() > w - 2) {
                this.graphValues.removeFirst();
            }
            int xOff = w - this.graphValues.size() - 1;
            graphics.setColor(scheme.getMidColor());
            int count = 0;
            Iterator i$ = this.graphValues.iterator();
            while (i$.hasNext()) {
                double value = (Double)i$.next();
                int valueH = (int)(value * (double)(h - 2));
                graphics.drawLine(xOff + count, h - 1 - valueH, xOff + count, h - 2);
                ++count;
            }
            graphics.setFont(UIManager.getFont("Panel.font"));
            FontMetrics fm = graphics.getFontMetrics();
            StringBuffer longFormat = new StringBuffer();
            Formatter longFormatter = new Formatter(longFormat);
            longFormatter.format("%.1fMB / %.1fMB", Float.valueOf((float)this.currTakenHeapSizeKB / 1024.0f), Float.valueOf((float)this.currHeapSizeKB / 1024.0f));
            int strW = fm.stringWidth(longFormat.toString());
            int strH = fm.getAscent() + fm.getDescent();
            graphics.setColor(scheme.getForegroundColor());
            RenderingUtils.installDesktopHints(graphics, this);
            if (strW < w - 5) {
                graphics.drawString(longFormat.toString(), (w - strW) / 2, (h + strH) / 2 - 2);
            } else {
                String shortFormat = this.currTakenHeapSizeKB / 1024 + "MB / " + this.currHeapSizeKB / 1024 + "MB";
                strW = fm.stringWidth(shortFormat);
                graphics.drawString(shortFormat, (w - strW) / 2, (h + strH) / 2 - 2);
            }
            graphics.dispose();
        }

        public int getPreferredWidth() {
            BufferedImage dummy2 = new BufferedImage(1, 1, 2);
            Graphics2D g2d = dummy2.createGraphics();
            RenderingUtils.installDesktopHints(g2d, this);
            g2d.setFont(UIManager.getFont("Panel.font"));
            FontMetrics fm = g2d.getFontMetrics();
            int result = fm.stringWidth("100.9MB / 200.9MB");
            g2d.dispose();
            return result;
        }
    }

    protected static enum ExtraComponentKind {
        LEADING,
        TRAILING;

    }
}

