/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.utils;

import java.awt.Color;
import java.awt.Component;
import javax.swing.AbstractButton;
import javax.swing.JTabbedPane;
import javax.swing.plaf.UIResource;
import org.jvnet.lafwidget.animation.FadeKind;
import org.jvnet.substance.api.ComponentState;
import org.jvnet.substance.api.SubstanceColorScheme;
import org.jvnet.substance.api.SubstanceColorSchemeBundle;
import org.jvnet.substance.api.SubstanceSkin;
import org.jvnet.substance.colorscheme.BottleGreenColorScheme;
import org.jvnet.substance.colorscheme.LightGrayColorScheme;
import org.jvnet.substance.colorscheme.MetallicColorScheme;
import org.jvnet.substance.colorscheme.ShiftColorScheme;
import org.jvnet.substance.colorscheme.SunGlareColorScheme;
import org.jvnet.substance.colorscheme.SunfireRedColorScheme;
import org.jvnet.substance.painter.decoration.DecorationAreaType;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceSpinnerButton;
import org.jvnet.substance.utils.SubstanceTitleButton;
import org.jvnet.substance.utils.combo.SubstanceComboBoxButton;
import org.jvnet.substance.utils.scroll.SubstanceScrollButton;

public class SubstanceColorSchemeUtilities {
    public static final SubstanceSkin METALLIC_SKIN = SubstanceColorSchemeUtilities.getMetallicSkin();
    public static final SubstanceColorScheme YELLOW = new SunGlareColorScheme();
    public static final SubstanceColorScheme ORANGE = new SunfireRedColorScheme();
    public static final SubstanceColorScheme GREEN = new BottleGreenColorScheme();

    private static SubstanceSkin getMetallicSkin() {
        SubstanceSkin res = new SubstanceSkin(){

            @Override
            public String getDisplayName() {
                return "Metallic Skin";
            }
        };
        res.registerDecorationAreaSchemeBundle(new SubstanceColorSchemeBundle(new MetallicColorScheme(), new MetallicColorScheme(), new LightGrayColorScheme()), DecorationAreaType.NONE);
        return res;
    }

    private static SubstanceColorScheme getColorizedScheme(Component component, SubstanceColorScheme scheme, boolean isEnabled) {
        ColorizationSupport support = new ColorizationSupport(){

            private boolean toTakeFromParent(Component component) {
                return component.getParent() != null && (component instanceof SubstanceScrollButton || component instanceof SubstanceSpinnerButton || component instanceof SubstanceComboBoxButton || component instanceof SubstanceTitleButton);
            }

            @Override
            public Color getBackground(Component component) {
                return this.toTakeFromParent(component) ? component.getParent().getBackground() : component.getBackground();
            }

            @Override
            public Color getForeground(Component component) {
                return this.toTakeFromParent(component) ? component.getParent().getForeground() : component.getForeground();
            }
        };
        return SubstanceColorSchemeUtilities.getColorizedScheme(component, scheme, support, isEnabled);
    }

    private static SubstanceColorScheme getColorizedScheme(Component component, SubstanceColorScheme scheme, ColorizationSupport support, boolean isEnabled) {
        if (component != null) {
            Color bk = support.getBackground(component);
            Color fg = support.getForeground(component);
            if (bk instanceof UIResource) {
                bk = null;
            }
            if (fg instanceof UIResource) {
                fg = null;
            }
            if (bk != null || fg != null) {
                double colorization = SubstanceCoreUtilities.getColorizationFactor(component);
                if (!isEnabled) {
                    colorization /= 2.0;
                }
                if (colorization > 0.0) {
                    return ShiftColorScheme.getShiftedScheme(scheme, bk, colorization, fg, colorization);
                }
            }
        }
        return scheme;
    }

    public static SubstanceColorScheme getColorScheme(final JTabbedPane jtp, final int tabIndex, ComponentState componentState) {
        SubstanceSkin skin = SubstanceCoreUtilities.getSkin(jtp);
        if (skin == null) {
            throw new IllegalStateException("Substance delegate used when Substance is not the current LAF");
        }
        SubstanceColorScheme nonColorized = skin.getColorScheme(jtp, componentState);
        if (tabIndex >= 0) {
            Component component = jtp.getComponentAt(tabIndex);
            SubstanceColorScheme colorized = SubstanceColorSchemeUtilities.getColorizedScheme(component, nonColorized, new ColorizationSupport(){

                @Override
                public Color getBackground(Component component) {
                    return jtp.getBackgroundAt(tabIndex);
                }

                @Override
                public Color getForeground(Component component) {
                    return jtp.getForegroundAt(tabIndex);
                }
            }, componentState.isKindActive(FadeKind.ENABLE));
            return colorized;
        }
        return SubstanceColorSchemeUtilities.getColorizedScheme(jtp, nonColorized, componentState.isKindActive(FadeKind.ENABLE));
    }

    public static SubstanceColorScheme getBorderColorScheme(final JTabbedPane jtp, final int tabIndex, ComponentState componentState) {
        SubstanceColorScheme nonColorized = SubstanceCoreUtilities.getSkin(jtp).getBorderColorScheme(jtp, componentState);
        if (tabIndex >= 0) {
            Component component = jtp.getComponentAt(tabIndex);
            SubstanceColorScheme colorized = SubstanceColorSchemeUtilities.getColorizedScheme(component, nonColorized, new ColorizationSupport(){

                @Override
                public Color getBackground(Component component) {
                    return jtp.getBackgroundAt(tabIndex);
                }

                @Override
                public Color getForeground(Component component) {
                    return jtp.getForegroundAt(tabIndex);
                }
            }, componentState.isKindActive(FadeKind.ENABLE));
            return colorized;
        }
        return SubstanceColorSchemeUtilities.getColorizedScheme(jtp, nonColorized, componentState.isKindActive(FadeKind.ENABLE));
    }

    public static SubstanceColorScheme getColorScheme(Component component, ComponentState componentState) {
        return SubstanceColorSchemeUtilities.getColorScheme(component, componentState, false);
    }

    public static SubstanceColorScheme getColorScheme(Component component, ComponentState componentState, boolean toIgnoreHighlights) {
        SubstanceSkin skin;
        boolean isButtonThatIsNeverPainted;
        Component orig = component;
        boolean bl = isButtonThatIsNeverPainted = component instanceof AbstractButton && SubstanceCoreUtilities.isButtonNeverPainted((AbstractButton)component);
        if (isButtonThatIsNeverPainted || SubstanceCoreUtilities.hasFlatAppearance(component, false) && componentState == ComponentState.DEFAULT) {
            component = component.getParent();
        }
        if ((skin = SubstanceCoreUtilities.getSkin(component)) == null) {
            throw new IllegalStateException("Substance delegate used when Substance is not the current LAF");
        }
        SubstanceColorScheme nonColorized = skin.getColorScheme(component, componentState, toIgnoreHighlights);
        return SubstanceColorSchemeUtilities.getColorizedScheme(orig, nonColorized, componentState.isKindActive(FadeKind.ENABLE));
    }

    public static SubstanceColorScheme getBorderColorScheme(Component component, ComponentState componentState) {
        if (SubstanceCoreUtilities.hasFlatAppearance(component, false) && componentState == ComponentState.DEFAULT) {
            component = component.getParent();
        }
        SubstanceColorScheme nonColorized = SubstanceCoreUtilities.getSkin(component).getBorderColorScheme(component, componentState);
        return SubstanceColorSchemeUtilities.getColorizedScheme(component, nonColorized, componentState.isKindActive(FadeKind.ENABLE));
    }

    public static SubstanceColorScheme getHighlightColorScheme(Component component, ComponentState componentState) {
        return SubstanceCoreUtilities.getSkin(component).getHighlightColorScheme(component, componentState);
    }

    public static float getHighlightAlpha(Component component, ComponentState componentState) {
        return SubstanceCoreUtilities.getSkin(component).getHighlightAlpha(component, componentState);
    }

    public static float getAlpha(Component component, ComponentState componentState) {
        return SubstanceCoreUtilities.getSkin(component).getAlpha(component, componentState);
    }

    private static interface ColorizationSupport {
        public Color getBackground(Component var1);

        public Color getForeground(Component var1);
    }
}

