/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.skin;

import java.awt.Color;
import org.jvnet.substance.api.ComponentState;
import org.jvnet.substance.api.SubstanceColorScheme;
import org.jvnet.substance.api.SubstanceColorSchemeBundle;
import org.jvnet.substance.api.SubstanceSkin;
import org.jvnet.substance.colorscheme.BaseDarkColorScheme;
import org.jvnet.substance.colorscheme.BaseLightColorScheme;
import org.jvnet.substance.painter.border.FlatBorderPainter;
import org.jvnet.substance.painter.decoration.ArcDecorationPainter;
import org.jvnet.substance.painter.decoration.DecorationAreaType;
import org.jvnet.substance.painter.decoration.MarbleNoiseDecorationPainter;
import org.jvnet.substance.painter.gradient.SubduedGradientPainter;
import org.jvnet.substance.painter.highlight.ClassicHighlightPainter;
import org.jvnet.substance.shaper.ClassicButtonShaper;

public class NebulaSkin
extends SubstanceSkin {
    public static String NAME = "Nebula";

    public NebulaSkin() {
        ActiveScheme activeScheme = new ActiveScheme();
        DefaultScheme defaultScheme = new DefaultScheme();
        RolloverUnselectedScheme rolloverUnselectedScheme = new RolloverUnselectedScheme();
        PressedScheme pressedScheme = new PressedScheme();
        RolloverSelectedScheme rolloverSelectedScheme = new RolloverSelectedScheme();
        DisabledScheme disabledScheme = new DisabledScheme();
        SubstanceColorSchemeBundle defaultSchemeBundle = new SubstanceColorSchemeBundle(activeScheme, defaultScheme, disabledScheme);
        defaultSchemeBundle.registerColorScheme((SubstanceColorScheme)rolloverUnselectedScheme, ComponentState.ROLLOVER_UNSELECTED);
        defaultSchemeBundle.registerColorScheme((SubstanceColorScheme)rolloverSelectedScheme, ComponentState.ROLLOVER_SELECTED);
        defaultSchemeBundle.registerColorScheme((SubstanceColorScheme)pressedScheme, ComponentState.PRESSED_SELECTED, ComponentState.PRESSED_UNSELECTED, ComponentState.ARMED, ComponentState.ROLLOVER_ARMED);
        defaultSchemeBundle.registerHighlightColorScheme((SubstanceColorScheme)pressedScheme, 0.6f, ComponentState.ROLLOVER_UNSELECTED);
        defaultSchemeBundle.registerHighlightColorScheme((SubstanceColorScheme)pressedScheme, 0.8f, ComponentState.SELECTED);
        defaultSchemeBundle.registerHighlightColorScheme((SubstanceColorScheme)pressedScheme, 0.95f, ComponentState.ROLLOVER_SELECTED);
        defaultSchemeBundle.registerHighlightColorScheme((SubstanceColorScheme)pressedScheme, 0.8f, ComponentState.ARMED, ComponentState.ROLLOVER_ARMED);
        this.registerDecorationAreaSchemeBundle(defaultSchemeBundle, DecorationAreaType.NONE);
        this.registerAsDecorationArea(activeScheme.saturate(-0.5), DecorationAreaType.PRIMARY_TITLE_PANE, DecorationAreaType.SECONDARY_TITLE_PANE, DecorationAreaType.HEADER, DecorationAreaType.FOOTER, DecorationAreaType.GENERAL);
        this.setPaintingDropShadows(DecorationAreaType.TOOLBAR);
        this.buttonShaper = new ClassicButtonShaper();
        this.gradientPainter = new SubduedGradientPainter();
        MarbleNoiseDecorationPainter decorationPainter = new MarbleNoiseDecorationPainter();
        decorationPainter.setPaintingSeparators(true);
        decorationPainter.setBaseDecorationPainter(new ArcDecorationPainter());
        decorationPainter.setTextureAlpha(0.3f);
        this.decorationPainter = decorationPainter;
        this.highlightPainter = new ClassicHighlightPainter();
        this.borderPainter = new FlatBorderPainter();
    }

    @Override
    public String getDisplayName() {
        return NAME;
    }

    protected static class PressedScheme
    extends BaseDarkColorScheme {
        private static final Color mainUltraLightColor = Color.decode("#8FA9C0");
        private static final Color mainExtraLightColor = Color.decode("#7695B2");
        private static final Color mainLightColor = Color.decode("#5B89B4");
        private static final Color mainMidColor = Color.decode("#33628C");
        private static final Color mainDarkColor = Color.decode("#1C3851");
        private static final Color mainUltraDarkColor = Color.decode("#000000");
        private static final Color foregroundColor = Color.decode("#FFFFFF");

        public PressedScheme() {
            super("Nebula Pressed");
        }

        @Override
        public Color getForegroundColor() {
            return foregroundColor;
        }

        @Override
        public Color getUltraLightColor() {
            return mainUltraLightColor;
        }

        @Override
        public Color getExtraLightColor() {
            return mainExtraLightColor;
        }

        @Override
        public Color getLightColor() {
            return mainLightColor;
        }

        @Override
        public Color getMidColor() {
            return mainMidColor;
        }

        @Override
        public Color getDarkColor() {
            return mainDarkColor;
        }

        @Override
        public Color getUltraDarkColor() {
            return mainUltraDarkColor;
        }
    }

    protected static class RolloverSelectedScheme
    extends BaseLightColorScheme {
        private static final Color mainUltraLightColor = Color.decode("#F8FAFC");
        private static final Color mainExtraLightColor = Color.decode("#E8FDFF");
        private static final Color mainLightColor = Color.decode("#D4E9FC");
        private static final Color mainMidColor = Color.decode("#B6CBDE");
        private static final Color mainDarkColor = Color.decode("#3B556D");
        private static final Color mainUltraDarkColor = Color.decode("#00051D");
        private static final Color foregroundColor = Color.decode("#000000");

        public RolloverSelectedScheme() {
            super("Nebula Rollover Selected");
        }

        @Override
        public Color getForegroundColor() {
            return foregroundColor;
        }

        @Override
        public Color getUltraLightColor() {
            return mainUltraLightColor;
        }

        @Override
        public Color getExtraLightColor() {
            return mainExtraLightColor;
        }

        @Override
        public Color getLightColor() {
            return mainLightColor;
        }

        @Override
        public Color getMidColor() {
            return mainMidColor;
        }

        @Override
        public Color getDarkColor() {
            return mainDarkColor;
        }

        @Override
        public Color getUltraDarkColor() {
            return mainUltraDarkColor;
        }
    }

    protected static class RolloverUnselectedScheme
    extends BaseLightColorScheme {
        private static final Color mainUltraLightColor = Color.decode("#FFFFFF");
        private static final Color mainExtraLightColor = Color.decode("#FDFDFE");
        private static final Color mainLightColor = Color.decode("#F7F8FA");
        private static final Color mainMidColor = Color.decode("#E9ECF2");
        private static final Color mainDarkColor = Color.decode("#7A7E86");
        private static final Color mainUltraDarkColor = Color.decode("#55585E");
        private static final Color foregroundColor = Color.decode("#2A2E36");

        public RolloverUnselectedScheme() {
            super("Nebula Rollover Unselected");
        }

        @Override
        public Color getForegroundColor() {
            return foregroundColor;
        }

        @Override
        public Color getUltraLightColor() {
            return mainUltraLightColor;
        }

        @Override
        public Color getExtraLightColor() {
            return mainExtraLightColor;
        }

        @Override
        public Color getLightColor() {
            return mainLightColor;
        }

        @Override
        public Color getMidColor() {
            return mainMidColor;
        }

        @Override
        public Color getDarkColor() {
            return mainDarkColor;
        }

        @Override
        public Color getUltraDarkColor() {
            return mainUltraDarkColor;
        }
    }

    protected static class DisabledScheme
    extends BaseLightColorScheme {
        private static final Color mainUltraLightColor = Color.decode("#E3EFE9");
        private static final Color mainExtraLightColor = Color.decode("#DFE2E6");
        private static final Color mainLightColor = Color.decode("#DADDE3");
        private static final Color mainMidColor = Color.decode("#D6D9DF");
        private static final Color mainDarkColor = Color.decode("#C9CCD2");
        private static final Color mainUltraDarkColor = Color.decode("#BCBFC5");
        private static final Color foregroundColor = Color.decode("#848B98");

        public DisabledScheme() {
            super("Nebula Disabled");
        }

        @Override
        public Color getForegroundColor() {
            return foregroundColor;
        }

        @Override
        public Color getUltraLightColor() {
            return mainUltraLightColor;
        }

        @Override
        public Color getExtraLightColor() {
            return mainExtraLightColor;
        }

        @Override
        public Color getLightColor() {
            return mainLightColor;
        }

        @Override
        public Color getMidColor() {
            return mainMidColor;
        }

        @Override
        public Color getDarkColor() {
            return mainDarkColor;
        }

        @Override
        public Color getUltraDarkColor() {
            return mainUltraDarkColor;
        }
    }

    protected static class DefaultScheme
    extends BaseLightColorScheme {
        private static final Color mainUltraLightColor = Color.decode("#FBFBFC");
        private static final Color mainExtraLightColor = Color.decode("#F4F7FC");
        private static final Color mainLightColor = Color.decode("#F1F2F4");
        private static final Color mainMidColor = Color.decode("#D6D9DF");
        private static final Color mainDarkColor = Color.decode("#95989E");
        private static final Color mainUltraDarkColor = Color.decode("#75787E");
        private static final Color foregroundColor = Color.decode("#2A2E36");

        public DefaultScheme() {
            super("Nebula Default");
        }

        @Override
        public Color getForegroundColor() {
            return foregroundColor;
        }

        @Override
        public Color getUltraLightColor() {
            return mainUltraLightColor;
        }

        @Override
        public Color getExtraLightColor() {
            return mainExtraLightColor;
        }

        @Override
        public Color getLightColor() {
            return mainLightColor;
        }

        @Override
        public Color getMidColor() {
            return mainMidColor;
        }

        @Override
        public Color getDarkColor() {
            return mainDarkColor;
        }

        @Override
        public Color getUltraDarkColor() {
            return mainUltraDarkColor;
        }
    }

    protected static class ActiveScheme
    extends BaseLightColorScheme {
        private static final Color mainUltraLightColor = Color.decode("#F6F8FA");
        private static final Color mainExtraLightColor = Color.decode("#DFE6ED");
        private static final Color mainLightColor = Color.decode("#C1D6E9");
        private static final Color mainMidColor = Color.decode("#A3B8CB");
        private static final Color mainDarkColor = Color.decode("#62778A");
        private static final Color mainUltraDarkColor = Color.decode("#42576A");
        private static final Color foregroundColor = Color.decode("#000000");

        public ActiveScheme() {
            super("Nebula Active");
        }

        @Override
        public Color getForegroundColor() {
            return foregroundColor;
        }

        @Override
        public Color getUltraLightColor() {
            return mainUltraLightColor;
        }

        @Override
        public Color getExtraLightColor() {
            return mainExtraLightColor;
        }

        @Override
        public Color getLightColor() {
            return mainLightColor;
        }

        @Override
        public Color getMidColor() {
            return mainMidColor;
        }

        @Override
        public Color getDarkColor() {
            return mainDarkColor;
        }

        @Override
        public Color getUltraDarkColor() {
            return mainUltraDarkColor;
        }
    }
}

