/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.skin;

import java.awt.Color;
import org.jvnet.substance.api.SubstanceColorScheme;
import org.jvnet.substance.api.SubstanceColorSchemeBundle;
import org.jvnet.substance.api.SubstanceSkin;
import org.jvnet.substance.colorscheme.BaseLightColorScheme;
import org.jvnet.substance.colorscheme.LightGrayColorScheme;
import org.jvnet.substance.colorscheme.MetallicColorScheme;
import org.jvnet.substance.colorscheme.SteelBlueColorScheme;
import org.jvnet.substance.painter.border.ClassicBorderPainter;
import org.jvnet.substance.painter.decoration.DecorationAreaType;
import org.jvnet.substance.painter.decoration.MatteDecorationPainter;
import org.jvnet.substance.painter.gradient.MatteGradientPainter;
import org.jvnet.substance.painter.highlight.ClassicHighlightPainter;
import org.jvnet.substance.shaper.StandardButtonShaper;

public class MistSilverSkin
extends SubstanceSkin {
    public static String NAME = "Mist Silver";

    public MistSilverSkin() {
        SubstanceColorScheme activeScheme = new MetallicColorScheme().tint(0.1).named("Mist Silver Active");
        SubstanceColorScheme defaultScheme = new MetallicColorScheme().shade(0.05).named("Mist Silver Default");
        SubstanceColorScheme disabledScheme = new LightGrayColorScheme().tone(0.2).named("Mist Silver Disabled");
        SubstanceColorSchemeBundle defaultSchemeBundle = new SubstanceColorSchemeBundle(activeScheme, defaultScheme, disabledScheme);
        this.registerDecorationAreaSchemeBundle(defaultSchemeBundle, DecorationAreaType.NONE);
        this.registerDecorationAreaSchemeBundle(new SubstanceColorSchemeBundle(activeScheme, defaultScheme, disabledScheme), new SteelBlueColorScheme().saturate(-0.3).tint(0.5).named("Mist Silver Background"), DecorationAreaType.GENERAL);
        this.registerAsDecorationArea(defaultScheme, DecorationAreaType.PRIMARY_TITLE_PANE, DecorationAreaType.SECONDARY_TITLE_PANE, DecorationAreaType.HEADER, DecorationAreaType.FOOTER, DecorationAreaType.TOOLBAR);
        this.setSelectedTabFadeStart(0.6);
        this.setSelectedTabFadeEnd(1.0);
        this.buttonShaper = new StandardButtonShaper();
        this.gradientPainter = new MatteGradientPainter();
        this.borderPainter = new ClassicBorderPainter();
        this.decorationPainter = new MatteDecorationPainter();
        this.highlightPainter = new ClassicHighlightPainter();
    }

    @Override
    public String getDisplayName() {
        return NAME;
    }

    protected static class ActiveTitleScheme
    extends BaseLightColorScheme {
        private static final Color mainUltraLightColor = new Color(197, 197, 197);
        private static final Color mainExtraLightColor = new Color(185, 185, 185);
        private static final Color mainLightColor = new Color(170, 170, 170);
        private static final Color mainMidColor = new Color(152, 152, 152);
        private static final Color mainDarkColor = new Color(152, 152, 152);
        private static final Color mainUltraDarkColor = new Color(152, 152, 152);
        private static final Color foregroundColor = Color.decode("#000000");

        public ActiveTitleScheme() {
            super("Mist Silver Active Title");
        }

        @Override
        public Color getForegroundColor() {
            return foregroundColor;
        }

        @Override
        public Color getUltraLightColor() {
            return mainUltraLightColor;
        }

        @Override
        public Color getExtraLightColor() {
            return mainExtraLightColor;
        }

        @Override
        public Color getLightColor() {
            return mainLightColor;
        }

        @Override
        public Color getMidColor() {
            return mainMidColor;
        }

        @Override
        public Color getDarkColor() {
            return mainDarkColor;
        }

        @Override
        public Color getUltraDarkColor() {
            return mainUltraDarkColor;
        }
    }
}

