/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicRadioButtonUI;
import javax.swing.text.View;
import org.jvnet.lafwidget.animation.FadeKind;
import org.jvnet.lafwidget.animation.FadeState;
import org.jvnet.lafwidget.animation.FadeStateListener;
import org.jvnet.lafwidget.animation.FadeTracker;
import org.jvnet.lafwidget.layout.TransitionLayout;
import org.jvnet.substance.api.ComponentState;
import org.jvnet.substance.api.SubstanceColorScheme;
import org.jvnet.substance.painter.utils.SubstanceFillBackgroundDelegate;
import org.jvnet.substance.utils.HashMapKey;
import org.jvnet.substance.utils.LazyResettableHashMap;
import org.jvnet.substance.utils.RolloverButtonListener;
import org.jvnet.substance.utils.SubstanceColorSchemeUtilities;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceFadeUtilities;
import org.jvnet.substance.utils.SubstanceImageCreator;
import org.jvnet.substance.utils.SubstanceSizeUtils;
import org.jvnet.substance.utils.SubstanceTextUtilities;

public class SubstanceRadioButtonUI
extends BasicRadioButtonUI {
    protected PropertyChangeListener substancePropertyListener;
    protected JToggleButton button;
    private static LazyResettableHashMap<Icon> icons = new LazyResettableHashMap("SubstanceRadioButtonUI");
    protected FadeStateListener substanceFadeStateListener;

    @Override
    protected void installListeners(final AbstractButton b) {
        super.installListeners(b);
        this.substanceFadeStateListener = new FadeStateListener(b, b.getModel(), SubstanceCoreUtilities.getFadeCallback(b, false));
        this.substanceFadeStateListener.registerListeners();
        this.substancePropertyListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("model".equals(evt.getPropertyName())) {
                    if (SubstanceRadioButtonUI.this.substanceFadeStateListener != null) {
                        SubstanceRadioButtonUI.this.substanceFadeStateListener.unregisterListeners();
                    }
                    SubstanceRadioButtonUI.this.substanceFadeStateListener = new FadeStateListener(b, b.getModel(), SubstanceCoreUtilities.getFadeCallback(b, false));
                    SubstanceRadioButtonUI.this.substanceFadeStateListener.registerListeners();
                }
                if ("opaque".equals(evt.getPropertyName()) && !Boolean.TRUE.equals(b.getClientProperty("substancelaf.lockopacity"))) {
                    b.putClientProperty("substancelaf.buttonopacityoriginal", evt.getNewValue());
                }
                if ("font".equals(evt.getPropertyName())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            b.updateUI();
                        }
                    });
                }
            }
        };
        b.addPropertyChangeListener(this.substancePropertyListener);
    }

    @Override
    protected void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        Border border = b.getBorder();
        if (border == null || border instanceof UIResource) {
            b.setBorder(SubstanceSizeUtils.getRadioButtonBorder(SubstanceSizeUtils.getComponentFontSize(b)));
        }
        LookAndFeel.installProperty(b, "iconTextGap", SubstanceSizeUtils.getTextIconGap(SubstanceSizeUtils.getComponentFontSize(b)));
    }

    @Override
    protected void uninstallListeners(AbstractButton b) {
        this.substanceFadeStateListener.unregisterListeners();
        this.substanceFadeStateListener = null;
        b.removePropertyChangeListener(this.substancePropertyListener);
        this.substancePropertyListener = null;
        super.uninstallListeners(b);
    }

    private static Icon getIcon(JToggleButton button, ComponentState currState, ComponentState prevState) {
        int checkMarkSize;
        HashMapKey key;
        Icon result;
        float visibility = currState.isKindActive(FadeKind.SELECTION) ? 10.0f : 0.0f;
        SubstanceColorScheme scheme = SubstanceColorSchemeUtilities.getColorScheme(button, currState);
        SubstanceColorScheme scheme2 = SubstanceColorSchemeUtilities.getColorScheme(button, prevState);
        float cyclePos = 0.0f;
        FadeState fadeState = SubstanceFadeUtilities.getFadeState((Component)button, FadeKind.SELECTION, FadeKind.ROLLOVER, FadeKind.PRESS);
        if (fadeState != null) {
            cyclePos = fadeState.getFadePosition();
            if (fadeState.isFadingIn()) {
                cyclePos = 1.0f - cyclePos;
            }
            if (fadeState.fadeKind == FadeKind.SELECTION) {
                visibility = fadeState.getFadePosition();
            }
        }
        if ((result = icons.get(key = SubstanceCoreUtilities.getHashKey(checkMarkSize = SubstanceSizeUtils.getRadioButtonMarkSize(SubstanceSizeUtils.getComponentFontSize(button)), currState.name(), currState.name(), scheme.getDisplayName(), scheme2.getDisplayName(), Float.valueOf(cyclePos), Float.valueOf(visibility)))) != null) {
            return result;
        }
        result = new ImageIcon(SubstanceImageCreator.getRadioButton(button, checkMarkSize, currState, prevState, 0, scheme, scheme2, cyclePos, visibility / 10.0f));
        icons.put(key, result);
        return result;
    }

    public static ComponentUI createUI(JComponent comp) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(comp);
        return new SubstanceRadioButtonUI((JToggleButton)comp);
    }

    public SubstanceRadioButtonUI(JToggleButton button) {
        this.button = button;
        button.setRolloverEnabled(true);
    }

    @Override
    protected BasicButtonListener createButtonListener(AbstractButton b) {
        return new RolloverButtonListener(b);
    }

    @Override
    public Icon getDefaultIcon() {
        ComponentState currState = ComponentState.getState(this.button);
        ComponentState prevState = SubstanceCoreUtilities.getPrevComponentState(this.button);
        return SubstanceRadioButtonUI.getIcon(this.button, currState, prevState);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        AbstractButton b = (AbstractButton)c;
        boolean isOpaque = b.isOpaque();
        b.putClientProperty("substancelaf.lockopacity", Boolean.TRUE);
        b.setOpaque(false);
        if (isOpaque || TransitionLayout.isOpaque(c)) {
            SubstanceFillBackgroundDelegate.GLOBAL_INSTANCE.update(g, c, false);
        }
        b.setOpaque(isOpaque);
        b.putClientProperty("substancelaf.lockopacity", null);
        FontMetrics fm = g.getFontMetrics();
        Insets i = b.getInsets();
        Rectangle viewRect = new Rectangle();
        Rectangle iconRect = new Rectangle();
        Rectangle textRect = new Rectangle();
        viewRect.x = i.left;
        viewRect.y = i.top;
        viewRect.width = b.getWidth() - (i.right + viewRect.x);
        viewRect.height = b.getHeight() - (i.bottom + viewRect.y);
        textRect.height = 0;
        textRect.width = 0;
        textRect.y = 0;
        textRect.x = 0;
        iconRect.height = 0;
        iconRect.width = 0;
        iconRect.y = 0;
        iconRect.x = 0;
        Font f = b.getFont();
        g.setFont(f);
        Icon icon = SubstanceCoreUtilities.getIcon(b, this.getDefaultIcon(), null, false);
        String text = SwingUtilities.layoutCompoundLabel(c, fm, b.getText(), icon, b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, b.getText() == null ? 0 : b.getIconTextGap());
        Graphics2D g2d = (Graphics2D)g.create();
        if (text != null && !text.equals("")) {
            View v = (View)b.getClientProperty("html");
            if (v != null) {
                v.paint(g2d, textRect);
            } else {
                this.paintButtonText(g2d, b, textRect, text);
            }
        }
        if (icon != null) {
            icon.paintIcon(c, g2d, iconRect.x, iconRect.y);
        }
        if (b.isFocusPainted() && (b.hasFocus() || FadeTracker.getInstance().isTracked(c, FadeKind.FOCUS))) {
            int focusRingPadding = SubstanceSizeUtils.getFocusRingPadding(SubstanceSizeUtils.getComponentFontSize(this.button)) / 2;
            SubstanceCoreUtilities.paintFocus(g2d, this.button, this.button, null, textRect, 1.0f, focusRingPadding);
        }
        g2d.dispose();
    }

    public static String getMemoryUsage() {
        StringBuffer sb = new StringBuffer();
        sb.append("SubstanceRadioButtonUI: \n");
        sb.append("\t" + icons.size() + " icons");
        return sb.toString();
    }

    protected void paintButtonText(Graphics g, AbstractButton button, Rectangle textRect, String text) {
        SubstanceTextUtilities.paintText(g, button, textRect, text, button.getDisplayedMnemonicIndex());
    }
}

