/*
 * Decompiled with CFR 0.152.
 */
package holmes.workspace;

import com.javadocking.dock.CompositeTabDock;
import com.javadocking.dock.Dock;
import com.javadocking.dock.Position;
import com.javadocking.dock.factory.DockFactory;
import com.javadocking.dockable.DefaultDockable;
import com.javadocking.dockable.Dockable;
import holmes.darkgui.GUIManager;
import holmes.graphpanel.GraphPanel;
import holmes.graphpanel.SelectionActionListener;
import holmes.petrinet.data.IdGenerator;
import holmes.petrinet.data.PetriNet;
import holmes.petrinet.elements.MetaNode;
import holmes.workspace.WorkspaceFiller;
import holmes.workspace.WorkspaceSheet;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.util.ArrayList;
import javax.swing.JOptionPane;

public class Workspace
implements SelectionActionListener {
    private DockFactory dockFactory;
    private ArrayList<Dockable> dockables;
    private ArrayList<Dock> docks;
    private ArrayList<WorkspaceSheet> sheets;
    private ArrayList<Integer> sheetsIDtable;
    private Dock fillerDock;
    private Dockable fillerDockable;
    private PetriNet project;
    private GUIManager overlord;
    private CompositeTabDock workspaceDock;

    public Workspace(GUIManager gui) {
        this.setWorkspaceDock(new CompositeTabDock());
        this.overlord = gui;
        this.setDockFactory(this.getWorkspaceDock().getChildDockFactory());
        this.dockables = new ArrayList();
        this.docks = new ArrayList();
        this.sheets = new ArrayList();
        this.sheetsIDtable = new ArrayList();
        this.setFillerDockable(new DefaultDockable("Workspace", new WorkspaceFiller(), "Workspace"));
        this.setFillerDock(this.getDockFactory().createDock(this.getFillerDockable(), 64));
        Point position = new Point(0, 0);
        this.getFillerDock().addDockable(this.getFillerDockable(), position, position);
        this.setProject(new PetriNet(this, "default"));
        this.getProject().addActionListener(this);
        this.newTab(false, new Point(0, 0), 1, MetaNode.MetaType.SUBNET);
    }

    public void redockSheets() {
        boolean i = false;
        Point position = new Point(0, 0);
        CompositeTabDock ctd = this.getWorkspaceDock();
        int ile = ctd.getChildDockCount();
        for (Dock dock : this.docks) {
            CompositeTabDock parent = (CompositeTabDock)dock.getParentDock();
            Container cont = ((Component)((Object)dock)).getParent();
            boolean bl = true;
        }
    }

    public int newTab(boolean addMetaNode, Point pos, int whichSubnet, MetaNode.MetaType type) {
        int index = this.sheetsIDtable.size();
        int id = index;
        if (this.sheetsIDtable.contains(id)) {
            id = this.getMaximumSubnetID() + 1;
        }
        Point position = new Point(0, 0);
        this.sheetsIDtable.add(id);
        this.sheets.add(new WorkspaceSheet("I am sheet " + id, id, this));
        DefaultDockable tempDockable = new DefaultDockable("Sheet " + id, this.sheets.get(index), "Sheet " + id);
        this.dockables.add(index, this.withListener(tempDockable));
        this.docks.add(this.getDockFactory().createDock(this.dockables.get(index), 64));
        this.docks.get(index).addDockable(this.dockables.get(index), position, position);
        this.getWorkspaceDock().addChildDock(this.docks.get(index), new Position(index));
        this.overlord.getMenu().addSheetItem(this.dockables.get(index));
        this.overlord.globalSheetsList.add(tempDockable);
        if (addMetaNode) {
            this.addMetaNode(pos, whichSubnet, id, type);
            this.setSelectedDock(this.getIndexOfId(whichSubnet));
        }
        return id;
    }

    private void addMetaNode(Point pos, int whichSubnet, int representedSubnet, MetaNode.MetaType type) {
        MetaNode metanode = new MetaNode(whichSubnet, IdGenerator.getNextId(), pos, type);
        metanode.setRepresentedSheetID(representedSubnet);
        GUIManager.getDefaultGUIManager().getWorkspace().getProject().getNodes().add(metanode);
        GUIManager.getDefaultGUIManager().getWorkspace().getProject().repaintAllGraphPanels();
    }

    public void setGraphMode(GraphPanel.DrawModes mode) {
        this.getProject().setDrawMode(mode);
    }

    public void deleteSheetFromArrays(WorkspaceSheet sheet) {
        int sheetID = sheet.getId();
        boolean result = this.getProject().removeGraphPanel(sheetID);
        if (!result) {
            GUIManager.getDefaultGUIManager().log("Error, removing graph panel in Workspace.deleteSheetFromArrays() failedfor WorkspaceSheet " + sheet.getId(), "error", true);
        }
        int id = this.sheets.indexOf(sheet);
        this.getWorkspaceDock().emptyChild(this.docks.get(id));
        this.docks.remove(id);
        this.sheets.remove(id);
        this.sheetsIDtable.remove(id);
    }

    public void deleteTab(Dockable dockable, boolean fastMode) {
        int index = this.dockables.indexOf(dockable);
        if (fastMode) {
            int indexSh = this.sheets.get(index).getId();
            GUIManager.getDefaultGUIManager().subnetsHQ.removeMetaNode(indexSh);
            this.deleteSheetFromArrays(this.sheets.get(index));
            this.overlord.getMenu().deleteSheetItem(this.dockables.get(index));
            this.dockables.remove(dockable);
            return;
        }
        if (index == -1) {
            GUIManager.getDefaultGUIManager().cleanLostOne(dockable);
            return;
        }
        if (index == 0) {
            JOptionPane.showMessageDialog(null, "First sheet cannot be deleted. Please use clear project instead.", "Cannot proceed", 1);
            return;
        }
        int indexSheet = this.dockables.indexOf(dockable);
        int elementsNumber = GUIManager.getDefaultGUIManager().subnetsHQ.getSubnetsVector().get(indexSheet);
        if (elementsNumber > 0) {
            JOptionPane.showMessageDialog(null, "Sheet contains " + elementsNumber + " net elements that must be\n removed manually (or moved to another subnet).", "Cannot proceed", 1);
            return;
        }
        int n = JOptionPane.showOptionDialog(null, "Are you sure you want to delete this sheet? You will not be able to retrieve it later.", "Are you sure?", 0, 3, null, null, null);
        if (n == 0 && this.sheets.size() > 1) {
            int indexSh = this.sheets.get(index).getId();
            GUIManager.getDefaultGUIManager().subnetsHQ.removeMetaNode(indexSh);
            this.deleteSheetFromArrays(this.sheets.get(index));
            this.overlord.getMenu().deleteSheetItem(this.dockables.get(index));
            this.dockables.remove(dockable);
        } else {
            if (this.sheets.size() == 1 && n == 0) {
                JOptionPane.showMessageDialog(null, "Can't delete this sheet! A project must contain at least one sheet!", "Can't delete this sheet!", 0);
            }
            Point position = new Point(0, 0);
            this.dockables.set(index, this.withListener(new DefaultDockable("Sheet " + this.sheets.get(index).getId(), this.sheets.get(index), "Sheet " + this.sheets.get(index).getId())));
            this.docks.get(index).addDockable(this.dockables.get(index), position, position);
        }
    }

    private Dockable withListener(Dockable dockable) {
        Dockable wrapper = this.overlord.decorateDockableWithActions(dockable, true);
        wrapper.addDockingListener(GUIManager.getDefaultGUIManager().getDockingListener());
        return wrapper;
    }

    public void globalDeselection() {
        for (WorkspaceSheet ws : this.sheets) {
            ws.getGraphPanel().getSelectionManager().deselectAllElements();
        }
    }

    public int getMaximumSubnetID() {
        int index = 0;
        for (int x : this.sheetsIDtable) {
            if (x <= index) continue;
            index = x;
        }
        return index;
    }

    public ArrayList<Integer> accessSheetsIDtable() {
        return this.sheetsIDtable;
    }

    public ArrayList<Dockable> getDockables() {
        return this.dockables;
    }

    public ArrayList<WorkspaceSheet> getSheets() {
        return this.sheets;
    }

    public PetriNet getProject() {
        return this.project;
    }

    private void setProject(PetriNet project) {
        this.project = project;
    }

    public int getIndexOfId(int id) {
        Integer ajDi = id;
        return this.sheetsIDtable.lastIndexOf(ajDi);
    }

    @Override
    public void actionPerformed(SelectionActionListener.SelectionActionEvent e) {
        this.overlord.getPropertiesBox().selectElement(e);
        this.overlord.getSelectionBox().getSelectionPanel().actionPerformed(e);
    }

    public WorkspaceSheet getSelectedSheet() {
        try {
            int index = this.docks.indexOf(this.workspaceDock.getSelectedDock());
            return this.sheets.get(index);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setSelectedDock(int i) {
        if (i < this.docks.size()) {
            this.workspaceDock.setSelectedDock(this.docks.get(i));
        }
    }

    public CompositeTabDock getWorkspaceDock() {
        return this.workspaceDock;
    }

    private void setWorkspaceDock(CompositeTabDock workspaceDock) {
        this.workspaceDock = workspaceDock;
    }

    public void repaintAllGraphPanels() {
        this.getProject().repaintAllGraphPanels();
    }

    public Dock getFillerDock() {
        return this.fillerDock;
    }

    public void setFillerDock(Dock fillerDock) {
        this.fillerDock = fillerDock;
    }

    public Dockable getFillerDockable() {
        return this.fillerDockable;
    }

    public void setFillerDockable(Dockable fillerDockable) {
        this.fillerDockable = fillerDockable;
    }

    public DockFactory getDockFactory() {
        return this.dockFactory;
    }

    private void setDockFactory(DockFactory dockFactory) {
        this.dockFactory = dockFactory;
    }
}

