/*
 * Decompiled with CFR 0.152.
 */
package holmes.windows.xtpn;

import holmes.darkgui.GUIManager;
import holmes.darkgui.holmesInterface.HolmesRoundedButton;
import holmes.petrinet.elements.Place;
import holmes.petrinet.elements.PlaceXTPN;
import holmes.petrinet.simulators.GraphicalSimulator;
import holmes.utilities.Tools;
import holmes.windows.xtpn.HolmesNodeInfoXTPN;
import holmes.windows.xtpn.managers.HolmesStatesEditorXTPN;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class HolmesXTPNtokens
extends JFrame {
    private final GUIManager overlord = GUIManager.getDefaultGUIManager();
    private JFrame parentWindow;
    private PlaceXTPN place;
    private boolean mainSimulatorActive;
    private boolean isGammaPlace;
    private ArrayList<Double> multisetK;
    private ArrayList<Place> places;
    private boolean doNotUpdate = true;
    private JComboBox<String> tokensComboBox;
    private JLabel tokensNoLabel;
    private JLabel idTokenLabel;
    private JFormattedTextField tokenValueTextField;
    private HolmesRoundedButton changeTokenValueButton;
    private HolmesRoundedButton removeTokenValueButton;
    private JFormattedTextField addNewTextField;
    private HolmesRoundedButton clearAllButton;

    public HolmesXTPNtokens(PlaceXTPN placeObj, JFrame parent, ArrayList<Double> multK, boolean isGammaPlace) {
        this.parentWindow = parent;
        this.places = this.overlord.getWorkspace().getProject().getPlaces();
        this.place = placeObj;
        this.multisetK = multK;
        this.isGammaPlace = isGammaPlace;
        this.setTitle("XPTN-place tokens options");
        try {
            this.setIconImage(Tools.getImageFromIcon("/icons/holmesicon.png"));
        }
        catch (Exception ex) {
            GUIManager.getDefaultGUIManager().log("Error (310108837) | Exception:  " + ex.getMessage(), "error", true);
        }
        if (GUIManager.getDefaultGUIManager().getSimulatorBox().getCurrentDockWindow().getSimulator().getSimulatorStatus() != GraphicalSimulator.SimulatorMode.STOPPED) {
            this.mainSimulatorActive = true;
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                if (HolmesXTPNtokens.this.parentWindow == null) {
                    HolmesXTPNtokens.this.overlord.getFrame().setEnabled(true);
                } else if (HolmesXTPNtokens.this.parentWindow instanceof HolmesStatesEditorXTPN) {
                    ((HolmesStatesEditorXTPN)HolmesXTPNtokens.this.parentWindow).fillTable();
                    HolmesXTPNtokens.this.parentWindow.setEnabled(true);
                    ((HolmesStatesEditorXTPN)HolmesXTPNtokens.this.parentWindow).doNotUpdate = false;
                } else if (HolmesXTPNtokens.this.parentWindow instanceof HolmesNodeInfoXTPN) {
                    HolmesXTPNtokens.this.parentWindow.setEnabled(true);
                }
            }
        });
        if (this.mainSimulatorActive) {
            JOptionPane.showMessageDialog(null, "Window unavailable when simulator is working.", "Error: simulation in progress", 0);
            this.dispatchEvent(new WindowEvent(this, 201));
        } else {
            if (this.parentWindow == null) {
                this.overlord.getFrame().setEnabled(false);
            } else if (this.parentWindow instanceof HolmesStatesEditorXTPN) {
                this.parentWindow.setEnabled(false);
                ((HolmesStatesEditorXTPN)this.parentWindow).doNotUpdate = true;
            } else if (this.parentWindow instanceof HolmesNodeInfoXTPN) {
                this.parentWindow.setEnabled(false);
            }
            this.setResizable(false);
            this.initializeComponents();
            if (parent != null) {
                this.setLocationRelativeTo(parent);
            } else {
                int x = this.place.getElementLocations().get((int)0).getPosition().x;
                int y = this.place.getElementLocations().get((int)0).getPosition().y;
                this.setLocation(x += 250, y);
            }
            this.setVisible(true);
        }
    }

    private void initializeComponents() {
        this.setLocation(20, 20);
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(380, 180));
        this.setLocation(50, 50);
        this.setResizable(false);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(null);
        mainPanel.setBounds(0, 0, 380, 180);
        mainPanel.setLocation(0, 0);
        mainPanel.add(this.createMainPanel());
        mainPanel.setBackground(Color.WHITE);
        this.add((Component)mainPanel, "Center");
    }

    private JPanel createMainPanel() {
        JPanel comboPanel = new JPanel();
        comboPanel.setLayout(null);
        comboPanel.setBounds(2, 0, 364, 143);
        comboPanel.setBorder(BorderFactory.createTitledBorder("Tokens:"));
        comboPanel.setBackground(Color.WHITE);
        this.doNotUpdate = false;
        int comboPanelX = 0;
        int comboPanelY = 0;
        String[] dataP = new String[]{"---"};
        this.tokensComboBox = new JComboBox<String>(dataP);
        this.tokensComboBox.setLocation(comboPanelX + 10, comboPanelY += 20);
        this.tokensComboBox.setSize(180, 20);
        this.tokensComboBox.setSelectedIndex(0);
        this.tokensComboBox.setMaximumRowCount(10);
        this.tokensComboBox.setBackground(Color.WHITE);
        this.tokensComboBox.addActionListener(actionEvent -> {
            if (!this.doNotUpdate) {
                return;
            }
            int selected = this.tokensComboBox.getSelectedIndex();
            this.idTokenLabel.setText("ID: " + selected);
            if (selected >= 0) {
                if (this.parentWindow == null) {
                    this.tokenValueTextField.setValue(this.place.accessMultiset().get(selected));
                } else if (this.parentWindow instanceof HolmesStatesEditorXTPN) {
                    this.tokenValueTextField.setValue(this.multisetK.get(selected));
                } else if (this.parentWindow instanceof HolmesNodeInfoXTPN) {
                    this.parentWindow.setEnabled(false);
                }
            }
        });
        comboPanel.add(this.tokensComboBox);
        this.recreateComboBox();
        this.tokensNoLabel = new JLabel("Tokens:" + this.place.getTokensNumber(), 2);
        this.tokensNoLabel.setLocation(comboPanelX + 200, comboPanelY);
        this.tokensNoLabel.setSize(90, 20);
        comboPanel.add(this.tokensNoLabel);
        this.idTokenLabel = new JLabel("ID: " + this.tokensComboBox.getSelectedIndex(), 2);
        this.idTokenLabel.setLocation(comboPanelX + 10, comboPanelY += 30);
        this.idTokenLabel.setSize(50, 20);
        comboPanel.add(this.idTokenLabel);
        NumberFormat formatter = DecimalFormat.getInstance();
        formatter.setMinimumFractionDigits(1);
        formatter.setMaximumFractionDigits(this.place.getFractionForPlaceXTPN());
        formatter.setRoundingMode(RoundingMode.HALF_UP);
        this.tokenValueTextField = new JFormattedTextField(formatter);
        this.tokenValueTextField.setValue(0.0);
        this.tokenValueTextField.setBounds(comboPanelX + 50, comboPanelY, 100, 20);
        this.tokenValueTextField.addPropertyChangeListener("value", e -> {
            if (!this.doNotUpdate) {
                return;
            }
            JFormattedTextField field = (JFormattedTextField)e.getSource();
            try {
                field.commitEdit();
            }
            catch (ParseException ex) {
                this.overlord.log("Exception: " + ex, "error", true);
                System.out.println(ex.getMessage());
            }
        });
        comboPanel.add(this.tokenValueTextField);
        this.changeTokenValueButton = new HolmesRoundedButton("Change value", "pearl_bH1_neutr.png", "pearl_bH2_hover.png", "pearl_bH3_press.png");
        this.changeTokenValueButton.setMargin(new Insets(0, 0, 0, 0));
        this.changeTokenValueButton.setBounds(comboPanelX + 150, comboPanelY - 5, 100, 30);
        this.changeTokenValueButton.setFocusPainted(false);
        this.changeTokenValueButton.addActionListener(e -> {
            if (!this.doNotUpdate) {
                return;
            }
            int selected = this.tokensComboBox.getSelectedIndex();
            if (selected == -1) {
                return;
            }
            try {
                String text = this.tokenValueTextField.getValue().toString();
                double val = Double.parseDouble(text);
                if (val < 0.0) {
                    val = 0.0;
                }
                this.doNotUpdate = false;
                if (this.parentWindow == null) {
                    this.place.updateToken_XTPN(selected, val);
                    GUIManager.getDefaultGUIManager().getWorkspace().getProject().repaintAllGraphPanels();
                } else if (this.parentWindow instanceof HolmesStatesEditorXTPN) {
                    this.multisetK.set(selected, val);
                    Collections.sort(this.multisetK);
                    Collections.reverse(this.multisetK);
                } else if (this.parentWindow instanceof HolmesNodeInfoXTPN) {
                    this.parentWindow.setEnabled(true);
                }
                this.recreateComboBox();
                this.tokensComboBox.setSelectedIndex(selected);
                this.doNotUpdate = true;
            }
            catch (Exception exc) {
                JOptionPane.showMessageDialog(null, "Cannot convert " + this.tokenValueTextField.getValue() + " into Double", "Conversion eror", 0);
            }
        });
        comboPanel.add(this.changeTokenValueButton);
        this.removeTokenValueButton = new HolmesRoundedButton("Remove", "pearl_bH1_neutr.png", "pearl_bH2_hover.png", "pearl_bH3_press.png");
        this.removeTokenValueButton.setMargin(new Insets(0, 0, 0, 0));
        this.removeTokenValueButton.setBounds(comboPanelX + 250, comboPanelY - 5, 100, 30);
        this.removeTokenValueButton.setFocusPainted(false);
        this.removeTokenValueButton.addActionListener(e -> {
            if (!this.doNotUpdate) {
                return;
            }
            int selected = this.tokensComboBox.getSelectedIndex();
            if (selected == -1) {
                return;
            }
            try {
                this.doNotUpdate = false;
                if (this.isGammaPlace) {
                    if (this.parentWindow == null) {
                        this.place.removeTokenByID_XTPN(selected);
                        GUIManager.getDefaultGUIManager().getWorkspace().getProject().repaintAllGraphPanels();
                    } else if (this.parentWindow instanceof HolmesStatesEditorXTPN) {
                        if (selected > -1 && selected < this.multisetK.size()) {
                            this.multisetK.remove(selected);
                        } else {
                            this.overlord.log("Error while removing token no. " + selected + "from state for place " + this.places.indexOf(this.place), "error", true);
                        }
                    } else if (this.parentWindow instanceof HolmesNodeInfoXTPN) {
                        ((HolmesNodeInfoXTPN)this.parentWindow).printTokenNumber();
                    }
                } else if (this.parentWindow == null) {
                    this.place.modifyTokensNumber(-1);
                    GUIManager.getDefaultGUIManager().getWorkspace().getProject().repaintAllGraphPanels();
                } else if (this.parentWindow instanceof HolmesStatesEditorXTPN) {
                    if (selected > -1 && selected < this.multisetK.size()) {
                        double tokensNumber = this.multisetK.get(0);
                        int tokens = (int)tokensNumber;
                        if (tokens >= 0) {
                            this.multisetK.set(0, tokensNumber -= 1.0);
                        }
                    } else {
                        this.overlord.log("Error while removing token no. " + selected + "from state for place " + this.places.indexOf(this.place), "error", true);
                    }
                } else if (this.parentWindow instanceof HolmesNodeInfoXTPN) {
                    ((HolmesNodeInfoXTPN)this.parentWindow).printTokenNumber();
                }
                this.recreateComboBox();
                this.writeTokensNumberInLabel();
                this.checkInterfaceConditions();
                this.doNotUpdate = true;
                if (this.isGammaPlace && this.multisetK.size() != 0) {
                    this.tokensComboBox.setSelectedIndex(0);
                }
            }
            catch (Exception exc) {
                JOptionPane.showMessageDialog(null, "Cannot convert " + this.tokenValueTextField.getValue() + " into Double", "Conversion eror", 0);
            }
        });
        comboPanel.add(this.removeTokenValueButton);
        JLabel addNewLabel = new JLabel("New:", 2);
        addNewLabel.setBounds(comboPanelX + 10, comboPanelY += 30, 50, 20);
        comboPanel.add(addNewLabel);
        this.addNewTextField = new JFormattedTextField(formatter);
        this.addNewTextField.setValue(0.0);
        this.addNewTextField.setBounds(comboPanelX + 50, comboPanelY, 100, 20);
        this.addNewTextField.addPropertyChangeListener("value", e -> {
            if (!this.doNotUpdate) {
                return;
            }
            JFormattedTextField field = (JFormattedTextField)e.getSource();
            try {
                field.commitEdit();
            }
            catch (ParseException ex) {
                this.overlord.log("Exception: " + ex, "error", true);
                System.out.println(ex.getMessage());
            }
        });
        comboPanel.add(this.addNewTextField);
        HolmesRoundedButton addNewTokenButton = new HolmesRoundedButton("Add new token", "pearl_bH1_neutr.png", "pearl_bH2_hover.png", "pearl_bH3_press.png");
        addNewTokenButton.setBounds(comboPanelX + 150, comboPanelY - 5, 100, 30);
        addNewTokenButton.setMargin(new Insets(0, 0, 0, 0));
        addNewTokenButton.setFocusPainted(false);
        addNewTokenButton.addActionListener(e -> {
            if (!this.doNotUpdate) {
                return;
            }
            try {
                if (this.isGammaPlace) {
                    String text = this.addNewTextField.getValue().toString();
                    double val = Double.parseDouble(text);
                    if (val < 0.0) {
                        val = 0.0;
                    }
                    if (this.parentWindow == null) {
                        this.place.addTokens_XTPN(1, val);
                        GUIManager.getDefaultGUIManager().getWorkspace().getProject().repaintAllGraphPanels();
                    } else if (this.parentWindow instanceof HolmesStatesEditorXTPN) {
                        this.multisetK.add(val);
                        if (val > 0.0) {
                            Collections.sort(this.multisetK);
                            Collections.reverse(this.multisetK);
                        }
                    } else if (this.parentWindow instanceof HolmesNodeInfoXTPN) {
                        ((HolmesNodeInfoXTPN)this.parentWindow).printTokenNumber();
                    }
                    this.recreateComboBox();
                    this.writeTokensNumberInLabel();
                    this.checkInterfaceConditions();
                    this.tokensComboBox.setSelectedIndex(0);
                } else {
                    if (this.parentWindow == null) {
                        this.place.addTokens_XTPN(1, 0.0);
                        GUIManager.getDefaultGUIManager().getWorkspace().getProject().repaintAllGraphPanels();
                    } else if (this.parentWindow instanceof HolmesStatesEditorXTPN) {
                        double tokensNumber = this.multisetK.get(0);
                        this.multisetK.set(0, tokensNumber += 1.0);
                    } else if (this.parentWindow instanceof HolmesNodeInfoXTPN) {
                        ((HolmesNodeInfoXTPN)this.parentWindow).printTokenNumber();
                    }
                    this.checkInterfaceConditions();
                    this.writeTokensNumberInLabel();
                }
            }
            catch (Exception exc) {
                JOptionPane.showMessageDialog(null, "Cannot convert " + this.tokenValueTextField.getValue() + " into Double", "Conversion eror", 0);
            }
        });
        comboPanel.add(addNewTokenButton);
        this.clearAllButton = new HolmesRoundedButton("Clear all", "pearl_bH1_neutr.png", "pearl_bH2_hover.png", "pearl_bH3_press.png");
        this.clearAllButton.setMargin(new Insets(0, 0, 0, 0));
        this.clearAllButton.setBounds(comboPanelX + 10, comboPanelY + 25, 120, 30);
        this.clearAllButton.addActionListener(e -> {
            if (!this.doNotUpdate) {
                return;
            }
            int n = JOptionPane.showConfirmDialog(null, "This will clear all the tokens data. Continue?", "Clean warning", 0);
            if (n == 0) {
                this.doNotUpdate = false;
                if (this.parentWindow == null) {
                    this.place.accessMultiset().clear();
                    this.place.setTokensNumber(0);
                    GUIManager.getDefaultGUIManager().getWorkspace().getProject().repaintAllGraphPanels();
                } else if (this.parentWindow instanceof HolmesStatesEditorXTPN) {
                    this.multisetK.clear();
                } else if (this.parentWindow instanceof HolmesNodeInfoXTPN) {
                    ((HolmesNodeInfoXTPN)this.parentWindow).printTokenNumber();
                }
                this.checkInterfaceConditions();
                this.recreateComboBox();
                this.writeTokensNumberInLabel();
                this.doNotUpdate = true;
            }
        });
        comboPanel.add(this.clearAllButton);
        HolmesRoundedButton addMultipleTokensButton = new HolmesRoundedButton("Add #[New] tokens", "pearl_bH1_neutr.png", "pearl_bH2_hover.png", "pearl_bH3_press.png");
        addMultipleTokensButton.setBounds(comboPanelX + 130, comboPanelY + 25, 120, 30);
        addMultipleTokensButton.setMargin(new Insets(0, 0, 0, 0));
        addMultipleTokensButton.setFocusPainted(false);
        addMultipleTokensButton.addActionListener(e -> {
            if (!this.doNotUpdate) {
                return;
            }
            try {
                String text = this.addNewTextField.getValue().toString();
                double val = Double.parseDouble(text);
                if (val < 1.0) {
                    val = 1.0;
                }
                if (this.isGammaPlace) {
                    if (this.parentWindow == null) {
                        this.place.addTokens_XTPN((int)val, 0.0);
                        GUIManager.getDefaultGUIManager().getWorkspace().getProject().repaintAllGraphPanels();
                    } else if (this.parentWindow instanceof HolmesStatesEditorXTPN) {
                        int i = 0;
                        while ((double)i < val) {
                            this.multisetK.add(0.0);
                            ++i;
                        }
                    } else if (this.parentWindow instanceof HolmesNodeInfoXTPN) {
                        ((HolmesNodeInfoXTPN)this.parentWindow).printTokenNumber();
                    }
                    this.recreateComboBox();
                    this.writeTokensNumberInLabel();
                    this.checkInterfaceConditions();
                    this.tokensComboBox.setSelectedIndex(0);
                } else {
                    if (this.parentWindow == null) {
                        this.place.addTokens_XTPN((int)val, 0.0);
                        GUIManager.getDefaultGUIManager().getWorkspace().getProject().repaintAllGraphPanels();
                    } else if (this.parentWindow instanceof HolmesStatesEditorXTPN) {
                        double tokensNumber = this.multisetK.get(0);
                        this.multisetK.set(0, tokensNumber += val);
                    } else if (this.parentWindow instanceof HolmesNodeInfoXTPN) {
                        ((HolmesNodeInfoXTPN)this.parentWindow).printTokenNumber();
                    }
                    this.checkInterfaceConditions();
                    this.writeTokensNumberInLabel();
                }
            }
            catch (Exception exc) {
                JOptionPane.showMessageDialog(null, "Cannot convert " + this.tokenValueTextField.getValue() + " into Double", "Conversion eror", 0);
            }
        });
        comboPanel.add(addMultipleTokensButton);
        this.doNotUpdate = true;
        if (this.tokensComboBox.getItemCount() > 0) {
            this.tokensComboBox.setSelectedIndex(0);
        }
        this.checkInterfaceConditions();
        return comboPanel;
    }

    private void checkInterfaceConditions() {
        if (this.isGammaPlace) {
            this.tokensComboBox.setEnabled(true);
            if (this.tokensComboBox.getItemCount() > 0) {
                this.tokenValueTextField.setEnabled(true);
                this.changeTokenValueButton.setEnabled(true);
                this.removeTokenValueButton.setEnabled(true);
                this.clearAllButton.setEnabled(true);
            } else {
                this.tokenValueTextField.setEnabled(false);
                this.changeTokenValueButton.setEnabled(false);
                this.removeTokenValueButton.setEnabled(false);
                this.clearAllButton.setEnabled(false);
            }
            this.addNewTextField.setEnabled(true);
        } else {
            this.tokenValueTextField.setEnabled(false);
            this.changeTokenValueButton.setEnabled(false);
            this.clearAllButton.setEnabled(false);
            this.removeTokenValueButton.setEnabled(true);
            this.tokensComboBox.setEnabled(false);
            this.addNewTextField.setEnabled(false);
        }
    }

    private void writeTokensNumberInLabel() {
        if (this.isGammaPlace) {
            int tokensNo = this.multisetK.size();
            this.tokensNoLabel.setText("Tokens: " + tokensNo);
            if (this.parentWindow == null && tokensNo != this.place.getTokensNumber()) {
                this.overlord.log("Error, multiset size and variable tokenNumber missmatch for place p_" + this.place.getID(), "error", true);
            }
        } else {
            double tokensNo = this.multisetK.get(0);
            this.tokensNoLabel.setText("Tokens: " + (int)tokensNo);
            if (this.parentWindow == null && tokensNo != (double)this.place.getTokensNumber()) {
                this.overlord.log("Error, classical place tokens number in a multiset at .get(0) and variable tokenNumber missmatch for place p_" + this.place.getID(), "error", true);
            }
        }
    }

    private void recreateComboBox() {
        this.tokensComboBox.removeAllItems();
        if (this.parentWindow == null) {
            for (int p = 0; p < this.place.accessMultiset().size(); ++p) {
                double token = this.place.accessMultiset().get(p);
                this.tokensComboBox.addItem("(\u03ba" + p + ")  " + Tools.cutValueExt(token, this.place.getFractionForPlaceXTPN()));
            }
        } else if (this.parentWindow instanceof HolmesStatesEditorXTPN) {
            for (int p = 0; p < this.multisetK.size(); ++p) {
                double token = this.multisetK.get(p);
                this.tokensComboBox.addItem("(\u03ba" + p + ")  " + Tools.cutValueExt(token, this.place.getFractionForPlaceXTPN()));
            }
        } else if (this.parentWindow instanceof HolmesNodeInfoXTPN) {
            // empty if block
        }
    }
}

