/*
 * Decompiled with CFR 0.152.
 */
package holmes.windows.xtpn;

import holmes.darkgui.GUIManager;
import holmes.darkgui.holmesInterface.HolmesRoundedButton;
import holmes.petrinet.elements.Place;
import holmes.petrinet.elements.Transition;
import holmes.petrinet.simulators.GraphicalSimulator;
import holmes.petrinet.simulators.xtpn.GraphicalSimulatorXTPN;
import holmes.petrinet.simulators.xtpn.StateSimDataContainer;
import holmes.petrinet.simulators.xtpn.StateSimulatorXTPN;
import holmes.utilities.Tools;
import holmes.windows.HolmesNotepad;
import holmes.windows.managers.HolmesStatesManager;
import holmes.windows.xtpn.HolmesSimXTPNActions;
import holmes.workspace.ExtensionFileFilter;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class HolmesSimXTPN
extends JFrame {
    private static final long serialVersionUID = 5381991734385357453L;
    private JFrame ego;
    private GUIManager overlord;
    private HolmesSimXTPNActions action = new HolmesSimXTPNActions();
    private StateSimulatorXTPN ssim;
    public boolean doNotUpdate = false;
    private JProgressBar progressBar;
    private int transInterval = 100;
    private int placesStepsInterval = 100;
    private int placesTimeInterval = 10;
    private boolean sortedP = false;
    private boolean sortedT = false;
    private ArrayList<Integer> placesInChart;
    private ArrayList<String> placesInChartStr;
    private ArrayList<Integer> transInChart;
    private ArrayList<String> transInChartStr;
    private XYSeriesCollection placesSeriesDataSet = null;
    private XYSeriesCollection transitionsSeriesDataSet = null;
    private JFreeChart placesChart;
    private JFreeChart transitionsChart;
    private int transChartType = 0;
    private int placesChartType = 0;
    private JPanel placesJPanel;
    private JPanel transitionsJPanel;
    private JSpinner transIntervalSpinner;
    private JSpinner placesStepsIntervalSpinner;
    private JSpinner placesTimeIntervalSpinner;
    private SpinnerModel placeRepsSpinnerModel = null;
    private JCheckBox qSimXTPNRecordStepsCheckbox = null;
    private SpinnerModel selStepsSpinnerModel = null;
    private JCheckBox qSimXTPNCompStatsCheckbox = null;
    private SpinnerModel placeStepsSpinnerModel = null;
    private SpinnerModel intervalPlaceStepsSpinnerModel = null;
    private JCheckBox qSimXTPNStatsTimeCheckbox = null;
    private SpinnerModel placeTimeSpinnerModel = null;
    private JComboBox<String> placesCombo = null;
    private JComboBox<String> transitionsCombo = null;
    private ChartPropertiesXTPN chartDetails;
    private JLabel selStateLabel;
    private HolmesRoundedButton stateManagerButton;
    private HolmesRoundedButton acqDataButton;
    private JPanel knockoutTab;
    private boolean workInProgress;
    public JTabbedPane mainTabPanel;
    StateSimDataContainer simDataBox = new StateSimDataContainer();
    private boolean isTimeSimulationXTPN = false;
    private JLabel placeSimSteps = null;
    private JLabel placeSimTime = null;
    private JLabel placeSimCompTime = null;

    public HolmesSimXTPN(GUIManager overlord) {
        this.overlord = overlord;
        this.ego = this;
        this.ssim = new StateSimulatorXTPN();
        this.chartDetails = new ChartPropertiesXTPN();
        this.placesInChart = new ArrayList();
        this.placesInChartStr = new ArrayList();
        this.transInChart = new ArrayList();
        this.transInChartStr = new ArrayList();
        this.initializeComponents();
        this.initiateListeners();
    }

    public HolmesSimXTPN returnFrame() {
        return this;
    }

    private void initializeComponents() {
        this.setVisible(false);
        this.setTitle("State Simulator");
        this.setLocation(30, 30);
        try {
            this.setIconImage(Tools.getImageFromIcon("/icons/holmesicon.png"));
        }
        catch (Exception ex) {
            GUIManager.getDefaultGUIManager().log("Error (418594315) | Exception:  " + ex.getMessage(), "error", true);
        }
        this.setSize(new Dimension(1120, 750));
        JPanel main = new JPanel(new BorderLayout());
        this.add(main);
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab("Places dynamics", Tools.getResIcon16("/icons/stateSim/placesDyn.png"), this.createPlacesTabPanel(), "Places dynamics");
        tabbedPane.setMnemonicAt(0, 49);
        tabbedPane.addTab("Transitions dynamics", Tools.getResIcon16("/icons/stateSim/transDyn.png"), this.createTransitionsTabPanel(), "Transistions dynamics");
        tabbedPane.setMnemonicAt(1, 50);
        this.mainTabPanel = new JTabbedPane();
        JPanel firstTab = new JPanel(new BorderLayout());
        firstTab.add((Component)this.craeteDataAcquisitionPanel(), "North");
        firstTab.add((Component)tabbedPane, "Center");
        this.mainTabPanel.addTab("Standard mode", Tools.getResIcon16("/icons/stateSim/simpleSimTab.png"), firstTab, "Simple mode");
        this.knockoutTab = new JPanel();
        this.mainTabPanel.addTab("KnockoutSim", Tools.getResIcon16("/icons/stateSim/knockSimTab.png"), this.knockoutTab, "KnockoutSim");
        main.add((Component)this.mainTabPanel, "Center");
        this.repaint();
    }

    private JPanel craeteDataAcquisitionPanel() {
        JPanel dataAcquisitionPanel = new JPanel(null);
        dataAcquisitionPanel.setBackground(Color.WHITE);
        dataAcquisitionPanel.setBorder(BorderFactory.createTitledBorder("Data acquisition"));
        dataAcquisitionPanel.setPreferredSize(new Dimension(670, 110));
        int posXda = 10;
        int posYda = 20;
        this.acqDataButton = new HolmesRoundedButton("<html><center>Simulation<br>start</center></html>", "pearl_bH1_neutr.png", "pearl_bH2_hover.png", "pearl_bH3_press.png");
        this.acqDataButton.setBounds(posXda, posYda, 110, 40);
        this.acqDataButton.setMargin(new Insets(0, 0, 0, 0));
        this.acqDataButton.setFocusPainted(false);
        this.acqDataButton.setIcon(Tools.getResIcon32("/icons/stateSim/computeData.png"));
        this.acqDataButton.setToolTipText("Compute steps from zero marking through the number of states given on the right.");
        this.acqDataButton.addActionListener(actionEvent -> this.acquireDataFromSimulation());
        dataAcquisitionPanel.add(this.acqDataButton);
        HolmesRoundedButton cancelButton = new HolmesRoundedButton("<html><center>Cancel</center></html>", "pearl_bH1_neutr.png", "pearl_bH2_hover.png", "pearl_bH3_press.png");
        cancelButton.setText("<html>&nbsp;&nbsp;&nbsp;STOP&nbsp;&nbsp;&nbsp;</html>");
        cancelButton.setIcon(Tools.getResIcon32("/icons/simulationKnockout/stopIcon.png"));
        cancelButton.setBounds(posXda, posYda + 45, 110, 30);
        cancelButton.setMargin(new Insets(0, 0, 0, 0));
        cancelButton.addActionListener(actionEvent -> this.ssim.setCancelStatus(true));
        cancelButton.setFocusPainted(false);
        dataAcquisitionPanel.add(cancelButton);
        HolmesRoundedButton simSettingsButton = new HolmesRoundedButton("<html><center>Simulation<br>Settings</center></html>", "pearl_bH1_neutr.png", "pearl_bH2_hover.png", "pearl_bH3_press.png");
        simSettingsButton.setBounds(posXda + 120, posYda, 130, 40);
        simSettingsButton.setMargin(new Insets(0, 0, 0, 0));
        simSettingsButton.setFocusPainted(false);
        simSettingsButton.setIcon(Tools.getResIcon32("/icons/simSettings/setupIcon.png"));
        simSettingsButton.setToolTipText("Set simulator options.");
        simSettingsButton.setEnabled(false);
        simSettingsButton.setEnabled(false);
        dataAcquisitionPanel.add(simSettingsButton);
        this.stateManagerButton = new HolmesRoundedButton("<html><center>States<br>Manager</center></html>", "pearl_bH1_neutr.png", "pearl_bH2_hover.png", "pearl_bH3_press.png");
        this.stateManagerButton.setIcon(Tools.getResIcon32("/icons/stateManager/stManIcon.png"));
        this.stateManagerButton.setBounds(posXda + 260, posYda, 130, 40);
        this.stateManagerButton.setMargin(new Insets(0, 0, 0, 0));
        this.stateManagerButton.setFocusPainted(false);
        this.stateManagerButton.addActionListener(actionEvent -> new HolmesStatesManager());
        dataAcquisitionPanel.add(this.stateManagerButton);
        JLabel stateLabel0 = new JLabel("Selected m0 state ID: ");
        stateLabel0.setBounds(posXda + 400, posYda, 130, 20);
        dataAcquisitionPanel.add(stateLabel0);
        this.selStateLabel = new JLabel("" + this.overlord.getWorkspace().getProject().accessStatesManager().selectedStateXTPN);
        this.selStateLabel.setBounds(posXda + 530, posYda, 40, 20);
        dataAcquisitionPanel.add(this.selStateLabel);
        HolmesRoundedButton clearDataButton = new HolmesRoundedButton("<html><center>Clear all<br>data</center></html>", "pearl_bH1_neutr.png", "pearl_bH2_hover.png", "pearl_bH3_press.png");
        clearDataButton.setBounds(posXda + 550, posYda, 110, 40);
        clearDataButton.setIcon(Tools.getResIcon32("/icons/stateSim/clearData.png"));
        clearDataButton.setToolTipText("Clear all charts and data vectors. Reset simulator.");
        clearDataButton.setFocusPainted(false);
        clearDataButton.addActionListener(actionEvent -> {
            this.clearPlacesChart();
            this.clearTransitionsChart();
            this.clearAllData();
        });
        dataAcquisitionPanel.add(clearDataButton);
        this.progressBar = new JProgressBar();
        this.progressBar.setBounds(posXda + 120, posYda + 40, 540, 40);
        this.progressBar.setMaximum(100);
        this.progressBar.setMinimum(0);
        this.progressBar.setValue(0);
        this.progressBar.setStringPainted(true);
        TitledBorder border = BorderFactory.createTitledBorder("Progress");
        this.progressBar.setBorder(border);
        this.progressBar.setBackground(Color.WHITE);
        dataAcquisitionPanel.add(this.progressBar);
        JPanel XTPNoptionsPanel = new JPanel(null);
        XTPNoptionsPanel.setBackground(Color.WHITE);
        XTPNoptionsPanel.setBorder(BorderFactory.createTitledBorder("XTPN sim options"));
        XTPNoptionsPanel.setBounds(posXda + 670, posYda - 20, 380, 110);
        dataAcquisitionPanel.add(XTPNoptionsPanel);
        int internalX = 10;
        int internalY = 20;
        JLabel labelReps = new JLabel("Repetitions:");
        labelReps.setBounds(internalX, internalY, 70, 20);
        XTPNoptionsPanel.add(labelReps);
        this.placeRepsSpinnerModel = new SpinnerNumberModel(1, 1, 100, 10);
        JSpinner placesRepsSpinner = new JSpinner(this.placeRepsSpinnerModel);
        placesRepsSpinner.setBounds(internalX + 70, internalY, 50, 20);
        placesRepsSpinner.addChangeListener(e -> {
            if (this.doNotUpdate) {
                return;
            }
            JSpinner spinner = (JSpinner)e.getSource();
            int tmp = (Integer)spinner.getValue();
            this.overlord.simSettings.setSimRepetitions_XTPN(tmp);
        });
        XTPNoptionsPanel.add(placesRepsSpinner);
        this.qSimXTPNRecordStepsCheckbox = new JCheckBox("Sel. steps");
        this.qSimXTPNRecordStepsCheckbox.setBackground(Color.WHITE);
        this.qSimXTPNRecordStepsCheckbox.setBounds(internalX + 130, internalY, 90, 20);
        this.qSimXTPNRecordStepsCheckbox.setSelected(this.overlord.simSettings.isTimeSimulation_XTPN());
        this.qSimXTPNRecordStepsCheckbox.addItemListener(e -> {
            if (this.doNotUpdate) {
                return;
            }
            JCheckBox box = (JCheckBox)e.getSource();
            this.overlord.simSettings.setPartialRecordingStetsStatus(box.isSelected());
        });
        XTPNoptionsPanel.add(this.qSimXTPNRecordStepsCheckbox);
        this.selStepsSpinnerModel = new SpinnerNumberModel(10, 2, 100, 10);
        JSpinner selStepsSpinner = new JSpinner(this.selStepsSpinnerModel);
        selStepsSpinner.setBounds(internalX + 220, internalY, 50, 20);
        selStepsSpinner.addChangeListener(e -> {
            if (this.doNotUpdate) {
                return;
            }
            JSpinner spinner = (JSpinner)e.getSource();
            int tmp = (Integer)spinner.getValue();
            this.overlord.simSettings.setRecordedSteps(tmp);
        });
        XTPNoptionsPanel.add(selStepsSpinner);
        this.qSimXTPNCompStatsCheckbox = new JCheckBox("Comp. stats");
        this.qSimXTPNCompStatsCheckbox.setBackground(Color.WHITE);
        this.qSimXTPNCompStatsCheckbox.setBounds(internalX + 130, internalY, 90, 20);
        this.qSimXTPNCompStatsCheckbox.setSelected(this.overlord.simSettings.isTimeSimulation_XTPN());
        this.qSimXTPNCompStatsCheckbox.addItemListener(e -> {
            if (this.doNotUpdate) {
                return;
            }
            JCheckBox box = (JCheckBox)e.getSource();
            this.overlord.simSettings.setStatsRecordingStatus(box.isSelected());
        });
        XTPNoptionsPanel.add(this.qSimXTPNCompStatsCheckbox);
        JLabel labelSteps = new JLabel("Steps:");
        labelSteps.setBounds(internalX, internalY += 20, 40, 20);
        XTPNoptionsPanel.add(labelSteps);
        long stepValue = this.overlord.simSettings.getSimSteps_XTPN();
        this.placeStepsSpinnerModel = new SpinnerNumberModel((int)stepValue, 0, 100000000, 10000);
        JSpinner placesStepsSpinner = new JSpinner(this.placeStepsSpinnerModel);
        placesStepsSpinner.setBounds(internalX + 45, internalY, 90, 20);
        placesStepsSpinner.addChangeListener(e -> {
            JSpinner spinner = (JSpinner)e.getSource();
            int tmp = (Integer)spinner.getValue();
            this.overlord.simSettings.setSimSteps_XTPN(tmp);
        });
        XTPNoptionsPanel.add(placesStepsSpinner);
        JLabel labelPInterval = new JLabel("Interval:");
        labelPInterval.setBounds(internalX + 140, internalY, 50, 20);
        XTPNoptionsPanel.add(labelPInterval);
        int placeStepsInterval = (int)this.overlord.simSettings.getSimSteps_XTPN() / 10;
        this.intervalPlaceStepsSpinnerModel = new SpinnerNumberModel(this.placesStepsInterval, 0, placeStepsInterval, 100);
        this.placesStepsIntervalSpinner = new JSpinner(this.intervalPlaceStepsSpinnerModel);
        this.placesStepsIntervalSpinner.setBounds(internalX + 190, internalY, 60, 20);
        this.placesStepsIntervalSpinner.addChangeListener(e -> {
            int tmp;
            if (this.doNotUpdate) {
                return;
            }
            JSpinner spinner = (JSpinner)e.getSource();
            this.placesStepsInterval = tmp = ((Integer)spinner.getValue()).intValue();
            this.clearPlacesChart();
        });
        XTPNoptionsPanel.add(this.placesStepsIntervalSpinner);
        this.qSimXTPNStatsTimeCheckbox = new JCheckBox("Time simulation");
        this.qSimXTPNStatsTimeCheckbox.setBackground(Color.WHITE);
        this.qSimXTPNStatsTimeCheckbox.setBounds(internalX, internalY += 20, 120, 20);
        this.qSimXTPNStatsTimeCheckbox.setSelected(this.overlord.simSettings.isTimeSimulation_XTPN());
        this.qSimXTPNStatsTimeCheckbox.addItemListener(e -> {
            if (this.doNotUpdate) {
                return;
            }
            JCheckBox box = (JCheckBox)e.getSource();
            this.overlord.simSettings.setTimeSimulationStatus_XTPN(box.isSelected());
        });
        XTPNoptionsPanel.add(this.qSimXTPNStatsTimeCheckbox);
        JLabel labelTime = new JLabel("Time:");
        labelTime.setBounds(internalX, internalY += 20, 40, 20);
        XTPNoptionsPanel.add(labelTime);
        double timeValue = this.overlord.simSettings.getSimTime_XTPN();
        this.placeTimeSpinnerModel = new SpinnerNumberModel((int)timeValue, 0, 1000000, 5000);
        JSpinner placesTimeSpinner = new JSpinner(this.placeTimeSpinnerModel);
        placesTimeSpinner.setBounds(internalX + 45, internalY, 90, 20);
        placesTimeSpinner.addChangeListener(e -> {
            JSpinner spinner = (JSpinner)e.getSource();
            int tmp = (Integer)spinner.getValue();
            this.overlord.simSettings.setSimTime_XTPN(tmp);
        });
        XTPNoptionsPanel.add(placesTimeSpinner);
        JLabel labelPTimeInterval = new JLabel("Interval:");
        labelPTimeInterval.setBounds(internalX + 140, internalY, 50, 20);
        XTPNoptionsPanel.add(labelPTimeInterval);
        int placeTimeMaxInterval = (int)this.overlord.simSettings.getSimTime_XTPN() / 100;
        SpinnerNumberModel intervalPlaceTimeSpinnerModel = new SpinnerNumberModel(this.placesTimeInterval, 0, placeTimeMaxInterval, 10);
        this.placesTimeIntervalSpinner = new JSpinner(intervalPlaceTimeSpinnerModel);
        this.placesTimeIntervalSpinner.setBounds(internalX + 190, internalY, 60, 20);
        this.placesTimeIntervalSpinner.addChangeListener(e -> {
            int tmp;
            JSpinner spinner = (JSpinner)e.getSource();
            this.placesTimeInterval = tmp = ((Integer)spinner.getValue()).intValue();
            this.clearPlacesChart();
        });
        XTPNoptionsPanel.add(this.placesTimeIntervalSpinner);
        return dataAcquisitionPanel;
    }

    private JPanel createPlacesTabPanel() {
        JPanel result = new JPanel(new BorderLayout());
        result.setBackground(Color.WHITE);
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.setBackground(Color.WHITE);
        result.add((Component)topPanel, "First");
        JPanel placesChartOptionsPanel = new JPanel(null);
        placesChartOptionsPanel.setBackground(Color.WHITE);
        placesChartOptionsPanel.setBorder(BorderFactory.createTitledBorder("Places chart options"));
        placesChartOptionsPanel.setPreferredSize(new Dimension(500, 120));
        int posXchart = 10;
        int posYchart = 20;
        HolmesRoundedButton showAllButton = new HolmesRoundedButton("<html><center>Show all</center></html>", "pearl_bH1_neutr.png", "pearl_bH2_hover.png", "pearl_bH3_press.png");
        showAllButton.setBounds(posXchart, posYchart, 120, 24);
        showAllButton.setMargin(new Insets(0, 0, 0, 0));
        showAllButton.setFocusPainted(false);
        showAllButton.setIcon(Tools.getResIcon16("/icons/stateSim/showAll.png"));
        showAllButton.setToolTipText("Show average numbers of token in places through simulation steps.");
        showAllButton.addActionListener(actionEvent -> this.showAllPlacesData());
        placesChartOptionsPanel.add(showAllButton);
        HolmesRoundedButton showNotepadButton = new HolmesRoundedButton("<html><center>Show notepad</center></html>", "pearl_bH1_neutr.png", "pearl_bH2_hover.png", "pearl_bH3_press.png");
        showNotepadButton.setBounds(posXchart + 130, posYchart, 120, 24);
        showNotepadButton.setMargin(new Insets(0, 0, 0, 0));
        showNotepadButton.setFocusPainted(false);
        showNotepadButton.setIcon(Tools.getResIcon16("/icons/stateSim/showNotepad.png"));
        showNotepadButton.setToolTipText("Show average numbers of token in places through simulation steps.");
        showNotepadButton.addActionListener(actionEvent -> this.showPlacesAllInNotepad());
        placesChartOptionsPanel.add(showNotepadButton);
        placesChartOptionsPanel.setEnabled(false);
        JCheckBox sortedCheckBox = new JCheckBox("Sorted by tokens");
        sortedCheckBox.setBounds(posXchart + 460, posYchart + 10, 130, 20);
        sortedCheckBox.setBackground(Color.WHITE);
        sortedCheckBox.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            this.sortedP = abstractButton.getModel().isSelected();
            this.fillPlacesAndTransitionsData();
        });
        placesChartOptionsPanel.add(sortedCheckBox);
        JLabel label1 = new JLabel("Places:");
        label1.setBounds(posXchart, posYchart += 30, 70, 20);
        placesChartOptionsPanel.add(label1);
        String[] dataP = new String[]{"---"};
        this.placesCombo = new JComboBox<String>(dataP);
        this.placesCombo.setLocation(posXchart + 75, posYchart + 2);
        this.placesCombo.setSize(500, 20);
        this.placesCombo.setSelectedIndex(0);
        this.placesCombo.setMaximumRowCount(12);
        this.placesCombo.addActionListener(actionEvent -> {});
        placesChartOptionsPanel.add(this.placesCombo);
        HolmesRoundedButton addPlaceButton = new HolmesRoundedButton("<html><center>Add to chart</center></html>", "pearl_bH1_neutr.png", "pearl_bH2_hover.png", "pearl_bH3_press.png");
        addPlaceButton.setBounds(posXchart, (posYchart += 30) + 2, 110, 24);
        addPlaceButton.setMargin(new Insets(0, 0, 0, 0));
        addPlaceButton.setFocusPainted(false);
        addPlaceButton.setIcon(Tools.getResIcon16("/icons/stateSim/addChart.png"));
        addPlaceButton.setToolTipText("Add data about place tokens to the chart.");
        addPlaceButton.addActionListener(actionEvent -> {
            if (this.simDataBox == null) {
                return;
            }
            int selected = this.placesCombo.getSelectedIndex();
            if (selected > 0) {
                String name = this.placesCombo.getSelectedItem().toString();
                int sel = this.action.getRealNodeID(name);
                if (sel == -1) {
                    return;
                }
                name = this.trimNodeName(name);
                this.placesInChart.set(sel, 1);
                this.placesInChartStr.set(sel, name);
                this.addNewPlaceSeries(sel, name);
                this.updatePlacesGraphicChart("places");
            }
        });
        placesChartOptionsPanel.add(addPlaceButton);
        HolmesRoundedButton removePlaceButton = new HolmesRoundedButton("<html><center>Remove</center></html>", "pearl_bH1_neutr.png", "pearl_bH2_hover.png", "pearl_bH3_press.png");
        removePlaceButton.setBounds(posXchart + 120, posYchart + 2, 110, 24);
        removePlaceButton.setMargin(new Insets(0, 0, 0, 0));
        removePlaceButton.setFocusPainted(false);
        removePlaceButton.setIcon(Tools.getResIcon16("/icons/stateSim/removeChart.png"));
        removePlaceButton.setToolTipText("Remove data about place tokens from the chart.");
        removePlaceButton.addActionListener(actionEvent -> {
            if (this.simDataBox == null) {
                return;
            }
            int selected = this.placesCombo.getSelectedIndex();
            if (selected > 0) {
                String name = this.placesCombo.getSelectedItem().toString();
                int sel = this.action.getRealNodeID(name);
                if (sel == -1) {
                    return;
                }
                name = this.trimNodeName(name);
                this.placesInChart.set(sel, -1);
                this.placesInChartStr.set(sel, "");
                this.removePlaceSeries(name);
            }
        });
        placesChartOptionsPanel.add(removePlaceButton);
        HolmesRoundedButton clearPlacesChartButton = new HolmesRoundedButton("<html><center>Clear chart</center></html>", "pearl_bH1_neutr.png", "pearl_bH2_hover.png", "pearl_bH3_press.png");
        clearPlacesChartButton.setBounds(posXchart + 240, posYchart + 2, 110, 24);
        clearPlacesChartButton.setMargin(new Insets(0, 0, 0, 0));
        clearPlacesChartButton.setFocusPainted(false);
        clearPlacesChartButton.setIcon(Tools.getResIcon16("/icons/stateSim/clearChart.png"));
        clearPlacesChartButton.setToolTipText("Clears the chart.");
        clearPlacesChartButton.addActionListener(actionEvent -> this.clearPlacesChart());
        placesChartOptionsPanel.add(clearPlacesChartButton);
        HolmesRoundedButton savePlacesChartButton = new HolmesRoundedButton("<html><center>Save image</center></html>", "pearl_bH1_neutr.png", "pearl_bH2_hover.png", "pearl_bH3_press.png");
        savePlacesChartButton.setBounds(posXchart + 360, posYchart + 2, 110, 24);
        savePlacesChartButton.setMargin(new Insets(0, 0, 0, 0));
        savePlacesChartButton.setFocusPainted(false);
        savePlacesChartButton.setIcon(Tools.getResIcon16("/icons/stateSim/saveImage.png"));
        savePlacesChartButton.setToolTipText("Saves the chart as image file.");
        savePlacesChartButton.addActionListener(actionEvent -> this.saveChartImage("places", 1200, 1024));
        placesChartOptionsPanel.add(savePlacesChartButton);
        HolmesRoundedButton showPlaceButton = new HolmesRoundedButton("<html><center>Find place</center></html>", "pearl_bH1_neutr.png", "pearl_bH2_hover.png", "pearl_bH3_press.png");
        showPlaceButton.setBounds(posXchart + 480, posYchart + 2, 110, 24);
        showPlaceButton.setMargin(new Insets(0, 0, 0, 0));
        showPlaceButton.setFocusPainted(false);
        showPlaceButton.setIcon(Tools.getResIcon16("/icons/stateSim/findNode.png"));
        showPlaceButton.setToolTipText("Find selected place within the net.");
        showPlaceButton.addActionListener(actionEvent -> {
            int selected = this.placesCombo.getSelectedIndex();
            if (selected > 0) {
                String name = this.placesCombo.getSelectedItem().toString();
                int sel = this.action.getRealNodeID(name);
                if (sel == -1) {
                    return;
                }
                GUIManager.getDefaultGUIManager().getSearchWindow().fillComboBoxesData();
                GUIManager.getDefaultGUIManager().getSearchWindow().selectedManually(true, sel);
            }
        });
        placesChartOptionsPanel.add(showPlaceButton);
        topPanel.add((Component)placesChartOptionsPanel, "Center");
        this.placeSimSteps = new JLabel("Place simulation steps: 0");
        this.placeSimSteps.setBounds(posXchart + 620, posYchart - 60, 200, 20);
        placesChartOptionsPanel.add(this.placeSimSteps);
        this.placeSimTime = new JLabel("Place simulation time: 0");
        this.placeSimTime.setBounds(posXchart + 620, posYchart - 40, 200, 20);
        placesChartOptionsPanel.add(this.placeSimTime);
        this.placeSimCompTime = new JLabel("Simulation computing time: 0");
        this.placeSimCompTime.setBounds(posXchart + 620, posYchart - 20, 230, 20);
        placesChartOptionsPanel.add(this.placeSimCompTime);
        JPanel placesChartGraphicPanel = new JPanel(null);
        placesChartGraphicPanel.setBackground(Color.WHITE);
        placesChartGraphicPanel.setBorder(BorderFactory.createTitledBorder("Chart graphic"));
        placesChartGraphicPanel.setPreferredSize(new Dimension(200, 100));
        int posXGchart = 10;
        int posYGchart = 20;
        ButtonGroup groupWidth = new ButtonGroup();
        JRadioButton width1 = new JRadioButton("Thin line");
        width1.setBackground(Color.WHITE);
        width1.setBounds(posXGchart, posYGchart, 90, 20);
        width1.setActionCommand("0");
        width1.addActionListener(actionEvent -> {
            if (((AbstractButton)actionEvent.getSource()).isSelected()) {
                this.chartDetails.p_StrokeWidth = 1.0f;
                this.updatePlacesGraphicChart("places");
            }
        });
        placesChartGraphicPanel.add(width1);
        groupWidth.add(width1);
        groupWidth.setSelected(width1.getModel(), true);
        JRadioButton width2 = new JRadioButton("Normal line");
        width2.setBackground(Color.WHITE);
        width2.setBounds(posXGchart, posYGchart + 20, 90, 20);
        width2.setActionCommand("1");
        width2.addActionListener(actionEvent -> {
            if (((AbstractButton)actionEvent.getSource()).isSelected()) {
                this.chartDetails.p_StrokeWidth = 2.0f;
                this.updatePlacesGraphicChart("places");
            }
        });
        placesChartGraphicPanel.add(width2);
        groupWidth.add(width2);
        JRadioButton width3 = new JRadioButton("Thick line");
        width3.setBackground(Color.WHITE);
        width3.setBounds(posXGchart, posYGchart + 40, 90, 20);
        width3.setActionCommand("2");
        width3.addActionListener(actionEvent -> {
            if (((AbstractButton)actionEvent.getSource()).isSelected()) {
                this.chartDetails.p_StrokeWidth = 3.0f;
                this.updatePlacesGraphicChart("places");
            }
        });
        placesChartGraphicPanel.add(width3);
        groupWidth.add(width3);
        topPanel.add((Component)placesChartGraphicPanel, "East");
        this.placesJPanel = new JPanel(new BorderLayout());
        this.placesJPanel.setBorder(BorderFactory.createTitledBorder("Places chart"));
        this.placesJPanel.add((Component)this.createPlacesChartPanel(), "Center");
        result.add((Component)this.placesJPanel, "Center");
        return result;
    }

    private JPanel createTransitionsTabPanel() {
        JPanel result = new JPanel(new BorderLayout());
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.setBackground(Color.WHITE);
        result.add((Component)topPanel, "First");
        JPanel transChartOptionsPanel = new JPanel(null);
        transChartOptionsPanel.setBackground(Color.WHITE);
        transChartOptionsPanel.setBorder(BorderFactory.createTitledBorder("Transitions chart options"));
        transChartOptionsPanel.setPreferredSize(new Dimension(500, 120));
        int posXchart = 10;
        int posYchart = 20;
        HolmesRoundedButton showAllButton = new HolmesRoundedButton("<html><center>Show all</center></html>", "pearl_bH1_neutr.png", "pearl_bH2_hover.png", "pearl_bH3_press.png");
        showAllButton.setBounds(posXchart, posYchart, 120, 24);
        showAllButton.setMargin(new Insets(0, 0, 0, 0));
        showAllButton.setFocusPainted(false);
        showAllButton.setIcon(Tools.getResIcon16("/icons/stateSim/showAll.png"));
        showAllButton.setToolTipText("Show average numbers of firings of transitions through simulation steps.");
        showAllButton.addActionListener(actionEvent -> this.showAllTransData());
        showAllButton.setEnabled(false);
        transChartOptionsPanel.add(showAllButton);
        HolmesRoundedButton showNotepadButton = new HolmesRoundedButton("<html><center>Show notepad</center></html>", "pearl_bH1_neutr.png", "pearl_bH2_hover.png", "pearl_bH3_press.png");
        showNotepadButton.setBounds(posXchart + 130, posYchart, 120, 24);
        showNotepadButton.setMargin(new Insets(0, 0, 0, 0));
        showNotepadButton.setFocusPainted(false);
        showNotepadButton.setIcon(Tools.getResIcon16("/icons/stateSim/showNotepad.png"));
        showNotepadButton.setToolTipText("Show average numbers of firings of transitions through simulation steps.");
        showNotepadButton.addActionListener(actionEvent -> this.showTransAllInNotepad());
        showNotepadButton.setEnabled(false);
        transChartOptionsPanel.add(showNotepadButton);
        JLabel label1 = new JLabel("Interval:");
        label1.setBounds(posXchart + 280, posYchart + 2, 70, 20);
        transChartOptionsPanel.add(label1);
        int mValue = (int)this.overlord.simSettings.getSimSteps_XTPN() / 10;
        SpinnerNumberModel intervSpinnerModel = new SpinnerNumberModel(this.transInterval, 1, mValue, 10);
        this.transIntervalSpinner = new JSpinner(intervSpinnerModel);
        this.transIntervalSpinner.setBounds(posXchart + 330, posYchart + 3, 60, 20);
        this.transIntervalSpinner.addChangeListener(e -> {
            JSpinner spinner = (JSpinner)e.getSource();
            this.transInterval = (Integer)spinner.getValue();
            this.clearTransitionsChart();
        });
        transChartOptionsPanel.add(this.transIntervalSpinner);
        JCheckBox sortedCheckBox = new JCheckBox("Sorted by firing");
        sortedCheckBox.setBounds(posXchart + 460, posYchart + 10, 130, 20);
        sortedCheckBox.setBackground(Color.WHITE);
        sortedCheckBox.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            this.sortedT = abstractButton.getModel().isSelected();
            this.fillPlacesAndTransitionsData();
        });
        transChartOptionsPanel.add(sortedCheckBox);
        JLabel label2 = new JLabel("Transition:");
        label2.setBounds(posXchart, posYchart += 30, 70, 20);
        transChartOptionsPanel.add(label2);
        String[] dataP = new String[]{"---"};
        this.transitionsCombo = new JComboBox<String>(dataP);
        this.transitionsCombo.setLocation(posXchart + 75, posYchart + 2);
        this.transitionsCombo.setSize(500, 20);
        this.transitionsCombo.setSelectedIndex(0);
        this.transitionsCombo.setMaximumRowCount(12);
        transChartOptionsPanel.add(this.transitionsCombo);
        HolmesRoundedButton addTransitionButton = new HolmesRoundedButton("<html><center>Add to chart</center></html>", "pearl_bH1_neutr.png", "pearl_bH2_hover.png", "pearl_bH3_press.png");
        addTransitionButton.setBounds(posXchart, (posYchart += 30) + 2, 110, 24);
        addTransitionButton.setMargin(new Insets(0, 0, 0, 0));
        addTransitionButton.setFocusPainted(false);
        addTransitionButton.setIcon(Tools.getResIcon16("/icons/stateSim/addChart.png"));
        addTransitionButton.setToolTipText("Add data about transition firing to the chart.");
        addTransitionButton.addActionListener(actionEvent -> {
            if (this.simDataBox == null) {
                return;
            }
            int selected = this.transitionsCombo.getSelectedIndex();
            if (selected > 0) {
                String name = this.transitionsCombo.getSelectedItem().toString();
                int sel = this.action.getRealNodeID(name);
                if (sel == -1) {
                    return;
                }
                name = this.trimNodeName(name);
                this.transInChart.set(sel, 1);
                this.transInChartStr.set(sel, name);
                this.addNewTransitionSeries(sel, name);
                this.updatePlacesGraphicChart("transitions");
            }
        });
        transChartOptionsPanel.add(addTransitionButton);
        HolmesRoundedButton removeTransitionButton = new HolmesRoundedButton("<html><center>Remove</center></html>", "pearl_bH1_neutr.png", "pearl_bH2_hover.png", "pearl_bH3_press.png");
        removeTransitionButton.setBounds(posXchart + 120, posYchart + 2, 110, 24);
        removeTransitionButton.setMargin(new Insets(0, 0, 0, 0));
        removeTransitionButton.setFocusPainted(false);
        removeTransitionButton.setIcon(Tools.getResIcon16("/icons/stateSim/removeChart.png"));
        removeTransitionButton.setToolTipText("Remove data about transition firing from the chart.");
        removeTransitionButton.addActionListener(actionEvent -> {
            if (this.simDataBox == null) {
                return;
            }
            int selected = this.transitionsCombo.getSelectedIndex();
            if (selected > 0) {
                String name = this.transitionsCombo.getSelectedItem().toString();
                int sel = this.action.getRealNodeID(name);
                if (sel == -1) {
                    return;
                }
                name = this.trimNodeName(name);
                this.transInChart.set(sel, -1);
                this.transInChartStr.set(sel, "");
                this.removeTransitionSeries(name);
            }
        });
        transChartOptionsPanel.add(removeTransitionButton);
        HolmesRoundedButton clearTransChartButton = new HolmesRoundedButton("<html><center>Clear chart</center></html>", "pearl_bH1_neutr.png", "pearl_bH2_hover.png", "pearl_bH3_press.png");
        clearTransChartButton.setBounds(posXchart + 240, posYchart + 2, 110, 24);
        clearTransChartButton.setMargin(new Insets(0, 0, 0, 0));
        clearTransChartButton.setFocusPainted(false);
        clearTransChartButton.setIcon(Tools.getResIcon16("/icons/stateSim/clearChart.png"));
        clearTransChartButton.setToolTipText("Clears the transitions chart.");
        clearTransChartButton.addActionListener(actionEvent -> this.clearTransitionsChart());
        transChartOptionsPanel.add(clearTransChartButton);
        HolmesRoundedButton saveTransitionsChartButton = new HolmesRoundedButton("<html><center>Save image</center></html>", "pearl_bH1_neutr.png", "pearl_bH2_hover.png", "pearl_bH3_press.png");
        saveTransitionsChartButton.setBounds(posXchart + 360, posYchart + 2, 110, 24);
        saveTransitionsChartButton.setMargin(new Insets(0, 0, 0, 0));
        saveTransitionsChartButton.setFocusPainted(false);
        saveTransitionsChartButton.setIcon(Tools.getResIcon16("/icons/stateSim/saveImage.png"));
        saveTransitionsChartButton.setToolTipText("Saves the chart as image file.");
        saveTransitionsChartButton.addActionListener(actionEvent -> this.saveChartImage("transitions", 1200, 1024));
        transChartOptionsPanel.add(saveTransitionsChartButton);
        HolmesRoundedButton showTransButton = new HolmesRoundedButton("<html><center>Find place</center></html>", "pearl_bH1_neutr.png", "pearl_bH2_hover.png", "pearl_bH3_press.png");
        showTransButton.setBounds(posXchart + 480, posYchart + 2, 110, 24);
        showTransButton.setMargin(new Insets(0, 0, 0, 0));
        showTransButton.setFocusPainted(false);
        showTransButton.setIcon(Tools.getResIcon16("/icons/stateSim/findNode.png"));
        showTransButton.setToolTipText("Find selected transition within the net.");
        showTransButton.addActionListener(actionEvent -> {
            int selected = this.transitionsCombo.getSelectedIndex();
            if (selected > 0) {
                int sel = this.action.getRealNodeID(this.transitionsCombo.getSelectedItem().toString());
                if (sel == -1) {
                    return;
                }
                GUIManager.getDefaultGUIManager().getSearchWindow().fillComboBoxesData();
                GUIManager.getDefaultGUIManager().getSearchWindow().selectedManually(false, sel);
            }
        });
        transChartOptionsPanel.add(showTransButton);
        topPanel.add((Component)transChartOptionsPanel, "Center");
        JPanel transChartGraphicPanel = new JPanel(null);
        transChartGraphicPanel.setBackground(Color.WHITE);
        transChartGraphicPanel.setBorder(BorderFactory.createTitledBorder("Chart graphic"));
        transChartGraphicPanel.setPreferredSize(new Dimension(200, 100));
        int posXGchart = 10;
        int posYGchart = 20;
        ButtonGroup groupWidth = new ButtonGroup();
        JRadioButton width1 = new JRadioButton("Thin");
        width1.setBackground(Color.WHITE);
        width1.setBounds(posXGchart, posYGchart, 70, 20);
        width1.setActionCommand("0");
        width1.addActionListener(actionEvent -> {
            if (((AbstractButton)actionEvent.getSource()).isSelected()) {
                this.chartDetails.t_StrokeWidth = 1.0f;
                this.updatePlacesGraphicChart("transitions");
            }
        });
        transChartGraphicPanel.add(width1);
        groupWidth.add(width1);
        groupWidth.setSelected(width1.getModel(), true);
        JRadioButton width2 = new JRadioButton("Normal");
        width2.setBackground(Color.WHITE);
        width2.setBounds(posXGchart, posYGchart + 20, 70, 20);
        width2.setActionCommand("1");
        width2.addActionListener(actionEvent -> {
            if (((AbstractButton)actionEvent.getSource()).isSelected()) {
                this.chartDetails.t_StrokeWidth = 2.0f;
                this.updatePlacesGraphicChart("transitions");
            }
        });
        transChartGraphicPanel.add(width2);
        groupWidth.add(width2);
        JRadioButton width3 = new JRadioButton("Thick");
        width3.setBackground(Color.WHITE);
        width3.setBounds(posXGchart, posYGchart + 40, 70, 20);
        width3.setActionCommand("2");
        width3.addActionListener(actionEvent -> {
            if (((AbstractButton)actionEvent.getSource()).isSelected()) {
                this.chartDetails.t_StrokeWidth = 3.0f;
                this.updatePlacesGraphicChart("transitions");
            }
        });
        transChartGraphicPanel.add(width3);
        groupWidth.add(width3);
        topPanel.add((Component)transChartGraphicPanel, "East");
        this.transitionsJPanel = new JPanel(new BorderLayout());
        this.transitionsJPanel.setBorder(BorderFactory.createTitledBorder("Transitions chart"));
        this.transitionsJPanel.add((Component)this.createTransChartPanel(), "Center");
        result.add((Component)this.transitionsJPanel, "Center");
        return result;
    }

    private JPanel createPlacesChartPanel() {
        String chartTitle = "Places dynamics";
        String xAxisLabel = "Step";
        String yAxisLabel = "Tokens";
        boolean showLegend = true;
        boolean createTooltip = true;
        boolean createURL = false;
        this.placesSeriesDataSet = new XYSeriesCollection();
        this.placesChart = ChartFactory.createXYLineChart(chartTitle, xAxisLabel, yAxisLabel, this.placesSeriesDataSet, PlotOrientation.VERTICAL, showLegend, createTooltip, createURL);
        return new ChartPanel(this.placesChart);
    }

    private void addNewPlaceSeries(int selPlaceID, String name) {
        if (this.placesChartType == 0) {
            this.placesJPanel.removeAll();
            this.placesJPanel.add((Component)this.createPlacesChartPanel(), "Center");
            this.placesJPanel.revalidate();
            this.placesJPanel.repaint();
            this.placesChartType = 1;
            this.placesSeriesDataSet.removeAllSeries();
        }
        List x = this.placesSeriesDataSet.getSeries();
        for (XYSeries xys : x) {
            if (!xys.getKey().equals(name)) continue;
            return;
        }
        XYSeries series = new XYSeries((Comparable)((Object)name));
        if (this.isTimeSimulationXTPN) {
            int step = 0;
            int intervalIteration = 1;
            while (step < this.simDataBox.fullTokensHistory.size()) {
                if (this.simDataBox.avgTimeForStep.get(step) < (double)(intervalIteration * this.placesTimeInterval)) {
                    double value = 0.0;
                    int getIndex = 0;
                    while (this.simDataBox.avgTimeForStep.get(step) < (double)(intervalIteration * this.placesTimeInterval)) {
                        value += this.simDataBox.fullTokensHistory.get(step).get(selPlaceID).doubleValue();
                        getIndex = ++step;
                        if (step < this.simDataBox.avgTimeForStep.size()) continue;
                        getIndex = this.simDataBox.avgTimeForStep.size() - 1;
                        break;
                    }
                    series.add(this.simDataBox.avgTimeForStep.get(getIndex), (Number)value);
                    continue;
                }
                ++intervalIteration;
            }
        } else {
            int interval = this.placesStepsInterval;
            int maxStep = this.simDataBox.fullTokensHistory.size() - interval - 1;
            if (this.simDataBox.fullTokensHistory.size() > 10 * interval) {
                for (int step = 0; step < maxStep; step += interval) {
                    double value = 0.0;
                    for (int j = 0; j < interval; ++j) {
                        value += this.simDataBox.fullTokensHistory.get(step + j).get(selPlaceID).doubleValue();
                    }
                    series.add((double)step, value /= (double)interval);
                }
            } else {
                for (int step = 0; step < this.simDataBox.fullTokensHistory.size(); ++step) {
                    double value = this.simDataBox.fullTokensHistory.get(step).get(selPlaceID);
                    series.add((double)step, value);
                }
            }
        }
        this.placesSeriesDataSet.addSeries(series);
    }

    private void removePlaceSeries(String name) {
        List x = this.placesSeriesDataSet.getSeries();
        for (XYSeries xys : x) {
            if (!xys.getKey().equals(name)) continue;
            this.placesSeriesDataSet.removeSeries(xys);
            return;
        }
    }

    private void clearPlacesChart() {
        this.placesSeriesDataSet.removeAllSeries();
        this.placesInChart = new ArrayList();
        this.placesInChartStr = new ArrayList();
        for (int i = 0; i < GUIManager.getDefaultGUIManager().getWorkspace().getProject().getPlaces().size(); ++i) {
            this.placesInChart.add(-1);
            this.placesInChartStr.add("");
        }
    }

    private void showAllPlacesData() {
    }

    public static double calculateSD(Double[] numArray) {
        double sum = 0.0;
        double standardDeviation = 0.0;
        int length = numArray.length;
        Double[] doubleArray = numArray;
        int n = doubleArray.length;
        for (int i = 0; i < n; ++i) {
            double num = doubleArray[i];
            sum += num;
        }
        double mean = sum / (double)length;
        Double[] doubleArray2 = numArray;
        int n2 = doubleArray2.length;
        for (int i = 0; i < n2; ++i) {
            double num = doubleArray2[i];
            standardDeviation += Math.pow(num - mean, 2.0);
        }
        return Math.sqrt(standardDeviation / (double)length);
    }

    private void showPlacesAllInNotepad() {
        HolmesNotepad notePad = new HolmesNotepad(900, 600);
        notePad.setVisible(true);
        ArrayList<Place> places_tmp = GUIManager.getDefaultGUIManager().getWorkspace().getProject().getPlaces();
    }

    private JPanel createTransChartPanel() {
        String chartTitle = "Transitions dynamics";
        String xAxisLabel = "Transition";
        String yAxisLabel = "Firing";
        boolean showLegend = true;
        boolean createTooltip = true;
        boolean createURL = false;
        this.transitionsSeriesDataSet = new XYSeriesCollection();
        this.transitionsChart = ChartFactory.createXYLineChart(chartTitle, xAxisLabel, yAxisLabel, this.transitionsSeriesDataSet, PlotOrientation.VERTICAL, showLegend, createTooltip, createURL);
        return new ChartPanel(this.transitionsChart);
    }

    private void addNewTransitionSeries(int selTransID, String name) {
        if (this.transChartType == 0) {
            this.transitionsJPanel.removeAll();
            this.transitionsJPanel.add((Component)this.createTransChartPanel(), "Center");
            this.transitionsJPanel.revalidate();
            this.transitionsJPanel.repaint();
            this.transChartType = 1;
            this.transitionsSeriesDataSet.removeAllSeries();
        }
        List x = this.transitionsSeriesDataSet.getSeries();
        for (XYSeries xys : x) {
            if (!xys.getKey().equals(name)) continue;
            return;
        }
        XYSeries series = new XYSeries((Comparable)((Object)name));
        for (int step = 0; step < this.simDataBox.transitionsSimHistory.get(selTransID).size(); ++step) {
            if (this.transInterval > this.simDataBox.transitionsSimHistory.get(selTransID).size() / 10) {
                this.transInterval = this.simDataBox.transitionsSimHistory.get(selTransID).size() / 10;
            }
            double value = 0.0;
            for (int i = 0; i < this.transInterval; ++i) {
                value += this.simDataBox.transitionsSimHistory.get((int)selTransID).get((int)(step + i)).fired;
            }
            series.add((double)step, value);
            step += this.transInterval;
            if (this.transInterval <= 1) continue;
            --step;
        }
        this.transitionsSeriesDataSet.addSeries(series);
    }

    private void removeTransitionSeries(String name) {
        List x = this.transitionsSeriesDataSet.getSeries();
        for (XYSeries xys : x) {
            if (!xys.getKey().equals(name)) continue;
            this.transitionsSeriesDataSet.removeSeries(xys);
            return;
        }
    }

    private void clearTransitionsChart() {
        this.transitionsSeriesDataSet.removeAllSeries();
        this.transInChart = new ArrayList();
        this.transInChartStr = new ArrayList();
        for (int i = 0; i < GUIManager.getDefaultGUIManager().getWorkspace().getProject().getTransitions().size(); ++i) {
            this.transInChart.add(-1);
            this.transInChartStr.add("");
        }
    }

    private void showAllTransData() {
    }

    private void showTransAllInNotepad() {
    }

    private void saveChartImage(String chartType, int w, int h) {
        String lastPath = GUIManager.getDefaultGUIManager().getLastPath();
        FileFilter[] filters = new FileFilter[]{new ExtensionFileFilter("Portable Network Graphics (.png)", new String[]{"PNG"})};
        Object selectedFile = Tools.selectFileDialog(lastPath, filters, "Save", "", "");
        if (((String)selectedFile).equals("")) {
            return;
        }
        if (!((String)selectedFile).contains(".png")) {
            selectedFile = (String)selectedFile + ".png";
        }
        File imageFile = new File((String)selectedFile);
        try {
            if (chartType.equals("places")) {
                ChartUtilities.saveChartAsPNG(imageFile, this.placesChart, w, h);
            } else if (chartType.equals("transitions")) {
                ChartUtilities.saveChartAsPNG(imageFile, this.transitionsChart, w, h);
            }
        }
        catch (IOException ex) {
            this.overlord.log("Error:" + ex, "error", true);
        }
    }

    private void fillPlacesAndTransitionsData() {
        ArrayList<Transition> transitions;
        this.doNotUpdate = true;
        this.placeRepsSpinnerModel.setValue(this.overlord.simSettings.getRepetitions());
        this.qSimXTPNRecordStepsCheckbox.setSelected(this.overlord.simSettings.isPartialRecordingSteps());
        this.selStepsSpinnerModel.setValue(this.overlord.simSettings.getRecordedSteps());
        this.qSimXTPNCompStatsCheckbox.setSelected(this.overlord.simSettings.isStatsRecorded());
        this.placeStepsSpinnerModel.setValue((int)this.overlord.simSettings.getSimSteps_XTPN());
        this.qSimXTPNStatsTimeCheckbox.setSelected(this.overlord.simSettings.isTimeSimulation_XTPN());
        this.placeTimeSpinnerModel.setValue((int)this.overlord.simSettings.getSimTime_XTPN());
        this.doNotUpdate = false;
        if (this.simDataBox == null) {
            this.simDataBox = new StateSimDataContainer();
        }
        this.selStateLabel.setText("" + this.overlord.getWorkspace().getProject().accessStatesManager().selectedStatePN);
        ArrayList<Place> places = GUIManager.getDefaultGUIManager().getWorkspace().getProject().getPlaces();
        if (places == null || places.size() == 0) {
            this.placesCombo.removeAllItems();
            this.placesCombo.addItem("---");
            this.transitionsCombo.removeAllItems();
            this.transitionsCombo.addItem("---");
            return;
        }
        this.placesCombo.removeAllItems();
        this.placesCombo.addItem("---");
        if (this.simDataBox.avgTokens.size() == places.size()) {
            if (!this.sortedP) {
                for (int p = 0; p < places.size(); ++p) {
                    this.placesCombo.addItem("p" + p + "." + places.get(p).getName() + " " + this.formatD(this.simDataBox.avgTokens.get(p)));
                }
            } else {
                HashMap<Integer, Double> map = new HashMap<Integer, Double>();
                for (int j = 0; j < this.simDataBox.avgTokens.size(); ++j) {
                    map.put(j, this.simDataBox.avgTokens.get(j));
                }
                Map sortedByValues = HolmesSimXTPNActions.crunchifySortMapXTPN(map);
                for (Map.Entry entry : sortedByValues.entrySet()) {
                    this.placesCombo.addItem("p" + entry.getKey() + "." + places.get((Integer)entry.getKey()).getName() + " " + this.formatD((Double)entry.getValue()));
                }
            }
        } else {
            for (int p = 0; p < places.size(); ++p) {
                this.placesCombo.addItem("p" + p + "." + places.get(p).getName());
            }
        }
        if ((transitions = GUIManager.getDefaultGUIManager().getWorkspace().getProject().getTransitions()) == null || transitions.size() == 0) {
            return;
        }
        this.transitionsCombo.removeAllItems();
        this.transitionsCombo.addItem("---");
        if (this.simDataBox.avgFired.size() == transitions.size()) {
            if (!this.sortedT) {
                for (int t = 0; t < transitions.size(); ++t) {
                    this.transitionsCombo.addItem("t" + t + "." + transitions.get(t).getName() + " " + this.formatD(this.simDataBox.avgFired.get(t)));
                }
            } else {
                HashMap<Integer, Double> map = new HashMap<Integer, Double>();
                for (int j = 0; j < this.simDataBox.avgFired.size(); ++j) {
                    map.put(j, this.simDataBox.avgFired.get(j));
                }
                Map sortedByValues = HolmesSimXTPNActions.crunchifySortMapXTPN(map);
                for (Map.Entry entry : sortedByValues.entrySet()) {
                    this.transitionsCombo.addItem("t" + entry.getKey() + "." + transitions.get((Integer)entry.getKey()).getName() + " " + this.formatD((Double)entry.getValue()));
                }
            }
        } else {
            for (int t = 0; t < transitions.size(); ++t) {
                this.transitionsCombo.addItem("t" + t + "." + transitions.get(t).getName());
            }
        }
    }

    private void acquireDataFromSimulation() {
        if (GUIManager.getDefaultGUIManager().getSimulatorBox().getCurrentDockWindow().getSimulator().getSimulatorStatus() != GraphicalSimulator.SimulatorMode.STOPPED) {
            JOptionPane.showMessageDialog(this.ego, "Main simulator active. Please turn if off before starting state simulator process", "Main simulator active", 0);
            return;
        }
        if (GUIManager.getDefaultGUIManager().getSimulatorBox().getCurrentDockWindow().getSimulatorXTPN().getsimulatorStatusXTPN() != GraphicalSimulatorXTPN.SimulatorModeXTPN.STOPPED) {
            JOptionPane.showMessageDialog(this.ego, "Main XTPN simulator active. Please turn if off before starting state simulator process", "XTPN simulator active", 0);
            return;
        }
        ArrayList<Place> places = GUIManager.getDefaultGUIManager().getWorkspace().getProject().getPlaces();
        if (places == null || places.size() == 0) {
            return;
        }
        this.clearTransitionsChart();
        this.clearPlacesChart();
        this.clearAllData();
        this.progressBar.setMaximum(this.overlord.simSettings.getSimSteps());
        boolean success = this.ssim.initiateSim(this.overlord.simSettings);
        if (!success) {
            return;
        }
        this.setSimWindowComponentsStatus(false);
        this.setWorkInProgress(true);
        this.ssim.setThreadDetails(4, this, this.overlord.simSettings, this.progressBar);
        Thread myThread = new Thread(this.ssim);
        myThread.start();
    }

    private void setSimWindowComponentsStatus(boolean value) {
        this.acqDataButton.setEnabled(value);
        this.stateManagerButton.setEnabled(value);
        this.overlord.getFrame().setEnabled(value);
    }

    public void completeSimulationProcedures_Mk1(StateSimDataContainer result) {
        int i;
        this.simDataBox = result;
        this.isTimeSimulationXTPN = this.overlord.simSettings.isTimeSimulation_XTPN();
        this.placesInChart = new ArrayList();
        this.placesInChartStr = new ArrayList();
        for (i = 0; i < GUIManager.getDefaultGUIManager().getWorkspace().getProject().getPlaces().size(); ++i) {
            this.placesInChart.add(-1);
            this.placesInChartStr.add("");
        }
        this.transInChart = new ArrayList();
        this.transInChartStr = new ArrayList();
        for (i = 0; i < GUIManager.getDefaultGUIManager().getWorkspace().getProject().getTransitions().size(); ++i) {
            this.transInChart.add(-1);
            this.transInChartStr.add("");
        }
        this.placeSimSteps.setText("Place simulation steps: " + this.simDataBox.avgTimeForStep.size());
        this.placeSimTime.setText("Place simulation time:  " + Tools.cutValue(this.simDataBox.avgTimeForStep.get(this.simDataBox.avgTimeForStep.size() - 1)));
        this.placeSimCompTime.setText("Simulation computing time: " + Tools.getTime(this.simDataBox.compTime));
        this.fillPlacesAndTransitionsData();
        this.setSimWindowComponentsStatus(true);
        this.setWorkInProgress(false);
    }

    private void clearAllData() {
        this.ssim = new StateSimulatorXTPN();
        this.simDataBox = null;
        this.placesInChart.clear();
        this.placesInChartStr.clear();
        this.transInChart.clear();
        this.transInChartStr.clear();
    }

    private String formatD(double value) {
        DecimalFormat df = new DecimalFormat("#.#######");
        Object txt = "(avg: ";
        txt = (String)txt + df.format(value);
        txt = (String)txt + ")";
        txt = ((String)txt).replace(",", ".");
        return txt;
    }

    private String trimNodeName(String name) {
        int i = name.indexOf("(avg");
        if (i < 0) {
            return name;
        }
        name = name.substring(0, i - 1);
        return name;
    }

    private void updatePlacesGraphicChart(String chartType) {
        block5: {
            block4: {
                if (!chartType.equals("places")) break block4;
                if (this.placesChartType == 0) {
                    return;
                }
                XYPlot plot = this.placesChart.getXYPlot();
                int count = this.placesChart.getXYPlot().getSeriesCount();
                for (int i = 0; i < count; ++i) {
                    plot.getRenderer().setSeriesStroke(i, new BasicStroke(this.chartDetails.p_StrokeWidth));
                }
                break block5;
            }
            if (!chartType.equals("transitions")) break block5;
            if (this.transChartType == 0) {
                return;
            }
            XYPlot plot = this.transitionsChart.getXYPlot();
            int count = this.transitionsChart.getXYPlot().getSeriesCount();
            for (int i = 0; i < count; ++i) {
                plot.getRenderer().setSeriesStroke(i, new BasicStroke(this.chartDetails.t_StrokeWidth));
            }
        }
    }

    private void initiateListeners() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                HolmesSimXTPN.this.fillPlacesAndTransitionsData();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                if (HolmesSimXTPN.this.isWorkInProgress()) {
                    JOptionPane.showMessageDialog(HolmesSimXTPN.this.ego, "Simulator working. Window closing operation cancelled.", "Simulator working", 1);
                    HolmesSimXTPN.this.setDefaultCloseOperation(0);
                } else {
                    HolmesSimXTPN.this.setDefaultCloseOperation(1);
                    HolmesSimXTPN.this.overlord.getFrame().setEnabled(true);
                }
            }
        });
    }

    public void setWorkInProgress(boolean value) {
        this.workInProgress = value;
    }

    public boolean isWorkInProgress() {
        return this.workInProgress;
    }

    public void resetSimWindow() {
        this.doNotUpdate = true;
        this.clearTransitionsChart();
        this.clearPlacesChart();
        this.clearAllData();
        this.fillPlacesAndTransitionsData();
        this.transInterval = 100;
        this.placesStepsInterval = 100;
        this.transChartType = 0;
        this.placesChartType = 0;
        int mValue = this.overlord.simSettings.getSimSteps() / 10;
        SpinnerNumberModel intervSpinnerModel = new SpinnerNumberModel(100, 0, mValue, 10);
        this.transIntervalSpinner.setModel(intervSpinnerModel);
        this.placesStepsIntervalSpinner.setValue(this.placesStepsInterval);
        this.placesTimeIntervalSpinner.setValue(this.placesTimeInterval);
        this.doNotUpdate = false;
    }

    public void updateIntervalSpinner() {
        int mValue = this.overlord.simSettings.getSimSteps() / 10;
        SpinnerNumberModel intervSpinnerModel = new SpinnerNumberModel(100, 0, mValue, 10);
        this.transIntervalSpinner.setModel(intervSpinnerModel);
        SpinnerNumberModel intervSpinnerModel2 = new SpinnerNumberModel(100, 0, mValue, 10);
        this.placesStepsIntervalSpinner.setModel(intervSpinnerModel2);
    }

    public JFrame getFrame() {
        return this.ego;
    }

    private static class ChartPropertiesXTPN {
        public float p_StrokeWidth = 1.0f;
        public float t_StrokeWidth = 1.0f;
    }

    public static class CustomToolTipPlacesGeneratorXTPN
    implements CategoryToolTipGenerator {
        ArrayList<Place> places;
        ArrayList<Double> dataVector;
        double max;
        DecimalFormat formatter;

        public CustomToolTipPlacesGeneratorXTPN(ArrayList<Place> places, ArrayList<Double> dataVector, double max) {
            this.places = places;
            this.dataVector = dataVector;
            this.max = max;
            this.formatter = new DecimalFormat("#.###");
        }

        @Override
        public String generateToolTip(CategoryDataset dataset, int bar, int nodeIndex) {
            Object text = "<html><font size=\"5\">";
            text = (String)text + "p" + nodeIndex + "_" + this.places.get(nodeIndex).getName() + "<br>";
            text = (String)text + "Tokens: " + this.dataVector.get(nodeIndex) + "   (maximum in this simulation: " + this.max + ")";
            text = (String)text + "</font></html>";
            return text;
        }
    }

    public static class CustomToolTipTransGeneratorXTPN
    implements CategoryToolTipGenerator {
        ArrayList<Transition> transitions;
        ArrayList<Integer> dataVector;
        double max;
        DecimalFormat formatter;

        public CustomToolTipTransGeneratorXTPN(ArrayList<Transition> transitions, ArrayList<Integer> dataVector, double max) {
            this.transitions = transitions;
            this.dataVector = dataVector;
            this.max = max;
            this.formatter = new DecimalFormat("#.###");
        }

        @Override
        public String generateToolTip(CategoryDataset dataset, int bar, int nodeIndex) {
            Object text = "<html><font size=\"5\">";
            text = (String)text + "t" + nodeIndex + "_" + this.transitions.get(nodeIndex).getName() + "<br>";
            text = (String)text + "Fired: " + this.dataVector.get(nodeIndex) + "   (maximum in this simulation: " + this.max + ")";
            text = (String)text + "</font></html>";
            return text;
        }
    }
}

