/*
 * Decompiled with CFR 0.152.
 */
package holmes.windows.xtpn;

import holmes.darkgui.GUIManager;
import holmes.darkgui.dockwindows.SharedActionsXTPN;
import holmes.darkgui.holmesInterface.HolmesRoundedButton;
import holmes.petrinet.elements.ElementLocation;
import holmes.petrinet.elements.Node;
import holmes.petrinet.elements.PlaceXTPN;
import holmes.petrinet.elements.Transition;
import holmes.petrinet.elements.TransitionXTPN;
import holmes.petrinet.simulators.GraphicalSimulator;
import holmes.petrinet.simulators.SimulatorGlobals;
import holmes.petrinet.simulators.xtpn.StateSimulatorXTPN;
import holmes.utilities.Tools;
import holmes.windows.xtpn.HolmesNodeInfoXTPNactions;
import holmes.windows.xtpn.HolmesXTPNtokens;
import holmes.workspace.WorkspaceSheet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.SpinnerNumberModel;
import javax.swing.text.DefaultFormatter;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class HolmesNodeInfoXTPN
extends JFrame {
    private GUIManager overlord;
    private PlaceXTPN thePlace;
    private ElementLocation eLocation;
    private HolmesNodeInfoXTPNactions action = new HolmesNodeInfoXTPNactions(this);
    private TransitionXTPN theTransition;
    private boolean doNotUpdate = false;
    private JPanel mainInfoPanel;
    private JFrame parentFrame;
    public boolean mainSimulatorActive = false;
    private XYSeriesCollection dynamicsSeriesDataSet = null;
    private JFreeChart dynamicsChart;
    private int simSteps = 30000;
    private int repeated = 10;
    private boolean simulateTime = false;
    private double simTimeLength = 5000.0;
    private int placeChartType = 0;
    private int transitionChartType = 0;
    ArrayList<Double> stepsVectorPlaces = new ArrayList();
    ArrayList<Double> timeVectorPlaces = new ArrayList();
    ArrayList<ArrayList<Double>> statusVectorTransition = new ArrayList();
    private HolmesRoundedButton buttonGammaMode;
    private HolmesRoundedButton gammaVisibilityButton;
    private HolmesRoundedButton tokensWindowButton;
    private JFormattedTextField tokensTextBox;
    private JFormattedTextField gammaMinTextField;
    private JFormattedTextField gammaMaxTextField;
    private HolmesRoundedButton acqDataButton;
    private boolean simPlaceReps = false;
    private int simPlaceNumberOfReps = 5;
    private int simPlaceInterval = 100;
    private HolmesRoundedButton buttonAlphaMode;
    private HolmesRoundedButton buttonBetaMode;
    private HolmesRoundedButton buttonClassXTPNmode;
    private HolmesRoundedButton alphaVisibilityButton;
    private HolmesRoundedButton betaVisibilityButton;
    private HolmesRoundedButton tauVisibilityButton;
    private JFormattedTextField alphaMinTextField;
    private JFormattedTextField alphaMaxTextField;
    private JFormattedTextField betaMinTextField;
    private JFormattedTextField betaMaxTextField;
    private JLabel transStatsStepLabel;
    private JLabel transStatsTimeLabel;
    private JFormattedTextField transStatsInactiveStepsTextBox;
    private JFormattedTextField transStatsActiveStepsTextBox;
    private JFormattedTextField transStatsProductionStepsTextBox;
    private JFormattedTextField transStatsFiringStepsTextBox;
    private JFormattedTextField transStatsInactiveTimeTextBox;
    private JFormattedTextField transStatsActiveTimeTextBox;
    private JFormattedTextField transStatsProductionTimeTextBox;
    private boolean simTransReps = false;
    private int simTransNumberOfReps = 5;
    private int simTransInterval = 100;
    private JCheckBox transStatsStepsCheckbox;
    private JCheckBox transStatsTimeCheckbox;
    private boolean transStatsSimulateWithSteps = true;
    private int transStatsRepetitions = 10;
    private int transStatsNumberOfSteps = 10000;
    private double transStatsMaxTime = 5000.0;
    private boolean transStatsReps = false;
    SimulatorGlobals ownSettings = new SimulatorGlobals();

    public HolmesNodeInfoXTPN(PlaceXTPN place, ElementLocation eloc, JFrame parent) {
        this.overlord = GUIManager.getDefaultGUIManager();
        this.parentFrame = parent;
        this.thePlace = place;
        this.eLocation = eloc;
        this.setTitle("Node: " + place.getName());
        this.setBackground(Color.WHITE);
        this.initiateSimGlobals();
        this.initializeCommon(place);
        JPanel main = new JPanel(new BorderLayout());
        this.add(main);
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab("XTPN Place Info", Tools.getResIcon16("/icons/nodeViewer/tab1.png"), this.initializePlaceInfo(), "General information about XTPN place");
        tabbedPane.setMnemonicAt(0, 49);
        tabbedPane.addTab("Additional Data", Tools.getResIcon16("/icons/nodeViewer/tab3.png"), this.initializePlaceInvPanel(), "Additional data");
        tabbedPane.setMnemonicAt(1, 50);
        tabbedPane.setBackgroundAt(0, Color.WHITE);
        tabbedPane.setBackgroundAt(1, Color.WHITE);
        this.setFieldStatus(true);
        main.add(tabbedPane);
    }

    public HolmesNodeInfoXTPN(TransitionXTPN transition, ElementLocation eloc, JFrame parent) {
        this.overlord = GUIManager.getDefaultGUIManager();
        this.parentFrame = parent;
        this.theTransition = transition;
        this.eLocation = eloc;
        this.setTitle("Node: " + transition.getName());
        this.setBackground(Color.WHITE);
        this.initiateSimGlobals();
        this.initializeCommon(transition);
        JPanel main = new JPanel(new BorderLayout());
        this.add(main);
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab("XTPN Transition Info", Tools.getResIcon16("/icons/nodeViewer/tab1.png"), this.initializeTransitionInfo(), "General information about XTPN transition");
        tabbedPane.setMnemonicAt(0, 49);
        tabbedPane.addTab("Additional data", Tools.getResIcon16("/icons/nodeViewer/tab3.png"), this.initializeTransInvPanel(), "Additional data");
        tabbedPane.setMnemonicAt(1, 50);
        tabbedPane.setBackgroundAt(0, Color.WHITE);
        tabbedPane.setBackgroundAt(1, Color.WHITE);
        this.setFieldStatus(false);
        main.add(tabbedPane);
    }

    private void initiateSimGlobals() {
        this.simSteps = 10000;
        this.repeated = 1;
        this.simulateTime = false;
        this.simTimeLength = 5000.0;
        this.ownSettings.setSimSteps_XTPN(this.simSteps);
        this.ownSettings.setSimTime_XTPN(this.simTimeLength);
        this.ownSettings.setSimRepetitions_XTPN(this.repeated);
        this.ownSettings.setTimeSimulationStatus_XTPN(this.simulateTime);
    }

    private void initializeCommon(Node node) {
        try {
            this.setIconImage(Tools.getImageFromIcon("/icons/holmesicon.png"));
        }
        catch (Exception ex) {
            GUIManager.getDefaultGUIManager().log("Error (181278513) | Exception:  " + ex.getMessage(), "error", true);
        }
        if (this.overlord.getSimulatorBox().getCurrentDockWindow().getSimulator().getSimulatorStatus() != GraphicalSimulator.SimulatorMode.STOPPED) {
            this.mainSimulatorActive = true;
        }
        if (this.overlord.getWorkspace().getProject().isSimulationActive()) {
            this.mainSimulatorActive = true;
        }
        this.parentFrame.setEnabled(false);
        this.setResizable(false);
        this.setLocation(20, 20);
        if (node instanceof PlaceXTPN) {
            this.setSize(new Dimension(800, 580));
        } else {
            this.setSize(new Dimension(800, 720));
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                HolmesNodeInfoXTPN.this.parentFrame.setEnabled(true);
            }
        });
        this.setVisible(true);
    }

    private JPanel initializePlaceInfo() {
        this.mainInfoPanel = new JPanel(null);
        this.mainInfoPanel.setBounds(0, 0, 800, 590);
        this.mainInfoPanel.setBackground(Color.WHITE);
        int mPanelX = 0;
        int mPanelY = 0;
        JPanel infoPanel = new JPanel(null);
        infoPanel.setBounds(mPanelX, mPanelY, this.mainInfoPanel.getWidth() - 18, 160);
        infoPanel.setBackground(Color.WHITE);
        infoPanel.setBorder(BorderFactory.createTitledBorder("Structural data:"));
        int infPanelX = 10;
        int infPanelY = 20;
        JLabel labelID = new JLabel("ID:");
        labelID.setBounds(infPanelX, infPanelY, 20, 20);
        infoPanel.add(labelID);
        int id = this.overlord.getWorkspace().getProject().getPlaces().indexOf(this.thePlace);
        JFormattedTextField idTextBox = new JFormattedTextField((Object)id);
        idTextBox.setBounds(infPanelX + 20, infPanelY, 30, 20);
        idTextBox.setEditable(false);
        infoPanel.add(idTextBox);
        JLabel labelName = new JLabel("Name:");
        labelName.setBounds(infPanelX + 60, infPanelY, 40, 20);
        infoPanel.add(labelName);
        DefaultFormatter format = new DefaultFormatter();
        format.setOverwriteMode(false);
        JFormattedTextField nameField = new JFormattedTextField(format);
        nameField.setLocation(infPanelX + 100, infPanelY);
        nameField.setSize(350, 20);
        nameField.setValue(this.thePlace.getName());
        nameField.addPropertyChangeListener("value", e -> {
            JFormattedTextField field = (JFormattedTextField)e.getSource();
            try {
                field.commitEdit();
            }
            catch (ParseException ex) {
                GUIManager.getDefaultGUIManager().log("Error (611156405) | Exception:  " + ex.getMessage(), "error", true);
            }
            String newName = field.getText();
            this.thePlace.setName(newName);
            this.action.repaintGraphPanel(this.thePlace);
        });
        infoPanel.add(nameField);
        JLabel commmentLabel = new JLabel("Comments:", 2);
        commmentLabel.setBounds(infPanelX + 460, infPanelY - 22, 100, 20);
        infoPanel.add(commmentLabel);
        JTextArea commentField = new JTextArea(this.thePlace.getComment());
        commentField.setLineWrap(true);
        commentField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                JTextArea field = (JTextArea)e.getSource();
                String newComment = "";
                if (field != null) {
                    newComment = field.getText();
                }
                HolmesNodeInfoXTPN.this.thePlace.setComment(newComment);
            }
        });
        JPanel creationPanel = new JPanel();
        creationPanel.setLayout(new BorderLayout());
        creationPanel.add((Component)new JScrollPane(commentField), "Center");
        creationPanel.setBounds(infPanelX + 460, infPanelY, 300, 70);
        infoPanel.add(creationPanel);
        this.mainInfoPanel.add(infoPanel);
        JLabel portalLabel = new JLabel("Portal:");
        portalLabel.setBounds(infPanelX, infPanelY += 25, 40, 20);
        infoPanel.add(portalLabel);
        String port = "no";
        if (this.thePlace.isPortal()) {
            port = "yes";
        }
        JLabel portalLabel2 = new JLabel(port);
        portalLabel2.setBounds(infPanelX + 40, infPanelY, 30, 20);
        infoPanel.add(portalLabel2);
        int inTrans = 0;
        int outTrans = 0;
        for (ElementLocation el : this.thePlace.getElementLocations()) {
            inTrans += el.getInArcs().size();
            outTrans += el.getOutArcs().size();
        }
        JLabel inTransLabel = new JLabel("Input transitions:");
        inTransLabel.setBounds(infPanelX + 60, infPanelY, 120, 20);
        infoPanel.add(inTransLabel);
        JFormattedTextField inTransTextBox = new JFormattedTextField((Object)inTrans);
        inTransTextBox.setBounds(infPanelX + 160, infPanelY, 25, 20);
        inTransTextBox.setEditable(false);
        infoPanel.add(inTransTextBox);
        JLabel outTransLabel = new JLabel("Output transitions:");
        outTransLabel.setBounds(infPanelX + 190, infPanelY, 120, 20);
        infoPanel.add(outTransLabel);
        JFormattedTextField outTransTextBox = new JFormattedTextField((Object)outTrans);
        outTransTextBox.setBounds(infPanelX + 310, infPanelY, 30, 20);
        outTransTextBox.setEditable(false);
        infoPanel.add(outTransTextBox);
        JLabel gammaModeInfoLabel = new JLabel("Time mode:");
        gammaModeInfoLabel.setBounds(infPanelX, infPanelY += 25, 80, 20);
        infoPanel.add(gammaModeInfoLabel);
        this.buttonGammaMode = new HolmesRoundedButton("<html>Gamma: ON</html>", "jade_bH1_neutr.png", "amber_bH2_hover.png", "amber_bH3_press.png");
        this.buttonGammaMode.setMargin(new Insets(0, 0, 0, 0));
        this.buttonGammaMode.setName("gammaButton1");
        this.buttonGammaMode.setBounds(infPanelX + 80, infPanelY, 100, 25);
        this.buttonGammaMode.setFocusPainted(false);
        if (this.thePlace.isGammaModeActive()) {
            this.buttonGammaMode.setNewText("<html>Gamma: ON</html>");
            this.buttonGammaMode.repaintBackground("jade_bH1_neutr.png", "amber_bH2_hover.png", "amber_bH3_press.png");
        } else {
            this.buttonGammaMode.setNewText("<html>Gamma: OFF</html>");
            this.buttonGammaMode.repaintBackground("amber_bH1_neutr.png", "jade_bH2_hover.png", "jade_bH3_press.png");
        }
        this.buttonGammaMode.addActionListener(e -> {
            this.action.buttonGammaModeSwitch(e, this.thePlace, this.tokensWindowButton, this.gammaVisibilityButton);
            this.action.reselectElement(this.eLocation);
        });
        infoPanel.add(this.buttonGammaMode);
        JLabel gammaVisInfoLabel = new JLabel("Visibility:");
        gammaVisInfoLabel.setBounds(infPanelX + 190, infPanelY, 70, 20);
        infoPanel.add(gammaVisInfoLabel);
        this.gammaVisibilityButton = new HolmesRoundedButton("<html>\u03b3:visible</html>", "jade_bH1_neutr.png", "amber_bH2_hover.png", "amber_bH3_press.png");
        this.gammaVisibilityButton.setMargin(new Insets(0, 0, 0, 0));
        this.gammaVisibilityButton.setName("gammaVisButton1");
        this.gammaVisibilityButton.setBounds(infPanelX + 250, infPanelY, 100, 25);
        this.gammaVisibilityButton.setFocusPainted(false);
        if (this.thePlace.isGammaModeActive()) {
            if (this.thePlace.isGammaRangeVisible()) {
                this.gammaVisibilityButton.setNewText("<html>\u03b3:visible<html>");
                this.gammaVisibilityButton.repaintBackground("jade_bH1_neutr.png", "amber_bH2_hover.png", "amber_bH3_press.png");
            } else {
                this.gammaVisibilityButton.setNewText("<html>\u03b3:hidden<html>");
                this.gammaVisibilityButton.repaintBackground("amber_bH3_press_bH1_neutr.png", "jade_bH2_hover.png", "jade_bH3_press.png");
            }
        } else {
            this.gammaVisibilityButton.setEnabled(false);
        }
        this.gammaVisibilityButton.addActionListener(e -> {
            this.action.gammaVisButtonSwitch(e, this.thePlace);
            this.action.reselectElement(this.eLocation);
        });
        infoPanel.add(this.gammaVisibilityButton);
        JLabel minMaxLabel = new JLabel("\u03b3 (min/max): ", 2);
        minMaxLabel.setBounds(infPanelX, infPanelY += 30, 80, 20);
        infoPanel.add(minMaxLabel);
        NumberFormat formatter = DecimalFormat.getInstance();
        formatter.setMinimumFractionDigits(1);
        formatter.setMaximumFractionDigits(this.thePlace.getFractionForPlaceXTPN());
        formatter.setRoundingMode(RoundingMode.HALF_UP);
        Double example = 3.14;
        this.gammaMinTextField = new JFormattedTextField(formatter);
        this.gammaMinTextField.setValue(example);
        this.gammaMinTextField.setValue(this.thePlace.getGammaMinValue());
        this.gammaMinTextField.addPropertyChangeListener("value", e -> {
            JFormattedTextField field = (JFormattedTextField)e.getSource();
            try {
                field.commitEdit();
            }
            catch (ParseException ex) {
                System.out.println(ex.getMessage());
            }
            if (this.doNotUpdate) {
                return;
            }
            double min = Double.parseDouble("" + field.getValue());
            if (!SharedActionsXTPN.access().setGammaMinTime(min, this.thePlace, this.eLocation)) {
                this.doNotUpdate = true;
                field.setValue(this.thePlace.getGammaMinValue());
                this.doNotUpdate = false;
                this.overlord.markNetChange();
            }
            this.doNotUpdate = true;
            this.gammaMaxTextField.setValue(this.thePlace.getGammaMaxValue());
            this.doNotUpdate = false;
            WorkspaceSheet ws = GUIManager.getDefaultGUIManager().getWorkspace().getSheets().get(0);
            ws.getGraphPanel().getSelectionManager().selectOneElementLocation(this.eLocation);
        });
        this.gammaMaxTextField = new JFormattedTextField(formatter);
        this.gammaMaxTextField.setValue(example);
        this.gammaMaxTextField.setValue(this.thePlace.getGammaMaxValue());
        this.gammaMaxTextField.addPropertyChangeListener("value", e -> {
            JFormattedTextField field = (JFormattedTextField)e.getSource();
            try {
                field.commitEdit();
            }
            catch (ParseException ex) {
                System.out.println(ex.getMessage());
            }
            if (this.doNotUpdate) {
                return;
            }
            double max = Double.parseDouble("" + field.getValue());
            if (!SharedActionsXTPN.access().setGammaMaxTime(max, this.thePlace, this.eLocation)) {
                this.doNotUpdate = true;
                field.setValue(this.thePlace.getGammaMaxValue());
                this.doNotUpdate = false;
                this.overlord.markNetChange();
            }
            this.doNotUpdate = true;
            this.gammaMinTextField.setValue(this.thePlace.getGammaMinValue());
            this.doNotUpdate = false;
            WorkspaceSheet ws = GUIManager.getDefaultGUIManager().getWorkspace().getSheets().get(0);
            ws.getGraphPanel().getSelectionManager().selectOneElementLocation(this.eLocation);
        });
        if (!this.thePlace.isGammaModeActive()) {
            this.gammaMinTextField.setEnabled(false);
            this.gammaMaxTextField.setEnabled(false);
        }
        this.gammaMinTextField.setBounds(infPanelX + 80, infPanelY, 90, 20);
        infoPanel.add(this.gammaMinTextField);
        JLabel slash1 = new JLabel(" / ", 2);
        slash1.setBounds(infPanelX + 170, infPanelY, 15, 20);
        infoPanel.add(slash1);
        this.gammaMaxTextField.setBounds(infPanelX + 190, infPanelY, 90, 20);
        infoPanel.add(this.gammaMaxTextField);
        JLabel tokenInfoLabel = new JLabel("Tokens:");
        tokenInfoLabel.setBounds(infPanelX, infPanelY += 25, 90, 20);
        infoPanel.add(tokenInfoLabel);
        this.tokensWindowButton = new HolmesRoundedButton("<html>Token window</html>", "pearl_bH1_neutr.png", "pearl_bH2_hover.png", "pearl_bH3_press.png");
        this.tokensWindowButton.setMargin(new Insets(0, 0, 0, 0));
        this.tokensWindowButton.setBounds(infPanelX + 80, infPanelY, 100, 25);
        if (!this.thePlace.isGammaModeActive()) {
            this.tokensWindowButton.setEnabled(false);
        }
        this.tokensWindowButton.addActionListener(actionEvent -> new HolmesXTPNtokens(this.thePlace, this, this.thePlace.accessMultiset(), this.thePlace.isGammaModeActive()));
        infoPanel.add(this.tokensWindowButton);
        JLabel tokenNumberInfoLabel = new JLabel("Current number:");
        tokenNumberInfoLabel.setBounds(infPanelX + 190, infPanelY, 120, 20);
        infoPanel.add(tokenNumberInfoLabel);
        this.tokensTextBox = new JFormattedTextField((Object)"0");
        this.tokensTextBox.setBounds(infPanelX + 310, infPanelY, 30, 20);
        this.tokensTextBox.setEditable(false);
        infoPanel.add(this.tokensTextBox);
        this.printTokenNumber();
        JPanel chartMainPanel = new JPanel(new BorderLayout());
        chartMainPanel.setBorder(BorderFactory.createTitledBorder("Places chart"));
        chartMainPanel.setBounds(0, infoPanel.getHeight(), this.mainInfoPanel.getWidth() - 18, 295);
        chartMainPanel.add((Component)this.createChartPanel(this.thePlace), "Center");
        chartMainPanel.setBackground(Color.WHITE);
        this.mainInfoPanel.add(chartMainPanel);
        JPanel chartButtonPanel = this.panelButtonsPlace(infoPanel.getHeight() + chartMainPanel.getHeight());
        this.mainInfoPanel.add(chartButtonPanel);
        try {
            if (this.overlord.getWorkspace().getProject().getTransitions().size() > 0 && this.overlord.getWorkspace().getProject().getPlaces().size() > 0) {
                this.fillPlaceDynamicData(chartMainPanel);
            }
        }
        catch (Exception ex) {
            this.overlord.log("Error while trying to simulate and compute place data.", "error", true);
        }
        return this.mainInfoPanel;
    }

    private JPanel initializePlaceInvPanel() {
        JPanel panel = new JPanel(null);
        panel.setBounds(0, 0, 600, 470);
        panel.setBackground(Color.WHITE);
        return panel;
    }

    private JPanel panelButtonsPlace(int y) {
        JPanel chartButtonPanel = new JPanel(null);
        chartButtonPanel.setBounds(0, y, this.mainInfoPanel.getWidth() - 18, 60);
        chartButtonPanel.setBorder(BorderFactory.createTitledBorder("Simulation options:"));
        chartButtonPanel.setBackground(Color.WHITE);
        int positionX = 5;
        int positionY = 30;
        this.acqDataButton = new HolmesRoundedButton("<html>Simulate</html>", "jade_bH1_neutr.png", "amber_bH2_hover.png", "amber_bH3_press.png");
        this.acqDataButton.setBounds(positionX, positionY - 10, 110, 35);
        this.acqDataButton.setMargin(new Insets(0, 0, 0, 0));
        this.acqDataButton.setToolTipText("Compute steps from zero marking through the number of states given on the right.");
        this.acqDataButton.addActionListener(actionEvent -> {
            if (this.overlord.getWorkspace().getProject().isSimulationActive()) {
                JOptionPane.showMessageDialog(null, "Holmes simulator is running. Please wait or stop it manually first.", "Simulator active", 2);
            } else {
                this.acqDataButton.setEnabled(false);
                this.getPlaceSimpleChartData(this.simPlaceNumberOfReps);
            }
        });
        chartButtonPanel.add(this.acqDataButton);
        JLabel simPlaceStepLabel = new JLabel("Steps:");
        simPlaceStepLabel.setBounds(positionX + 120, positionY - 15, 60, 15);
        chartButtonPanel.add(simPlaceStepLabel);
        SpinnerNumberModel simStepsSpinnerModel = new SpinnerNumberModel(this.simSteps, 0, 100000000, 10000);
        JSpinner simStepsSpinner = new JSpinner(simStepsSpinnerModel);
        simStepsSpinner.setBounds(positionX + 120, positionY, 80, 25);
        simStepsSpinner.addChangeListener(e -> {
            JSpinner spinner = (JSpinner)e.getSource();
            this.simSteps = (Integer)spinner.getValue();
        });
        chartButtonPanel.add(simStepsSpinner);
        JLabel label1 = new JLabel("Show:");
        label1.setBounds(positionX + 210, positionY - 15, 50, 15);
        chartButtonPanel.add(label1);
        JComboBox<String> simMode = new JComboBox<String>(new String[]{"Steps", "Time"});
        simMode.setBounds(positionX + 210, positionY, 80, 25);
        simMode.setSelectedIndex(0);
        simMode.setMaximumRowCount(6);
        simMode.addActionListener(actionEvent -> {
            this.placeChartType = simMode.getSelectedIndex();
            this.showPlaceChart();
        });
        chartButtonPanel.add(simMode);
        JCheckBox simPlaceRepsCheckbox = new JCheckBox("Reps:");
        simPlaceRepsCheckbox.setBounds(positionX + 295, positionY - 15, 70, 15);
        simPlaceRepsCheckbox.setSelected(this.simulateTime);
        simPlaceRepsCheckbox.setBackground(Color.WHITE);
        simPlaceRepsCheckbox.addItemListener(e -> {
            if (this.doNotUpdate) {
                return;
            }
            JCheckBox box = (JCheckBox)e.getSource();
            this.simPlaceReps = box.isSelected();
        });
        chartButtonPanel.add(simPlaceRepsCheckbox);
        SpinnerNumberModel simStepsRepeatedSpinnerModel = new SpinnerNumberModel(this.simPlaceNumberOfReps, 1, 100, 10);
        JSpinner simStepsRepeatedSpinner = new JSpinner(simStepsRepeatedSpinnerModel);
        simStepsRepeatedSpinner.setBounds(positionX + 300, positionY, 70, 25);
        simStepsRepeatedSpinner.addChangeListener(e -> {
            JSpinner spinner = (JSpinner)e.getSource();
            this.simPlaceNumberOfReps = (Integer)spinner.getValue();
        });
        chartButtonPanel.add(simStepsRepeatedSpinner);
        JLabel simPlaceIntervalLabel = new JLabel("Interval:");
        simPlaceIntervalLabel.setBounds(positionX + 380, positionY - 15, 80, 15);
        chartButtonPanel.add(simPlaceIntervalLabel);
        SpinnerNumberModel simIntervalSpinnerModel = new SpinnerNumberModel(this.simPlaceInterval, 1, 1000, 10);
        JSpinner simIntervalSpinner = new JSpinner(simIntervalSpinnerModel);
        simIntervalSpinner.setBounds(positionX + 380, positionY, 60, 25);
        simIntervalSpinner.addChangeListener(e -> {
            JSpinner spinner = (JSpinner)e.getSource();
            this.simPlaceInterval = (Integer)spinner.getValue();
            this.showPlaceChart();
        });
        chartButtonPanel.add(simIntervalSpinner);
        return chartButtonPanel;
    }

    private void fillPlaceDynamicData(JPanel chartMainPanel) {
        if (!this.mainSimulatorActive) {
            this.getPlaceSimpleChartData(1);
        } else {
            chartMainPanel.setEnabled(false);
            TextTitle title = this.dynamicsChart.getTitle();
            title.setBorder(2.0, 2.0, 2.0, 2.0);
            title.setBackgroundPaint(Color.white);
            title.setFont(new Font("Dialog", 0, 20));
            title.setExpandToFitSpace(true);
            title.setPaint(Color.red);
            title.setText("Chart unavailable, main simulator is active.");
        }
    }

    private void getPlaceSimpleChartData(int reps) {
        StateSimulatorXTPN ss = new StateSimulatorXTPN();
        this.ownSettings.setNetType(SimulatorGlobals.SimNetType.XTPN, true);
        this.ownSettings.setSimSteps_XTPN(this.simSteps);
        this.ownSettings.setTimeSimulationStatus_XTPN(false);
        ss.initiateSim(this.ownSettings);
        if (!this.simPlaceReps) {
            reps = 1;
        }
        ArrayList<ArrayList<Double>> firstDataVectors = ss.simulateNetSinglePlace(this.ownSettings, this.thePlace, reps);
        this.stepsVectorPlaces = new ArrayList(firstDataVectors.get(0));
        this.timeVectorPlaces = new ArrayList(firstDataVectors.get(1));
        this.acqDataButton.setEnabled(true);
        this.showPlaceChart();
    }

    private void showPlaceChart() {
        this.dynamicsSeriesDataSet.removeAllSeries();
        XYSeries series = new XYSeries((Comparable)((Object)"Number of tokens"));
        int maxInterval = this.simPlaceInterval;
        if (10 * this.simPlaceInterval > this.stepsVectorPlaces.size()) {
            maxInterval = 1;
            this.overlord.log("Warning: place node window interval too big, reduced to 1.", "warning", true);
        }
        if (this.stepsVectorPlaces != null) {
            double sumTokens = 0.0;
            int interval = 0;
            for (int step = 0; step < this.stepsVectorPlaces.size(); ++step) {
                double value = this.stepsVectorPlaces.get(step);
                sumTokens += value;
                if (interval++ != maxInterval) continue;
                sumTokens /= (double)maxInterval;
                if (this.placeChartType == 0) {
                    series.add((double)step, (int)sumTokens);
                } else {
                    double time = this.timeVectorPlaces.get(step);
                    series.add(time, (int)sumTokens);
                }
                sumTokens = 0.0;
                interval = 0;
            }
        }
        this.dynamicsSeriesDataSet.addSeries(series);
    }

    JPanel createChartPanel(Node node) {
        String chartTitle = node.getName() + " dynamics";
        String xAxisLabel = "Simulation steps";
        String yAxisLabel = "Tokens";
        if (node instanceof Transition) {
            yAxisLabel = "Firings chance %";
        }
        boolean showLegend = true;
        boolean createTooltip = true;
        boolean createURL = false;
        this.dynamicsSeriesDataSet = new XYSeriesCollection();
        this.dynamicsChart = ChartFactory.createXYLineChart(chartTitle, xAxisLabel, yAxisLabel, this.dynamicsSeriesDataSet, PlotOrientation.VERTICAL, showLegend, createTooltip, createURL);
        this.dynamicsChart.getTitle().setFont(new Font("Dialog", 0, 14));
        return new ChartPanel(this.dynamicsChart);
    }

    public void printTokenNumber() {
        int tokens = this.thePlace.isGammaModeActive() ? this.thePlace.accessMultiset().size() : this.thePlace.getTokensNumber();
        this.tokensTextBox.setText("" + tokens);
    }

    private JPanel initializeTransInvPanel() {
        JPanel panel = new JPanel(null);
        panel.setBounds(0, 0, 600, 480);
        panel.setBackground(Color.WHITE);
        return panel;
    }

    private JPanel initializeTransitionInfo() {
        this.mainInfoPanel = new JPanel(null);
        this.mainInfoPanel.setBounds(0, 0, 800, 680);
        this.mainInfoPanel.setBackground(Color.WHITE);
        int mPanelX = 0;
        int mPanelY = 0;
        JPanel infoPanel = new JPanel(null);
        infoPanel.setBounds(mPanelX, mPanelY, this.mainInfoPanel.getWidth() - 18, 185);
        infoPanel.setBorder(BorderFactory.createTitledBorder("Structural data:"));
        infoPanel.setBackground(Color.WHITE);
        int infPanelX = 10;
        int infPanelY = 20;
        JLabel labelID = new JLabel("ID:");
        labelID.setBounds(infPanelX, infPanelY, 20, 20);
        infoPanel.add(labelID);
        int id = this.overlord.getWorkspace().getProject().getTransitions().indexOf(this.theTransition);
        JFormattedTextField idTextBox = new JFormattedTextField((Object)id);
        idTextBox.setBounds(infPanelX + 20, infPanelY, 30, 20);
        idTextBox.setEditable(false);
        infoPanel.add(idTextBox);
        JLabel labelName = new JLabel("Name:");
        labelName.setBounds(infPanelX + 60, infPanelY, 40, 20);
        infoPanel.add(labelName);
        DefaultFormatter format = new DefaultFormatter();
        format.setOverwriteMode(false);
        JFormattedTextField nameField = new JFormattedTextField(format);
        nameField.setLocation(infPanelX + 100, infPanelY);
        nameField.setSize(350, 20);
        nameField.setValue(this.theTransition.getName());
        nameField.addPropertyChangeListener("value", e -> {
            JFormattedTextField field = (JFormattedTextField)e.getSource();
            try {
                field.commitEdit();
            }
            catch (ParseException ex) {
                GUIManager.getDefaultGUIManager().log("Error (212156495) | Exception:  " + ex.getMessage(), "error", true);
            }
            String newName = field.getText();
            this.theTransition.setName(newName);
            this.action.repaintGraphPanel(this.theTransition);
        });
        infoPanel.add(nameField);
        JLabel commmentLabel = new JLabel("Comments:", 2);
        commmentLabel.setBounds(infPanelX + 460, infPanelY - 22, 100, 20);
        infoPanel.add(commmentLabel);
        JTextArea commentField = new JTextArea(this.theTransition.getComment());
        commentField.setLineWrap(true);
        commentField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                JTextArea field = (JTextArea)e.getSource();
                String newComment = "";
                if (field != null) {
                    newComment = field.getText();
                }
                HolmesNodeInfoXTPN.this.theTransition.setComment(newComment);
            }
        });
        JPanel creationPanel = new JPanel();
        creationPanel.setLayout(new BorderLayout());
        creationPanel.add((Component)new JScrollPane(commentField), "Center");
        creationPanel.setBounds(infPanelX + 460, infPanelY, 300, 70);
        infoPanel.add(creationPanel);
        this.mainInfoPanel.add(infoPanel);
        JLabel portalLabel = new JLabel("Portal:");
        portalLabel.setBounds(infPanelX, infPanelY += 25, 40, 20);
        infoPanel.add(portalLabel);
        String port = "no";
        if (this.theTransition.isPortal()) {
            port = "yes";
        }
        JLabel portalLabel2 = new JLabel(port);
        portalLabel2.setBounds(infPanelX + 40, infPanelY, 30, 20);
        infoPanel.add(portalLabel2);
        int preP = 0;
        int postP = 0;
        for (ElementLocation el : this.theTransition.getElementLocations()) {
            preP += el.getInArcs().size();
            postP += el.getOutArcs().size();
        }
        JLabel prePlaceLabel = new JLabel("Input places:");
        prePlaceLabel.setBounds(infPanelX + 60, infPanelY, 120, 20);
        infoPanel.add(prePlaceLabel);
        JFormattedTextField prePlaceTextBox = new JFormattedTextField((Object)preP);
        prePlaceTextBox.setBounds(infPanelX + 160, infPanelY, 25, 20);
        prePlaceTextBox.setEditable(false);
        infoPanel.add(prePlaceTextBox);
        JLabel postPlaceLabel = new JLabel("Output places:");
        postPlaceLabel.setBounds(infPanelX + 190, infPanelY, 120, 20);
        infoPanel.add(postPlaceLabel);
        JFormattedTextField postPlaceTextBox = new JFormattedTextField((Object)postP);
        postPlaceTextBox.setBounds(infPanelX + 310, infPanelY, 30, 20);
        postPlaceTextBox.setEditable(false);
        infoPanel.add(postPlaceTextBox);
        JLabel timeModesInfoLabel = new JLabel("Time modes:");
        timeModesInfoLabel.setBounds(infPanelX, infPanelY += 25, 80, 20);
        infoPanel.add(timeModesInfoLabel);
        this.buttonAlphaMode = new HolmesRoundedButton("<html>Alpha: ON</html>", "jade_bH1_neutr.png", "amber_bH2_hover.png", "amber_bH3_press.png");
        this.buttonAlphaMode.setMargin(new Insets(0, 0, 0, 0));
        this.buttonAlphaMode.setName("alphaButton1");
        this.buttonAlphaMode.setBounds(infPanelX + 80, infPanelY, 100, 25);
        this.buttonAlphaMode.setFocusPainted(false);
        if (this.theTransition.isAlphaModeActive()) {
            this.buttonAlphaMode.setNewText("<html>Alpha: ON</html>");
            this.buttonAlphaMode.repaintBackground("jade_bH1_neutr.png", "amber_bH2_hover.png", "amber_bH3_press.png");
        } else {
            this.buttonAlphaMode.setNewText("<html>Alpha: OFF</html>");
            this.buttonAlphaMode.repaintBackground("amber_bH1_neutr.png", "jade_bH2_hover.png", "jade_bH3_press.png");
        }
        this.buttonAlphaMode.addActionListener(e -> {
            this.doNotUpdate = true;
            SharedActionsXTPN.access().buttonAlphaSwitchMode(e, this.theTransition, this, this.tauVisibilityButton, this.buttonClassXTPNmode, this.alphaMaxTextField, this.eLocation);
            this.doNotUpdate = false;
            this.action.reselectElement(this.eLocation);
            this.setFieldStatus(false);
        });
        infoPanel.add(this.buttonAlphaMode);
        JLabel alphaVisInfoLabel = new JLabel("Visibility:");
        alphaVisInfoLabel.setBounds(infPanelX + 190, infPanelY, 70, 20);
        infoPanel.add(alphaVisInfoLabel);
        this.alphaVisibilityButton = new HolmesRoundedButton("<html>\u03b1: Visible</html>", "jade_bH1_neutr.png", "amber_bH2_hover.png", "amber_bH3_press.png");
        this.alphaVisibilityButton.setMargin(new Insets(0, 0, 0, 0));
        this.alphaVisibilityButton.setName("gammaVisButton1");
        this.alphaVisibilityButton.setBounds(infPanelX + 250, infPanelY, 100, 25);
        this.alphaVisibilityButton.setFocusPainted(false);
        if (this.theTransition.isAlphaModeActive()) {
            if (this.theTransition.isAlphaRangeVisible()) {
                this.alphaVisibilityButton.setNewText("<html>\u03b1: Visible<html>");
                this.alphaVisibilityButton.repaintBackground("jade_bH1_neutr.png", "amber_bH2_hover.png", "amber_bH3_press.png");
            } else {
                this.alphaVisibilityButton.setNewText("<html>\u03b1: Hidden<html>");
                this.alphaVisibilityButton.repaintBackground("amber_bH1_neutr.png", "jade_bH2_hover.png", "jade_bH3_press.png");
            }
        } else {
            this.alphaVisibilityButton.setNewText("<html>\u03b1: Hidden<html>");
            this.alphaVisibilityButton.repaintBackground("amber_bH1_neutr.png", "jade_bH2_hover.png", "jade_bH3_press.png");
            this.alphaVisibilityButton.setEnabled(false);
        }
        this.alphaVisibilityButton.addActionListener(e -> {
            HolmesRoundedButton button = (HolmesRoundedButton)e.getSource();
            if (this.theTransition.isAlphaRangeVisible()) {
                this.theTransition.setAlphaRangeVisibility(false);
                button.setNewText("<html>\u03b1: Hidden<html>");
                button.repaintBackground("amber_bH1_neutr.png", "jade_bH2_hover.png", "jade_bH3_press.png");
            } else {
                this.theTransition.setAlphaRangeVisibility(true);
                button.setNewText("<html>\u03b1: Visible<html>");
                button.repaintBackground("jade_bH1_neutr.png", "amber_bH2_hover.png", "amber_bH3_press.png");
            }
            GUIManager.getDefaultGUIManager().getWorkspace().getProject().repaintAllGraphPanels();
            button.setFocusPainted(false);
            this.action.reselectElement(this.eLocation);
            this.setFieldStatus(false);
        });
        infoPanel.add(this.alphaVisibilityButton);
        this.buttonBetaMode = new HolmesRoundedButton("<html>Beta: ON</html>", "jade_bH1_neutr.png", "amber_bH2_hover.png", "amber_bH3_press.png");
        this.buttonBetaMode.setMargin(new Insets(0, 0, 0, 0));
        this.buttonBetaMode.setName("alphaButton1");
        this.buttonBetaMode.setBounds(infPanelX + 80, infPanelY += 30, 100, 25);
        this.buttonBetaMode.setFocusPainted(false);
        if (this.theTransition.isAlphaModeActive()) {
            this.buttonBetaMode.setNewText("<html>Beta: ON</html>");
            this.buttonBetaMode.repaintBackground("jade_bH1_neutr.png", "amber_bH2_hover.png", "amber_bH3_press.png");
        } else {
            this.buttonBetaMode.setNewText("<html>Beta: OFF</html>");
            this.buttonBetaMode.repaintBackground("amber_bH1_neutr.png", "jade_bH2_hover.png", "jade_bH3_press.png");
        }
        this.buttonBetaMode.addActionListener(e -> {
            this.doNotUpdate = true;
            SharedActionsXTPN.access().buttonBetaSwitchMode(e, this.theTransition, this, this.tauVisibilityButton, this.buttonClassXTPNmode, this.betaMaxTextField, this.eLocation);
            this.doNotUpdate = false;
            this.action.reselectElement(this.eLocation);
            this.setFieldStatus(false);
        });
        infoPanel.add(this.buttonBetaMode);
        JLabel betaVisInfoLabel = new JLabel("Visibility:");
        betaVisInfoLabel.setBounds(infPanelX + 190, infPanelY, 70, 20);
        infoPanel.add(betaVisInfoLabel);
        this.betaVisibilityButton = new HolmesRoundedButton("<html>\u03b2: Visible</html>", "jade_bH1_neutr.png", "amber_bH2_hover.png", "amber_bH3_press.png");
        this.betaVisibilityButton.setMargin(new Insets(0, 0, 0, 0));
        this.betaVisibilityButton.setName("gammaVisButton1");
        this.betaVisibilityButton.setBounds(infPanelX + 250, infPanelY, 100, 25);
        this.betaVisibilityButton.setFocusPainted(false);
        if (this.theTransition.isBetaModeActive()) {
            if (this.theTransition.isBetaRangeVisible()) {
                this.betaVisibilityButton.setNewText("<html>\u03b2: Visible<html>");
                this.betaVisibilityButton.repaintBackground("jade_bH1_neutr.png", "amber_bH2_hover.png", "amber_bH3_press.png");
            } else {
                this.betaVisibilityButton.setNewText("<html>\u03b2: Hidden<html>");
                this.betaVisibilityButton.repaintBackground("amber_bH1_neutr.png", "jade_bH2_hover.png", "jade_bH3_press.png");
            }
        } else {
            this.betaVisibilityButton.setNewText("<html>\u03b2: Hidden<html>");
            this.betaVisibilityButton.repaintBackground("amber_bH1_neutr.png", "jade_bH2_hover.png", "jade_bH3_press.png");
            this.betaVisibilityButton.setEnabled(false);
        }
        this.betaVisibilityButton.addActionListener(e -> {
            HolmesRoundedButton button = (HolmesRoundedButton)e.getSource();
            if (this.theTransition.isBetaRangeVisible()) {
                this.theTransition.setBetaRangeVisibility(false);
                button.setNewText("<html>\u03b2: Hidden<html>");
                button.repaintBackground("amber_bH1_neutr.png", "jade_bH2_hover.png", "jade_bH3_press.png");
            } else {
                this.theTransition.setBetaRangeVisibility(true);
                button.setNewText("<html>\u03b2: Visible<html>");
                button.repaintBackground("jade_bH1_neutr.png", "amber_bH2_hover.png", "amber_bH3_press.png");
            }
            GUIManager.getDefaultGUIManager().getWorkspace().getProject().repaintAllGraphPanels();
            button.setFocusPainted(false);
            this.action.reselectElement(this.eLocation);
            this.setFieldStatus(false);
        });
        infoPanel.add(this.betaVisibilityButton);
        JLabel classXTPNInfoLabel = new JLabel("Classical/XTPN:");
        classXTPNInfoLabel.setBounds(infPanelX + 360, infPanelY, 120, 20);
        infoPanel.add(classXTPNInfoLabel);
        this.buttonClassXTPNmode = new HolmesRoundedButton("<html>XTPN</html>", "jade_bH1_neutr.png", "amber_bH2_hover.png", "amber_bH3_press.png");
        this.buttonClassXTPNmode.setMargin(new Insets(0, 0, 0, 0));
        this.buttonClassXTPNmode.setName("alphaButton1");
        this.buttonClassXTPNmode.setBounds(infPanelX + 460, infPanelY, 100, 25);
        this.buttonClassXTPNmode.setFocusPainted(false);
        if (!this.theTransition.isAlphaModeActive() && !this.theTransition.isBetaModeActive()) {
            this.buttonClassXTPNmode.setNewText("<html>Classical<html>");
            this.buttonClassXTPNmode.repaintBackground("amber_bH1_neutr.png", "jade_bH2_hover.png", "jade_bH3_press.png");
        } else {
            this.buttonClassXTPNmode.setNewText("<html>XTPN<html>");
            this.buttonClassXTPNmode.repaintBackground("jade_bH1_neutr.png", "amber_bH2_hover.png", "amber_bH3_press.png");
        }
        this.buttonClassXTPNmode.addActionListener(e -> {
            if (this.doNotUpdate) {
                return;
            }
            this.doNotUpdate = true;
            SharedActionsXTPN.access().buttonTransitionToXTPN_classicSwitchMode(e, this.theTransition, this, this.alphaMaxTextField, this.betaMaxTextField, this.eLocation);
            this.doNotUpdate = false;
            this.setFieldStatus(false);
        });
        infoPanel.add(this.buttonClassXTPNmode);
        JLabel tauVisInfoLabel = new JLabel("Tau:");
        tauVisInfoLabel.setBounds(infPanelX + 570, infPanelY, 50, 20);
        infoPanel.add(tauVisInfoLabel);
        this.tauVisibilityButton = new HolmesRoundedButton("<html>\u03c4: Visible</html>", "jade_bH1_neutr.png", "amber_bH2_hover.png", "amber_bH3_press.png");
        this.tauVisibilityButton.setMargin(new Insets(0, 0, 0, 0));
        this.tauVisibilityButton.setName("gammaVisButton1");
        this.tauVisibilityButton.setBounds(infPanelX + 600, infPanelY, 100, 25);
        this.tauVisibilityButton.setFocusPainted(false);
        if (this.theTransition.isAlphaModeActive() || this.theTransition.isBetaModeActive()) {
            if (this.theTransition.isTauTimerVisible()) {
                this.tauVisibilityButton.setNewText("<html>\u03c4: Visible<html>");
                this.tauVisibilityButton.repaintBackground("jade_bH1_neutr.png", "amber_bH2_hover.png", "amber_bH3_press.png");
            } else {
                this.tauVisibilityButton.setNewText("<html>\u03c4: Hidden<html>");
                this.tauVisibilityButton.repaintBackground("amber_bH1_neutr.png", "jade_bH2_hover.png", "jade_bH3_press.png");
            }
        } else {
            this.tauVisibilityButton.setEnabled(false);
        }
        this.tauVisibilityButton.addActionListener(e -> {
            if (this.doNotUpdate) {
                return;
            }
            HolmesRoundedButton button = (HolmesRoundedButton)e.getSource();
            if (this.theTransition.isTauTimerVisible()) {
                this.theTransition.setTauTimersVisibility(false);
                button.setNewText("<html>\u03c4: Hidden<html>");
                button.repaintBackground("amber_bH1_neutr.png", "jade_bH2_hover.png", "jade_bH3_press.png");
            } else {
                this.theTransition.setTauTimersVisibility(true);
                button.setNewText("<html>\u03c4: Visible<html>");
                button.repaintBackground("jade_bH1_neutr.png", "amber_bH2_hover.png", "amber_bH3_press.png");
                this.overlord.setNameLocationChangeMode(null, null, GUIManager.locationMoveType.NONE);
            }
            GUIManager.getDefaultGUIManager().getWorkspace().getProject().repaintAllGraphPanels();
            button.setFocusPainted(false);
            this.action.reselectElement(this.eLocation);
            this.setFieldStatus(false);
        });
        infoPanel.add(this.tauVisibilityButton);
        JLabel minMaxLabel = new JLabel("\u03b1 (min/max): ", 2);
        minMaxLabel.setBounds(infPanelX, infPanelY += 30, 80, 20);
        infoPanel.add(minMaxLabel);
        NumberFormat formatter = DecimalFormat.getInstance();
        formatter.setMinimumFractionDigits(2);
        formatter.setMaximumFractionDigits(6);
        formatter.setRoundingMode(RoundingMode.HALF_UP);
        Double example = 3.14;
        this.alphaMinTextField = new JFormattedTextField(formatter);
        this.alphaMinTextField.setValue(example);
        this.alphaMinTextField.setValue(this.theTransition.getAlphaMinValue());
        this.alphaMinTextField.addPropertyChangeListener("value", e -> {
            if (this.doNotUpdate) {
                return;
            }
            JFormattedTextField field = (JFormattedTextField)e.getSource();
            try {
                field.commitEdit();
            }
            catch (ParseException ex) {
                System.out.println(ex.getMessage());
            }
            double min = Double.parseDouble("" + field.getValue());
            SharedActionsXTPN.access().setAlfaMinTime(min, this.theTransition, this.eLocation);
            this.doNotUpdate = true;
            this.alphaMaxTextField.setValue(this.theTransition.getAlphaMaxValue());
            field.setValue(this.theTransition.getAlphaMinValue());
            this.doNotUpdate = false;
            this.overlord.markNetChange();
            this.setFieldStatus(false);
            WorkspaceSheet ws = GUIManager.getDefaultGUIManager().getWorkspace().getSheets().get(0);
            ws.getGraphPanel().getSelectionManager().selectOneElementLocation(this.eLocation);
        });
        this.alphaMaxTextField = new JFormattedTextField(formatter);
        this.alphaMaxTextField.setValue(example);
        this.alphaMaxTextField.setValue(this.theTransition.getAlphaMaxValue());
        this.alphaMaxTextField.addPropertyChangeListener("value", e -> {
            if (this.doNotUpdate) {
                return;
            }
            JFormattedTextField field = (JFormattedTextField)e.getSource();
            try {
                field.commitEdit();
            }
            catch (ParseException ex) {
                System.out.println(ex.getMessage());
            }
            double max = Double.parseDouble("" + field.getValue());
            SharedActionsXTPN.access().setAlfaMaxTime(max, this.theTransition, this.eLocation);
            this.doNotUpdate = true;
            this.alphaMinTextField.setValue(this.theTransition.getAlphaMinValue());
            field.setValue(this.theTransition.getAlphaMaxValue());
            this.doNotUpdate = false;
            this.overlord.markNetChange();
            this.setFieldStatus(false);
            WorkspaceSheet ws = GUIManager.getDefaultGUIManager().getWorkspace().getSheets().get(0);
            ws.getGraphPanel().getSelectionManager().selectOneElementLocation(this.eLocation);
        });
        if (!this.theTransition.isAlphaModeActive()) {
            this.alphaMinTextField.setEnabled(false);
            this.alphaMaxTextField.setEnabled(false);
        }
        this.alphaMinTextField.setBounds(infPanelX + 80, infPanelY, 90, 20);
        infoPanel.add(this.alphaMinTextField);
        JLabel slash1 = new JLabel(" / ", 2);
        slash1.setBounds(infPanelX + 170, infPanelY, 15, 20);
        infoPanel.add(slash1);
        this.alphaMaxTextField.setBounds(infPanelX + 190, infPanelY, 90, 20);
        infoPanel.add(this.alphaMaxTextField);
        JLabel betaLabel = new JLabel("\u03b2 (min/max): ", 2);
        betaLabel.setBounds(infPanelX, infPanelY += 25, 80, 20);
        infoPanel.add(betaLabel);
        this.betaMinTextField = new JFormattedTextField(formatter);
        this.betaMinTextField.setValue(example);
        this.betaMinTextField.setValue(this.theTransition.getBetaMinValue());
        this.betaMinTextField.addPropertyChangeListener("value", e -> {
            if (this.doNotUpdate) {
                return;
            }
            JFormattedTextField field = (JFormattedTextField)e.getSource();
            try {
                field.commitEdit();
            }
            catch (ParseException ex) {
                System.out.println(ex.getMessage());
            }
            double min = Double.parseDouble("" + field.getValue());
            SharedActionsXTPN.access().setBetaMinTime(min, this.theTransition, this.eLocation);
            this.doNotUpdate = true;
            field.setValue(this.theTransition.getBetaMinValue());
            this.betaMaxTextField.setValue(this.theTransition.getBetaMaxValue());
            this.doNotUpdate = false;
            this.overlord.markNetChange();
            this.setFieldStatus(false);
            WorkspaceSheet ws = GUIManager.getDefaultGUIManager().getWorkspace().getSheets().get(0);
            ws.getGraphPanel().getSelectionManager().selectOneElementLocation(this.eLocation);
        });
        this.betaMaxTextField = new JFormattedTextField(formatter);
        this.betaMaxTextField.setValue(example);
        this.betaMaxTextField.setValue(this.theTransition.getBetaMaxValue());
        this.betaMaxTextField.addPropertyChangeListener("value", e -> {
            if (this.doNotUpdate) {
                return;
            }
            JFormattedTextField field = (JFormattedTextField)e.getSource();
            try {
                field.commitEdit();
            }
            catch (ParseException ex) {
                System.out.println(ex.getMessage());
            }
            double max = Double.parseDouble("" + field.getValue());
            SharedActionsXTPN.access().setBetaMaxTime(max, this.theTransition, this.eLocation);
            this.doNotUpdate = true;
            this.betaMinTextField.setValue(this.theTransition.getBetaMinValue());
            field.setValue(this.theTransition.getBetaMaxValue());
            this.doNotUpdate = false;
            this.overlord.markNetChange();
            this.setFieldStatus(false);
            WorkspaceSheet ws = GUIManager.getDefaultGUIManager().getWorkspace().getSheets().get(0);
            ws.getGraphPanel().getSelectionManager().selectOneElementLocation(this.eLocation);
        });
        if (!this.theTransition.isBetaModeActive()) {
            this.betaMinTextField.setEnabled(false);
            this.betaMaxTextField.setEnabled(false);
        }
        this.betaMinTextField.setBounds(infPanelX + 80, infPanelY, 90, 20);
        infoPanel.add(this.betaMinTextField);
        JLabel slash3 = new JLabel(" / ", 2);
        slash3.setBounds(infPanelX + 170, infPanelY, 15, 20);
        infoPanel.add(slash3);
        this.betaMaxTextField.setBounds(infPanelX + 190, infPanelY, 90, 20);
        infoPanel.add(this.betaMaxTextField);
        JPanel chartMainPanel = new JPanel(new BorderLayout());
        chartMainPanel.setBorder(BorderFactory.createTitledBorder("Transition chart"));
        chartMainPanel.setBounds(0, infoPanel.getHeight(), this.mainInfoPanel.getWidth() - 18, 280);
        chartMainPanel.add((Component)this.createChartPanel(this.theTransition), "Center");
        chartMainPanel.setBackground(Color.WHITE);
        this.mainInfoPanel.add(chartMainPanel);
        JPanel chartButtonPanel = this.panelButtonsTransition(infoPanel.getHeight() + chartMainPanel.getHeight());
        this.mainInfoPanel.add(chartButtonPanel);
        JPanel simStatsPanel = this.panelSimStatsTransition(infoPanel.getHeight() + chartMainPanel.getHeight() + chartButtonPanel.getHeight());
        this.mainInfoPanel.add(simStatsPanel);
        try {
            if (this.overlord.getWorkspace().getProject().getTransitions().size() > 0 && this.overlord.getWorkspace().getProject().getPlaces().size() > 0) {
                this.fillTransitionDynamicData(this.transStatsFiringStepsTextBox, chartMainPanel, chartButtonPanel);
            }
        }
        catch (Exception ex) {
            this.overlord.log("Error while trying to simulate and compute transition data.", "error", true);
        }
        return this.mainInfoPanel;
    }

    private JPanel panelButtonsTransition(int y) {
        JPanel chartButtonPanel = new JPanel(null);
        chartButtonPanel.setBounds(0, y, this.mainInfoPanel.getWidth() - 18, 60);
        chartButtonPanel.setBorder(BorderFactory.createTitledBorder("Simulation options:"));
        chartButtonPanel.setBackground(Color.WHITE);
        int positionX = 5;
        int positionY = 30;
        this.acqDataButton = new HolmesRoundedButton("<html>Simulate</html>", "jade_bH1_neutr.png", "amber_bH2_hover.png", "amber_bH3_press.png");
        this.acqDataButton.setBounds(positionX, positionY - 10, 110, 35);
        this.acqDataButton.setMargin(new Insets(0, 0, 0, 0));
        this.acqDataButton.setIcon(Tools.getResIcon32("/icons/stateSim/computeData.png"));
        this.acqDataButton.setToolTipText("Compute steps from zero marking through the number of states given on the right.");
        this.acqDataButton.addActionListener(actionEvent -> {
            if (this.overlord.getWorkspace().getProject().isSimulationActive()) {
                JOptionPane.showMessageDialog(null, "Holmes simulator is running. Please wait or stop it manually first.", "Simulator active", 2);
            } else {
                this.acqDataButton.setEnabled(false);
                this.getTransSimpleChartData(this.simTransNumberOfReps);
            }
        });
        chartButtonPanel.add(this.acqDataButton);
        JLabel labelSteps = new JLabel("Steps:");
        labelSteps.setBounds(positionX + 120, positionY - 15, 70, 15);
        chartButtonPanel.add(labelSteps);
        SpinnerNumberModel simStepsSpinnerModel = new SpinnerNumberModel(this.simSteps, 0, 100000000, 10000);
        JSpinner simStepsSpinner = new JSpinner(simStepsSpinnerModel);
        simStepsSpinner.setBounds(positionX + 120, positionY, 80, 25);
        simStepsSpinner.addChangeListener(e -> {
            JSpinner spinner = (JSpinner)e.getSource();
            this.simSteps = (Integer)spinner.getValue();
        });
        chartButtonPanel.add(simStepsSpinner);
        JLabel labelMode = new JLabel("Show:");
        labelMode.setBounds(positionX + 210, positionY - 15, 80, 15);
        chartButtonPanel.add(labelMode);
        JComboBox<String> simMode = new JComboBox<String>(new String[]{"Steps", "Time"});
        simMode.setBounds(positionX + 210, positionY, 80, 25);
        simMode.setSelectedIndex(0);
        simMode.setMaximumRowCount(6);
        simMode.addActionListener(actionEvent -> {
            this.transitionChartType = simMode.getSelectedIndex();
            if (this.statusVectorTransition.size() == 3) {
                this.showTransitionsChart();
            }
        });
        chartButtonPanel.add(simMode);
        JCheckBox simTransRepsCheckbox = new JCheckBox("Reps:");
        simTransRepsCheckbox.setBounds(positionX + 295, positionY - 15, 70, 15);
        simTransRepsCheckbox.setSelected(this.simulateTime);
        simTransRepsCheckbox.setBackground(Color.WHITE);
        simTransRepsCheckbox.addItemListener(e -> {
            if (this.doNotUpdate) {
                return;
            }
            JCheckBox box = (JCheckBox)e.getSource();
            this.simTransReps = box.isSelected();
        });
        chartButtonPanel.add(simTransRepsCheckbox);
        SpinnerNumberModel simTransStepsRepeatedSpinnerModel = new SpinnerNumberModel(this.simPlaceNumberOfReps, 1, 100, 10);
        JSpinner simTransStepsRepeatedSpinner = new JSpinner(simTransStepsRepeatedSpinnerModel);
        simTransStepsRepeatedSpinner.setBounds(positionX + 300, positionY, 70, 25);
        simTransStepsRepeatedSpinner.addChangeListener(e -> {
            JSpinner spinner = (JSpinner)e.getSource();
            this.simTransNumberOfReps = (Integer)spinner.getValue();
        });
        chartButtonPanel.add(simTransStepsRepeatedSpinner);
        JLabel simTransIntervalLabel = new JLabel("Interval:");
        simTransIntervalLabel.setBounds(positionX + 380, positionY - 15, 80, 15);
        chartButtonPanel.add(simTransIntervalLabel);
        SpinnerNumberModel simTransIntervalSpinnerModel = new SpinnerNumberModel(this.simPlaceInterval, 1, 1000, 10);
        JSpinner simTransIntervalSpinner = new JSpinner(simTransIntervalSpinnerModel);
        simTransIntervalSpinner.setBounds(positionX + 380, positionY, 60, 25);
        simTransIntervalSpinner.addChangeListener(e -> {
            JSpinner spinner = (JSpinner)e.getSource();
            this.simTransInterval = (Integer)spinner.getValue();
            this.showTransitionsChart();
        });
        chartButtonPanel.add(simTransIntervalSpinner);
        return chartButtonPanel;
    }

    private JPanel panelSimStatsTransition(int y) {
        JPanel resultPanel = new JPanel(null);
        resultPanel.setBounds(0, y, this.mainInfoPanel.getWidth() - 18, 130);
        resultPanel.setBorder(BorderFactory.createTitledBorder("Simulation data:"));
        resultPanel.setBackground(Color.WHITE);
        int positionX = 10;
        int positionY = 30;
        this.transStatsStepLabel = new JLabel("Steps:", 2);
        this.transStatsStepLabel.setBounds(positionX + 80, positionY - 20, 140, 20);
        resultPanel.add(this.transStatsStepLabel);
        this.transStatsTimeLabel = new JLabel("Time:", 2);
        this.transStatsTimeLabel.setBounds(positionX + 185, positionY - 20, 140, 20);
        resultPanel.add(this.transStatsTimeLabel);
        JLabel inactiveStepsLabel = new JLabel("Inactive:", 2);
        inactiveStepsLabel.setBounds(positionX, positionY, 70, 20);
        resultPanel.add(inactiveStepsLabel);
        this.transStatsInactiveStepsTextBox = new JFormattedTextField((Object)"n/a");
        this.transStatsInactiveStepsTextBox.setBounds(positionX + 80, positionY, 100, 20);
        this.transStatsInactiveStepsTextBox.setEditable(false);
        resultPanel.add(this.transStatsInactiveStepsTextBox);
        this.transStatsInactiveTimeTextBox = new JFormattedTextField((Object)"n/a");
        this.transStatsInactiveTimeTextBox.setBounds(positionX + 185, positionY, 110, 20);
        this.transStatsInactiveTimeTextBox.setEditable(false);
        resultPanel.add(this.transStatsInactiveTimeTextBox);
        HolmesRoundedButton acqTransSimDataButton = new HolmesRoundedButton("<html>Simulate</html>", "jade_bH1_neutr.png", "amber_bH2_hover.png", "amber_bH3_press.png");
        acqTransSimDataButton.setBounds(positionX + 300, positionY, 110, 20);
        acqTransSimDataButton.setMargin(new Insets(0, 0, 0, 0));
        acqTransSimDataButton.setIcon(Tools.getResIcon32("/icons/stateSim/computeData.png"));
        acqTransSimDataButton.setToolTipText("Compute steps from zero marking through the number of states given on the right.");
        acqTransSimDataButton.addActionListener(actionEvent -> {
            if (this.overlord.getWorkspace().getProject().isSimulationActive()) {
                JOptionPane.showMessageDialog(null, "Holmes simulator is running. Please wait or stop it manually first.", "Simulator active", 2);
            } else {
                this.getMultipleTransitionData();
            }
        });
        resultPanel.add(acqTransSimDataButton);
        JLabel activeStepsLabel = new JLabel("Active:", 2);
        activeStepsLabel.setBounds(positionX, positionY += 23, 70, 20);
        resultPanel.add(activeStepsLabel);
        this.transStatsActiveStepsTextBox = new JFormattedTextField((Object)"n/a");
        this.transStatsActiveStepsTextBox.setBounds(positionX + 80, positionY, 100, 20);
        this.transStatsActiveStepsTextBox.setEditable(false);
        resultPanel.add(this.transStatsActiveStepsTextBox);
        this.transStatsActiveTimeTextBox = new JFormattedTextField((Object)"n/a");
        this.transStatsActiveTimeTextBox.setBounds(positionX + 185, positionY, 110, 20);
        this.transStatsActiveTimeTextBox.setEditable(false);
        resultPanel.add(this.transStatsActiveTimeTextBox);
        this.transStatsStepsCheckbox = new JCheckBox("Steps");
        this.transStatsStepsCheckbox.setBounds(positionX + 300, positionY, 70, 20);
        this.transStatsStepsCheckbox.setSelected(this.simulateTime);
        this.transStatsStepsCheckbox.setBackground(Color.WHITE);
        this.transStatsStepsCheckbox.addItemListener(e -> {
            if (this.doNotUpdate) {
                return;
            }
            JCheckBox box = (JCheckBox)e.getSource();
            this.transStatsSimulateWithSteps = box.isSelected();
            this.doNotUpdate = true;
            this.transStatsTimeCheckbox.setSelected(!this.transStatsSimulateWithSteps);
            this.doNotUpdate = false;
        });
        resultPanel.add(this.transStatsStepsCheckbox);
        SpinnerNumberModel simStepsSpinnerModel = new SpinnerNumberModel(this.transStatsNumberOfSteps, 0, 1000000, 5000);
        JSpinner simStepsSpinner = new JSpinner(simStepsSpinnerModel);
        simStepsSpinner.setBounds(positionX + 400, positionY, 70, 20);
        simStepsSpinner.addChangeListener(e -> {
            JSpinner spinner = (JSpinner)e.getSource();
            this.transStatsNumberOfSteps = (Integer)spinner.getValue();
        });
        resultPanel.add(simStepsSpinner);
        JLabel producingStepsLabel = new JLabel("Producing:", 2);
        producingStepsLabel.setBounds(positionX, positionY += 23, 70, 20);
        resultPanel.add(producingStepsLabel);
        this.transStatsProductionStepsTextBox = new JFormattedTextField((Object)"n/a");
        this.transStatsProductionStepsTextBox.setBounds(positionX + 80, positionY, 100, 20);
        this.transStatsProductionStepsTextBox.setEditable(false);
        resultPanel.add(this.transStatsProductionStepsTextBox);
        this.transStatsProductionTimeTextBox = new JFormattedTextField((Object)"n/a");
        this.transStatsProductionTimeTextBox.setBounds(positionX + 185, positionY, 110, 20);
        this.transStatsProductionTimeTextBox.setEditable(false);
        resultPanel.add(this.transStatsProductionTimeTextBox);
        this.transStatsTimeCheckbox = new JCheckBox("Time");
        this.transStatsTimeCheckbox.setBounds(positionX + 300, positionY, 70, 20);
        this.transStatsTimeCheckbox.setSelected(this.simulateTime);
        this.transStatsTimeCheckbox.setBackground(Color.WHITE);
        this.transStatsTimeCheckbox.addItemListener(e -> {
            if (this.doNotUpdate) {
                return;
            }
            JCheckBox box = (JCheckBox)e.getSource();
            this.transStatsSimulateWithSteps = !box.isSelected();
            this.doNotUpdate = true;
            this.transStatsStepsCheckbox.setSelected(this.transStatsSimulateWithSteps);
            this.doNotUpdate = false;
        });
        resultPanel.add(this.transStatsTimeCheckbox);
        SpinnerNumberModel simTimeLengthSpinnerModel = new SpinnerNumberModel(this.transStatsMaxTime, 0.0, 50000.0, 1000.0);
        JSpinner simTimeLengthSpinner = new JSpinner(simTimeLengthSpinnerModel);
        simTimeLengthSpinner.setBounds(positionX + 400, positionY, 70, 20);
        simTimeLengthSpinner.addChangeListener(e -> {
            JSpinner spinner = (JSpinner)e.getSource();
            this.transStatsMaxTime = (Double)spinner.getValue();
        });
        resultPanel.add(simTimeLengthSpinner);
        JLabel producedStepsLabel = new JLabel("Fired:", 2);
        producedStepsLabel.setBounds(positionX, positionY += 23, 70, 20);
        resultPanel.add(producedStepsLabel);
        this.transStatsFiringStepsTextBox = new JFormattedTextField((Object)"n/a");
        this.transStatsFiringStepsTextBox.setBounds(positionX + 80, positionY, 100, 20);
        this.transStatsFiringStepsTextBox.setEditable(false);
        resultPanel.add(this.transStatsFiringStepsTextBox);
        JCheckBox transRepsCheckbox = new JCheckBox("Repetitions:");
        transRepsCheckbox.setBounds(positionX + 300, positionY, 100, 20);
        transRepsCheckbox.setSelected(this.transStatsReps);
        transRepsCheckbox.setBackground(Color.WHITE);
        transRepsCheckbox.addItemListener(e -> {
            if (this.doNotUpdate) {
                return;
            }
            JCheckBox box = (JCheckBox)e.getSource();
            this.transStatsReps = box.isSelected();
        });
        resultPanel.add(transRepsCheckbox);
        SpinnerNumberModel simRepetitionsSpinnerModel = new SpinnerNumberModel(10, 10, 100, 1);
        JSpinner simRepetitionsSpinner = new JSpinner(simRepetitionsSpinnerModel);
        simRepetitionsSpinner.setBounds(positionX + 400, positionY, 70, 20);
        simRepetitionsSpinner.addChangeListener(e -> {
            JSpinner spinner = (JSpinner)e.getSource();
            this.transStatsRepetitions = (Integer)spinner.getValue();
        });
        resultPanel.add(simRepetitionsSpinner);
        this.doNotUpdate = true;
        this.transStatsStepsCheckbox.setSelected(true);
        this.doNotUpdate = false;
        return resultPanel;
    }

    private void fillTransitionDynamicData(JFormattedTextField avgFiredTextBox, JPanel chartMainPanel, JPanel chartButtonPanel) {
        if (!this.mainSimulatorActive) {
            this.getTransSimpleChartData(1);
        } else {
            avgFiredTextBox.setEnabled(false);
            avgFiredTextBox.setText("n/a");
            chartMainPanel.setEnabled(false);
            chartButtonPanel.setEnabled(false);
            TextTitle title = this.dynamicsChart.getTitle();
            title.setBorder(2.0, 2.0, 2.0, 2.0);
            title.setFont(new Font("Dialog", 0, 20));
            title.setExpandToFitSpace(true);
            title.setPaint(Color.red);
            title.setText("Chart unavailable, main simulator is active.");
        }
    }

    private void getTransSimpleChartData(int reps) {
        StateSimulatorXTPN ss = new StateSimulatorXTPN();
        this.ownSettings.setNetType(SimulatorGlobals.SimNetType.XTPN, true);
        this.ownSettings.setSimSteps_XTPN(this.simSteps);
        this.ownSettings.setSimTime_XTPN(this.simTimeLength);
        this.ownSettings.setTimeSimulationStatus_XTPN(this.simulateTime);
        ss.initiateSim(this.ownSettings);
        if (!this.simTransReps) {
            reps = 1;
        }
        this.statusVectorTransition = new ArrayList<ArrayList<Double>>(ss.simulateNetSingleTransition(this.ownSettings, this.theTransition, reps));
        this.acqDataButton.setEnabled(true);
        if (this.statusVectorTransition.size() == 3) {
            this.showTransitionsChart();
        }
    }

    private void getMultipleTransitionData() {
        StateSimulatorXTPN ss = new StateSimulatorXTPN();
        this.ownSettings.setNetType(SimulatorGlobals.SimNetType.XTPN, true);
        this.ownSettings.setSimSteps_XTPN(this.transStatsNumberOfSteps);
        this.ownSettings.setSimTime_XTPN(this.transStatsMaxTime);
        this.ownSettings.setTimeSimulationStatus_XTPN(!this.transStatsSimulateWithSteps);
        ss.initiateSim(this.ownSettings);
        ArrayList<Double> statsVector = null;
        for (int i = 0; i < this.transStatsRepetitions; ++i) {
            ss.restartEngine();
            ArrayList<Double> dataVector = ss.simulateNetSingleTransitionStatistics(this.ownSettings, this.theTransition);
            if (i == 0) {
                statsVector = new ArrayList<Double>(dataVector);
                continue;
            }
            for (int j = 0; j < dataVector.size(); ++j) {
                statsVector.set(j, statsVector.get(j) + dataVector.get(j));
            }
        }
        for (int j = 0; j < statsVector.size(); ++j) {
            statsVector.set(j, (Double)statsVector.get(j) / (double)this.transStatsRepetitions);
        }
        this.fillStatsFields((Double)statsVector.get(0), (Double)statsVector.get(1), statsVector.get(2), statsVector.get(3), statsVector.get(4), statsVector.get(5), statsVector.get(6), statsVector.get(7), statsVector.get(8));
    }

    private void showTransitionsChart() {
        this.dynamicsSeriesDataSet.removeAllSeries();
        XYSeries series0 = new XYSeries((Comparable)((Object)"Avg. inactive"));
        XYSeries series1 = new XYSeries((Comparable)((Object)"Avg. active"));
        XYSeries series2 = new XYSeries((Comparable)((Object)"Avg. producing"));
        XYSeries series3 = new XYSeries((Comparable)((Object)"Avg. firing"));
        int maxInterval = this.simTransInterval;
        if (10 * this.simTransInterval > this.statusVectorTransition.get(0).size()) {
            maxInterval = 1;
            this.overlord.log("Warning: transition node window interval too big, reduced to 1.", "warning", true);
        }
        if (this.statusVectorTransition != null) {
            double inactive = 0.0;
            double active = 0.0;
            double producing = 0.0;
            double firing = 0.0;
            int interval = 0;
            for (int step = 0; step < this.statusVectorTransition.get(0).size(); ++step) {
                double value = this.statusVectorTransition.get(0).get(step);
                if (value == 0.0) {
                    inactive += 1.0;
                } else if (value == 1.0) {
                    active += 1.0;
                } else if (value == 2.0) {
                    producing += 1.0;
                } else {
                    firing += 1.0;
                }
                if (interval++ != maxInterval) continue;
                inactive /= (double)maxInterval;
                active /= (double)maxInterval;
                producing /= (double)maxInterval;
                firing /= (double)maxInterval;
                if (this.transitionChartType == 0) {
                    series0.add((double)step, inactive);
                    series1.add((double)step, active);
                    series2.add((double)step, producing);
                    series3.add((double)step, firing);
                } else {
                    double time = this.statusVectorTransition.get(1).get(step);
                    series0.add(time, inactive);
                    series1.add(time, active);
                    series2.add(time, producing);
                    series3.add(time, firing);
                }
                firing = 0.0;
                producing = 0.0;
                active = 0.0;
                inactive = 0.0;
                interval = 0;
            }
        }
        this.dynamicsSeriesDataSet.addSeries(series0);
        this.dynamicsSeriesDataSet.addSeries(series1);
        this.dynamicsSeriesDataSet.addSeries(series2);
        this.dynamicsSeriesDataSet.addSeries(series3);
        ArrayList<Double> resultVector = this.statusVectorTransition.get(2);
        this.fillStatsFields(resultVector.get(0), resultVector.get(1), resultVector.get(2), resultVector.get(3), resultVector.get(4), resultVector.get(5), resultVector.get(6), resultVector.get(7), resultVector.get(8));
    }

    private void setFieldStatus(boolean isPlace) {
        if (isPlace) {
            if (this.thePlace.isGammaModeActive()) {
                this.buttonGammaMode.setNewText("<html>Gamma: ON</html>");
                this.buttonGammaMode.repaintBackground("jade_bH1_neutr.png", "amber_bH2_hover.png", "amber_bH3_press.png");
                this.gammaVisibilityButton.setEnabled(true);
                this.gammaMinTextField.setEnabled(true);
                this.gammaMaxTextField.setEnabled(true);
                if (this.thePlace.isGammaRangeVisible()) {
                    this.gammaVisibilityButton.setNewText("<html>\u03b3:visible<html>");
                    this.gammaVisibilityButton.repaintBackground("jade_bH1_neutr.png", "amber_bH2_hover.png", "amber_bH3_press.png");
                } else {
                    this.gammaVisibilityButton.setNewText("<html>\u03b3:hidden<html>");
                    this.gammaVisibilityButton.repaintBackground("amber_bH1_neutr.png", "jade_bH2_hover.png", "jade_bH3_press.png");
                }
            } else {
                this.buttonGammaMode.setNewText("<html>Gamma: OFF</html>");
                this.buttonGammaMode.repaintBackground("paerl_bH1_neutr.png", "paerl_bH2_hover.png", "paerl_bH3_press.png");
                this.gammaVisibilityButton.setEnabled(false);
                this.gammaMinTextField.setEnabled(false);
                this.gammaMaxTextField.setEnabled(false);
            }
            this.doNotUpdate = true;
            this.gammaMinTextField.setValue(this.thePlace.getGammaMinValue());
            this.gammaMaxTextField.setValue(this.thePlace.getGammaMaxValue());
            this.doNotUpdate = false;
        } else {
            if (this.theTransition.isAlphaModeActive()) {
                this.buttonAlphaMode.setNewText("<html>Alpha: ON</html>");
                this.buttonAlphaMode.repaintBackground("jade_bH1_neutr.png", "amber_bH2_hover.png", "amber_bH3_press.png");
                this.buttonClassXTPNmode.setNewText("<html>XTPN<html>");
                this.buttonClassXTPNmode.repaintBackground("jade_bH1_neutr.png", "amber_bH2_hover.png", "amber_bH3_press.png");
                this.alphaMinTextField.setEnabled(true);
                this.alphaMaxTextField.setEnabled(true);
                this.alphaVisibilityButton.setEnabled(true);
                this.tauVisibilityButton.setEnabled(true);
                if (this.theTransition.isAlphaRangeVisible()) {
                    this.alphaVisibilityButton.setNewText("<html>\u03b1: Visible<html>");
                    this.alphaVisibilityButton.repaintBackground("jade_bH1_neutr.png", "amber_bH2_hover.png", "amber_bH3_press.png");
                } else {
                    this.alphaVisibilityButton.setNewText("<html>\u03b1: Hidden<html>");
                    this.alphaVisibilityButton.repaintBackground("amber_bH1_neutr.png", "jade_bH2_hover.png", "jade_bH3_press.png");
                }
                if (this.theTransition.isTauTimerVisible()) {
                    this.tauVisibilityButton.setNewText("<html>\u03c4: Visible<html>");
                    this.tauVisibilityButton.repaintBackground("jade_bH1_neutr.png", "amber_bH2_hover.png", "amber_bH3_press.png");
                } else {
                    this.tauVisibilityButton.setNewText("<html>\u03c4: Hidden<html>");
                    this.tauVisibilityButton.repaintBackground("amber_bH1_neutr.png", "jade_bH2_hover.png", "jade_bH3_press.png");
                }
            } else {
                this.buttonAlphaMode.setNewText("<html>Alpha: OFF</html>");
                this.buttonAlphaMode.repaintBackground("amber_bH1_neutr.png", "jade_bH2_hover.png", "jade_bH3_press.png");
                this.alphaMinTextField.setEnabled(false);
                this.alphaMaxTextField.setEnabled(false);
                this.alphaVisibilityButton.setEnabled(false);
            }
            if (this.theTransition.isBetaModeActive()) {
                this.buttonBetaMode.setNewText("<html>Beta: ON</html>");
                this.buttonBetaMode.repaintBackground("jade_bH1_neutr.png", "amber_bH2_hover.png", "amber_bH3_press.png");
                this.buttonClassXTPNmode.setNewText("<html>XTPN<html>");
                this.buttonClassXTPNmode.repaintBackground("jade_bH1_neutr.png", "amber_bH2_hover.png", "amber_bH3_press.png");
                this.betaMinTextField.setEnabled(true);
                this.betaMaxTextField.setEnabled(true);
                this.betaVisibilityButton.setEnabled(true);
                this.tauVisibilityButton.setEnabled(true);
                if (this.theTransition.isBetaRangeVisible()) {
                    this.betaVisibilityButton.setNewText("<html>\u03b2: Visible<html>");
                    this.betaVisibilityButton.repaintBackground("jade_bH1_neutr.png", "amber_bH2_hover.png", "amber_bH3_press.png");
                } else {
                    this.betaVisibilityButton.setNewText("<html>\u03b2: Hidden<html>");
                    this.betaVisibilityButton.repaintBackground("amber_bH1_neutr.png", "jade_bH2_hover.png", "jade_bH3_press.png");
                }
                if (this.theTransition.isTauTimerVisible()) {
                    this.tauVisibilityButton.setNewText("<html>\u03c4: Visible<html>");
                    this.tauVisibilityButton.repaintBackground("jade_bH1_neutr.png", "amber_bH2_hover.png", "amber_bH3_press.png");
                } else {
                    this.tauVisibilityButton.setNewText("<html>\u03c4: Hidden<html>");
                    this.tauVisibilityButton.repaintBackground("amber_bH1_neutr.png", "jade_bH2_hover.png", "jade_bH3_press.png");
                }
            } else {
                this.buttonBetaMode.setNewText("<html>Beta: OFF</html>");
                this.buttonBetaMode.repaintBackground("amber_bH1_neutr.png", "jade_bH2_hover.png", "jade_bH3_press.png");
                this.betaMinTextField.setEnabled(false);
                this.betaMaxTextField.setEnabled(false);
                this.betaVisibilityButton.setEnabled(false);
            }
            if (!this.theTransition.isAlphaModeActive() && !this.theTransition.isBetaModeActive()) {
                this.buttonClassXTPNmode.setNewText("<html>Classical<html>");
                this.buttonClassXTPNmode.repaintBackground("amber_bH1_neutr.png", "jade_bH2_hover.png", "jade_bH3_press.png");
                this.tauVisibilityButton.setEnabled(false);
            }
            this.doNotUpdate = true;
            this.alphaMinTextField.setValue(this.theTransition.getAlphaMinValue());
            this.alphaMaxTextField.setValue(this.theTransition.getAlphaMaxValue());
            this.betaMinTextField.setValue(this.theTransition.getBetaMinValue());
            this.betaMaxTextField.setValue(this.theTransition.getBetaMaxValue());
            this.doNotUpdate = false;
        }
    }

    private void fillStatsFields(double realSimulationSteps, double realSimulationTime, double inactiveSteps, double activeSteps, double producingSteps, double fireSteps, double inactiveTime, double activeTime, double producingTime) {
        this.transStatsStepLabel.setText("Steps: " + Tools.cutValue(realSimulationSteps));
        this.transStatsTimeLabel.setText("Time: " + Tools.cutValue(realSimulationTime));
        double tmp = inactiveSteps / realSimulationSteps * 100.0;
        this.transStatsInactiveStepsTextBox.setText((int)inactiveSteps + " (" + Tools.cutValue(tmp) + "%)");
        tmp = activeSteps / realSimulationSteps * 100.0;
        this.transStatsActiveStepsTextBox.setText((int)activeSteps + " (" + Tools.cutValue(tmp) + "%)");
        tmp = producingSteps / realSimulationSteps * 100.0;
        this.transStatsProductionStepsTextBox.setText((int)producingSteps + " (" + Tools.cutValue(tmp) + "%)");
        tmp = fireSteps / realSimulationSteps * 100.0;
        this.transStatsFiringStepsTextBox.setText((int)fireSteps + "  (" + Tools.cutValue(tmp) + "%)");
        tmp = inactiveTime / realSimulationTime * 100.0;
        this.transStatsInactiveTimeTextBox.setText(Tools.cutValue(inactiveTime) + " (" + Tools.cutValue(tmp) + "%)");
        tmp = activeTime / realSimulationTime * 100.0;
        this.transStatsActiveTimeTextBox.setText(Tools.cutValue(activeTime) + " (" + Tools.cutValue(tmp) + "%)");
        tmp = producingTime / realSimulationTime * 100.0;
        this.transStatsProductionTimeTextBox.setText(Tools.cutValue(producingTime) + " (" + Tools.cutValue(tmp) + "%)");
    }
}

