/*
 * Decompiled with CFR 0.152.
 */
package holmes.windows.ssim;

import holmes.darkgui.GUIManager;
import holmes.petrinet.simulators.SimulatorGlobals;
import holmes.utilities.Tools;
import holmes.windows.managers.HolmesSPNmanager;
import holmes.windows.managers.HolmesSSAwindowManager;
import holmes.windows.managers.HolmesStatesManager;
import holmes.windows.ssim.HolmesSim;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class HolmesSimSetup
extends JFrame {
    private static final long serialVersionUID = -240275069200534886L;
    private GUIManager overlord;
    private JFrame parentWindow;
    private JFrame ego;
    private boolean doNotUpdate = false;
    private SimulatorGlobals settings;
    private ButtonGroup groupNetType = new ButtonGroup();
    private JRadioButton classPNRadioButton;
    private JRadioButton timeNetRadioButtion;
    private JRadioButton hybridNetRadioButton;
    private ButtonGroup groupSimMode = new ButtonGroup();
    private JRadioButton fiftyModeRadioButton;
    private JRadioButton maxModeRadioButton;
    private JRadioButton singleModeRadioButton;
    private ButtonGroup immSPNmode = new ButtonGroup();
    private JRadioButton immOnly1RadioButton;
    private JRadioButton immSchedRadioButton;
    private JRadioButton immProbRadioButton;
    private JCheckBox allowEmptySteps;
    private JCheckBox useMassActionKinetics;
    private JCheckBox detRemoveMode;
    private JComboBox<String> generatorType;
    private JComboBox<String> simulatorType;

    public HolmesSimSetup(JFrame parent) {
        this.overlord = GUIManager.getDefaultGUIManager();
        this.ego = this;
        this.parentWindow = parent;
        this.settings = this.overlord.simSettings;
        this.parentWindow.setEnabled(false);
        this.initializeComponents();
        this.initiateListeners();
    }

    private void initializeComponents() {
        this.setTitle("Simulator settings");
        this.setLocation(this.parentWindow.getX() + 150, this.parentWindow.getY() + 150);
        try {
            this.setIconImage(Tools.getImageFromIcon("/icons/holmesicon.png"));
        }
        catch (Exception ex) {
            GUIManager.getDefaultGUIManager().log("Error (766220006) | Exception:  " + ex.getMessage(), "error", true);
        }
        this.setSize(new Dimension(620, 490));
        JPanel main = new JPanel(null);
        this.add(main);
        main.add(this.createGlobalOptionsPanel(0, 0, 600, 110));
        main.add(this.createStdSimulatorSettingsPanel(0, 110, 600, 110));
        main.add(this.createStochasticSimSettingsPanel(0, 220, 600, 160));
        main.add(this.createGillespieSSASimSettingsPanel(0, 380, 600, 70));
        this.setVisible(true);
    }

    private JPanel createGlobalOptionsPanel(int x, int y, int width, int height) {
        JPanel panel = new JPanel(null);
        panel.setBounds(x, y, width, height);
        panel.setBorder(BorderFactory.createTitledBorder("Global settings"));
        int posX = 10;
        int posY = 15;
        JLabel simStepsLabel = new JLabel("Steps:");
        simStepsLabel.setBounds(posX, posY, 80, 20);
        panel.add(simStepsLabel);
        SpinnerNumberModel simStepsSpinnerModel = new SpinnerNumberModel(this.settings.getSimSteps(), 100, 10000000, 100);
        JSpinner simStepsSpinner = new JSpinner(simStepsSpinnerModel);
        simStepsSpinner.setBounds(posX, posY + 20, 80, 20);
        simStepsSpinner.addChangeListener(e -> {
            if (this.doNotUpdate) {
                return;
            }
            JSpinner spinner = (JSpinner)e.getSource();
            int value = (Integer)spinner.getValue();
            this.settings.setSimSteps(value);
            if (this.parentWindow instanceof HolmesSim) {
                ((HolmesSim)this.parentWindow).updateIntervalSpinner();
            }
        });
        panel.add(simStepsSpinner);
        JLabel repetLabel = new JLabel("Repetitions:");
        repetLabel.setBounds(posX + 85, posY, 80, 20);
        panel.add(repetLabel);
        SpinnerNumberModel simRepetsSpinnerModel = new SpinnerNumberModel(this.settings.getRepetitions(), 1, 100000, 10);
        JSpinner simRepsSpinner = new JSpinner(simRepetsSpinnerModel);
        simRepsSpinner.setBounds(posX + 85, posY + 20, 80, 20);
        simRepsSpinner.addChangeListener(e -> {
            if (this.doNotUpdate) {
                return;
            }
            JSpinner spinner = (JSpinner)e.getSource();
            int value = (Integer)spinner.getValue();
            this.settings.setRepetitions(value);
        });
        panel.add(simRepsSpinner);
        JLabel generatorLabel = new JLabel("Random number generator:");
        generatorLabel.setBounds(posX + 170, posY, 180, 20);
        panel.add(generatorLabel);
        String[] simulator = new String[]{"Random (Java default)", "HighQualityRandom (slower)"};
        this.generatorType = new JComboBox<String>(simulator);
        this.generatorType.setBounds(posX + 170, posY + 20, 200, 20);
        this.generatorType.setSelectedIndex(0);
        this.generatorType.addActionListener(actionEvent -> {
            if (this.doNotUpdate) {
                return;
            }
            int selected = this.generatorType.getSelectedIndex();
            if (selected == 1) {
                this.overlord.simSettings.setGeneratorType(1);
            } else {
                this.overlord.simSettings.setGeneratorType(0);
            }
            this.doNotUpdate = false;
        });
        panel.add(this.generatorType);
        JButton stateManagerButton = new JButton();
        stateManagerButton.setText("<html>States<br>Manager</html>");
        stateManagerButton.setIcon(Tools.getResIcon32("/icons/stateManager/stManIcon.png"));
        stateManagerButton.setBounds(posX + 380, posY, 130, 40);
        stateManagerButton.setMargin(new Insets(0, 0, 0, 0));
        stateManagerButton.setFocusPainted(false);
        stateManagerButton.addActionListener(actionEvent -> new HolmesStatesManager());
        panel.add(stateManagerButton);
        JLabel simulatorLabel = new JLabel("Simulator selection:");
        simulatorLabel.setBounds(posX, posY + 40, 180, 20);
        panel.add(simulatorLabel);
        String[] simulatorName = new String[]{"Standard token simulator", "Stochastics simulation for SPN", "Gillespie SSA (exact version)", "Gillespie SSA (fast version)"};
        this.simulatorType = new JComboBox<String>(simulatorName);
        this.simulatorType.setBounds(posX, posY + 60, 250, 20);
        this.simulatorType.setSelectedIndex(0);
        this.simulatorType.addActionListener(actionEvent -> {
            if (this.doNotUpdate) {
                return;
            }
            int selected = this.simulatorType.getSelectedIndex();
            if (selected == 0) {
                this.overlord.simSettings.setSimulatorType(0);
            } else if (selected == 1) {
                this.overlord.simSettings.setSimulatorType(1);
            } else {
                JOptionPane.showMessageDialog(this.ego, "This feature is not yet implemented.", "Simulator unavailable", 1);
            }
            this.doNotUpdate = false;
        });
        panel.add(this.simulatorType);
        return panel;
    }

    private JPanel createStdSimulatorSettingsPanel(int x, int y, int width, int height) {
        JPanel panel = new JPanel(null);
        panel.setBounds(x, y, width, height);
        panel.setBorder(BorderFactory.createTitledBorder("Standard simulator settings"));
        int posX = 10;
        int posY = 15;
        JPanel netTypeModePanel = new JPanel(null);
        netTypeModePanel.setBounds(posX, posY, 150, 90);
        netTypeModePanel.setBorder(BorderFactory.createTitledBorder("Net type mode:"));
        panel.add(netTypeModePanel);
        this.classPNRadioButton = new JRadioButton("Classical Petri Net");
        this.classPNRadioButton.setBounds(5, 20, 130, 20);
        this.classPNRadioButton.setActionCommand("0");
        this.classPNRadioButton.addActionListener(actionEvent -> {
            AbstractButton aButton = (AbstractButton)actionEvent.getSource();
            if (aButton.isSelected()) {
                if (this.doNotUpdate) {
                    return;
                }
                this.settings.setNetType(0);
            }
        });
        netTypeModePanel.add(this.classPNRadioButton);
        this.groupNetType.add(this.classPNRadioButton);
        this.timeNetRadioButtion = new JRadioButton("Time(d) Petri Net");
        this.timeNetRadioButtion.setBounds(5, 40, 130, 20);
        this.timeNetRadioButtion.setActionCommand("1");
        this.timeNetRadioButtion.addActionListener(actionEvent -> {
            AbstractButton aButton = (AbstractButton)actionEvent.getSource();
            if (aButton.isSelected()) {
                if (this.doNotUpdate) {
                    return;
                }
                int res = this.settings.setNetType(1);
                if (res == 0) {
                    this.groupNetType.setSelected(this.classPNRadioButton.getModel(), true);
                } else if (res == 2) {
                    this.groupNetType.setSelected(this.hybridNetRadioButton.getModel(), true);
                }
                this.doNotUpdate = false;
            }
        });
        netTypeModePanel.add(this.timeNetRadioButtion);
        this.groupNetType.add(this.timeNetRadioButtion);
        this.hybridNetRadioButton = new JRadioButton("Hybrid Net");
        this.hybridNetRadioButton.setBounds(5, 60, 130, 20);
        this.hybridNetRadioButton.setActionCommand("2");
        this.hybridNetRadioButton.addActionListener(actionEvent -> {
            AbstractButton aButton = (AbstractButton)actionEvent.getSource();
            if (aButton.isSelected()) {
                if (this.doNotUpdate) {
                    return;
                }
                this.settings.setNetType(2);
            }
        });
        netTypeModePanel.add(this.hybridNetRadioButton);
        this.groupNetType.add(this.hybridNetRadioButton);
        JPanel subModeModePanel = new JPanel(null);
        subModeModePanel.setBounds(posX + 150, posY, 170, 90);
        subModeModePanel.setBorder(BorderFactory.createTitledBorder("Simulator sub-mode:"));
        panel.add(subModeModePanel);
        this.fiftyModeRadioButton = new JRadioButton("50/50 mode (async.)");
        this.fiftyModeRadioButton.setBounds(5, 20, 140, 20);
        this.fiftyModeRadioButton.setActionCommand("0");
        this.fiftyModeRadioButton.addActionListener(actionEvent -> {
            if (this.doNotUpdate) {
                return;
            }
            AbstractButton aButton = (AbstractButton)actionEvent.getSource();
            if (aButton.isSelected()) {
                this.settings.setSingleMode(false);
                this.settings.setMaxMode(false);
            }
        });
        subModeModePanel.add(this.fiftyModeRadioButton);
        this.groupSimMode.add(this.fiftyModeRadioButton);
        this.maxModeRadioButton = new JRadioButton("Maximum mode (sync.)");
        this.maxModeRadioButton.setBounds(5, 40, 160, 20);
        this.maxModeRadioButton.setActionCommand("1");
        this.maxModeRadioButton.addActionListener(actionEvent -> {
            if (this.doNotUpdate) {
                return;
            }
            AbstractButton aButton = (AbstractButton)actionEvent.getSource();
            if (aButton.isSelected()) {
                this.settings.setSingleMode(false);
                this.settings.setMaxMode(true);
            }
        });
        subModeModePanel.add(this.maxModeRadioButton);
        this.groupSimMode.add(this.maxModeRadioButton);
        this.singleModeRadioButton = new JRadioButton("Single fire mode");
        this.singleModeRadioButton.setBounds(5, 60, 140, 20);
        this.singleModeRadioButton.setActionCommand("2");
        this.singleModeRadioButton.addActionListener(actionEvent -> {
            if (this.doNotUpdate) {
                return;
            }
            AbstractButton aButton = (AbstractButton)actionEvent.getSource();
            if (aButton.isSelected()) {
                this.settings.setSingleMode(true);
            }
        });
        subModeModePanel.add(this.singleModeRadioButton);
        this.groupSimMode.add(this.singleModeRadioButton);
        this.allowEmptySteps = new JCheckBox("Allow empty steps");
        this.allowEmptySteps.setBounds(posX + 325, posY, 150, 20);
        this.allowEmptySteps.addActionListener(actionEvent -> {
            if (this.doNotUpdate) {
                return;
            }
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            this.settings.setEmptySteps(abstractButton.getModel().isSelected());
        });
        panel.add(this.allowEmptySteps);
        return panel;
    }

    private JPanel createStochasticSimSettingsPanel(int x, int y, int width, int height) {
        JPanel panel = new JPanel(null);
        panel.setBounds(x, y, width, height);
        panel.setBorder(BorderFactory.createTitledBorder("Stochastic simulation settings for SPN"));
        int posX = 10;
        int posY = 20;
        JButton createFRWindowButton = new JButton("<html>Fire rate<br>Manager</html>");
        createFRWindowButton.setIcon(Tools.getResIcon16("/icons/fRatesManager/fireRateIcon.png"));
        createFRWindowButton.setBounds(posX, posY, 120, 40);
        createFRWindowButton.setFocusPainted(false);
        createFRWindowButton.setToolTipText("Loop single transition simulation");
        createFRWindowButton.addActionListener(actionEvent -> new HolmesSPNmanager(this.ego));
        panel.add(createFRWindowButton);
        this.useMassActionKinetics = new JCheckBox("Mass action kinetics enabled");
        this.useMassActionKinetics.setBounds(posX + 130, posY, 200, 20);
        this.useMassActionKinetics.addActionListener(actionEvent -> {
            if (this.doNotUpdate) {
                return;
            }
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            this.settings.setSSAmassAction(abstractButton.getModel().isSelected());
        });
        panel.add(this.useMassActionKinetics);
        this.detRemoveMode = new JCheckBox("Remove deactivated deterministic SPN transitions");
        this.detRemoveMode.setToolTipText("When this mode is selected, deterministic SPN transition which after its delay time\nis no longer active, will be remove from the firing sequence. Otherwise, it will fire\nas soon as it become activated again = will act as immediate in that moment.");
        this.detRemoveMode.setBounds(posX + 130, posY + 20, 350, 20);
        this.detRemoveMode.addActionListener(actionEvent -> {
            if (this.doNotUpdate) {
                return;
            }
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            this.settings.setSPNdetRemoveMode(abstractButton.getModel().isSelected());
        });
        panel.add(this.detRemoveMode);
        JPanel immSPNModePanel = new JPanel(null);
        immSPNModePanel.setBounds(posX, posY + 45, 240, 90);
        immSPNModePanel.setBorder(BorderFactory.createTitledBorder("Immediate-transition SPN mode:"));
        panel.add(immSPNModePanel);
        this.immOnly1RadioButton = new JRadioButton("Only 1 with the highest priority fire");
        this.immOnly1RadioButton.setBounds(5, 20, 220, 20);
        this.immOnly1RadioButton.setToolTipText("Only 1 transition with the highest priority will fire, then all will be evaluated from the beginning.");
        this.immOnly1RadioButton.setActionCommand("0");
        this.immOnly1RadioButton.addActionListener(actionEvent -> {
            AbstractButton aButton = (AbstractButton)actionEvent.getSource();
            if (aButton.isSelected()) {
                if (this.doNotUpdate) {
                    return;
                }
                this.settings.setSPNimmediateMode(0);
            }
        });
        immSPNModePanel.add(this.immOnly1RadioButton);
        this.immSPNmode.add(this.immOnly1RadioButton);
        this.immSchedRadioButton = new JRadioButton("Sequenced firing by priority");
        this.immSchedRadioButton.setBounds(5, 40, 220, 20);
        this.immOnly1RadioButton.setToolTipText("Sequenced firing of active immediate transition by priority.");
        this.immSchedRadioButton.setActionCommand("1");
        this.immSchedRadioButton.addActionListener(actionEvent -> {
            AbstractButton aButton = (AbstractButton)actionEvent.getSource();
            if (aButton.isSelected()) {
                if (this.doNotUpdate) {
                    return;
                }
                this.settings.setSPNimmediateMode(1);
            }
        });
        immSPNModePanel.add(this.immSchedRadioButton);
        this.immSPNmode.add(this.immSchedRadioButton);
        this.immProbRadioButton = new JRadioButton("Priority - probability mode");
        this.immProbRadioButton.setBounds(5, 60, 220, 20);
        this.immProbRadioButton.setToolTipText("1 from active IM transition will fire, probability depends on priority set for transition.");
        this.immProbRadioButton.setActionCommand("2");
        this.immProbRadioButton.addActionListener(actionEvent -> {
            AbstractButton aButton = (AbstractButton)actionEvent.getSource();
            if (aButton.isSelected()) {
                if (this.doNotUpdate) {
                    return;
                }
                this.settings.setSPNimmediateMode(2);
            }
        });
        immSPNModePanel.add(this.immProbRadioButton);
        this.immSPNmode.add(this.immProbRadioButton);
        return panel;
    }

    private JPanel createGillespieSSASimSettingsPanel(int x, int y, int width, int height) {
        JPanel panel = new JPanel(null);
        panel.setBounds(x, y, width, height);
        panel.setBorder(BorderFactory.createTitledBorder("Gillespie SSA (Stochastic Simulation Algorithm) settings"));
        int posX = 10;
        int posY = 20;
        JButton createFRWindowButton = new JButton("<html>Fire rate<br>Manager</html>");
        createFRWindowButton.setIcon(Tools.getResIcon16("/icons/fRatesManager/fireRateIcon.png"));
        createFRWindowButton.setBounds(posX, posY, 120, 40);
        createFRWindowButton.setFocusPainted(false);
        createFRWindowButton.setToolTipText("Set transition firing rates for SSA.");
        createFRWindowButton.addActionListener(actionEvent -> new HolmesSPNmanager(this.ego));
        panel.add(createFRWindowButton);
        JButton createCompoundsEditorWindowButton = new JButton("<html>Components<br>&nbsp;&nbsp;Manager&nbsp;</html>");
        createCompoundsEditorWindowButton.setIcon(Tools.getResIcon16("/icons/componentsManager/compIcon.png"));
        createCompoundsEditorWindowButton.setMargin(new Insets(0, 0, 0, 0));
        createCompoundsEditorWindowButton.setFocusPainted(false);
        createCompoundsEditorWindowButton.setBounds(posX + 130, posY, 120, 40);
        createCompoundsEditorWindowButton.setToolTipText("Component vectors managaer for SSA.");
        createCompoundsEditorWindowButton.addActionListener(actionEvent -> new HolmesSSAwindowManager(this.ego));
        panel.add(createCompoundsEditorWindowButton);
        return panel;
    }

    private void configureWindow() {
        this.doNotUpdate = true;
        SimulatorGlobals.SimNetType netType = this.settings.getNetType();
        if (netType == SimulatorGlobals.SimNetType.BASIC) {
            this.groupNetType.setSelected(this.classPNRadioButton.getModel(), true);
        } else if (netType == SimulatorGlobals.SimNetType.TIME) {
            this.groupNetType.setSelected(this.timeNetRadioButtion.getModel(), true);
        } else if (netType == SimulatorGlobals.SimNetType.HYBRID) {
            this.groupNetType.setSelected(this.hybridNetRadioButton.getModel(), true);
        }
        if (this.settings.isSingleMode()) {
            this.groupSimMode.setSelected(this.singleModeRadioButton.getModel(), true);
        } else if (this.settings.isMaxMode()) {
            this.groupSimMode.setSelected(this.maxModeRadioButton.getModel(), true);
        } else {
            this.groupSimMode.setSelected(this.fiftyModeRadioButton.getModel(), true);
        }
        this.allowEmptySteps.setSelected(this.settings.isEmptySteps());
        this.useMassActionKinetics.setSelected(this.settings.isSSAMassAction());
        this.detRemoveMode.setSelected(this.settings.isSPNdetRemoveMode());
        if (this.settings.getGeneratorType() == 0) {
            this.generatorType.setSelectedIndex(0);
        } else {
            this.generatorType.setSelectedIndex(1);
        }
        if (this.settings.getSimulatorType() == 0) {
            this.simulatorType.setSelectedIndex(0);
        } else {
            this.simulatorType.setSelectedIndex(1);
        }
        int imSPNmode = this.settings.getSPNimmediateMode();
        if (imSPNmode == 0) {
            this.immSPNmode.setSelected(this.immOnly1RadioButton.getModel(), true);
        } else if (imSPNmode == 1) {
            this.immSPNmode.setSelected(this.immSchedRadioButton.getModel(), true);
        } else if (imSPNmode == 2) {
            this.immSPNmode.setSelected(this.immProbRadioButton.getModel(), true);
        }
        this.doNotUpdate = false;
    }

    private void initiateListeners() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                HolmesSimSetup.this.configureWindow();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                HolmesSimSetup.this.setDefaultCloseOperation(2);
                HolmesSimSetup.this.parentWindow.setEnabled(true);
            }
        });
    }
}

