/*
 * Decompiled with CFR 0.152.
 */
package holmes.windows.ssim;

import holmes.darkgui.GUIManager;
import holmes.petrinet.data.NetSimulationData;
import holmes.petrinet.data.PetriNet;
import holmes.petrinet.elements.Place;
import holmes.petrinet.elements.Transition;
import holmes.tables.simKnock.SimKnockPlacesCompAllTableModel;
import holmes.tables.simKnock.SimKnockPlacesCompTableModel;
import holmes.tables.simKnock.SimKnockPlacesTableModel;
import holmes.tables.simKnock.SimKnockTableRenderer;
import holmes.tables.simKnock.SimKnockTransCompAllTableModel;
import holmes.tables.simKnock.SimKnockTransCompTableModel;
import holmes.tables.simKnock.SimKnockTransTableModel;
import holmes.utilities.Tools;
import holmes.windows.HolmesNodeInfo;
import holmes.windows.HolmesNotepad;
import holmes.windows.ssim.HolmesSim;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.invoke.CallSite;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.TreeMap;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.StatisticalBarRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.statistics.DefaultStatisticalCategoryDataset;
import org.jfree.data.statistics.StatisticalCategoryDataset;
import org.jfree.data.xy.XYSeriesCollection;

public class HolmesSimKnockVis
extends JFrame {
    private static final long serialVersionUID = 3020186160500907678L;
    private GUIManager overlord = GUIManager.getDefaultGUIManager();
    private PetriNet pn = this.overlord.getWorkspace().getProject();
    private static final DecimalFormat formatter1 = new DecimalFormat("#.#");
    private static final DecimalFormat formatter2 = new DecimalFormat("#.##");
    private static final DecimalFormat formatter3 = new DecimalFormat("#.###");
    private boolean doNotUpdate = false;
    private HolmesSim boss;
    private JFreeChart placesChart;
    private JFreeChart transitionsChart;
    private JPanel placesChartPanel;
    private JPanel transitionsChartPanel;
    private JComboBox<String> referencesCombo = null;
    private JComboBox<String> dataCombo = null;
    private JComboBox<String> seriesCombo = null;
    private ArrayList<Place> places;
    private ArrayList<Transition> transitions;
    private DefaultTableModel model;
    private SimKnockTableRenderer tableRenderer;
    private JTable placesTable;
    private JTable transTable;
    private JTable placesCompAllTable;
    private JTable transCompAllTable;
    protected boolean notepadInfo = false;

    public HolmesSimKnockVis(HolmesSim boss) {
        this.boss = boss;
        this.places = this.pn.getPlaces();
        this.transitions = this.pn.getTransitions();
        this.initializeComponents();
        this.initiateListeners();
    }

    private void initializeComponents() {
        this.setVisible(true);
        this.setTitle("Knockout data visualisation");
        this.setLocation(this.boss.getLocation().x, this.boss.getLocation().y);
        try {
            this.setIconImage(Tools.getImageFromIcon("/icons/holmesicon.png"));
        }
        catch (Exception ex) {
            GUIManager.getDefaultGUIManager().log("Error (210930262) | Exception:  " + ex.getMessage(), "error", true);
        }
        this.setSize(new Dimension(1200, 920));
        JPanel main = new JPanel(new BorderLayout());
        this.add(main);
        main.add((Component)this.getActionsPanel(), "North");
        JPanel mainTabbedPanel = new JPanel(new BorderLayout());
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab("Charts", Tools.getResIcon32("/icons/simulationKnockout/visChartsIcon.png"), this.createPlacesChartsPanel(), "<html>Show charts comparing difference in places na transitions<br>behaviour between reference and data sets</html>");
        tabbedPane.setMnemonicAt(0, 49);
        tabbedPane.addTab("Places", Tools.getResIcon16("/icons/simulationKnockout/visPlaces.png"), this.createPlacesTablePanel(), "<html>Show places behaviour for selected dataset OR<br>comparison between reference and data sets</html>");
        tabbedPane.setMnemonicAt(1, 50);
        tabbedPane.addTab("Transitions", Tools.getResIcon16("/icons/simulationKnockout/visTrans.png"), this.createTransTablePanel(), "<html>Show transitions behaviour for selected dataset OR<br>comparison between reference and data sets</html>");
        tabbedPane.setMnemonicAt(2, 51);
        tabbedPane.addTab("Places (series)", Tools.getResIcon16("/icons/simulationKnockout/visPlacesSeries.png"), this.createPlacesCompAllTablePanel(), "<html>Show places table for knockout series.</html>");
        tabbedPane.setMnemonicAt(3, 52);
        tabbedPane.addTab("Transitions (series)", Tools.getResIcon16("/icons/simulationKnockout/visTransSeries.png"), this.createTransCompAllTablePanel(), "<html>Show transitions table for knockout series.</html>");
        tabbedPane.setMnemonicAt(4, 53);
        mainTabbedPanel.add(tabbedPane);
        main.add((Component)mainTabbedPanel, "Center");
        GUIManager.getDefaultGUIManager().getFrame().setEnabled(false);
    }

    private JPanel getActionsPanel() {
        JPanel result = new JPanel(null);
        result.setBorder(BorderFactory.createTitledBorder("Main options panel"));
        result.setPreferredSize(new Dimension(670, 120));
        int posXda = 10;
        int posYda = 20;
        JLabel label1 = new JLabel("Ref sets:");
        label1.setBounds(posXda, posYda, 70, 20);
        result.add(label1);
        String[] data = new String[]{" ----- "};
        this.referencesCombo = new JComboBox<String>(data);
        this.referencesCombo.setToolTipText("Select reference data (presumably dataset without any transition knockout)");
        this.referencesCombo.setBounds(posXda + 80, posYda, 500, 20);
        this.referencesCombo.setMaximumRowCount(12);
        this.referencesCombo.addActionListener(actionEvent -> {});
        result.add(this.referencesCombo);
        JLabel label3 = new JLabel("Sim. series:");
        label3.setBounds(posXda + 600, posYda, 80, 20);
        result.add(label3);
        String[] dataSeries = new String[]{" ----- "};
        this.seriesCombo = new JComboBox<String>(dataSeries);
        this.seriesCombo.setToolTipText("Select dataset series (presumably with every transition disable one per dataset)");
        this.seriesCombo.setBounds(posXda + 680, posYda, 250, 20);
        this.seriesCombo.setMaximumRowCount(12);
        this.seriesCombo.addActionListener(actionEvent -> {});
        result.add(this.seriesCombo);
        JLabel label2 = new JLabel("Data sets:");
        label2.setBounds(posXda, posYda += 25, 70, 20);
        result.add(label2);
        String[] data2 = new String[]{" ----- "};
        this.dataCombo = new JComboBox<String>(data2);
        this.dataCombo.setToolTipText("Select dataset (presumably with some transition(s) knocked out)");
        this.dataCombo.setBounds(posXda + 80, posYda, 850, 20);
        this.dataCombo.setMaximumRowCount(12);
        this.dataCombo.addActionListener(actionEvent -> {});
        result.add(this.dataCombo);
        JButton showRefDataButton = new JButton("<html>Show reference<br/>&nbsp; &nbsp; &nbsp; &nbsp; dataset</html>");
        showRefDataButton.setBounds(posXda, posYda += 25, 175, 36);
        showRefDataButton.setMargin(new Insets(0, 0, 0, 0));
        showRefDataButton.setIcon(Tools.getResIcon32("/icons/simulationKnockout/visShowRefButton.png"));
        showRefDataButton.addActionListener(actionEvent -> {
            int selRef = this.referencesCombo.getSelectedIndex();
            if (selRef > 0) {
                this.showSingleKnockoutCharts(true);
                this.createPlacesTable(true);
                this.createTransTable(true);
            }
        });
        result.add(showRefDataButton);
        JButton showKnockDataButton = new JButton("<html>Show knockout<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;dataset</html>");
        showKnockDataButton.setBounds(posXda + 180, posYda, 175, 36);
        showKnockDataButton.setMargin(new Insets(0, 0, 0, 0));
        showKnockDataButton.setIcon(Tools.getResIcon16("/icons/simulationKnockout/visShowDataSetButton.png"));
        showKnockDataButton.addActionListener(actionEvent -> {
            int selected = this.dataCombo.getSelectedIndex();
            if (selected > 0) {
                this.showSingleKnockoutCharts(false);
                this.createPlacesTable(false);
                this.createTransTable(false);
            }
        });
        result.add(showKnockDataButton);
        JButton showChartKnockButton = new JButton("<html>Compare reference<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;and knockout</html>");
        showChartKnockButton.setBounds(posXda + 360, posYda, 175, 36);
        showChartKnockButton.setMargin(new Insets(0, 0, 0, 0));
        showChartKnockButton.setIcon(Tools.getResIcon16("/icons/simulationKnockout/visCompRefDataButton.png"));
        showChartKnockButton.addActionListener(actionEvent -> {
            int selRef = this.referencesCombo.getSelectedIndex();
            int dataRef = this.dataCombo.getSelectedIndex();
            if (selRef < 1 || dataRef < 1) {
                JOptionPane.showMessageDialog(null, "Please select reference and knockout set!", "Selection needed", 2);
            } else {
                this.showCompareCharts();
                this.createPlacesCompTable();
                this.createTransCompTable();
            }
        });
        result.add(showChartKnockButton);
        JButton showSeriesButton = new JButton("<html>&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;Full series&nbsp;<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;datatables</html>");
        showSeriesButton.setBounds(posXda + 600, posYda, 175, 36);
        showSeriesButton.setMargin(new Insets(0, 0, 0, 0));
        showSeriesButton.setIcon(Tools.getResIcon16("/icons/simulationKnockout/visRefDataSeriesButton.png"));
        showSeriesButton.addActionListener(actionEvent -> {
            int selected = this.seriesCombo.getSelectedIndex() - 1;
            if (selected > -1) {
                this.createCompareAllTables(selected);
            }
        });
        result.add(showSeriesButton);
        JButton showNotepadButton = new JButton("<html>&nbsp; &nbsp;Show notepad<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;summary</html>");
        showNotepadButton.setBounds(posXda + 780, posYda, 175, 36);
        showNotepadButton.setMargin(new Insets(0, 0, 0, 0));
        showNotepadButton.setIcon(Tools.getResIcon16("/icons/simulationKnockout/visRefDataSeriesNotepadButton.png"));
        showNotepadButton.addActionListener(actionEvent -> {
            int selected = this.seriesCombo.getSelectedIndex() - 1;
            if (selected > -1) {
                this.createCompareAllTablesNotepad(selected);
            }
        });
        result.add(showNotepadButton);
        JCheckBox sortedCheckBox = new JCheckBox("Notepad");
        sortedCheckBox.setBounds(posXda + 960, posYda, 80, 20);
        sortedCheckBox.setSelected(false);
        sortedCheckBox.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            this.notepadInfo = abstractButton.getModel().isSelected();
        });
        result.add(sortedCheckBox);
        return result;
    }

    private JPanel createPlacesChartsPanel() {
        JPanel result = new JPanel(new BorderLayout());
        result.setBorder(BorderFactory.createTitledBorder("Charts"));
        result.setPreferredSize(new Dimension(670, 500));
        String chartTitle = "Places dynamics";
        String xAxisLabel = "Step";
        String yAxisLabel = "Tokens";
        boolean showLegend = true;
        boolean createTooltip = true;
        boolean createURL = false;
        XYSeriesCollection placesSeriesDataSet = new XYSeriesCollection();
        this.placesChart = ChartFactory.createXYLineChart(chartTitle, xAxisLabel, yAxisLabel, placesSeriesDataSet, PlotOrientation.VERTICAL, showLegend, createTooltip, createURL);
        this.placesChartPanel = new JPanel(new BorderLayout());
        this.placesChartPanel.setBorder(BorderFactory.createTitledBorder("Places chart"));
        this.placesChartPanel.add((Component)new ChartPanel(this.placesChart), "Center");
        JPanel result2 = new JPanel(new BorderLayout());
        result2.setBorder(BorderFactory.createTitledBorder("Charts"));
        result2.setPreferredSize(new Dimension(670, 500));
        String chartTitle2 = "Transitions dynamics";
        String xAxisLabel2 = "Transition";
        String yAxisLabel2 = "Firing";
        boolean showLegend2 = true;
        boolean createTooltip2 = true;
        boolean createURL2 = false;
        XYSeriesCollection transitionsSeriesDataSet = new XYSeriesCollection();
        this.transitionsChart = ChartFactory.createXYLineChart(chartTitle2, xAxisLabel2, yAxisLabel2, transitionsSeriesDataSet, PlotOrientation.VERTICAL, showLegend2, createTooltip2, createURL2);
        this.transitionsChartPanel = new JPanel(new BorderLayout());
        this.transitionsChartPanel.setBorder(BorderFactory.createTitledBorder("Transitions chart"));
        this.transitionsChartPanel.add((Component)new ChartPanel(this.transitionsChart), "Center");
        JSplitPane pane = new JSplitPane(0, this.placesChartPanel, this.transitionsChartPanel);
        pane.setDividerLocation(350);
        result.add(pane);
        return result;
    }

    protected void showSingleKnockoutCharts(boolean showRef) {
        NetSimulationData data = this.getCorrectSet(showRef);
        if (data == null) {
            return;
        }
        StatisticalCategoryDataset datasetPlaces = this.createPlacesDataset(data, null);
        CategoryAxis xAxisPlaces = new CategoryAxis("Type");
        xAxisPlaces.setLowerMargin(0.01);
        xAxisPlaces.setUpperMargin(0.01);
        xAxisPlaces.setCategoryMargin(0.05);
        NumberAxis yAxisPlaces = new NumberAxis("Value");
        StatisticalBarRenderer rendererPlaces = new StatisticalBarRenderer();
        CategoryPlot plotPlaces = new CategoryPlot(datasetPlaces, xAxisPlaces, yAxisPlaces, rendererPlaces);
        rendererPlaces.setToolTipGenerator(new CustomToolTipGenerator(true, false, this.places, this.transitions, data, null));
        this.placesChartPanel.removeAll();
        this.placesChart = new JFreeChart("Places statistical data", new Font("Helvetica", 1, 14), plotPlaces, true);
        ChartPanel chartPanelPlaces = new ChartPanel(this.placesChart);
        chartPanelPlaces.setPreferredSize(new Dimension(data.placesNumber * 40, 270));
        chartPanelPlaces.setMaximumDrawWidth(data.placesNumber * 40);
        JScrollPane sPanePlaces = new JScrollPane(chartPanelPlaces);
        this.placesChartPanel.add((Component)sPanePlaces, "Center");
        this.placesChartPanel.revalidate();
        this.placesChartPanel.repaint();
        StatisticalCategoryDataset datasetTrans = this.createTransitionsDataset(data, null);
        CategoryAxis xAxisTrans = new CategoryAxis("Type");
        xAxisTrans.setLowerMargin(0.01);
        xAxisTrans.setUpperMargin(0.01);
        xAxisTrans.setCategoryMargin(0.05);
        NumberAxis yAxisTrans = new NumberAxis("Value");
        StatisticalBarRenderer rendererTrans = new StatisticalBarRenderer();
        CategoryPlot plotTrans = new CategoryPlot(datasetTrans, xAxisTrans, yAxisTrans, rendererTrans);
        rendererTrans.setToolTipGenerator(new CustomToolTipGenerator(false, false, this.places, this.transitions, data, null));
        this.transitionsChartPanel.removeAll();
        this.transitionsChart = new JFreeChart("Transitions statistical data", new Font("Helvetica", 1, 14), plotTrans, true);
        ChartPanel chartPanelTrans = new ChartPanel(this.transitionsChart);
        chartPanelTrans.setPreferredSize(new Dimension(data.transNumber * 40, 270));
        chartPanelTrans.setMaximumDrawWidth(data.transNumber * 40);
        JScrollPane sPaneTrans = new JScrollPane(chartPanelTrans);
        this.transitionsChartPanel.add((Component)sPaneTrans, "Center");
        this.transitionsChartPanel.revalidate();
        this.transitionsChartPanel.repaint();
    }

    private NetSimulationData getCorrectSet(boolean showRef) {
        NetSimulationData data;
        if (showRef) {
            int selectedRef = this.referencesCombo.getSelectedIndex() - 1;
            if (selectedRef == -1) {
                return null;
            }
            data = this.pn.accessSimKnockoutData().getReferenceSet(selectedRef);
        } else {
            int selectedKnockout = this.dataCombo.getSelectedIndex() - 1;
            if (selectedKnockout == -1) {
                return null;
            }
            data = this.pn.accessSimKnockoutData().getKnockoutSet(selectedKnockout);
        }
        if (data == null) {
            this.overlord.log("Error accessing dataset.", "error", true);
            return null;
        }
        return data;
    }

    protected void showCompareCharts() {
        int selectedRef = this.referencesCombo.getSelectedIndex() - 1;
        if (selectedRef == -1) {
            return;
        }
        NetSimulationData refData = this.pn.accessSimKnockoutData().getReferenceSet(selectedRef);
        int selectedKnockout = this.dataCombo.getSelectedIndex() - 1;
        if (selectedKnockout == -1) {
            return;
        }
        NetSimulationData knockData = this.pn.accessSimKnockoutData().getKnockoutSet(selectedKnockout);
        if (refData == null || knockData == null) {
            this.overlord.log("Error accessing dataset.", "error", true);
            return;
        }
        StatisticalCategoryDataset datasetPlaces = this.createPlacesDataset(refData, knockData);
        CategoryAxis xAxisPlaces = new CategoryAxis("Type");
        xAxisPlaces.setLowerMargin(0.01);
        xAxisPlaces.setUpperMargin(0.01);
        xAxisPlaces.setCategoryMargin(0.1);
        NumberAxis yAxisPlaces = new NumberAxis("Value");
        StatisticalBarRenderer rendererPlaces = new StatisticalBarRenderer();
        CategoryPlot plotPlaces = new CategoryPlot(datasetPlaces, xAxisPlaces, yAxisPlaces, rendererPlaces);
        BarRenderer rendererBarPlaces = (BarRenderer)plotPlaces.getRenderer();
        rendererBarPlaces.setItemMargin(0.0);
        rendererPlaces.setToolTipGenerator(new CustomToolTipGenerator(true, true, this.places, this.transitions, refData, knockData));
        this.placesChartPanel.removeAll();
        this.placesChart = new JFreeChart("Places statistical data", new Font("Helvetica", 1, 14), plotPlaces, true);
        ChartPanel chartPanelPlaces = new ChartPanel(this.placesChart);
        chartPanelPlaces.setPreferredSize(new Dimension(refData.placesNumber * 50, 270));
        chartPanelPlaces.setMaximumDrawWidth(refData.placesNumber * 50);
        JScrollPane sPanePlaces = new JScrollPane(chartPanelPlaces);
        this.placesChartPanel.add((Component)sPanePlaces, "Center");
        this.placesChartPanel.revalidate();
        this.placesChartPanel.repaint();
        StatisticalCategoryDataset datasetTrans = this.createTransitionsDataset(refData, knockData);
        CategoryAxis xAxisTrans = new CategoryAxis("Type");
        xAxisTrans.setLowerMargin(0.01);
        xAxisTrans.setUpperMargin(0.01);
        xAxisTrans.setCategoryMargin(0.1);
        NumberAxis yAxisTrans = new NumberAxis("Value");
        StatisticalBarRenderer rendererTrans = new StatisticalBarRenderer();
        CategoryPlot plotTrans = new CategoryPlot(datasetTrans, xAxisTrans, yAxisTrans, rendererTrans);
        BarRenderer rendererBarTrans = (BarRenderer)plotTrans.getRenderer();
        rendererBarTrans.setItemMargin(0.0);
        rendererTrans.setToolTipGenerator(new CustomToolTipGenerator(false, true, this.places, this.transitions, refData, knockData));
        this.transitionsChartPanel.removeAll();
        this.transitionsChart = new JFreeChart("Transitions statistical data", new Font("Helvetica", 1, 14), plotTrans, true);
        ChartPanel chartPanelTrans = new ChartPanel(this.transitionsChart);
        chartPanelTrans.setPreferredSize(new Dimension(refData.transNumber * 50, 270));
        chartPanelTrans.setMaximumDrawWidth(refData.transNumber * 50);
        JScrollPane sPaneTrans = new JScrollPane(chartPanelTrans);
        this.transitionsChartPanel.add((Component)sPaneTrans, "Center");
        this.transitionsChartPanel.revalidate();
        this.transitionsChartPanel.repaint();
    }

    private StatisticalCategoryDataset createPlacesDataset(NetSimulationData data, NetSimulationData compData) {
        DefaultStatisticalCategoryDataset result = new DefaultStatisticalCategoryDataset();
        if (compData == null) {
            double val;
            int p;
            int places = data.placesNumber;
            double max = 0.0;
            for (p = 0; p < places; ++p) {
                val = data.placeTokensAvg.get(p);
                if (!(val > max)) continue;
                max = val;
            }
            for (p = 0; p < places; ++p) {
                val = data.placeTokensAvg.get(p);
                if (val > 0.0) {
                    result.add(data.placeTokensAvg.get(p), data.placeStdDev.get(p), (Comparable)((Object)"Tokens"), (Comparable)((Object)("p" + p)));
                    continue;
                }
                result.add(-(0.05 * max), 0.0, (Comparable)((Object)"Tokens"), (Comparable)((Object)("p" + p)));
            }
        } else {
            double val;
            int p;
            int placesRef = data.placesNumber;
            int placesKnock = compData.placesNumber;
            if (placesRef != placesKnock) {
                this.overlord.log("Reference set and knockout set have different number of places.", "error", true);
                return null;
            }
            double maxRef = 0.0;
            double maxKnock = 0.0;
            for (p = 0; p < placesRef; ++p) {
                val = data.placeTokensAvg.get(p);
                if (val > maxRef) {
                    maxRef = val;
                }
                if (!((val = compData.placeTokensAvg.get(p).doubleValue()) > maxKnock)) continue;
                maxKnock = val;
            }
            for (p = 0; p < placesRef; ++p) {
                val = data.placeTokensAvg.get(p);
                double valKnock = compData.placeTokensAvg.get(p);
                if (val > 0.0) {
                    result.add(data.placeTokensAvg.get(p), data.placeStdDev.get(p), (Comparable)((Object)"Reference dataset"), (Comparable)((Object)("p" + p)));
                } else {
                    result.add(-(0.05 * maxRef), 0.0, (Comparable)((Object)"Reference dataset"), (Comparable)((Object)("p" + p)));
                }
                if (valKnock > 0.0) {
                    result.add(compData.placeTokensAvg.get(p), compData.placeStdDev.get(p), (Comparable)((Object)"Knockout dataset"), (Comparable)((Object)("p" + p)));
                    continue;
                }
                result.add(-(0.05 * maxRef), 0.0, (Comparable)((Object)"Knockout dataset"), (Comparable)((Object)("p" + p)));
            }
        }
        return result;
    }

    private StatisticalCategoryDataset createTransitionsDataset(NetSimulationData data, NetSimulationData compData) {
        DefaultStatisticalCategoryDataset result = new DefaultStatisticalCategoryDataset();
        if (compData == null) {
            double val;
            int t;
            int transitions = data.transNumber;
            double max = 0.0;
            for (t = 0; t < transitions; ++t) {
                val = data.transFiringsAvg.get(t);
                if (!(val > max)) continue;
                max = val;
            }
            for (t = 0; t < transitions; ++t) {
                val = data.transFiringsAvg.get(t);
                if (val > 0.0) {
                    result.add(data.transFiringsAvg.get(t), data.transStdDev.get(t), (Comparable)((Object)"Firing"), (Comparable)((Object)("t" + t)));
                    continue;
                }
                result.add(-(0.05 * max), 0.0, (Comparable)((Object)"Firing"), (Comparable)((Object)("t" + t)));
            }
        } else {
            double val;
            int t;
            int transRef = data.transNumber;
            int transKnock = compData.transNumber;
            if (transRef != transKnock) {
                this.overlord.log("Reference set and knockout set have different number of transitions.", "error", true);
                return null;
            }
            double maxRef = 0.0;
            double maxKnock = 0.0;
            for (t = 0; t < transRef; ++t) {
                val = data.transFiringsAvg.get(t);
                if (val > maxRef) {
                    maxRef = val;
                }
                if (!((val = compData.transFiringsAvg.get(t).doubleValue()) > maxKnock)) continue;
                maxKnock = val;
            }
            for (t = 0; t < transRef; ++t) {
                val = data.transFiringsAvg.get(t);
                double valKnock = compData.transFiringsAvg.get(t);
                if (val > 0.0) {
                    result.add(data.transFiringsAvg.get(t), data.transStdDev.get(t), (Comparable)((Object)"Reference dataset"), (Comparable)((Object)("t" + t)));
                } else {
                    result.add(-(0.05 * maxRef), 0.0, (Comparable)((Object)"Reference dataset"), (Comparable)((Object)("t" + t)));
                }
                if (valKnock > 0.0) {
                    result.add(compData.transFiringsAvg.get(t), compData.transStdDev.get(t), (Comparable)((Object)"Knockout dataset"), (Comparable)((Object)("t" + t)));
                    continue;
                }
                result.add(-(0.05 * maxRef), 0.0, (Comparable)((Object)"Knockout dataset"), (Comparable)((Object)("t" + t)));
            }
        }
        return result;
    }

    private JPanel createPlacesTablePanel() {
        JPanel tablesSubPanel = new JPanel(new BorderLayout());
        tablesSubPanel.setPreferredSize(new Dimension(670, 560));
        tablesSubPanel.setLocation(0, 0);
        tablesSubPanel.setBorder(BorderFactory.createTitledBorder("Place single knockout data table:"));
        this.model = new DefaultTableModel();
        this.placesTable = new JTable(this.model);
        this.placesTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 1 && !e.isControlDown()) {
                    HolmesSimKnockVis.this.cellClickAction(HolmesSimKnockVis.this.placesTable);
                }
            }
        });
        this.tableRenderer = new SimKnockTableRenderer(this.placesTable);
        this.placesTable.setAutoResizeMode(0);
        JScrollPane tableScrollPane = new JScrollPane(this.placesTable, 20, 30);
        tablesSubPanel.add((Component)tableScrollPane, "Center");
        return tablesSubPanel;
    }

    private JPanel createPlacesCompAllTablePanel() {
        JPanel tablesSubPanel = new JPanel(new BorderLayout());
        tablesSubPanel.setPreferredSize(new Dimension(670, 560));
        tablesSubPanel.setLocation(0, 0);
        tablesSubPanel.setBorder(BorderFactory.createTitledBorder("Places comparison single knockout data table:"));
        this.model = new DefaultTableModel();
        this.placesCompAllTable = new JTable(this.model);
        this.placesCompAllTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 1 && !e.isControlDown()) {
                    HolmesSimKnockVis.this.cellClickAction(HolmesSimKnockVis.this.placesCompAllTable);
                }
            }
        });
        this.tableRenderer = new SimKnockTableRenderer(this.placesCompAllTable);
        this.placesCompAllTable.setAutoResizeMode(0);
        JScrollPane tableScrollPane = new JScrollPane(this.placesCompAllTable, 20, 30);
        tablesSubPanel.add((Component)tableScrollPane, "Center");
        return tablesSubPanel;
    }

    private JPanel createTransTablePanel() {
        JPanel tablesSubPanel = new JPanel(new BorderLayout());
        tablesSubPanel.setPreferredSize(new Dimension(670, 560));
        tablesSubPanel.setLocation(0, 0);
        tablesSubPanel.setBorder(BorderFactory.createTitledBorder("Transition single knockout data table:"));
        this.model = new DefaultTableModel();
        this.transTable = new JTable(this.model);
        this.transTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 1 && !e.isControlDown()) {
                    HolmesSimKnockVis.this.cellClickAction(HolmesSimKnockVis.this.transTable);
                }
            }
        });
        this.tableRenderer = new SimKnockTableRenderer(this.transTable);
        this.transTable.setAutoResizeMode(0);
        JScrollPane tableScrollPane = new JScrollPane(this.transTable, 20, 30);
        tablesSubPanel.add((Component)tableScrollPane, "Center");
        return tablesSubPanel;
    }

    private JPanel createTransCompAllTablePanel() {
        JPanel tablesSubPanel = new JPanel(new BorderLayout());
        tablesSubPanel.setPreferredSize(new Dimension(670, 560));
        tablesSubPanel.setLocation(0, 0);
        tablesSubPanel.setBorder(BorderFactory.createTitledBorder("Transition comparison single knockout data table:"));
        this.model = new DefaultTableModel();
        this.transCompAllTable = new JTable(this.model);
        this.transCompAllTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 1 && !e.isControlDown()) {
                    HolmesSimKnockVis.this.cellClickAction(HolmesSimKnockVis.this.transCompAllTable);
                }
            }
        });
        this.tableRenderer = new SimKnockTableRenderer(this.transCompAllTable);
        this.transCompAllTable.setAutoResizeMode(0);
        JScrollPane tableScrollPane = new JScrollPane(this.transCompAllTable, 20, 30);
        tablesSubPanel.add((Component)tableScrollPane, "Center");
        return tablesSubPanel;
    }

    private void createPlacesTable(boolean ref) {
        NetSimulationData data = this.getCorrectSet(ref);
        if (data == null) {
            return;
        }
        SimKnockPlacesTableModel modelPlaces = new SimKnockPlacesTableModel();
        this.placesTable.setModel(modelPlaces);
        int cellSize = 50;
        int largeCell = 65;
        int svaluesCell = 35;
        this.placesTable.getColumnModel().getColumn(0).setHeaderValue("ID");
        this.placesTable.getColumnModel().getColumn(0).setPreferredWidth(cellSize);
        this.placesTable.getColumnModel().getColumn(0).setMinWidth(cellSize);
        this.placesTable.getColumnModel().getColumn(0).setMaxWidth(cellSize);
        this.placesTable.getColumnModel().getColumn(1).setHeaderValue("Place name:");
        this.placesTable.getColumnModel().getColumn(1).setPreferredWidth(300);
        this.placesTable.getColumnModel().getColumn(1).setMinWidth(100);
        this.placesTable.getColumnModel().getColumn(2).setHeaderValue("AvgT:");
        this.placesTable.getColumnModel().getColumn(2).setPreferredWidth(largeCell);
        this.placesTable.getColumnModel().getColumn(2).setMinWidth(largeCell);
        this.placesTable.getColumnModel().getColumn(2).setMaxWidth(largeCell);
        this.placesTable.getColumnModel().getColumn(3).setHeaderValue("MinT:");
        this.placesTable.getColumnModel().getColumn(3).setPreferredWidth(largeCell);
        this.placesTable.getColumnModel().getColumn(3).setMinWidth(largeCell);
        this.placesTable.getColumnModel().getColumn(3).setMaxWidth(largeCell);
        this.placesTable.getColumnModel().getColumn(4).setHeaderValue("MaxT:");
        this.placesTable.getColumnModel().getColumn(4).setPreferredWidth(largeCell);
        this.placesTable.getColumnModel().getColumn(4).setMinWidth(largeCell);
        this.placesTable.getColumnModel().getColumn(4).setMaxWidth(largeCell);
        this.placesTable.getColumnModel().getColumn(5).setHeaderValue("notT:");
        this.placesTable.getColumnModel().getColumn(5).setPreferredWidth(cellSize);
        this.placesTable.getColumnModel().getColumn(5).setMinWidth(cellSize);
        this.placesTable.getColumnModel().getColumn(5).setMaxWidth(cellSize);
        this.placesTable.getColumnModel().getColumn(6).setHeaderValue("stdDev:");
        this.placesTable.getColumnModel().getColumn(6).setPreferredWidth(cellSize);
        this.placesTable.getColumnModel().getColumn(6).setMinWidth(cellSize);
        this.placesTable.getColumnModel().getColumn(6).setMaxWidth(cellSize);
        this.placesTable.getColumnModel().getColumn(7).setHeaderValue("S1%");
        this.placesTable.getColumnModel().getColumn(7).setPreferredWidth(svaluesCell);
        this.placesTable.getColumnModel().getColumn(7).setMinWidth(svaluesCell);
        this.placesTable.getColumnModel().getColumn(7).setMaxWidth(svaluesCell);
        this.placesTable.getColumnModel().getColumn(8).setHeaderValue("S2%");
        this.placesTable.getColumnModel().getColumn(8).setPreferredWidth(svaluesCell);
        this.placesTable.getColumnModel().getColumn(8).setMinWidth(svaluesCell);
        this.placesTable.getColumnModel().getColumn(8).setMaxWidth(svaluesCell);
        this.placesTable.getColumnModel().getColumn(9).setHeaderValue("S3%");
        this.placesTable.getColumnModel().getColumn(9).setPreferredWidth(svaluesCell);
        this.placesTable.getColumnModel().getColumn(9).setMinWidth(svaluesCell);
        this.placesTable.getColumnModel().getColumn(9).setMaxWidth(svaluesCell);
        this.placesTable.getColumnModel().getColumn(10).setHeaderValue("S4%");
        this.placesTable.getColumnModel().getColumn(10).setPreferredWidth(svaluesCell);
        this.placesTable.getColumnModel().getColumn(10).setMinWidth(svaluesCell);
        this.placesTable.getColumnModel().getColumn(10).setMaxWidth(svaluesCell);
        this.placesTable.getColumnModel().getColumn(11).setHeaderValue("S5%");
        this.placesTable.getColumnModel().getColumn(11).setPreferredWidth(svaluesCell);
        this.placesTable.getColumnModel().getColumn(11).setMinWidth(svaluesCell);
        this.placesTable.getColumnModel().getColumn(11).setMaxWidth(svaluesCell);
        TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(this.placesTable.getModel());
        this.placesTable.setRowSorter(sorter);
        this.placesTable.setName("PlacesTable");
        this.placesTable.setFillsViewportHeight(true);
        this.tableRenderer.setMode(0);
        this.placesTable.setDefaultRenderer(Object.class, this.tableRenderer);
        try {
            if (this.places.size() == 0) {
                for (int p = 0; p < data.placesNumber; ++p) {
                    modelPlaces.addNew(data, p, null);
                }
            } else {
                int index = -1;
                for (Place place : this.places) {
                    modelPlaces.addNew(data, ++index, place);
                }
            }
        }
        catch (Exception ex) {
            GUIManager.getDefaultGUIManager().log("Error (704284698) | Exception:  " + ex.getMessage(), "error", true);
        }
        this.placesTable.setAutoResizeMode(4);
        this.placesTable.validate();
    }

    private void createPlacesCompTable() {
        NetSimulationData dataRef = this.getCorrectSet(true);
        NetSimulationData dataComp = this.getCorrectSet(false);
        if (dataRef == null || dataComp == null) {
            return;
        }
        SimKnockPlacesCompTableModel modelPlacesComp = new SimKnockPlacesCompTableModel();
        this.placesTable.setModel(modelPlacesComp);
        int cellSize = 50;
        int largeCell = 65;
        this.placesTable.getColumnModel().getColumn(0).setHeaderValue("ID");
        this.placesTable.getColumnModel().getColumn(0).setPreferredWidth(cellSize);
        this.placesTable.getColumnModel().getColumn(0).setMinWidth(cellSize);
        this.placesTable.getColumnModel().getColumn(0).setMaxWidth(cellSize);
        this.placesTable.getColumnModel().getColumn(1).setHeaderValue("Place name");
        this.placesTable.getColumnModel().getColumn(1).setPreferredWidth(300);
        this.placesTable.getColumnModel().getColumn(1).setMinWidth(100);
        this.placesTable.getColumnModel().getColumn(2).setHeaderValue("AvgTRef");
        this.placesTable.getColumnModel().getColumn(2).setPreferredWidth(largeCell);
        this.placesTable.getColumnModel().getColumn(2).setMinWidth(largeCell);
        this.placesTable.getColumnModel().getColumn(2).setMaxWidth(largeCell);
        this.placesTable.getColumnModel().getColumn(3).setHeaderValue("stdDevRef");
        this.placesTable.getColumnModel().getColumn(3).setPreferredWidth(largeCell);
        this.placesTable.getColumnModel().getColumn(3).setMinWidth(largeCell);
        this.placesTable.getColumnModel().getColumn(3).setMaxWidth(largeCell);
        this.placesTable.getColumnModel().getColumn(4).setHeaderValue("AvgTKnock");
        this.placesTable.getColumnModel().getColumn(4).setPreferredWidth(largeCell);
        this.placesTable.getColumnModel().getColumn(4).setMinWidth(largeCell);
        this.placesTable.getColumnModel().getColumn(4).setMaxWidth(largeCell);
        this.placesTable.getColumnModel().getColumn(5).setHeaderValue("stdDevKnock");
        this.placesTable.getColumnModel().getColumn(5).setPreferredWidth(cellSize);
        this.placesTable.getColumnModel().getColumn(5).setMinWidth(cellSize);
        this.placesTable.getColumnModel().getColumn(5).setMaxWidth(cellSize);
        this.placesTable.getColumnModel().getColumn(6).setHeaderValue("diff:");
        this.placesTable.getColumnModel().getColumn(6).setPreferredWidth(largeCell + 10);
        this.placesTable.getColumnModel().getColumn(6).setMinWidth(largeCell + 10);
        this.placesTable.getColumnModel().getColumn(6).setMaxWidth(largeCell + 10);
        this.placesTable.getColumnModel().getColumn(7).setHeaderValue("noTok");
        this.placesTable.getColumnModel().getColumn(7).setPreferredWidth(largeCell);
        this.placesTable.getColumnModel().getColumn(7).setMinWidth(largeCell);
        this.placesTable.getColumnModel().getColumn(7).setMaxWidth(largeCell);
        this.placesTable.getColumnModel().getColumn(8).setHeaderValue("Sign1");
        this.placesTable.getColumnModel().getColumn(8).setPreferredWidth(cellSize);
        this.placesTable.getColumnModel().getColumn(8).setMinWidth(cellSize);
        this.placesTable.getColumnModel().getColumn(8).setMaxWidth(cellSize);
        this.placesTable.getColumnModel().getColumn(9).setHeaderValue("Sign2");
        this.placesTable.getColumnModel().getColumn(9).setPreferredWidth(cellSize);
        this.placesTable.getColumnModel().getColumn(9).setMinWidth(cellSize);
        this.placesTable.getColumnModel().getColumn(9).setMaxWidth(cellSize);
        TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(this.placesTable.getModel());
        this.placesTable.setRowSorter(sorter);
        this.placesTable.setName("PlacesCompTable");
        this.placesTable.setFillsViewportHeight(true);
        SimKnockTableRenderer tableRendererPlaces = new SimKnockTableRenderer(this.placesTable);
        tableRendererPlaces.setMode(2);
        this.placesTable.setDefaultRenderer(String.class, tableRendererPlaces);
        this.placesTable.setDefaultRenderer(Double.class, tableRendererPlaces);
        try {
            int index;
            if (this.places.size() == 0) {
                for (index = 0; index < dataRef.placesNumber; ++index) {
                    modelPlacesComp.addNew(dataRef, dataComp, index, null);
                }
            } else {
                index = -1;
                for (Place place : this.places) {
                    modelPlacesComp.addNew(dataRef, dataComp, ++index, place);
                }
            }
        }
        catch (Exception ex) {
            GUIManager.getDefaultGUIManager().log("Error (656544812) | Exception:  " + ex.getMessage(), "error", true);
        }
        this.placesTable.setAutoResizeMode(4);
        this.placesTable.validate();
        if (this.notepadInfo) {
            HolmesNotepad notepad = new HolmesNotepad(900, 600);
            notepad.setVisible(true);
            notepad.addTextLine("PLACES", "text");
            for (SimKnockPlacesCompTableModel.PlaceCompContainer data : modelPlacesComp.accessDataMatrix()) {
                double diff = data.tokenAvgPercDiff / 100.0;
                Object dif = data.tokenAvgPercDiff == -999999.0 ? " -inf" : (data.tokenAvgPercDiff == 999991.0 ? " ---" : (data.tokenAvgPercDiff == 999999.0 ? " +inf" : "" + diff));
                Object row = data.ID + ";" + data.name + ";" + data.tokenAvgRef + ";" + data.tokenAvgKnock + ";" + (String)dif + "\n";
                row = ((String)row).replace(".", ",");
                notepad.addTextLine((String)row, "text");
            }
        }
    }

    private void createTransTable(boolean ref) {
        NetSimulationData data = this.getCorrectSet(ref);
        if (data == null) {
            return;
        }
        SimKnockTransTableModel modelTrans = new SimKnockTransTableModel();
        this.transTable.setModel(modelTrans);
        int cellSize = 50;
        int largeCell = 65;
        int svaluesCell = 35;
        int hugeCell = 80;
        this.transTable.getColumnModel().getColumn(0).setHeaderValue("ID");
        this.transTable.getColumnModel().getColumn(0).setPreferredWidth(cellSize);
        this.transTable.getColumnModel().getColumn(0).setMinWidth(cellSize);
        this.transTable.getColumnModel().getColumn(0).setMaxWidth(cellSize);
        this.transTable.getColumnModel().getColumn(1).setHeaderValue("Transition name:");
        this.transTable.getColumnModel().getColumn(1).setPreferredWidth(300);
        this.transTable.getColumnModel().getColumn(1).setMinWidth(100);
        this.transTable.getColumnModel().getColumn(2).setHeaderValue("AvgF:");
        this.transTable.getColumnModel().getColumn(2).setPreferredWidth(hugeCell);
        this.transTable.getColumnModel().getColumn(2).setMinWidth(hugeCell);
        this.transTable.getColumnModel().getColumn(2).setMaxWidth(hugeCell);
        this.transTable.getColumnModel().getColumn(3).setHeaderValue("MinF:");
        this.transTable.getColumnModel().getColumn(3).setPreferredWidth(hugeCell);
        this.transTable.getColumnModel().getColumn(3).setMinWidth(hugeCell);
        this.transTable.getColumnModel().getColumn(3).setMaxWidth(hugeCell);
        this.transTable.getColumnModel().getColumn(4).setHeaderValue("MaxF:");
        this.transTable.getColumnModel().getColumn(4).setPreferredWidth(hugeCell);
        this.transTable.getColumnModel().getColumn(4).setMinWidth(hugeCell);
        this.transTable.getColumnModel().getColumn(4).setMaxWidth(hugeCell);
        this.transTable.getColumnModel().getColumn(5).setHeaderValue("notF:");
        this.transTable.getColumnModel().getColumn(5).setPreferredWidth(cellSize);
        this.transTable.getColumnModel().getColumn(5).setMinWidth(cellSize);
        this.transTable.getColumnModel().getColumn(5).setMaxWidth(cellSize);
        this.transTable.getColumnModel().getColumn(6).setHeaderValue("stdDev:");
        this.transTable.getColumnModel().getColumn(6).setPreferredWidth(cellSize);
        this.transTable.getColumnModel().getColumn(6).setMinWidth(cellSize);
        this.transTable.getColumnModel().getColumn(6).setMaxWidth(cellSize);
        this.transTable.getColumnModel().getColumn(7).setHeaderValue("S1%");
        this.transTable.getColumnModel().getColumn(7).setPreferredWidth(svaluesCell);
        this.transTable.getColumnModel().getColumn(7).setMinWidth(svaluesCell);
        this.transTable.getColumnModel().getColumn(7).setMaxWidth(svaluesCell);
        this.transTable.getColumnModel().getColumn(8).setHeaderValue("S2%");
        this.transTable.getColumnModel().getColumn(8).setPreferredWidth(svaluesCell);
        this.transTable.getColumnModel().getColumn(8).setMinWidth(svaluesCell);
        this.transTable.getColumnModel().getColumn(8).setMaxWidth(svaluesCell);
        this.transTable.getColumnModel().getColumn(9).setHeaderValue("S3%");
        this.transTable.getColumnModel().getColumn(9).setPreferredWidth(svaluesCell);
        this.transTable.getColumnModel().getColumn(9).setMinWidth(svaluesCell);
        this.transTable.getColumnModel().getColumn(9).setMaxWidth(svaluesCell);
        this.transTable.getColumnModel().getColumn(10).setHeaderValue("S4%");
        this.transTable.getColumnModel().getColumn(10).setPreferredWidth(svaluesCell);
        this.transTable.getColumnModel().getColumn(10).setMinWidth(svaluesCell);
        this.transTable.getColumnModel().getColumn(10).setMaxWidth(svaluesCell);
        this.transTable.getColumnModel().getColumn(11).setHeaderValue("S5%");
        this.transTable.getColumnModel().getColumn(11).setPreferredWidth(svaluesCell);
        this.transTable.getColumnModel().getColumn(11).setMinWidth(svaluesCell);
        this.transTable.getColumnModel().getColumn(11).setMaxWidth(svaluesCell);
        TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(this.transTable.getModel());
        this.transTable.setRowSorter(sorter);
        this.transTable.setName("TransitionsTable");
        this.transTable.setFillsViewportHeight(true);
        this.tableRenderer.setMode(0);
        this.transTable.setDefaultRenderer(Object.class, this.tableRenderer);
        try {
            if (this.transitions.size() == 0) {
                for (int p = 0; p < data.transNumber; ++p) {
                    modelTrans.addNew(data, p, null);
                }
            } else {
                int index = -1;
                for (Transition trans : this.transitions) {
                    modelTrans.addNew(data, ++index, trans);
                }
            }
        }
        catch (Exception ex) {
            GUIManager.getDefaultGUIManager().log("Error (391946877) | Exception:  " + ex.getMessage(), "error", true);
        }
        this.transTable.setAutoResizeMode(4);
        this.transTable.validate();
    }

    private void createTransCompTable() {
        NetSimulationData dataRef = this.getCorrectSet(true);
        NetSimulationData dataComp = this.getCorrectSet(false);
        if (dataRef == null || dataComp == null) {
            return;
        }
        SimKnockTransCompTableModel modelTransComp = new SimKnockTransCompTableModel();
        this.transTable.setModel(modelTransComp);
        int cellSize = 50;
        int largeCell = 65;
        this.transTable.getColumnModel().getColumn(0).setHeaderValue("ID");
        this.transTable.getColumnModel().getColumn(0).setPreferredWidth(cellSize);
        this.transTable.getColumnModel().getColumn(0).setMinWidth(cellSize);
        this.transTable.getColumnModel().getColumn(0).setMaxWidth(cellSize);
        this.transTable.getColumnModel().getColumn(1).setHeaderValue("Transition name");
        this.transTable.getColumnModel().getColumn(1).setPreferredWidth(300);
        this.transTable.getColumnModel().getColumn(1).setMinWidth(100);
        this.transTable.getColumnModel().getColumn(2).setHeaderValue("AvgFRef");
        this.transTable.getColumnModel().getColumn(2).setPreferredWidth(largeCell);
        this.transTable.getColumnModel().getColumn(2).setMinWidth(largeCell);
        this.transTable.getColumnModel().getColumn(2).setMaxWidth(largeCell);
        this.transTable.getColumnModel().getColumn(3).setHeaderValue("stdDevRef");
        this.transTable.getColumnModel().getColumn(3).setPreferredWidth(largeCell);
        this.transTable.getColumnModel().getColumn(3).setMinWidth(largeCell);
        this.transTable.getColumnModel().getColumn(3).setMaxWidth(largeCell);
        this.transTable.getColumnModel().getColumn(4).setHeaderValue("AvgFKnock");
        this.transTable.getColumnModel().getColumn(4).setPreferredWidth(largeCell);
        this.transTable.getColumnModel().getColumn(4).setMinWidth(largeCell);
        this.transTable.getColumnModel().getColumn(4).setMaxWidth(largeCell);
        this.transTable.getColumnModel().getColumn(5).setHeaderValue("stdDevKnock");
        this.transTable.getColumnModel().getColumn(5).setPreferredWidth(cellSize);
        this.transTable.getColumnModel().getColumn(5).setMinWidth(cellSize);
        this.transTable.getColumnModel().getColumn(5).setMaxWidth(cellSize);
        this.transTable.getColumnModel().getColumn(6).setHeaderValue("diff:");
        this.transTable.getColumnModel().getColumn(6).setPreferredWidth(largeCell + 10);
        this.transTable.getColumnModel().getColumn(6).setMinWidth(largeCell + 10);
        this.transTable.getColumnModel().getColumn(6).setMaxWidth(largeCell + 10);
        this.transTable.getColumnModel().getColumn(7).setHeaderValue("noFire");
        this.transTable.getColumnModel().getColumn(7).setPreferredWidth(largeCell);
        this.transTable.getColumnModel().getColumn(7).setMinWidth(largeCell);
        this.transTable.getColumnModel().getColumn(7).setMaxWidth(largeCell);
        this.transTable.getColumnModel().getColumn(8).setHeaderValue("Sign1");
        this.transTable.getColumnModel().getColumn(8).setPreferredWidth(cellSize);
        this.transTable.getColumnModel().getColumn(8).setMinWidth(cellSize);
        this.transTable.getColumnModel().getColumn(8).setMaxWidth(cellSize);
        this.transTable.getColumnModel().getColumn(9).setHeaderValue("Sign2");
        this.transTable.getColumnModel().getColumn(9).setPreferredWidth(cellSize);
        this.transTable.getColumnModel().getColumn(9).setMinWidth(cellSize);
        this.transTable.getColumnModel().getColumn(9).setMaxWidth(cellSize);
        TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(this.transTable.getModel());
        this.transTable.setRowSorter(sorter);
        this.transTable.setName("TransitionsCompTable");
        this.transTable.setFillsViewportHeight(true);
        SimKnockTableRenderer tableRendererTrans = new SimKnockTableRenderer(this.transTable);
        tableRendererTrans.setMode(1);
        this.transTable.setDefaultRenderer(String.class, tableRendererTrans);
        this.transTable.setDefaultRenderer(Double.class, tableRendererTrans);
        try {
            int index;
            if (this.transitions.size() == 0) {
                for (index = 0; index < dataRef.transNumber; ++index) {
                    modelTransComp.addNew(dataRef, dataComp, index, null);
                }
            } else {
                index = -1;
                for (Transition trans : this.transitions) {
                    modelTransComp.addNew(dataRef, dataComp, ++index, trans);
                }
            }
        }
        catch (Exception ex) {
            GUIManager.getDefaultGUIManager().log("Error (121688445) | Exception:  " + ex.getMessage(), "error", true);
        }
        this.transTable.setAutoResizeMode(4);
        this.transTable.validate();
        if (this.notepadInfo) {
            HolmesNotepad notepad = new HolmesNotepad(900, 600);
            notepad.setVisible(true);
            notepad.addTextLine("TRANSITIONS\n", "text");
            for (SimKnockTransCompTableModel.TransCompContainer data : modelTransComp.accessDataMatrix()) {
                double diff = data.firingAvgPercDiff;
                Object dif = diff == -999999.0 ? " -inf" : (diff == 999991.0 ? " ---" : (diff == 999999.0 ? " +inf" : "" + diff / 100.0));
                Object row = data.ID + ";" + data.name + ";" + data.firingAvgRef / 100.0 + ";" + data.firingAvgKnock / 100.0 + ";" + (String)dif + "\n";
                row = ((String)row).replace(".", ",");
                notepad.addTextLine((String)row, "text");
            }
        }
    }

    private void createCompareAllTables(int selected) {
        long IDseries = this.pn.accessSimKnockoutData().accessSeries().get(selected);
        ArrayList<NetSimulationData> dataPackage = this.pn.accessSimKnockoutData().getSeriesDatasets(IDseries);
        int selRef = this.referencesCombo.getSelectedIndex() - 1;
        if (selRef == -1) {
            JOptionPane.showMessageDialog(null, "Please select reference set!", "Reference selection", 2);
            this.seriesCombo.setSelectedIndex(0);
            return;
        }
        NetSimulationData refSet = this.pn.accessSimKnockoutData().getReferenceSet(selRef);
        if (dataPackage == null) {
            return;
        }
        int transNumber = dataPackage.get((int)0).transNumber;
        SimKnockTransCompAllTableModel modelTransCompAll = new SimKnockTransCompAllTableModel(transNumber);
        this.transCompAllTable.setModel(modelTransCompAll);
        this.transCompAllTable.getColumnModel().getColumn(0).setHeaderValue("ID");
        this.transCompAllTable.getColumnModel().getColumn(0).setPreferredWidth(40);
        this.transCompAllTable.getColumnModel().getColumn(0).setMinWidth(40);
        this.transCompAllTable.getColumnModel().getColumn(0).setMaxWidth(40);
        this.transCompAllTable.getColumnModel().getColumn(1).setHeaderValue("Transition name");
        this.transCompAllTable.getColumnModel().getColumn(1).setPreferredWidth(300);
        this.transCompAllTable.getColumnModel().getColumn(1).setMinWidth(100);
        this.transCompAllTable.getColumnModel().getColumn(2).setHeaderValue("Knocked");
        this.transCompAllTable.getColumnModel().getColumn(2).setPreferredWidth(50);
        this.transCompAllTable.getColumnModel().getColumn(2).setMinWidth(50);
        this.transCompAllTable.getColumnModel().getColumn(2).setMaxWidth(50);
        for (int i = 0; i < transNumber; ++i) {
            this.transCompAllTable.getColumnModel().getColumn(i + 3).setHeaderValue("t" + i);
        }
        TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(this.transCompAllTable.getModel());
        this.transCompAllTable.setRowSorter(sorter);
        this.transCompAllTable.setName("TransitionsCompAllTable");
        this.transCompAllTable.setFillsViewportHeight(true);
        SimKnockTableRenderer tableRendererTransitions = new SimKnockTableRenderer(this.transCompAllTable);
        tableRendererTransitions.setMode(3);
        this.transCompAllTable.setDefaultRenderer(String.class, tableRendererTransitions);
        this.transCompAllTable.setDefaultRenderer(Double.class, tableRendererTransitions);
        this.transCompAllTable.setAutoResizeMode(0);
        this.transCompAllTable.validate();
        this.resizeColumnWidth(this.transCompAllTable);
        int placesNumber = dataPackage.get((int)0).placesNumber;
        SimKnockPlacesCompAllTableModel modelPlacesCompAll = new SimKnockPlacesCompAllTableModel(placesNumber);
        this.placesCompAllTable.setModel(modelPlacesCompAll);
        this.placesCompAllTable.getColumnModel().getColumn(0).setHeaderValue("ID");
        this.placesCompAllTable.getColumnModel().getColumn(0).setPreferredWidth(40);
        this.placesCompAllTable.getColumnModel().getColumn(0).setMinWidth(40);
        this.placesCompAllTable.getColumnModel().getColumn(0).setMaxWidth(40);
        this.placesCompAllTable.getColumnModel().getColumn(1).setHeaderValue("Transition name");
        this.placesCompAllTable.getColumnModel().getColumn(1).setPreferredWidth(300);
        this.placesCompAllTable.getColumnModel().getColumn(1).setMinWidth(100);
        this.placesCompAllTable.getColumnModel().getColumn(2).setHeaderValue("Disabled");
        this.placesCompAllTable.getColumnModel().getColumn(2).setPreferredWidth(50);
        this.placesCompAllTable.getColumnModel().getColumn(2).setMinWidth(50);
        this.placesCompAllTable.getColumnModel().getColumn(2).setMaxWidth(50);
        for (int i = 0; i < placesNumber; ++i) {
            this.placesCompAllTable.getColumnModel().getColumn(i + 3).setHeaderValue("p" + i);
        }
        TableRowSorter<TableModel> sorterPlaces = new TableRowSorter<TableModel>(this.placesCompAllTable.getModel());
        this.placesCompAllTable.setRowSorter(sorterPlaces);
        this.placesCompAllTable.setName("PlacesCompAllTable");
        this.placesCompAllTable.setFillsViewportHeight(true);
        SimKnockTableRenderer tableRendererPlaces = new SimKnockTableRenderer(this.placesCompAllTable);
        tableRendererPlaces.setMode(3);
        this.placesCompAllTable.setDefaultRenderer(String.class, tableRendererPlaces);
        this.placesCompAllTable.setDefaultRenderer(Double.class, tableRendererPlaces);
        this.placesCompAllTable.setAutoResizeMode(0);
        this.placesCompAllTable.validate();
        this.resizeColumnWidth(this.placesCompAllTable);
        HolmesNotepad notePadTrans = null;
        HolmesNotepad notePadPlaces = null;
        if (this.notepadInfo) {
            notePadTrans = new HolmesNotepad(900, 600);
            notePadTrans.setVisible(true);
            notePadPlaces = new HolmesNotepad(900, 600);
            notePadPlaces.setVisible(true);
        }
        modelTransCompAll.tTableData = new ArrayList();
        modelPlacesCompAll.pTableData = new ArrayList();
        for (int t = 0; t < transNumber; ++t) {
            double diff;
            Object details;
            ArrayList<String> pVector = new ArrayList<String>();
            ArrayList<String> tVector = new ArrayList<String>();
            ArrayList<Object> pTableVector = new ArrayList<Object>();
            ArrayList<Object> tTableVector = new ArrayList<Object>();
            NetSimulationData dataSet = dataPackage.get(t);
            pVector.add("" + t);
            tVector.add("" + t);
            pTableVector.add(null);
            tTableVector.add(null);
            String name = this.transitions.size() == 0 ? "t" + t : "t" + this.transitions.get(t).getName();
            pVector.add(name);
            tVector.add(name);
            pTableVector.add(null);
            tTableVector.add(null);
            pVector.add("0");
            tVector.add("0");
            pTableVector.add(null);
            tTableVector.add(null);
            for (int t1 = 0; t1 < transNumber; ++t1) {
                details = modelTransCompAll.newDetailsInstance();
                ((SimKnockTransCompAllTableModel.DetailsTrans)details).knockAvgFiring = dataSet.transFiringsAvg.get(t1);
                ((SimKnockTransCompAllTableModel.DetailsTrans)details).refAvgFiring = refSet.transFiringsAvg.get(t1);
                ((SimKnockTransCompAllTableModel.DetailsTrans)details).knockDisabled = dataSet.transZeroFiring.get(t1);
                ((SimKnockTransCompAllTableModel.DetailsTrans)details).significance1 = this.getTransSign1(refSet, dataSet, t1);
                ((SimKnockTransCompAllTableModel.DetailsTrans)details).significance2 = this.getTransSign2(refSet, dataSet, t1);
                ((SimKnockTransCompAllTableModel.DetailsTrans)details).diff = 0.0;
                if (refSet.transFiringsAvg.get(t1) == 0.0 && dataSet.transFiringsAvg.get(t1) == 0.0) {
                    tVector.add("999990.0");
                    tTableVector.add(details);
                    continue;
                }
                if (refSet.transFiringsAvg.get(t1) == 0.0 && dataSet.transFiringsAvg.get(t1) > 0.0) {
                    tVector.add("+999999.0");
                    tTableVector.add(details);
                    continue;
                }
                if (refSet.transFiringsAvg.get(t1) > 0.0 && dataSet.transFiringsAvg.get(t1) == 0.0) {
                    tVector.add("-999999.0");
                    tTableVector.add(details);
                    continue;
                }
                diff = ((SimKnockTransCompAllTableModel.DetailsTrans)details).refAvgFiring - ((SimKnockTransCompAllTableModel.DetailsTrans)details).knockAvgFiring;
                if ((diff = diff / ((SimKnockTransCompAllTableModel.DetailsTrans)details).refAvgFiring * 100.0) < 0.0) {
                    ((SimKnockTransCompAllTableModel.DetailsTrans)details).diff = diff *= -1.0;
                    tVector.add(formatter2.format(diff));
                    tTableVector.add(details);
                    continue;
                }
                ((SimKnockTransCompAllTableModel.DetailsTrans)details).diff = diff *= -1.0;
                tVector.add(formatter2.format(diff));
                tTableVector.add(details);
            }
            for (int p = 0; p < placesNumber; ++p) {
                details = modelPlacesCompAll.newDetailsInstance();
                ((SimKnockPlacesCompAllTableModel.DetailsPlace)details).knockAvgTokens = dataSet.placeTokensAvg.get(p);
                ((SimKnockPlacesCompAllTableModel.DetailsPlace)details).refAvgTokens = refSet.placeTokensAvg.get(p);
                ((SimKnockPlacesCompAllTableModel.DetailsPlace)details).knockDisabled = dataSet.placeZeroTokens.get(p);
                ((SimKnockPlacesCompAllTableModel.DetailsPlace)details).significance1 = this.getPlaceSign1(refSet, dataSet, p);
                ((SimKnockPlacesCompAllTableModel.DetailsPlace)details).significance2 = this.getPlaceSign2(refSet, dataSet, p);
                if (refSet.placeTokensAvg.get(p) == 0.0 && dataSet.placeTokensAvg.get(p) == 0.0) {
                    pVector.add("999990.0");
                    pTableVector.add(details);
                    continue;
                }
                if (refSet.placeTokensAvg.get(p) == 0.0 && dataSet.placeTokensAvg.get(p) > 0.0) {
                    pVector.add("999999.0");
                    pTableVector.add(details);
                    continue;
                }
                if (refSet.placeTokensAvg.get(p) > 0.0 && dataSet.placeTokensAvg.get(p) == 0.0) {
                    pVector.add("-999999.0");
                    pTableVector.add(details);
                    continue;
                }
                diff = ((SimKnockPlacesCompAllTableModel.DetailsPlace)details).refAvgTokens - ((SimKnockPlacesCompAllTableModel.DetailsPlace)details).knockAvgTokens;
                if ((diff = diff / ((SimKnockPlacesCompAllTableModel.DetailsPlace)details).refAvgTokens * 100.0) < 0.0) {
                    ((SimKnockPlacesCompAllTableModel.DetailsPlace)details).diff = diff *= -1.0;
                    pVector.add(formatter2.format(diff));
                    pTableVector.add(details);
                    continue;
                }
                ((SimKnockPlacesCompAllTableModel.DetailsPlace)details).diff = diff *= -1.0;
                pVector.add(formatter2.format(diff));
                pTableVector.add(details);
            }
            modelTransCompAll.addNew(tVector);
            modelTransCompAll.tTableData.add(tTableVector);
            modelPlacesCompAll.addNew(pVector);
            modelPlacesCompAll.pTableData.add(pTableVector);
            if (!this.notepadInfo || notePadTrans == null) continue;
            for (String s : tVector) {
                notePadTrans.addTextLine(s + ";", "text");
            }
            for (String s : pVector) {
                notePadPlaces.addTextLine(s + ";", "text");
            }
            notePadTrans.addTextLineNL("", "text");
            notePadPlaces.addTextLineNL("", "text");
        }
    }

    private void createCompareAllTablesNotepad(int selected) {
        TreeMap<Double, CallSite> data;
        NetSimulationData dataSet;
        int t;
        long IDseries = this.pn.accessSimKnockoutData().accessSeries().get(selected);
        ArrayList<NetSimulationData> dataPackage = this.pn.accessSimKnockoutData().getSeriesDatasets(IDseries);
        int selRef = this.referencesCombo.getSelectedIndex() - 1;
        if (selRef == -1) {
            JOptionPane.showMessageDialog(null, "Please select reference set!", "Reference selection", 2);
            this.seriesCombo.setSelectedIndex(0);
            return;
        }
        NetSimulationData refSet = this.pn.accessSimKnockoutData().getReferenceSet(selRef);
        if (dataPackage == null) {
            return;
        }
        int transNumber = dataPackage.get((int)0).transNumber;
        int placesNumber = dataPackage.get((int)0).placesNumber;
        if (transNumber == 0 || placesNumber == 0) {
            return;
        }
        HolmesNotepad notePad = new HolmesNotepad(900, 600);
        notePad.setVisible(true);
        notePad.addTextLineNL("Data series " + selected + " analysis:", "text");
        notePad.addTextLineNL(" +/-20% treshold for increased/decreased firing of transitions ", "text");
        notePad.addTextLineNL("===============================================================================", "text");
        notePad.addTextLineNL("", "text");
        for (t = 0; t < transNumber; ++t) {
            int t1;
            dataSet = dataPackage.get(t);
            notePad.addTextLineNL("*** t" + t + "_" + this.transitions.get(t).getName() + "    disabled manually. Impact on the net:", "text");
            ArrayList<Integer> transVector = new ArrayList<Integer>();
            for (t1 = 0; t1 < transNumber; ++t1) {
                if (t == t1) {
                    transVector.add(0);
                    continue;
                }
                transVector.add(1);
            }
            for (t1 = 0; t1 < transNumber; ++t1) {
                double value;
                if ((Integer)transVector.get(t1) == 0) continue;
                if (refSet.transFiringsAvg.get(t1) == 0.0 && dataSet.transFiringsAvg.get(t1) == 0.0) {
                    notePad.addTextLineNL("      (DEAD IN REF & SERIES SETS!) t" + t1 + "_" + this.transitions.get(t1).getName(), "text");
                    transVector.set(t1, 0);
                    continue;
                }
                if (refSet.transFiringsAvg.get(t1) == 0.0 && dataSet.transFiringsAvg.get(t1) > 0.0) {
                    value = dataSet.transFiringsAvg.get(t1) * 100.0;
                    notePad.addTextLineNL("      (DEAD IN REF, ALIVE IN SERIES) [avg fire chance: " + formatter2.format(value) + "%]  t" + t1 + "_" + this.transitions.get(t1).getName(), "text");
                    transVector.set(t1, 0);
                    continue;
                }
                if (!(refSet.transFiringsAvg.get(t1) > 0.0) || dataSet.transFiringsAvg.get(t1) != 0.0) continue;
                value = refSet.transFiringsAvg.get(t1) * 100.0;
                notePad.addTextLineNL("      (KNOCKED OUT IN SERIES SET) [avg fired chance in reference: " + formatter2.format(value) + "%]  t" + t1 + "_" + this.transitions.get(t1).getName(), "text");
                transVector.set(t1, 0);
            }
            data = new TreeMap<Double, CallSite>();
            for (int t12 = 0; t12 < transNumber; ++t12) {
                double value;
                if ((Integer)transVector.get(t12) == 0) continue;
                double diff = refSet.transFiringsAvg.get(t12) - dataSet.transFiringsAvg.get(t12);
                diff /= refSet.transFiringsAvg.get(t12).doubleValue();
                String txt = "[firing chance refSet:" + formatter2.format(refSet.transFiringsAvg.get(t12) * 100.0) + "% dataSet: " + formatter2.format(dataSet.transFiringsAvg.get(t12) * 100.0) + "%] ";
                if (diff < 0.0) {
                    value = (diff *= -1.0) * 100.0;
                    data.put(value, (CallSite)((Object)(txt + "t" + t12 + "_" + this.transitions.get(t12).getName())));
                    transVector.set(t12, 0);
                    continue;
                }
                value = (diff *= -1.0) * 100.0;
                data.put(value, (CallSite)((Object)(txt + "t" + t12 + "_" + this.transitions.get(t12).getName())));
                transVector.set(t12, 0);
            }
            for (Double key : data.keySet()) {
                if (key < -20.0) {
                    notePad.addTextLineNL("      (DECREASED) [change: " + formatter1.format(key) + "%] " + (String)data.get(key), "text");
                }
                if (!(key > 20.0)) continue;
                notePad.addTextLineNL("      (INCREASED) [change: +" + formatter1.format(key) + "%] " + (String)data.get(key), "text");
            }
        }
        notePad.addTextLineNL("", "text");
        notePad.addTextLineNL("", "text");
        notePad.addTextLineNL("", "text");
        notePad.addTextLineNL("===============================================================================", "text");
        notePad.addTextLineNL(" +/-20% treshold for increased/decreased tokens in places ", "text");
        notePad.addTextLineNL("===============================================================================", "text");
        notePad.addTextLineNL("", "text");
        for (t = 0; t < transNumber; ++t) {
            int p;
            dataSet = dataPackage.get(t);
            notePad.addTextLineNL("*** t" + t + "_" + this.transitions.get(t).getName() + "    disabled manually. Impact on the net:", "text");
            ArrayList<Integer> placesVector = new ArrayList<Integer>();
            for (p = 0; p < placesNumber; ++p) {
                placesVector.add(1);
            }
            for (p = 0; p < placesNumber; ++p) {
                double value;
                if (refSet.placeTokensAvg.get(p) == 0.0 && dataSet.placeTokensAvg.get(p) == 0.0) {
                    notePad.addTextLineNL("      (DEAD IN REF & SERIES SETS!) p" + p + "_" + this.places.get(p).getName(), "text");
                    placesVector.set(p, 0);
                    continue;
                }
                if (refSet.placeTokensAvg.get(p) == 0.0 && dataSet.placeTokensAvg.get(p) > 0.0) {
                    value = dataSet.placeTokensAvg.get(p);
                    notePad.addTextLineNL("      (DEAD IN REF, ALIVE IN SERIES) [avg tokens: " + formatter3.format(value) + "]  p" + p + "_" + this.places.get(p).getName(), "text");
                    placesVector.set(p, 0);
                    continue;
                }
                if (!(refSet.placeTokensAvg.get(p) > 0.0) || dataSet.placeTokensAvg.get(p) != 0.0) continue;
                value = refSet.placeTokensAvg.get(p);
                notePad.addTextLineNL("      (KNOCKED OUT IN SERIES SET) [avg tokens reference: " + formatter3.format(value) + "]  p" + p + "_" + this.places.get(p).getName(), "text");
                placesVector.set(p, 0);
            }
            data = new TreeMap();
            for (int p2 = 0; p2 < placesNumber; ++p2) {
                double value;
                if ((Integer)placesVector.get(p2) == 0) continue;
                double diff = refSet.placeTokensAvg.get(p2) - dataSet.placeTokensAvg.get(p2);
                if ((diff /= refSet.placeTokensAvg.get(p2).doubleValue()) < 0.0) {
                    value = (diff *= -1.0) * 100.0;
                    data.put(value, (CallSite)((Object)("p" + p2 + "_" + this.places.get(p2).getName())));
                    placesVector.set(p2, 0);
                    continue;
                }
                value = (diff *= -1.0) * 100.0;
                data.put(value, (CallSite)((Object)("p" + p2 + "_" + this.places.get(p2).getName())));
                placesVector.set(p2, 0);
            }
            for (Double key : data.keySet()) {
                if (key < -20.0) {
                    notePad.addTextLineNL("      (DECREASED) [tokens change: " + formatter2.format(key) + "%] " + (String)data.get(key), "text");
                }
                if (!(key > 20.0)) continue;
                notePad.addTextLineNL("      (INCREASED) [tokens change: +" + formatter2.format(key) + "%] " + (String)data.get(key), "text");
            }
        }
    }

    private boolean getTransSign1(NetSimulationData refSet, NetSimulationData dataSet, int index) {
        if (refSet.transFiringsAvg.get(index) > dataSet.transFiringsAvg.get(index)) {
            return refSet.transFiringsMin.get(index) > dataSet.transFiringsMax.get(index);
        }
        return refSet.transFiringsMax.get(index) < dataSet.transFiringsMin.get(index);
    }

    private boolean getTransSign2(NetSimulationData refSet, NetSimulationData dataSet, int index) {
        if (refSet.transFiringsAvg.get(index) > dataSet.transFiringsAvg.get(index)) {
            return refSet.transFiringsAvg.get(index) - refSet.transStdDev.get(index) > dataSet.transFiringsAvg.get(index) + dataSet.transStdDev.get(index);
        }
        return refSet.transFiringsAvg.get(index) + refSet.transStdDev.get(index) < dataSet.transFiringsAvg.get(index) - dataSet.transStdDev.get(index);
    }

    private boolean getPlaceSign1(NetSimulationData refSet, NetSimulationData dataSet, int index) {
        if (refSet.placeTokensAvg.get(index) > dataSet.placeTokensAvg.get(index)) {
            return refSet.placeTokensMin.get(index) > dataSet.placeTokensMax.get(index);
        }
        return refSet.placeTokensMax.get(index) < dataSet.placeTokensMin.get(index);
    }

    private boolean getPlaceSign2(NetSimulationData refSet, NetSimulationData dataSet, int index) {
        if (refSet.placeTokensAvg.get(index) > dataSet.placeTokensAvg.get(index)) {
            return refSet.placeTokensAvg.get(index) - refSet.placeStdDev.get(index) > dataSet.placeTokensAvg.get(index) + dataSet.placeStdDev.get(index);
        }
        return refSet.placeTokensAvg.get(index) + refSet.placeStdDev.get(index) < dataSet.placeTokensAvg.get(index) - dataSet.placeStdDev.get(index);
    }

    public void resizeColumnWidth(JTable table) {
        TableColumnModel columnModel = table.getColumnModel();
        for (int column = 3; column < table.getColumnCount(); ++column) {
            columnModel.getColumn(column).setPreferredWidth(65);
            columnModel.getColumn(column).setMinWidth(65);
            columnModel.getColumn(column).setMaxWidth(65);
        }
    }

    private void initiateListeners() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                HolmesSimKnockVis.this.fillComponents();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                HolmesSimKnockVis.this.boss.setEnabled(true);
                GUIManager.getDefaultGUIManager().getFrame().setEnabled(true);
            }
        });
    }

    private void fillComponents() {
        PetriNet pn = this.overlord.getWorkspace().getProject();
        ArrayList<NetSimulationData> references = pn.accessSimKnockoutData().accessReferenceSets();
        int refSize = references.size();
        this.doNotUpdate = true;
        int oldSelected = this.referencesCombo.getSelectedIndex();
        this.referencesCombo.removeAllItems();
        this.referencesCombo.addItem(" ----- ");
        if (refSize > 0) {
            for (int r = 0; r < refSize; ++r) {
                StringBuilder disTxt = new StringBuilder("Disabled: ");
                for (int t : references.get((int)r).disabledTransitionsIDs) {
                    disTxt.append("t").append(t).append(", ");
                }
                for (int t : references.get((int)r).disabledMCTids) {
                    disTxt.append("MCT").append(t + 1).append(", ");
                }
                disTxt = new StringBuilder(disTxt.toString().replace(", ", " "));
                String name = "Data set:" + r + ":    " + disTxt + "     NetMode:" + references.get((int)r).netSimType + "   MaxMode:" + references.get((int)r).maxMode;
                this.referencesCombo.addItem(name);
            }
            if (oldSelected < this.referencesCombo.getItemCount()) {
                this.referencesCombo.setSelectedIndex(oldSelected);
            } else {
                this.referencesCombo.setSelectedIndex(0);
            }
        }
        ArrayList<Transition> transitions = pn.getTransitions();
        ArrayList<NetSimulationData> knockout = pn.accessSimKnockoutData().accessKnockoutDataSets();
        int knockSize = knockout.size();
        int oldKnockSelected = this.dataCombo.getSelectedIndex();
        this.dataCombo.removeAllItems();
        this.dataCombo.addItem(" ----- ");
        if (knockSize > 0) {
            for (int r = 0; r < knockSize; ++r) {
                StringBuilder disTxt = new StringBuilder("Disabled: ");
                for (int t : knockout.get((int)r).disabledTransitionsIDs) {
                    disTxt.append("t").append(t).append(", ");
                }
                for (int t : knockout.get((int)r).disabledMCTids) {
                    disTxt.append("MCT").append(t + 1).append(", ");
                }
                disTxt = new StringBuilder(disTxt.toString().replace(", ", " "));
                Object transName = "(multiple transitions";
                if (knockout.get((int)r).disabledTransitionsIDs.size() == 1) {
                    transName = "(" + transitions.get(knockout.get((int)r).disabledTransitionsIDs.get(0)).getName();
                }
                transName = (String)transName + ")";
                String name = "Data set:" + r + ":    " + disTxt + "     NetMode:" + knockout.get((int)r).netSimType + "   MaxMode:" + knockout.get((int)r).maxMode + "  " + (String)transName;
                this.dataCombo.addItem(name);
            }
            if (oldKnockSelected < this.dataCombo.getItemCount()) {
                this.dataCombo.setSelectedIndex(oldKnockSelected);
            } else {
                this.dataCombo.setSelectedIndex(0);
            }
        }
        ArrayList<Long> series = pn.accessSimKnockoutData().accessSeries();
        int seriesSize = series.size();
        int oldSeriesSelected = this.seriesCombo.getSelectedIndex();
        this.seriesCombo.removeAllItems();
        this.seriesCombo.addItem(" ----- ");
        if (seriesSize > 0) {
            for (int s = 0; s < seriesSize; ++s) {
                long IDseries = series.get(s);
                NetSimulationData representant = pn.accessSimKnockoutData().returnSeriesFirst(IDseries);
                String disTxt = "Package: " + s + " Steps: " + representant.steps + " Reps: " + representant.reps;
                this.seriesCombo.addItem(disTxt);
            }
            if (oldSeriesSelected < this.seriesCombo.getItemCount()) {
                this.seriesCombo.setSelectedIndex(oldSeriesSelected);
            } else {
                this.seriesCombo.setSelectedIndex(0);
            }
        }
        this.doNotUpdate = false;
    }

    protected void cellClickAction(JTable table) {
        try {
            String name = table.getName();
            if (name.contains("Places")) {
                int row = table.getSelectedRow();
                int index = Integer.parseInt(table.getValueAt(row, 0).toString());
                HolmesNodeInfo window = new HolmesNodeInfo(GUIManager.getDefaultGUIManager().getWorkspace().getProject().getPlaces().get(index), (JFrame)this);
                window.setVisible(true);
            } else if (name.contains("Transitions")) {
                int row = table.getSelectedRow();
                int index = Integer.parseInt(table.getValueAt(row, 0).toString());
                HolmesNodeInfo window = new HolmesNodeInfo(GUIManager.getDefaultGUIManager().getWorkspace().getProject().getTransitions().get(index), (JFrame)this);
                window.setVisible(true);
            }
        }
        catch (Exception ex) {
            GUIManager.getDefaultGUIManager().log("Error (905683345) | Exception:  " + ex.getMessage(), "error", true);
        }
    }

    public static class CustomToolTipGenerator
    implements CategoryToolTipGenerator {
        boolean isPlaces;
        boolean compareMode;
        ArrayList<Place> places;
        ArrayList<Transition> transitions;
        NetSimulationData refData;
        NetSimulationData knockData;
        DecimalFormat formatter;
        boolean simpleMode = false;

        public CustomToolTipGenerator(boolean isPlaces, boolean compareMode, Object ... blackBox) {
            this.isPlaces = isPlaces;
            this.compareMode = compareMode;
            this.places = (ArrayList)blackBox[0];
            this.transitions = (ArrayList)blackBox[1];
            this.refData = (NetSimulationData)blackBox[2];
            this.knockData = (NetSimulationData)blackBox[3];
            this.formatter = new DecimalFormat("#.###");
            if (this.places.size() != this.refData.placesNumber || this.transitions.size() != this.refData.transNumber) {
                this.simpleMode = true;
            }
        }

        @Override
        public String generateToolTip(CategoryDataset dataset, int bar, int nodeIndex) {
            StringBuilder text = new StringBuilder("<html><font size=\"5\">");
            text.append("Simulate steps: <b>").append(this.refData.steps).append("</b> Repetitions: <b>").append(this.refData.reps).append("</b><br>");
            if (this.compareMode) {
                if (this.isPlaces) {
                    if (this.simpleMode) {
                        text.append("Place: p").append(nodeIndex);
                    } else {
                        text.append("Place: p").append(nodeIndex).append("_").append(this.places.get(nodeIndex).getName());
                    }
                    double tokensRef = this.refData.placeTokensAvg.get(nodeIndex);
                    text.append("<br>Reference tokens: <b>").append(this.formatter.format(tokensRef));
                    text.append("</b> StdDev: <b>").append(this.formatter.format(this.refData.placeStdDev.get(nodeIndex))).append("</b>");
                    double tokensKnock = this.knockData.placeTokensAvg.get(nodeIndex);
                    text.append("<br>Knockout tokens: <b>").append(this.formatter.format(tokensKnock));
                    text.append("</b> StdDev: <b>").append(this.formatter.format(this.knockData.placeStdDev.get(nodeIndex))).append("</b>");
                } else {
                    if (this.simpleMode) {
                        text.append("Transition: t").append(nodeIndex);
                    } else {
                        text.append("Transition: t").append(nodeIndex).append("_").append(this.transitions.get(nodeIndex).getName());
                    }
                    double firingRef = this.refData.transFiringsAvg.get(nodeIndex);
                    text.append("<br>Reference firing: <b>").append(this.formatter.format(firingRef));
                    text.append("</b> StdDev: <b>").append(this.formatter.format(this.refData.transStdDev.get(nodeIndex))).append("</b>");
                    double firingKnock = this.knockData.transFiringsAvg.get(nodeIndex);
                    text.append("<br>Knockout firing: <b>").append(this.formatter.format(firingKnock));
                    text.append("</b> StdDev: <b>").append(this.formatter.format(this.knockData.transStdDev.get(nodeIndex))).append("</b>");
                    if (bar != 0) {
                        if (this.knockData.disabledTotals.contains(nodeIndex)) {
                            text.append("<br><font color=\"green\">Transition disabled manually in simulation</font> ");
                        } else if (firingKnock == 0.0) {
                            text.append("<br><font color=\"red\">Transition starved because of other disabled transition(s)</font><br><b>");
                            for (int t : this.knockData.disabledTotals) {
                                text.append("t").append(t).append(" ");
                            }
                            text.append("</b>");
                        }
                    }
                }
            } else if (this.isPlaces) {
                if (this.simpleMode) {
                    text.append("Place: p").append(nodeIndex);
                } else {
                    text.append("Place: p").append(nodeIndex).append("_").append(this.places.get(nodeIndex).getName());
                }
                double tokensRef = this.refData.placeTokensAvg.get(nodeIndex);
                text.append("<br>Tokens: <b>").append(this.formatter.format(tokensRef));
                text.append("</b> StdDev: <b>").append(this.formatter.format(this.refData.placeStdDev.get(nodeIndex))).append("</b>");
            } else {
                if (this.simpleMode) {
                    text.append("Transition: t").append(nodeIndex);
                } else {
                    text.append("Transition: t").append(nodeIndex).append("_").append(this.transitions.get(nodeIndex).getName());
                }
                double firingRef = this.refData.transFiringsAvg.get(nodeIndex);
                text.append("<br>Reference firing: <b>").append(this.formatter.format(firingRef));
                text.append("</b> StdDev: <b>").append(this.formatter.format(this.refData.transStdDev.get(nodeIndex))).append("</b>");
                if (bar != 0) {
                    if (this.refData.disabledTotals.contains(nodeIndex)) {
                        text.append("<br><font color=\"green\">Transition disabled manually in simulation</font> ");
                    } else if (firingRef == 0.0) {
                        text.append("<br><font color=\"red\">Transition starved because of other disabled transition(s):</font><br><b>");
                        for (int t : this.refData.disabledTotals) {
                            text.append("t").append(t).append(" ");
                        }
                        text.append("</b>");
                    }
                }
            }
            text.append("</font></html>");
            return text.toString();
        }
    }
}

