/*
 * Decompiled with CFR 0.152.
 */
package holmes.windows.ssim;

import holmes.darkgui.GUIManager;
import holmes.petrinet.data.NetSimulationData;
import holmes.petrinet.data.PetriNet;
import holmes.petrinet.elements.Place;
import holmes.petrinet.elements.Transition;
import holmes.petrinet.simulators.GraphicalSimulator;
import holmes.utilities.Tools;
import holmes.windows.HolmesNotepad;
import holmes.windows.ssim.HolmesSimKnock;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;

public class HolmesSimKnockActions {
    HolmesSimKnock boss;
    private int pingPongSimTransLimit;
    private int pingPongSimCurrentTrans;
    private long pingPongSimSeries;
    private GUIManager overlord;
    private PetriNet pn;

    public HolmesSimKnockActions(HolmesSimKnock window) {
        this.boss = window;
        this.overlord = GUIManager.getDefaultGUIManager();
        this.pn = this.overlord.getWorkspace().getProject();
    }

    public void acquireDataForRefSet() {
        if (this.overlord.getSimulatorBox().getCurrentDockWindow().getSimulator().getSimulatorStatus() != GraphicalSimulator.SimulatorMode.STOPPED) {
            JOptionPane.showMessageDialog(null, "Main simulator active. Please turn if off before starting state simulator process", "Main simulator active", 0);
            return;
        }
        ArrayList<Transition> transitions = this.pn.getTransitions();
        if (transitions == null || transitions.size() == 0) {
            JOptionPane.showMessageDialog(null, "At least single place and transition required for simulation.", "Net not found", 2);
            return;
        }
        boolean success = this.boss.ssimKnock.initiateSim(true, null);
        if (!success) {
            GUIManager.getDefaultGUIManager().log("State simulator initialization failed.", "error", true);
            return;
        }
        this.boss.setSimWindowComponentsStatus(false);
        this.boss.mainSimWindow.setWorkInProgress(true);
        NetSimulationData currentDataPackage = new NetSimulationData();
        for (Transition trans : transitions) {
            trans.setKnockout(false);
        }
        this.boss.ssimKnock.setThreadDetails(2, this.boss.mainSimWindow, this.boss.refProgressBarKnockout, currentDataPackage);
        Thread myThread = new Thread(this.boss.ssimKnock);
        this.boss.refSimInProgress = true;
        myThread.start();
    }

    public void completeRefSimulationResults(NetSimulationData netSimData, ArrayList<Transition> transitions, ArrayList<Place> places) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        Date date = new Date();
        netSimData.date = dateFormat.format(date);
        netSimData.refSet = true;
        this.pn.accessSimKnockoutData().addNewReferenceSet(netSimData);
        if (this.boss.refShowNotepad) {
            double valMax;
            double valMin;
            double valAvg;
            String t_name;
            int t;
            HolmesNotepad notePad = new HolmesNotepad(900, 600);
            notePad.setVisible(true);
            notePad.addTextLineNL("", "text");
            notePad.addTextLineNL("Transitions: ", "text");
            notePad.addTextLineNL("", "text");
            for (t = 0; t < netSimData.transFiringsAvg.size(); ++t) {
                t_name = transitions.get(t).getName();
                valAvg = netSimData.transFiringsAvg.get(t);
                valMin = netSimData.transFiringsMin.get(t);
                valMax = netSimData.transFiringsMax.get(t);
                notePad.addTextLineNL("  t" + t + "_" + t_name + " : " + Tools.cutValueExt(valAvg, 4) + " min: " + Tools.cutValueExt(valMin, 4) + " max: " + Tools.cutValueExt(valMax, 4), "text");
            }
            notePad.addTextLineNL("", "text");
            notePad.addTextLineNL("Places: ", "text");
            notePad.addTextLineNL("", "text");
            for (t = 0; t < netSimData.placeTokensAvg.size(); ++t) {
                t_name = places.get(t).getName();
                valAvg = netSimData.placeTokensAvg.get(t);
                valMin = netSimData.placeTokensMin.get(t);
                valMax = netSimData.placeTokensMax.get(t);
                notePad.addTextLineNL("  p" + t + "_" + t_name + " : " + Tools.cutValueExt(valAvg, 4) + " min: " + Tools.cutValueExt(valMin, 4) + " max: " + Tools.cutValueExt(valMax, 4), "text");
            }
        }
        this.boss.refSimInProgress = false;
        this.boss.mainSimWindow.setWorkInProgress(false);
        this.boss.setSimWindowComponentsStatus(true);
        this.boss.updateFreshKnockoutTab();
    }

    public void acquireDataForKnockoutSet(JTextArea dataSelectedTransTextArea, boolean manualSelection) {
        if (this.overlord.getSimulatorBox().getCurrentDockWindow().getSimulator().getSimulatorStatus() != GraphicalSimulator.SimulatorMode.STOPPED) {
            JOptionPane.showMessageDialog(null, "Main simulator active. Please turn if off before starting state simulator process", "Main simulator active", 0);
            return;
        }
        ArrayList<Transition> transitions = this.pn.getTransitions();
        if (transitions == null || transitions.size() == 0) {
            JOptionPane.showMessageDialog(null, "At least single place and transition required for simulation.", "Net not found", 2);
            return;
        }
        boolean success = this.boss.ssimKnock.initiateSim(true, null);
        if (!success) {
            GUIManager.getDefaultGUIManager().log("State simulator initialization failed.", "error", true);
            return;
        }
        this.boss.setSimWindowComponentsStatus(false);
        this.boss.mainSimWindow.setWorkInProgress(true);
        NetSimulationData currentDataPackage = new NetSimulationData();
        this.updateNetOfflineStatus(dataSelectedTransTextArea, transitions, manualSelection, currentDataPackage);
        this.boss.ssimKnock.setThreadDetails(3, this.boss.mainSimWindow, this.boss.dataProgressBarKnockout, currentDataPackage);
        Thread myThread = new Thread(this.boss.ssimKnock);
        this.boss.dataSimInProgress = true;
        myThread.start();
    }

    public void completeKnockoutSimulationResults(NetSimulationData netSimData, ArrayList<Transition> transitions, ArrayList<Place> places) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        Date date = new Date();
        netSimData.date = dateFormat.format(date);
        netSimData.refSet = false;
        this.pn.accessSimKnockoutData().addNewDataSet(netSimData);
        if (this.boss.dataShowNotepad) {
            double valMax;
            double valMin;
            double valAvg;
            String t_name;
            int t;
            HolmesNotepad notePad = new HolmesNotepad(900, 600);
            notePad.setVisible(true);
            notePad.addTextLineNL("", "text");
            notePad.addTextLineNL("Transitions: ", "text");
            notePad.addTextLineNL("", "text");
            for (t = 0; t < netSimData.transFiringsAvg.size(); ++t) {
                t_name = transitions.get(t).getName();
                valAvg = netSimData.transFiringsAvg.get(t);
                valMin = netSimData.transFiringsMin.get(t);
                valMax = netSimData.transFiringsMax.get(t);
                notePad.addTextLineNL("  t" + t + "_" + t_name + " : " + Tools.cutValueExt(valAvg, 4) + " min: " + Tools.cutValueExt(valMin, 4) + " max: " + Tools.cutValueExt(valMax, 4), "text");
            }
            notePad.addTextLineNL("", "text");
            notePad.addTextLineNL("Places: ", "text");
            notePad.addTextLineNL("", "text");
            for (t = 0; t < netSimData.placeTokensAvg.size(); ++t) {
                t_name = places.get(t).getName();
                valAvg = netSimData.placeTokensAvg.get(t);
                valMin = netSimData.placeTokensMin.get(t);
                valMax = netSimData.placeTokensMax.get(t);
                notePad.addTextLineNL("  p" + t + "_" + t_name + " : " + Tools.cutValueExt(valAvg, 4) + " min: " + Tools.cutValueExt(valMin, 4) + " max: " + Tools.cutValueExt(valMax, 4), "text");
            }
        }
        this.boss.dataSimInProgress = false;
        this.boss.mainSimWindow.setWorkInProgress(false);
        this.boss.setSimWindowComponentsStatus(true);
        this.boss.updateFreshKnockoutTab();
    }

    public void acquireAll() {
        if (this.overlord.getSimulatorBox().getCurrentDockWindow().getSimulator().getSimulatorStatus() != GraphicalSimulator.SimulatorMode.STOPPED) {
            JOptionPane.showMessageDialog(null, "Main simulator active. Please turn if off before starting state simulator process", "Main simulator active", 0);
            return;
        }
        ArrayList<Transition> transitions = this.pn.getTransitions();
        if (transitions == null || transitions.size() == 0) {
            JOptionPane.showMessageDialog(null, "At least single place and transition required for simulation.", "Net not found", 2);
            return;
        }
        boolean success = this.boss.ssimKnock.initiateSim(true, null);
        if (!success) {
            GUIManager.getDefaultGUIManager().log("State simulator initialization failed.", "error", true);
            return;
        }
        this.boss.setSimWindowComponentsStatus(false);
        this.boss.mainSimWindow.setWorkInProgress(true);
        for (Transition trans : transitions) {
            trans.setKnockout(false);
        }
        this.pingPongSimTransLimit = transitions.size();
        this.pingPongSimCurrentTrans = -1;
        this.pingPongSimSeries = this.overlord.randGen.nextLong();
        this.pn.accessSimKnockoutData().addNewSeries(this.pingPongSimSeries);
        this.pingPongSimulation(null, null, null, false);
    }

    public void pingPongSimulation(NetSimulationData returningData, ArrayList<Transition> transitions, ArrayList<Place> places, boolean forceTerminate) {
        if (returningData == null) {
            ++this.pingPongSimCurrentTrans;
            this.boss.dataProgressBarKnockout.setBorder(BorderFactory.createTitledBorder("Progress: " + (this.pingPongSimCurrentTrans + 1) + "/" + this.pingPongSimTransLimit));
            this.pn.getTransitions().get(this.pingPongSimCurrentTrans).setKnockout(true);
            NetSimulationData currentDataPackage = new NetSimulationData();
            this.boss.ssimKnock.setThreadDetails(4, this.boss.mainSimWindow, this.boss.dataProgressBarKnockout, currentDataPackage);
            Thread myThread = new Thread(this.boss.ssimKnock);
            this.boss.dataSimInProgress = true;
            myThread.start();
        } else {
            transitions.get(this.pingPongSimCurrentTrans).setKnockout(false);
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
            Date date = new Date();
            returningData.date = dateFormat.format(date);
            returningData.refSet = false;
            returningData.disabledTransitionsIDs.add(this.pingPongSimCurrentTrans);
            returningData.disabledTotals.add(this.pingPongSimCurrentTrans);
            returningData.setIDseries(this.pingPongSimSeries);
            if (forceTerminate) {
                this.pn.accessSimKnockoutData().removeSeries(this.pingPongSimSeries);
            } else {
                this.pn.accessSimKnockoutData().addNewDataSet(returningData);
            }
            ++this.pingPongSimCurrentTrans;
            if (this.pingPongSimCurrentTrans == this.pingPongSimTransLimit || forceTerminate) {
                this.boss.mainSimWindow.setWorkInProgress(false);
                this.boss.setSimWindowComponentsStatus(true);
                this.boss.dataSimInProgress = false;
                this.boss.updateFreshKnockoutTab();
                return;
            }
            transitions.get(this.pingPongSimCurrentTrans).setKnockout(true);
            this.boss.dataProgressBarKnockout.setBorder(BorderFactory.createTitledBorder("Progress: " + (this.pingPongSimCurrentTrans + 1) + "/" + this.pingPongSimTransLimit));
            NetSimulationData currentDataPackage = new NetSimulationData();
            this.boss.ssimKnock.setThreadDetails(4, this.boss.mainSimWindow, this.boss.dataProgressBarKnockout, currentDataPackage);
            Thread myThread = new Thread(this.boss.ssimKnock);
            myThread.start();
        }
    }

    public void saveDataSets() {
        boolean status = this.pn.accessSimKnockoutData().saveDataSets();
        if (status) {
            // empty if block
        }
    }

    public void loadDataSets() {
        boolean status = this.pn.accessSimKnockoutData().loadDataSets();
        if (status) {
            this.boss.resetWindow();
            this.boss.updateFreshKnockoutTab();
        }
    }

    private void updateNetOfflineStatus(JTextArea dataSelectedTransTextArea, ArrayList<Transition> transitions, boolean manualSelection, NetSimulationData currentDataPackage) {
        if (manualSelection) {
            for (int t = 0; t < transitions.size(); ++t) {
                Transition trans = transitions.get(t);
                if (!trans.isKnockedOut()) continue;
                currentDataPackage.disabledTransitionsIDs.add(t);
                currentDataPackage.disabledTotals.add(t);
            }
        } else {
            String value;
            int hashIndex;
            int semiIndex;
            String tmp;
            int index;
            ArrayList<ArrayList<Transition>> mcts = this.pn.getMCTMatrix();
            ArrayList<Transition> disableList = new ArrayList<Transition>();
            String dataTxt = dataSelectedTransTextArea.getText();
            while (dataTxt.contains("tr#")) {
                index = dataTxt.indexOf("tr#");
                tmp = dataTxt.substring(index);
                semiIndex = tmp.indexOf(";");
                hashIndex = tmp.indexOf("#");
                value = tmp.substring(hashIndex + 1, semiIndex);
                int transIndex = Integer.parseInt(value);
                if (!disableList.contains(transitions.get(transIndex))) {
                    disableList.add(transitions.get(transIndex));
                    currentDataPackage.disabledTransitionsIDs.add(transIndex);
                    if (!currentDataPackage.disabledTotals.contains(transIndex)) {
                        currentDataPackage.disabledTotals.add(transIndex);
                    }
                }
                tmp = tmp.substring(0, semiIndex + 1);
                dataTxt = dataTxt.replace(tmp, "");
            }
            while (dataTxt.contains("MCT#")) {
                index = dataTxt.indexOf("MCT#");
                tmp = dataTxt.substring(index);
                semiIndex = tmp.indexOf(";");
                hashIndex = tmp.indexOf("#");
                value = tmp.substring(hashIndex + 1, semiIndex);
                int mctIndex = Integer.parseInt(value);
                ArrayList<Transition> mct = mcts.get(mctIndex - 1);
                currentDataPackage.disabledMCTids.add(mctIndex - 1);
                for (Transition trans : mct) {
                    if (!disableList.contains(trans)) {
                        disableList.add(trans);
                    }
                    if (currentDataPackage.disabledTotals.contains(transitions.indexOf(trans))) continue;
                    currentDataPackage.disabledTotals.add(transitions.indexOf(trans));
                }
                tmp = tmp.substring(0, semiIndex + 1);
                dataTxt = dataTxt.replace(tmp, "");
            }
            for (Transition trans : transitions) {
                trans.setKnockout(disableList.contains(trans));
            }
        }
    }

    public void addOfflineElement(int i, int selected, JTextArea dataSelectedTransTextArea) {
        if (i == 1) {
            String trans;
            Object txt = dataSelectedTransTextArea.getText();
            if (!((String)txt).contains(trans = "tr#" + selected + ";")) {
                txt = (String)txt + trans;
            }
            dataSelectedTransTextArea.setText((String)txt);
        } else if (i == 2) {
            String MCT;
            Object txt = dataSelectedTransTextArea.getText();
            if (!((String)txt).contains(MCT = "MCT#" + selected + ";")) {
                txt = (String)txt + MCT;
            }
            dataSelectedTransTextArea.setText((String)txt);
        }
    }

    public void removeOfflineElement(int i, int selected, JTextArea dataSelectedTransTextArea) {
        if (i == 1) {
            String trans;
            String txt = dataSelectedTransTextArea.getText();
            if (txt.contains(trans = "tr#" + selected + ";")) {
                txt = txt.replace(trans, "");
            }
            dataSelectedTransTextArea.setText(txt);
        } else if (i == 2) {
            String MCT;
            String txt = dataSelectedTransTextArea.getText();
            if (txt.contains(MCT = "MCT#" + selected + ";")) {
                txt = txt.replace(MCT, "");
            }
            dataSelectedTransTextArea.setText(txt);
        }
    }

    public boolean removeRedDataSet(int i) {
        ArrayList<NetSimulationData> references = this.pn.accessSimKnockoutData().accessReferenceSets();
        if (references.size() == 1) {
            Object[] options = new Object[]{"Remove ref. set", "Keep it"};
            int n = JOptionPane.showOptionDialog(null, "This is the only available reference set. Without it,\ncomparing knockout data will be impossible.", "Remove last reference set?", 0, 2, null, options, options[1]);
            if (n == 0) {
                references.remove(i);
                return true;
            }
        } else {
            Object[] options = new Object[]{"Remove ref. set", "Keep it"};
            int n = JOptionPane.showOptionDialog(null, "Remove this reference set?", "Please confirm", 0, 3, null, options, options[1]);
            if (n == 0) {
                references.remove(i);
                return true;
            }
        }
        return false;
    }

    public boolean removeKnockDataSet(int i) {
        ArrayList<NetSimulationData> knockouts = this.pn.accessSimKnockoutData().accessKnockoutDataSets();
        if (knockouts.get(i).getIDseries() != -1L) {
            Object[] options = new Object[]{"Remove ALL data series", "Keep them"};
            int n = JOptionPane.showOptionDialog(null, "WARNING! This dataset belongs to data series (e.g. single transition knockout\nsimulation for the whole net.\nTHIS WILL REMOVE ALL THE DATASETS, NOT ONLY THE SELECTED ONE. Proceed?", "Datasets series remove", 0, 0, null, options, options[1]);
            if (n == 0) {
                this.pn.accessSimKnockoutData().removeSeries(knockouts.get(i).getIDseries());
                return true;
            }
        } else {
            Object[] options = new Object[]{"Remove selected set", "Keep it"};
            int n = JOptionPane.showOptionDialog(null, "Remove this knockout dataset?", "Please confirm", 0, 3, null, options, options[1]);
            if (n == 0) {
                knockouts.remove(i);
                return true;
            }
        }
        return false;
    }
}

