/*
 * Decompiled with CFR 0.152.
 */
package holmes.windows.ssim;

import holmes.darkgui.GUIManager;
import holmes.petrinet.elements.Place;
import holmes.petrinet.elements.Transition;
import holmes.petrinet.simulators.GraphicalSimulator;
import holmes.petrinet.simulators.StateSimulator;
import holmes.utilities.Tools;
import holmes.windows.HolmesNotepad;
import holmes.windows.managers.HolmesStatesManager;
import holmes.windows.ssim.HolmesSimActions;
import holmes.windows.ssim.HolmesSimKnock;
import holmes.windows.ssim.HolmesSimSetup;
import holmes.workspace.ExtensionFileFilter;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.StackedBarRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class HolmesSim
extends JFrame {
    private static final long serialVersionUID = 5287992734385359453L;
    private JFrame ego;
    private GUIManager overlord;
    private HolmesSimActions action = new HolmesSimActions();
    private StateSimulator ssim;
    public boolean doNotUpdate = false;
    private JProgressBar progressBar;
    private int transInterval = 100;
    private int placesInterval = 100;
    private boolean sortedP = false;
    private boolean sortedT = false;
    private ArrayList<ArrayList<Integer>> placesRawData;
    private ArrayList<ArrayList<Integer>> transitionsRawData;
    private ArrayList<Integer> transitionsCompactData;
    private ArrayList<Double> transAvgData;
    private ArrayList<Double> placesAvgData;
    private ArrayList<Long> placesTotalData;
    private ArrayList<Integer> placesInChart;
    private ArrayList<String> placesInChartStr;
    private XYSeriesCollection placesSeriesDataSet = null;
    private XYSeriesCollection transitionsSeriesDataSet = null;
    private JFreeChart placesChart;
    private JFreeChart transitionsChart;
    private int transChartType = 0;
    private int placesChartType = 0;
    private JPanel placesJPanel;
    private JPanel transitionsJPanel;
    private JSpinner transIntervalSpinner;
    private JSpinner placesIntervalSpinner;
    private JComboBox<String> placesCombo = null;
    private JComboBox<String> transitionsCombo = null;
    private ChartProperties chartDetails;
    private JLabel selStateLabel;
    private JButton stateManagerButton;
    private JButton acqDataButton;
    private JPanel knockoutTab;
    private boolean workInProgress;
    public JTabbedPane mainTabPanel;

    public HolmesSim(GUIManager overlord) {
        this.overlord = overlord;
        this.ego = this;
        this.ssim = new StateSimulator();
        this.chartDetails = new ChartProperties();
        this.placesRawData = new ArrayList();
        this.transitionsRawData = new ArrayList();
        this.transitionsCompactData = new ArrayList();
        this.placesInChart = new ArrayList();
        this.placesInChartStr = new ArrayList();
        this.transAvgData = new ArrayList();
        this.placesAvgData = new ArrayList();
        this.placesTotalData = new ArrayList();
        this.initializeComponents();
        this.initiateListeners();
    }

    public HolmesSim returnFrame() {
        return this;
    }

    private void initializeComponents() {
        this.setVisible(false);
        this.setTitle("State Simulator");
        this.setLocation(30, 30);
        try {
            this.setIconImage(Tools.getImageFromIcon("/icons/holmesicon.png"));
        }
        catch (Exception ex) {
            GUIManager.getDefaultGUIManager().log("Error (418594315) | Exception:  " + ex.getMessage(), "error", true);
        }
        this.setSize(new Dimension(1000, 750));
        JPanel main = new JPanel(new BorderLayout());
        this.add(main);
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab("Places dynamics", Tools.getResIcon16("/icons/stateSim/placesDyn.png"), this.createPlacesTabPanel(), "Places dynamics");
        tabbedPane.setMnemonicAt(0, 49);
        tabbedPane.addTab("Transitions dynamics", Tools.getResIcon16("/icons/stateSim/transDyn.png"), this.createTransitionsTabPanel(), "Transistions dynamics");
        tabbedPane.setMnemonicAt(1, 50);
        this.mainTabPanel = new JTabbedPane();
        JPanel firstTab = new JPanel(new BorderLayout());
        firstTab.add((Component)this.craeteDataAcquisitionPanel(), "North");
        firstTab.add((Component)tabbedPane, "Center");
        this.mainTabPanel.addTab("Simple mode", Tools.getResIcon16("/icons/stateSim/simpleSimTab.png"), firstTab, "Simple mode");
        this.knockoutTab = new HolmesSimKnock(this);
        this.mainTabPanel.addTab("KnockoutSim", Tools.getResIcon16("/icons/stateSim/knockSimTab.png"), this.knockoutTab, "KnockoutSim");
        main.add((Component)this.mainTabPanel, "Center");
        this.repaint();
    }

    private JPanel craeteDataAcquisitionPanel() {
        JPanel dataAcquisitionPanel = new JPanel(null);
        dataAcquisitionPanel.setBorder(BorderFactory.createTitledBorder("Data acquisition"));
        dataAcquisitionPanel.setPreferredSize(new Dimension(670, 110));
        int posXda = 10;
        int posYda = 20;
        this.acqDataButton = new JButton("SimStart");
        this.acqDataButton.setBounds(posXda, posYda, 110, 40);
        this.acqDataButton.setMargin(new Insets(0, 0, 0, 0));
        this.acqDataButton.setFocusPainted(false);
        this.acqDataButton.setIcon(Tools.getResIcon32("/icons/stateSim/computeData.png"));
        this.acqDataButton.setToolTipText("Compute steps from zero marking through the number of states given on the right.");
        this.acqDataButton.addActionListener(actionEvent -> this.acquireDataFromSimulation());
        dataAcquisitionPanel.add(this.acqDataButton);
        JButton cancelButton = new JButton();
        cancelButton.setText("<html>&nbsp;&nbsp;&nbsp;STOP&nbsp;&nbsp;&nbsp;</html>");
        cancelButton.setIcon(Tools.getResIcon32("/icons/simulationKnockout/stopIcon.png"));
        cancelButton.setBounds(posXda, posYda + 45, 110, 30);
        cancelButton.setMargin(new Insets(0, 0, 0, 0));
        cancelButton.setFocusPainted(false);
        cancelButton.addActionListener(actionEvent -> this.ssim.setCancelStatus(true));
        dataAcquisitionPanel.add(cancelButton);
        JButton simSettingsButton = new JButton("SimSettings");
        simSettingsButton.setBounds(posXda + 120, posYda, 130, 40);
        simSettingsButton.setMargin(new Insets(0, 0, 0, 0));
        simSettingsButton.setFocusPainted(false);
        simSettingsButton.setIcon(Tools.getResIcon32("/icons/simSettings/setupIcon.png"));
        simSettingsButton.setToolTipText("Set simulator options.");
        simSettingsButton.addActionListener(actionEvent -> new HolmesSimSetup(this.ego));
        dataAcquisitionPanel.add(simSettingsButton);
        this.stateManagerButton = new JButton();
        this.stateManagerButton.setText("<html>States<br>Manager</html>");
        this.stateManagerButton.setIcon(Tools.getResIcon32("/icons/stateManager/stManIcon.png"));
        this.stateManagerButton.setBounds(posXda + 260, posYda, 130, 40);
        this.stateManagerButton.setMargin(new Insets(0, 0, 0, 0));
        this.stateManagerButton.setFocusPainted(false);
        this.stateManagerButton.addActionListener(actionEvent -> new HolmesStatesManager());
        dataAcquisitionPanel.add(this.stateManagerButton);
        JLabel stateLabel0 = new JLabel("Selected m0 state ID: ");
        stateLabel0.setBounds(posXda + 400, posYda, 130, 20);
        dataAcquisitionPanel.add(stateLabel0);
        this.selStateLabel = new JLabel("" + this.overlord.getWorkspace().getProject().accessStatesManager().selectedStatePN);
        this.selStateLabel.setBounds(posXda + 400, posYda + 20, 60, 20);
        dataAcquisitionPanel.add(this.selStateLabel);
        JButton clearDataButton = new JButton("Clear");
        clearDataButton.setBounds(posXda + 840, posYda, 110, 40);
        clearDataButton.setIcon(Tools.getResIcon32("/icons/stateSim/clearData.png"));
        clearDataButton.setToolTipText("Clear all charts and data vectors. Reset simulator.");
        clearDataButton.setFocusPainted(false);
        clearDataButton.addActionListener(actionEvent -> {
            this.clearPlacesChart();
            this.clearTransitionsChart();
            this.clearAllData();
        });
        dataAcquisitionPanel.add(clearDataButton);
        this.progressBar = new JProgressBar();
        this.progressBar.setBounds(posXda + 120, posYda + 40, 840, 40);
        this.progressBar.setMaximum(100);
        this.progressBar.setMinimum(0);
        this.progressBar.setValue(0);
        this.progressBar.setStringPainted(true);
        TitledBorder border = BorderFactory.createTitledBorder("Progress");
        this.progressBar.setBorder(border);
        dataAcquisitionPanel.add(this.progressBar);
        return dataAcquisitionPanel;
    }

    private JPanel createPlacesTabPanel() {
        JPanel result = new JPanel(new BorderLayout());
        JPanel topPanel = new JPanel(new BorderLayout());
        result.add((Component)topPanel, "First");
        JPanel placesChartOptionsPanel = new JPanel(null);
        placesChartOptionsPanel.setBorder(BorderFactory.createTitledBorder("Places chart options"));
        placesChartOptionsPanel.setPreferredSize(new Dimension(500, 120));
        int posXchart = 10;
        int posYchart = 20;
        JButton showAllButton = new JButton("<html>&nbsp;&nbsp;&nbsp;&nbsp;Show all&nbsp;&nbsp;&nbsp;&nbsp;</htm>");
        showAllButton.setBounds(posXchart, posYchart, 120, 24);
        showAllButton.setMargin(new Insets(0, 0, 0, 0));
        showAllButton.setFocusPainted(false);
        showAllButton.setIcon(Tools.getResIcon16("/icons/stateSim/showAll.png"));
        showAllButton.setToolTipText("Show average numbers of token in places through simulation steps.");
        showAllButton.addActionListener(actionEvent -> this.showAllPlacesData());
        placesChartOptionsPanel.add(showAllButton);
        JButton showNotepadButton = new JButton("Show notepad");
        showNotepadButton.setBounds(posXchart + 130, posYchart, 120, 24);
        showNotepadButton.setMargin(new Insets(0, 0, 0, 0));
        showNotepadButton.setFocusPainted(false);
        showNotepadButton.setIcon(Tools.getResIcon16("/icons/stateSim/showNotepad.png"));
        showNotepadButton.setToolTipText("Show average numbers of token in places through simulation steps.");
        showNotepadButton.addActionListener(actionEvent -> this.showPlacesAllInNotepad());
        placesChartOptionsPanel.add(showNotepadButton);
        JLabel labelInt = new JLabel("Interval:");
        labelInt.setBounds(posXchart + 280, posYchart + 2, 70, 20);
        placesChartOptionsPanel.add(labelInt);
        int mValue = this.overlord.simSettings.getSimSteps() / 10;
        SpinnerNumberModel intervSpinnerModel = new SpinnerNumberModel(this.placesInterval, 0, mValue, 10);
        this.placesIntervalSpinner = new JSpinner(intervSpinnerModel);
        this.placesIntervalSpinner.setBounds(posXchart + 330, posYchart + 3, 60, 20);
        this.placesIntervalSpinner.addChangeListener(e -> {
            JSpinner spinner = (JSpinner)e.getSource();
            this.placesInterval = (Integer)spinner.getValue();
            this.clearPlacesChart();
        });
        placesChartOptionsPanel.add(this.placesIntervalSpinner);
        JCheckBox sortedCheckBox = new JCheckBox("Sorted by tokens");
        sortedCheckBox.setBounds(posXchart + 460, posYchart + 10, 130, 20);
        sortedCheckBox.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            this.sortedP = abstractButton.getModel().isSelected();
            this.fillPlacesAndTransitionsData();
        });
        placesChartOptionsPanel.add(sortedCheckBox);
        JLabel label1 = new JLabel("Places:");
        label1.setBounds(posXchart, posYchart += 30, 70, 20);
        placesChartOptionsPanel.add(label1);
        String[] dataP = new String[]{"---"};
        this.placesCombo = new JComboBox<String>(dataP);
        this.placesCombo.setLocation(posXchart + 75, posYchart + 2);
        this.placesCombo.setSize(500, 20);
        this.placesCombo.setSelectedIndex(0);
        this.placesCombo.setMaximumRowCount(12);
        this.placesCombo.addActionListener(actionEvent -> {});
        placesChartOptionsPanel.add(this.placesCombo);
        JButton addPlaceButton = new JButton("Add to chart");
        addPlaceButton.setBounds(posXchart, (posYchart += 30) + 2, 110, 24);
        addPlaceButton.setMargin(new Insets(0, 0, 0, 0));
        addPlaceButton.setFocusPainted(false);
        addPlaceButton.setIcon(Tools.getResIcon16("/icons/stateSim/addChart.png"));
        addPlaceButton.setToolTipText("Add data about place tokens to the chart.");
        addPlaceButton.addActionListener(actionEvent -> {
            if (this.placesRawData.size() == 0) {
                return;
            }
            int selected = this.placesCombo.getSelectedIndex();
            if (selected > 0) {
                String name = this.placesCombo.getSelectedItem().toString();
                int sel = this.action.getRealNodeID(name);
                if (sel == -1) {
                    return;
                }
                name = this.trimNodeName(name);
                this.placesInChart.set(sel, 1);
                this.placesInChartStr.set(sel, name);
                this.addNewPlaceSeries(sel, name);
                this.updatePlacesGraphicChart("places");
            }
        });
        placesChartOptionsPanel.add(addPlaceButton);
        JButton removePlaceButton = new JButton("Remove");
        removePlaceButton.setBounds(posXchart + 120, posYchart + 2, 110, 24);
        removePlaceButton.setMargin(new Insets(0, 0, 0, 0));
        removePlaceButton.setFocusPainted(false);
        removePlaceButton.setIcon(Tools.getResIcon16("/icons/stateSim/removeChart.png"));
        removePlaceButton.setToolTipText("Remove data about place tokens from the chart.");
        removePlaceButton.addActionListener(actionEvent -> {
            if (this.placesRawData.size() == 0) {
                return;
            }
            int selected = this.placesCombo.getSelectedIndex();
            if (selected > 0) {
                String name = this.placesCombo.getSelectedItem().toString();
                int sel = this.action.getRealNodeID(name);
                if (sel == -1) {
                    return;
                }
                name = this.trimNodeName(name);
                this.placesInChart.set(sel, -1);
                this.placesInChartStr.set(sel, "");
                this.removePlaceSeries(name);
            }
        });
        placesChartOptionsPanel.add(removePlaceButton);
        JButton clearPlacesChartButton = new JButton("Clear chart");
        clearPlacesChartButton.setBounds(posXchart + 240, posYchart + 2, 110, 24);
        clearPlacesChartButton.setMargin(new Insets(0, 0, 0, 0));
        clearPlacesChartButton.setFocusPainted(false);
        clearPlacesChartButton.setIcon(Tools.getResIcon16("/icons/stateSim/clearChart.png"));
        clearPlacesChartButton.setToolTipText("Clears the chart.");
        clearPlacesChartButton.addActionListener(actionEvent -> this.clearPlacesChart());
        placesChartOptionsPanel.add(clearPlacesChartButton);
        JButton savePlacesChartButton = new JButton("Save Image");
        savePlacesChartButton.setBounds(posXchart + 360, posYchart + 2, 110, 24);
        savePlacesChartButton.setMargin(new Insets(0, 0, 0, 0));
        savePlacesChartButton.setFocusPainted(false);
        savePlacesChartButton.setIcon(Tools.getResIcon16("/icons/stateSim/saveImage.png"));
        savePlacesChartButton.setToolTipText("Saves the chart as image file.");
        savePlacesChartButton.addActionListener(actionEvent -> this.saveChartImage("places", 1200, 1024));
        placesChartOptionsPanel.add(savePlacesChartButton);
        JButton showPlaceButton = new JButton("Find place");
        showPlaceButton.setBounds(posXchart + 480, posYchart + 2, 110, 24);
        showPlaceButton.setMargin(new Insets(0, 0, 0, 0));
        showPlaceButton.setFocusPainted(false);
        showPlaceButton.setIcon(Tools.getResIcon16("/icons/stateSim/findNode.png"));
        showPlaceButton.setToolTipText("Find selected place within the net.");
        showPlaceButton.addActionListener(actionEvent -> {
            int selected = this.placesCombo.getSelectedIndex();
            if (selected > 0) {
                String name = this.placesCombo.getSelectedItem().toString();
                int sel = this.action.getRealNodeID(name);
                if (sel == -1) {
                    return;
                }
                GUIManager.getDefaultGUIManager().getSearchWindow().fillComboBoxesData();
                GUIManager.getDefaultGUIManager().getSearchWindow().selectedManually(true, sel);
            }
        });
        placesChartOptionsPanel.add(showPlaceButton);
        topPanel.add((Component)placesChartOptionsPanel, "Center");
        JPanel placesChartGraphicPanel = new JPanel(null);
        placesChartGraphicPanel.setBorder(BorderFactory.createTitledBorder("Chart graphic"));
        placesChartGraphicPanel.setPreferredSize(new Dimension(200, 100));
        int posXGchart = 10;
        int posYGchart = 20;
        ButtonGroup groupWidth = new ButtonGroup();
        JRadioButton width1 = new JRadioButton("Thin");
        width1.setBounds(posXGchart, posYGchart, 70, 20);
        width1.setActionCommand("0");
        width1.addActionListener(actionEvent -> {
            if (((AbstractButton)actionEvent.getSource()).isSelected()) {
                this.chartDetails.p_StrokeWidth = 1.0f;
                this.updatePlacesGraphicChart("places");
            }
        });
        placesChartGraphicPanel.add(width1);
        groupWidth.add(width1);
        groupWidth.setSelected(width1.getModel(), true);
        JRadioButton width2 = new JRadioButton("Normal");
        width2.setBounds(posXGchart, posYGchart + 20, 70, 20);
        width2.setActionCommand("1");
        width2.addActionListener(actionEvent -> {
            if (((AbstractButton)actionEvent.getSource()).isSelected()) {
                this.chartDetails.p_StrokeWidth = 2.0f;
                this.updatePlacesGraphicChart("places");
            }
        });
        placesChartGraphicPanel.add(width2);
        groupWidth.add(width2);
        JRadioButton width3 = new JRadioButton("Thick");
        width3.setBounds(posXGchart, posYGchart + 40, 70, 20);
        width3.setActionCommand("2");
        width3.addActionListener(actionEvent -> {
            if (((AbstractButton)actionEvent.getSource()).isSelected()) {
                this.chartDetails.p_StrokeWidth = 3.0f;
                this.updatePlacesGraphicChart("places");
            }
        });
        placesChartGraphicPanel.add(width3);
        groupWidth.add(width3);
        topPanel.add((Component)placesChartGraphicPanel, "East");
        this.placesJPanel = new JPanel(new BorderLayout());
        this.placesJPanel.setBorder(BorderFactory.createTitledBorder("Places chart"));
        this.placesJPanel.add((Component)this.createPlacesChartPanel(), "Center");
        result.add((Component)this.placesJPanel, "Center");
        return result;
    }

    private JPanel createTransitionsTabPanel() {
        JPanel result = new JPanel(new BorderLayout());
        JPanel topPanel = new JPanel(new BorderLayout());
        result.add((Component)topPanel, "First");
        JPanel transChartOptionsPanel = new JPanel(null);
        transChartOptionsPanel.setBorder(BorderFactory.createTitledBorder("Transitions chart options"));
        transChartOptionsPanel.setPreferredSize(new Dimension(500, 120));
        int posXchart = 10;
        int posYchart = 20;
        JButton showAllButton = new JButton("<html>&nbsp;&nbsp;&nbsp;&nbsp;Show all&nbsp;&nbsp;&nbsp;&nbsp;</html>");
        showAllButton.setBounds(posXchart, posYchart, 120, 24);
        showAllButton.setMargin(new Insets(0, 0, 0, 0));
        showAllButton.setFocusPainted(false);
        showAllButton.setIcon(Tools.getResIcon16("/icons/stateSim/showAll.png"));
        showAllButton.setToolTipText("Show average numbers of firings of transitions through simulation steps.");
        showAllButton.addActionListener(actionEvent -> this.showAllTransData());
        transChartOptionsPanel.add(showAllButton);
        JButton showNotepadButton = new JButton("Show notepad");
        showNotepadButton.setBounds(posXchart + 130, posYchart, 120, 24);
        showNotepadButton.setMargin(new Insets(0, 0, 0, 0));
        showNotepadButton.setFocusPainted(false);
        showNotepadButton.setIcon(Tools.getResIcon16("/icons/stateSim/showNotepad.png"));
        showNotepadButton.setToolTipText("Show average numbers of firings of transitions through simulation steps.");
        showNotepadButton.addActionListener(actionEvent -> this.showTransAllInNotepad());
        transChartOptionsPanel.add(showNotepadButton);
        JLabel label1 = new JLabel("Interval:");
        label1.setBounds(posXchart + 280, posYchart + 2, 70, 20);
        transChartOptionsPanel.add(label1);
        int mValue = this.overlord.simSettings.getSimSteps() / 10;
        SpinnerNumberModel intervSpinnerModel = new SpinnerNumberModel(this.transInterval, 0, mValue, 10);
        this.transIntervalSpinner = new JSpinner(intervSpinnerModel);
        this.transIntervalSpinner.setBounds(posXchart + 330, posYchart + 3, 60, 20);
        this.transIntervalSpinner.addChangeListener(e -> {
            JSpinner spinner = (JSpinner)e.getSource();
            this.transInterval = (Integer)spinner.getValue();
            this.clearTransitionsChart();
        });
        transChartOptionsPanel.add(this.transIntervalSpinner);
        JCheckBox sortedCheckBox = new JCheckBox("Sorted by firing");
        sortedCheckBox.setBounds(posXchart + 460, posYchart + 10, 130, 20);
        sortedCheckBox.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            this.sortedT = abstractButton.getModel().isSelected();
            this.fillPlacesAndTransitionsData();
        });
        transChartOptionsPanel.add(sortedCheckBox);
        JLabel label2 = new JLabel("Transition:");
        label2.setBounds(posXchart, posYchart += 30, 70, 20);
        transChartOptionsPanel.add(label2);
        String[] dataP = new String[]{"---"};
        this.transitionsCombo = new JComboBox<String>(dataP);
        this.transitionsCombo.setLocation(posXchart + 75, posYchart + 2);
        this.transitionsCombo.setSize(500, 20);
        this.transitionsCombo.setSelectedIndex(0);
        this.transitionsCombo.setMaximumRowCount(12);
        transChartOptionsPanel.add(this.transitionsCombo);
        JButton addTransitionButton = new JButton("Add to chart");
        addTransitionButton.setBounds(posXchart, (posYchart += 30) + 2, 110, 24);
        addTransitionButton.setMargin(new Insets(0, 0, 0, 0));
        addTransitionButton.setFocusPainted(false);
        addTransitionButton.setIcon(Tools.getResIcon16("/icons/stateSim/addChart.png"));
        addTransitionButton.setToolTipText("Add data about transition firing to the chart.");
        addTransitionButton.addActionListener(actionEvent -> {
            if (this.transitionsRawData.size() == 0) {
                return;
            }
            int selected = this.transitionsCombo.getSelectedIndex();
            if (selected > 0) {
                String name = this.transitionsCombo.getSelectedItem().toString();
                int sel = this.action.getRealNodeID(name);
                if (sel == -1) {
                    return;
                }
                name = this.trimNodeName(name);
                this.addNewTransitionSeries(sel, name);
            }
        });
        transChartOptionsPanel.add(addTransitionButton);
        JButton removeTransitionButton = new JButton("Remove");
        removeTransitionButton.setBounds(posXchart + 120, posYchart + 2, 110, 24);
        removeTransitionButton.setMargin(new Insets(0, 0, 0, 0));
        removeTransitionButton.setFocusPainted(false);
        removeTransitionButton.setIcon(Tools.getResIcon16("/icons/stateSim/removeChart.png"));
        removeTransitionButton.setToolTipText("Remove data about transition firing from the chart.");
        removeTransitionButton.addActionListener(actionEvent -> {
            if (this.transitionsRawData.size() == 0) {
                return;
            }
            int selected = this.transitionsCombo.getSelectedIndex();
            if (selected > 0) {
                String name = this.transitionsCombo.getSelectedItem().toString();
                name = this.trimNodeName(name);
                this.removeTransitionSeries(name);
            }
        });
        transChartOptionsPanel.add(removeTransitionButton);
        JButton clearTransChartButton = new JButton("Clear chart");
        clearTransChartButton.setBounds(posXchart + 240, posYchart + 2, 110, 24);
        clearTransChartButton.setMargin(new Insets(0, 0, 0, 0));
        clearTransChartButton.setFocusPainted(false);
        clearTransChartButton.setIcon(Tools.getResIcon16("/icons/stateSim/clearChart.png"));
        clearTransChartButton.setToolTipText("Clears the transitions chart.");
        clearTransChartButton.addActionListener(actionEvent -> this.clearTransitionsChart());
        transChartOptionsPanel.add(clearTransChartButton);
        JButton saveTransitionsChartButton = new JButton("Save Image");
        saveTransitionsChartButton.setBounds(posXchart + 360, posYchart + 2, 110, 24);
        saveTransitionsChartButton.setMargin(new Insets(0, 0, 0, 0));
        saveTransitionsChartButton.setFocusPainted(false);
        saveTransitionsChartButton.setIcon(Tools.getResIcon16("/icons/stateSim/saveImage.png"));
        saveTransitionsChartButton.setToolTipText("Saves the chart as image file.");
        saveTransitionsChartButton.addActionListener(actionEvent -> this.saveChartImage("transitions", 1200, 1024));
        transChartOptionsPanel.add(saveTransitionsChartButton);
        JButton showTransButton = new JButton("Find trans.");
        showTransButton.setBounds(posXchart + 480, posYchart + 2, 110, 24);
        showTransButton.setMargin(new Insets(0, 0, 0, 0));
        showTransButton.setFocusPainted(false);
        showTransButton.setIcon(Tools.getResIcon16("/icons/stateSim/findNode.png"));
        showTransButton.setToolTipText("Find selected transition within the net.");
        showTransButton.addActionListener(actionEvent -> {
            int selected = this.transitionsCombo.getSelectedIndex();
            if (selected > 0) {
                int sel = this.action.getRealNodeID(this.transitionsCombo.getSelectedItem().toString());
                if (sel == -1) {
                    return;
                }
                GUIManager.getDefaultGUIManager().getSearchWindow().fillComboBoxesData();
                GUIManager.getDefaultGUIManager().getSearchWindow().selectedManually(false, sel);
            }
        });
        transChartOptionsPanel.add(showTransButton);
        topPanel.add((Component)transChartOptionsPanel, "Center");
        JPanel transChartGraphicPanel = new JPanel(null);
        transChartGraphicPanel.setBorder(BorderFactory.createTitledBorder("Chart graphic"));
        transChartGraphicPanel.setPreferredSize(new Dimension(200, 100));
        int posXGchart = 10;
        int posYGchart = 20;
        ButtonGroup groupWidth = new ButtonGroup();
        JRadioButton width1 = new JRadioButton("Thin");
        width1.setBounds(posXGchart, posYGchart, 70, 20);
        width1.setActionCommand("0");
        width1.addActionListener(actionEvent -> {
            if (((AbstractButton)actionEvent.getSource()).isSelected()) {
                this.chartDetails.t_StrokeWidth = 1.0f;
                this.updatePlacesGraphicChart("transitions");
            }
        });
        transChartGraphicPanel.add(width1);
        groupWidth.add(width1);
        groupWidth.setSelected(width1.getModel(), true);
        JRadioButton width2 = new JRadioButton("Normal");
        width2.setBounds(posXGchart, posYGchart + 20, 70, 20);
        width2.setActionCommand("1");
        width2.addActionListener(actionEvent -> {
            if (((AbstractButton)actionEvent.getSource()).isSelected()) {
                this.chartDetails.t_StrokeWidth = 2.0f;
                this.updatePlacesGraphicChart("transitions");
            }
        });
        transChartGraphicPanel.add(width2);
        groupWidth.add(width2);
        JRadioButton width3 = new JRadioButton("Thick");
        width3.setBounds(posXGchart, posYGchart + 40, 70, 20);
        width3.setActionCommand("2");
        width3.addActionListener(actionEvent -> {
            if (((AbstractButton)actionEvent.getSource()).isSelected()) {
                this.chartDetails.t_StrokeWidth = 3.0f;
                this.updatePlacesGraphicChart("transitions");
            }
        });
        transChartGraphicPanel.add(width3);
        groupWidth.add(width3);
        topPanel.add((Component)transChartGraphicPanel, "East");
        this.transitionsJPanel = new JPanel(new BorderLayout());
        this.transitionsJPanel.setBorder(BorderFactory.createTitledBorder("Transitions chart"));
        this.transitionsJPanel.add((Component)this.createTransChartPanel(), "Center");
        result.add((Component)this.transitionsJPanel, "Center");
        return result;
    }

    private JPanel createPlacesChartPanel() {
        String chartTitle = "Places dynamics";
        String xAxisLabel = "Step";
        String yAxisLabel = "Tokens";
        boolean showLegend = true;
        boolean createTooltip = true;
        boolean createURL = false;
        this.placesSeriesDataSet = new XYSeriesCollection();
        this.placesChart = ChartFactory.createXYLineChart(chartTitle, xAxisLabel, yAxisLabel, this.placesSeriesDataSet, PlotOrientation.VERTICAL, showLegend, createTooltip, createURL);
        return new ChartPanel(this.placesChart);
    }

    private void addNewPlaceSeries(int selPlaceID, String name) {
        if (this.placesChartType == 0) {
            this.placesJPanel.removeAll();
            this.placesJPanel.add((Component)this.createPlacesChartPanel(), "Center");
            this.placesJPanel.revalidate();
            this.placesJPanel.repaint();
            this.placesChartType = 1;
            this.placesSeriesDataSet.removeAllSeries();
        }
        List x = this.placesSeriesDataSet.getSeries();
        for (XYSeries xys : x) {
            if (!xys.getKey().equals(name)) continue;
            return;
        }
        XYSeries series = new XYSeries((Comparable)((Object)name));
        int interval = this.placesInterval;
        int maxStep = this.placesRawData.size() - interval - 1;
        if (this.placesRawData.size() > 10 * interval) {
            for (int step = 0; step < maxStep; step += interval) {
                double value = 0.0;
                for (int j = 0; j < interval; ++j) {
                    value += (double)this.placesRawData.get(step + j).get(selPlaceID).intValue();
                }
                series.add((double)step, value /= (double)interval);
            }
        } else {
            for (int step = 0; step < this.placesRawData.size(); ++step) {
                int value = this.placesRawData.get(step).get(selPlaceID);
                series.add((double)step, value);
            }
        }
        this.placesSeriesDataSet.addSeries(series);
    }

    private void removePlaceSeries(String name) {
        List x = this.placesSeriesDataSet.getSeries();
        for (XYSeries xys : x) {
            if (!xys.getKey().equals(name)) continue;
            this.placesSeriesDataSet.removeSeries(xys);
            return;
        }
    }

    private void clearPlacesChart() {
        this.placesSeriesDataSet.removeAllSeries();
        this.placesInChart = new ArrayList();
        this.placesInChartStr = new ArrayList();
        for (int i = 0; i < GUIManager.getDefaultGUIManager().getWorkspace().getProject().getPlaces().size(); ++i) {
            this.placesInChart.add(-1);
            this.placesInChartStr.add("");
        }
    }

    private void showAllPlacesData() {
        if (this.placesAvgData.size() == 0) {
            return;
        }
        this.placesChartType = 0;
        double max = 0.0;
        for (Double placesAvgDatum : this.placesAvgData) {
            if (!(placesAvgDatum > max)) continue;
            max = placesAvgDatum;
        }
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        for (int p = 0; p < this.placesAvgData.size(); ++p) {
            String tName = "p" + p;
            double value = this.placesAvgData.get(p);
            dataset.addValue(value, (Comparable)((Object)"Tokens"), (Comparable)((Object)tName));
            if (value > 0.0) {
                dataset.addValue(max - value, (Comparable)((Object)"toMax"), (Comparable)((Object)tName));
                dataset.addValue(0.0, (Comparable)((Object)"ZeroTokens"), (Comparable)((Object)tName));
                continue;
            }
            dataset.addValue(0.0, (Comparable)((Object)"toMax"), (Comparable)((Object)tName));
            dataset.addValue(max, (Comparable)((Object)"ZeroTokens"), (Comparable)((Object)tName));
        }
        CategoryAxis xAxisPlaces = new CategoryAxis("Place ID");
        xAxisPlaces.setLowerMargin(0.01);
        xAxisPlaces.setUpperMargin(0.01);
        xAxisPlaces.setCategoryMargin(0.05);
        NumberAxis yAxisPlaces = new NumberAxis("Average tokens");
        yAxisPlaces.setLabelFont(new Font("Helvetica", 1, 24));
        StackedBarRenderer rendererPlaces = new StackedBarRenderer();
        CategoryPlot plotPlaces = new CategoryPlot(dataset, xAxisPlaces, yAxisPlaces, rendererPlaces);
        rendererPlaces.setToolTipGenerator(new CustomToolTipPlacesGenerator(this.overlord.getWorkspace().getProject().getPlaces(), this.placesAvgData, max));
        this.placesChart = new JFreeChart("Places average tokens data", new Font("Helvetica", 1, 24), plotPlaces, true);
        CategoryPlot plot = (CategoryPlot)this.placesChart.getPlot();
        StackedBarRenderer renderer = (StackedBarRenderer)plot.getRenderer();
        renderer.setBase(1.0);
        GradientPaint p1 = new GradientPaint(0.0f, 0.0f, Color.red, 0.0f, 0.0f, Color.red);
        renderer.setSeriesPaint(0, p1);
        GradientPaint p2 = new GradientPaint(0.0f, 0.0f, Color.lightGray, 0.0f, 0.0f, Color.lightGray);
        renderer.setSeriesPaint(1, p2);
        GradientPaint p3 = new GradientPaint(0.0f, 0.0f, Color.gray, 0.0f, 0.0f, Color.gray);
        renderer.setSeriesPaint(2, p3);
        plot.setRenderer(renderer);
        Font font3 = new Font("Dialog", 0, 10);
        plot.getDomainAxis().setLabelFont(font3);
        plot.getRangeAxis().setLabelFont(font3);
        LegendTitle legend = this.placesChart.getLegend();
        Font labelFont = new Font("Arial", 1, 12);
        legend.setItemFont(labelFont);
        BarRenderer br = (BarRenderer)plot.getRenderer();
        br.setMaximumBarWidth(20.0);
        this.placesJPanel.removeAll();
        ChartPanel placesChartPanel = new ChartPanel(this.placesChart);
        int places = this.placesAvgData.size();
        if (this.placesAvgData.size() > 99) {
            placesChartPanel.setPreferredSize(new Dimension(places * 50, 270));
            placesChartPanel.setMaximumDrawWidth(places * 30);
        } else {
            placesChartPanel.setPreferredSize(new Dimension(places * 40, 270));
            placesChartPanel.setMaximumDrawWidth(places * 30);
        }
        JScrollPane sPane = new JScrollPane(placesChartPanel);
        this.placesJPanel.add((Component)sPane, "Center");
        this.placesJPanel.revalidate();
        this.placesJPanel.repaint();
    }

    private void showPlacesAllInNotepad() {
        if (this.placesAvgData.size() == 0) {
            return;
        }
        HolmesNotepad notePad = new HolmesNotepad(900, 600);
        notePad.setVisible(true);
        ArrayList<Place> places_tmp = GUIManager.getDefaultGUIManager().getWorkspace().getProject().getPlaces();
        notePad.addTextLineNL("", "text");
        notePad.addTextLineNL("Places: ", "text");
        notePad.addTextLineNL("", "text");
        for (int p = 0; p < this.placesAvgData.size(); ++p) {
            String p_name = places_tmp.get(p).getName();
            double val = this.placesAvgData.get(p);
            long total = this.placesTotalData.get(p);
            if (val > 0.0) {
                notePad.addTextLineNL("  p_" + p + " " + p_name + " : Avg. tokens: " + val + " Total: " + total, "text");
                continue;
            }
            notePad.addTextLineNL("NO_TOKENS: p_" + p + " " + p_name + " : " + val, "text");
        }
    }

    private JPanel createTransChartPanel() {
        String chartTitle = "Transitions dynamics";
        String xAxisLabel = "Transition";
        String yAxisLabel = "Firing";
        boolean showLegend = true;
        boolean createTooltip = true;
        boolean createURL = false;
        this.transitionsSeriesDataSet = new XYSeriesCollection();
        this.transitionsChart = ChartFactory.createXYLineChart(chartTitle, xAxisLabel, yAxisLabel, this.transitionsSeriesDataSet, PlotOrientation.VERTICAL, showLegend, createTooltip, createURL);
        return new ChartPanel(this.transitionsChart);
    }

    private void addNewTransitionSeries(int selTransID, String name) {
        if (this.transChartType == 0) {
            this.transitionsJPanel.removeAll();
            this.transitionsJPanel.add((Component)this.createTransChartPanel(), "Center");
            this.transitionsJPanel.revalidate();
            this.transitionsJPanel.repaint();
            this.transChartType = 1;
            this.transitionsSeriesDataSet.removeAllSeries();
        }
        List x = this.transitionsSeriesDataSet.getSeries();
        for (XYSeries xys : x) {
            if (!xys.getKey().equals(name)) continue;
            return;
        }
        XYSeries series = new XYSeries((Comparable)((Object)name));
        for (int step = 0; step < this.transitionsRawData.size(); ++step) {
            if (this.transInterval > this.transitionsRawData.size() / 10) {
                this.transInterval = this.transitionsRawData.size() / 10;
            }
            int value = 0;
            for (int i = 0; i < this.transInterval; ++i) {
                try {
                    value += this.transitionsRawData.get(step + i).get(selTransID).intValue();
                    continue;
                }
                catch (Exception ex) {
                    GUIManager.getDefaultGUIManager().log("Error (906615096) | Exception:  " + ex.getMessage(), "error", true);
                }
            }
            series.add((double)step, value);
            step += this.transInterval;
            if (this.transInterval <= 1) continue;
            --step;
        }
        this.transitionsSeriesDataSet.addSeries(series);
    }

    private void removeTransitionSeries(String name) {
        List x = this.transitionsSeriesDataSet.getSeries();
        for (XYSeries xys : x) {
            if (!xys.getKey().equals(name)) continue;
            this.transitionsSeriesDataSet.removeSeries(xys);
            return;
        }
    }

    private void clearTransitionsChart() {
        this.transitionsSeriesDataSet.removeAllSeries();
    }

    private void showAllTransData() {
        if (this.transitionsCompactData.size() == 0) {
            return;
        }
        this.transChartType = 0;
        double max = 0.0;
        for (Integer transitionsCompactDatum : this.transitionsCompactData) {
            if (!((double)transitionsCompactDatum.intValue() > max)) continue;
            max = transitionsCompactDatum.intValue();
        }
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        for (int t = 0; t < this.transitionsCompactData.size(); ++t) {
            String tName = "t" + t;
            int value = this.transitionsCompactData.get(t);
            dataset.addValue(value, (Comparable)((Object)"Firing"), (Comparable)((Object)tName));
            if (value > 0) {
                dataset.addValue(max - (double)value, (Comparable)((Object)"NotFiring"), (Comparable)((Object)tName));
                dataset.addValue(0.0, (Comparable)((Object)"zero"), (Comparable)((Object)tName));
                continue;
            }
            dataset.addValue(0.0, (Comparable)((Object)"NotFiring"), (Comparable)((Object)tName));
            dataset.addValue(max, (Comparable)((Object)"zero"), (Comparable)((Object)tName));
        }
        CategoryAxis xAxisTrans = new CategoryAxis("Transition ID");
        xAxisTrans.setLowerMargin(0.01);
        xAxisTrans.setUpperMargin(0.01);
        xAxisTrans.setCategoryMargin(0.05);
        NumberAxis yAxisPlaces = new NumberAxis("Total firing value");
        StackedBarRenderer rendererTrans = new StackedBarRenderer();
        CategoryPlot plotTrans = new CategoryPlot(dataset, xAxisTrans, yAxisPlaces, rendererTrans);
        rendererTrans.setToolTipGenerator(new CustomToolTipTransGenerator(this.overlord.getWorkspace().getProject().getTransitions(), this.transitionsCompactData, max));
        this.transitionsChart = new JFreeChart("Transitions statistical data", new Font("Helvetica", 1, 14), plotTrans, true);
        CategoryPlot plot = (CategoryPlot)this.transitionsChart.getPlot();
        CategoryItemRenderer renderer = plot.getRenderer();
        GradientPaint p1 = new GradientPaint(0.0f, 0.0f, Color.red, 0.0f, 0.0f, Color.red);
        renderer.setSeriesPaint(0, p1);
        GradientPaint p2 = new GradientPaint(0.0f, 0.0f, Color.lightGray, 0.0f, 0.0f, Color.lightGray);
        renderer.setSeriesPaint(1, p2);
        GradientPaint p3 = new GradientPaint(0.0f, 0.0f, Color.gray, 0.0f, 0.0f, Color.gray);
        renderer.setSeriesPaint(2, p3);
        plot.setRenderer(renderer);
        Font font3 = new Font("Dialog", 0, 12);
        plot.getDomainAxis().setLabelFont(font3);
        plot.getRangeAxis().setLabelFont(font3);
        LegendTitle legend = this.transitionsChart.getLegend();
        Font labelFont = new Font("Arial", 1, 12);
        legend.setItemFont(labelFont);
        this.transitionsJPanel.removeAll();
        ChartPanel transChartPanel = new ChartPanel(this.transitionsChart);
        int transitions = this.transitionsCompactData.size();
        if (this.transitionsCompactData.size() > 99) {
            transChartPanel.setPreferredSize(new Dimension(transitions * 50, 270));
            transChartPanel.setMaximumDrawWidth(transitions * 30);
        } else {
            transChartPanel.setPreferredSize(new Dimension(transitions * 40, 270));
            transChartPanel.setMaximumDrawWidth(transitions * 30);
        }
        JScrollPane sPane = new JScrollPane(transChartPanel);
        this.transitionsJPanel.add((Component)sPane, "Center");
        this.transitionsJPanel.revalidate();
        this.transitionsJPanel.repaint();
    }

    private void showTransAllInNotepad() {
        if (this.transitionsCompactData.size() == 0) {
            return;
        }
        double max = 0.0;
        long total = 0L;
        for (Integer transitionsCompactDatum : this.transitionsCompactData) {
            total += (long)transitionsCompactDatum.intValue();
            if (!((double)transitionsCompactDatum.intValue() > max)) continue;
            max = transitionsCompactDatum.intValue();
        }
        HolmesNotepad notePad = new HolmesNotepad(900, 600);
        notePad.setVisible(true);
        ArrayList<Transition> trans_tmp = GUIManager.getDefaultGUIManager().getWorkspace().getProject().getTransitions();
        notePad.addTextLineNL("", "text");
        notePad.addTextLineNL("Transitions: (sum of all firing: " + total + ")", "text");
        notePad.addTextLineNL("", "text");
        for (int t = 0; t < this.transitionsCompactData.size(); ++t) {
            String t_name = trans_tmp.get(t).getName();
            double val = this.transitionsCompactData.get(t).intValue();
            if (val > 0.0) {
                notePad.addTextLineNL("  t_" + t + " " + t_name + " : Fired: " + val + " (max: " + max + ")", "text");
                continue;
            }
            if (trans_tmp.get(t).isKnockedOut()) {
                notePad.addTextLineNL("MANUALLY DISABLED: t_" + t + " " + t_name + " : " + val, "text");
                continue;
            }
            notePad.addTextLineNL("OFFLINE: t_" + t + " " + t_name + " : " + val, "text");
        }
    }

    private void saveChartImage(String chartType, int w, int h) {
        String lastPath = GUIManager.getDefaultGUIManager().getLastPath();
        FileFilter[] filters = new FileFilter[]{new ExtensionFileFilter("Portable Network Graphics (.png)", new String[]{"PNG"})};
        Object selectedFile = Tools.selectFileDialog(lastPath, filters, "Save", "", "");
        if (((String)selectedFile).equals("")) {
            return;
        }
        if (!((String)selectedFile).contains(".png")) {
            selectedFile = (String)selectedFile + ".png";
        }
        File imageFile = new File((String)selectedFile);
        try {
            if (chartType.equals("places")) {
                ChartUtilities.saveChartAsPNG(imageFile, this.placesChart, w, h);
            } else if (chartType.equals("transitions")) {
                ChartUtilities.saveChartAsPNG(imageFile, this.transitionsChart, w, h);
            }
        }
        catch (IOException ex) {
            this.overlord.log("Error:" + ex, "error", true);
        }
    }

    private void fillPlacesAndTransitionsData() {
        ArrayList<Transition> transitions;
        this.selStateLabel.setText("" + this.overlord.getWorkspace().getProject().accessStatesManager().selectedStatePN);
        ArrayList<Place> places = GUIManager.getDefaultGUIManager().getWorkspace().getProject().getPlaces();
        if (places == null || places.size() == 0) {
            this.placesCombo.removeAllItems();
            this.placesCombo.addItem("---");
            this.transitionsCombo.removeAllItems();
            this.transitionsCombo.addItem("---");
            return;
        }
        this.placesCombo.removeAllItems();
        this.placesCombo.addItem("---");
        if (this.placesAvgData.size() == places.size()) {
            if (!this.sortedP) {
                for (int p = 0; p < places.size(); ++p) {
                    this.placesCombo.addItem("p" + p + "." + places.get(p).getName() + " " + this.formatD(this.placesAvgData.get(p)));
                }
            } else {
                HashMap<Integer, Double> map = new HashMap<Integer, Double>();
                for (int j = 0; j < this.placesAvgData.size(); ++j) {
                    map.put(j, this.placesAvgData.get(j));
                }
                Map sortedByValues = HolmesSimActions.crunchifySortMap(map);
                for (Map.Entry entry : sortedByValues.entrySet()) {
                    this.placesCombo.addItem("p" + entry.getKey() + "." + places.get((Integer)entry.getKey()).getName() + " " + this.formatD((Double)entry.getValue()));
                }
            }
        } else {
            for (int p = 0; p < places.size(); ++p) {
                this.placesCombo.addItem("p" + p + "." + places.get(p).getName());
            }
        }
        if ((transitions = GUIManager.getDefaultGUIManager().getWorkspace().getProject().getTransitions()) == null || transitions.size() == 0) {
            return;
        }
        this.transitionsCombo.removeAllItems();
        this.transitionsCombo.addItem("---");
        if (this.transAvgData.size() == transitions.size()) {
            if (!this.sortedT) {
                for (int t = 0; t < transitions.size(); ++t) {
                    this.transitionsCombo.addItem("t" + t + "." + transitions.get(t).getName() + " " + this.formatD(this.transAvgData.get(t)));
                }
            } else {
                HashMap<Integer, Double> map = new HashMap<Integer, Double>();
                for (int j = 0; j < this.transAvgData.size(); ++j) {
                    map.put(j, this.transAvgData.get(j));
                }
                Map sortedByValues = HolmesSimActions.crunchifySortMap(map);
                for (Map.Entry entry : sortedByValues.entrySet()) {
                    this.transitionsCombo.addItem("t" + entry.getKey() + "." + transitions.get((Integer)entry.getKey()).getName() + " " + this.formatD((Double)entry.getValue()));
                }
            }
        } else {
            for (int t = 0; t < transitions.size(); ++t) {
                this.transitionsCombo.addItem("t" + t + "." + transitions.get(t).getName());
            }
        }
    }

    private void acquireDataFromSimulation() {
        if (GUIManager.getDefaultGUIManager().getSimulatorBox().getCurrentDockWindow().getSimulator().getSimulatorStatus() != GraphicalSimulator.SimulatorMode.STOPPED) {
            JOptionPane.showMessageDialog(this.ego, "Main simulator active. Please turn if off before starting state simulator process", "Main simulator active", 0);
            return;
        }
        ArrayList<Place> places = GUIManager.getDefaultGUIManager().getWorkspace().getProject().getPlaces();
        if (places == null || places.size() == 0) {
            return;
        }
        this.clearTransitionsChart();
        this.clearPlacesChart();
        this.clearAllData();
        this.progressBar.setMaximum(this.overlord.simSettings.getSimSteps());
        boolean success = this.ssim.initiateSim(true, null);
        if (!success) {
            return;
        }
        this.setSimWindowComponentsStatus(false);
        this.setWorkInProgress(true);
        this.ssim.setThreadDetails(1, this, this.progressBar);
        Thread myThread = new Thread(this.ssim);
        myThread.start();
    }

    private void setSimWindowComponentsStatus(boolean value) {
        this.acqDataButton.setEnabled(value);
        this.stateManagerButton.setEnabled(value);
        this.overlord.getFrame().setEnabled(value);
    }

    public void completeSimulationProcedures() {
        this.placesRawData = this.ssim.getPlacesData();
        this.placesAvgData = this.ssim.getPlacesAvgData();
        this.placesTotalData = this.ssim.getPlacesTotalData();
        this.transitionsRawData = this.ssim.getTransitionsData();
        this.transitionsCompactData = this.ssim.getTransitionsCompactData();
        this.transAvgData = this.ssim.getTransitionsAvgData();
        this.placesInChart = new ArrayList();
        this.placesInChartStr = new ArrayList();
        for (int i = 0; i < GUIManager.getDefaultGUIManager().getWorkspace().getProject().getPlaces().size(); ++i) {
            this.placesInChart.add(-1);
            this.placesInChartStr.add("");
        }
        this.fillPlacesAndTransitionsData();
        this.setSimWindowComponentsStatus(true);
        this.setWorkInProgress(false);
    }

    private void clearAllData() {
        this.ssim = new StateSimulator();
        this.placesRawData.clear();
        this.transitionsRawData.clear();
        this.transitionsCompactData.clear();
        this.placesAvgData.clear();
        this.placesTotalData.clear();
        this.transAvgData.clear();
        this.placesInChart.clear();
        this.placesInChartStr.clear();
    }

    private String formatD(double value) {
        DecimalFormat df = new DecimalFormat("#.#######");
        Object txt = "(avg: ";
        txt = (String)txt + df.format(value);
        txt = (String)txt + ")";
        txt = ((String)txt).replace(",", ".");
        return txt;
    }

    private String trimNodeName(String name) {
        int i = name.indexOf("(avg");
        if (i < 0) {
            return name;
        }
        name = name.substring(0, i - 1);
        return name;
    }

    private void updatePlacesGraphicChart(String chartType) {
        block5: {
            block4: {
                if (!chartType.equals("places")) break block4;
                if (this.placesChartType == 0) {
                    return;
                }
                XYPlot plot = this.placesChart.getXYPlot();
                int count = this.placesChart.getXYPlot().getSeriesCount();
                for (int i = 0; i < count; ++i) {
                    plot.getRenderer().setSeriesStroke(i, new BasicStroke(this.chartDetails.p_StrokeWidth));
                }
                break block5;
            }
            if (!chartType.equals("transitions")) break block5;
            if (this.transChartType == 0) {
                return;
            }
            XYPlot plot = this.transitionsChart.getXYPlot();
            int count = this.transitionsChart.getXYPlot().getSeriesCount();
            for (int i = 0; i < count; ++i) {
                plot.getRenderer().setSeriesStroke(i, new BasicStroke(this.chartDetails.t_StrokeWidth));
            }
        }
    }

    public StateSimulator accessSim() {
        return this.ssim;
    }

    private void initiateListeners() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                HolmesSim.this.fillPlacesAndTransitionsData();
                ((HolmesSimKnock)HolmesSim.this.knockoutTab).updateFreshKnockoutTab();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                if (HolmesSim.this.isWorkInProgress()) {
                    JOptionPane.showMessageDialog(HolmesSim.this.ego, "Simulator working. Window closing operation cancelled.", "Simulator working", 1);
                    HolmesSim.this.setDefaultCloseOperation(0);
                } else {
                    HolmesSim.this.setDefaultCloseOperation(1);
                    HolmesSim.this.overlord.getFrame().setEnabled(true);
                }
            }
        });
    }

    public void setWorkInProgress(boolean value) {
        this.workInProgress = value;
    }

    public boolean isWorkInProgress() {
        return this.workInProgress;
    }

    public HolmesSimKnock accessKnockoutTab() {
        return (HolmesSimKnock)this.knockoutTab;
    }

    public void resetSimWindow() {
        this.doNotUpdate = true;
        this.clearTransitionsChart();
        this.clearPlacesChart();
        this.clearAllData();
        this.fillPlacesAndTransitionsData();
        this.transInterval = 100;
        this.placesInterval = 100;
        this.transChartType = 0;
        this.placesChartType = 0;
        int mValue = this.overlord.simSettings.getSimSteps() / 10;
        SpinnerNumberModel intervSpinnerModel = new SpinnerNumberModel(100, 0, mValue, 10);
        this.transIntervalSpinner.setModel(intervSpinnerModel);
        SpinnerNumberModel intervSpinnerModel2 = new SpinnerNumberModel(100, 0, mValue, 10);
        this.placesIntervalSpinner.setModel(intervSpinnerModel2);
        ((HolmesSimKnock)this.knockoutTab).resetWindow();
        this.doNotUpdate = false;
    }

    public void updateIntervalSpinner() {
        int mValue = this.overlord.simSettings.getSimSteps() / 10;
        SpinnerNumberModel intervSpinnerModel = new SpinnerNumberModel(100, 0, mValue, 10);
        this.transIntervalSpinner.setModel(intervSpinnerModel);
        SpinnerNumberModel intervSpinnerModel2 = new SpinnerNumberModel(100, 0, mValue, 10);
        this.placesIntervalSpinner.setModel(intervSpinnerModel2);
    }

    public JFrame getFrame() {
        return this.ego;
    }

    private static class ChartProperties {
        public float p_StrokeWidth = 1.0f;
        public float t_StrokeWidth = 1.0f;
    }

    public static class CustomToolTipPlacesGenerator
    implements CategoryToolTipGenerator {
        ArrayList<Place> places;
        ArrayList<Double> dataVector;
        double max;
        DecimalFormat formatter;

        public CustomToolTipPlacesGenerator(ArrayList<Place> places, ArrayList<Double> dataVector, double max) {
            this.places = places;
            this.dataVector = dataVector;
            this.max = max;
            this.formatter = new DecimalFormat("#.###");
        }

        @Override
        public String generateToolTip(CategoryDataset dataset, int bar, int nodeIndex) {
            Object text = "<html><font size=\"5\">";
            text = (String)text + "p" + nodeIndex + "_" + this.places.get(nodeIndex).getName() + "<br>";
            text = (String)text + "Tokens: " + this.dataVector.get(nodeIndex) + "   (maximum in this simulation: " + this.max + ")";
            text = (String)text + "</font></html>";
            return text;
        }
    }

    public static class CustomToolTipTransGenerator
    implements CategoryToolTipGenerator {
        ArrayList<Transition> transitions;
        ArrayList<Integer> dataVector;
        double max;
        DecimalFormat formatter;

        public CustomToolTipTransGenerator(ArrayList<Transition> transitions, ArrayList<Integer> dataVector, double max) {
            this.transitions = transitions;
            this.dataVector = dataVector;
            this.max = max;
            this.formatter = new DecimalFormat("#.###");
        }

        @Override
        public String generateToolTip(CategoryDataset dataset, int bar, int nodeIndex) {
            Object text = "<html><font size=\"5\">";
            text = (String)text + "t" + nodeIndex + "_" + this.transitions.get(nodeIndex).getName() + "<br>";
            text = (String)text + "Fired: " + this.dataVector.get(nodeIndex) + "   (maximum in this simulation: " + this.max + ")";
            text = (String)text + "</font></html>";
            return text;
        }
    }
}

