/*
 * Decompiled with CFR 0.152.
 */
package holmes.windows.managers;

import holmes.darkgui.GUIController;
import holmes.darkgui.GUIManager;
import holmes.darkgui.holmesInterface.HolmesRoundedButton;
import holmes.petrinet.data.MultisetM;
import holmes.petrinet.data.P_StateManager;
import holmes.petrinet.data.PetriNet;
import holmes.petrinet.data.StatePlacesVector;
import holmes.petrinet.elements.Place;
import holmes.tables.RXTable;
import holmes.tables.managers.StatesPlacesTableModel;
import holmes.tables.managers.StatesPlacesTableModelXTPN;
import holmes.tables.managers.StatesPlacesTableRenderer;
import holmes.tables.managers.StatesPlacesTableRendererXTPN;
import holmes.utilities.Tools;
import holmes.windows.managers.HolmesStatesEditor;
import holmes.windows.xtpn.managers.HolmesStatesEditorXTPN;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;

public class HolmesStatesManager
extends JFrame {
    private static final long serialVersionUID = -4590055483268695118L;
    private final JFrame ego;
    private final GUIManager overlord;
    private StatesPlacesTableModel tableModelPN;
    private StatesPlacesTableModelXTPN tableModelXTPN;
    private JTable statesTablePN;
    private JTable statesTableXTPN;
    private JTextArea stateDescrTextAreaPN;
    private JTextArea stateDescrTextAreaXTPN;
    private final ArrayList<Place> places;
    private final PetriNet pn;
    private final P_StateManager statesManager;
    private int selectedRow;
    private final int cellWidth;

    public HolmesStatesManager() {
        this.setTitle("Holmes p-states states manager");
        try {
            this.setIconImage(Tools.getImageFromIcon("/icons/holmesicon.png"));
        }
        catch (Exception ex) {
            GUIManager.getDefaultGUIManager().log("Error (281108210) | Exception:  " + ex.getMessage(), "error", true);
        }
        this.overlord = GUIManager.getDefaultGUIManager();
        this.ego = this;
        this.pn = this.overlord.getWorkspace().getProject();
        this.places = this.pn.getPlaces();
        this.statesManager = this.pn.accessStatesManager();
        this.selectedRow = 0;
        this.cellWidth = 50;
        this.initalizeComponents();
        this.initiateListeners();
        this.overlord.getFrame().setEnabled(false);
        this.fillTable();
        this.fillTableXTPN();
        this.statesTableXTPN.setRowSelectionInterval(0, 0);
        this.setVisible(true);
    }

    private void initalizeComponents() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(900, 650));
        this.setLocation(50, 50);
        this.setResizable(true);
        this.setLayout(new BorderLayout());
        JPanel main = new JPanel(new BorderLayout());
        JPanel submain = new JPanel(new BorderLayout());
        JPanel tablePanelPN = this.getMainTablePanel();
        submain.add((Component)tablePanelPN, "Center");
        submain.add((Component)this.getBottomPanel(), "South");
        main.add((Component)submain, "Center");
        main.add((Component)this.getButtonsPanel(), "East");
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab("PN p-states", Tools.getResIcon22("/icons/stateManager/PNtab.png"), main, "Petri net, TPN, DPN, SPN");
        tabbedPane.setMnemonicAt(0, 49);
        JPanel mainXTPN = new JPanel(new BorderLayout());
        JPanel submainXTPN = new JPanel(new BorderLayout());
        JPanel tablePanelXTPN = this.getMainTablePanelXTPN();
        submainXTPN.add((Component)tablePanelXTPN, "Center");
        submainXTPN.add((Component)this.getBottomPanelXTPN(), "South");
        mainXTPN.add((Component)submainXTPN, "Center");
        mainXTPN.add((Component)this.getButtonsPanelXTPN(), "East");
        tabbedPane.addTab("XTPN p-states", Tools.getResIcon22("/icons/stateManager/XTPNtab.png"), mainXTPN, "XTPN p-states manager");
        tabbedPane.setMnemonicAt(1, 50);
        this.add((Component)tabbedPane, "Center");
        tabbedPane.addChangeListener(e -> {
            int selected = ((JTabbedPane)e.getSource()).getSelectedIndex();
            if (selected == 1 && GUIController.access().getCurrentNetType() != PetriNet.GlobalNetType.XTPN) {
                JOptionPane.showMessageDialog(null, "XTPN state manager unavailable for normal nets.", "Wrong tab", 1);
                ((JTabbedPane)e.getSource()).setSelectedIndex(0);
            } else if (selected == 0 && GUIController.access().getCurrentNetType() == PetriNet.GlobalNetType.XTPN) {
                JOptionPane.showMessageDialog(null, "Normal state manager unavailable for XTPN nets.", "Wrong tab", 1);
                ((JTabbedPane)e.getSource()).setSelectedIndex(1);
            }
        });
        if (GUIController.access().getCurrentNetType() == PetriNet.GlobalNetType.XTPN) {
            tabbedPane.setSelectedIndex(1);
        }
    }

    public JPanel getMainTablePanel() {
        JPanel result = new JPanel(new BorderLayout());
        result.setLocation(0, 0);
        result.setBorder(BorderFactory.createTitledBorder("p-states table"));
        result.setPreferredSize(new Dimension(500, 500));
        this.tableModelPN = new StatesPlacesTableModel(this.places.size(), this);
        this.statesTablePN = new RXTable(this.tableModelPN);
        ((RXTable)this.statesTablePN).setSelectAllForEdit(true);
        this.statesTablePN.getColumnModel().getColumn(0).setHeaderValue("Sel:");
        this.statesTablePN.getColumnModel().getColumn(0).setPreferredWidth(30);
        this.statesTablePN.getColumnModel().getColumn(0).setMinWidth(30);
        this.statesTablePN.getColumnModel().getColumn(0).setMaxWidth(30);
        this.statesTablePN.getColumnModel().getColumn(1).setHeaderValue("State ID");
        this.statesTablePN.getColumnModel().getColumn(1).setPreferredWidth(50);
        this.statesTablePN.getColumnModel().getColumn(1).setMinWidth(50);
        this.statesTablePN.getColumnModel().getColumn(1).setMaxWidth(50);
        for (int i = 0; i < this.places.size(); ++i) {
            this.statesTablePN.getColumnModel().getColumn(i + 2).setHeaderValue("p" + i);
            this.statesTablePN.getColumnModel().getColumn(i + 2).setPreferredWidth(this.cellWidth);
            this.statesTablePN.getColumnModel().getColumn(i + 2).setMinWidth(this.cellWidth);
            this.statesTablePN.getColumnModel().getColumn(i + 2).setMaxWidth(this.cellWidth);
        }
        this.statesTablePN.setName("StatesTable");
        this.statesTablePN.setFillsViewportHeight(true);
        StatesPlacesTableRenderer tableRendererPN = new StatesPlacesTableRenderer(this.statesTablePN);
        this.statesTablePN.setDefaultRenderer(Object.class, tableRendererPN);
        this.statesTablePN.setDefaultRenderer(Double.class, tableRendererPN);
        this.statesTablePN.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 1 && !e.isControlDown()) {
                    HolmesStatesManager.this.cellClickAction();
                }
            }
        });
        this.statesTablePN.setRowSelectionAllowed(false);
        this.statesTablePN.setAutoResizeMode(0);
        JScrollPane tableScrollPane = new JScrollPane(this.statesTablePN, 20, 30);
        result.add((Component)tableScrollPane, "Center");
        return result;
    }

    public JPanel getButtonsPanel() {
        JPanel result = new JPanel(null);
        result.setBorder(BorderFactory.createTitledBorder("Buttons"));
        result.setPreferredSize(new Dimension(150, 500));
        int posXda = 10;
        int posYda = 25;
        JButton selectStateButton = new JButton("Set net state");
        selectStateButton.setBounds(posXda, posYda, 130, 40);
        selectStateButton.setMargin(new Insets(0, 0, 0, 0));
        selectStateButton.setFocusPainted(false);
        selectStateButton.setToolTipText("Sets selected state as the active one and changes number of tokens in\nnet places according to values of the selected state.");
        selectStateButton.setIcon(Tools.getResIcon16("/icons/stateManager/selectStateIcon.png"));
        selectStateButton.addActionListener(actionEvent -> {
            if (this.places.size() == 0) {
                this.noNetInfo();
                return;
            }
            int selected = this.statesTablePN.getSelectedRow();
            if (selected == -1) {
                JOptionPane.showMessageDialog(null, "Please select state from the table.", "Selection problem", 1);
            }
            Object[] options = new Object[]{"Set new state", "Keep current state"};
            int n = JOptionPane.showOptionDialog(null, "Set all places of the net according to the selected (table row: " + (selected + 1) + ") state?", "Setting new state", 0, 3, null, options, options[1]);
            if (n == 0) {
                this.tableModelPN.setSelected(selected);
                this.statesManager.setNetworkStatePN(selected);
                this.pn.repaintAllGraphPanels();
                this.tableModelPN.fireTableDataChanged();
                this.overlord.markNetChange();
            }
        });
        result.add(selectStateButton);
        JButton addNewStateButton = new JButton("<html>Add current<br/>&nbsp;&nbsp;net state</html>");
        addNewStateButton.setBounds(posXda, posYda += 50, 130, 40);
        addNewStateButton.setMargin(new Insets(0, 0, 0, 0));
        addNewStateButton.setFocusPainted(false);
        addNewStateButton.setToolTipText("Create new state vector based on current net state (distribution of tokens in places)");
        addNewStateButton.setIcon(Tools.getResIcon16("/icons/stateManager/addStateIcon.png"));
        addNewStateButton.addActionListener(actionEvent -> {
            if (this.places.size() == 0) {
                this.noNetInfo();
                return;
            }
            Object[] options = new Object[]{"Add new state", "Cancel"};
            int n = JOptionPane.showOptionDialog(null, "Add current net state to states table?", "Adding new state", 0, 3, null, options, options[1]);
            if (n == 0) {
                this.statesManager.addCurrentStatePN();
                this.addLastStateToTable();
                this.tableModelPN.fireTableDataChanged();
            }
        });
        result.add(addNewStateButton);
        JButton addNewCleanStateButton = new JButton("<html>Create new<br/>state vector</html>");
        addNewCleanStateButton.setBounds(posXda, posYda += 50, 130, 40);
        addNewCleanStateButton.setMargin(new Insets(0, 0, 0, 0));
        addNewCleanStateButton.setFocusPainted(false);
        addNewCleanStateButton.setToolTipText("Create new and clean state vector (all tokens values set to 0).");
        addNewCleanStateButton.setIcon(Tools.getResIcon16("/icons/stateManager/addCleanState.png"));
        addNewCleanStateButton.addActionListener(actionEvent -> {
            if (this.places.size() == 0) {
                this.noNetInfo();
                return;
            }
            Object[] options = new Object[]{"Add new state", "Cancel"};
            int n = JOptionPane.showOptionDialog(null, "Add clean net state to states table?", "Adding new clean state", 0, 3, null, options, options[1]);
            if (n == 0) {
                this.statesManager.addNewCleanStatePN();
                this.addLastStateToTable();
                this.tableModelPN.fireTableDataChanged();
            }
        });
        result.add(addNewCleanStateButton);
        JButton replaceStateButton = new JButton("<html>&nbsp;&nbsp;&nbsp;&nbsp;Replace&nbsp;<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;state&nbsp;</html>");
        replaceStateButton.setBounds(posXda, posYda += 50, 130, 40);
        replaceStateButton.setMargin(new Insets(0, 0, 0, 0));
        replaceStateButton.setFocusPainted(false);
        replaceStateButton.setToolTipText("Replace the values of the selected state from the table with the current net places values.");
        replaceStateButton.setIcon(Tools.getResIcon16("/icons/stateManager/replaceStateIcon.png"));
        replaceStateButton.addActionListener(actionEvent -> {
            if (this.places.size() == 0) {
                this.noNetInfo();
                return;
            }
            int selected = this.statesTablePN.getSelectedRow();
            if (selected == -1) {
                JOptionPane.showMessageDialog(null, "Please select state from the table.", "Selection problem", 1);
            }
            this.replaceStateAction();
        });
        result.add(replaceStateButton);
        JButton removeStateButton = new JButton("<html>&nbsp;&nbsp;&nbsp;Remove&nbsp;&nbsp;<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;state&nbsp;&nbsp;</html>");
        removeStateButton.setBounds(posXda, posYda += 50, 130, 40);
        removeStateButton.setMargin(new Insets(0, 0, 0, 0));
        removeStateButton.setFocusPainted(false);
        removeStateButton.setToolTipText("Removes state vector from project data.");
        removeStateButton.setIcon(Tools.getResIcon16("/icons/stateManager/removeStateIcon.png"));
        removeStateButton.addActionListener(actionEvent -> {
            if (this.places.size() == 0) {
                this.noNetInfo();
                return;
            }
            int selected = this.statesTablePN.getSelectedRow();
            if (selected == -1) {
                JOptionPane.showMessageDialog(null, "Please select state from the table.", "Selection problem", 1);
            }
            this.removeStateAction();
        });
        result.add(removeStateButton);
        JButton editStateButton = new JButton("<html>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Edit&nbsp;&nbsp;&nbsp;&nbsp;<br/>state vector</html>");
        editStateButton.setBounds(posXda, posYda += 50, 130, 40);
        editStateButton.setMargin(new Insets(0, 0, 0, 0));
        editStateButton.setFocusPainted(false);
        editStateButton.setIcon(Tools.getResIcon32("/icons/stateManager/stateEdit.png"));
        editStateButton.addActionListener(actionEvent -> {
            if (this.places.size() == 0) {
                this.noNetInfo();
                return;
            }
            int selected = this.statesTablePN.getSelectedRow();
            if (selected > -1) {
                new HolmesStatesEditor((HolmesStatesManager)this.ego, this.statesManager.getStatePN(selected), selected);
            } else {
                JOptionPane.showMessageDialog(null, "Please select state from the table.", "Selection problem", 1);
            }
        });
        result.add(editStateButton);
        return result;
    }

    private void noNetInfo() {
        JOptionPane.showMessageDialog(this, "There are no places in the net!", "No net", 2);
    }

    private void removeStateAction() {
        int selected = this.statesTablePN.getSelectedRow();
        int states = this.statesManager.accessStateMatrix().size();
        if (states == 1) {
            JOptionPane.showMessageDialog(null, "At least one net state must remain!", "Warning", 2);
            return;
        }
        Object[] options = new Object[]{"Remove state", "Cancel"};
        int n = JOptionPane.showOptionDialog(null, "Remove selected state (table row: " + (selected + 1) + ") from the states table?", "Removing state", 0, 3, null, options, options[1]);
        if (n == 1) {
            return;
        }
        this.statesManager.removeStatePN(selected);
        this.fillTable();
        this.overlord.markNetChange();
    }

    private void replaceStateAction() {
        int selected = this.statesTablePN.getSelectedRow();
        Object[] options = new Object[]{"Replace state", "Cancel"};
        int n = JOptionPane.showOptionDialog(null, "Replace selected state (table row: " + (selected + 1) + ") with the current net state?", "Replacing state", 0, 3, null, options, options[1]);
        if (n == 1) {
            return;
        }
        this.statesManager.replaceStoredStateWithNetStatePN(selected);
        this.fillTable();
        this.overlord.markNetChange();
    }

    public void changeTableCell(int index, int placeID, double newValue, boolean update) {
        this.tableModelPN.setQuietlyValueAt(newValue, index, placeID);
        if (update) {
            this.tableModelPN.fireTableDataChanged();
        }
    }

    private void addLastStateToTable() {
        int states = this.statesManager.accessStateMatrix().size();
        StatePlacesVector psVector = this.statesManager.getStatePN(states - 1);
        ArrayList<String> rowVector = new ArrayList<String>();
        rowVector.add("");
        rowVector.add("m0(" + states + ")");
        for (int p = 0; p < psVector.getSize(); ++p) {
            rowVector.add("" + psVector.getTokens(p));
        }
        this.tableModelPN.addNew(rowVector);
        this.overlord.markNetChange();
    }

    private void fillTable() {
        this.tableModelPN.clearModel(this.places.size());
        for (int row = 0; row < this.statesManager.accessStateMatrix().size(); ++row) {
            ArrayList<String> rowVector = new ArrayList<String>();
            if (this.statesManager.selectedStatePN == row) {
                rowVector.add("X");
            } else {
                rowVector.add("");
            }
            StatePlacesVector psVector = this.statesManager.getStatePN(row);
            rowVector.add("m0(" + (row + 1) + ")");
            for (int p = 0; p < psVector.getSize(); ++p) {
                rowVector.add("" + psVector.getTokens(p));
            }
            this.tableModelPN.addNew(rowVector);
        }
        this.tableModelPN.fireTableDataChanged();
    }

    public JPanel getBottomPanel() {
        JPanel result = new JPanel(new BorderLayout());
        result.setBorder(BorderFactory.createTitledBorder("State description:"));
        result.setPreferredSize(new Dimension(900, 150));
        int posXda = 10;
        int posYda = 15;
        this.stateDescrTextAreaPN = new JTextArea();
        this.stateDescrTextAreaPN.setLineWrap(true);
        this.stateDescrTextAreaPN.setEditable(true);
        this.stateDescrTextAreaPN.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                JTextArea field = (JTextArea)e.getSource();
                if (field != null) {
                    String newComment = field.getText();
                    HolmesStatesManager.this.statesManager.setStateDescriptionPN(HolmesStatesManager.this.selectedRow, newComment);
                }
            }
        });
        JPanel CreationPanel = new JPanel();
        CreationPanel.setLayout(new BorderLayout());
        CreationPanel.add((Component)new JScrollPane(this.stateDescrTextAreaPN), "Center");
        CreationPanel.setBounds(posXda, posYda + 25, 600, 100);
        result.add((Component)CreationPanel, "Center");
        return result;
    }

    public void changeState(int row, int column, double value) {
        this.statesManager.getStatePN(row).accessVector().set(column - 2, value);
        this.overlord.markNetChange();
        this.tableModelPN.fireTableDataChanged();
    }

    public void fillDescriptionField() {
        String description = this.statesManager.getStateDescriptionPN(this.selectedRow);
        this.stateDescrTextAreaPN.setText(description);
    }

    protected void cellClickAction() {
        try {
            this.selectedRow = this.statesTablePN.getSelectedRow();
            this.fillDescriptionField();
        }
        catch (Exception ex) {
            GUIManager.getDefaultGUIManager().log("Error (581229108) | Exception:  " + ex.getMessage(), "error", true);
        }
    }

    public JPanel getMainTablePanelXTPN() {
        JPanel result = new JPanel(new BorderLayout());
        result.setLocation(0, 0);
        result.setBorder(BorderFactory.createTitledBorder("p-states table"));
        result.setPreferredSize(new Dimension(500, 500));
        this.tableModelXTPN = new StatesPlacesTableModelXTPN(this.places.size(), this);
        this.statesTableXTPN = new RXTable(this.tableModelXTPN);
        ((RXTable)this.statesTableXTPN).setSelectAllForEdit(true);
        this.statesTableXTPN.getColumnModel().getColumn(0).setHeaderValue("Sel:");
        this.statesTableXTPN.getColumnModel().getColumn(0).setPreferredWidth(30);
        this.statesTableXTPN.getColumnModel().getColumn(0).setMinWidth(30);
        this.statesTableXTPN.getColumnModel().getColumn(0).setMaxWidth(30);
        this.statesTableXTPN.getColumnModel().getColumn(1).setHeaderValue("State ID");
        this.statesTableXTPN.getColumnModel().getColumn(1).setPreferredWidth(50);
        this.statesTableXTPN.getColumnModel().getColumn(1).setMinWidth(50);
        this.statesTableXTPN.getColumnModel().getColumn(1).setMaxWidth(50);
        for (int i = 0; i < this.places.size(); ++i) {
            this.statesTableXTPN.getColumnModel().getColumn(i + 2).setHeaderValue("p" + i);
            this.statesTableXTPN.getColumnModel().getColumn(i + 2).setPreferredWidth(this.cellWidth);
            this.statesTableXTPN.getColumnModel().getColumn(i + 2).setMinWidth(this.cellWidth);
            this.statesTableXTPN.getColumnModel().getColumn(i + 2).setMaxWidth(this.cellWidth);
        }
        this.statesTableXTPN.setName("XTPNStatesTable");
        this.statesTableXTPN.setFillsViewportHeight(true);
        StatesPlacesTableRendererXTPN tableRendererXTPN = new StatesPlacesTableRendererXTPN(this.statesTableXTPN);
        this.statesTableXTPN.setDefaultRenderer(Object.class, tableRendererXTPN);
        this.statesTableXTPN.setDefaultRenderer(Double.class, tableRendererXTPN);
        this.statesTableXTPN.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 1 && !e.isControlDown()) {
                    HolmesStatesManager.this.cellClickActionXTPN();
                }
            }
        });
        this.statesTableXTPN.setRowSelectionAllowed(false);
        this.statesTableXTPN.setAutoResizeMode(0);
        JScrollPane tableScrollPane = new JScrollPane(this.statesTableXTPN, 20, 30);
        result.add((Component)tableScrollPane, "Center");
        return result;
    }

    public JPanel getButtonsPanelXTPN() {
        JPanel result = new JPanel(null);
        result.setBorder(BorderFactory.createTitledBorder("Buttons"));
        result.setPreferredSize(new Dimension(150, 500));
        int posXda = 10;
        int posYda = 25;
        HolmesRoundedButton selectStateButton = new HolmesRoundedButton("<html><center>Restore<br>selected state</center></html>", "pearl_bH1_neutr.png", "pearl_bH2_hover.png", "pearl_bH3_press.png");
        selectStateButton.setBounds(posXda, posYda, 130, 40);
        selectStateButton.setMargin(new Insets(0, 0, 0, 0));
        selectStateButton.setFocusPainted(false);
        selectStateButton.setToolTipText("<html>Use selected XTPN p-state as the active one and change number of tokens in<br>all net places according to values of the selected p-state.<html>");
        selectStateButton.addActionListener(actionEvent -> {
            if (this.places.size() == 0) {
                this.noNetInfoXTPN();
                return;
            }
            int selected = this.statesTableXTPN.getSelectedRow();
            if (selected == -1) {
                JOptionPane.showMessageDialog(null, "Please select state from the table.", "Selection problem", 1);
                return;
            }
            Object[] options = new Object[]{"Set new state", "Keep current state"};
            int n = JOptionPane.showOptionDialog(null, "Set all places of the net according to the selected (table row: " + (selected + 1) + ") p-state?", "Setting new state", 0, 3, null, options, options[1]);
            if (n == 0) {
                this.tableModelXTPN.setSelected(selected);
                boolean status = this.statesManager.replaceNetStateWithSelectedMultiset_M(selected);
                if (status) {
                    this.pn.repaintAllGraphPanels();
                    this.tableModelXTPN.fireTableDataChanged();
                    this.overlord.markNetChange();
                } else {
                    JOptionPane.showMessageDialog(this, "Selected state corrupted, operation cancelled.", "Error", 0);
                }
            }
        });
        result.add(selectStateButton);
        HolmesRoundedButton addNewStateButton = new HolmesRoundedButton("<html><center>Store current<br>net state</center></html>", "pearl_bH1_neutr.png", "pearl_bH2_hover.png", "pearl_bH3_press.png");
        addNewStateButton.setBounds(posXda, posYda += 50, 130, 40);
        addNewStateButton.setMargin(new Insets(0, 0, 0, 0));
        addNewStateButton.setFocusPainted(false);
        addNewStateButton.setToolTipText("Store current XTPN net p-state as a state vector.");
        addNewStateButton.addActionListener(actionEvent -> {
            if (this.places.size() == 0) {
                this.noNetInfoXTPN();
                return;
            }
            Object[] options = new Object[]{"Add new XTPN state", "Cancel"};
            int n = JOptionPane.showOptionDialog(null, "Remember current XTPN p-state?", "New state", 0, 3, null, options, options[1]);
            if (n == 0) {
                this.statesManager.createNewMultiset_M_basedOnNet();
                this.addLastStateToTableXTPN();
                this.tableModelXTPN.fireTableDataChanged();
            }
        });
        result.add(addNewStateButton);
        HolmesRoundedButton addNewCleanStateButton = new HolmesRoundedButton("<html><center>Create<br>clean state</center></html>", "pearl_bH1_neutr.png", "pearl_bH2_hover.png", "pearl_bH3_press.png");
        addNewCleanStateButton.setBounds(posXda, posYda += 50, 130, 40);
        addNewCleanStateButton.setMargin(new Insets(0, 0, 0, 0));
        addNewCleanStateButton.setFocusPainted(false);
        addNewCleanStateButton.setToolTipText("Create new clean p-state vector (no tokens, clean multisets).");
        addNewCleanStateButton.addActionListener(actionEvent -> {
            if (this.places.size() == 0) {
                this.noNetInfoXTPN();
                return;
            }
            Object[] options = new Object[]{"Add new XTPN state", "Cancel"};
            int n = JOptionPane.showOptionDialog(null, "Add clean XTPN net state to states table?", "New clean state", 0, 3, null, options, options[1]);
            if (n == 0) {
                this.statesManager.addNewCleanMultiset_M();
                this.addLastStateToTableXTPN();
                this.tableModelXTPN.fireTableDataChanged();
            }
        });
        result.add(addNewCleanStateButton);
        HolmesRoundedButton replaceStateButton = new HolmesRoundedButton("<html><center>Overwrite<br>selected state</center></html>", "pearl_bH1_neutr.png", "pearl_bH2_hover.png", "pearl_bH3_press.png");
        replaceStateButton.setBounds(posXda, posYda += 50, 130, 40);
        replaceStateButton.setMargin(new Insets(0, 0, 0, 0));
        replaceStateButton.setFocusPainted(false);
        replaceStateButton.setToolTipText("<html>Replace the values of the selected XTPN p-state from the table<br>with the current XTPN net p-state.</html>");
        replaceStateButton.addActionListener(actionEvent -> {
            if (this.places.size() == 0) {
                this.noNetInfoXTPN();
                return;
            }
            int selected = this.statesTableXTPN.getSelectedRow();
            if (selected == -1) {
                JOptionPane.showMessageDialog(null, "Please select state from the table.", "Selection problem", 1);
            } else {
                this.replaceStateActionXTPN();
            }
        });
        result.add(replaceStateButton);
        HolmesRoundedButton removeStateButton = new HolmesRoundedButton("<html><center>Remove<br>stored state</center></html>", "pearl_bH1_neutr.png", "pearl_bH2_hover.png", "pearl_bH3_press.png");
        removeStateButton.setBounds(posXda, posYda += 50, 130, 40);
        removeStateButton.setMargin(new Insets(0, 0, 0, 0));
        removeStateButton.setFocusPainted(false);
        removeStateButton.setToolTipText("Removes XTPN p-state vector from the project data.");
        removeStateButton.addActionListener(actionEvent -> {
            if (this.places.size() == 0) {
                this.noNetInfoXTPN();
                return;
            }
            int selected = this.statesTableXTPN.getSelectedRow();
            if (selected == -1) {
                JOptionPane.showMessageDialog(null, "Please select p-state from the table.", "Selection problem", 1);
            } else {
                this.removeStateActionXTPN();
            }
        });
        result.add(removeStateButton);
        HolmesRoundedButton editStateButton = new HolmesRoundedButton("<html><center>XTPN<br>state editor</center></html>", "pearl_bH1_neutr.png", "pearl_bH2_hover.png", "pearl_bH3_press.png");
        editStateButton.setBounds(posXda, posYda + 50, 130, 40);
        editStateButton.setMargin(new Insets(0, 0, 0, 0));
        editStateButton.setFocusPainted(false);
        editStateButton.setToolTipText("Opens p-state editor window based on the currently selected p-state.");
        editStateButton.addActionListener(actionEvent -> {
            if (this.places.size() == 0) {
                this.noNetInfoXTPN();
                return;
            }
            int selected = this.statesTableXTPN.getSelectedRow();
            if (selected > -1) {
                new HolmesStatesEditorXTPN((HolmesStatesManager)this.ego, this.statesManager.getMultiset_M(selected), selected);
            } else {
                JOptionPane.showMessageDialog(this.ego, "Please click on any XTPN p-state row.", "No XTPN p-state selected", 2);
            }
        });
        result.add(editStateButton);
        return result;
    }

    private void noNetInfoXTPN() {
        JOptionPane.showMessageDialog(this, "There are no places in the net.", "No places", 0);
    }

    private void removeStateActionXTPN() {
        int selected = this.statesTableXTPN.getSelectedRow();
        int states = this.statesManager.accessStateMatrixXTPN().size();
        if (states == 1) {
            JOptionPane.showMessageDialog(null, "At least one XTPN net state must remain.", "Warning", 2);
            return;
        }
        Object[] options = new Object[]{"Remove XTPN state", "Cancel"};
        int n = JOptionPane.showOptionDialog(null, "Remove selected XTPN state (table row: " + (selected + 1) + ") from the states table?", "Remove XTPN state", 0, 3, null, options, options[1]);
        if (n == 1) {
            return;
        }
        this.statesManager.removeMultiset_M(selected);
        this.fillTableXTPN();
        this.overlord.markNetChange();
    }

    private void replaceStateActionXTPN() {
        int selected = this.statesTableXTPN.getSelectedRow();
        if (selected == -1) {
            JOptionPane.showMessageDialog(null, "Please select state from the table.", "Selection problem", 1);
            return;
        }
        Object[] options = new Object[]{"Replace XTPN state", "Cancel"};
        int n = JOptionPane.showOptionDialog(null, "Replace selected XTPN state (table row: " + (selected + 1) + ") with the current net state?", "Replace XTPN state", 0, 3, null, options, options[1]);
        if (n == 1) {
            return;
        }
        this.statesManager.replaceStoredMultiset_M_withCurrentNetState(selected);
        this.fillTableXTPN();
        this.overlord.markNetChange();
    }

    public void changeTableCellXTPN(int index, int placeID, double newValue, boolean update) {
        this.tableModelXTPN.setQuietlyValueAt(newValue, index, placeID);
        if (update) {
            this.tableModelXTPN.fireTableDataChanged();
        }
    }

    private void addLastStateToTableXTPN() {
        int states = this.statesManager.accessStateMatrixXTPN().size();
        MultisetM multisetM = this.statesManager.getMultiset_M(states - 1);
        ArrayList<String> rowVector = new ArrayList<String>();
        rowVector.add("");
        rowVector.add("m0(" + states + ")");
        for (int p = 0; p < multisetM.getMultiset_M_Size(); ++p) {
            if (multisetM.isPlaceStoredAsGammaActive(p)) {
                int value = multisetM.accessMultiset_K(p).size();
                rowVector.add("" + value);
                continue;
            }
            double value = multisetM.accessMultiset_K(p).get(0);
            rowVector.add((int)value + " (C)");
        }
        this.tableModelXTPN.addNew(rowVector);
        this.overlord.markNetChange();
    }

    private void fillTableXTPN() {
        this.tableModelXTPN.clearModel(this.places.size());
        for (int row = 0; row < this.statesManager.accessStateMatrixXTPN().size(); ++row) {
            ArrayList<String> rowVector = new ArrayList<String>();
            if (this.statesManager.selectedStateXTPN == row) {
                rowVector.add("X");
            } else {
                rowVector.add("");
            }
            MultisetM multisetM = this.statesManager.getMultiset_M(row);
            rowVector.add("m0(" + (row + 1) + ")");
            for (int placeIndex = 0; placeIndex < multisetM.getMultiset_M_Size(); ++placeIndex) {
                if (multisetM.isPlaceStoredAsGammaActive(placeIndex)) {
                    int value = multisetM.accessMultiset_K(placeIndex).size();
                    rowVector.add("" + value);
                    continue;
                }
                double value = multisetM.accessMultiset_K(placeIndex).get(0);
                rowVector.add((int)value + " (C)");
            }
            this.tableModelXTPN.addNew(rowVector);
        }
        this.tableModelXTPN.fireTableDataChanged();
    }

    public JPanel getBottomPanelXTPN() {
        JPanel result = new JPanel(new BorderLayout());
        result.setBorder(BorderFactory.createTitledBorder("XTPN state description:"));
        result.setPreferredSize(new Dimension(900, 150));
        int posXda = 10;
        int posYda = 15;
        this.stateDescrTextAreaXTPN = new JTextArea();
        this.stateDescrTextAreaXTPN.setLineWrap(true);
        this.stateDescrTextAreaXTPN.setEditable(true);
        this.stateDescrTextAreaXTPN.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                JTextArea field = (JTextArea)e.getSource();
                if (field != null) {
                    String newComment = field.getText();
                    HolmesStatesManager.this.statesManager.setMultiset_M_Description(HolmesStatesManager.this.selectedRow, newComment);
                }
            }
        });
        JPanel CreationPanel = new JPanel();
        CreationPanel.setLayout(new BorderLayout());
        CreationPanel.add((Component)new JScrollPane(this.stateDescrTextAreaXTPN), "Center");
        CreationPanel.setBounds(posXda, posYda + 25, 600, 100);
        result.add((Component)CreationPanel, "Center");
        return result;
    }

    public void changeStateXTPN(int row, int column, double value) {
        this.tableModelXTPN.fireTableDataChanged();
    }

    public void fillDescriptionFieldXTPN() {
        String description = this.statesManager.getMultiset_M_Description(this.selectedRow);
        this.stateDescrTextAreaXTPN.setText(description);
    }

    protected void cellClickActionXTPN() {
        try {
            this.selectedRow = this.statesTableXTPN.getSelectedRow();
            this.fillDescriptionFieldXTPN();
        }
        catch (Exception ex) {
            GUIManager.getDefaultGUIManager().log("Error (164166738) | Exception:  " + ex.getMessage(), "error", true);
        }
    }

    private void initiateListeners() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                HolmesStatesManager.this.overlord.getFrame().setEnabled(true);
            }
        });
    }
}

