/*
 * Decompiled with CFR 0.152.
 */
package holmes.windows.managers;

import holmes.darkgui.GUIManager;
import holmes.petrinet.data.PetriNet;
import holmes.petrinet.data.SSAplacesManager;
import holmes.petrinet.data.SSAplacesVector;
import holmes.petrinet.elements.Place;
import holmes.tables.managers.SSAplacesTableModel;
import holmes.tables.managers.SSAplacesTableRenderer;
import holmes.utilities.Tools;
import holmes.windows.managers.HolmesSSAplacesEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;

public class HolmesSSAwindowManager
extends JFrame {
    private static final long serialVersionUID = 8184934957669150556L;
    private GUIManager overlord;
    private JFrame parentWindow;
    private JFrame ego;
    private SSAplacesTableModel tableModel;
    private JTable table;
    private JTextArea vectorDescrTextArea;
    private ArrayList<Place> places;
    private SSAplacesManager ssaManager;
    private boolean doNotUpdate = false;
    private JComboBox<String> typeCombo;
    private int selectedRow;

    public HolmesSSAwindowManager(JFrame parent) {
        this.setTitle("Holmes SSA vectors manager");
        try {
            this.setIconImage(Tools.getImageFromIcon("/icons/holmesicon.png"));
        }
        catch (Exception ex) {
            GUIManager.getDefaultGUIManager().log("Error (151044901) | Exception:  " + ex.getMessage(), "error", true);
        }
        this.overlord = GUIManager.getDefaultGUIManager();
        PetriNet pn = this.overlord.getWorkspace().getProject();
        this.ego = this;
        this.parentWindow = parent;
        this.places = pn.getPlaces();
        this.ssaManager = pn.accessSSAmanager();
        this.selectedRow = 0;
        this.initalizeComponents();
        this.initiateListeners();
        this.fillTable();
        this.setVisible(true);
        this.parentWindow.setEnabled(false);
        this.setDefaultCloseOperation(2);
    }

    public JPanel getMainTablePanel() {
        JPanel result = new JPanel(new BorderLayout());
        result.setLocation(0, 0);
        result.setBorder(BorderFactory.createTitledBorder("SSA vectors table"));
        result.setPreferredSize(new Dimension(500, 500));
        this.tableModel = new SSAplacesTableModel();
        this.table = new JTable(this.tableModel);
        this.table.getColumnModel().getColumn(0).setHeaderValue("Sel.");
        this.table.getColumnModel().getColumn(0).setPreferredWidth(40);
        this.table.getColumnModel().getColumn(0).setMinWidth(40);
        this.table.getColumnModel().getColumn(0).setMaxWidth(40);
        this.table.getColumnModel().getColumn(1).setHeaderValue("ID");
        this.table.getColumnModel().getColumn(1).setPreferredWidth(30);
        this.table.getColumnModel().getColumn(1).setMinWidth(30);
        this.table.getColumnModel().getColumn(1).setMaxWidth(30);
        this.table.getColumnModel().getColumn(2).setHeaderValue("Vector description");
        this.table.getColumnModel().getColumn(2).setMinWidth(50);
        this.table.getColumnModel().getColumn(3).setHeaderValue("Data type");
        this.table.getColumnModel().getColumn(3).setPreferredWidth(120);
        this.table.getColumnModel().getColumn(3).setMinWidth(120);
        this.table.getColumnModel().getColumn(3).setMaxWidth(120);
        this.table.getColumnModel().getColumn(4).setHeaderValue("Volume");
        this.table.getColumnModel().getColumn(4).setPreferredWidth(50);
        this.table.getColumnModel().getColumn(4).setMinWidth(50);
        this.table.getColumnModel().getColumn(4).setMaxWidth(50);
        this.table.setName("SSAvectorsTable");
        this.table.setFillsViewportHeight(true);
        SSAplacesTableRenderer tableRenderer = new SSAplacesTableRenderer();
        this.table.setDefaultRenderer(Object.class, tableRenderer);
        this.table.setDefaultRenderer(String.class, tableRenderer);
        this.table.setDefaultRenderer(Double.class, tableRenderer);
        this.table.setDefaultRenderer(Integer.class, tableRenderer);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 1 && !e.isControlDown()) {
                    HolmesSSAwindowManager.this.cellClickAction();
                }
            }
        });
        this.table.setRowSelectionAllowed(false);
        this.table.setAutoResizeMode(4);
        JScrollPane tableScrollPane = new JScrollPane(this.table, 20, 30);
        result.add((Component)tableScrollPane, "Center");
        return result;
    }

    private void initalizeComponents() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(900, 650));
        this.setLocation(50, 50);
        this.setResizable(true);
        this.setLayout(new BorderLayout());
        JPanel main = new JPanel(new BorderLayout());
        JPanel submain = new JPanel(new BorderLayout());
        JPanel tablePanel = this.getMainTablePanel();
        submain.add((Component)tablePanel, "Center");
        submain.add((Component)this.getBottomPanel(), "South");
        main.add((Component)submain, "Center");
        main.add((Component)this.getButtonsPanel(), "East");
        this.add((Component)main, "Center");
    }

    public void changeState(int row, int column, String value) {
    }

    public JPanel getButtonsPanel() {
        JPanel result = new JPanel(null);
        result.setBorder(BorderFactory.createTitledBorder("Buttons"));
        result.setPreferredSize(new Dimension(150, 500));
        int posXda = 10;
        int posYda = 25;
        JButton selectStateButton = new JButton("<html>Select SSA<br>&nbsp;&nbsp;&nbsp;&nbsp;vector&nbsp;&nbsp;&nbsp;&nbsp;</html>");
        selectStateButton.setBounds(posXda, posYda, 130, 40);
        selectStateButton.setMargin(new Insets(0, 0, 0, 0));
        selectStateButton.setFocusPainted(false);
        selectStateButton.setIcon(Tools.getResIcon16("/icons/ssaWindow/selectSSAVectorIcon.png"));
        selectStateButton.addActionListener(actionEvent -> {
            if (this.places.size() == 0) {
                this.noNetInfo();
                return;
            }
            int selected = this.table.getSelectedRow();
            if (selected == -1) {
                return;
            }
            Object[] options = new Object[]{"Set new SSA values", "Keep old ones"};
            int n = JOptionPane.showOptionDialog(null, "Set all places of the net according to the selected\nSSA vector (table row: " + selected + ") ?", "Set new particles values?", 0, 2, null, options, options[1]);
            if (n == 0) {
                this.ssaManager.setNetworkSSAvector(selected);
                this.tableModel.setSelected(selected);
                this.tableModel.fireTableDataChanged();
            }
        });
        result.add(selectStateButton);
        JButton addNewStateButton = new JButton("<html>Add current<br/>SSA values</html>");
        addNewStateButton.setBounds(posXda, posYda += 50, 130, 40);
        addNewStateButton.setMargin(new Insets(0, 0, 0, 0));
        addNewStateButton.setFocusPainted(false);
        addNewStateButton.setIcon(Tools.getResIcon16("/icons/ssaWindow/addSSAVectorIcon.png"));
        addNewStateButton.addActionListener(actionEvent -> {
            if (this.places.size() == 0) {
                this.noNetInfo();
                return;
            }
            Object[] options = new Object[]{"Add new vector", "Cancel"};
            int n = JOptionPane.showOptionDialog(null, "Remember current SSA particle numbers in the table?", "Add new SSA vactor?", 0, 2, null, options, options[1]);
            if (n == 0) {
                this.ssaManager.addCurrentStateAsSSAvector();
                this.addLastStateToTable();
                this.tableModel.fireTableDataChanged();
            }
        });
        result.add(addNewStateButton);
        JButton replaceStateButton = new JButton("<html>&nbsp;&nbsp;&nbsp;Replace&nbsp;<br/>SSA values</html>");
        replaceStateButton.setBounds(posXda, posYda += 50, 130, 40);
        replaceStateButton.setMargin(new Insets(0, 0, 0, 0));
        replaceStateButton.setFocusPainted(false);
        replaceStateButton.setIcon(Tools.getResIcon16("/icons/ssaWindow/replaceSSAVectorIcon.png"));
        replaceStateButton.addActionListener(actionEvent -> {
            if (this.places.size() == 0) {
                this.noNetInfo();
                return;
            }
            this.replaceStateAction();
        });
        result.add(replaceStateButton);
        JButton removeStateButton = new JButton("<html>&nbsp;&nbsp;&nbsp;Remove&nbsp;&nbsp;<br/>SSA vector</html>");
        removeStateButton.setBounds(posXda, posYda += 50, 130, 40);
        removeStateButton.setMargin(new Insets(0, 0, 0, 0));
        removeStateButton.setFocusPainted(false);
        removeStateButton.setIcon(Tools.getResIcon16("/icons/ssaWindow/removeSSAVectorIcon.png"));
        removeStateButton.addActionListener(actionEvent -> {
            if (this.places.size() == 0) {
                this.noNetInfo();
                return;
            }
            this.removeStateAction();
        });
        result.add(removeStateButton);
        JButton editStateButton = new JButton("<html>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Edit&nbsp;&nbsp;&nbsp;&nbsp;<br/>SSA vector</html>");
        editStateButton.setBounds(posXda, posYda += 50, 130, 40);
        editStateButton.setMargin(new Insets(0, 0, 0, 0));
        editStateButton.setFocusPainted(false);
        editStateButton.setIcon(Tools.getResIcon32("/icons/ssaWindow/ssaEditor.png"));
        editStateButton.addActionListener(actionEvent -> {
            if (this.places.size() == 0) {
                this.noNetInfo();
                return;
            }
            int selected = this.table.getSelectedRow();
            if (selected > -1) {
                new HolmesSSAplacesEditor(this.ego, this.ssaManager.getSSAvector(selected), selected);
            }
        });
        result.add(editStateButton);
        return result;
    }

    private void removeStateAction() {
        int selected = this.table.getSelectedRow();
        int states = this.ssaManager.accessSSAmatrix().size();
        if (states == 1) {
            JOptionPane.showMessageDialog(null, "At least one SSA vector must remain!", "Cannot delete!", 2);
            return;
        }
        Object[] options = new Object[]{"Remove SSA vector", "Cancel"};
        int n = JOptionPane.showOptionDialog(null, "Remove selected SSA vector from the table\n(table row: " + selected + ") ?", "Remove SSA vector?", 0, 2, null, options, options[1]);
        if (n == 1) {
            return;
        }
        this.ssaManager.removeSSAvector(selected);
        this.fillTable();
        this.overlord.markNetChange();
    }

    private void noNetInfo() {
        JOptionPane.showMessageDialog(this, "There are no places in the net!", "No net", 2);
    }

    private void replaceStateAction() {
        int selected = this.table.getSelectedRow();
        Object[] options = new Object[]{"Replace SSA vector", "Cancel"};
        int n = JOptionPane.showOptionDialog(null, "Replace selected SSA vector (table row: " + selected + ")\nwith the current particle values?", "Replace SSA vector?", 0, 2, null, options, options[1]);
        if (n == 1) {
            return;
        }
        this.ssaManager.replaceSSAvectorWithNetState(selected);
        this.fillTable();
        this.overlord.markNetChange();
    }

    private void addLastStateToTable() {
        int states = this.ssaManager.accessSSAmatrix().size();
        SSAplacesVector ssaV = this.ssaManager.getSSAvector(states - 1);
        this.tableModel.addNew("", states - 1, ssaV.getDescription(), ssaV.getType(), ssaV.getVolume());
        this.overlord.markNetChange();
    }

    public JPanel getBottomPanel() {
        JPanel result = new JPanel(null);
        result.setBorder(BorderFactory.createTitledBorder("Others"));
        result.setPreferredSize(new Dimension(900, 150));
        int posX = 10;
        int posY = 15;
        JLabel label0 = new JLabel("State description:");
        label0.setBounds(posX, posY, 140, 20);
        result.add(label0);
        this.vectorDescrTextArea = new JTextArea();
        this.vectorDescrTextArea.setLineWrap(true);
        this.vectorDescrTextArea.setEditable(true);
        this.vectorDescrTextArea.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                JTextArea field = (JTextArea)e.getSource();
                if (field != null) {
                    String newComment = field.getText();
                    HolmesSSAwindowManager.this.ssaManager.setSSAvectorDescription(HolmesSSAwindowManager.this.selectedRow, newComment);
                    HolmesSSAwindowManager.this.selectedRow = HolmesSSAwindowManager.this.table.getSelectedRow();
                    HolmesSSAwindowManager.this.fillTable();
                    HolmesSSAwindowManager.this.table.setRowSelectionInterval(HolmesSSAwindowManager.this.selectedRow, HolmesSSAwindowManager.this.selectedRow);
                    HolmesSSAwindowManager.this.overlord.markNetChange();
                }
            }
        });
        JPanel CreationPanel = new JPanel();
        CreationPanel.setLayout(new BorderLayout());
        CreationPanel.add((Component)new JScrollPane(this.vectorDescrTextArea), "Center");
        CreationPanel.setBounds(posX, posY += 25, 500, 100);
        result.add(CreationPanel);
        String[] data = new String[]{"Molecules [number]", "Concentration [mole^-1]"};
        this.typeCombo = new JComboBox<String>(data);
        this.typeCombo.setBounds(posX + 510, posY, 180, 20);
        if (this.ssaManager.getCurrentSSAvector().getType() == SSAplacesVector.SSAdataType.MOLECULES) {
            this.typeCombo.setSelectedIndex(0);
        } else {
            this.typeCombo.setSelectedIndex(1);
        }
        this.typeCombo.addActionListener(actionEvent -> {
            if (this.doNotUpdate) {
                return;
            }
            JComboBox comboBox = (JComboBox)actionEvent.getSource();
            int mode = comboBox.getSelectedIndex();
            if (mode == 0) {
                this.ssaManager.getSSAvector(this.selectedRow).setType(SSAplacesVector.SSAdataType.MOLECULES);
                this.tableModel.changeType(this.selectedRow, SSAplacesVector.SSAdataType.MOLECULES);
            } else {
                this.ssaManager.getSSAvector(this.selectedRow).setType(SSAplacesVector.SSAdataType.CONCENTRATION);
                this.tableModel.changeType(this.selectedRow, SSAplacesVector.SSAdataType.CONCENTRATION);
            }
            this.tableModel.fireTableDataChanged();
        });
        result.add(this.typeCombo);
        return result;
    }

    private void fillDescriptionField() {
        String description = this.ssaManager.accessSSAmatrix().get(this.selectedRow).getDescription();
        this.vectorDescrTextArea.setText(description);
    }

    protected void cellClickAction() {
        try {
            int newSelection;
            this.doNotUpdate = true;
            this.selectedRow = newSelection = this.table.getSelectedRow();
            this.fillDescriptionField();
            if (this.ssaManager.getSSAvector(this.selectedRow).getType() == SSAplacesVector.SSAdataType.MOLECULES) {
                this.typeCombo.setSelectedIndex(0);
            } else {
                this.typeCombo.setSelectedIndex(1);
            }
            this.doNotUpdate = false;
        }
        catch (Exception ex) {
            GUIManager.getDefaultGUIManager().log("Error (311913047) | Exception:  " + ex.getMessage(), "error", true);
        }
    }

    private void fillTable() {
        this.tableModel.clearModel();
        int selectedVector = this.ssaManager.selectedSSAvector;
        for (int row = 0; row < this.ssaManager.accessSSAmatrix().size(); ++row) {
            SSAplacesVector ssaV = this.ssaManager.getSSAvector(row);
            if (row == selectedVector) {
                this.tableModel.addNew("X", row, ssaV.getDescription(), ssaV.getType(), ssaV.getVolume());
                continue;
            }
            this.tableModel.addNew("", row, ssaV.getDescription(), ssaV.getType(), ssaV.getVolume());
        }
        this.tableModel.fireTableDataChanged();
    }

    private void initiateListeners() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                HolmesSSAwindowManager.this.parentWindow.setEnabled(true);
            }
        });
    }
}

