/*
 * Decompiled with CFR 0.152.
 */
package holmes.windows.managers;

import holmes.darkgui.GUIManager;
import holmes.petrinet.data.PetriNet;
import holmes.petrinet.data.SPNdataVector;
import holmes.petrinet.data.SPNtransitionData;
import holmes.petrinet.elements.Transition;
import holmes.petrinet.elements.extensions.TransitionSPNExtension;
import holmes.utilities.Tools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.text.DefaultFormatter;

public class HolmesSPNtransitionEditor
extends JFrame {
    private static final long serialVersionUID = 3441899337352923949L;
    private JFrame ego;
    private GUIManager overlord;
    private PetriNet pn;
    private JFrame parentWindow;
    private SPNtransitionData myData;
    private Transition transition;
    private boolean doNotUpdate = false;
    private JFormattedTextField STfunctionValueEdit;
    private JFormattedTextField IMpriorityValueEdit;
    private JFormattedTextField DTdelayValueEdit;
    private JFormattedTextField SCHstartValueEdit;
    private JFormattedTextField SCHrepValueEdit;
    private JFormattedTextField SCHendValueEdit;

    public HolmesSPNtransitionEditor(JFrame boss, SPNtransitionData data, Transition trans, Point xyLoc) {
        this.setTitle("Holmes SPN transition editor");
        try {
            this.setIconImage(Tools.getImageFromIcon("/icons/holmesicon.png"));
        }
        catch (Exception ex) {
            GUIManager.getDefaultGUIManager().log("Error (736888893) | Exception:  " + ex.getMessage(), "error", true);
        }
        this.ego = this;
        this.overlord = GUIManager.getDefaultGUIManager();
        this.pn = this.overlord.getWorkspace().getProject();
        this.parentWindow = boss;
        this.myData = data;
        this.transition = trans;
        this.initalizeComponents();
        this.initiateListeners();
        this.setLocation(this.parentWindow.getLocation().x + 100, this.parentWindow.getLocation().x + 100);
        this.setVisible(true);
        this.parentWindow.setEnabled(false);
        this.setDefaultCloseOperation(2);
    }

    private void initalizeComponents() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(405, 260));
        this.setResizable(false);
        this.setLayout(new BorderLayout());
        JPanel main = new JPanel(null);
        int posX = 10;
        int posY = 15;
        main.setBorder(BorderFactory.createTitledBorder("SPN transition data vector"));
        JLabel label0 = new JLabel("SPN data vector:");
        label0.setBounds(posX, posY, 120, 20);
        main.add(label0);
        SPNdataVector frVector = this.pn.accessFiringRatesManager().getCurrentSPNdataVector();
        int frVectorIndex = this.pn.accessFiringRatesManager().selectedVector;
        JLabel label1 = new JLabel(frVectorIndex + " (" + frVector.getDescription() + ")");
        label1.setBounds(posX + 130, posY, 260, 20);
        main.add(label1);
        JLabel label2 = new JLabel("Transition:");
        label2.setBounds(posX, posY += 25, 120, 20);
        main.add(label2);
        DefaultFormatter format = new DefaultFormatter();
        format.setOverwriteMode(false);
        JFormattedTextField nameField = new JFormattedTextField(format);
        nameField.setBounds(posX + 130, posY, 250, 20);
        nameField.setValue(this.transition.getName());
        nameField.setEditable(false);
        main.add(nameField);
        JLabel label3 = new JLabel("SPN transition type:");
        label3.setBounds(posX, posY += 25, 120, 20);
        main.add(label3);
        JComboBox<String> spnTypeCombo = new JComboBox<String>();
        spnTypeCombo.addItem("Stochastic Transition");
        spnTypeCombo.addItem("Immediate Transition");
        spnTypeCombo.addItem("Deterministic Transition");
        spnTypeCombo.addItem("Scheduled Transition");
        spnTypeCombo.setBounds(posX + 130, posY, 250, 20);
        spnTypeCombo.addActionListener(actionEvent -> {
            JComboBox comboBox = (JComboBox)actionEvent.getSource();
            this.handleSubTypeSelection(comboBox.getSelectedIndex());
        });
        JLabel label4 = new JLabel("Function / value:");
        label4.setBounds(posX, posY += 25, 120, 20);
        main.add(label4);
        this.STfunctionValueEdit = new JFormattedTextField(format);
        this.STfunctionValueEdit.setBounds(posX + 130, posY, 250, 20);
        this.STfunctionValueEdit.setValue(this.myData.ST_function);
        this.STfunctionValueEdit.addPropertyChangeListener("value", e -> {
            JFormattedTextField field = (JFormattedTextField)e.getSource();
            try {
                this.myData.ST_function = field.getText();
            }
            catch (Exception ex) {
                GUIManager.getDefaultGUIManager().log("Error (222582756) | Exception:  " + ex.getMessage(), "error", true);
            }
        });
        main.add(this.STfunctionValueEdit);
        JLabel label5 = new JLabel("Priority:");
        label5.setBounds(posX, posY += 25, 120, 20);
        main.add(label5);
        this.IMpriorityValueEdit = new JFormattedTextField(format);
        this.IMpriorityValueEdit.setBounds(posX + 130, posY, 80, 20);
        this.IMpriorityValueEdit.setValue(this.myData.IM_priority);
        this.IMpriorityValueEdit.addPropertyChangeListener("value", e -> {
            if (this.doNotUpdate) {
                return;
            }
            JFormattedTextField field = (JFormattedTextField)e.getSource();
            try {
                this.myData.IM_priority = Integer.parseInt(field.getText());
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this.ego, "Invalid value, priority must be an integer.", "Error", 0);
                this.doNotUpdate = true;
                this.IMpriorityValueEdit.setValue(this.myData.IM_priority);
                this.doNotUpdate = false;
            }
        });
        main.add(this.IMpriorityValueEdit);
        JLabel label6 = new JLabel("Delay:");
        label6.setBounds(posX, posY += 25, 120, 20);
        main.add(label6);
        this.DTdelayValueEdit = new JFormattedTextField(format);
        this.DTdelayValueEdit.setBounds(posX + 130, posY, 80, 20);
        this.DTdelayValueEdit.setValue(this.myData.DET_delay);
        this.DTdelayValueEdit.addPropertyChangeListener("value", e -> {
            if (this.doNotUpdate) {
                return;
            }
            JFormattedTextField field = (JFormattedTextField)e.getSource();
            try {
                int priority = Integer.parseInt(field.getText());
                if (priority < 1) {
                    throw new Exception();
                }
                this.myData.DET_delay = priority;
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this.ego, "Invalid value, delay must be a positive integer.", "Error", 0);
                this.doNotUpdate = true;
                this.DTdelayValueEdit.setValue(this.myData.DET_delay);
                this.doNotUpdate = false;
            }
        });
        main.add(this.DTdelayValueEdit);
        JLabel label7 = new JLabel("Start / Rep. / Stop:");
        label7.setBounds(posX, posY += 25, 120, 20);
        main.add(label7);
        this.SCHstartValueEdit = new JFormattedTextField(format);
        this.SCHstartValueEdit.setBounds(posX + 130, posY, 80, 20);
        this.SCHstartValueEdit.setValue(this.myData.SCH_start);
        this.SCHstartValueEdit.addPropertyChangeListener("value", e -> {
            if (this.doNotUpdate) {
                return;
            }
            JFormattedTextField field = (JFormattedTextField)e.getSource();
            String data = field.getText();
            try {
                int start = Integer.parseInt(data);
                if (start < 0) {
                    throw new Exception();
                }
                this.myData.SCH_start = "" + start;
            }
            catch (Exception ex) {
                if (data.equals("start")) {
                    this.myData.SCH_start = data;
                }
                JOptionPane.showMessageDialog(this.ego, "Invalid value, either \"start\" text of non-negative value expected.", "Error", 0);
                this.doNotUpdate = true;
                this.SCHstartValueEdit.setValue(this.myData.SCH_start);
                this.doNotUpdate = false;
            }
        });
        main.add(this.SCHstartValueEdit);
        JLabel label8 = new JLabel("/");
        label8.setBounds(posX + 210, posY, 10, 20);
        main.add(label8);
        this.SCHrepValueEdit = new JFormattedTextField(format);
        this.SCHrepValueEdit.setBounds(posX + 215, posY, 80, 20);
        this.SCHrepValueEdit.setValue(this.myData.SCH_rep);
        this.SCHrepValueEdit.addPropertyChangeListener("value", e -> {
            if (this.doNotUpdate) {
                return;
            }
            JFormattedTextField field = (JFormattedTextField)e.getSource();
            try {
                int priority = Integer.parseInt(field.getText());
                if (priority < 0) {
                    throw new Exception();
                }
                this.myData.SCH_rep = priority;
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this.ego, "Invalid value, delay must be a non-negatice integer.", "Error", 0);
                this.doNotUpdate = true;
                this.SCHrepValueEdit.setValue(this.myData.SCH_rep);
                this.doNotUpdate = false;
            }
        });
        main.add(this.SCHrepValueEdit);
        JLabel label9 = new JLabel("/");
        label9.setBounds(posX + 295, posY, 10, 20);
        main.add(label9);
        this.SCHendValueEdit = new JFormattedTextField(format);
        this.SCHendValueEdit.setBounds(posX + 300, posY, 80, 20);
        this.SCHendValueEdit.setValue(this.myData.SCH_end);
        this.SCHendValueEdit.addPropertyChangeListener("value", e -> {
            if (this.doNotUpdate) {
                return;
            }
            JFormattedTextField field = (JFormattedTextField)e.getSource();
            String data = field.getText();
            try {
                int end = Integer.parseInt(data);
                if (end < 0) {
                    throw new Exception();
                }
                this.myData.SCH_end = "" + end;
            }
            catch (Exception ex) {
                if (data.equals("end")) {
                    this.myData.SCH_end = data;
                }
                JOptionPane.showMessageDialog(this.ego, "Invalid value, either \"end\" text of non-negative value expected.", "Error", 0);
                this.doNotUpdate = true;
                this.SCHendValueEdit.setValue(this.myData.SCH_end);
                this.doNotUpdate = false;
            }
        });
        main.add(this.SCHendValueEdit);
        main.add(spnTypeCombo);
        if (this.myData.sType == TransitionSPNExtension.StochaticsType.ST) {
            spnTypeCombo.setSelectedIndex(0);
        } else if (this.myData.sType == TransitionSPNExtension.StochaticsType.IM) {
            spnTypeCombo.setSelectedIndex(1);
        } else if (this.myData.sType == TransitionSPNExtension.StochaticsType.DT) {
            spnTypeCombo.setSelectedIndex(2);
        } else {
            spnTypeCombo.setSelectedIndex(3);
        }
        JButton saveAndExit = new JButton("<html>&nbsp;Change & exit</html>");
        saveAndExit.setIcon(Tools.getResIcon16("/icons/fRatesManager/acceptChange.png"));
        saveAndExit.setMargin(new Insets(0, 0, 0, 0));
        saveAndExit.setFocusPainted(false);
        saveAndExit.setBounds(posX + 115, posY += 25, 160, 32);
        saveAndExit.setToolTipText("One action back");
        saveAndExit.addActionListener(actionEvent -> this.ego.dispatchEvent(new WindowEvent(this.ego, 201)));
        main.add(saveAndExit);
        this.add((Component)main, "Center");
    }

    protected void handleSubTypeSelection(int selectedIndex) {
        if (selectedIndex == 0) {
            this.STfunctionValueEdit.setEnabled(true);
            this.IMpriorityValueEdit.setEnabled(false);
            this.DTdelayValueEdit.setEnabled(false);
            this.SCHstartValueEdit.setEnabled(false);
            this.SCHrepValueEdit.setEnabled(false);
            this.SCHendValueEdit.setEnabled(false);
            this.myData.sType = TransitionSPNExtension.StochaticsType.ST;
        } else if (selectedIndex == 1) {
            this.STfunctionValueEdit.setEnabled(false);
            this.IMpriorityValueEdit.setEnabled(true);
            this.DTdelayValueEdit.setEnabled(false);
            this.SCHstartValueEdit.setEnabled(false);
            this.SCHrepValueEdit.setEnabled(false);
            this.SCHendValueEdit.setEnabled(false);
            this.myData.sType = TransitionSPNExtension.StochaticsType.IM;
        } else if (selectedIndex == 2) {
            this.STfunctionValueEdit.setEnabled(false);
            this.IMpriorityValueEdit.setEnabled(false);
            this.DTdelayValueEdit.setEnabled(true);
            this.SCHstartValueEdit.setEnabled(false);
            this.SCHrepValueEdit.setEnabled(false);
            this.SCHendValueEdit.setEnabled(false);
            this.myData.sType = TransitionSPNExtension.StochaticsType.DT;
        } else {
            this.STfunctionValueEdit.setEnabled(false);
            this.IMpriorityValueEdit.setEnabled(false);
            this.DTdelayValueEdit.setEnabled(false);
            this.SCHstartValueEdit.setEnabled(true);
            this.SCHrepValueEdit.setEnabled(true);
            this.SCHendValueEdit.setEnabled(true);
            this.myData.sType = TransitionSPNExtension.StochaticsType.SchT;
        }
    }

    private void initiateListeners() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                HolmesSPNtransitionEditor.this.parentWindow.setEnabled(true);
            }
        });
    }
}

