/*
 * Decompiled with CFR 0.152.
 */
package holmes.windows.managers;

import holmes.darkgui.GUIManager;
import holmes.petrinet.data.PetriNet;
import holmes.petrinet.data.SPNdataVectorManager;
import holmes.petrinet.elements.Transition;
import holmes.tables.RXTable;
import holmes.tables.managers.SPNdataVectorsRenderer;
import holmes.tables.managers.SPNdataVectorsTableModel;
import holmes.utilities.Tools;
import holmes.windows.managers.HolmesSPNeditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;

public class HolmesSPNmanager
extends JFrame {
    private static final long serialVersionUID = 8184934957669150556L;
    private GUIManager overlord;
    private JFrame parentWindow;
    private JFrame ego;
    private boolean doNotUpdate = false;
    private SPNdataVectorsTableModel tableModel;
    private JTable table;
    private JTextArea vectorDescrTextArea;
    private ArrayList<Transition> transitions;
    private SPNdataVectorManager spnManager;
    private int selectedRow;

    public HolmesSPNmanager(JFrame parent) {
        this.setTitle("Holmes SPN transitions data manager");
        try {
            this.setIconImage(Tools.getImageFromIcon("/icons/holmesicon.png"));
        }
        catch (Exception ex) {
            GUIManager.getDefaultGUIManager().log("Error (634466444) | Exception:  " + ex.getMessage(), "error", true);
        }
        this.overlord = GUIManager.getDefaultGUIManager();
        PetriNet pn = this.overlord.getWorkspace().getProject();
        this.ego = this;
        this.parentWindow = parent;
        this.transitions = pn.getTransitions();
        this.spnManager = pn.accessFiringRatesManager();
        this.selectedRow = 0;
        this.initalizeComponents();
        this.initiateListeners();
        this.fillTable();
        this.setVisible(true);
        this.parentWindow.setEnabled(false);
        this.setDefaultCloseOperation(2);
    }

    public JPanel getMainTablePanel() {
        JPanel result = new JPanel(new BorderLayout());
        result.setLocation(0, 0);
        result.setBorder(BorderFactory.createTitledBorder("SPN vectors table"));
        result.setPreferredSize(new Dimension(500, 500));
        this.tableModel = new SPNdataVectorsTableModel(this);
        this.table = new RXTable(this.tableModel);
        ((RXTable)this.table).setSelectAllForEdit(true);
        this.table.getColumnModel().getColumn(0).setHeaderValue("Sel.");
        this.table.getColumnModel().getColumn(0).setPreferredWidth(40);
        this.table.getColumnModel().getColumn(0).setMinWidth(40);
        this.table.getColumnModel().getColumn(0).setMaxWidth(40);
        this.table.getColumnModel().getColumn(1).setHeaderValue("ID");
        this.table.getColumnModel().getColumn(1).setPreferredWidth(30);
        this.table.getColumnModel().getColumn(1).setMinWidth(30);
        this.table.getColumnModel().getColumn(1).setMaxWidth(30);
        this.table.getColumnModel().getColumn(2).setHeaderValue("SPN data vector description");
        this.table.getColumnModel().getColumn(2).setMinWidth(50);
        this.table.getColumnModel().getColumn(3).setHeaderValue("Vector type");
        this.table.getColumnModel().getColumn(3).setMinWidth(80);
        this.table.getColumnModel().getColumn(3).setMaxWidth(80);
        this.table.setName("FiringRatesTable");
        this.table.setFillsViewportHeight(true);
        SPNdataVectorsRenderer tableRenderer = new SPNdataVectorsRenderer(this.table);
        this.table.setDefaultRenderer(Object.class, tableRenderer);
        this.table.setDefaultRenderer(Double.class, tableRenderer);
        this.table.setDefaultRenderer(Integer.class, tableRenderer);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 1 && !e.isControlDown()) {
                    HolmesSPNmanager.this.cellClickAction();
                }
            }
        });
        this.table.setRowSelectionAllowed(false);
        this.table.setAutoResizeMode(4);
        JScrollPane tableScrollPane = new JScrollPane(this.table, 20, 30);
        result.add((Component)tableScrollPane, "Center");
        return result;
    }

    private void initalizeComponents() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(900, 650));
        this.setLocation(50, 50);
        this.setResizable(true);
        this.setLayout(new BorderLayout());
        JPanel main = new JPanel(new BorderLayout());
        JPanel submain = new JPanel(new BorderLayout());
        JPanel tablePanel = this.getMainTablePanel();
        submain.add((Component)tablePanel, "Center");
        submain.add((Component)this.getBottomPanel(), "South");
        main.add((Component)submain, "Center");
        main.add((Component)this.getButtonsPanel(), "East");
        this.add((Component)main, "Center");
    }

    public void changeState(int row, int column, String value) {
        this.spnManager.accessSPNmatrix().get(row).setDescription(value);
    }

    public JPanel getButtonsPanel() {
        JPanel result = new JPanel(null);
        result.setBorder(BorderFactory.createTitledBorder("Buttons"));
        result.setPreferredSize(new Dimension(150, 500));
        int posXda = 10;
        int posYda = 25;
        JButton selectStateButton = new JButton("<html>Select this<br>SPN vector</html>");
        selectStateButton.setBounds(posXda, posYda, 130, 40);
        selectStateButton.setMargin(new Insets(0, 0, 0, 0));
        selectStateButton.setFocusPainted(false);
        selectStateButton.setIcon(Tools.getResIcon16("/icons/fRatesManager/selectVectorIcon.png"));
        selectStateButton.addActionListener(actionEvent -> {
            if (this.transitions.size() == 0) {
                this.noNetInfo();
                return;
            }
            int selected = this.table.getSelectedRow();
            if (selected == -1) {
                return;
            }
            Object[] options = new Object[]{"Set new rates", "Keep old ones"};
            int n = JOptionPane.showOptionDialog(null, "Set all transitions of the net according to the selected\nSPN data vector (table row: " + selected + ") ?", "Set new firing rates?", 0, 2, null, options, options[1]);
            if (n == 0) {
                this.tableModel.setSelected(selected);
                this.spnManager.setNetworkSPNdataVector(selected);
                this.tableModel.fireTableDataChanged();
            }
        });
        result.add(selectStateButton);
        JButton addNewStateButton = new JButton("<html>Save current<br/>&nbsp;&nbsp;SPN vector</html>");
        addNewStateButton.setBounds(posXda, posYda += 50, 130, 40);
        addNewStateButton.setMargin(new Insets(0, 0, 0, 0));
        addNewStateButton.setFocusPainted(false);
        addNewStateButton.setIcon(Tools.getResIcon16("/icons/fRatesManager/addVectorIcon.png"));
        addNewStateButton.addActionListener(actionEvent -> {
            if (this.transitions.size() == 0) {
                this.noNetInfo();
                return;
            }
            Object[] options = new Object[]{"Add new vector", "Cancel"};
            int n = JOptionPane.showOptionDialog(null, "Remember current net firing rates in the table?", "Add new SPN data vactor?", 0, 2, null, options, options[1]);
            if (n == 0) {
                this.spnManager.addCurrentFRasSPNdataVector();
                this.addLastStateToTable();
                this.tableModel.fireTableDataChanged();
                this.overlord.markNetChange();
            }
        });
        result.add(addNewStateButton);
        JButton replaceStateButton = new JButton("<html>&nbsp;&nbsp;&nbsp;Replace&nbsp;<br/>SPN vector</html>");
        replaceStateButton.setBounds(posXda, posYda += 50, 130, 40);
        replaceStateButton.setMargin(new Insets(0, 0, 0, 0));
        replaceStateButton.setFocusPainted(false);
        replaceStateButton.setIcon(Tools.getResIcon16("/icons/fRatesManager/replaceVectorIcon.png"));
        replaceStateButton.addActionListener(actionEvent -> {
            if (this.transitions.size() == 0) {
                this.noNetInfo();
                return;
            }
            this.replaceStateAction();
        });
        result.add(replaceStateButton);
        JButton removeStateButton = new JButton("<html>&nbsp;&nbsp;&nbsp;Remove&nbsp;&nbsp;<br/>SPN vector</html>");
        removeStateButton.setBounds(posXda, posYda += 50, 130, 40);
        removeStateButton.setMargin(new Insets(0, 0, 0, 0));
        removeStateButton.setFocusPainted(false);
        removeStateButton.setIcon(Tools.getResIcon16("/icons/fRatesManager/removeVectorIcon.png"));
        removeStateButton.addActionListener(actionEvent -> {
            if (this.transitions.size() == 0) {
                this.noNetInfo();
                return;
            }
            this.removeStateAction();
        });
        result.add(removeStateButton);
        JButton editStateButton = new JButton("<html>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Edit&nbsp;&nbsp;&nbsp;&nbsp;<br/>SPN vector</html>");
        editStateButton.setBounds(posXda, posYda += 50, 130, 40);
        editStateButton.setMargin(new Insets(0, 0, 0, 0));
        editStateButton.setFocusPainted(false);
        editStateButton.setIcon(Tools.getResIcon32("/icons/fRatesManager/fireRateEdit.png"));
        editStateButton.addActionListener(actionEvent -> {
            if (this.transitions.size() == 0) {
                this.noNetInfo();
                return;
            }
            int selected = this.table.getSelectedRow();
            if (selected > -1) {
                new HolmesSPNeditor(this.ego, this.spnManager.getSPNdataVector(selected), selected);
            }
        });
        result.add(editStateButton);
        return result;
    }

    private void removeStateAction() {
        int selected = this.table.getSelectedRow();
        int states = this.spnManager.accessSPNmatrix().size();
        if (states == 1) {
            JOptionPane.showMessageDialog(null, "At least one net SPN data vector must remain!", "Cannot delete!", 2);
            return;
        }
        Object[] options = new Object[]{"Remove vector", "Cancel"};
        int n = JOptionPane.showOptionDialog(null, "Remove selected SPN data vector from the table\n(table row: " + selected + ") ?", "Remove SPN data vector?", 0, 2, null, options, options[1]);
        if (n == 1) {
            return;
        }
        this.spnManager.removeSPNvector(selected);
        this.fillTable();
        this.overlord.markNetChange();
    }

    private void noNetInfo() {
        JOptionPane.showMessageDialog(this, "There are no transitions in the net!", "No net", 2);
    }

    private void replaceStateAction() {
        int selected = this.table.getSelectedRow();
        Object[] options = new Object[]{"Replace vector", "Cancel"};
        int n = JOptionPane.showOptionDialog(null, "Replace selected SPN data vector (table row: " + selected + ")\nwith the currently set net firing rates?", "Replace SPN data vector?", 0, 2, null, options, options[1]);
        if (n == 1) {
            return;
        }
        this.spnManager.replaceSPNvectorWithNetFRates(selected);
        this.fillTable();
        this.overlord.markNetChange();
    }

    private void addLastStateToTable() {
        int states = this.spnManager.accessSPNmatrix().size();
        this.tableModel.addNew("", states - 1, this.spnManager.getSPNvectorDescription(states - 1), this.spnManager.getSPNvectorType(states - 1));
    }

    public JPanel getBottomPanel() {
        JPanel result = new JPanel(null);
        result.setBorder(BorderFactory.createTitledBorder("Others"));
        result.setPreferredSize(new Dimension(900, 150));
        int posXda = 10;
        int posYda = 15;
        JLabel label0 = new JLabel("State description:");
        label0.setBounds(posXda, posYda, 140, 20);
        result.add(label0);
        this.vectorDescrTextArea = new JTextArea();
        this.vectorDescrTextArea.setLineWrap(true);
        this.vectorDescrTextArea.setEditable(true);
        this.vectorDescrTextArea.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                JTextArea field = (JTextArea)e.getSource();
                if (field != null) {
                    String newComment = field.getText();
                    HolmesSPNmanager.this.spnManager.setSPNvectorDescription(HolmesSPNmanager.this.selectedRow, newComment);
                    HolmesSPNmanager.this.selectedRow = HolmesSPNmanager.this.table.getSelectedRow();
                    HolmesSPNmanager.this.fillTable();
                    HolmesSPNmanager.this.table.setRowSelectionInterval(HolmesSPNmanager.this.selectedRow, HolmesSPNmanager.this.selectedRow);
                    HolmesSPNmanager.this.overlord.markNetChange();
                }
            }
        });
        JPanel CreationPanel = new JPanel();
        CreationPanel.setLayout(new BorderLayout());
        CreationPanel.add((Component)new JScrollPane(this.vectorDescrTextArea), "Center");
        CreationPanel.setBounds(posXda, posYda += 25, 600, 100);
        result.add(CreationPanel);
        return result;
    }

    private void fillDescriptionField() {
        String description = this.spnManager.getSPNvectorDescription(this.selectedRow);
        this.vectorDescrTextArea.setText(description);
    }

    protected void cellClickAction() {
        try {
            this.selectedRow = this.table.getSelectedRow();
            this.fillDescriptionField();
        }
        catch (Exception ex) {
            GUIManager.getDefaultGUIManager().log("Error (502046909) | Exception:  " + ex.getMessage(), "error", true);
        }
    }

    private void fillTable() {
        this.tableModel.clearModel();
        int selectedFR = this.spnManager.selectedVector;
        for (int row = 0; row < this.spnManager.accessSPNmatrix().size(); ++row) {
            if (row == selectedFR) {
                this.tableModel.addNew("X", row, this.spnManager.getSPNvectorDescription(row), this.spnManager.getSPNvectorType(row));
                continue;
            }
            this.tableModel.addNew("", row, this.spnManager.getSPNvectorDescription(row), this.spnManager.getSPNvectorType(row));
        }
        this.tableModel.fireTableDataChanged();
    }

    private void initiateListeners() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                HolmesSPNmanager.this.parentWindow.setEnabled(true);
            }
        });
    }
}

