/*
 * Decompiled with CFR 0.152.
 */
package holmes.windows.decompositions;

import holmes.analyse.InvariantsCalculator;
import holmes.analyse.SubnetCalculator;
import holmes.analyse.comparison.Hungarian;
import holmes.analyse.comparison.SubnetComparator;
import holmes.analyse.comparison.structures.GreatCommonSubnet;
import holmes.darkgui.GUIManager;
import holmes.files.io.IOprotocols;
import holmes.petrinet.data.PetriNet;
import holmes.petrinet.elements.Arc;
import holmes.petrinet.elements.Node;
import holmes.petrinet.elements.PetriNetElement;
import holmes.petrinet.elements.Place;
import holmes.petrinet.elements.Transition;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class HolmesSubnetComparison
extends JFrame {
    PetriNet secondNet = null;
    ArrayList<SubnetCalculator.SubNet> seconNetList;
    SubnetComparator sc;
    String resultFlag = "Hungarian";
    JTextArea infoPane = new JTextArea();
    Boolean firstQuestionB = false;
    Boolean secondQuestionB = false;
    Boolean thirdQuestionB = false;
    ArrayList<JTable> listOfTables = new ArrayList();
    JButton generate;
    private boolean indexQuestionB = false;
    JRadioButton hungarianButton;
    JTabbedPane tabbedPane;
    int coloringMode = 0;
    ArrayList<ArrayList<ArrayList<GreatCommonSubnet>>> listOfTableContent = new ArrayList();

    private JPanel createStartOptionsPanel() {
        JPanel jp = new JPanel();
        JPanel buttonPanel = new JPanel(new GridLayout(0, 1));
        JButton chooser = new JButton("Choose second net");
        chooser.setVisible(true);
        chooser.addActionListener(e -> {
            JFileChooser jfc = new JFileChooser();
            int returnVal = jfc.showOpenDialog(this);
            this.infoPane.append("Choosen file: " + jfc.getSelectedFile().getName() + "\n");
            this.chooseSecondNet(jfc.getSelectedFile().getAbsolutePath());
            if (returnVal == 0) {
                this.generate.setEnabled(true);
            }
        });
        buttonPanel.add(chooser);
        this.generate = new JButton("Compare nets");
        this.generate.addActionListener(e -> this.compare());
        this.generate.setEnabled(false);
        buttonPanel.add(this.generate);
        jp.add(buttonPanel);
        JPanel firstQuestion = new JPanel(new GridLayout(0, 1));
        final JRadioButton maxButton = new JRadioButton("Max common path");
        maxButton.setActionCommand("");
        maxButton.setSelected(true);
        maxButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (maxButton.isSelected()) {
                    HolmesSubnetComparison.this.firstQuestionB = false;
                }
            }
        });
        firstQuestion.add(maxButton);
        JRadioButton minButton = new JRadioButton("Min common path");
        minButton.setActionCommand("");
        minButton.addActionListener(e -> {
            if (minButton.isSelected()) {
                this.firstQuestionB = true;
            }
        });
        firstQuestion.add(minButton);
        ButtonGroup groupQ1 = new ButtonGroup();
        groupQ1.add(minButton);
        groupQ1.add(maxButton);
        TitledBorder titleF = BorderFactory.createTitledBorder("Path size");
        firstQuestion.setBorder(titleF);
        jp.add(firstQuestion);
        if (GUIManager.getDefaultGUIManager().getWorkspace().getProject().getT_InvMatrix() == null || GUIManager.getDefaultGUIManager().getWorkspace().getProject().getT_InvMatrix().isEmpty()) {
            this.infoPane.append("Generate inwariants for net in workspace.\n");
        }
        if (SubnetCalculator.adtSubNets == null || SubnetCalculator.adtSubNets.isEmpty()) {
            this.infoPane.append("Generate ADT subnets for net in workspace.\n");
        }
        JPanel secondQuestion = new JPanel(new GridLayout(0, 1));
        JRadioButton ttButton = new JRadioButton("Same type branches comparison");
        ttButton.setActionCommand("");
        ttButton.setSelected(true);
        ttButton.addActionListener(e -> {
            if (ttButton.isSelected()) {
                this.secondQuestionB = false;
            }
        });
        secondQuestion.add(ttButton);
        JRadioButton tpButton = new JRadioButton("Mix type branches comparison");
        tpButton.setActionCommand("");
        tpButton.addActionListener(e -> {
            if (tpButton.isSelected()) {
                this.secondQuestionB = true;
            }
        });
        secondQuestion.add(tpButton);
        ButtonGroup groupQ2 = new ButtonGroup();
        groupQ2.add(ttButton);
        groupQ2.add(tpButton);
        TitledBorder titleS = BorderFactory.createTitledBorder("Branch restriction");
        secondQuestion.setBorder(titleS);
        jp.add(secondQuestion);
        JPanel thirdQuestion = new JPanel(new GridLayout(0, 1));
        JRadioButton loButton = new JRadioButton("With loops");
        loButton.setActionCommand("");
        loButton.addActionListener(e -> {
            if (loButton.isSelected()) {
                this.thirdQuestionB = false;
            }
        });
        loButton.setSelected(true);
        thirdQuestion.add(loButton);
        JRadioButton nloButton = new JRadioButton("Without loops");
        nloButton.setActionCommand("");
        nloButton.addActionListener(e -> {
            if (nloButton.isSelected()) {
                this.thirdQuestionB = true;
            }
        });
        thirdQuestion.add(nloButton);
        ButtonGroup groupQ3 = new ButtonGroup();
        groupQ3.add(loButton);
        groupQ3.add(nloButton);
        TitledBorder titleT = BorderFactory.createTitledBorder("Loop restriction");
        thirdQuestion.setBorder(titleT);
        jp.add(thirdQuestion);
        JPanel indexQuestion = new JPanel(new GridLayout(0, 1));
        JRadioButton jacButton = new JRadioButton("Jackard index");
        jacButton.setActionCommand("");
        jacButton.addActionListener(e -> {
            if (jacButton.isSelected()) {
                this.indexQuestionB = false;
            }
        });
        jacButton.setSelected(true);
        indexQuestion.add(jacButton);
        JRadioButton sorButton = new JRadioButton("S\u00f8rensen index");
        sorButton.setActionCommand("");
        sorButton.addActionListener(e -> {
            if (sorButton.isSelected()) {
                this.indexQuestionB = true;
            }
        });
        indexQuestion.add(sorButton);
        ButtonGroup groupQ4 = new ButtonGroup();
        groupQ4.add(jacButton);
        groupQ4.add(sorButton);
        TitledBorder titleIn = BorderFactory.createTitledBorder("Index");
        indexQuestion.setBorder(titleIn);
        jp.add(indexQuestion);
        return jp;
    }

    private void compare() {
        if (SubnetCalculator.adtSubNets == null || SubnetCalculator.adtSubNets.isEmpty()) {
            JOptionPane jpo = new JOptionPane("No ADT sets!");
            GUIManager.getDefaultGUIManager().showDecoWindow();
        } else {
            this.listOfTables.clear();
            InvariantsCalculator ic = new InvariantsCalculator(this.secondNet);
            ic.generateInvariantsForTest(this.secondNet);
            this.infoPane.append("Second net: Invariants generated.\n");
            this.secondNet.setT_InvMatrix(ic.getInvariants(true), false);
            this.seconNetList = SubnetCalculator.generateADTFromSecondNet(this.secondNet);
            this.infoPane.append("Second net: ADT generated.\n");
            this.sc = new SubnetComparator(SubnetCalculator.adtSubNets, this.seconNetList);
            this.infoPane.append("Start comparison...\n");
            JPanel result = this.createResultsPanel();
            this.getContentPane().add((Component)result, "Last");
            this.revalidate();
        }
    }

    private void chooseSecondNet(String absolutePath) {
        IOprotocols io = new IOprotocols();
        this.secondNet = io.serverReadPNT(absolutePath, 99);
    }

    private JPanel createResultsPanel() {
        JPanel jp = new JPanel();
        JPanel leftPanel = new JPanel();
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.setSize(200, 500);
        this.setSize(950, 800);
        this.sc.firstQuestion = this.firstQuestionB;
        this.sc.secondQuestion = this.secondQuestionB;
        this.sc.thirdQuestion = this.thirdQuestionB;
        this.infoPane.append("Compare first net to second net.\n");
        JComponent panelFF = this.createPartResultTable(this.sc.compareFirstSecond(), false);
        this.tabbedPane.addTab("First net to second net", null, panelFF, "Does nothing");
        this.tabbedPane.setMnemonicAt(0, 49);
        this.infoPane.append("Compare second net to first net.\n");
        JComponent panelSS = this.createPartResultTable(this.sc.compareSecondFirst(), false);
        this.tabbedPane.addTab("Second net to first net", null, panelSS, "Does twice as much nothing");
        this.tabbedPane.setMnemonicAt(1, 50);
        this.infoPane.append("Compare first net internally.\n");
        JComponent panelFS = this.createPartResultTable(this.sc.compareInternalFirst(), true);
        this.tabbedPane.addTab("Internal similarity of First net", null, panelFS, "Still does nothing");
        this.tabbedPane.setMnemonicAt(2, 51);
        this.infoPane.append("Compare second net internally.\n");
        JComponent panelSF = this.createPartResultTable(this.sc.compareInternalSecond(), true);
        this.tabbedPane.addTab("Internal similarity of Second net", null, panelSF, "Does nothing at all");
        this.tabbedPane.setMnemonicAt(3, 52);
        this.infoPane.append("Comparison finished.\n");
        leftPanel.add(this.tabbedPane);
        jp.add((Component)leftPanel, "Last");
        JPanel rightPanel = new JPanel(new GridLayout(0, 1));
        this.hungarianButton = new JRadioButton("Hungarian method");
        this.hungarianButton.setMnemonic(66);
        this.hungarianButton.addActionListener(e -> {
            if (this.hungarianButton.isSelected()) {
                this.coloringMode = 2;
                if (this.tabbedPane.getSelectedIndex() < 2) {
                    int[] hungarianCels = this.calcHungarianCels(this.listOfTableContent.get(this.tabbedPane.getSelectedIndex()));
                    this.colorAllHungarianCel(hungarianCels, this.listOfTableContent.get(this.tabbedPane.getSelectedIndex()));
                }
            }
        });
        this.hungarianButton.setActionCommand(this.resultFlag);
        JRadioButton singleHandButton = new JRadioButton("Color single matching");
        singleHandButton.setMnemonic(68);
        singleHandButton.setSelected(true);
        singleHandButton.addActionListener(e -> {
            if (singleHandButton.isSelected()) {
                this.coloringMode = 0;
            }
        });
        JRadioButton handButton = new JRadioButton("Color choosen matching");
        handButton.setMnemonic(68);
        handButton.addActionListener(e -> {
            if (handButton.isSelected()) {
                this.coloringMode = 1;
            }
        });
        ButtonGroup group = new ButtonGroup();
        group.add(singleHandButton);
        group.add(handButton);
        group.add(this.hungarianButton);
        rightPanel.add(singleHandButton);
        rightPanel.add(handButton);
        rightPanel.add(this.hungarianButton);
        TitledBorder title = BorderFactory.createTitledBorder("");
        rightPanel.setBorder(title);
        JButton saveButton = new JButton("Save to .csv");
        saveButton.addActionListener(e -> {
            JFileChooser fc = new JFileChooser();
            int returnVal = fc.showOpenDialog(this);
            if (returnVal == 0) {
                HolmesSubnetComparison.exportToCSV(this.listOfTables.get(0), fc.getSelectedFile().getPath() + "1-2.csv");
                HolmesSubnetComparison.exportToCSV(this.listOfTables.get(1), fc.getSelectedFile().getPath() + "2-1.csv");
                HolmesSubnetComparison.exportToCSV(this.listOfTables.get(2), fc.getSelectedFile().getPath() + "1-1.csv");
                HolmesSubnetComparison.exportToCSV(this.listOfTables.get(3), fc.getSelectedFile().getPath() + "2-2.csv");
                this.infoPane.append("csv files saved!\n");
            }
        });
        rightPanel.add(saveButton);
        jp.add((Component)rightPanel, "East");
        return jp;
    }

    public static boolean exportToCSV(JTable tableToExport, String pathToExportTo) {
        try {
            int i;
            TableModel model = tableToExport.getModel();
            FileWriter csv = new FileWriter(new File(pathToExportTo));
            for (i = 0; i < model.getColumnCount(); ++i) {
                csv.write(model.getColumnName(i) + ",");
            }
            csv.write("\n");
            for (i = 0; i < model.getRowCount(); ++i) {
                for (int j = 0; j < model.getColumnCount(); ++j) {
                    csv.write(model.getValueAt(i, j).toString() + ",");
                }
                csv.write("\n");
            }
            csv.close();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private ArrayList<ArrayList<GreatCommonSubnet>> cutGcs(ArrayList<ArrayList<GreatCommonSubnet>> gscl, int i, int i1, int size, int size1) {
        ArrayList<ArrayList<GreatCommonSubnet>> result = new ArrayList<ArrayList<GreatCommonSubnet>>();
        for (int j = i; j < size; ++j) {
            ArrayList<GreatCommonSubnet> al = new ArrayList<GreatCommonSubnet>();
            for (int k = i1; k < size1; ++k) {
                al.add(gscl.get(j).get(k));
            }
            result.add(al);
        }
        System.out.println("Rozmiar " + result.size() + ": " + ((ArrayList)result.get(0)).size());
        return result;
    }

    public JComponent createPartResultTable(final ArrayList<ArrayList<GreatCommonSubnet>> gcls, final boolean isInternal) {
        int i;
        this.listOfTableContent.add(gcls);
        JPanel jp = new JPanel();
        jp.setPreferredSize(new Dimension(800, 300));
        final String[] netLabelsFirst = new String[gcls.size()];
        Object[] netLabelsSecond = new String[gcls.get(0).size()];
        for (i = 0; i < gcls.size(); ++i) {
            netLabelsFirst[i] = "SubF :" + i;
            System.out.println(netLabelsFirst[i]);
        }
        for (i = 0; i < gcls.get(0).size(); ++i) {
            netLabelsSecond[i] = "SubS :" + i;
            System.out.println(netLabelsSecond[i]);
        }
        AbstractListModel lm = new AbstractListModel(){
            String[] headers;
            {
                this.headers = netLabelsFirst;
            }

            @Override
            public int getSize() {
                return this.headers.length;
            }

            @Override
            public Object getElementAt(int index) {
                return this.headers[index];
            }
        };
        Object[][] results = new String[gcls.size()][gcls.get(0).size()];
        for (int i2 = 0; i2 < gcls.size(); ++i2) {
            for (int j = 0; j < gcls.get(i2).size(); ++j) {
                results[i2][j] = gcls.get((int)i2).get((int)j).gcsValue + "/" + gcls.get((int)i2).get((int)j).firstNetNodeSize;
            }
        }
        final int[] hungarianCels = this.calcHungarianCels(gcls);
        final JTable comparisonTable = new JTable(results, netLabelsSecond){

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int col) {
                Component comp = super.prepareRenderer(renderer, row, col);
                Object value = this.getModel().getValueAt(row, col);
                if (isInternal) {
                    HolmesSubnetComparison.this.colorIsomorphicCels(row, col, comp, gcls);
                } else {
                    if (HolmesSubnetComparison.this.coloringMode == 0) {
                        // empty if block
                    }
                    if (HolmesSubnetComparison.this.coloringMode == 1) {
                        // empty if block
                    }
                    if (HolmesSubnetComparison.this.coloringMode == 2) {
                        HolmesSubnetComparison.this.colorHungarianCels(row, col, comp, hungarianCels, gcls);
                    }
                }
                return comp;
            }
        };
        comparisonTable.setAutoResizeMode(0);
        JList rowHeader = new JList(lm);
        rowHeader.setFixedCellWidth(50);
        rowHeader.setFixedCellHeight(comparisonTable.getRowHeight());
        rowHeader.setCellRenderer(new RowHeaderRenderer(comparisonTable));
        comparisonTable.getSelectionModel().addListSelectionListener(event -> {});
        comparisonTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                GUIManager.getDefaultGUIManager().reset.clearGraphColors();
                int row = comparisonTable.rowAtPoint(evt.getPoint());
                int col = comparisonTable.columnAtPoint(evt.getPoint());
                if (row >= 0 && col >= 0 && HolmesSubnetComparison.this.coloringMode == 0) {
                    HolmesSubnetComparison.this.colorHungarianCel(row, col, gcls);
                    TableCellEditor tableCellEditor = comparisonTable.getCellEditor(row, col);
                }
            }
        });
        JScrollPane scroll = new JScrollPane(comparisonTable);
        scroll.setRowHeaderView(rowHeader);
        this.listOfTables.add(comparisonTable);
        return scroll;
    }

    public static String[][] transposeMatrix(String[][] m) {
        String[][] temp = new String[m[0].length][m.length];
        for (int i = 0; i < m.length; ++i) {
            for (int j = 0; j < m[0].length; ++j) {
                temp[j][i] = m[i][j];
            }
        }
        return temp;
    }

    private void colorHungarianCels(int row, int col, Component comp, int[] hungarianCels, ArrayList<ArrayList<GreatCommonSubnet>> gcls) {
        if (row < hungarianCels.length) {
            if (hungarianCels[row] == col) {
                comp.setBackground(Color.green);
                this.colorSubnet(gcls.get(row).get(col), SubnetCalculator.adtSubNets.get(row));
            } else {
                comp.setBackground(Color.white);
            }
        }
    }

    private void colorHungarianCel(int row, int col, ArrayList<ArrayList<GreatCommonSubnet>> gcls) {
        this.colorSubnet(gcls.get(row).get(col), SubnetCalculator.adtSubNets.get(row));
    }

    private void colorAllHungarianCel(int[] hungarianCels, ArrayList<ArrayList<GreatCommonSubnet>> gcls) {
        for (int i = 0; i < gcls.size(); ++i) {
            for (int j = 0; j < gcls.get(i).size(); ++j) {
                if (i >= hungarianCels.length || hungarianCels[i] != j) continue;
                this.colorSubnetDensity(gcls.get(i).get(j), SubnetCalculator.adtSubNets.get(i), i, gcls.size());
            }
        }
    }

    private void colorSubnet(GreatCommonSubnet gcs, SubnetCalculator.SubNet sn) {
        for (Node transition : sn.getSubNode()) {
            if (transition.getType() == PetriNetElement.PetriNetElementType.TRANSITION) {
                ((Transition)transition).drawGraphBoxT.setColorWithNumber(true, Color.RED, false, 0.0, true, "");
            }
            if (transition.getType() != PetriNetElement.PetriNetElementType.PLACE) continue;
            ((Place)transition).drawGraphBoxP.setColorWithNumber(true, Color.RED, false, 0.0, true, "");
        }
        ArrayList<Arc> arcs = sn.getSubArcs();
        for (Arc arc : arcs) {
            arc.arcDecoBox.setColor(true, Color.red);
        }
        for (SubnetComparator.PartialSubnetElements pse : gcs.psel) {
            for (Node transition : pse.partialNodes) {
                if (transition.getType() == PetriNetElement.PetriNetElementType.TRANSITION) {
                    ((Transition)transition).drawGraphBoxT.setColorWithNumber(true, Color.GREEN, false, 0.0, true, "");
                }
                if (transition.getType() != PetriNetElement.PetriNetElementType.PLACE) continue;
                ((Place)transition).drawGraphBoxP.setColorWithNumber(true, Color.GREEN, false, 0.0, true, "");
            }
            for (Arc arc : pse.partialArcs) {
                arc.arcDecoBox.setColor(true, Color.GREEN);
            }
        }
        GUIManager.getDefaultGUIManager().getWorkspace().getProject().repaintAllGraphPanels();
    }

    private void colorSubnetDensity(GreatCommonSubnet gcs, SubnetCalculator.SubNet sn, int fr, int max) {
        Color randomColor = new Color(0, (int)(255.0 * ((double)fr / (double)max)), 0);
        for (Node transition : sn.getSubNode()) {
            if (transition.getType() == PetriNetElement.PetriNetElementType.TRANSITION) {
                ((Transition)transition).drawGraphBoxT.setColorWithNumber(true, Color.RED, false, 0.0, true, "");
            }
            if (transition.getType() != PetriNetElement.PetriNetElementType.PLACE) continue;
            ((Place)transition).drawGraphBoxP.setColorWithNumber(true, Color.RED, false, 0.0, true, "");
        }
        ArrayList<Arc> arcs = sn.getSubArcs();
        for (Arc arc : arcs) {
            arc.arcDecoBox.setColor(true, Color.red);
        }
        for (SubnetComparator.PartialSubnetElements pse : gcs.psel) {
            for (Node transition : pse.partialNodes) {
                if (transition.getType() == PetriNetElement.PetriNetElementType.TRANSITION) {
                    ((Transition)transition).drawGraphBoxT.setColorWithNumber(true, randomColor, false, 0.0, true, "");
                }
                if (transition.getType() != PetriNetElement.PetriNetElementType.PLACE) continue;
                ((Place)transition).drawGraphBoxP.setColorWithNumber(true, randomColor, false, 0.0, true, "");
            }
            for (Arc arc : pse.partialArcs) {
                arc.arcDecoBox.setColor(true, randomColor);
            }
        }
        GUIManager.getDefaultGUIManager().getWorkspace().getProject().repaintAllGraphPanels();
    }

    private int[] calcHungarianCels(ArrayList<ArrayList<GreatCommonSubnet>> subNetArrayList) {
        double[][] matrix = new double[subNetArrayList.size()][subNetArrayList.get(0).size()];
        for (int i = 0; i < subNetArrayList.size(); ++i) {
            for (int j = 0; j < subNetArrayList.get(i).size(); ++j) {
                matrix[i][j] = 1.0 - subNetArrayList.get((int)i).get((int)j).gcsValue;
            }
        }
        Hungarian h = new Hungarian(matrix);
        int[] result = h.execute();
        for (int i = 0; i < result.length; ++i) {
        }
        return result;
    }

    private void colorIsomorphicCels(int row, int col, Component comp, ArrayList<ArrayList<GreatCommonSubnet>> subNetArrayList) {
        if (subNetArrayList.get((int)row).get((int)col).gcsValue == (double)subNetArrayList.get((int)row).get((int)col).firstNetNodeSize) {
            comp.setBackground(Color.green);
        } else if (subNetArrayList.get((int)row).get((int)col).gcsValue == 0.0) {
            comp.setBackground(Color.red);
        } else if (subNetArrayList.get((int)row).get((int)col).gcsValue > (double)subNetArrayList.get((int)row).get((int)col).firstNetNodeSize || subNetArrayList.get((int)row).get((int)col).gcsValue > (double)subNetArrayList.get((int)row).get((int)col).secondNetNodeSize) {
            comp.setBackground(Color.blue);
        } else {
            comp.setBackground(Color.white);
        }
    }

    class RowHeaderRenderer
    extends JLabel
    implements ListCellRenderer {
        RowHeaderRenderer(JTable table) {
            JTableHeader header = table.getTableHeader();
            this.setOpaque(true);
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            this.setHorizontalAlignment(0);
            this.setForeground(header.getForeground());
            this.setBackground(header.getBackground());
            this.setFont(header.getFont());
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setText(value == null ? "" : value.toString());
            return this;
        }
    }
}

