/*
 * Decompiled with CFR 0.152.
 */
package holmes.windows.decompositions;

import holmes.darkgui.GUIManager;
import holmes.files.io.snoopy.SnoopyReader;
import holmes.graphpanel.GraphPanel;
import holmes.petrinet.data.IdGenerator;
import holmes.petrinet.data.PetriNet;
import holmes.petrinet.elements.Arc;
import holmes.petrinet.elements.ElementLocation;
import holmes.petrinet.elements.Node;
import holmes.petrinet.elements.Place;
import holmes.petrinet.elements.Transition;
import holmes.tables.MergeNodesTableModel;
import holmes.utilities.Tools;
import holmes.workspace.ExtensionFileFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;

public class HolmesMergeNets
extends JFrame {
    private static final long serialVersionUID = -1099324397672549971L;
    private GUIManager overlord = GUIManager.getDefaultGUIManager();
    private PetriNet pn = this.overlord.getWorkspace().getProject();
    private JFrame ego = this;
    private ArrayList<Transition> transitions;
    private ArrayList<Place> places = this.pn.getPlaces();
    private ArrayList<Arc> arcs;
    private ArrayList<Node> nodes;
    private ArrayList<Transition> newTransitions;
    private ArrayList<Place> newPlaces;
    private ArrayList<Node> newNodes;
    private ArrayList<Arc> newArcs;
    private JTable projectTable;
    private JTable mergeTable;
    private JTable importTable;
    private MergeNodesTableModel projectTableModel;
    private MergeNodesTableModel mergeTableModel;
    private MergeNodesTableModel importTableModel;
    private boolean transitionView = true;

    public HolmesMergeNets() {
        this.transitions = this.pn.getTransitions();
        this.arcs = this.pn.getArcs();
        this.nodes = this.pn.getNodes();
        this.initalizeComponents();
        this.initiateListeners();
        this.setVisible(true);
        this.fillProjectTable();
        this.overlord.getFrame().setEnabled(false);
    }

    private void initalizeComponents() {
        try {
            this.setIconImage(Tools.getImageFromIcon("/icons/holmesicon.png"));
        }
        catch (Exception ex) {
            GUIManager.getDefaultGUIManager().log("Error (482301297) | Exception:  " + ex.getMessage(), "error", true);
        }
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(1024, 800));
        this.setLocation(50, 50);
        this.setResizable(true);
        this.setTitle("Holmes net joining tool");
        this.setLayout(new BorderLayout());
        JPanel main = new JPanel(new BorderLayout());
        main.add((Component)this.getUpperPanel(), "North");
        main.add((Component)this.getMainPanel(), "Center");
        this.add((Component)main, "Center");
    }

    public JPanel getUpperPanel() {
        JPanel result = new JPanel(null);
        result.setBorder(BorderFactory.createTitledBorder("Buttons"));
        result.setPreferredSize(new Dimension(800, 80));
        int posXda = 10;
        int posYda = 25;
        JButton loadSnoopyButton = new JButton("<html>Load Snoopy<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;file&nbsp;&nbsp;&nbsp;&nbsp;</html>");
        loadSnoopyButton.setBounds(posXda, posYda, 150, 36);
        loadSnoopyButton.setMargin(new Insets(0, 0, 0, 0));
        loadSnoopyButton.setFocusPainted(false);
        loadSnoopyButton.setIcon(Tools.getResIcon32("/icons/mergeWindow/importFromSnoopy.png"));
        loadSnoopyButton.setToolTipText("Load net from Snoopy file to merge with current one");
        loadSnoopyButton.addActionListener(actionEvent -> this.handleSnoopyImport());
        result.add(loadSnoopyButton);
        JButton loadHolmesButton = new JButton("<html>Load Holmes<br>&nbsp;&nbsp;&nbsp;project&nbsp;</html>");
        loadHolmesButton.setBounds(posXda + 160, posYda, 150, 36);
        loadHolmesButton.setMargin(new Insets(0, 0, 0, 0));
        loadHolmesButton.setFocusPainted(false);
        loadHolmesButton.setIcon(Tools.getResIcon32("/icons/mergeWindow/importFromHolmes.png"));
        loadHolmesButton.setToolTipText("Load net from Holmes project file to merge with current one");
        loadHolmesButton.addActionListener(actionEvent -> {});
        result.add(loadHolmesButton);
        JButton mergeButton = new JButton("<html>Merge nets</html>");
        mergeButton.setBounds(posXda + 320, posYda, 150, 36);
        mergeButton.setMargin(new Insets(0, 0, 0, 0));
        mergeButton.setFocusPainted(false);
        mergeButton.setIcon(Tools.getResIcon32("/icons/mergeWindow/mergeNet.png"));
        mergeButton.setToolTipText("Integrate project net and imported net");
        mergeButton.addActionListener(actionEvent -> this.mergeNets());
        result.add(mergeButton);
        return result;
    }

    public JPanel getMainPanel() {
        JPanel results = new JPanel(new BorderLayout());
        results.setPreferredSize(new Dimension(1000, 800));
        JPanel tablesPanel = new JPanel();
        tablesPanel.setPreferredSize(new Dimension(1000, 600));
        BoxLayout boxLayout = new BoxLayout(tablesPanel, 0);
        tablesPanel.setLayout(boxLayout);
        JPanel leftTablePanel = new JPanel(new BorderLayout());
        leftTablePanel.setBorder(BorderFactory.createTitledBorder("Active project net"));
        leftTablePanel.setPreferredSize(new Dimension(440, 800));
        JPanel middleTablePanel = new JPanel(new BorderLayout());
        middleTablePanel.setBorder(BorderFactory.createTitledBorder("Interface elements"));
        middleTablePanel.setPreferredSize(new Dimension(150, 800));
        middleTablePanel.setMinimumSize(new Dimension(150, 800));
        middleTablePanel.setMaximumSize(new Dimension(150, 800));
        JPanel rightTablePanel = new JPanel(new BorderLayout());
        rightTablePanel.setBorder(BorderFactory.createTitledBorder("Loaded net"));
        rightTablePanel.setPreferredSize(new Dimension(440, 800));
        this.projectTableModel = new MergeNodesTableModel();
        this.projectTable = new JTable(this.projectTableModel);
        this.projectTable.getColumnModel().getColumn(0).setHeaderValue("ID");
        this.projectTable.getColumnModel().getColumn(0).setPreferredWidth(30);
        this.projectTable.getColumnModel().getColumn(0).setMinWidth(30);
        this.projectTable.getColumnModel().getColumn(0).setMaxWidth(30);
        this.projectTable.getColumnModel().getColumn(0).setResizable(false);
        this.projectTable.getColumnModel().getColumn(1).setHeaderValue("Name:");
        this.projectTable.getColumnModel().getColumn(1).setMinWidth(100);
        this.projectTable.getColumnModel().getColumn(2).setHeaderValue("Pre:");
        this.projectTable.getColumnModel().getColumn(2).setPreferredWidth(40);
        this.projectTable.getColumnModel().getColumn(2).setMinWidth(40);
        this.projectTable.getColumnModel().getColumn(2).setMaxWidth(40);
        this.projectTable.getColumnModel().getColumn(3).setHeaderValue("Post:");
        this.projectTable.getColumnModel().getColumn(3).setPreferredWidth(40);
        this.projectTable.getColumnModel().getColumn(3).setMinWidth(40);
        this.projectTable.getColumnModel().getColumn(3).setMaxWidth(40);
        this.projectTable.setAutoResizeMode(4);
        this.projectTable.setFillsViewportHeight(true);
        JScrollPane tableScrollPane = new JScrollPane(this.projectTable, 20, 30);
        leftTablePanel.add((Component)tableScrollPane, "Center");
        this.mergeTableModel = new MergeNodesTableModel();
        this.mergeTable = new JTable(this.mergeTableModel);
        this.mergeTable.getColumnModel().getColumn(1).setHeaderValue("Merge:");
        this.mergeTable.getColumnModel().getColumn(1).setPreferredWidth(130);
        this.mergeTable.removeColumn(this.mergeTable.getColumnModel().getColumn(3));
        this.mergeTable.removeColumn(this.mergeTable.getColumnModel().getColumn(2));
        this.mergeTable.removeColumn(this.mergeTable.getColumnModel().getColumn(0));
        this.mergeTable.setAutoResizeMode(4);
        this.mergeTable.setFillsViewportHeight(true);
        JScrollPane tableScrollPaneRightMiddle = new JScrollPane(this.mergeTable, 20, 30);
        middleTablePanel.add((Component)tableScrollPaneRightMiddle, "Center");
        InputMap im = this.mergeTable.getInputMap(0);
        ActionMap am = this.mergeTable.getActionMap();
        im.put(KeyStroke.getKeyStroke(127, 0), "DeleteRow");
        am.put("DeleteRow", new AbstractAction(){
            private static final long serialVersionUID = 7224127781074461772L;

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = HolmesMergeNets.this.mergeTable.getSelectedRow();
                if (row > -1) {
                    String value = (String)HolmesMergeNets.this.mergeTable.getValueAt(row, 0);
                    ((MergeNodesTableModel)HolmesMergeNets.this.mergeTable.getModel()).removeRow(value);
                }
                ((MergeNodesTableModel)HolmesMergeNets.this.mergeTable.getModel()).fireTableDataChanged();
            }
        });
        this.importTableModel = new MergeNodesTableModel();
        this.importTable = new JTable(this.importTableModel);
        this.importTable.getColumnModel().getColumn(0).setHeaderValue("ID");
        this.importTable.getColumnModel().getColumn(0).setPreferredWidth(30);
        this.importTable.getColumnModel().getColumn(0).setMinWidth(30);
        this.importTable.getColumnModel().getColumn(0).setMaxWidth(30);
        this.importTable.getColumnModel().getColumn(1).setHeaderValue("Name:");
        this.importTable.getColumnModel().getColumn(1).setPreferredWidth(300);
        this.importTable.getColumnModel().getColumn(1).setMinWidth(100);
        this.importTable.getColumnModel().getColumn(2).setHeaderValue("Pre:");
        this.importTable.getColumnModel().getColumn(2).setPreferredWidth(40);
        this.importTable.getColumnModel().getColumn(2).setMinWidth(40);
        this.importTable.getColumnModel().getColumn(2).setMaxWidth(40);
        this.importTable.getColumnModel().getColumn(3).setHeaderValue("Post:");
        this.importTable.getColumnModel().getColumn(3).setPreferredWidth(40);
        this.importTable.getColumnModel().getColumn(3).setMinWidth(40);
        this.importTable.getColumnModel().getColumn(3).setMaxWidth(40);
        this.importTable.setFillsViewportHeight(true);
        this.importTable.setAutoResizeMode(4);
        JScrollPane tableScrollPaneRight = new JScrollPane(this.importTable, 20, 30);
        rightTablePanel.add((Component)tableScrollPaneRight, "Center");
        this.projectTable.getTableHeader().setReorderingAllowed(false);
        this.mergeTable.getTableHeader().setReorderingAllowed(false);
        this.importTable.getTableHeader().setReorderingAllowed(false);
        TableRowSorter<TableModel> projectSorter = new TableRowSorter<TableModel>(this.projectTable.getModel());
        this.projectTable.setRowSorter(projectSorter);
        TableRowSorter<TableModel> mergeSorter = new TableRowSorter<TableModel>(this.mergeTable.getModel());
        this.mergeTable.setRowSorter(mergeSorter);
        TableRowSorter<TableModel> importSorter = new TableRowSorter<TableModel>(this.importTable.getModel());
        this.importTable.setRowSorter(importSorter);
        JPanel topPanel = new JPanel(null);
        topPanel.setBorder(BorderFactory.createTitledBorder("Options"));
        topPanel.setPreferredSize(new Dimension(1000, 60));
        JCheckBox placesViewCheckBox = new JCheckBox("Transition view");
        placesViewCheckBox.setBounds(10, 15, 150, 20);
        placesViewCheckBox.setSelected(true);
        placesViewCheckBox.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            this.transitionView = abstractButton.getModel().isSelected();
            this.fillProjectTable();
            this.fillImportTable(this.newNodes);
        });
        topPanel.add(placesViewCheckBox);
        JButton mergeButton = new JButton("<html>Merge nodes</html>");
        mergeButton.setBounds(160, 15, 150, 36);
        mergeButton.setMargin(new Insets(0, 0, 0, 0));
        mergeButton.setFocusPainted(false);
        mergeButton.setIcon(Tools.getResIcon32("/icons/mergeWindow/mergeNodes.png"));
        mergeButton.setToolTipText("Set nodes for joining (imported net node will become another\ngraphical element location of a node from the project)");
        mergeButton.addActionListener(actionEvent -> this.addMergeLine());
        topPanel.add(mergeButton);
        JButton removeButton = new JButton("<html>Remove merge</html>");
        removeButton.setBounds(320, 15, 150, 36);
        removeButton.setMargin(new Insets(0, 0, 0, 0));
        removeButton.setFocusPainted(false);
        removeButton.setIcon(Tools.getResIcon32("/icons/mergeWindow/removeMergeLine.png"));
        removeButton.setToolTipText("Remove merge line");
        removeButton.addActionListener(actionEvent -> {
            int row = this.mergeTable.getSelectedRow();
            if (row > -1) {
                String value = (String)this.mergeTable.getValueAt(row, 0);
                ((MergeNodesTableModel)this.mergeTable.getModel()).removeRow(value);
            }
            ((MergeNodesTableModel)this.mergeTable.getModel()).fireTableDataChanged();
        });
        topPanel.add(removeButton);
        results.add((Component)topPanel, "North");
        results.add((Component)tablesPanel, "Center");
        tablesPanel.add(leftTablePanel);
        tablesPanel.add(middleTablePanel);
        tablesPanel.add(rightTablePanel);
        return results;
    }

    private void mergeNets() {
        Point oldPos;
        if (this.newNodes == null || this.newNodes.size() == 0) {
            return;
        }
        Dimension dimSheet0 = this.getSheet0NetSize();
        Dimension dimImportedNet = this.getImportedNetSize();
        ArrayList<ArrayList<DataTuple>> vectors = this.getNodesMerge();
        ArrayList<DataTuple> dataTrans = vectors.get(0);
        ArrayList<DataTuple> dataPlaces = vectors.get(1);
        ArrayList<Place> importedPlacesToRemove = new ArrayList<Place>();
        ArrayList<Transition> importedTransitionsToRemove = new ArrayList<Transition>();
        for (DataTuple pData : dataPlaces) {
            Place projectPlace = this.places.get(pData.n_org);
            Place importedPlace = this.newPlaces.get(pData.n_imp);
            importedPlacesToRemove.add(importedPlace);
            projectPlace.setPortal(true);
            for (ElementLocation el : importedPlace.getElementLocations()) {
                projectPlace.getElementLocations().add(el);
                el.setParentNode(projectPlace);
                oldPos = el.getPosition();
                oldPos.setLocation(oldPos.x, oldPos.y + dimSheet0.height);
                el.setSheetID(0);
            }
            for (ElementLocation el : importedPlace.getTextsLocations(GUIManager.locationMoveType.NAME)) {
                projectPlace.getTextsLocations(GUIManager.locationMoveType.NAME).add(el);
                el.setParentNode(projectPlace);
                el.setSheetID(0);
            }
            for (ElementLocation el : importedPlace.getTextsLocations(GUIManager.locationMoveType.ALPHA)) {
                projectPlace.getTextsLocations(GUIManager.locationMoveType.ALPHA).add(el);
                el.setParentNode(projectPlace);
                el.setSheetID(0);
            }
            for (ElementLocation el : importedPlace.getTextsLocations(GUIManager.locationMoveType.BETA)) {
                projectPlace.getTextsLocations(GUIManager.locationMoveType.BETA).add(el);
                el.setParentNode(projectPlace);
                el.setSheetID(0);
            }
            for (ElementLocation el : importedPlace.getTextsLocations(GUIManager.locationMoveType.GAMMA)) {
                projectPlace.getTextsLocations(GUIManager.locationMoveType.GAMMA).add(el);
                el.setParentNode(projectPlace);
                el.setSheetID(0);
            }
            for (ElementLocation el : importedPlace.getTextsLocations(GUIManager.locationMoveType.TAU)) {
                projectPlace.getTextsLocations(GUIManager.locationMoveType.TAU).add(el);
                el.setParentNode(projectPlace);
                el.setSheetID(0);
            }
        }
        for (DataTuple tData : dataTrans) {
            Iterator<Point> projectTrans = this.transitions.get(tData.n_org);
            Transition importedTrans = this.newTransitions.get(tData.n_imp);
            importedTransitionsToRemove.add(importedTrans);
            ((Node)((Object)projectTrans)).setPortal(true);
            for (ElementLocation el : importedTrans.getElementLocations()) {
                ((Node)((Object)projectTrans)).getElementLocations().add(el);
                el.setParentNode((Node)((Object)projectTrans));
                oldPos = el.getPosition();
                oldPos.setLocation(oldPos.x, oldPos.y + dimSheet0.height);
                el.setSheetID(0);
            }
            for (ElementLocation el : importedTrans.getTextsLocations(GUIManager.locationMoveType.NAME)) {
                ((Node)((Object)projectTrans)).getTextsLocations(GUIManager.locationMoveType.NAME).add(el);
                el.setParentNode((Node)((Object)projectTrans));
                el.setSheetID(0);
            }
            for (ElementLocation el : importedTrans.getTextsLocations(GUIManager.locationMoveType.ALPHA)) {
                ((Node)((Object)projectTrans)).getTextsLocations(GUIManager.locationMoveType.ALPHA).add(el);
                el.setParentNode((Node)((Object)projectTrans));
                el.setSheetID(0);
            }
            for (ElementLocation el : importedTrans.getTextsLocations(GUIManager.locationMoveType.BETA)) {
                ((Node)((Object)projectTrans)).getTextsLocations(GUIManager.locationMoveType.BETA).add(el);
                el.setParentNode((Node)((Object)projectTrans));
                el.setSheetID(0);
            }
            for (ElementLocation el : importedTrans.getTextsLocations(GUIManager.locationMoveType.GAMMA)) {
                ((Node)((Object)projectTrans)).getTextsLocations(GUIManager.locationMoveType.GAMMA).add(el);
                el.setParentNode((Node)((Object)projectTrans));
                el.setSheetID(0);
            }
            for (ElementLocation el : importedTrans.getTextsLocations(GUIManager.locationMoveType.TAU)) {
                ((Node)((Object)projectTrans)).getTextsLocations(GUIManager.locationMoveType.TAU).add(el);
                el.setParentNode((Node)((Object)projectTrans));
                el.setSheetID(0);
            }
        }
        for (Place place : importedPlacesToRemove) {
            this.newNodes.remove(place);
        }
        for (Transition trans : importedTransitionsToRemove) {
            this.newNodes.remove(trans);
        }
        for (Node n : this.newNodes) {
            n.importOnlySetID(IdGenerator.getNextId());
            for (ElementLocation el : n.getElementLocations()) {
                Point oldPos2 = el.getPosition();
                oldPos2.setLocation(oldPos2.x, oldPos2.y + dimSheet0.height);
            }
            this.nodes.add(n);
            if (n instanceof Place) {
                this.pn.accessStatesManager().addPlace((Place)n);
                this.pn.accessSSAmanager().addPlace();
                continue;
            }
            if (!(n instanceof Transition)) continue;
            this.pn.accessFiringRatesManager().addTrans();
        }
        for (Arc a : this.newArcs) {
            a.importOnlySetID(IdGenerator.getNextId());
            for (Point p : a.accessBreaks()) {
                p.setLocation(p.x, p.y + dimSheet0.height);
            }
            this.arcs.add(a);
        }
        try {
            GraphPanel graphPanel = this.overlord.getWorkspace().getSheets().get(0).getGraphPanel();
            int width = dimSheet0.width;
            int height = dimSheet0.height;
            int addW = dimImportedNet.width;
            int addHeight = dimImportedNet.height;
            graphPanel.setSize(new Dimension(width + addW + 200, height + addHeight + 100));
            graphPanel.setOriginSize(new Dimension(width + addW + 200, height + addHeight + 100));
        }
        catch (Exception e) {
            GUIManager.getDefaultGUIManager().log("Error: cannot resize sheets.", "error", true);
        }
        this.overlord.reset.reset2ndOrderData(true);
        this.overlord.markNetChange();
        this.pn.repaintAllGraphPanels();
    }

    private ArrayList<ArrayList<DataTuple>> getNodesMerge() {
        try {
            ArrayList<ArrayList<DataTuple>> result = new ArrayList<ArrayList<DataTuple>>();
            ArrayList<String> tableData = this.mergeTableModel.getMergeVector();
            ArrayList<DataTuple> dataPlaces = new ArrayList<DataTuple>();
            ArrayList<DataTuple> dataTrans = new ArrayList<DataTuple>();
            for (String str : tableData) {
                String firstInt = str.substring(1, str.indexOf(" "));
                String secondInt = str.substring(str.indexOf(" <== ") + 6);
                DataTuple newP = new DataTuple(Integer.parseInt(firstInt), Integer.parseInt(secondInt));
                if (str.charAt(0) == 'p') {
                    dataPlaces.add(newP);
                    continue;
                }
                dataTrans.add(newP);
            }
            result.add(dataTrans);
            result.add(dataPlaces);
            return result;
        }
        catch (Exception e) {
            return null;
        }
    }

    private Dimension getSheet0NetSize() {
        Dimension dimSheet0 = new Dimension(0, 0);
        for (Node n : this.nodes) {
            for (ElementLocation el : n.getElementLocations()) {
                int subNet = el.getSheetID();
                if (subNet != 0) continue;
                if (dimSheet0.getWidth() < (double)el.getPosition().x) {
                    dimSheet0.setSize((double)el.getPosition().x, dimSheet0.getHeight());
                }
                if (!(dimSheet0.getHeight() < (double)el.getPosition().y)) continue;
                dimSheet0.setSize(dimSheet0.getWidth(), (double)el.getPosition().y);
            }
        }
        return dimSheet0;
    }

    private Dimension getImportedNetSize() {
        Dimension dimSheet0 = new Dimension(0, 0);
        for (Node n : this.newNodes) {
            for (ElementLocation el : n.getElementLocations()) {
                int subNet = el.getSheetID();
                if (subNet != 0) continue;
                if (dimSheet0.getWidth() < (double)el.getPosition().x) {
                    dimSheet0.setSize((double)el.getPosition().x, dimSheet0.getHeight());
                }
                if (!(dimSheet0.getHeight() < (double)el.getPosition().y)) continue;
                dimSheet0.setSize(dimSheet0.getWidth(), (double)el.getPosition().y);
            }
        }
        return dimSheet0;
    }

    protected void handleSnoopyImport() {
        FileFilter[] filters;
        String lastPath = this.overlord.getLastPath();
        String selectedFile = Tools.selectFileDialog(lastPath, filters = new FileFilter[]{new ExtensionFileFilter("All supported Snoopy files", new String[]{"SPPED", "SPEPT", "SPTPT"}), new ExtensionFileFilter("Snoopy Petri Net file (.spped)", new String[]{"SPPED"}), new ExtensionFileFilter("Snoopy Extended PN file (.spept)", new String[]{"SPEPT"}), new ExtensionFileFilter("Snoopy Time PN file (.sptpt)", new String[]{"SPTPT"}), new ExtensionFileFilter(".pnt - INA PNT file (.pnt)", new String[]{"PNT"})}, "Select PN", "Select petri net file", "");
        if (selectedFile.equals("")) {
            return;
        }
        File file = new File(selectedFile);
        if (!file.exists()) {
            return;
        }
        String path = file.getPath();
        if (path.endsWith(".spped") || path.endsWith(".spept") || path.endsWith(".colpn") || path.endsWith(".sptpt")) {
            SnoopyReader reader = new SnoopyReader(0, path);
            this.newNodes = reader.getNodesList();
            this.newArcs = reader.getArcList();
        }
        this.newTransitions = new ArrayList();
        this.newPlaces = new ArrayList();
        for (Node n : this.newNodes) {
            if (n instanceof Transition) {
                this.newTransitions.add((Transition)n);
                continue;
            }
            if (!(n instanceof Place)) continue;
            this.newPlaces.add((Place)n);
        }
        if (this.newNodes.size() > 0 && this.newArcs.size() > 0) {
            this.fillImportTable(this.newNodes);
        } else {
            JOptionPane.showMessageDialog(this.ego, "Unable to continue. Loaded nodes and/or arcs sets are empty.", "Error: no data", 0);
        }
    }

    protected void addMergeLine() {
        String rowString;
        int leftSelection = this.projectTable.getSelectedRow();
        int rightSelection = this.importTable.getSelectedRow();
        if (leftSelection < 0 || rightSelection < 0) {
            return;
        }
        String leftTableValue = "" + this.projectTable.getValueAt(leftSelection, 0);
        String rightTableValue = "" + this.importTable.getValueAt(rightSelection, 0);
        String prefix = "p";
        if (this.transitionView) {
            prefix = "t";
        }
        if (this.mergeTableModel.elementIndex(rowString = prefix + leftTableValue + " <== " + prefix + rightTableValue) == -1) {
            this.mergeTableModel.addNew(-1, rowString, 0, 0);
            ((MergeNodesTableModel)this.mergeTable.getModel()).fireTableDataChanged();
        } else {
            JOptionPane.showMessageDialog(this.ego, "Row already present in the merge table!", "Value present", 1);
        }
    }

    private void fillProjectTable() {
        if (this.transitionView) {
            this.projectTableModel.clearModel();
            int id = 0;
            for (Transition trans : this.transitions) {
                this.projectTableModel.addNew(id++, trans.getName(), trans.getPrePlaces().size(), trans.getPostPlaces().size());
            }
        } else {
            this.projectTableModel.clearModel();
            int id = 0;
            for (Place place : this.places) {
                this.projectTableModel.addNew(id++, place.getName(), place.getPreTransitions().size(), place.getPostTransitions().size());
            }
        }
        this.projectTable.setFillsViewportHeight(true);
        this.projectTable.validate();
    }

    private void fillImportTable(ArrayList<Node> nodes) {
        if (nodes == null || nodes.size() == 0) {
            return;
        }
        if (this.transitionView) {
            this.importTableModel.clearModel();
            int id = 0;
            for (Node trans : nodes) {
                if (!(trans instanceof Transition)) continue;
                this.importTableModel.addNew(id++, trans.getName(), ((Transition)trans).getPrePlaces().size(), ((Transition)trans).getPostPlaces().size());
            }
        } else {
            this.importTableModel.clearModel();
            int id = 0;
            for (Node place : nodes) {
                if (!(place instanceof Place)) continue;
                this.importTableModel.addNew(id++, place.getName(), ((Place)place).getPreTransitions().size(), ((Place)place).getPostTransitions().size());
            }
        }
        this.importTable.setFillsViewportHeight(true);
        this.importTable.validate();
    }

    private void initiateListeners() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                HolmesMergeNets.this.setDefaultCloseOperation(2);
                HolmesMergeNets.this.overlord.getFrame().setEnabled(true);
            }
        });
    }

    private static class DataTuple {
        int n_org;
        int n_imp;

        public DataTuple(int x, int y) {
            this.n_org = x;
            this.n_imp = y;
        }
    }
}

