/*
 * Decompiled with CFR 0.152.
 */
package holmes.windows.decompositions;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.xml.StaxDriver;
import holmes.analyse.comparison.LabelNetComparator;
import holmes.darkgui.GUIManager;
import holmes.files.io.ProjectReader;
import holmes.petrinet.data.PetriNetData;
import holmes.windows.decompositions.HolmesGraphletsPrototype;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.filechooser.FileNameExtensionFilter;

public class HolmesLabelComparison
extends JFrame {
    JTextArea resultArea = null;
    PetriNetData fPND = null;
    PetriNetData sPND = null;
    private JPanel mainPanel;

    public HolmesLabelComparison() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(900, 300));
        this.setLocation(15, 15);
        this.mainPanel = this.createMainPanel();
        this.add((Component)this.mainPanel, "Center");
        this.add((Component)this.createOutputPanel(10, 50, 800, 200), "South");
    }

    private JPanel createMainPanel() {
        JPanel panel = new JPanel();
        JButton getFirstNetButton = new JButton("Get first Net");
        getFirstNetButton.setBounds(10, 10, 150, 20);
        getFirstNetButton.addActionListener(actionEvent -> this.getNet(actionEvent, true));
        panel.add(getFirstNetButton);
        JButton getSecondNetButton = new JButton("Get second Net");
        getSecondNetButton.setBounds(200, 10, 150, 20);
        getSecondNetButton.addActionListener(actionEvent -> this.getNet(actionEvent, false));
        panel.add(getSecondNetButton);
        JButton compareButton = new JButton("Compare");
        compareButton.setBounds(400, 10, 150, 20);
        compareButton.addActionListener(actionEvent -> this.compare(actionEvent));
        panel.add(compareButton);
        JButton calc = new JButton("Compare");
        calc.setBounds(500, 10, 150, 20);
        calc.addActionListener(actionEvent -> this.calculate(actionEvent));
        panel.add(calc);
        return panel;
    }

    private void calculate(ActionEvent actionEvent) {
        HolmesGraphletsPrototype hgp = new HolmesGraphletsPrototype("C:\\Eksperyment\\Wyniki\\");
        hgp.compareDRGFwithoutDensity();
    }

    private JPanel createOutputPanel(int x, int y, int width, int height) {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.setBorder(BorderFactory.createTitledBorder("Data"));
        panel.setPreferredSize(new Dimension(width, height));
        this.resultArea = new JTextArea();
        this.resultArea.setText("");
        this.resultArea.setLayout(new BorderLayout());
        panel.add((Component)new JScrollPane(this.resultArea), "Center");
        return panel;
    }

    private void compare(ActionEvent actionEvent) {
        if (this.fPND != null && this.sPND != null) {
            LabelNetComparator lnc = new LabelNetComparator(this.fPND, this.sPND);
            lnc.calcSimilarities();
            this.resultArea.append("---Differences from first Net---\n");
            for (String s : lnc.getDifferencesFromFirstNet()) {
                this.resultArea.append(s + "\n");
            }
            this.resultArea.append("\n\n---Differences from second Net---\n");
            for (String s : lnc.getDifferencesFromSecondNet()) {
                this.resultArea.append(s + "\n");
            }
            this.resultArea.append("\n\n---Common parts---\n");
            for (String s : lnc.getSimilarities()) {
                this.resultArea.append(s + "\n");
            }
        }
    }

    public void getNet(ActionEvent actionEvent, boolean type) {
        JFileChooser firstNetChooser = new JFileChooser();
        FileNameExtensionFilter fnef = new FileNameExtensionFilter("Holmes format", "project");
        firstNetChooser.setFileFilter(fnef);
        int returnVal = firstNetChooser.showSaveDialog(this);
        if (returnVal == 0) {
            try {
                ProjectReader pRdr = new ProjectReader(true);
                boolean status = pRdr.readProjectForLabelComparison(firstNetChooser.getSelectedFile().getPath());
                XStream xstream = new XStream(new StaxDriver());
                xstream.alias("petriNet", PetriNetData.class);
                File source = new File(firstNetChooser.getSelectedFile().getPath());
                if (type) {
                    this.fPND = new PetriNetData(pRdr.getNodes(), pRdr.getArcs(), "First Net");
                } else {
                    this.sPND = new PetriNetData(pRdr.getNodes(), pRdr.getArcs(), "Second Net");
                }
            }
            catch (Exception ex) {
                GUIManager.getDefaultGUIManager().log("Error (236840455) | Exception:  " + ex.getMessage(), "error", true);
            }
        }
    }
}

