/*
 * Decompiled with CFR 0.152.
 */
package holmes.windows.decompositions;

import holmes.analyse.GraphletsCalculator;
import holmes.analyse.comparison.GraphletComparator;
import holmes.analyse.comparison.experiment.NetGenerator;
import holmes.darkgui.GUIManager;
import holmes.files.io.IOprotocols;
import holmes.petrinet.data.PetriNet;
import holmes.petrinet.elements.Arc;
import holmes.petrinet.elements.Node;
import holmes.petrinet.elements.PetriNetElement;
import holmes.petrinet.elements.Place;
import holmes.petrinet.elements.Transition;
import holmes.utilities.ColorPalette;
import holmes.utilities.Tools;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class HolmesGraphletsPrototype {
    private GUIManager overlord;
    private JPanel mainPanel;
    JComboBox<String> orbit;
    JComboBox<String> nodeList;
    JComboBox<String> graphletList;
    JTextArea jtaImin;
    JTextArea jtaJmin;
    JTextArea jtaPmin;
    JTextArea jtaImax;
    JTextArea jtaJmax;
    JTextArea jtaPmax;
    JComboBox<String> orbitSorted;
    JComboBox<String> graphletListSorted;
    JComboBox<String> graphletListUniq;
    String[] orbitData = new String[]{" --O-- "};
    String[] nodeData = new String[]{" --N-- "};
    String[] graphData = new String[]{" --G-- "};
    String[] orbitDataSorted = new String[]{" --OS-- "};
    String[] graphDataSorted = new String[]{" --GS-- "};
    String[] graphDataUniq = new String[]{" --GU-- "};
    String basePath = "";

    public HolmesGraphletsPrototype() {
    }

    public HolmesGraphletsPrototype(String path) {
        this.basePath = path;
    }

    private JPanel createMainPanel() {
        JPanel panel = new JPanel(new FlowLayout());
        int posX = 0;
        int posY = 0;
        JButton generateButton = new JButton("<html>Generate</html>");
        generateButton.setBounds(posX, posY, 120, 36);
        generateButton.setMargin(new Insets(0, 0, 0, 0));
        generateButton.setIcon(Tools.getResIcon32("/icons/stateSim/computeData.png"));
        generateButton.addActionListener(actionEvent -> this.generateGraphletOrbits());
        generateButton.setFocusPainted(false);
        panel.add(generateButton);
        this.orbit = new JComboBox<String>(this.orbitData);
        this.orbit.setBounds(posX + 130, posY, 250, 20);
        this.orbit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JComboBox comboBox = (JComboBox)actionEvent.getSource();
                int selected = comboBox.getSelectedIndex();
                ArrayList<CallSite> data = new ArrayList<CallSite>();
                for (int i = 0; i < GraphletsCalculator.graphlets.get(selected).size(); ++i) {
                    data.add((CallSite)((Object)("Node : " + i)));
                }
                HolmesGraphletsPrototype.this.nodeData = (String[])data.stream().toArray(String[]::new);
                HolmesGraphletsPrototype.this.nodeList.setModel(new DefaultComboBoxModel<String>(HolmesGraphletsPrototype.this.nodeData));
                ArrayList<CallSite> dataS = new ArrayList<CallSite>();
                for (int i = 0; i < GraphletsCalculator.sortedGraphlets.get(selected).size(); ++i) {
                    dataS.add((CallSite)((Object)("Graphlet : " + i)));
                }
                HolmesGraphletsPrototype.this.graphDataSorted = (String[])dataS.stream().toArray(String[]::new);
                HolmesGraphletsPrototype.this.graphletListSorted.setModel(new DefaultComboBoxModel<String>(HolmesGraphletsPrototype.this.graphDataSorted));
            }
        });
        panel.add(this.orbit, "Center");
        this.nodeList = new JComboBox<String>(this.nodeData);
        this.nodeList.setBounds(posX + 130, posY + 80, 250, 20);
        this.nodeList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JComboBox comboBox = (JComboBox)actionEvent.getSource();
                int selectedOrbit = HolmesGraphletsPrototype.this.orbit.getSelectedIndex();
                int selectedNode = comboBox.getSelectedIndex();
                ArrayList<CallSite> data = new ArrayList<CallSite>();
                for (int i = 0; i < GraphletsCalculator.graphlets.get(selectedOrbit).get(selectedNode).size(); ++i) {
                    data.add((CallSite)((Object)("Graphlet : " + i)));
                }
                HolmesGraphletsPrototype.this.graphData = (String[])data.stream().toArray(String[]::new);
                HolmesGraphletsPrototype.this.graphletList.setModel(new DefaultComboBoxModel<String>(HolmesGraphletsPrototype.this.graphData));
            }
        });
        panel.add(this.nodeList, "North");
        this.graphletList = new JComboBox<String>(this.graphData);
        this.graphletList.setBounds(posX + 130, posY + 160, 250, 20);
        this.graphletList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JComboBox comboBox = (JComboBox)actionEvent.getSource();
                int selectedOrbit = HolmesGraphletsPrototype.this.orbit.getSelectedIndex();
                int selectedNode = HolmesGraphletsPrototype.this.nodeList.getSelectedIndex();
                int selectedGraphlet = comboBox.getSelectedIndex();
                ArrayList data = new ArrayList();
                GraphletsCalculator.Struct graphletStructure = GraphletsCalculator.graphlets.get(selectedOrbit).get(selectedNode).get(selectedGraphlet);
                HolmesGraphletsPrototype.this.paintGraphlet(graphletStructure);
            }
        });
        panel.add(this.graphletList, "East");
        this.jtaImin = new JTextArea("Set Place min number +10");
        this.jtaImin.setBounds(posX + 130, posY + 160, 250, 20);
        panel.add((Component)this.jtaImin, "South");
        this.jtaImax = new JTextArea("Set Place max numbejtaIr +10");
        this.jtaImax.setBounds(posX + 130, posY + 160, 250, 20);
        panel.add((Component)this.jtaImax, "South");
        this.jtaJmin = new JTextArea("Set Transition min  number +10");
        this.jtaJmin.setBounds(posX + 130, posY + 160, 250, 20);
        panel.add((Component)this.jtaJmin, "South");
        this.jtaJmax = new JTextArea("Set Transition max number +10");
        this.jtaJmax.setBounds(posX + 130, posY + 160, 250, 20);
        panel.add((Component)this.jtaJmax, "South");
        this.jtaPmin = new JTextArea("Set min number of probe");
        this.jtaPmin.setBounds(posX + 130, posY + 160, 250, 20);
        panel.add((Component)this.jtaPmin, "South");
        this.jtaPmax = new JTextArea("Set max number of probe");
        this.jtaPmax.setBounds(posX + 130, posY + 160, 250, 20);
        panel.add((Component)this.jtaPmax, "South");
        this.graphletListSorted = new JComboBox<String>(this.graphDataSorted);
        this.graphletListSorted.setBounds(posX + 130, posY + 160, 250, 20);
        this.graphletListSorted.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JComboBox comboBox = (JComboBox)actionEvent.getSource();
                int selectedOrbit = HolmesGraphletsPrototype.this.orbit.getSelectedIndex();
                int selectedNode = HolmesGraphletsPrototype.this.nodeList.getSelectedIndex();
                int selectedGraphlet = comboBox.getSelectedIndex();
                ArrayList data = new ArrayList();
                GraphletsCalculator.Struct graphletStructure = GraphletsCalculator.sortedGraphlets.get(selectedOrbit).get(selectedGraphlet);
                HolmesGraphletsPrototype.this.paintGraphlet(graphletStructure);
            }
        });
        panel.add(this.graphletListSorted, "East");
        this.graphletListUniq = new JComboBox<String>(this.graphDataUniq);
        this.graphletListUniq.setBounds(posX + 130, posY + 160, 250, 20);
        this.graphletListUniq.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JComboBox comboBox = (JComboBox)actionEvent.getSource();
                int selectedGraphlet = comboBox.getSelectedIndex();
                GraphletsCalculator.Struct graphletStructure = GraphletsCalculator.uniqGraphlets.get(selectedGraphlet);
                HolmesGraphletsPrototype.this.paintGraphlet(graphletStructure);
            }
        });
        panel.add(this.graphletListUniq, "East");
        panel.add((Component)generateButton, "West");
        JButton genNetsButton = new JButton("<html>Generate nets</html>");
        genNetsButton.setBounds(posX, posY, 120, 36);
        genNetsButton.setMargin(new Insets(0, 0, 0, 0));
        genNetsButton.setIcon(Tools.getResIcon32("/icons/stateSim/computeData.png"));
        genNetsButton.addActionListener(actionEvent -> new NetGenerator(Integer.parseInt(this.jtaImin.getText()), Integer.parseInt(this.jtaImax.getText()), Integer.parseInt(this.jtaJmin.getText()), Integer.parseInt(this.jtaJmax.getText()), Integer.parseInt(this.jtaPmin.getText()), Integer.parseInt(this.jtaPmax.getText())));
        genNetsButton.setFocusPainted(false);
        panel.add(genNetsButton);
        JButton compNets = new JButton("<html>Compare graphlets</html>");
        compNets.setBounds(posX, posY, 120, 36);
        compNets.setMargin(new Insets(0, 0, 0, 0));
        compNets.setIcon(Tools.getResIcon32("/icons/stateSim/computeData.png"));
        compNets.addActionListener(actionEvent -> this.compareNets());
        compNets.setFocusPainted(false);
        panel.add(compNets);
        JButton saveGDD = new JButton("<html>Get GDD</html>");
        saveGDD.setBounds(posX, posY, 120, 36);
        saveGDD.setMargin(new Insets(0, 0, 0, 0));
        saveGDD.setIcon(Tools.getResIcon32("/icons/stateSim/computeData.png"));
        saveGDD.addActionListener(actionEvent -> this.getAndSaveGdd());
        saveGDD.setFocusPainted(false);
        panel.add(saveGDD);
        JButton comp = new JButton("<html>Comp old nets</html>");
        comp.setBounds(posX, posY, 120, 36);
        comp.setMargin(new Insets(0, 0, 0, 0));
        comp.setIcon(Tools.getResIcon32("/icons/stateSim/computeData.png"));
        comp.addActionListener(actionEvent -> this.compOldNets());
        comp.setFocusPainted(false);
        panel.add(comp);
        JButton compGDDA = new JButton("<html>Compare GDDA for all nets</html>");
        compGDDA.setBounds(posX, posY, 120, 36);
        compGDDA.setMargin(new Insets(0, 0, 0, 0));
        compGDDA.setIcon(Tools.getResIcon32("/icons/stateSim/computeData.png"));
        compGDDA.addActionListener(actionEvent -> this.compareAllGDDA());
        compGDDA.setFocusPainted(false);
        panel.add(compGDDA);
        JButton compGDDAstar = new JButton("<html>Compare GDDA BASE-STAR</html>");
        compGDDAstar.setBounds(posX, posY, 120, 36);
        compGDDAstar.setMargin(new Insets(0, 0, 0, 0));
        compGDDAstar.setIcon(Tools.getResIcon32("/icons/stateSim/computeData.png"));
        compGDDAstar.addActionListener(actionEvent -> this.compareAllGDDAstar());
        compGDDAstar.setFocusPainted(false);
        panel.add(compGDDAstar);
        JButton compGDDALk = new JButton("<html>Compare GDDA BASE-CYCLE</html>");
        compGDDALk.setBounds(posX, posY, 120, 36);
        compGDDALk.setMargin(new Insets(0, 0, 0, 0));
        compGDDALk.setIcon(Tools.getResIcon32("/icons/stateSim/computeData.png"));
        compGDDALk.addActionListener(actionEvent -> this.compareAllGDDALk());
        compGDDALk.setFocusPainted(false);
        panel.add(compGDDALk);
        JButton compGDDAcycle = new JButton("<html>Compare GDDA BASE-CYCLE</html>");
        compGDDAcycle.setBounds(posX, posY, 120, 36);
        compGDDAcycle.setMargin(new Insets(0, 0, 0, 0));
        compGDDAcycle.setIcon(Tools.getResIcon32("/icons/stateSim/computeData.png"));
        compGDDAcycle.addActionListener(actionEvent -> this.compareAllGDDAcycle());
        compGDDAcycle.setFocusPainted(false);
        panel.add(compGDDAcycle);
        JButton nnn = new JButton("<html>Compare GDDA with all variants</html>");
        nnn.setBounds(posX, posY, 120, 36);
        nnn.setMargin(new Insets(0, 0, 0, 0));
        nnn.setIcon(Tools.getResIcon32("/icons/stateSim/computeData.png"));
        nnn.setFocusPainted(false);
        panel.add(nnn);
        JButton test = new JButton("<html>Test Button/html>");
        test.setBounds(posX, posY, 120, 36);
        test.setMargin(new Insets(0, 0, 0, 0));
        test.setIcon(Tools.getResIcon32("/icons/stateSim/computeData.png"));
        test.addActionListener(actionEvent -> this.testMethd());
        test.setFocusPainted(false);
        panel.add(test);
        return panel;
    }

    private void testMethd() {
    }

    public void serverSecondComparisonExperiment() {
        this.compareGDDA("BASE", "1S");
        this.compareGDDA("BASE", "1S1S");
    }

    public double calcDRGF(int d, int p, String first, String Second2) {
        double result = 0.0;
        return result;
    }

    public void compareDRGF() {
        for (int d = 99; d < 303; ++d) {
            for (int p = 0; p < 100; ++p) {
                this.calcDRGF(d, p, "BASE", "S1");
                this.calcDRGF(d, p, "BASE", "S1S1");
                this.calcDRGF(d, p, "S1", "S1S1");
            }
        }
    }

    public void compareDRGFwithoutDensity() {
        for (int i = 0; i < 65; i += 5) {
            for (int j = 0; j < 65; j += 5) {
                for (int p = 0; p < 100; ++p) {
                    this.calcGraphletVector(i, j, p, "BASE");
                    this.calcGraphletVector(i, j, p, "C6VARIANT");
                    this.calcGraphletVector(i, j, p, "E2VARIANT");
                    this.calcGraphletVector(i, j, p, "K4LkVARIANT");
                    this.calcGraphletVector(i, j, p, "K4LVARIANT");
                    this.calcGraphletVector(i, j, p, "S4VARIANT");
                    this.calcGraphletVector(i, j, p, "P3VARIANT");
                    this.calcGraphletVector(i, j, p, "SS4VARIANT");
                    this.calcGraphletVector(i, j, p, "SSS4VARIANT");
                    this.calcGraphletVector(i, j, p, "ALLVARIANT");
                }
            }
        }
    }

    public void calcVectorForDRGF() {
        for (int d = 99; d < 303; ++d) {
            for (int p = 0; p < 100; ++p) {
                this.calcGraphletVector(d, p, "BASE");
                this.calcGraphletVector(d, p, "1S");
                this.calcGraphletVector(d, p, "1S1S");
                System.out.println("writen d:" + d + " p:" + p);
            }
        }
    }

    public void calcGraphletVector(int i, int j, int p, String type) {
        IOprotocols io = new IOprotocols();
        PetriNet pn = io.serverReadPNT(this.basePath + "/i" + i + "j" + j + "/i" + i + "j" + j + "p" + p + "/i" + i + "j" + j + "p" + p + "-" + type + ".pnt", 99);
        GraphletsCalculator.cleanAll();
        GraphletsCalculator.generateGraphlets();
        GraphletsCalculator.getFoundServerGraphlets(pn);
        long[] singleDRGF = new long[GraphletsCalculator.graphetsList.size()];
        for (int k = 0; k < GraphletsCalculator.graphetsList.size(); ++k) {
            long val;
            int finalI = k;
            singleDRGF[k] = val = GraphletsCalculator.uniqGraphlets.stream().filter(x -> x.getGraphletID() == finalI).count();
        }
        try {
            FileWriter myWriter = new FileWriter(this.basePath + "/i" + i + "j" + j + "/i" + i + "j" + j + "p" + p + "/i" + i + "j" + j + "p" + p + "/DRGF-" + type + ".txt");
            myWriter.write(this.convertToCSV(singleDRGF));
            myWriter.close();
            System.out.println("");
        }
        catch (IOException e) {
            System.out.println("An error occurred.");
            e.printStackTrace();
        }
    }

    public void calcGraphletVector(int d, int p, String type) {
        IOprotocols io = new IOprotocols();
        PetriNet pn = io.serverReadPNT("/home/bartek/Eksperyment/Wyniki/d" + d + "i40j40/d" + d + "i40j40p" + p + "/d" + d + "i40j40p" + p + "-" + type + ".pnt", 99);
        GraphletsCalculator.cleanAll();
        GraphletsCalculator.generateGraphlets();
        GraphletsCalculator.getFoundServerGraphlets(pn);
        long[] singleDRGF = new long[GraphletsCalculator.graphetsList.size()];
        for (int i = 0; i < GraphletsCalculator.graphetsList.size(); ++i) {
            long val;
            int finalI = i;
            singleDRGF[i] = val = GraphletsCalculator.uniqGraphlets.stream().filter(x -> x.getGraphletID() == finalI).count();
        }
        try {
            FileWriter myWriter = new FileWriter("/home/bartek/Eksperyment/Wyniki/d" + d + "i40j40/d" + d + "i40j40p" + p + "/DRGF-" + type + ".txt");
            myWriter.write(this.convertToCSV(singleDRGF));
            myWriter.close();
            System.out.println("");
        }
        catch (IOException e) {
            System.out.println("An error occurred.");
            e.printStackTrace();
        }
    }

    public String convertToCSV(long[] data) {
        String[] line = new String[data.length];
        for (int i = 0; i < data.length; ++i) {
            line[i] = String.valueOf(data[i]);
        }
        return Stream.of(line).collect(Collectors.joining(","));
    }

    public void collectDRGF() {
        System.out.println("max");
        double[][] bTableMax = this.collectDRGFFromFiles("DRGF-BASE", 0);
        double[][] sTableMax = this.collectDRGFFromFiles("DRGF-1S", 0);
        double[][] dTableMax = this.collectDRGFFromFiles("DRGF-1S1S", 0);
        System.out.println("min");
        double[][] bTableMin = this.collectDRGFFromFiles("DRGF-BASE", 1);
        double[][] sTableMin = this.collectDRGFFromFiles("DRGF-1S", 1);
        double[][] dTableMin = this.collectDRGFFromFiles("DRGF-1S1S", 1);
        System.out.println("avg");
        double[][] bTableAvg = this.collectDRGFFromFiles("DRGF-BASE", 2);
        double[][] sTableAbg = this.collectDRGFFromFiles("DRGF-1S", 2);
        double[][] dTableAvg = this.collectDRGFFromFiles("DRGF-1S1S", 2);
        String sciezka = "/home/bartek/Eksperyment/Wyniki/";
        try {
            System.out.println("Zapis");
            this.writeToCSVdrgf(bTableMax, sTableMax, dTableMax, sciezka + "drgf-max.csv");
            this.writeToCSVdrgf(bTableMin, sTableMin, dTableMin, sciezka + "drgf-min.csv");
            this.writeToCSVdrgf(bTableAvg, sTableAbg, dTableAvg, sciezka + "drgf-avg.csv");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void writeToCSVdrgf(double[][] bTable, double[][] sTable, double[][] dTable, String path) throws IOException {
        int j;
        int i;
        FileWriter writer = new FileWriter(path);
        int x = 0;
        int y = 0;
        for (i = 99; i < bTable.length; ++i) {
            for (j = 0; j < bTable[0].length; ++j) {
                writer.append(String.valueOf(bTable[i][j]));
                if (j != bTable[0].length - 1) {
                    writer.append(",");
                }
                ++x;
            }
            ++y;
            writer.append("\n");
        }
        writer.append("\n");
        x = 0;
        y = 0;
        for (i = 99; i < sTable.length; ++i) {
            for (j = 0; j < sTable[0].length; ++j) {
                writer.append(String.valueOf(sTable[i][j]));
                if (j != sTable[0].length - 1) {
                    writer.append(",");
                }
                ++x;
            }
            ++y;
            writer.append("\n");
        }
        writer.append("\n");
        x = 0;
        y = 0;
        for (i = 99; i < dTable.length; ++i) {
            for (j = 0; j < dTable[0].length; ++j) {
                writer.append(String.valueOf(dTable[i][j]));
                if (j != dTable[0].length - 1) {
                    writer.append(",");
                }
                ++x;
            }
            ++y;
            writer.append("\n");
        }
        writer.append("\n");
        writer.close();
    }

    private double[][] collectDRGFFromFiles(String s, int mod) {
        int[][][] bigTable = new int[230][100][151];
        block4: for (int d = 99; d < 230; ++d) {
            for (int p = 0; p < 100; ++p) {
                String sciezka = "/home/bartek/Eksperyment/Wyniki/d" + d + "i40j40/d" + d + "i40j40p" + p + "/";
                DataInputStream in = null;
                try {
                    in = new DataInputStream(new FileInputStream(sciezka + s + ".txt"));
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                BufferedReader buffer = new BufferedReader(new InputStreamReader(in));
                String readedLine = null;
                try {
                    readedLine = buffer.readLine();
                    if (readedLine == null) {
                        continue block4;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (!readedLine.contains(",")) continue;
                String[] line = readedLine.split(",");
                int[] count = new int[line.length];
                for (int i = 0; i < line.length; ++i) {
                    count[i] = Integer.valueOf(line[i]);
                }
                bigTable[d][p] = count;
            }
        }
        double[][] result = new double[230][100];
        for (int d = 99; d < 230; ++d) {
            System.out.println("d: " + d);
            for (int p1 = 0; p1 < 100; ++p1) {
                double[] best = new double[100];
                for (int p2 = 0; p2 < 100; ++p2) {
                    if (p1 != p2) {
                        int t1 = Arrays.stream(bigTable[d][p1]).sum();
                        int t2 = Arrays.stream(bigTable[d][p2]).sum();
                        double[] partialDistance = new double[151];
                        for (int g = 0; g < 151; ++g) {
                            double n1 = (double)bigTable[d][p1][g] / (double)t1;
                            double n2 = (double)bigTable[d][p2][g] / (double)t2;
                            partialDistance[g] = Math.abs(n1 - n2);
                        }
                        best[p2] = Arrays.stream(partialDistance).sum();
                        continue;
                    }
                    if (mod != 1) continue;
                    best[p2] = Double.MAX_VALUE;
                }
                result[d][p1] = mod == 0 ? Arrays.stream(best).max().orElse(-1.0) : (mod == 1 ? Arrays.stream(best).min().orElse(-1.0) : Arrays.stream(best).sum() / 99.0);
            }
        }
        return result;
    }

    public void collectGDDAFromFiles() {
        this.collectGDDAFromFilesDensE("BASE-BASE");
    }

    private void collectGDDAFromFilesDens(String name) {
        String sciezka = "/home/bartek/Eksperyment/Wyniki-g\u0119sto\u015b\u0107/";
        Double[][] minTab = new Double[1][400];
        Double[][] maxTab = new Double[1][400];
        Double[][] avarage = new Double[1][400];
        Double[][] ravarage = new Double[1][400];
        DataInputStream in = null;
        try {
            in = new DataInputStream(new FileInputStream(sciezka + name + ".txt"));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        BufferedReader buffer = new BufferedReader(new InputStreamReader(in));
        String wczytanaLinia = null;
        try {
            int i = -1;
            int j = -1;
            double min = -1.0;
            double max = -1.0;
            double avg = -1.0;
            double ravg = -1.0;
            int next = 0;
            while ((wczytanaLinia = buffer.readLine()) != null) {
                String[] line;
                if (wczytanaLinia.contains("==")) {
                    wczytanaLinia = wczytanaLinia.replace("==", "");
                    line = wczytanaLinia.split("-");
                    i = 0;
                    j = next;
                }
                if (wczytanaLinia.contains("min")) {
                    line = wczytanaLinia.split("\t");
                    min = Double.parseDouble(line[1]);
                }
                if (wczytanaLinia.contains("max")) {
                    line = wczytanaLinia.split("\t");
                    max = Double.parseDouble(line[1]);
                }
                if (wczytanaLinia.contains("avarage") && !wczytanaLinia.contains("reduced")) {
                    line = wczytanaLinia.split("\t");
                    avg = Double.parseDouble(line[1]);
                }
                if (!wczytanaLinia.contains("reduced")) continue;
                line = wczytanaLinia.split("\t");
                ravg = Double.parseDouble(line[1]);
                if (j < 400) {
                    minTab[0][j] = min;
                    maxTab[0][j] = max;
                    avarage[0][j] = avg;
                    ravarage[0][j] = ravg;
                }
                min = -1.0;
                max = -1.0;
                avg = -1.0;
                ravg = -1.0;
                ++next;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            this.writeToCSVDens(minTab, maxTab, avarage, ravarage, sciezka + name + ".csv");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void collectGDDAFromFilesDensE(String name) {
        String sciezka = "/home/Szavislav/Eksperyment/Wyniki-g\u0119sto\u015b\u0107/";
        Double[][] minTab = new Double[204][100];
        Double[][] maxTab = new Double[204][100];
        Double[][] avarage = new Double[204][100];
        Double[][] ravarage = new Double[204][100];
        DataInputStream in = null;
        try {
            in = new DataInputStream(new FileInputStream(sciezka + name + ".txt"));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        BufferedReader buffer = new BufferedReader(new InputStreamReader(in));
        String wczytanaLinia = null;
        int p1 = 0;
        int p2 = 0;
        int d = 0;
        try {
            int i = -1;
            int j = -1;
            double min = -1.0;
            double max = -1.0;
            double avg = -1.0;
            double ravg = -1.0;
            int next = 0;
            boolean wczytana = false;
            while ((wczytanaLinia = buffer.readLine()) != null) {
                String[] line;
                if (wczytanaLinia.contains("==")) {
                    wczytanaLinia = wczytanaLinia.replace("==", "");
                    line = wczytanaLinia.split("-");
                    System.out.println("d : " + d + " p1 : " + p1 + " p2 : " + ++p2);
                    if (++p1 == 100) {
                        p1 = 0;
                        ++d;
                    }
                }
                if (wczytanaLinia.contains("min")) {
                    line = wczytanaLinia.split("\t");
                    min = Double.parseDouble(line[1]);
                }
                if (wczytanaLinia.contains("max")) {
                    line = wczytanaLinia.split("\t");
                    max = Double.parseDouble(line[1]);
                }
                if (wczytanaLinia.contains("avarage") && !wczytanaLinia.contains("reduced")) {
                    line = wczytanaLinia.split("\t");
                    avg = Double.parseDouble(line[1]);
                }
                if (!wczytanaLinia.contains("reduced")) continue;
                line = wczytanaLinia.split("\t");
                ravg = Double.parseDouble(line[1]);
                if (p1 < 100) {
                    minTab[d][p1] = min;
                    maxTab[d][p1] = max;
                    avarage[d][p1] = avg;
                    ravarage[d][p1] = ravg;
                }
                min = -1.0;
                max = -1.0;
                avg = -1.0;
                ravg = -1.0;
                ++next;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Double[] extractedMinTab = new Double[203];
        Double[] extractedMaxTab = new Double[203];
        Double[] extractedAveTab = new Double[203];
        Double[] extractedPacTab = new Double[203];
        System.out.println("zapis");
        for (d = 0; d < 202; ++d) {
            Double min = this.getMin(minTab[d]);
            Double max = this.getMax(maxTab[d]);
            Double ave = this.getAverage(avarage[d]);
            extractedMinTab[d] = min;
            extractedMaxTab[d] = max;
            extractedAveTab[d] = ave;
        }
        try {
            this.writeToCSVDensE(extractedMinTab, extractedMaxTab, extractedAveTab, extractedPacTab);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void writeToCSVDensE(Double[] minTab, Double[] maxTab, Double[] avarage, Double[] pack) throws IOException {
        int i;
        FileWriter writer = new FileWriter("/home/Szavislav/Eksperyment/Wyniki-g\u0119sto\u015b\u0107/comparison.csv");
        for (i = 0; i < minTab.length; ++i) {
            writer.append(String.valueOf(minTab[i]));
            if (i != minTab.length - 1) {
                writer.append(",");
            }
            writer.append("\n");
        }
        writer.append("\n");
        for (i = 0; i < maxTab.length; ++i) {
            writer.append(String.valueOf(maxTab[i]));
            if (i != maxTab.length - 1) {
                writer.append(",");
            }
            writer.append("\n");
        }
        writer.append("\n");
        for (i = 0; i < avarage.length; ++i) {
            writer.append(String.valueOf(avarage[i]));
            if (i != avarage.length - 1) {
                writer.append(",");
            }
            writer.append("\n");
        }
        writer.append("\n");
        for (i = 0; i < pack.length; ++i) {
            writer.append(String.valueOf(pack[i]));
            if (i != pack.length - 1) {
                writer.append(",");
            }
            writer.append("\n");
        }
        writer.append("\n");
        writer.close();
    }

    private double getMin(Double[] doubles) {
        double result = 99.0;
        for (int i = 0; i < 100; ++i) {
            if (doubles[i] == null || !(doubles[i] < result)) continue;
            result = doubles[i];
        }
        return result;
    }

    private double getMax(Double[] doubles) {
        double result = -99.0;
        for (int i = 0; i < 100; ++i) {
            if (doubles[i] == null || !(doubles[i] > result)) continue;
            result = doubles[i];
        }
        return result;
    }

    private double getAverage(Double[] doubles) {
        double result = 0.0;
        int count = 0;
        for (int i = 0; i < 100; ++i) {
            if (doubles[i] == null) continue;
            result += doubles[i].doubleValue();
            ++count;
        }
        return result / (double)count;
    }

    private Double[] getAveragePackage(Double[] doubles) {
        Double[] result = new Double[100];
        for (int i = 0; i < 100; ++i) {
            if (doubles[i] == null) continue;
            result[i] = doubles[i];
        }
        return result;
    }

    private double getAP(Double[] doubles) {
        double result = 0.0;
        int count = 0;
        for (int i = 0; i < 100; ++i) {
            if (doubles[i] == null) continue;
            result += doubles[i].doubleValue();
            ++count;
        }
        return result / (double)count;
    }

    private void collectGDDAFromFiles(String name) {
        String sciezka = "/home/Szavislav/Eksperyment/Wyniki/";
        Double[][] minTab = new Double[50][50];
        Double[][] maxTab = new Double[50][50];
        Double[][] avarage = new Double[50][50];
        Double[][] ravarage = new Double[50][50];
        DataInputStream in = null;
        try {
            in = new DataInputStream(new FileInputStream(sciezka + name + ".txt"));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        BufferedReader buffer = new BufferedReader(new InputStreamReader(in));
        String wczytanaLinia = null;
        try {
            int i = -1;
            int j = -1;
            double min = -1.0;
            double max = -1.0;
            double avg = -1.0;
            double ravg = -1.0;
            while ((wczytanaLinia = buffer.readLine()) != null) {
                String[] line;
                if (wczytanaLinia.contains("==")) {
                    wczytanaLinia = wczytanaLinia.replace("==", "");
                    line = wczytanaLinia.split("-");
                    i = Integer.parseInt(line[0]);
                    j = Integer.parseInt(line[1]);
                }
                if (wczytanaLinia.contains("min")) {
                    line = wczytanaLinia.split("\t");
                    min = Double.parseDouble(line[1]);
                }
                if (wczytanaLinia.contains("max")) {
                    line = wczytanaLinia.split("\t");
                    max = Double.parseDouble(line[1]);
                }
                if (wczytanaLinia.contains("avarage") && !wczytanaLinia.contains("reduced")) {
                    line = wczytanaLinia.split("\t");
                    avg = Double.parseDouble(line[1]);
                }
                if (!wczytanaLinia.contains("reduced")) continue;
                line = wczytanaLinia.split("\t");
                ravg = Double.parseDouble(line[1]);
                if (i < 45 && j < 45) {
                    minTab[i][j] = min;
                    maxTab[i][j] = max;
                    avarage[i][j] = avg;
                    ravarage[i][j] = ravg;
                }
                min = -1.0;
                max = -1.0;
                avg = -1.0;
                ravg = -1.0;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            this.writeToCSV(minTab, maxTab, avarage, ravarage, sciezka + name + ".csv");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void writeToCSV(Double[][] minmatrix, Double[][] maxmatrix, Double[][] avgmatrix, Double[][] ravgmatrix, String path) throws IOException {
        int j;
        int i;
        FileWriter writer = new FileWriter(path);
        int x = 0;
        int y = 0;
        for (i = 0; i < minmatrix.length; i += 5) {
            for (j = 0; j < minmatrix[0].length; j += 5) {
                writer.append(String.valueOf(minmatrix[i][j]));
                if (j != minmatrix[0].length - 1) {
                    writer.append(",");
                }
                ++x;
            }
            ++y;
            writer.append("\n");
        }
        writer.append("\n");
        x = 0;
        y = 0;
        for (i = 0; i < maxmatrix.length; i += 5) {
            for (j = 0; j < maxmatrix[0].length; j += 5) {
                writer.append(String.valueOf(maxmatrix[i][j]));
                if (j != maxmatrix[0].length - 1) {
                    writer.append(",");
                }
                ++x;
            }
            ++y;
            writer.append("\n");
        }
        writer.append("\n");
        x = 0;
        y = 0;
        for (i = 0; i < avgmatrix.length; i += 5) {
            for (j = 0; j < avgmatrix[0].length; j += 5) {
                writer.append(String.valueOf(avgmatrix[i][j]));
                if (j != avgmatrix[0].length - 1) {
                    writer.append(",");
                }
                ++x;
            }
            ++y;
            writer.append("\n");
        }
        writer.append("\n");
        x = 0;
        y = 0;
        for (i = 0; i < ravgmatrix.length; i += 5) {
            for (j = 0; j < ravgmatrix[0].length; j += 5) {
                writer.append(String.valueOf(ravgmatrix[i][j]));
                if (j != ravgmatrix[0].length - 1) {
                    writer.append(",");
                }
                ++x;
            }
            ++y;
            writer.append("\n");
        }
        writer.append("\n");
        writer.close();
    }

    public void distortionTest() {
        String pathToBaseNet = "";
        IOprotocols io = new IOprotocols();
        PetriNet pn = io.serverReadPNT(pathToBaseNet, 99);
    }

    private void writeToCSVDens(Double[][] minmatrix, Double[][] maxmatrix, Double[][] avgmatrix, Double[][] ravgmatrix, String path) throws IOException {
        int j;
        int i;
        FileWriter writer = new FileWriter(path);
        int x = 0;
        int y = 0;
        writer.append("min,");
        for (i = 0; i < minmatrix.length; i += 5) {
            for (j = 0; j < minmatrix[0].length; ++j) {
                writer.append(String.valueOf(minmatrix[i][j]));
                if (j != minmatrix[0].length - 1) {
                    writer.append(",");
                }
                ++x;
            }
            ++y;
            writer.append("\n");
        }
        writer.append("\n");
        x = 0;
        y = 0;
        writer.append("max,");
        for (i = 0; i < maxmatrix.length; i += 5) {
            for (j = 0; j < maxmatrix[0].length; ++j) {
                writer.append(String.valueOf(maxmatrix[i][j]));
                if (j != maxmatrix[0].length - 1) {
                    writer.append(",");
                }
                ++x;
            }
            ++y;
            writer.append("\n");
        }
        writer.append("\n");
        x = 0;
        y = 0;
        writer.append("avg,");
        for (i = 0; i < avgmatrix.length; i += 5) {
            for (j = 0; j < avgmatrix[0].length; ++j) {
                writer.append(String.valueOf(avgmatrix[i][j]));
                if (j != avgmatrix[0].length - 1) {
                    writer.append(",");
                }
                ++x;
            }
            ++y;
            writer.append("\n");
        }
        writer.append("\n");
        x = 0;
        y = 0;
        writer.append("ravg,");
        for (i = 0; i < ravgmatrix.length; i += 5) {
            for (j = 0; j < ravgmatrix[0].length; ++j) {
                writer.append(String.valueOf(ravgmatrix[i][j]));
                if (j != ravgmatrix[0].length - 1) {
                    writer.append(",");
                }
                ++x;
            }
            ++y;
            writer.append("\n");
        }
        writer.append("\n");
        writer.close();
    }

    private void compareGDDA(String first, String second) {
        System.out.println(first + " - " + second);
        GraphletComparator gc600 = new GraphletComparator(600);
        for (int d = 99; d < 302; ++d) {
            for (int i = 0; i < 45; ++i) {
                for (int j = 0; j < 45; ++j) {
                    PrintWriter printWriter;
                    if (!Files.exists(Paths.get("/home/bartek/Eksperyment/Wyniki/d" + d + "i" + i + "j" + j + "/", new String[0]), new LinkOption[0])) continue;
                    double[] resultForGDDA4 = new double[100];
                    double[] resultForGDDA5 = new double[100];
                    for (int p1 = 0; p1 < 100; ++p1) {
                        if (Files.exists(Paths.get("/home/bartek/Eksperyment/Wyniki/d" + d + "i" + i + "j" + j + "/d" + d + "i" + i + "j" + j + "p" + p1 + "/", new String[0]), new LinkOption[0])) {
                            resultForGDDA5[p1] = gc600.calcDGDDA(gc600.getPath(d, i, j, p1, first), gc600.getPath(d, i, j, p1, second));
                            continue;
                        }
                        resultForGDDA4[p1] = -1.0;
                    }
                    BufferedWriter fileWriter = null;
                    BufferedWriter totalResultWriter = null;
                    System.out.println("write " + d + ":" + i + ":" + j);
                    String toSave5 = this.createBlockToSave(resultForGDDA5, i, j);
                    fileWriter = null;
                    try {
                        fileWriter = new BufferedWriter(new FileWriter("/home/bartek/Eksperyment/Wyniki/d" + d + "i" + i + "j" + j + "/" + first + "-" + second));
                        printWriter = new PrintWriter(fileWriter);
                        printWriter.append(toSave5);
                        printWriter.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    totalResultWriter = null;
                    try {
                        totalResultWriter = new BufferedWriter(new FileWriter("/home/bartek/Eksperyment/Wyniki/" + first + "-" + second + ".txt", true));
                        printWriter = new PrintWriter(totalResultWriter);
                        printWriter.append(toSave5);
                        printWriter.close();
                        continue;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private void compareAllGDDAP() {
        GraphletComparator gc98 = new GraphletComparator(98);
        GraphletComparator gc600 = new GraphletComparator(600);
        for (int i = 0; i < 100; ++i) {
            for (int j = 0; j < 100; ++j) {
                PrintWriter printWriter;
                if (!Files.exists(Paths.get("/home/Szavislav/Eksperyment/Wyniki/i" + i + "j" + j + "/", new String[0]), new LinkOption[0])) continue;
                double[] resultForGDDA4 = new double[100];
                double[] resultForGDDA5 = new double[100];
                for (int p1 = 0; p1 < 100; ++p1) {
                    if (Files.exists(Paths.get("/home/Szavislav/Eksperyment/Wyniki/i" + i + "j" + j + "/i" + i + "j" + j + "p" + p1 + "/", new String[0]), new LinkOption[0])) {
                        resultForGDDA4[p1] = gc98.calcDGDDA(gc98.getPath(i, j, p1, "BASE"), gc98.getPath(i, j, p1, "P3VARIANT"));
                        resultForGDDA5[p1] = gc600.calcDGDDA(gc600.getPath(i, j, p1, "BASE"), gc600.getPath(i, j, p1, "P3VARIANT"));
                        continue;
                    }
                    resultForGDDA4[p1] = -1.0;
                }
                String toSave4 = this.createBlockToSave(resultForGDDA4, i, j);
                BufferedWriter fileWriter = null;
                try {
                    fileWriter = new BufferedWriter(new FileWriter("/home/Szavislav/Eksperyment/Wyniki/i" + i + "j" + j + "/BASE-P-4.txt"));
                    PrintWriter printWriter2 = new PrintWriter(fileWriter);
                    printWriter2.append(toSave4);
                    printWriter2.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                BufferedWriter totalResultWriter = null;
                try {
                    totalResultWriter = new BufferedWriter(new FileWriter("/home/Szavislav/Eksperyment/Wyniki/BASE-P-4.txt", true));
                    PrintWriter printWriter3 = new PrintWriter(totalResultWriter);
                    printWriter3.append(toSave4);
                    printWriter3.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                String toSave5 = this.createBlockToSave(resultForGDDA5, i, j);
                fileWriter = null;
                try {
                    fileWriter = new BufferedWriter(new FileWriter("/home/Szavislav/Eksperyment/Wyniki/i" + i + "j" + j + "/BASE-P-5.txt"));
                    printWriter = new PrintWriter(fileWriter);
                    printWriter.append(toSave5);
                    printWriter.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                totalResultWriter = null;
                try {
                    totalResultWriter = new BufferedWriter(new FileWriter("/home/Szavislav/Eksperyment/Wyniki/BASE-P-5.txt", true));
                    printWriter = new PrintWriter(totalResultWriter);
                    printWriter.append(toSave5);
                    printWriter.close();
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void compareAllGDDAE() {
        GraphletComparator gc98 = new GraphletComparator(98);
        GraphletComparator gc600 = new GraphletComparator(600);
        for (int i = 0; i < 100; ++i) {
            for (int j = 0; j < 100; ++j) {
                PrintWriter printWriter;
                if (!Files.exists(Paths.get("/home/Szavislav/Eksperyment/Wyniki/i" + i + "j" + j + "/", new String[0]), new LinkOption[0])) continue;
                double[] resultForGDDA4 = new double[100];
                double[] resultForGDDA5 = new double[100];
                for (int p1 = 0; p1 < 100; ++p1) {
                    if (Files.exists(Paths.get("/home/Szavislav/Eksperyment/Wyniki/i" + i + "j" + j + "/i" + i + "j" + j + "p" + p1 + "/", new String[0]), new LinkOption[0])) {
                        resultForGDDA4[p1] = gc98.calcDGDDA(gc98.getPath(i, j, p1, "BASE"), gc98.getPath(i, j, p1, "E2VARIANT"));
                        resultForGDDA5[p1] = gc600.calcDGDDA(gc600.getPath(i, j, p1, "BASE"), gc600.getPath(i, j, p1, "E2VARIANT"));
                        continue;
                    }
                    resultForGDDA4[p1] = -1.0;
                }
                String toSave4 = this.createBlockToSave(resultForGDDA4, i, j);
                BufferedWriter fileWriter = null;
                try {
                    fileWriter = new BufferedWriter(new FileWriter("/home/Szavislav/Eksperyment/Wyniki/i" + i + "j" + j + "/BASE-E-4.txt"));
                    PrintWriter printWriter2 = new PrintWriter(fileWriter);
                    printWriter2.append(toSave4);
                    printWriter2.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                BufferedWriter totalResultWriter = null;
                try {
                    totalResultWriter = new BufferedWriter(new FileWriter("/home/Szavislav/Eksperyment/Wyniki/BASE-E-4.txt", true));
                    PrintWriter printWriter3 = new PrintWriter(totalResultWriter);
                    printWriter3.append(toSave4);
                    printWriter3.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                String toSave5 = this.createBlockToSave(resultForGDDA5, i, j);
                fileWriter = null;
                try {
                    fileWriter = new BufferedWriter(new FileWriter("/home/Szavislav/Eksperyment/Wyniki/i" + i + "j" + j + "/BASE-E-5.txt"));
                    printWriter = new PrintWriter(fileWriter);
                    printWriter.append(toSave5);
                    printWriter.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                totalResultWriter = null;
                try {
                    totalResultWriter = new BufferedWriter(new FileWriter("/home/Szavislav/Eksperyment/Wyniki/BASE-E-5.txt", true));
                    printWriter = new PrintWriter(totalResultWriter);
                    printWriter.append(toSave5);
                    printWriter.close();
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void compareAllGDDAL() {
        GraphletComparator gc98 = new GraphletComparator(98);
        GraphletComparator gc600 = new GraphletComparator(600);
        for (int i = 0; i < 100; ++i) {
            for (int j = 0; j < 100; ++j) {
                PrintWriter printWriter;
                if (!Files.exists(Paths.get("/home/Szavislav/Eksperyment/Wyniki/i" + i + "j" + j + "/", new String[0]), new LinkOption[0])) continue;
                double[] resultForGDDA4 = new double[100];
                double[] resultForGDDA5 = new double[100];
                for (int p1 = 0; p1 < 100; ++p1) {
                    if (Files.exists(Paths.get("/home/Szavislav/Eksperyment/Wyniki/i" + i + "j" + j + "/i" + i + "j" + j + "p" + p1 + "/", new String[0]), new LinkOption[0])) {
                        resultForGDDA4[p1] = gc98.calcDGDDA(gc98.getPath(i, j, p1, "BASE"), gc98.getPath(i, j, p1, "K4LVARIANT"));
                        resultForGDDA5[p1] = gc600.calcDGDDA(gc600.getPath(i, j, p1, "BASE"), gc600.getPath(i, j, p1, "K4LVARIANT"));
                        continue;
                    }
                    resultForGDDA4[p1] = -1.0;
                }
                String toSave4 = this.createBlockToSave(resultForGDDA4, i, j);
                BufferedWriter fileWriter = null;
                try {
                    fileWriter = new BufferedWriter(new FileWriter("/home/Szavislav/Eksperyment/Wyniki/i" + i + "j" + j + "/BASE-L-4.txt"));
                    PrintWriter printWriter2 = new PrintWriter(fileWriter);
                    printWriter2.append(toSave4);
                    printWriter2.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                BufferedWriter totalResultWriter = null;
                try {
                    totalResultWriter = new BufferedWriter(new FileWriter("/home/Szavislav/Eksperyment/Wyniki/BASE-L-4.txt", true));
                    PrintWriter printWriter3 = new PrintWriter(totalResultWriter);
                    printWriter3.append(toSave4);
                    printWriter3.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                String toSave5 = this.createBlockToSave(resultForGDDA5, i, j);
                fileWriter = null;
                try {
                    fileWriter = new BufferedWriter(new FileWriter("/home/Szavislav/Eksperyment/Wyniki/i" + i + "j" + j + "/BASE-L-5.txt"));
                    printWriter = new PrintWriter(fileWriter);
                    printWriter.append(toSave5);
                    printWriter.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                totalResultWriter = null;
                try {
                    totalResultWriter = new BufferedWriter(new FileWriter("/home/Szavislav/Eksperyment/Wyniki/BASE-L-5.txt", true));
                    printWriter = new PrintWriter(totalResultWriter);
                    printWriter.append(toSave5);
                    printWriter.close();
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void compareAllGDDALk() {
        GraphletComparator gc98 = new GraphletComparator(98);
        GraphletComparator gc600 = new GraphletComparator(600);
        for (int i = 0; i < 100; ++i) {
            for (int j = 0; j < 100; ++j) {
                PrintWriter printWriter;
                if (!Files.exists(Paths.get("/home/Szavislav/Eksperyment/Wyniki/i" + i + "j" + j + "/", new String[0]), new LinkOption[0])) continue;
                double[] resultForGDDA4 = new double[100];
                double[] resultForGDDA5 = new double[100];
                for (int p1 = 0; p1 < 100; ++p1) {
                    if (Files.exists(Paths.get("/home/Szavislav/Eksperyment/Wyniki/i" + i + "j" + j + "/i" + i + "j" + j + "p" + p1 + "/", new String[0]), new LinkOption[0])) {
                        resultForGDDA4[p1] = gc98.calcDGDDA(gc98.getPath(i, j, p1, "BASE"), gc98.getPath(i, j, p1, "K4LkVARIANT"));
                        resultForGDDA5[p1] = gc600.calcDGDDA(gc600.getPath(i, j, p1, "BASE"), gc600.getPath(i, j, p1, "K4LkVARIANT"));
                        continue;
                    }
                    resultForGDDA4[p1] = -1.0;
                }
                String toSave4 = this.createBlockToSave(resultForGDDA4, i, j);
                BufferedWriter fileWriter = null;
                try {
                    fileWriter = new BufferedWriter(new FileWriter("/home/Szavislav/Eksperyment/Wyniki/i" + i + "j" + j + "/BASE-Lk-4.txt"));
                    PrintWriter printWriter2 = new PrintWriter(fileWriter);
                    printWriter2.append(toSave4);
                    printWriter2.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                BufferedWriter totalResultWriter = null;
                try {
                    totalResultWriter = new BufferedWriter(new FileWriter("/home/Szavislav/Eksperyment/Wyniki/BASE-Lk-4.txt", true));
                    PrintWriter printWriter3 = new PrintWriter(totalResultWriter);
                    printWriter3.append(toSave4);
                    printWriter3.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                String toSave5 = this.createBlockToSave(resultForGDDA5, i, j);
                fileWriter = null;
                try {
                    fileWriter = new BufferedWriter(new FileWriter("/home/Szavislav/Eksperyment/Wyniki/i" + i + "j" + j + "/BASE-Lk-5.txt"));
                    printWriter = new PrintWriter(fileWriter);
                    printWriter.append(toSave5);
                    printWriter.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                totalResultWriter = null;
                try {
                    totalResultWriter = new BufferedWriter(new FileWriter("/home/Szavislav/Eksperyment/Wyniki/BASE-Lk-5.txt", true));
                    printWriter = new PrintWriter(totalResultWriter);
                    printWriter.append(toSave5);
                    printWriter.close();
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void compareAllGDDAcycle() {
        GraphletComparator gc98 = new GraphletComparator(98);
        GraphletComparator gc600 = new GraphletComparator(600);
        for (int i = 0; i < 100; ++i) {
            for (int j = 0; j < 100; ++j) {
                PrintWriter printWriter;
                if (!Files.exists(Paths.get("/home/Szavislav/Eksperyment/Wyniki/i" + i + "j" + j + "/", new String[0]), new LinkOption[0])) continue;
                double[] resultForGDDA4 = new double[100];
                double[] resultForGDDA5 = new double[100];
                for (int p1 = 0; p1 < 100; ++p1) {
                    if (Files.exists(Paths.get("/home/Szavislav/Eksperyment/Wyniki/i" + i + "j" + j + "/i" + i + "j" + j + "p" + p1 + "/", new String[0]), new LinkOption[0])) {
                        resultForGDDA4[p1] = gc98.calcDGDDA(gc98.getPath(i, j, p1, "BASE"), gc98.getPath(i, j, p1, "C6VARIANT"));
                        resultForGDDA5[p1] = gc600.calcDGDDA(gc600.getPath(i, j, p1, "BASE"), gc600.getPath(i, j, p1, "C6VARIANT"));
                        continue;
                    }
                    resultForGDDA4[p1] = -1.0;
                }
                String toSave4 = this.createBlockToSave(resultForGDDA4, i, j);
                BufferedWriter fileWriter = null;
                try {
                    fileWriter = new BufferedWriter(new FileWriter("/home/Szavislav/Eksperyment/Wyniki/i" + i + "j" + j + "/BASE-CYCLE-4.txt"));
                    PrintWriter printWriter2 = new PrintWriter(fileWriter);
                    printWriter2.append(toSave4);
                    printWriter2.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                BufferedWriter totalResultWriter = null;
                try {
                    totalResultWriter = new BufferedWriter(new FileWriter("/home/Szavislav/Eksperyment/Wyniki/BASE-CYCLE-4.txt", true));
                    PrintWriter printWriter3 = new PrintWriter(totalResultWriter);
                    printWriter3.append(toSave4);
                    printWriter3.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                String toSave5 = this.createBlockToSave(resultForGDDA5, i, j);
                fileWriter = null;
                try {
                    fileWriter = new BufferedWriter(new FileWriter("/home/Szavislav/Eksperyment/Wyniki/i" + i + "j" + j + "/BASE-CYCLE-5.txt"));
                    printWriter = new PrintWriter(fileWriter);
                    printWriter.append(toSave5);
                    printWriter.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                totalResultWriter = null;
                try {
                    totalResultWriter = new BufferedWriter(new FileWriter("/home/Szavislav/Eksperyment/Wyniki/BASE-CYCLE-5.txt", true));
                    printWriter = new PrintWriter(totalResultWriter);
                    printWriter.append(toSave5);
                    printWriter.close();
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void compareAllGDDAstar() {
        GraphletComparator gc98 = new GraphletComparator(98);
        GraphletComparator gc600 = new GraphletComparator(600);
        for (int i = 0; i < 100; ++i) {
            for (int j = 0; j < 100; ++j) {
                PrintWriter printWriter;
                if (!Files.exists(Paths.get("/home/Szavislav/Eksperyment/Wyniki/i" + i + "j" + j + "/", new String[0]), new LinkOption[0])) continue;
                double[] resultForGDDA4 = new double[100];
                double[] resultForGDDA5 = new double[100];
                for (int p1 = 0; p1 < 100; ++p1) {
                    if (Files.exists(Paths.get("/home/Szavislav/Eksperyment/Wyniki/i" + i + "j" + j + "/i" + i + "j" + j + "p" + p1 + "/", new String[0]), new LinkOption[0])) {
                        resultForGDDA4[p1] = gc98.calcDGDDA(gc98.getPath(i, j, p1, "BASE"), gc98.getPath(i, j, p1, "S4VARIANT"));
                        resultForGDDA5[p1] = gc600.calcDGDDA(gc600.getPath(i, j, p1, "BASE"), gc600.getPath(i, j, p1, "S4VARIANT"));
                        continue;
                    }
                    resultForGDDA4[p1] = -1.0;
                }
                String toSave4 = this.createBlockToSave(resultForGDDA4, i, j);
                BufferedWriter fileWriter = null;
                try {
                    fileWriter = new BufferedWriter(new FileWriter("/home/Szavislav/Eksperyment/Wyniki/i" + i + "j" + j + "/BASE-STAR-4.txt"));
                    PrintWriter printWriter2 = new PrintWriter(fileWriter);
                    printWriter2.append(toSave4);
                    printWriter2.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                BufferedWriter totalResultWriter = null;
                try {
                    totalResultWriter = new BufferedWriter(new FileWriter("/home/Szavislav/Eksperyment/Wyniki/BASE-STAR-4.txt", true));
                    PrintWriter printWriter3 = new PrintWriter(totalResultWriter);
                    printWriter3.append(toSave4);
                    printWriter3.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                String toSave5 = this.createBlockToSave(resultForGDDA5, i, j);
                fileWriter = null;
                try {
                    fileWriter = new BufferedWriter(new FileWriter("/home/Szavislav/Eksperyment/Wyniki/i" + i + "j" + j + "/BASE-STAR-5.txt"));
                    printWriter = new PrintWriter(fileWriter);
                    printWriter.append(toSave5);
                    printWriter.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                totalResultWriter = null;
                try {
                    totalResultWriter = new BufferedWriter(new FileWriter("/home/Szavislav/Eksperyment/Wyniki/BASE-STAR-5.txt", true));
                    printWriter = new PrintWriter(totalResultWriter);
                    printWriter.append(toSave5);
                    printWriter.close();
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void compareAllGDDA() {
        GraphletComparator gc17 = new GraphletComparator(17);
        GraphletComparator gc98 = new GraphletComparator(98);
        GraphletComparator gc600 = new GraphletComparator(600);
        for (int i = 55; i < 100; ++i) {
            for (int j = 0; j < 100; ++j) {
                if (!Files.exists(Paths.get("/home/Szavislav/Eksperyment/Wyniki/i" + i + "j" + j + "/", new String[0]), new LinkOption[0])) continue;
                double[] resultForGDDA3 = new double[100];
                double[] resultForGDDA4 = new double[100];
                double[] resultForGDDA5 = new double[100];
                for (int p1 = 1; p1 < 100; ++p1) {
                    if (Files.exists(Paths.get("/home/Szavislav/Eksperyment/Wyniki/i" + i + "j" + j + "/i" + i + "j" + j + "p" + p1 + "/", new String[0]), new LinkOption[0])) {
                        System.out.println("i " + i + " j " + j + " p " + p1);
                        resultForGDDA3[p1] = gc17.calcDGDDA(gc17.getPath(i, j, 0, "BASE"), gc17.getPath(i, j, p1, "BASE"));
                        continue;
                    }
                    resultForGDDA4[p1] = -1.0;
                }
                String toSave3 = this.createBlockToSave(resultForGDDA3, i, j);
                BufferedWriter fileWriter = null;
                try {
                    fileWriter = new BufferedWriter(new FileWriter("/home/Szavislav/Eksperyment/Wyniki/i" + i + "j" + j + "/BASE-BASE-3.txt"));
                    PrintWriter printWriter = new PrintWriter(fileWriter);
                    printWriter.append(toSave3);
                    printWriter.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                BufferedWriter totalResultWriter = null;
                try {
                    totalResultWriter = new BufferedWriter(new FileWriter("/home/Szavislav/Eksperyment/Wyniki/BASE-BASE-3.txt", true));
                    PrintWriter printWriter = new PrintWriter(totalResultWriter);
                    printWriter.append(toSave3);
                    printWriter.close();
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private String createBlockToSave(double[] resultForGDDA, int i, int j) {
        Object result = "";
        result = (String)result + "==" + i + "-" + j + "==\n\r";
        double min = Arrays.stream(resultForGDDA).filter(x -> x > 0.0).min().getAsDouble();
        int minID = IntStream.range(0, resultForGDDA.length).filter(x -> min == resultForGDDA[x]).findFirst().orElse(-1);
        double max = Arrays.stream(resultForGDDA).max().getAsDouble();
        int maxID = IntStream.range(0, resultForGDDA.length).filter(x -> max == resultForGDDA[x]).findFirst().orElse(-1);
        double avarage = Arrays.stream(resultForGDDA).sum() / (double)resultForGDDA.length;
        ArrayList<Double> reduced = new ArrayList<Double>();
        ArrayList<Double> toWrite = new ArrayList<Double>();
        boolean minThrown = false;
        boolean maxThrown = false;
        for (int k = 0; k < resultForGDDA.length; ++k) {
            if (resultForGDDA[k] == min && !minThrown) {
                minThrown = true;
            } else if (resultForGDDA[k] == max && !maxThrown) {
                maxThrown = true;
            } else {
                reduced.add(resultForGDDA[k]);
            }
            toWrite.add(resultForGDDA[k]);
        }
        double redAvarage = reduced.stream().mapToDouble(f -> f).sum() / (double)reduced.size();
        result = (String)result + "min\t" + min + "\t net: " + minID + "\n";
        result = (String)result + "max\t" + max + "\t net: " + maxID + "\n";
        result = (String)result + "avarage\t" + avarage + "\n";
        result = (String)result + "reduced avarage\t" + redAvarage + "\n";
        result = (String)result + "tab\n";
        result = (String)result + toWrite + "\n";
        return result;
    }

    private String createBlockToSaveBASE(double[] resultForGDDA, int i, int j) {
        Object result = "";
        result = (String)result + "==" + i + "-" + j + "==\n\r";
        double min = Arrays.stream(resultForGDDA).filter(x -> x > 0.0).min().getAsDouble();
        int minID = IntStream.range(0, resultForGDDA.length).filter(x -> min == resultForGDDA[x]).findFirst().orElse(-1);
        double max = Arrays.stream(resultForGDDA).max().getAsDouble();
        int maxID = IntStream.range(0, resultForGDDA.length).filter(x -> max == resultForGDDA[x]).findFirst().orElse(-1);
        double avarage = Arrays.stream(resultForGDDA).sum() / (double)resultForGDDA.length;
        ArrayList<Double> reduced = new ArrayList<Double>();
        ArrayList<Double> toWrite = new ArrayList<Double>();
        boolean minThrown = false;
        boolean maxThrown = false;
        for (int k = 0; k < resultForGDDA.length; ++k) {
            if (resultForGDDA[k] == min && !minThrown) {
                minThrown = true;
            } else if (resultForGDDA[k] == max && !maxThrown) {
                maxThrown = true;
            } else {
                reduced.add(resultForGDDA[k]);
            }
            toWrite.add(resultForGDDA[k]);
        }
        double redAvarage = reduced.stream().mapToDouble(f -> f).sum() / (double)reduced.size();
        result = (String)result + "min\t" + min + "\t net: " + minID + "\n";
        result = (String)result + "max\t" + max + "\t net: " + maxID + "\n";
        result = (String)result + "avarage\t" + avarage + "\n";
        result = (String)result + "reduced avarage\t" + redAvarage + "\n";
        result = (String)result + "tab\n";
        result = (String)result + toWrite + "\n";
        return result;
    }

    private void compOldNets() {
        JFileChooser jFileChooser = new JFileChooser();
        String path = jFileChooser.getSelectedFile().getPath();
        JFileChooser jFileChooser2 = new JFileChooser();
        String path2 = jFileChooser2.getSelectedFile().getPath();
        GraphletComparator gc = new GraphletComparator(98);
    }

    private void getAndSaveGdd() {
        JFileChooser jFileChooser = new JFileChooser();
        String path = jFileChooser.getSelectedFile().getPath();
        ArrayList<int[]> DGDV = new ArrayList<int[]>();
        GraphletsCalculator.generateGraphlets();
        for (Node startNode : GUIManager.getDefaultGUIManager().getWorkspace().getProject().getNodes()) {
            int[] vectorOrbit = GraphletsCalculator.vectorOrbit(startNode, false);
            DGDV.add(vectorOrbit);
        }
        NetGenerator.writeDGDDA(path, DGDV);
    }

    private void compareNets() {
        GraphletComparator gc = new GraphletComparator(600);
        gc.compare();
    }

    private void compareNetdivs() {
        GraphletComparator gc = new GraphletComparator(98);
    }

    private void paintGraphlet(GraphletsCalculator.Struct graphletStructure) {
        ColorPalette cp = new ColorPalette();
        this.overlord.getWorkspace().getProject().resetNetColors();
        for (Node node : graphletStructure.getNodeMap().values()) {
            if (node.getType().equals((Object)PetriNetElement.PetriNetElementType.PLACE)) {
                ((Place)node).drawGraphBoxP.setColorWithNumber(true, Color.red, false, 0.0, false, "");
                continue;
            }
            ((Transition)node).drawGraphBoxT.setColorWithNumber(true, Color.blue, false, 0.0, true, "");
        }
        this.overlord.getWorkspace().getProject().repaintAllGraphPanels();
        for (Arc arc : graphletStructure.getArcMap().values()) {
            arc.arcDecoBox.setColor(true, Color.green);
        }
    }

    private void generateGraphletOrbits() {
        int i;
        GraphletsCalculator.generateGraphlets();
        GraphletsCalculator.getFoundGraphlets();
        for (int j = 0; j < GraphletsCalculator.graphlets.get(0).size(); ++j) {
            for (i = 0; i < GraphletsCalculator.graphlets.size(); ++i) {
            }
        }
        ArrayList<CallSite> data = new ArrayList<CallSite>();
        for (i = 0; i < GraphletsCalculator.graphlets.size(); ++i) {
            data.add((CallSite)((Object)("Orbita : " + i)));
        }
        this.orbitData = (String[])data.stream().toArray(String[]::new);
        this.orbit.setModel(new DefaultComboBoxModel<String>(this.orbitData));
        ArrayList<CallSite> dataG = new ArrayList<CallSite>();
        for (int i2 = 0; i2 < GraphletsCalculator.uniqGraphlets.size(); ++i2) {
            dataG.add((CallSite)((Object)("Graphlet " + GraphletsCalculator.uniqGraphlets.get(i2).getGraphletID() + " : " + i2)));
        }
        this.graphDataUniq = (String[])dataG.stream().toArray(String[]::new);
        this.graphletListUniq.setModel(new DefaultComboBoxModel<String>(this.graphDataUniq));
    }

    public void serverThirdComparisonExperiment() {
        this.compareGDDAforBASE("BASE", "BASE");
    }

    public void compareGDDAforDistortions() {
        GraphletsCalculator.GraphletsCalculator();
        GraphletComparator gc600 = new GraphletComparator(600);
        Double[][] resultA = new Double[10][2];
        Double[][] resultB = new Double[10][2];
        for (int i = 0; i < 10; ++i) {
            resultA[i][0] = gc600.calcDGDDA("/home/Szavislav/Eksperyment/Distortion/net-BASE-DGDDA.txt", "/home/Szavislav/Eksperyment/Distortion/net-" + i + "A-DGDDA.txt");
            resultA[i][1] = gc600.calcDGDDA("/home/Szavislav/Eksperyment/Distortion/net-BASE+sub-DGDDA.txt", "/home/Szavislav/Eksperyment/Distortion/net-" + i + "A-DGDDA.txt");
            resultB[i][0] = gc600.calcDGDDA("/home/Szavislav/Eksperyment/Distortion/net-BASE-DGDDA.txt", "/home/Szavislav/Eksperyment/Distortion/net-" + i + "B-DGDDA.txt");
            resultB[i][1] = gc600.calcDGDDA("/home/Szavislav/Eksperyment/Distortion/net-BASE+sub-DGDDA.txt", "/home/Szavislav/Eksperyment/Distortion/net-" + i + "B-DGDDA.txt");
        }
        this.saveToCsv(resultA, "A");
        this.saveToCsv(resultB, "B");
    }

    public void compareGDDAforSingleF() {
        GraphletsCalculator.GraphletsCalculator();
        GraphletComparator gc600 = new GraphletComparator(600);
        Double[][] resultMin = new Double[10][10];
        Double[][] resultMax = new Double[10][10];
        Double[][] resultAvg = new Double[10][10];
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                System.out.println("i " + i + " j " + j + " ");
                Double[] vecor = new Double[100];
                double min = 9.99999999E8;
                double max = 0.0;
                double avg = 0.0;
                for (int p = 0; p < 100; ++p) {
                    int iI = i * 5;
                    int jI = j * 5;
                    vecor[p] = gc600.calcDGDDA("/home/bszawulak/Dokumenty/Eksperyment/Wyniki/i" + iI + "j" + jI + "/i" + iI + "j" + jI + "p" + p + "/i" + iI + "j" + jI + "p" + p + "-BASE-DGDDA.txt", "/home/bszawulak/Dokumenty/Eksperyment/Wyniki/i" + iI + "j" + jI + "/i" + iI + "j" + jI + "p" + p + "/i" + iI + "j" + jI + "p" + p + "-P3OVARIANT-DGDDA.txt");
                    if (vecor[p] > max) {
                        max = vecor[p];
                    }
                    if (vecor[p] < min) {
                        min = vecor[p];
                    }
                    avg += vecor[p].doubleValue();
                }
                resultMin[i][j] = min;
                resultMax[i][j] = max;
                resultAvg[i][j] = avg / 100.0;
            }
        }
        this.saveToCsv(resultMin, "resultMin");
        this.saveToCsv(resultMax, "resultMax");
        this.saveToCsv(resultAvg, "resultAvg");
    }

    private void saveToCsv(Double[][] resultA, String name) {
        try {
            FileWriter writer = new FileWriter("/home/bszawulak/Dokumenty/Eksperyment/" + name + ".csv");
            for (int i = 0; i < resultA.length; ++i) {
                for (int j = 0; j < resultA[i].length; ++j) {
                    writer.append(String.valueOf(resultA[i][j]));
                    if (i == resultA[i].length - 1) continue;
                    writer.append(",");
                }
                writer.append("\n");
            }
            writer.append("\n");
            writer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void compareGDDAforBASE(String first, String second) {
        System.out.println(first + " - " + second);
        GraphletComparator gc600 = new GraphletComparator(600);
        for (int d = 112; d < 302; ++d) {
            for (int i = 0; i < 45; ++i) {
                for (int j = 0; j < 45; ++j) {
                    if (!Files.exists(Paths.get("/home/bartek/Eksperyment/Wyniki/d" + d + "i" + i + "j" + j + "/", new String[0]), new LinkOption[0])) continue;
                    double[] resultForGDDA4 = new double[100];
                    double[][] resultForGDDA5 = new double[100][100];
                    for (int p1 = 0; p1 < 100; ++p1) {
                        for (int p2 = 0; p2 < 100; ++p2) {
                            if (p1 != p2) {
                                if (Files.exists(Paths.get("/home/bartek/Eksperyment/Wyniki/d" + d + "i" + i + "j" + j + "/d" + d + "i" + i + "j" + j + "p" + p1 + "/", new String[0]), new LinkOption[0])) {
                                    resultForGDDA5[p1][p2] = gc600.calcDGDDA(gc600.getPath(d, i, j, p1, first), gc600.getPath(d, i, j, p2, second));
                                    continue;
                                }
                                resultForGDDA5[p1][p2] = -1.0;
                                continue;
                            }
                            resultForGDDA5[p1][p2] = -1.0;
                        }
                    }
                    BufferedWriter fileWriter = null;
                    BufferedWriter totalResultWriter = null;
                    BufferedWriter partialResultWriter = null;
                    System.out.println("Zapis " + d + ":" + i + ":" + j);
                    for (int p1 = 0; p1 < 100; ++p1) {
                        PrintWriter printWriter;
                        String toSave5 = this.createBlockToSaveBASE(resultForGDDA5[p1], i, j);
                        fileWriter = null;
                        try {
                            fileWriter = new BufferedWriter(new FileWriter("/home/bartek/Eksperyment/Wyniki/d" + d + "i" + i + "j" + j + "/" + first + "-" + second + "p-" + p1));
                            printWriter = new PrintWriter(fileWriter);
                            printWriter.append(toSave5);
                            printWriter.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        partialResultWriter = null;
                        try {
                            partialResultWriter = new BufferedWriter(new FileWriter("/home/bartek/Eksperyment/Wyniki/d" + d + "i" + i + "j" + j + "/" + first + "-" + second, true));
                            printWriter = new PrintWriter(partialResultWriter);
                            printWriter.append(toSave5);
                            printWriter.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        totalResultWriter = null;
                        try {
                            totalResultWriter = new BufferedWriter(new FileWriter("/home/bartek/Eksperyment/Wyniki/" + first + "-" + second + ".txt", true));
                            printWriter = new PrintWriter(totalResultWriter);
                            printWriter.append(toSave5);
                            printWriter.close();
                            continue;
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
    }
}

