/*
 * Decompiled with CFR 0.152.
 */
package holmes.windows.decompositions;

import holmes.analyse.DecoCalccalculator;
import holmes.analyse.GDDAcalculator;
import holmes.analyse.GRDFcalculator;
import holmes.analyse.GraphletsCalculator;
import holmes.analyse.InvariantsCalculator;
import holmes.analyse.SubnetCalculator;
import holmes.analyse.comparison.GraphletComparator;
import holmes.analyse.comparison.Hungarian;
import holmes.analyse.comparison.InvariantComparator;
import holmes.analyse.comparison.SubnetComparator;
import holmes.analyse.comparison.structures.BranchVertex;
import holmes.analyse.comparison.structures.GreatCommonSubnet;
import holmes.darkgui.GUIManager;
import holmes.files.io.IOprotocols;
import holmes.files.io.snoopy.SnoopyReader;
import holmes.petrinet.data.PetriNet;
import holmes.petrinet.elements.Arc;
import holmes.petrinet.elements.Node;
import holmes.petrinet.elements.PetriNetElement;
import holmes.petrinet.elements.Place;
import holmes.petrinet.elements.Transition;
import holmes.server.BranchesServerCalc;
import holmes.workspace.ExtensionFileFilter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Paint;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.prefs.Preferences;
import java.util.stream.DoubleStream;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.text.BadLocationException;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.SymbolAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.DefaultDrawingSupplier;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYBarPainter;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class HolmesComparisonModule
extends JFrame {
    private static final String LAST_USED_FOLDER = "";
    private boolean decoCompareFtS = true;
    private boolean decoCompareStF = false;
    private boolean decoCompareFtF = false;
    private boolean decoCompareStS = false;
    public PetriNet secondNet = null;
    public ArrayList<SubnetCalculator.SubNet> seconNetList;
    public JTextArea infoPaneInv = new JTextArea(30, 30);
    public JTextArea infoPaneDec = new JTextArea(30, 30);
    public JTextArea infoPaneDRGF = new JTextArea(30, 30);
    public JTextArea infoPaneGDDA = new JTextArea(30, 30);
    JTextArea infoPaneNetdiv = new JTextArea(30, 30);
    JTextArea infoPaneBranch = new JTextArea(30, 60);
    JButton generateInvl;
    JButton generateDec;
    public JButton generateDrgf;
    JButton generateGDDA;
    JButton saveDGDV1;
    JButton saveDGDV2;
    JButton saveDGDD;
    JButton generateNetdiv;
    JButton generateBranch;
    JButton chooserPnt;
    public JTable dgddTable;
    public JComboBox graphletSize;
    JComboBox orbitSize;
    JComboBox egoSize;
    JComboBox graphletNDSize;
    JComboBox branchingVariant;
    public JComboBox decoType;
    public JPanel decoResult;
    boolean invariantMatchingTypr = false;
    boolean transitionMatchingTypr = false;
    Boolean firstQuestionDec = false;
    Boolean secondQuestionDec = false;
    Boolean thirdQuestionDec = false;
    public ArrayList<JTable> listOfTablesDec = new ArrayList();
    private boolean indexQuestionB = false;
    public SubnetComparator sc;
    JRadioButton hungarianButton;
    int coloringMode = 0;
    ArrayList<ArrayList<ArrayList<GreatCommonSubnet>>> listOfTableContent = new ArrayList();
    String resultFlag = "Hungarian";
    InvariantComparator invComp;
    JTable matchingTable;
    JTable branchTable;
    JPanel invPanel;
    JPanel verticesPanel;
    public Object[][] dataDRGF;
    public Object[][] dataDGDD;
    Object[][] dataBranch;
    public JTable drgfTable;
    JButton matchVertices;
    int[][] DGDVFirst;
    int[][] DGDVSecond;
    public XYSeriesCollection grdfSeriesDataSet = null;
    public JFreeChart grdfChart;
    public JPanel grdfChartPanel = new JPanel();
    private final JPanel branchChartPanel = new JPanel();
    private JPanel branchTabs;
    JPanel listBranchView;
    JList<String> leftBranchList = new JList();
    JList<String> centerBranchList = new JList();
    JList<String> rightBranchList = new JList();
    ArrayList<branchingPairs> currentBranchingRelations = new ArrayList();
    JComponent invCompPanel;
    JComponent GRDFPanel;
    JComponent GDDAPanel;
    JComponent DecoPanel;
    JComponent BrPanel;
    GRDFcalculator grdfCalculator;
    GDDAcalculator gddaCalculator;
    DecoCalccalculator decoCalculator;
    InvariantComparator invariantComparator;
    JTabbedPane tabbedDecoPane;
    boolean reGenerateBoolean = false;
    public JButton chooserGRDF;
    private String lastChoosenPath = "";

    public HolmesComparisonModule() {
        this.setTitle("Comparison module");
        this.setSize(1250, 800);
        JTabbedPane tabbedPane = new JTabbedPane();
        this.invCompPanel = this.makeInCompPanel();
        tabbedPane.addTab("Invariant based comparison", null, this.invCompPanel, LAST_USED_FOLDER);
        this.GRDFPanel = this.makeGraphletPanel();
        tabbedPane.addTab("Graphlets (GRDF) comparison", null, this.GRDFPanel, LAST_USED_FOLDER);
        this.GDDAPanel = this.makeGDDAPanel();
        tabbedPane.addTab("Graphlets (GDDA) comparison", null, this.GDDAPanel, LAST_USED_FOLDER);
        JPanel panel4 = this.makeNetdivPanel();
        this.DecoPanel = this.makeDecoPanel();
        tabbedPane.addTab("Decomposition based comparison", null, this.DecoPanel, LAST_USED_FOLDER);
        this.BrPanel = this.makeBranchPanel();
        tabbedPane.addTab("Branching based comparison", null, this.BrPanel, LAST_USED_FOLDER);
        this.add(tabbedPane);
    }

    private JPanel makeInCompPanel() {
        this.invPanel = new JPanel();
        JPanel optionPanel = this.createInOptionPanel();
        this.invPanel.add((Component)optionPanel, "North");
        this.verticesPanel = this.createVerticesPanel();
        this.invPanel.add((Component)this.verticesPanel, "West");
        JPanel textPanel = this.createInvTextArea();
        this.invPanel.add((Component)textPanel, "Center");
        return this.invPanel;
    }

    private JPanel createInvTextArea() {
        JPanel textPanel = new JPanel();
        JScrollPane jsp = new JScrollPane(this.infoPaneInv);
        TitledBorder titleF = BorderFactory.createTitledBorder("Info Panel");
        jsp.setBorder(titleF);
        textPanel.add(jsp);
        return textPanel;
    }

    private JPanel createVerticesPanel() {
        JPanel panel = new JPanel();
        this.matchingTable = new JTable();
        JScrollPane jpane = new JScrollPane(this.matchingTable);
        JPanel scroll = new JPanel();
        panel.add(jpane);
        scroll.add(new JScrollPane(panel));
        scroll.setEnabled(false);
        return scroll;
    }

    private JPanel createInOptionPanel() {
        JPanel panel = new JPanel();
        JPanel buttonPanel = new JPanel(new GridLayout(3, 1));
        JPanel mopanel = new JPanel(new GridLayout(1, 2));
        JButton chooser = new JButton("Choose second net");
        chooser.setVisible(true);
        chooser.addActionListener(e -> {
            Preferences prefs = Preferences.userRoot().node(this.getClass().getName());
            JFileChooser jfc = new JFileChooser(prefs.get(LAST_USED_FOLDER, new File(".").getAbsolutePath()));
            FileFilter[] filters = new FileFilter[]{new ExtensionFileFilter("Snoopy Petri Net file (.spped),(.pn)", new String[]{"SPPED", "PN"}), new ExtensionFileFilter(".pnt - INA PNT file (.pnt)", new String[]{"PNT"})};
            jfc.addChoosableFileFilter(filters[0]);
            jfc.addChoosableFileFilter(filters[1]);
            int returnVal = jfc.showOpenDialog(this);
            this.infoPaneInv.append("Choosen file: " + jfc.getSelectedFile().getName() + "\n");
            this.chooseSecondNet(jfc.getSelectedFile().getAbsolutePath());
            if (returnVal == 0) {
                this.invComp = new InvariantComparator(GUIManager.getDefaultGUIManager().getWorkspace().getProject(), this.secondNet);
                this.matchVertices.setEnabled(true);
                this.chooserPnt.setEnabled(true);
                prefs.put(LAST_USED_FOLDER, jfc.getSelectedFile().getParent());
            }
        });
        mopanel.add(chooser);
        this.chooserPnt = new JButton("Load invariants for second net(.inv)");
        this.chooserPnt.setVisible(true);
        this.chooserPnt.setEnabled(false);
        this.chooserPnt.addActionListener(e -> {
            JFileChooser jfc = new JFileChooser();
            jfc.setFileFilter(new ExtensionFileFilter("INA INV format (.inv)", new String[]{"INV"}));
            int returnVal = jfc.showOpenDialog(this);
            if (returnVal == 0) {
                this.infoPaneInv.append("Choosen pnt file: " + jfc.getSelectedFile().getName() + "\n");
                IOprotocols io = new IOprotocols();
                if (this.invComp.invariantType) {
                    this.secondNet.setT_InvMatrix(io.readT_invariantsOut(jfc.getSelectedFile().getAbsolutePath()), false);
                } else {
                    this.secondNet.setP_InvMatrix(io.readP_invariantsOut(jfc.getSelectedFile().getAbsolutePath()));
                }
                this.generateInvl.setEnabled(true);
            }
        });
        mopanel.add(this.chooserPnt);
        buttonPanel.add(mopanel);
        JPanel tmpanel = new JPanel(new GridLayout(1, 3));
        this.matchVertices = new JButton("Match transitions");
        this.matchVertices.setEnabled(false);
        this.matchVertices.addActionListener(e -> {
            HashMap<Node, Node> matching;
            if (this.transitionMatchingTypr) {
                this.infoPaneInv.append("Choosen: SED transition label matching\n\r");
                matching = this.invComp.matchVertices(1);
            } else {
                this.infoPaneInv.append("Choosen: Precise transition label matching\n\r");
                matching = this.invComp.matchVertices(0);
            }
            this.infoPaneInv.append("First net transitions number: " + this.invComp.pn1.getTransitions().size() + "\nSecond net transition number: " + this.invComp.pn2.getTransitions().size() + "\nMatched transition number: " + matching.size());
            this.calcMatchingTable(matching);
        });
        tmpanel.add(this.matchVertices);
        JButton loadMatchVertices = new JButton("Load match");
        loadMatchVertices.setEnabled(true);
        loadMatchVertices.addActionListener(e -> {
            JFileChooser jfc = new JFileChooser();
            int returnVal = jfc.showOpenDialog(this);
            if (returnVal == 0) {
                this.infoPaneInv.append("Choosen match file: " + jfc.getSelectedFile().getName() + "\n");
                IOprotocols io = new IOprotocols();
                HashMap<Node, Node> matching = this.loadMatchVerticesFromFile(jfc.getSelectedFile().getAbsolutePath());
                this.calcMatchingTable(matching);
            }
        });
        tmpanel.add(loadMatchVertices);
        JButton saveMatchedVertices = new JButton("Save match");
        saveMatchedVertices.addActionListener(e -> {
            JFileChooser jfc = new JFileChooser();
            int returnVal = jfc.showSaveDialog(this);
            if (returnVal == 0) {
                IOprotocols io = new IOprotocols();
                boolean result = this.saveMatchVerticesFromFile(jfc.getSelectedFile().getAbsolutePath());
                if (result) {
                    this.infoPaneInv.append("Match saved to file: " + jfc.getSelectedFile().getName() + "\n");
                } else {
                    this.infoPaneInv.append("Save operation failed");
                }
            }
        });
        tmpanel.add(saveMatchedVertices);
        buttonPanel.add(tmpanel);
        JPanel impanel = new JPanel(new GridLayout(1, 2));
        this.generateInvl = new JButton("Compare nets");
        this.generateInvl.addActionListener(e -> this.compareInv());
        this.generateInvl.setEnabled(false);
        impanel.add(this.generateInvl);
        buttonPanel.add(impanel);
        panel.add(buttonPanel);
        JPanel questions = new JPanel(new GridLayout(1, 3));
        JPanel zeroQuestion = new JPanel(new GridLayout(0, 1));
        TitledBorder titleQ0 = BorderFactory.createTitledBorder("Invariants");
        JRadioButton tiButton = new JRadioButton("T-inv");
        tiButton.setActionCommand(LAST_USED_FOLDER);
        tiButton.setSelected(true);
        tiButton.addActionListener(e -> {
            if (tiButton.isSelected()) {
                this.invComp.invariantType = true;
            }
        });
        zeroQuestion.add(tiButton);
        JRadioButton piButton = new JRadioButton("P-inv");
        piButton.setActionCommand(LAST_USED_FOLDER);
        piButton.addActionListener(e -> {
            if (piButton.isSelected()) {
                this.invComp.invariantType = false;
            }
        });
        zeroQuestion.add(piButton);
        zeroQuestion.setBorder(titleQ0);
        questions.add(zeroQuestion);
        ButtonGroup groupQ0 = new ButtonGroup();
        groupQ0.add(tiButton);
        groupQ0.add(piButton);
        JPanel firstQuestion = new JPanel(new GridLayout(0, 1));
        TitledBorder titleQ1 = BorderFactory.createTitledBorder("Matching");
        JRadioButton preButton = new JRadioButton("Precise matching");
        preButton.setActionCommand(LAST_USED_FOLDER);
        preButton.setSelected(true);
        preButton.addActionListener(e -> {
            if (preButton.isSelected()) {
                this.invariantMatchingTypr = true;
            }
        });
        firstQuestion.add(preButton);
        JRadioButton maxButton = new JRadioButton("Best matching");
        maxButton.setActionCommand(LAST_USED_FOLDER);
        maxButton.addActionListener(e -> {
            if (maxButton.isSelected()) {
                this.invariantMatchingTypr = false;
            }
        });
        firstQuestion.add(maxButton);
        firstQuestion.setBorder(titleQ1);
        questions.add(firstQuestion);
        ButtonGroup groupQ1 = new ButtonGroup();
        groupQ1.add(preButton);
        groupQ1.add(maxButton);
        JPanel secondQuestion = new JPanel(new GridLayout(0, 1));
        TitledBorder titleQ2 = BorderFactory.createTitledBorder("Node");
        secondQuestion.setBorder(titleQ2);
        JRadioButton preTButton = new JRadioButton("Precise matching");
        preTButton.setActionCommand(LAST_USED_FOLDER);
        preTButton.setSelected(true);
        preTButton.addActionListener(e -> {
            if (preButton.isSelected()) {
                this.transitionMatchingTypr = false;
            }
        });
        secondQuestion.add(preTButton);
        JRadioButton maxTButton = new JRadioButton("Best matching");
        maxTButton.setActionCommand(LAST_USED_FOLDER);
        maxTButton.addActionListener(e -> {
            if (maxButton.isSelected()) {
                this.transitionMatchingTypr = true;
            }
        });
        secondQuestion.add(maxTButton);
        questions.add(secondQuestion);
        panel.add(questions);
        ButtonGroup groupQ2 = new ButtonGroup();
        groupQ2.add(preTButton);
        groupQ2.add(maxTButton);
        return panel;
    }

    private HashMap<Node, Node> loadMatchVerticesFromFile(String absolutePath) {
        HashMap<Node, Node> result = new HashMap<Node, Node>();
        try {
            DataInputStream in = new DataInputStream(new FileInputStream(absolutePath));
            BufferedReader buffer = new BufferedReader(new InputStreamReader(in));
            String readLine = buffer.readLine();
            while (readLine != null && readLine.length() > 0) {
                String[] line = readLine.split(",");
                if (!line[1].equals("-1")) {
                    Node n1 = GUIManager.getDefaultGUIManager().getWorkspace().getProject().getTransitions().get(Integer.parseInt(line[0]));
                    Node n2 = this.secondNet.getTransitions().get(Integer.parseInt(line[1]));
                    result.put(n1, n2);
                }
                readLine = buffer.readLine();
            }
            buffer.close();
        }
        catch (Exception e) {
            System.out.println("Problem with loading matching : " + e.getMessage());
        }
        return result;
    }

    private boolean saveMatchVerticesFromFile(String absolutePath) {
        try {
            HashMap<Node, Node> toSave = new HashMap<Node, Node>();
            int i = 0;
            while (i < this.matchingTable.getRowCount()) {
                int finalI = i++;
                String cell = (String)this.matchingTable.getModel().getValueAt(finalI, 1);
                Node firstNetNode = GUIManager.getDefaultGUIManager().getWorkspace().getProject().getTransitions().stream().filter(x -> x.getName().equals(this.matchingTable.getModel().getValueAt(finalI, 0))).findFirst().orElse(new Transition("Error"));
                Node secondNetNode = this.secondNet.getTransitions().stream().filter(x -> x.getName().equals(cell)).findFirst().orElse(new Transition("Error"));
                toSave.put(firstNetNode, secondNetNode);
            }
            File csvOutputFile = new File(absolutePath);
            try (PrintWriter pw = new PrintWriter(csvOutputFile);){
                for (Map.Entry entry : toSave.entrySet()) {
                    Node key = (Node)entry.getKey();
                    Node value = (Node)entry.getValue();
                    pw.write(GUIManager.getDefaultGUIManager().getWorkspace().getProject().getTransitions().indexOf(key) + "," + this.secondNet.getTransitions().indexOf(value) + "\n");
                }
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void calcMatchingTable(HashMap<Node, Node> matching) {
        int i;
        Object[] colNames = new String[]{"First Net", "Second Net"};
        Object[][] rowData = new String[GUIManager.getDefaultGUIManager().getWorkspace().getProject().getTransitions().size()][colNames.length];
        if (this.invComp.invariantType) {
            for (i = 0; i < rowData.length; ++i) {
                rowData[i][0] = GUIManager.getDefaultGUIManager().getWorkspace().getProject().getTransitions().get(i).getName();
                if (matching.get(GUIManager.getDefaultGUIManager().getWorkspace().getProject().getTransitions().get(i)) != null) {
                    Node nodeFormSecond = matching.get(GUIManager.getDefaultGUIManager().getWorkspace().getProject().getTransitions().get(i));
                    rowData[i][1] = nodeFormSecond.getName();
                    continue;
                }
                rowData[i][1] = "--";
            }
        } else {
            rowData = new String[GUIManager.getDefaultGUIManager().getWorkspace().getProject().getPlaces().size()][colNames.length];
            for (i = 0; i < rowData.length; ++i) {
                rowData[i][0] = GUIManager.getDefaultGUIManager().getWorkspace().getProject().getPlaces().get(i).getName();
                if (matching.get(GUIManager.getDefaultGUIManager().getWorkspace().getProject().getPlaces().get(i)) != null) {
                    Node nodeFormSecond = matching.get(GUIManager.getDefaultGUIManager().getWorkspace().getProject().getPlaces().get(i));
                    rowData[i][1] = nodeFormSecond.getName();
                    continue;
                }
                rowData[i][1] = "--";
            }
        }
        DefaultTableModel model = new DefaultTableModel(rowData, colNames);
        this.matchingTable.setModel(model);
        this.invPanel.add((Component)this.verticesPanel, "West");
        this.invPanel.updateUI();
        this.verticesPanel.updateUI();
        this.revalidate();
    }

    private void compareInv() {
        if (this.invComp.pn1.getT_InvMatrix() != null && !this.invComp.pn1.getT_InvMatrix().isEmpty() && this.invComp.pn2.getT_InvMatrix() != null && !this.invComp.pn2.getT_InvMatrix().isEmpty()) {
            this.infoPaneInv.append("Comparison result: \n\r");
            double matchingScore = 0.0;
            if (this.invariantMatchingTypr) {
                this.infoPaneInv.append("Choosen: Ideal invariant matching\n\r");
                this.infoPaneInv.append("Matched invariants\n\r");
                this.infoPaneInv.append("First net ID - Second net ID\n\r");
                this.invComp.mode = true;
                Thread myThread = new Thread(this.invComp);
                myThread.start();
            } else {
                HashMap<Integer, Integer> maping = this.invComp.bestTInvariantMatching();
                this.infoPaneInv.append("Choosen: Best invariant matching\n\r");
                this.infoPaneInv.append("Matched invariants\n\r");
                this.infoPaneInv.append("First net ID - Second net ID\n\r");
                for (Map.Entry<Integer, Integer> ma : maping.entrySet()) {
                    this.infoPaneInv.append(ma.getKey() + " - " + ma.getValue() + "\n\r");
                }
                this.invComp.mode = false;
                Thread myThread = new Thread(this.invComp);
                myThread.start();
                this.calcBestScore(maping);
            }
        } else {
            if (this.invComp.pn1.getT_InvMatrix() == null || this.invComp.pn1.getT_InvMatrix().isEmpty()) {
                JOptionPane.showMessageDialog(this, "Please generate Invariants for first net");
                this.infoPaneInv.append("First net lack generated t-invariants\n");
                GUIManager.getDefaultGUIManager().showInvariantsWindow();
            }
            if (this.invComp.pn2.getT_InvMatrix() == null || this.invComp.pn2.getT_InvMatrix().isEmpty()) {
                JOptionPane.showMessageDialog(this, "Please load Invariants for second net");
                this.infoPaneInv.append("Second net lack loaded t-invariants\n");
            }
        }
    }

    public void calcIdealScore(HashMap<Integer, Integer> maping) {
        double score = 0.0;
        score = (double)(2 * maping.values().size()) / (double)(GUIManager.getDefaultGUIManager().getWorkspace().getProject().getT_InvMatrix().size() + this.secondNet.getT_InvMatrix().size());
        this.infoPaneInv.append("Ideal count score: " + score + "\n\r");
        score = 0.0;
        for (Map.Entry<Integer, Integer> entry : maping.entrySet()) {
            Integer key = entry.getKey();
            Integer value = entry.getValue();
            ArrayList<Integer> firstInvariant = GUIManager.getDefaultGUIManager().getWorkspace().getProject().getT_InvMatrix().get(key);
            ArrayList<Integer> secondInvariant = this.secondNet.getT_InvMatrix().get(value);
            int commonPart = 0;
            int size1 = 0;
            for (int i = 0; i < firstInvariant.size(); ++i) {
                Node matched = this.invComp.matchedVertices.get(GUIManager.getDefaultGUIManager().getWorkspace().getProject().getTransitions().get(i));
                int index = this.secondNet.getTransitions().indexOf(matched);
                if (firstInvariant.get(i) == 0) continue;
                ++size1;
                if (!Objects.equals(firstInvariant.get(index), secondInvariant.get(i))) continue;
                ++commonPart;
            }
            int size2 = 0;
            for (Integer integer : secondInvariant) {
                if (integer == 0) continue;
                ++size2;
            }
            score += (double)(2 * commonPart) / (double)(size1 + size2);
        }
        this.infoPaneInv.append("Ideal common score: " + score + "\n\r");
    }

    private void calcBestScore(HashMap<Integer, Integer> maping) {
        double score = (double)(2 * maping.values().size()) / (double)(GUIManager.getDefaultGUIManager().getWorkspace().getProject().getT_InvMatrix().size() + this.secondNet.getT_InvMatrix().size());
        this.infoPaneInv.append("Best count score: " + score + "\n\r");
        score = 0.0;
        for (Map.Entry<Integer, Integer> entry : maping.entrySet()) {
            Integer key = entry.getKey();
            Integer value = entry.getValue();
            ArrayList<Integer> firstInvariant = GUIManager.getDefaultGUIManager().getWorkspace().getProject().getT_InvMatrix().get(key);
            ArrayList<Integer> secondInvariant = this.secondNet.getT_InvMatrix().get(value);
            int commonPart = 0;
            int size1 = 0;
            for (int i = 0; i < firstInvariant.size(); ++i) {
                Node matched = this.invComp.matchedVertices.get(GUIManager.getDefaultGUIManager().getWorkspace().getProject().getTransitions().get(i));
                int index = this.secondNet.getTransitions().indexOf(matched);
                if (firstInvariant.get(i) == 0) continue;
                ++size1;
                if (i >= secondInvariant.size()) continue;
                System.out.println("FT : " + GUIManager.getDefaultGUIManager().getWorkspace().getProject().getTransitions().get(i).getName() + " - ST :" + this.secondNet.getTransitions().get(index).getName());
                if (index == -1 || index >= firstInvariant.size() || !Objects.equals(firstInvariant.get(i), secondInvariant.get(index))) continue;
                ++commonPart;
            }
            int size2 = 0;
            for (Integer integer : secondInvariant) {
                if (integer == 0) continue;
                ++size2;
            }
            score += (double)(2 * commonPart) / (double)(size1 + size2);
            System.out.println("----");
        }
        this.infoPaneInv.append("Best common score: " + score + "\n\r");
    }

    private void chooseSecondNet(String absolutePath) {
        if (absolutePath.endsWith(".pnt")) {
            IOprotocols io = new IOprotocols();
            this.secondNet = io.serverReadPNT(absolutePath, 99);
        }
        if (absolutePath.endsWith(".spped") || absolutePath.endsWith(".pn")) {
            SnoopyReader reader = new SnoopyReader(0, absolutePath);
            this.secondNet = new PetriNet(reader.getNodesList(), reader.getArcList());
        }
    }

    public JPanel makeGraphletPanel() {
        JPanel panel = new JPanel();
        JPanel optionPanel = this.createGRDFOptionPanel();
        panel.add((Component)optionPanel, "North");
        JPanel south = new JPanel();
        JPanel verticesPanel = this.createGRDFResultPanel();
        south.add((Component)verticesPanel, "West");
        JPanel textPanel = this.createGRDFTextArea();
        south.add((Component)textPanel, "East");
        panel.add(south);
        this.grdfChartPanel = this.createChartPanel();
        this.grdfChartPanel.setVisible(false);
        panel.add((Component)this.grdfChartPanel, "South");
        return panel;
    }

    JPanel createChartPanel() {
        String chartTitle = "Graflet Relative Distribution Frequency (GRDF)";
        String xAxisLabel = "Grphlets";
        String yAxisLabel = "Count";
        boolean showLegend = true;
        boolean createTooltip = true;
        boolean createURL = false;
        this.grdfSeriesDataSet = new XYSeriesCollection();
        this.grdfChart = ChartFactory.createXYLineChart(chartTitle, xAxisLabel, yAxisLabel, this.grdfSeriesDataSet, PlotOrientation.VERTICAL, showLegend, createTooltip, createURL);
        this.grdfChart.getTitle().setFont(new Font("Dialog", 0, 14));
        ChartPanel placesChartPanel = new ChartPanel(this.grdfChart);
        return placesChartPanel;
    }

    private JPanel createGRDFResultPanel() {
        JPanel panel = new JPanel();
        Object[] column = new Object[]{"Graphlets", "First net", "Second net", "Difference"};
        this.dataDRGF = new Object[][]{{"Graphlet O", "-", "-", "-"}};
        this.drgfTable = new JTable(this.dataDRGF, column){

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int col) {
                Component comp = super.prepareRenderer(renderer, row, col);
                Object value = this.getModel().getValueAt(row, col);
                String checkStart = String.valueOf(this.getModel().getValueAt(row, 1));
                if (checkStart.equals("-")) {
                    comp.setBackground(Color.lightGray);
                } else {
                    checkStart = String.valueOf(this.getModel().getValueAt(row, 1));
                    int c1 = Integer.parseInt(checkStart);
                    checkStart = String.valueOf(this.getModel().getValueAt(row, 2));
                    int c2 = Integer.parseInt(checkStart);
                    checkStart = String.valueOf(this.getModel().getValueAt(row, 3));
                    int c3 = Integer.parseInt(checkStart);
                    if (c1 == 0 && c2 == 0) {
                        comp.setBackground(Color.lightGray);
                    } else if (c1 != 0 && c1 == c2) {
                        comp.setBackground(Color.GREEN);
                    } else {
                        comp.setBackground(Color.WHITE);
                    }
                }
                return comp;
            }
        };
        JScrollPane jpane = new JScrollPane(this.drgfTable);
        JPanel scroll = new JPanel();
        panel.add(jpane);
        scroll.add(new JScrollPane(panel));
        scroll.setEnabled(false);
        return scroll;
    }

    private JPanel createGRDFTextArea() {
        JPanel textPanel = new JPanel();
        JScrollPane jsp = new JScrollPane(this.infoPaneDRGF);
        TitledBorder titleF = BorderFactory.createTitledBorder("Info Panel");
        jsp.setBorder(titleF);
        textPanel.add(jsp);
        return textPanel;
    }

    public JPanel createGRDFOptionPanel() {
        JPanel panel = new JPanel();
        JPanel buttonPanel = new JPanel(new GridLayout(2, 2));
        this.chooserGRDF = new JButton("Choose second net");
        this.chooserGRDF.setVisible(true);
        this.chooserGRDF.addActionListener(e -> {
            Preferences prefs = Preferences.userRoot().node(this.getClass().getName());
            JFileChooser jfc = new JFileChooser(prefs.get(LAST_USED_FOLDER, new File(".").getAbsolutePath()));
            FileFilter[] filters = new FileFilter[]{new ExtensionFileFilter("Snoopy Petri Net file (.spped), (.pn)", new String[]{"SPPED", "PN"}), new ExtensionFileFilter(".pnt - INA PNT file (.pnt)", new String[]{"PNT"})};
            jfc.addChoosableFileFilter(filters[0]);
            jfc.addChoosableFileFilter(filters[1]);
            int returnVal = jfc.showOpenDialog(this);
            this.infoPaneDRGF.append("Choosen file: " + jfc.getSelectedFile().getName() + "\n");
            this.chooseSecondNet(jfc.getSelectedFile().getAbsolutePath());
            if (returnVal == 0) {
                this.generateDrgf.setEnabled(true);
                prefs.put(LAST_USED_FOLDER, jfc.getSelectedFile().getParent());
            }
        });
        buttonPanel.add(this.chooserGRDF);
        this.graphletSize = new JComboBox();
        this.graphletSize.setModel(new DefaultComboBoxModel<String>(new String[]{"Graphlets size", "2-node size (2)", "3-node size (8)", "4-node size (31)", "5-node size (151)"}));
        buttonPanel.add(this.graphletSize);
        this.generateDrgf = new JButton("Compare nets");
        this.generateDrgf.addActionListener(actionEvent -> {
            this.grdfCalculator = new GRDFcalculator();
            Thread myThread = new Thread(this.grdfCalculator);
            myThread.start();
            this.setSize(1250, 1100);
        });
        this.generateDrgf.setEnabled(false);
        buttonPanel.add(this.generateDrgf);
        JButton analysis = new JButton("Single net graphlet analysis");
        analysis.addActionListener(e -> {
            GUIManager.getDefaultGUIManager().createGraphletsWindow();
            GUIManager.getDefaultGUIManager().showGraphletsWindow();
        });
        buttonPanel.add(analysis);
        JPanel radioButtonsPanel = new JPanel(new GridLayout(2, 1));
        JRadioButton maxButton = new JRadioButton("Single arcs interpetation");
        maxButton.setActionCommand(LAST_USED_FOLDER);
        maxButton.setSelected(true);
        maxButton.addActionListener(e -> {
            if (maxButton.isSelected()) {
                GraphletsCalculator.multipleArcCheck = false;
            }
        });
        radioButtonsPanel.add(maxButton);
        JRadioButton minButton = new JRadioButton("Multiple arc interpertation");
        minButton.setActionCommand(LAST_USED_FOLDER);
        minButton.addActionListener(e -> {
            if (minButton.isSelected()) {
                GraphletsCalculator.multipleArcCheck = true;
            }
        });
        radioButtonsPanel.add(minButton);
        ButtonGroup groupQ1 = new ButtonGroup();
        groupQ1.add(minButton);
        groupQ1.add(maxButton);
        panel.add(buttonPanel);
        panel.add(radioButtonsPanel);
        return panel;
    }

    public void enableGRDFbuttons(boolean type) {
        this.chooserGRDF.setEnabled(type);
        this.generateDrgf.setEnabled(type);
        this.graphletSize.setEnabled(type);
    }

    public void setSizeForFtame() {
        this.setSize(1250, 1100);
    }

    public void compareGraphlets() {
        int chiisenGraohletSize = this.getChoosenGraohletSize(this.graphletSize.getSelectedIndex());
        long[] firstSingleDRGF = this.calcDRGF(GUIManager.getDefaultGUIManager().getWorkspace().getProject());
        long[] secondSingleDRGF = this.calcDRGF(this.secondNet);
        long firstSum = Arrays.stream(firstSingleDRGF).sum();
        long secondSum = Arrays.stream(secondSingleDRGF).sum();
        long[] distanceDRGF = new long[chiisenGraohletSize];
        double result = 0.0;
        for (int i = 0; i < chiisenGraohletSize; ++i) {
            distanceDRGF[i] = Math.abs(firstSingleDRGF[i] - secondSingleDRGF[i]);
            result += Math.abs((double)firstSingleDRGF[i] / (double)firstSum - (double)secondSingleDRGF[i] / (double)secondSum);
        }
        this.infoPaneDRGF.append("DRGF : " + result + "\n");
        XYSeries series1 = new XYSeries((Comparable)((Object)"Number of graphlets of net 1"));
        XYSeries series2 = new XYSeries((Comparable)((Object)"Number of graphlets of net 2"));
        this.dataDRGF = new Object[chiisenGraohletSize][4];
        Object[] colNames = new String[]{"Graphlets", "First net", "Second net", "Distance"};
        for (int i = 0; i < chiisenGraohletSize; ++i) {
            this.dataDRGF[i][0] = "G " + i;
            this.dataDRGF[i][1] = firstSingleDRGF[i];
            this.dataDRGF[i][2] = secondSingleDRGF[i];
            this.dataDRGF[i][3] = distanceDRGF[i];
            series1.add((double)i, firstSingleDRGF[i]);
            series2.add((double)i, secondSingleDRGF[i]);
        }
        DefaultTableModel model = new DefaultTableModel(this.dataDRGF, colNames);
        this.drgfTable.setModel(model);
        this.grdfSeriesDataSet.removeAllSeries();
        this.grdfSeriesDataSet.addSeries(series1);
        this.grdfSeriesDataSet.addSeries(series2);
        this.grdfChartPanel.setVisible(true);
        CategoryPlot chartPlot = this.grdfChart.getCategoryPlot();
        ValueAxis yAxis = chartPlot.getRangeAxis();
        yAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        CategoryAxis xAxis = chartPlot.getDomainAxis();
    }

    public int getChoosenGraohletSize(int index) {
        return switch (this.graphletSize.getSelectedIndex()) {
            case 1 -> 2;
            case 2 -> 8;
            case 3 -> 31;
            case 4 -> 151;
            default -> 151;
        };
    }

    private long[] calcDRGF(PetriNet project) {
        GraphletsCalculator.cleanAll();
        GraphletsCalculator.generateGraphlets();
        GraphletsCalculator.getFoundServerGraphlets(project);
        long[] singleDRGF = new long[GraphletsCalculator.graphetsList.size()];
        for (int k = 0; k < GraphletsCalculator.graphetsList.size(); ++k) {
            long val;
            int finalI = k;
            singleDRGF[k] = val = GraphletsCalculator.uniqGraphlets.stream().filter(x -> x.getGraphletID() == finalI).count();
        }
        return singleDRGF;
    }

    private JPanel makeGDDAPanel() {
        JPanel panel = new JPanel();
        JPanel optionPanel = this.createGDDAOptionPanel();
        panel.add((Component)optionPanel, "North");
        JPanel south = new JPanel();
        JPanel verticesPanel = this.createGDDAResultPanel();
        south.add((Component)verticesPanel, "South");
        JPanel textPanel = this.createGDDATextArea();
        south.add((Component)textPanel, "East");
        panel.add(south);
        return panel;
    }

    private JPanel createGDDATextArea() {
        JPanel panel = new JPanel();
        JScrollPane jsp = new JScrollPane(this.infoPaneGDDA);
        TitledBorder titleF = BorderFactory.createTitledBorder("Info Panel");
        jsp.setBorder(titleF);
        panel.add(jsp);
        return panel;
    }

    private JPanel createGDDAResultPanel() {
        JPanel panel = new JPanel();
        Object[] column = new Object[]{"DGDD", "0", "1", "2", "...", "k"};
        Object[][] data = new Object[][]{{"Orbit O", 0, 0, 0, 0, 0}, {"Orbit 1", 0, 0, 0, 0, 0}, {"Orbit 2", 0, 0, 0, 0, 0}};
        this.dgddTable = new JTable(data, column){

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int col) {
                Component comp = super.prepareRenderer(renderer, row, col);
                Object value = this.getModel().getValueAt(row, col);
                return comp;
            }
        };
        JScrollPane jpane = new JScrollPane(this.dgddTable, 20, 30);
        this.dgddTable.setAutoResizeMode(0);
        JPanel scroll = new JPanel();
        panel.add(jpane);
        scroll.add(new JScrollPane(panel));
        scroll.setEnabled(false);
        return scroll;
    }

    private JPanel createGDDAOptionPanel() {
        JPanel panel = new JPanel();
        JPanel buttonPanel = new JPanel(new GridLayout(2, 3));
        JButton chooser = new JButton("Choose second net");
        chooser.setVisible(true);
        chooser.addActionListener(e -> {
            Preferences prefs = Preferences.userRoot().node(this.getClass().getName());
            JFileChooser jfc = new JFileChooser(prefs.get(LAST_USED_FOLDER, new File(".").getAbsolutePath()));
            FileFilter[] filters = new FileFilter[]{new ExtensionFileFilter("Snoopy Petri Net file (.spped), (.pn)", new String[]{"SPPED", "PN"}), new ExtensionFileFilter(".pnt - INA PNT file (.pnt)", new String[]{"PNT"})};
            jfc.addChoosableFileFilter(filters[0]);
            jfc.addChoosableFileFilter(filters[1]);
            int returnVal = jfc.showOpenDialog(this);
            this.infoPaneGDDA.append("Choosen file: " + jfc.getSelectedFile().getName() + "\n");
            this.chooseSecondNet(jfc.getSelectedFile().getAbsolutePath());
            if (returnVal == 0) {
                this.generateGDDA.setEnabled(true);
                prefs.put(LAST_USED_FOLDER, jfc.getSelectedFile().getParent());
            }
        });
        buttonPanel.add(chooser);
        this.generateGDDA = new JButton("Compare nets");
        this.generateGDDA.addActionListener(e -> {
            this.gddaCalculator = new GDDAcalculator();
            Thread myThread = new Thread(this.gddaCalculator);
            myThread.start();
            this.saveDGDV1.setEnabled(true);
            this.saveDGDV2.setEnabled(true);
            this.saveDGDD.setEnabled(true);
        });
        this.generateGDDA.setEnabled(false);
        buttonPanel.add(this.generateGDDA);
        this.orbitSize = new JComboBox();
        this.orbitSize.setModel(new DefaultComboBoxModel<String>(new String[]{"Orbits", "18", "90", "592"}));
        buttonPanel.add(this.orbitSize);
        this.saveDGDV1 = new JButton("Save DGDV for first net");
        this.saveDGDV1.addActionListener(e -> this.saveDGDV(this.DGDVFirst));
        this.saveDGDV1.setEnabled(false);
        buttonPanel.add(this.saveDGDV1);
        this.saveDGDV2 = new JButton("Save DGDV for second net");
        this.saveDGDV2.addActionListener(e -> this.saveDGDV(this.DGDVSecond));
        this.saveDGDV2.setEnabled(false);
        buttonPanel.add(this.saveDGDV2);
        this.saveDGDD = new JButton("Save DGDD");
        this.saveDGDD.addActionListener(e -> this.saveDGDV(this.toInt(this.dataDGDD)));
        this.saveDGDD.setEnabled(false);
        buttonPanel.add(this.saveDGDD);
        panel.add(buttonPanel);
        return panel;
    }

    private int[][] toInt(Object[][] dataDGDD) {
        int[][] result = new int[dataDGDD.length][dataDGDD[0].length];
        for (int i = 0; i < dataDGDD.length; ++i) {
            for (int j = 0; j < dataDGDD[i].length; ++j) {
                result[i][j] = (Integer)dataDGDD[i][j];
            }
        }
        return result;
    }

    private void saveDGDV(int[][] data) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(1);
        if (chooser.showSaveDialog(this) == 0) {
            HolmesComparisonModule.exportToCSV(data, chooser.getSelectedFile().getAbsolutePath());
        } else {
            this.infoPaneGDDA.append("No directiory choosen for DGDV\n");
        }
    }

    private void compareGDDA() {
        GraphletsCalculator.GraphletsCalculator();
        int[][] firstSingleDGDV = this.calcDGDD(GUIManager.getDefaultGUIManager().getWorkspace().getProject(), true);
        int[][] secondSingleDGDV = this.calcDGDD(this.secondNet, false);
        long[] distanceDGDD = new long[GraphletsCalculator.globalOrbitMap.size()];
        double result = 0.0;
        double DGDDA = this.calcDGDDA(firstSingleDGDV, secondSingleDGDV, this.getOrbitsNumber());
        this.infoPaneGDDA.append("DGDDA : " + DGDDA + "\n");
        if (firstSingleDGDV.length != 0) {
            Object[] colNames = new String[firstSingleDGDV[0].length + 1];
            for (int i = 1; i < firstSingleDGDV[0].length + 1; ++i) {
                colNames[i] = String.valueOf(i);
            }
            DefaultTableModel model = new DefaultTableModel(this.dataDGDD, colNames);
            this.dgddTable.setAutoResizeMode(5);
            this.dgddTable.setModel(model);
            this.dgddTable.setAutoResizeMode(5);
        }
    }

    public int getOrbitsNumber() {
        return switch (this.orbitSize.getSelectedIndex()) {
            case 1 -> 18;
            case 2 -> 90;
            case 3 -> 592;
            default -> 592;
        };
    }

    public int[][] calcDGDD(PetriNet pn, boolean firstNet) {
        Object vectorOrbit;
        int[][] result = new int[0][0];
        ArrayList<int[]> DGDV = new ArrayList<int[]>();
        if (firstNet) {
            this.DGDVFirst = new int[pn.getNodes().size()][GraphletsCalculator.globalOrbitMap.size()];
        } else {
            this.DGDVSecond = new int[pn.getNodes().size()][GraphletsCalculator.globalOrbitMap.size()];
        }
        int nodeIndex = 0;
        for (Node startNode : pn.getNodes()) {
            vectorOrbit = GraphletsCalculator.vectorOrbit(startNode, false);
            DGDV.add((int[])vectorOrbit);
            if (firstNet) {
                this.DGDVFirst[pn.getNodes().indexOf((Object)startNode)] = (int[])vectorOrbit;
            } else {
                this.DGDVSecond[pn.getNodes().indexOf((Object)startNode)] = (int[])vectorOrbit;
            }
            DecimalFormat df = new DecimalFormat("0.00");
            String content = null;
            try {
                content = this.infoPaneGDDA.getDocument().getText(0, this.infoPaneGDDA.getDocument().getLength());
                int lastLineBreak = content.lastIndexOf(10);
                this.infoPaneGDDA.getDocument().remove(lastLineBreak, this.infoPaneGDDA.getDocument().getLength() - lastLineBreak);
                double progress = (double)nodeIndex / (double)pn.getNodes().size();
                this.infoPaneGDDA.append("\n" + df.format(progress * 100.0) + "%");
                ++nodeIndex;
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
        String content = null;
        try {
            content = this.infoPaneGDDA.getDocument().getText(0, this.infoPaneGDDA.getDocument().getLength());
            int lastLineBreak = content.lastIndexOf(10);
            this.infoPaneGDDA.getDocument().remove(lastLineBreak, this.infoPaneGDDA.getDocument().getLength() - lastLineBreak);
            this.infoPaneGDDA.append("finished.");
            ++nodeIndex;
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        int max = 0;
        vectorOrbit = DGDV.iterator();
        while (vectorOrbit.hasNext()) {
            int[] ints = (int[])vectorOrbit.next();
            int localMax = Arrays.stream(ints).max().getAsInt();
            if (localMax <= max) continue;
            max = localMax;
        }
        int orbitNumber = ((int[])DGDV.get(0)).length;
        int[][] d = new int[orbitNumber][max + 1];
        for (int[] ints : DGDV) {
            for (int m = 0; m < ints.length; ++m) {
                if (ints[m] <= 0) continue;
                int[] nArray = d[m];
                int n = ints[m];
                nArray[n] = nArray[n] + 1;
            }
        }
        return d;
    }

    public double calcDGDDA(int[][] nG, int[][] nH, int orbNumber) {
        int maxk = Math.max(nG[0].length, nH[0].length);
        double[] d = new double[orbNumber];
        this.dataDGDD = new Object[orbNumber][maxk + 1];
        for (int orb = 0; orb < orbNumber; ++orb) {
            double di = 0.0;
            for (int k = 0; k < maxk; ++k) {
                if (k == 0) {
                    this.dataDGDD[orb][k] = "Orb. - " + orb;
                    continue;
                }
                if (k >= nG[orb].length) {
                    this.dataDGDD[orb][k] = Math.pow(0 - nH[orb][k], 2.0);
                    di += ((Double)this.dataDGDD[orb][k]).doubleValue();
                    continue;
                }
                if (k >= nH[orb].length) {
                    this.dataDGDD[orb][k] = Math.pow(nG[orb][k] - 0, 2.0);
                    di += ((Double)this.dataDGDD[orb][k]).doubleValue();
                    continue;
                }
                this.dataDGDD[orb][k] = Math.pow(nG[orb][k] - nH[orb][k], 2.0);
                di += ((Double)this.dataDGDD[orb][k]).doubleValue();
            }
            d[orb] = 1.0 - 1.0 / Math.sqrt(2.0) * Math.sqrt(di);
        }
        return Math.abs(DoubleStream.of(d).sum() / (double)orbNumber);
    }

    private JPanel makeNetdivPanel() {
        JPanel panel = new JPanel();
        JPanel optionPanel = this.createNetdivOptionPanel();
        panel.add((Component)optionPanel, "North");
        JPanel south = new JPanel();
        JPanel verticesPanel = this.createNetdivResultPanel();
        south.add((Component)verticesPanel, "West");
        JPanel textPanel = this.createNetdivTextArea();
        south.add((Component)textPanel, "East");
        panel.add(south);
        return panel;
    }

    private JPanel createNetdivOptionPanel() {
        JPanel panel = new JPanel();
        JPanel buttonPanel = new JPanel(new GridLayout(1, 4));
        JButton chooser = new JButton("Choose second net");
        chooser.setVisible(true);
        chooser.addActionListener(e -> {
            Preferences prefs = Preferences.userRoot().node(this.getClass().getName());
            JFileChooser jfc = new JFileChooser(prefs.get(LAST_USED_FOLDER, new File(".").getAbsolutePath()));
            int returnVal = jfc.showOpenDialog(this);
            jfc.setFileFilter(new ExtensionFileFilter("INA PNT format (.pnt)", new String[]{"PNT"}));
            this.infoPaneNetdiv.append("Choosen file: " + jfc.getSelectedFile().getName() + "\n");
            this.chooseSecondNet(jfc.getSelectedFile().getAbsolutePath());
            if (returnVal == 0) {
                this.generateNetdiv.setEnabled(true);
                prefs.put(LAST_USED_FOLDER, jfc.getSelectedFile().getParent());
            }
        });
        buttonPanel.add(chooser);
        this.generateNetdiv = new JButton("Generate");
        this.generateNetdiv.setVisible(true);
        this.generateNetdiv.addActionListener(e -> {
            GraphletComparator gc = new GraphletComparator(592);
            this.infoPaneNetdiv.append(gc.compareNetdiv(this.getNDKsize(), this.getRadius(), GUIManager.getDefaultGUIManager().getWorkspace().getProject(), this.secondNet));
        });
        buttonPanel.add(this.generateNetdiv);
        this.graphletNDSize = new JComboBox();
        this.graphletNDSize.setModel(new DefaultComboBoxModel<String>(new String[]{"Graphlets size", "3-node size", "4-node size", "5-node size"}));
        buttonPanel.add(this.graphletNDSize);
        this.egoSize = new JComboBox();
        this.egoSize.setModel(new DefaultComboBoxModel<String>(new String[]{"Ego net size", "3-node radius", "4-node radius", "5-node radius", "6-node radius", "7-node radius", "8-node radius"}));
        buttonPanel.add(this.egoSize);
        panel.add(buttonPanel);
        return panel;
    }

    private int getNDKsize() {
        return switch (this.graphletNDSize.getSelectedIndex()) {
            case 1 -> 3;
            case 2 -> 4;
            case 3 -> 5;
            default -> 3;
        };
    }

    private int getRadius() {
        return switch (this.egoSize.getSelectedIndex()) {
            case 1 -> 3;
            case 2 -> 4;
            case 3 -> 5;
            case 4 -> 6;
            case 6 -> 7;
            case 7 -> 8;
            default -> 3;
        };
    }

    private JPanel createNetdivResultPanel() {
        return new JPanel();
    }

    private JPanel createNetdivTextArea() {
        JPanel panel = new JPanel();
        JScrollPane jsp = new JScrollPane(this.infoPaneNetdiv);
        TitledBorder titleF = BorderFactory.createTitledBorder("Info Panel");
        jsp.setBorder(titleF);
        panel.add(jsp);
        return panel;
    }

    private JPanel makeDecoPanel() {
        JPanel panel = new JPanel();
        JPanel csop = this.createStartOptionsPanel();
        panel.add((Component)csop, "North");
        this.decoResult = new JPanel();
        JScrollPane jsp = new JScrollPane(this.infoPaneDec);
        TitledBorder titleF = BorderFactory.createTitledBorder("Info Panel");
        jsp.setBorder(titleF);
        this.decoResult.add((Component)jsp, "Center");
        panel.add(this.decoResult);
        return panel;
    }

    private JPanel createStartOptionsPanel() {
        JPanel jp = new JPanel();
        JPanel buttonPanel = new JPanel(new GridLayout(0, 1));
        JButton chooser = new JButton("Choose second net");
        chooser.setVisible(true);
        chooser.addActionListener(e -> {
            Preferences prefs = Preferences.userRoot().node(this.getClass().getName());
            JFileChooser jfc = new JFileChooser(prefs.get(LAST_USED_FOLDER, new File(".").getAbsolutePath()));
            FileFilter[] filters = new FileFilter[]{new ExtensionFileFilter("Snoopy Petri Net file (.spped), (.pn)", new String[]{"SPPED", "PN"}), new ExtensionFileFilter(".pnt - INA PNT file (.pnt)", new String[]{"PNT"})};
            jfc.addChoosableFileFilter(filters[0]);
            jfc.addChoosableFileFilter(filters[1]);
            int returnVal = jfc.showOpenDialog(this);
            this.infoPaneDec.append("Choosen file: " + jfc.getSelectedFile().getName() + "\n");
            this.chooseSecondNet(jfc.getSelectedFile().getAbsolutePath());
            if (returnVal == 0) {
                this.generateDec.setEnabled(true);
                prefs.put(LAST_USED_FOLDER, jfc.getSelectedFile().getParent());
            }
        });
        buttonPanel.add(chooser);
        this.generateDec = new JButton("Compare nets");
        this.generateDec.addActionListener(e -> {
            this.decoCalculator = new DecoCalccalculator();
            Thread myThread = new Thread(this.decoCalculator);
            myThread.start();
        });
        this.generateDec.setEnabled(false);
        buttonPanel.add(this.generateDec);
        this.decoType = new JComboBox();
        this.decoType.setModel(new DefaultComboBoxModel<String>(new String[]{"Choose decomposition type", "con. ADT", "Functional", "T-net", "t-component", "s-component"}));
        buttonPanel.add(this.decoType);
        jp.add(buttonPanel);
        JPanel subComparisons = new JPanel(new GridLayout(4, 1));
        JCheckBox fts = new JCheckBox("First to Second");
        fts.addActionListener(actionEvent -> {
            this.decoCompareFtS = fts.isSelected();
        });
        fts.setSelected(true);
        subComparisons.add(fts);
        JCheckBox stf = new JCheckBox("Second to First");
        stf.addActionListener(actionEvent -> {
            this.decoCompareStF = stf.isSelected();
        });
        subComparisons.add(stf);
        JCheckBox ftf = new JCheckBox("First to First");
        ftf.addActionListener(actionEvent -> {
            this.decoCompareFtF = ftf.isSelected();
        });
        subComparisons.add(ftf);
        JCheckBox sts = new JCheckBox("Second to Second");
        sts.addActionListener(actionEvent -> {
            this.decoCompareStS = sts.isSelected();
        });
        subComparisons.add(sts);
        jp.add(subComparisons);
        JPanel firstQuestion = new JPanel(new GridLayout(0, 1));
        JRadioButton maxButton = new JRadioButton("Max common path");
        maxButton.setActionCommand(LAST_USED_FOLDER);
        maxButton.setSelected(true);
        maxButton.addActionListener(e -> {
            if (maxButton.isSelected()) {
                this.firstQuestionDec = false;
            }
        });
        firstQuestion.add(maxButton);
        JRadioButton minButton = new JRadioButton("Min common path");
        minButton.setActionCommand(LAST_USED_FOLDER);
        minButton.addActionListener(e -> {
            if (minButton.isSelected()) {
                this.firstQuestionDec = true;
            }
        });
        firstQuestion.add(minButton);
        ButtonGroup groupQ1 = new ButtonGroup();
        groupQ1.add(minButton);
        groupQ1.add(maxButton);
        TitledBorder titleF = BorderFactory.createTitledBorder("Path size");
        firstQuestion.setBorder(titleF);
        jp.add(firstQuestion);
        if (GUIManager.getDefaultGUIManager().getWorkspace().getProject().getT_InvMatrix() == null || GUIManager.getDefaultGUIManager().getWorkspace().getProject().getT_InvMatrix().isEmpty()) {
            this.infoPaneDec.append("Generate inwariants for net in workspace.\n");
        }
        JPanel secondQuestion = new JPanel(new GridLayout(0, 1));
        JRadioButton ttButton = new JRadioButton("Same type branches comparison");
        ttButton.setActionCommand(LAST_USED_FOLDER);
        ttButton.setSelected(true);
        ttButton.addActionListener(e -> {
            if (ttButton.isSelected()) {
                this.secondQuestionDec = false;
            }
        });
        secondQuestion.add(ttButton);
        JRadioButton tpButton = new JRadioButton("Mix type branches comparison");
        tpButton.setActionCommand(LAST_USED_FOLDER);
        tpButton.addActionListener(e -> {
            if (tpButton.isSelected()) {
                this.secondQuestionDec = true;
            }
        });
        secondQuestion.add(tpButton);
        ButtonGroup groupQ2 = new ButtonGroup();
        groupQ2.add(ttButton);
        groupQ2.add(tpButton);
        TitledBorder titleS = BorderFactory.createTitledBorder("Branch restriction");
        secondQuestion.setBorder(titleS);
        jp.add(secondQuestion);
        JPanel thirdQuestion = new JPanel(new GridLayout(0, 1));
        JRadioButton loButton = new JRadioButton("With loops");
        loButton.setActionCommand(LAST_USED_FOLDER);
        loButton.addActionListener(e -> {
            if (loButton.isSelected()) {
                this.thirdQuestionDec = false;
            }
        });
        loButton.setSelected(true);
        thirdQuestion.add(loButton);
        JRadioButton nloButton = new JRadioButton("Without loops");
        nloButton.setActionCommand(LAST_USED_FOLDER);
        nloButton.addActionListener(e -> {
            if (nloButton.isSelected()) {
                this.thirdQuestionDec = true;
            }
        });
        thirdQuestion.add(nloButton);
        ButtonGroup groupQ3 = new ButtonGroup();
        groupQ3.add(loButton);
        groupQ3.add(nloButton);
        TitledBorder titleT = BorderFactory.createTitledBorder("Loop restriction");
        thirdQuestion.setBorder(titleT);
        jp.add(thirdQuestion);
        JPanel indexQuestion = new JPanel(new GridLayout(0, 1));
        JRadioButton jacButton = new JRadioButton("Jackard index");
        jacButton.setActionCommand(LAST_USED_FOLDER);
        jacButton.addActionListener(e -> {
            if (jacButton.isSelected()) {
                this.indexQuestionB = false;
            }
        });
        jacButton.setSelected(true);
        indexQuestion.add(jacButton);
        JRadioButton sorButton = new JRadioButton("S\u00f8rensen index");
        sorButton.setActionCommand(LAST_USED_FOLDER);
        sorButton.addActionListener(e -> {
            if (sorButton.isSelected()) {
                this.indexQuestionB = true;
            }
        });
        indexQuestion.add(sorButton);
        ButtonGroup groupQ4 = new ButtonGroup();
        groupQ4.add(jacButton);
        groupQ4.add(sorButton);
        TitledBorder titleIn = BorderFactory.createTitledBorder("Index");
        indexQuestion.setBorder(titleIn);
        jp.add(indexQuestion);
        return jp;
    }

    private void compare() {
        if (SubnetCalculator.adtSubNets == null || SubnetCalculator.adtSubNets.isEmpty()) {
            JOptionPane jpo = new JOptionPane("No ADT sets!");
            GUIManager.getDefaultGUIManager().showDecoWindow();
        } else {
            this.listOfTablesDec.clear();
            InvariantsCalculator ic = new InvariantsCalculator(this.secondNet);
            ic.generateInvariantsForTest(this.secondNet);
            this.infoPaneDec.append("Second net: Invariants generated.\n");
            this.secondNet.setT_InvMatrix(ic.getInvariants(true), false);
            this.seconNetList = SubnetCalculator.generateADTFromSecondNet(this.secondNet);
            this.infoPaneDec.append("Second net: ADT generated.\n");
            this.sc = new SubnetComparator(SubnetCalculator.adtSubNets, this.seconNetList);
            this.infoPaneDec.append("Start comparison...\n");
            JPanel result = this.createResultsPanel();
            this.decoResult.add((Component)result, "West");
            this.revalidate();
        }
    }

    public JPanel createResultsPanel() {
        JPanel jp = new JPanel();
        JPanel leftPanel = new JPanel();
        this.tabbedDecoPane = new JTabbedPane();
        this.tabbedDecoPane.setSize(200, 500);
        this.sc.firstQuestion = this.firstQuestionDec;
        this.sc.secondQuestion = this.secondQuestionDec;
        this.sc.thirdQuestion = this.thirdQuestionDec;
        if (!(this.decoCompareFtS || this.decoCompareStF || this.decoCompareFtF || this.decoCompareStS)) {
            JOptionPane.showMessageDialog(this, "Please choose comparison");
        }
        if (this.decoCompareFtS) {
            this.infoPaneDec.append("Compare first net to second net.\n");
            JComponent panelFF = this.createPartResultTable(this.sc.compareFirstSecond(), false);
            this.tabbedDecoPane.addTab("First net to second net", null, panelFF, "Does nothing");
        }
        if (this.decoCompareStF) {
            this.infoPaneDec.append("Compare second net to first net.\n");
            JComponent panelSS = this.createPartResultTable(this.sc.compareSecondFirst(), false);
            this.tabbedDecoPane.addTab("Second net to first net", null, panelSS, "Does twice as much nothing");
        }
        if (this.decoCompareFtF) {
            this.infoPaneDec.append("Compare first net internally.\n");
            JComponent panelFS = this.createPartResultTable(this.sc.compareInternalFirst(), true);
            this.tabbedDecoPane.addTab("Internal similarity of First net", null, panelFS, "Still does nothing");
        }
        if (this.decoCompareStS) {
            this.infoPaneDec.append("Compare second net internally.\n");
            JComponent panelSF = this.createPartResultTable(this.sc.compareInternalSecond(), true);
            this.tabbedDecoPane.addTab("Internal similarity of Second net", null, panelSF, "Does nothing at all");
        }
        this.infoPaneDec.append("Comparison finished.\n");
        leftPanel.add(this.tabbedDecoPane);
        jp.add((Component)leftPanel, "Last");
        JPanel rightPanel = new JPanel(new GridLayout(0, 1));
        this.hungarianButton = new JRadioButton("Hungarian method");
        this.hungarianButton.setMnemonic(66);
        this.hungarianButton.addActionListener(e -> {
            if (this.hungarianButton.isSelected()) {
                this.coloringMode = 2;
                if (this.tabbedDecoPane.getSelectedIndex() < 2) {
                    int[] hungarianCels = this.calcHungarianCels(this.listOfTableContent.get(this.tabbedDecoPane.getSelectedIndex()));
                    this.colorAllHungarianCel(hungarianCels, this.listOfTableContent.get(this.tabbedDecoPane.getSelectedIndex()));
                }
            }
        });
        this.hungarianButton.setActionCommand(this.resultFlag);
        JRadioButton singleHandButton = new JRadioButton("Color single matching");
        singleHandButton.setMnemonic(68);
        singleHandButton.setSelected(true);
        singleHandButton.addActionListener(e -> {
            if (singleHandButton.isSelected()) {
                this.coloringMode = 0;
            }
        });
        JRadioButton handButton = new JRadioButton("Color choosen matching");
        handButton.setMnemonic(68);
        handButton.addActionListener(e -> {
            if (handButton.isSelected()) {
                this.coloringMode = 1;
            }
        });
        ButtonGroup group = new ButtonGroup();
        group.add(singleHandButton);
        group.add(handButton);
        group.add(this.hungarianButton);
        rightPanel.add(singleHandButton);
        rightPanel.add(handButton);
        rightPanel.add(this.hungarianButton);
        TitledBorder title = BorderFactory.createTitledBorder(LAST_USED_FOLDER);
        JButton saveButton = new JButton("Save to .csv");
        saveButton.addActionListener(e -> {
            JFileChooser fc = new JFileChooser();
            int returnVal = fc.showOpenDialog(this);
            if (returnVal == 0) {
                HolmesComparisonModule.exportToCSV(this.listOfTablesDec.get(0), fc.getSelectedFile().getPath() + "1-2.csv");
                HolmesComparisonModule.exportToCSV(this.listOfTablesDec.get(1), fc.getSelectedFile().getPath() + "2-1.csv");
                HolmesComparisonModule.exportToCSV(this.listOfTablesDec.get(2), fc.getSelectedFile().getPath() + "1-1.csv");
                HolmesComparisonModule.exportToCSV(this.listOfTablesDec.get(3), fc.getSelectedFile().getPath() + "2-2.csv");
                this.infoPaneDec.append("csv files saved!\n");
            }
        });
        rightPanel.add(saveButton);
        return jp;
    }

    public JComponent createPartResultTable(final ArrayList<ArrayList<GreatCommonSubnet>> gcls, final boolean isInternal) {
        int i;
        this.listOfTableContent.add(gcls);
        JPanel jp = new JPanel();
        jp.setPreferredSize(new Dimension(800, 300));
        final String[] netLabelsFirst = new String[gcls.size()];
        Object[] netLabelsSecond = new String[gcls.get(0).size()];
        for (i = 0; i < gcls.size(); ++i) {
            netLabelsFirst[i] = "SubF :" + i;
            System.out.println(netLabelsFirst[i]);
        }
        for (i = 0; i < gcls.get(0).size(); ++i) {
            netLabelsSecond[i] = "SubS :" + i;
            System.out.println(netLabelsSecond[i]);
        }
        AbstractListModel lm = new AbstractListModel(){
            final String[] headers;
            {
                this.headers = netLabelsFirst;
            }

            @Override
            public int getSize() {
                return this.headers.length;
            }

            @Override
            public Object getElementAt(int index) {
                return this.headers[index];
            }
        };
        Object[][] results = new String[gcls.size()][gcls.get(0).size()];
        for (int i2 = 0; i2 < gcls.size(); ++i2) {
            for (int j = 0; j < gcls.get(i2).size(); ++j) {
                results[i2][j] = gcls.get((int)i2).get((int)j).gcsValue + "/" + gcls.get((int)i2).get((int)j).firstNetNodeSize;
            }
        }
        final int[] hungarianCels = this.calcHungarianCels(gcls);
        final JTable comparisonTable = new JTable(results, netLabelsSecond){

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int col) {
                Component comp = super.prepareRenderer(renderer, row, col);
                Object value = this.getModel().getValueAt(row, col);
                HolmesComparisonModule.this.colorHungarianCels(row, col, comp, hungarianCels, gcls, isInternal);
                if (isInternal) {
                    HolmesComparisonModule.this.colorIsomorphicCels(row, col, comp, gcls);
                } else {
                    if (HolmesComparisonModule.this.coloringMode == 0) {
                        // empty if block
                    }
                    if (HolmesComparisonModule.this.coloringMode == 1) {
                        // empty if block
                    }
                    if (HolmesComparisonModule.this.coloringMode == 2) {
                        HolmesComparisonModule.this.colorHungarianCels(row, col, comp, hungarianCels, gcls, isInternal);
                    }
                }
                return comp;
            }
        };
        comparisonTable.setAutoResizeMode(0);
        JList rowHeader = new JList(lm);
        rowHeader.setFixedCellWidth(50);
        rowHeader.setFixedCellHeight(comparisonTable.getRowHeight());
        rowHeader.setCellRenderer(new RowHeaderRenderer(comparisonTable));
        comparisonTable.getSelectionModel().addListSelectionListener(event -> {});
        comparisonTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                GUIManager.getDefaultGUIManager().reset.clearGraphColors();
                int row = comparisonTable.rowAtPoint(evt.getPoint());
                int col = comparisonTable.columnAtPoint(evt.getPoint());
                if (row >= 0 && col >= 0 && HolmesComparisonModule.this.coloringMode == 0) {
                    HolmesComparisonModule.this.colorHungarianCel(row, col, gcls, isInternal);
                    TableCellEditor tableCellEditor = comparisonTable.getCellEditor(row, col);
                }
            }
        });
        JScrollPane scroll = new JScrollPane(comparisonTable);
        scroll.setRowHeaderView(rowHeader);
        this.listOfTablesDec.add(comparisonTable);
        return scroll;
    }

    private void colorHungarianCels(int row, int col, Component comp, int[] hungarianCels, ArrayList<ArrayList<GreatCommonSubnet>> gcls, boolean isInternal) {
        if (row < hungarianCels.length) {
            if (hungarianCels[row] == col) {
                comp.setBackground(Color.green);
            } else {
                comp.setBackground(Color.white);
            }
        }
    }

    private void colorHungarianCel(int row, int col, ArrayList<ArrayList<GreatCommonSubnet>> gcls, boolean isInternal) {
        if (isInternal && row <= col) {
            isInternal = false;
        }
        switch (this.decoType.getSelectedIndex()) {
            case 0: {
                System.out.println("Wrong type of decomposed set to color");
                break;
            }
            case 1: {
                this.colorSubnet(gcls.get(row).get(col), SubnetCalculator.adtSubNets.get(row), isInternal);
                break;
            }
            case 2: {
                this.colorSubnet(gcls.get(row).get(col), SubnetCalculator.functionalSubNets.get(row), isInternal);
                break;
            }
            case 3: {
                this.colorSubnet(gcls.get(row).get(col), SubnetCalculator.tnetSubNets.get(row), isInternal);
                break;
            }
            case 4: {
                this.colorSubnet(gcls.get(row).get(col), SubnetCalculator.tinvSubNets.get(row), isInternal);
            }
        }
    }

    private void colorAllHungarianCel(int[] hungarianCels, ArrayList<ArrayList<GreatCommonSubnet>> gcls) {
        for (int i = 0; i < gcls.size(); ++i) {
            block8: for (int j = 0; j < gcls.get(i).size(); ++j) {
                if (i >= hungarianCels.length || hungarianCels[i] != j) continue;
                switch (this.decoType.getSelectedIndex()) {
                    case 0: {
                        System.out.println("Wrong type of decomposed set to color");
                        continue block8;
                    }
                    case 1: {
                        this.colorSubnetDensity(gcls.get(i).get(j), SubnetCalculator.functionalSubNets.get(i), i, gcls.size());
                        continue block8;
                    }
                    case 2: {
                        this.colorSubnetDensity(gcls.get(i).get(j), SubnetCalculator.adtSubNets.get(i), i, gcls.size());
                        continue block8;
                    }
                    case 3: {
                        this.colorSubnetDensity(gcls.get(i).get(j), SubnetCalculator.tnetSubNets.get(i), i, gcls.size());
                        continue block8;
                    }
                    case 4: {
                        this.colorSubnetDensity(gcls.get(i).get(j), SubnetCalculator.tinvSubNets.get(i), i, gcls.size());
                    }
                }
            }
        }
    }

    private void colorSubnetDensity(GreatCommonSubnet gcs, SubnetCalculator.SubNet sn, int fr, int max) {
        Color randomColor = new Color(0, (int)(255.0 * ((double)fr / (double)max)), 0);
        for (Node transition : sn.getSubNode()) {
            if (transition.getType() == PetriNetElement.PetriNetElementType.TRANSITION) {
                ((Transition)transition).drawGraphBoxT.setColorWithNumber(true, Color.RED, false, 0.0, true, LAST_USED_FOLDER);
            }
            if (transition.getType() != PetriNetElement.PetriNetElementType.PLACE) continue;
            ((Place)transition).drawGraphBoxP.setColorWithNumber(true, Color.RED, false, 0.0, true, LAST_USED_FOLDER);
        }
        ArrayList<Arc> arcs = sn.getSubArcs();
        for (Arc arc : arcs) {
            arc.arcDecoBox.setColor(true, Color.red);
        }
        for (SubnetComparator.PartialSubnetElements pse : gcs.psel) {
            for (Node transition : pse.partialNodes) {
                if (transition.getType() == PetriNetElement.PetriNetElementType.TRANSITION) {
                    ((Transition)transition).drawGraphBoxT.setColorWithNumber(true, randomColor, false, 0.0, true, LAST_USED_FOLDER);
                }
                if (transition.getType() != PetriNetElement.PetriNetElementType.PLACE) continue;
                ((Place)transition).drawGraphBoxP.setColorWithNumber(true, randomColor, false, 0.0, true, LAST_USED_FOLDER);
            }
            for (Arc arc : pse.partialArcs) {
                arc.arcDecoBox.setColor(true, randomColor);
            }
        }
        GUIManager.getDefaultGUIManager().getWorkspace().getProject().repaintAllGraphPanels();
    }

    private int[] calcHungarianCels(ArrayList<ArrayList<GreatCommonSubnet>> subNetArrayList) {
        double[][] matrix = new double[subNetArrayList.size()][subNetArrayList.get(0).size()];
        for (int i = 0; i < subNetArrayList.size(); ++i) {
            for (int j = 0; j < subNetArrayList.get(i).size(); ++j) {
                matrix[i][j] = 1.0 - subNetArrayList.get((int)i).get((int)j).gcsValue;
            }
        }
        Hungarian h = new Hungarian(matrix);
        int[] result = h.execute();
        for (int i = 0; i < result.length; ++i) {
        }
        return result;
    }

    private void colorIsomorphicCels(int row, int col, Component comp, ArrayList<ArrayList<GreatCommonSubnet>> subNetArrayList) {
        if (subNetArrayList.get((int)row).get((int)col).gcsValue == (double)subNetArrayList.get((int)row).get((int)col).firstNetNodeSize) {
            if (subNetArrayList.get((int)row).get((int)col).secondNetNodeSize == subNetArrayList.get((int)row).get((int)col).firstNetNodeSize) {
                comp.setBackground(new Color(0, 153, 0));
            } else {
                comp.setBackground(Color.green);
            }
        } else if (subNetArrayList.get((int)row).get((int)col).gcsValue == 0.0) {
            comp.setBackground(Color.red);
        } else if (subNetArrayList.get((int)row).get((int)col).gcsValue > (double)subNetArrayList.get((int)row).get((int)col).firstNetNodeSize || subNetArrayList.get((int)row).get((int)col).gcsValue > (double)subNetArrayList.get((int)row).get((int)col).secondNetNodeSize) {
            comp.setBackground(Color.blue);
        } else {
            comp.setBackground(Color.white);
        }
    }

    private void colorSubnet(GreatCommonSubnet gcs, SubnetCalculator.SubNet sn, boolean map) {
        for (Node node : sn.getSubNode()) {
            if (node.getType() == PetriNetElement.PetriNetElementType.TRANSITION) {
                ((Transition)node).drawGraphBoxT.setColorWithNumber(true, Color.RED, false, 0.0, true, LAST_USED_FOLDER);
            }
            if (node.getType() != PetriNetElement.PetriNetElementType.PLACE) continue;
            ((Place)node).drawGraphBoxP.setColorWithNumber(true, Color.RED, false, 0.0, true, LAST_USED_FOLDER);
        }
        ArrayList<Arc> arcs = sn.getSubArcs();
        for (Arc arc : arcs) {
            arc.arcDecoBox.setColor(true, Color.red);
        }
        int n = 0;
        if (!gcs.psel.isEmpty()) {
            SubnetComparator.PartialSubnetElements pse = gcs.psel.get(n);
            for (Node transition : pse.partialNodes) {
                System.out.println("Pered map :" + transition.getName());
                if (map) {
                    transition = pse.nodesMap.get(transition);
                }
                System.out.println("Post map :" + transition.getName());
                if (transition.getType() == PetriNetElement.PetriNetElementType.TRANSITION) {
                    ((Transition)transition).drawGraphBoxT.setColorWithNumber(true, Color.GREEN, false, 0.0, true, LAST_USED_FOLDER);
                }
                if (transition.getType() != PetriNetElement.PetriNetElementType.PLACE) continue;
                ((Place)transition).drawGraphBoxP.setColorWithNumber(true, Color.GREEN, false, 0.0, true, LAST_USED_FOLDER);
            }
            for (Arc arc : pse.partialArcs) {
                if (map) {
                    arc = pse.arcsMap.get(arc);
                }
                arc.arcDecoBox.setColor(true, Color.GREEN);
            }
        }
        GUIManager.getDefaultGUIManager().getWorkspace().getProject().repaintAllGraphPanels();
    }

    public static boolean exportToCSV(JTable tableToExport, String pathToExportTo) {
        try {
            int i;
            TableModel model = tableToExport.getModel();
            FileWriter csv = new FileWriter(pathToExportTo);
            for (i = 0; i < model.getColumnCount(); ++i) {
                csv.write(model.getColumnName(i) + ",");
            }
            csv.write("\n");
            for (i = 0; i < model.getRowCount(); ++i) {
                for (int j = 0; j < model.getColumnCount(); ++j) {
                    csv.write(model.getValueAt(i, j).toString() + ",");
                }
                csv.write("\n");
            }
            csv.close();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean exportToCSV(int[][] data, String pathToExportTo) {
        try {
            FileWriter csv = new FileWriter(pathToExportTo);
            int[][] nArray = data;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                int[] datum;
                for (int i2 : datum = nArray[i]) {
                    csv.write(i2 + ",");
                }
                csv.write("\n");
            }
            csv.close();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private JPanel makeBranchPanel() {
        JPanel panel = new JPanel();
        JPanel optionPanel = this.createBramchOptionPanel();
        panel.add((Component)optionPanel, "North");
        JPanel south = new JPanel();
        JPanel textPanel = this.createBranchTextArea();
        south.add((Component)textPanel, "East");
        JPanel resultPanel = new JPanel();
        this.branchTabs = new JPanel();
        this.branchTabs.setVisible(true);
        south.add((Component)this.branchTabs, "West");
        panel.add(south);
        this.listBranchView = new JPanel();
        this.listBranchView.setVisible(true);
        panel.add((Component)this.listBranchView, "South");
        return panel;
    }

    private JPanel createBramchOptionPanel() {
        JPanel panel = new JPanel();
        JPanel buttonPanel = new JPanel(new GridLayout(1, 4));
        JButton chooser = new JButton("Choose second net");
        chooser.setVisible(true);
        chooser.addActionListener(e -> {
            Preferences prefs = Preferences.userRoot().node(this.getClass().getName());
            JFileChooser jfc = new JFileChooser(prefs.get(LAST_USED_FOLDER, new File(".").getAbsolutePath()));
            FileFilter[] filters = new FileFilter[]{new ExtensionFileFilter("Snoopy Petri Net file (.spped), (.pn)", new String[]{"SPPED", "PN"}), new ExtensionFileFilter(".pnt - INA PNT file (.pnt)", new String[]{"PNT"})};
            jfc.addChoosableFileFilter(filters[0]);
            jfc.addChoosableFileFilter(filters[1]);
            int returnVal = jfc.showOpenDialog(this);
            this.infoPaneBranch.append("Choosen file: " + jfc.getSelectedFile().getName() + "\n");
            this.chooseSecondNet(jfc.getSelectedFile().getAbsolutePath());
            if (returnVal == 0) {
                this.generateBranch.setEnabled(true);
                prefs.put(LAST_USED_FOLDER, jfc.getSelectedFile().getParent());
            }
        });
        buttonPanel.add(chooser);
        this.generateBranch = new JButton("Generate");
        this.generateBranch.setVisible(true);
        this.generateBranch.addActionListener(e -> {
            if (this.reGenerateBoolean) {
                this.infoPaneBranch.selectAll();
                this.infoPaneBranch.replaceSelection(LAST_USED_FOLDER);
            }
            BranchesServerCalc bsc = new BranchesServerCalc();
            BranchesServerCalc.ParsedBranchData result = bsc.compare(GUIManager.getDefaultGUIManager().getWorkspace().getProject(), this.secondNet, 1);
            this.parsBranchingData(result);
            this.reGenerateBoolean = true;
        });
        buttonPanel.add(this.generateBranch);
        this.branchingVariant = new JComboBox();
        this.branchingVariant.setModel(new DefaultComboBoxModel<String>(new String[]{"Matching variant", "Type I", "Type II", "Type III", "Type IV", "Type V"}));
        JButton singleAnalysis = new JButton("Single net branching analysis");
        singleAnalysis.setVisible(true);
        singleAnalysis.addActionListener(e -> {
            GUIManager.getDefaultGUIManager().createBranchWindow();
            GUIManager.getDefaultGUIManager().showBranchWindow();
        });
        buttonPanel.add(singleAnalysis);
        panel.add(buttonPanel);
        return panel;
    }

    public void parsBranchingData(BranchesServerCalc.ParsedBranchData result) {
        JPanel tabRes = this.createBranchDiagramsPanel(result);
        this.infoPaneBranch.setColumns(25);
        this.infoPaneBranch.revalidate();
        this.infoPaneBranch.append("Calculation compleated :\n");
        this.infoPaneBranch.append("BrRDF value for all vertices : " + result.brrdf.vBrRDFvalue + "\n");
        this.infoPaneBranch.append("BrRDF value for transitions : " + result.brrdf.tBrRDFvalue + "\n");
        this.infoPaneBranch.append("BrRDF value for places : " + result.brrdf.pBrRDFvalue + "\n");
        this.infoPaneBranch.append("\n");
        this.infoPaneBranch.append("Partial BrRDF for each vertex: \n");
        for (int x = 0; x < result.brrdf.branchingVertices.size(); ++x) {
            String name = result.brrdf.branchingVertices.get(x).getTypeOfBV().equals((Object)PetriNetElement.PetriNetElementType.TRANSITION) ? "T" : "P";
            String line = name + "<" + result.brrdf.branchingVertices.get(x).getNumberOfInTransitions() + "," + result.brrdf.branchingVertices.get(x).getNumberOfOutTransitions() + "," + result.brrdf.branchingVertices.get(x).getNumberOfInPlace() + "," + result.brrdf.branchingVertices.get(x).getNumberOfOutPlace() + ">";
            this.infoPaneBranch.append(line + " : " + result.brrdf.vBrRDFtable[x] + "\n");
        }
        this.calcDataForRelationTable(result);
        this.branchTabs.removeAll();
        this.branchTabs.add((Component)tabRes, "West");
        this.branchTabs.revalidate();
    }

    private void calcDataForRelationTable(BranchesServerCalc.ParsedBranchData result) {
        ArrayList<branchingPairs> bp = new ArrayList<branchingPairs>();
        ArrayList<branchingRelation> br2 = new ArrayList<branchingRelation>();
        for (BranchVertex vertex : result.lbv2) {
            boolean isIso = false;
            for (branchingRelation br : br2) {
                isIso = br.compare(vertex);
            }
            if (isIso) continue;
            br2.add(new branchingRelation(vertex));
            bp.add(new branchingPairs(null, (branchingRelation)br2.get(br2.size() - 1)));
        }
        ArrayList<branchingRelation> br1 = new ArrayList<branchingRelation>();
        for (BranchVertex vertex : result.lbv1) {
            boolean isIso = false;
            for (branchingRelation br : br1) {
                isIso = br.compare(vertex);
            }
            if (isIso) continue;
            br1.add(new branchingRelation(vertex));
            boolean noIso = true;
            for (branchingPairs element : bp) {
                if (element.net2 == null || !element.net2.isIso(vertex)) continue;
                element.net1 = (branchingRelation)br1.get(br1.size() - 1);
                noIso = false;
            }
            if (!noIso) continue;
            bp.add(new branchingPairs((branchingRelation)br1.get(br1.size() - 1), null));
        }
        for (branchingPairs basePair : bp) {
            for (branchingPairs internalPair : bp) {
                if (basePair.type.isIncludED(internalPair.type.root)) {
                    if (!basePair.smaller.contains(internalPair)) {
                        basePair.smaller.add(internalPair);
                    }
                    if (!internalPair.larger.contains(basePair)) {
                        internalPair.larger.add(basePair);
                    }
                }
                if (!basePair.type.isIncludING(internalPair.type.root)) continue;
                if (!basePair.larger.contains(internalPair)) {
                    basePair.larger.add(internalPair);
                }
                if (internalPair.smaller.contains(basePair)) continue;
                internalPair.smaller.add(basePair);
            }
        }
    }

    private JPanel createBranchingList(ArrayList<branchingPairs> bp) {
        this.currentBranchingRelations.clear();
        this.currentBranchingRelations = bp;
        JPanel jp = new JPanel();
        JPanel northPanel = new JPanel(new FlowLayout());
        JLabel name = new JLabel("Choose branch vertex");
        northPanel.add(name);
        String[] branchingString = this.calcBranchingString(bp);
        JComboBox<String> brList = new JComboBox<String>(branchingString);
        brList.setSelectedIndex(0);
        brList.addActionListener(e -> {
            branchingPairs pair = this.currentBranchingRelations.get(brList.getSelectedIndex());
            ArrayList<branchingPairs> larger = pair.larger;
            ArrayList<branchingPairs> smaller = pair.smaller;
            DefaultListModel<String> centerNodel = this.createListInterior(brList, pair);
            this.centerBranchList.setModel(centerNodel);
            this.centerBranchList.setVisible(true);
            this.centerBranchList.updateUI();
            this.centerBranchList.setBounds(200, 200, 75, 75);
            DefaultListModel leftModel = new DefaultListModel();
            for (branchingPairs element : pair.larger) {
                DefaultListModel<String> tmpModel = this.createListInterior(brList, element);
                HolmesComparisonModule.addTo(tmpModel, leftModel);
            }
            this.leftBranchList.setModel(leftModel);
            this.leftBranchList.setVisible(true);
            this.leftBranchList.updateUI();
            this.leftBranchList.setBounds(200, 200, 75, 75);
            DefaultListModel rightModel = new DefaultListModel();
            for (branchingPairs element : pair.smaller) {
                DefaultListModel<String> tmpModel = this.createListInterior(brList, element);
                HolmesComparisonModule.addTo(tmpModel, rightModel);
            }
            this.rightBranchList.setModel(rightModel);
            this.rightBranchList.setVisible(true);
            this.rightBranchList.updateUI();
            this.rightBranchList.setBounds(200, 200, 75, 75);
        });
        jp.add(brList);
        DefaultListModel<String> centerNodel = new DefaultListModel<String>();
        DefaultListModel<String> leftModel = new DefaultListModel<String>();
        DefaultListModel<String> rightModel = new DefaultListModel<String>();
        leftModel.addElement("TEST");
        centerNodel.addElement("TEST");
        rightModel.addElement("TEST");
        this.leftBranchList = new JList(leftModel);
        this.centerBranchList = new JList(centerNodel);
        this.rightBranchList = new JList(rightModel);
        jp.add(this.leftBranchList);
        jp.add(this.centerBranchList);
        jp.add(this.rightBranchList);
        this.listBranchView.add((Component)jp, "South");
        return jp;
    }

    private DefaultListModel<String> createListInterior(JComboBox brList, branchingPairs pair) {
        int i;
        DefaultListModel<String> centerNodel = new DefaultListModel<String>();
        centerNodel.addElement(brList.getSelectedItem().toString());
        centerNodel.addElement("FIRST NET");
        for (i = 0; i < pair.net1.list.size(); ++i) {
            centerNodel.addElement("- " + pair.net1.list.get(i).getBVName());
        }
        centerNodel.addElement("SECOND NET");
        for (i = 0; i < pair.net2.list.size(); ++i) {
            centerNodel.addElement("- " + pair.net2.list.get(i).getBVName());
        }
        return centerNodel;
    }

    private String getBRanchName(BranchVertex root) {
        String name = root.equals((Object)PetriNetElement.PetriNetElementType.TRANSITION) ? "T" : "P";
        String result = name + "<" + root.getNumberOfInTransitions() + "," + root.getNumberOfOutTransitions() + "," + root.getNumberOfInPlace() + "," + root.getNumberOfOutPlace() + ">";
        return result;
    }

    private String[] calcBranchingString(ArrayList<branchingPairs> bp) {
        String[] result = new String[bp.size()];
        for (int i = 0; i < bp.size(); ++i) {
            String name = bp.get((int)i).type.root.getTypeOfBV().equals((Object)PetriNetElement.PetriNetElementType.TRANSITION) ? "T" : "P";
            result[i] = name + "<" + bp.get((int)i).type.root.getNumberOfInTransitions() + "," + bp.get((int)i).type.root.getNumberOfOutTransitions() + "," + bp.get((int)i).type.root.getNumberOfInPlace() + "," + bp.get((int)i).type.root.getNumberOfOutPlace() + ">";
        }
        return result;
    }

    private Map<? extends BranchVertex, ? extends Integer> parsed(ArrayList<BranchVertex> onlyFIrst) {
        HashMap<BranchVertex, Integer> result = new HashMap<BranchVertex, Integer>();
        while (onlyFIrst.size() > 0) {
            BranchVertex bv1 = onlyFIrst.get(0);
            onlyFIrst.remove(bv1);
            int counter = 1;
            ArrayList<BranchVertex> toRemove = new ArrayList<BranchVertex>();
            for (BranchVertex bv2 : onlyFIrst) {
                if (!this.sameType(bv1, bv2)) continue;
                ++counter;
                toRemove.add(bv2);
            }
            onlyFIrst.removeAll(toRemove);
            result.put(bv1, counter);
        }
        return result;
    }

    private int sameTypeInList(BranchVertex bv1, ArrayList<BranchVertex> list) {
        int position = -1;
        for (BranchVertex bv2 : list) {
            if (!this.sameType(bv1, bv2)) continue;
            position = list.indexOf(bv2);
        }
        return position;
    }

    private boolean sameType(BranchVertex bv1, BranchVertex bv2) {
        if (bv2.getBVName().equals("promoting_thinning_of_the_fibrous_cap") || bv1.getBVName().equals("promoting_thinning_of_the_fibrous_cap")) {
            System.out.println();
        }
        return bv1.getTypeOfBV().equals((Object)bv2.getTypeOfBV()) && bv1.getOutDegreeOfBV() == bv2.getOutDegreeOfBV() && bv1.getInDegreeOfBV() == bv2.getInDegreeOfBV() && bv1.getNumberOfInPlace() == bv2.getNumberOfInPlace() && bv1.getNumberOfOutPlace() == bv2.getNumberOfOutPlace() && bv1.getNumberOfInTransitions() == bv2.getNumberOfInTransitions() && bv1.getNumberOfOutTransitions() == bv2.getNumberOfOutTransitions();
    }

    private JPanel createBranchResultPanel() {
        JPanel panel = new JPanel();
        Object[] column = new Object[]{"Branches", "First net", "Second net"};
        this.dataBranch = new Object[][]{{"Branch O", "-", "-"}};
        this.branchTable = new JTable(this.dataBranch, column);
        JScrollPane jpane = new JScrollPane(this.branchTable);
        JPanel scroll = new JPanel();
        panel.add(jpane);
        scroll.add(new JScrollPane(panel));
        scroll.setEnabled(false);
        return scroll;
    }

    private JPanel createBranchTextArea() {
        JPanel panel = new JPanel();
        JScrollPane jsp = new JScrollPane(this.infoPaneBranch);
        TitledBorder titleF = BorderFactory.createTitledBorder("Info Panel");
        jsp.setBorder(titleF);
        panel.add(jsp);
        return panel;
    }

    private JPanel createBranchDiagramsPanel(BranchesServerCalc.ParsedBranchData result) {
        JPanel jp = new JPanel();
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.setSize(200, 500);
        this.setSize(1250, 800);
        JComponent panelFF = this.createDiagram(result, 0);
        tabbedPane.addTab("Branching vertices BrRDF", null, panelFF, "Diagram for branching vertices ");
        tabbedPane.setMnemonicAt(0, 49);
        JComponent panelFP = this.createDiagram(result, 1);
        tabbedPane.addTab("Branching transitions BrRDF", null, panelFP, "Diagram for branching transitions ");
        tabbedPane.setMnemonicAt(1, 50);
        JComponent panelPP = this.createDiagram(result, 2);
        tabbedPane.addTab("Branching places BrRDF", null, panelPP, "Diagram for branching places ");
        tabbedPane.setMnemonicAt(2, 51);
        jp.add(tabbedPane);
        return jp;
    }

    private JComponent createDiagram(BranchesServerCalc.ParsedBranchData result, int mod) {
        DecimalFormat format;
        NumberAxis yAxis;
        SymbolAxis rangeAxis;
        Paint[] paintArray;
        XYBarRenderer xybarrenderer;
        XYPlot xyplot;
        ChartPanel vertChartPanel;
        boolean createURL;
        boolean createTooltip;
        boolean showLegend;
        String yAxisLabel;
        String xAxisLabel;
        int pos;
        int fb1;
        JPanel jp = new JPanel();
        ArrayList<BranchVertex> lista = new ArrayList<BranchVertex>();
        int position = 0;
        XYSeries series1 = new XYSeries((Comparable)((Object)"Branching vertices of first net"));
        XYSeries series2 = new XYSeries((Comparable)((Object)"Branching vertices of second net"));
        for (fb1 = 0; fb1 < result.lbv1.size(); ++fb1) {
            pos = this.sameTypeInList(result.lbv1.get(fb1), lista);
            if (pos > -1) {
                if (!(mod == 1 && result.lbv1.get(fb1).getTypeOfBV().equals((Object)PetriNetElement.PetriNetElementType.TRANSITION) || mod == 2 && result.lbv1.get(fb1).getTypeOfBV().equals((Object)PetriNetElement.PetriNetElementType.PLACE)) && mod != 0) continue;
                series1.update((Number)pos, (Number)(series1.getY(pos).intValue() + 1));
                System.out.println("Position: " + pos + " - " + result.lbv1.get(fb1).getBVName());
                continue;
            }
            if (!(mod == 1 && result.lbv1.get(fb1).getTypeOfBV().equals((Object)PetriNetElement.PetriNetElementType.TRANSITION) || mod == 2 && result.lbv1.get(fb1).getTypeOfBV().equals((Object)PetriNetElement.PetriNetElementType.PLACE)) && mod != 0) continue;
            series1.add((double)position, 1.0);
            series2.add((double)position, 0.0);
            lista.add(result.lbv1.get(fb1));
            System.out.println("Position: " + position + " - " + result.lbv1.get(fb1).getBVName());
            ++position;
        }
        System.out.println("second");
        for (fb1 = 0; fb1 < result.lbv2.size(); ++fb1) {
            pos = this.sameTypeInList(result.lbv2.get(fb1), lista);
            if (pos > -1) {
                if (!(mod == 1 && result.lbv2.get(fb1).getTypeOfBV().equals((Object)PetriNetElement.PetriNetElementType.TRANSITION) || mod == 2 && result.lbv2.get(fb1).getTypeOfBV().equals((Object)PetriNetElement.PetriNetElementType.PLACE)) && mod != 0) continue;
                series2.update((Number)pos, (Number)(series2.getY(pos).intValue() + 1));
                System.out.println("Position: " + pos + " - " + result.lbv2.get(fb1).getBVName());
                continue;
            }
            if (!(mod == 1 && result.lbv2.get(fb1).getTypeOfBV().equals((Object)PetriNetElement.PetriNetElementType.TRANSITION) || mod == 2 && result.lbv2.get(fb1).getTypeOfBV().equals((Object)PetriNetElement.PetriNetElementType.PLACE)) && mod != 0) continue;
            series1.add((double)position, 0.0);
            series2.add((double)position, 1.0);
            lista.add(result.lbv2.get(fb1));
            System.out.println("Position: " + position + " - " + result.lbv2.get(fb1).getBVName());
            ++position;
        }
        String[] axisX = new String[lista.size()];
        for (int x = 0; x < lista.size(); ++x) {
            String name = lista.get(x).getTypeOfBV().equals((Object)PetriNetElement.PetriNetElementType.TRANSITION) ? "T" : "P";
            axisX[x] = name + "<" + lista.get(x).getNumberOfInTransitions() + "," + lista.get(x).getNumberOfOutTransitions() + "," + lista.get(x).getNumberOfInPlace() + "," + lista.get(x).getNumberOfOutPlace() + ">";
        }
        if (mod == 0) {
            String chartTitle = "Branching vertices measure";
            xAxisLabel = "Branching vertices";
            yAxisLabel = "Count";
            showLegend = true;
            createTooltip = true;
            createURL = false;
            XYSeriesCollection branchVertSeriesDataSet = new XYSeriesCollection();
            JFreeChart branchVertChart = ChartFactory.createHistogram(chartTitle, xAxisLabel, yAxisLabel, branchVertSeriesDataSet, PlotOrientation.VERTICAL, showLegend, createTooltip, createURL);
            branchVertChart.getTitle().setFont(new Font("Dialog", 0, 14));
            vertChartPanel = new ChartPanel(branchVertChart);
            branchVertSeriesDataSet.removeAllSeries();
            branchVertSeriesDataSet.addSeries(series1);
            branchVertSeriesDataSet.addSeries(series2);
            xyplot = (XYPlot)branchVertChart.getPlot();
            xyplot.setForegroundAlpha(0.85f);
            xybarrenderer = (XYBarRenderer)xyplot.getRenderer();
            xybarrenderer.setBarPainter(new StandardXYBarPainter());
            paintArray = new Paint[]{new Color(-2130967958, true), new Color(-2145915385, true)};
            rangeAxis = new SymbolAxis("Branching Vertices", axisX);
            rangeAxis.setVerticalTickLabels(true);
            xyplot.setDomainAxis(rangeAxis);
            yAxis = (NumberAxis)xyplot.getRangeAxis();
            format = new DecimalFormat("0");
            yAxis.setNumberFormatOverride(format);
            yAxis.setTickUnit(new NumberTickUnit(1.0));
            xyplot.setDrawingSupplier(new DefaultDrawingSupplier(paintArray, DefaultDrawingSupplier.DEFAULT_FILL_PAINT_SEQUENCE, DefaultDrawingSupplier.DEFAULT_OUTLINE_PAINT_SEQUENCE, DefaultDrawingSupplier.DEFAULT_STROKE_SEQUENCE, DefaultDrawingSupplier.DEFAULT_OUTLINE_STROKE_SEQUENCE, DefaultDrawingSupplier.DEFAULT_SHAPE_SEQUENCE));
            jp.add(vertChartPanel);
        }
        if (mod == 1) {
            String chartTitle = "Branching vertices measure";
            xAxisLabel = "Branching vertices";
            yAxisLabel = "Count";
            showLegend = true;
            createTooltip = true;
            createURL = false;
            XYSeriesCollection branchSeriesTranDataSet = new XYSeriesCollection();
            JFreeChart branchTranChart = ChartFactory.createHistogram(chartTitle, xAxisLabel, yAxisLabel, branchSeriesTranDataSet, PlotOrientation.VERTICAL, showLegend, createTooltip, createURL);
            branchTranChart.getTitle().setFont(new Font("Dialog", 0, 14));
            vertChartPanel = new ChartPanel(branchTranChart);
            branchSeriesTranDataSet.removeAllSeries();
            branchSeriesTranDataSet.addSeries(series1);
            branchSeriesTranDataSet.addSeries(series2);
            xyplot = (XYPlot)branchTranChart.getPlot();
            xyplot.setForegroundAlpha(0.85f);
            xybarrenderer = (XYBarRenderer)xyplot.getRenderer();
            xybarrenderer.setBarPainter(new StandardXYBarPainter());
            paintArray = new Paint[]{new Color(-2130967958, true), new Color(-2145915385, true)};
            rangeAxis = new SymbolAxis("Branching Vertices", axisX);
            rangeAxis.setVerticalTickLabels(true);
            xyplot.setDomainAxis(rangeAxis);
            yAxis = (NumberAxis)xyplot.getRangeAxis();
            format = new DecimalFormat("0");
            yAxis.setNumberFormatOverride(format);
            yAxis.setTickUnit(new NumberTickUnit(1.0));
            xyplot.setDrawingSupplier(new DefaultDrawingSupplier(paintArray, DefaultDrawingSupplier.DEFAULT_FILL_PAINT_SEQUENCE, DefaultDrawingSupplier.DEFAULT_OUTLINE_PAINT_SEQUENCE, DefaultDrawingSupplier.DEFAULT_STROKE_SEQUENCE, DefaultDrawingSupplier.DEFAULT_OUTLINE_STROKE_SEQUENCE, DefaultDrawingSupplier.DEFAULT_SHAPE_SEQUENCE));
            this.branchChartPanel.setVisible(true);
            jp.add(vertChartPanel);
        }
        if (mod == 2) {
            String chartTitle = "Branching vertices measure";
            xAxisLabel = "Branching vertices";
            yAxisLabel = "Count";
            showLegend = true;
            createTooltip = true;
            createURL = false;
            XYSeriesCollection branchSeriesPlaDataSet = new XYSeriesCollection();
            JFreeChart branchPlaChart = ChartFactory.createHistogram(chartTitle, xAxisLabel, yAxisLabel, branchSeriesPlaDataSet, PlotOrientation.VERTICAL, showLegend, createTooltip, createURL);
            branchPlaChart.getTitle().setFont(new Font("Dialog", 0, 14));
            vertChartPanel = new ChartPanel(branchPlaChart);
            branchSeriesPlaDataSet.removeAllSeries();
            branchSeriesPlaDataSet.addSeries(series1);
            branchSeriesPlaDataSet.addSeries(series2);
            xyplot = (XYPlot)branchPlaChart.getPlot();
            xyplot.setForegroundAlpha(0.85f);
            xybarrenderer = (XYBarRenderer)xyplot.getRenderer();
            xybarrenderer.setBarPainter(new StandardXYBarPainter());
            paintArray = new Paint[]{new Color(-2130967958, true), new Color(-2145915385, true)};
            rangeAxis = new SymbolAxis("Branching Vertices", axisX);
            rangeAxis.setVerticalTickLabels(true);
            xyplot.setDomainAxis(rangeAxis);
            yAxis = (NumberAxis)xyplot.getRangeAxis();
            format = new DecimalFormat("0");
            yAxis.setNumberFormatOverride(format);
            yAxis.setTickUnit(new NumberTickUnit(1.0));
            xyplot.setDrawingSupplier(new DefaultDrawingSupplier(paintArray, DefaultDrawingSupplier.DEFAULT_FILL_PAINT_SEQUENCE, DefaultDrawingSupplier.DEFAULT_OUTLINE_PAINT_SEQUENCE, DefaultDrawingSupplier.DEFAULT_STROKE_SEQUENCE, DefaultDrawingSupplier.DEFAULT_OUTLINE_STROKE_SEQUENCE, DefaultDrawingSupplier.DEFAULT_SHAPE_SEQUENCE));
            this.branchChartPanel.setVisible(true);
            jp.add(vertChartPanel);
        }
        return jp;
    }

    protected static <T> void addTo(ListModel<T> from, DefaultListModel<T> to) {
        for (int index = 0; index < from.getSize(); ++index) {
            to.addElement(from.getElementAt(index));
        }
    }

    static class RowHeaderRenderer
    extends JLabel
    implements ListCellRenderer {
        RowHeaderRenderer(JTable table) {
            JTableHeader header = table.getTableHeader();
            this.setOpaque(true);
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            this.setHorizontalAlignment(0);
            this.setForeground(header.getForeground());
            this.setBackground(header.getBackground());
            this.setFont(header.getFont());
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setText(value == null ? HolmesComparisonModule.LAST_USED_FOLDER : value.toString());
            return this;
        }
    }

    private static class branchingRelation {
        BranchVertex root;
        ArrayList<BranchVertex> list = new ArrayList();

        private branchingRelation(BranchVertex newVertex) {
            this.root = newVertex;
            this.list.add(this.root);
        }

        private int getTi() {
            return (int)this.root.getNumberOfInTransitions();
        }

        private int getTo() {
            return (int)this.root.getNumberOfOutTransitions();
        }

        private int getPi() {
            return (int)this.root.getNumberOfInPlace();
        }

        private int getPo() {
            return (int)this.root.getNumberOfOutPlace();
        }

        public boolean compare(BranchVertex toCompare) {
            boolean result = false;
            if (this.isIso(toCompare)) {
                result = true;
                this.list.add(toCompare);
            }
            return result;
        }

        public boolean isIso(BranchVertex toCompare) {
            return (long)this.getTi() == toCompare.getNumberOfInTransitions() && (long)this.getTo() == toCompare.getNumberOfOutTransitions() && (long)this.getPi() == toCompare.getNumberOfInPlace() && (long)this.getPo() == toCompare.getNumberOfOutPlace();
        }

        public boolean isIncludED(BranchVertex toCompare) {
            return (long)this.getTi() >= toCompare.getNumberOfInTransitions() && (long)this.getTo() >= toCompare.getNumberOfOutTransitions() && (long)this.getPi() >= toCompare.getNumberOfInPlace() && (long)this.getPo() >= toCompare.getNumberOfOutPlace() && ((long)this.getTi() != toCompare.getNumberOfInTransitions() || (long)this.getTo() != toCompare.getNumberOfOutTransitions() || (long)this.getPi() != toCompare.getNumberOfInPlace() || (long)this.getPo() != toCompare.getNumberOfOutPlace());
        }

        public boolean isIncludING(BranchVertex toCompare) {
            return (long)this.getTi() <= toCompare.getNumberOfInTransitions() && (long)this.getTo() <= toCompare.getNumberOfOutTransitions() && (long)this.getPi() <= toCompare.getNumberOfInPlace() && (long)this.getPo() <= toCompare.getNumberOfOutPlace() && ((long)this.getTi() != toCompare.getNumberOfInTransitions() || (long)this.getTo() != toCompare.getNumberOfOutTransitions() || (long)this.getPi() != toCompare.getNumberOfInPlace() || (long)this.getPo() != toCompare.getNumberOfOutPlace());
        }
    }

    private class branchingPairs {
        public branchingRelation net1;
        public branchingRelation net2;
        public branchingRelation type;
        public ArrayList<branchingPairs> larger = new ArrayList();
        public ArrayList<branchingPairs> smaller = new ArrayList();

        private branchingPairs(branchingRelation n1, branchingRelation n2) {
            if (n1 != null) {
                this.type = this.net1 = n1;
            }
            if (n2 != null) {
                this.type = this.net2 = n2;
            }
        }
    }

    static enum ComparisonTypes {
        Invariants,
        Graphlets,
        Orbits,
        Netdiv,
        Branches,
        Gred;

    }
}

