/*
 * Decompiled with CFR 0.152.
 */
package holmes.windows.decompositions;

import holmes.analyse.GraphletsCalculator;
import holmes.analyse.SubnetCalculator;
import holmes.darkgui.GUIManager;
import holmes.files.io.IOprotocols;
import holmes.petrinet.elements.Arc;
import holmes.petrinet.elements.Node;
import holmes.petrinet.elements.PetriNetElement;
import holmes.utilities.ColorPalette;
import holmes.utilities.Tools;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class HolmesBranchVerticesPrototype
extends JFrame {
    private JPanel mainPanel;
    private JPanel logPanel;
    private JPanel inputPanel;
    private JPanel outputPanel;
    private GUIManager overlord;
    private JTextArea resultArea;
    JTextArea minallTA;
    JTextArea maxallTA;
    JTextArea minallTAIN;
    JTextArea maxallTAIN;
    JTextArea minallTAOUT;
    JTextArea maxallTAOUT;
    public ArrayList<BranchStructure> bsl = new ArrayList();

    public HolmesBranchVerticesPrototype() {
        try {
            this.setIconImage(Tools.getImageFromIcon("/icons/holmesicon.png"));
        }
        catch (Exception e) {
            e.getMessage();
            e.printStackTrace();
        }
        this.overlord = GUIManager.getDefaultGUIManager();
        this.setVisible(false);
        this.setTitle("Branching");
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(900, 600));
        this.setLocation(15, 15);
        this.mainPanel = this.createMainPanel();
        this.add((Component)this.mainPanel, "Center");
        GraphletsCalculator.GraphletsCalculator();
    }

    private JPanel createMainPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        this.logPanel = this.createLogPanel(0, 0, 200, 150);
        this.inputPanel = this.createInputPanel(0, 130, 100, 150);
        this.outputPanel = this.createOutputPanel(0, 130, 700, 300);
        panel.add((Component)this.inputPanel, "West");
        panel.add((Component)this.outputPanel, "East");
        panel.repaint();
        return panel;
    }

    private JPanel createLogPanel(int x, int y, int width, int height) {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder("Numbers of degrees"));
        panel.setLocation(x, y);
        panel.setPreferredSize(new Dimension(width, height));
        GridBagConstraints c = new GridBagConstraints();
        JLabel nameDeg = new JLabel("Degree  :  ");
        nameDeg.setLayout(new GridLayout());
        nameDeg.setEnabled(true);
        c.gridx = 0;
        c.gridy = 0;
        panel.add((Component)nameDeg, c);
        JLabel nameV = new JLabel(" Ver. ");
        nameV.setLayout(new GridLayout());
        nameV.setEnabled(true);
        c.gridx = 1;
        c.gridy = 0;
        panel.add((Component)nameV, c);
        JLabel nameT = new JLabel(" Tran. ");
        nameT.setLayout(new GridLayout());
        nameT.setEnabled(true);
        c.gridx = 2;
        c.gridy = 0;
        panel.add((Component)nameT, c);
        JLabel nameP = new JLabel(" Pla. ");
        nameP.setLayout(new GridLayout());
        nameP.setEnabled(true);
        c.gridx = 3;
        c.gridy = 0;
        panel.add((Component)nameP, c);
        int row = 1;
        for (VertCounter group : this.countVerticesDegrees()) {
            JLabel groupDegree = new JLabel(String.valueOf(group.deg));
            groupDegree.setLayout(new GridLayout());
            groupDegree.setEnabled(true);
            c.gridx = 0;
            c.gridy = row;
            panel.add((Component)groupDegree, c);
            JLabel groupValue = new JLabel(String.valueOf(group.t + group.p));
            groupValue.setLayout(new GridLayout());
            groupValue.setEnabled(true);
            c.gridx = 1;
            c.gridy = row;
            panel.add((Component)groupValue, c);
            JLabel groupTValue = new JLabel(String.valueOf(group.t));
            groupTValue.setLayout(new GridLayout());
            groupTValue.setEnabled(true);
            c.gridx = 2;
            c.gridy = row;
            panel.add((Component)groupTValue, c);
            JLabel groupPValue = new JLabel(String.valueOf(group.p));
            groupPValue.setLayout(new GridLayout());
            groupPValue.setEnabled(true);
            c.gridx = 3;
            c.gridy = row++;
            panel.add((Component)groupPValue, c);
        }
        return panel;
    }

    private JPanel createOutputPanel(int x, int y, int width, int height) {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.setBorder(BorderFactory.createTitledBorder("Data"));
        panel.setPreferredSize(new Dimension(width, height));
        this.resultArea = new JTextArea();
        this.resultArea.setText("");
        this.resultArea.setLayout(new BorderLayout());
        panel.add((Component)new JScrollPane(this.resultArea), "Center");
        return panel;
    }

    private JPanel createInputPanel(int x, int y, int width, int height) {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new GridLayout(3, 1));
        mainPanel.setBorder(BorderFactory.createTitledBorder(""));
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder("Restrictions"));
        int posX = 10;
        int posY = 10;
        JPanel buttonPanel = new JPanel(new GridLayout(5, 1));
        JButton calc = new JButton("<html>Find Branching <br />Vertices</html>");
        calc.setLayout(new FlowLayout());
        calc.setEnabled(true);
        calc.setBounds(posX, posY, 70, 70);
        calc.setMargin(new Insets(0, 0, 0, 0));
        calc.setIcon(Tools.getResIcon32("/icons/stateSim/computeData.png"));
        calc.addActionListener(actionEvent -> this.caclBranches(0));
        calc.setFocusPainted(false);
        buttonPanel.add(calc);
        JButton calcT = new JButton("<html>Find Branching <br />Transitions</html>");
        calcT.setLayout(new FlowLayout());
        calcT.setEnabled(true);
        calcT.setBounds(posX, posY + 80, 70, 70);
        calcT.setMargin(new Insets(0, 0, 0, 0));
        calcT.setIcon(Tools.getResIcon32("/icons/stateSim/computeData.png"));
        calcT.addActionListener(actionEvent -> this.caclBranches(1));
        calcT.setFocusPainted(false);
        buttonPanel.add(calcT);
        JButton calcP = new JButton("<html>Find Branching <br />Places</html>");
        calcP.setLayout(new FlowLayout());
        calcP.setEnabled(true);
        calcP.setBounds(posX, posY + 160, 70, 70);
        calcP.setMargin(new Insets(0, 0, 0, 0));
        calcP.setIcon(Tools.getResIcon32("/icons/stateSim/computeData.png"));
        calcP.addActionListener(actionEvent -> this.caclBranches(2));
        calcP.setFocusPainted(false);
        buttonPanel.add(calcP);
        JButton export = new JButton("<html>Export</html>");
        export.setLayout(new FlowLayout());
        export.setEnabled(true);
        export.setBounds(posX, posY + 80, 70, 70);
        export.setMargin(new Insets(0, 0, 0, 0));
        export.setIcon(Tools.getResIcon32("/icons/stateSim/computeData.png"));
        export.addActionListener(actionEvent -> this.exportClick());
        export.setFocusPainted(false);
        buttonPanel.add(export);
        JButton impor = new JButton("<html>Import</html>");
        impor.setLayout(new FlowLayout());
        impor.setEnabled(true);
        impor.setBounds(posX, posY + 80, 70, 70);
        impor.setMargin(new Insets(0, 0, 0, 0));
        impor.setIcon(Tools.getResIcon32("/icons/stateSim/computeData.png"));
        impor.addActionListener(actionEvent -> this.importClick());
        impor.setFocusPainted(false);
        JButton comp = new JButton("<html>Compare</html>");
        comp.setLayout(new FlowLayout());
        comp.setEnabled(true);
        comp.setBounds(posX, posY + 80, 70, 70);
        comp.setMargin(new Insets(0, 0, 0, 0));
        comp.setIcon(Tools.getResIcon32("/icons/stateSim/computeData.png"));
        comp.addActionListener(actionEvent -> this.compareClick());
        comp.setFocusPainted(false);
        buttonPanel.add(comp);
        GridBagConstraints c = new GridBagConstraints();
        JLabel minall = new JLabel("min");
        minall.setLayout(new GridLayout());
        minall.setEnabled(true);
        c.gridx = 0;
        c.gridy = 0;
        panel.add((Component)minall, c);
        this.minallTA = new JTextArea(1, 5);
        this.minallTA.setLayout(new GridLayout());
        this.minallTA.setEnabled(true);
        c.gridx = 1;
        c.gridy = 0;
        panel.add((Component)this.minallTA, c);
        JLabel maxall = new JLabel("max");
        maxall.setLayout(new GridLayout());
        maxall.setEnabled(true);
        c.gridx = 0;
        c.gridy = 1;
        panel.add((Component)maxall, c);
        this.maxallTA = new JTextArea(1, 5);
        this.maxallTA.setLayout(new GridLayout());
        this.maxallTA.setEnabled(true);
        c.gridx = 1;
        c.gridy = 1;
        panel.add((Component)this.maxallTA, c);
        JLabel minallIN = new JLabel("min in");
        minallIN.setLayout(new GridLayout());
        minallIN.setEnabled(true);
        c.gridx = 0;
        c.gridy = 2;
        panel.add((Component)minallIN, c);
        this.minallTAIN = new JTextArea(1, 5);
        this.minallTAIN.setLayout(new GridLayout());
        this.minallTAIN.setEnabled(true);
        c.gridx = 1;
        c.gridy = 2;
        panel.add((Component)this.minallTAIN, c);
        JLabel maxallIN = new JLabel("max in");
        maxallIN.setLayout(new GridLayout());
        maxallIN.setEnabled(true);
        c.gridx = 0;
        c.gridy = 3;
        panel.add((Component)maxallIN, c);
        this.maxallTAIN = new JTextArea(1, 5);
        this.maxallTAIN.setLayout(new GridLayout());
        this.maxallTAIN.setEnabled(true);
        c.gridx = 1;
        c.gridy = 3;
        panel.add((Component)this.maxallTAIN, c);
        JLabel minallOUT = new JLabel("min out");
        minallOUT.setLayout(new GridLayout());
        minallOUT.setEnabled(true);
        c.gridx = 0;
        c.gridy = 4;
        panel.add((Component)minallOUT, c);
        this.minallTAOUT = new JTextArea(1, 5);
        this.minallTAOUT.setLayout(new GridLayout());
        this.minallTAOUT.setEnabled(true);
        c.gridx = 1;
        c.gridy = 4;
        panel.add((Component)this.minallTAOUT, c);
        JLabel maxallOUT = new JLabel("max out");
        maxallOUT.setLayout(new GridLayout());
        maxallOUT.setEnabled(true);
        c.gridx = 0;
        c.gridy = 5;
        panel.add((Component)maxallOUT, c);
        this.maxallTAOUT = new JTextArea(1, 5);
        this.maxallTAOUT.setLayout(new GridLayout());
        this.maxallTAOUT.setEnabled(true);
        c.gridx = 1;
        c.gridy = 5;
        panel.add((Component)this.maxallTAOUT, c);
        mainPanel.add((Component)buttonPanel, "North");
        mainPanel.add((Component)panel, "Center");
        mainPanel.add((Component)this.logPanel, "South");
        return mainPanel;
    }

    private void exportClick() {
        IOprotocols io = new IOprotocols();
        this.calcBase();
        io.exportBranchVertices(this.bsl);
    }

    private void importClick() {
        IOprotocols io = new IOprotocols();
        this.calcBase();
        try {
            JFileChooser fc = new JFileChooser();
            int returnVal = fc.showOpenDialog(this);
            if (returnVal == 0) {
                File file = fc.getSelectedFile();
                String path = file.getAbsolutePath();
                this.bsl = io.importBranchVertices(path);
            }
        }
        catch (Exception e) {
            System.out.println("Problem serializing: " + e);
        }
    }

    private void compareClick() {
        GUIManager.getDefaultGUIManager().createComparisonnWindow();
        GUIManager.getDefaultGUIManager().showCompWindow();
    }

    private void calcBase() {
        for (Node n : this.overlord.getWorkspace().getProject().getNodes()) {
            if (n.getOutNodes().size() <= 1 && n.getInNodes().size() <= 1) continue;
            BranchStructure bs = new BranchStructure(n, new Color(0, 0, 0));
            this.bsl.add(bs);
        }
    }

    private void calcTypeI() {
        this.calcBase();
        for (BranchStructure bs : this.bsl) {
            bs.root.getType();
        }
    }

    private void calcTypeII() {
    }

    private void calcTypeIII() {
    }

    private void calcTypeIV() {
    }

    private void caclBranches(int type) {
        int tmp;
        this.clearLayers();
        this.bsl.clear();
        this.resultArea.selectAll();
        this.resultArea.replaceSelection("");
        this.clearColors();
        ColorPalette cp = new ColorPalette();
        int minimalValue = -1;
        int maximalValue = Integer.MAX_VALUE;
        int minimaInlValue = -1;
        int maximaInlValue = Integer.MAX_VALUE;
        int minimalOutValue = -1;
        int maximalOutValue = Integer.MAX_VALUE;
        if (!this.minallTA.getText().isEmpty() && (tmp = Integer.parseInt(this.minallTA.getText())) != 0) {
            minimalValue = tmp;
        }
        if (!this.maxallTA.getText().isEmpty() && (tmp = Integer.parseInt(this.maxallTA.getText())) != 0) {
            maximalValue = tmp;
        }
        if (!this.minallTAIN.getText().isEmpty() && (tmp = Integer.parseInt(this.minallTAIN.getText())) != 0) {
            minimaInlValue = tmp;
        }
        if (!this.maxallTAIN.getText().isEmpty() && (tmp = Integer.parseInt(this.maxallTAIN.getText())) != 0) {
            maximaInlValue = tmp;
        }
        if (!this.minallTAOUT.getText().isEmpty() && (tmp = Integer.parseInt(this.minallTAOUT.getText())) != 0) {
            minimalOutValue = tmp;
        }
        if (!this.maxallTAOUT.getText().isEmpty() && (tmp = Integer.parseInt(this.maxallTAOUT.getText())) != 0) {
            maximalOutValue = tmp;
        }
        block4: for (Node n : this.overlord.getWorkspace().getProject().getNodes()) {
            BranchStructure bs;
            switch (type) {
                case 1: {
                    if (!n.getType().equals((Object)PetriNetElement.PetriNetElementType.TRANSITION) || n.getOutNodes().size() <= 1 && n.getInNodes().size() <= 1 || n.getOutNodes().size() + n.getInNodes().size() < minimalValue || n.getOutNodes().size() + n.getInNodes().size() > maximalValue || (n.getInNodes().size() < minimaInlValue || n.getInNodes().size() > maximaInlValue) && (n.getOutNodes().size() < minimalOutValue || n.getOutNodes().size() > maximalOutValue)) continue block4;
                    bs = new BranchStructure(n, cp.getColor());
                    this.bsl.add(bs);
                    continue block4;
                }
                case 2: {
                    if (!n.getType().equals((Object)PetriNetElement.PetriNetElementType.PLACE) || n.getOutNodes().size() <= 1 && n.getInNodes().size() <= 1 || n.getOutNodes().size() + n.getInNodes().size() < minimalValue || n.getOutNodes().size() + n.getInNodes().size() > maximalValue || !((n.getInNodes().size() >= minimaInlValue && n.getInNodes().size() <= maximaInlValue) | (n.getOutNodes().size() >= minimalOutValue && n.getOutNodes().size() <= maximalOutValue))) continue block4;
                    bs = new BranchStructure(n, cp.getColor());
                    this.bsl.add(bs);
                    continue block4;
                }
            }
            if (n.getOutNodes().size() <= 1 && n.getInNodes().size() <= 1 || n.getOutNodes().size() + n.getInNodes().size() < minimalValue || n.getOutNodes().size() + n.getInNodes().size() > maximalValue || n.getInNodes().size() < minimaInlValue || n.getInNodes().size() > maximaInlValue || n.getOutNodes().size() < minimalOutValue || n.getOutNodes().size() > maximalOutValue) continue;
            bs = new BranchStructure(n, cp.getColor());
            this.bsl.add(bs);
        }
        StringBuilder resultString = new StringBuilder();
        for (int i = 0; i < this.bsl.size(); ++i) {
            Node root = this.bsl.get((int)i).root;
            resultString.append(i).append(") ").append((Object)root.getType()).append(": ").append(root.getName()).append("\n\r");
            for (Node n : this.bsl.get((int)i).borderNodes) {
                String direction = "";
                if (this.bsl.get((int)i).paths.stream().anyMatch(path -> path.endNode.equals(n) && !path.isRevers)) {
                    direction = " --> ";
                }
                if (this.bsl.get((int)i).paths.stream().anyMatch(path -> path.endNode.equals(n) && path.isRevers)) {
                    direction = " <-- ";
                }
                if (this.bsl.get((int)i).paths.stream().anyMatch(path -> path.endNode.equals(n) && !path.isRevers) && this.bsl.get((int)i).paths.stream().anyMatch(path -> path.endNode.equals(n) && path.isRevers)) {
                    direction = " <-> ";
                }
                if (n.getType().equals((Object)PetriNetElement.PetriNetElementType.TRANSITION)) {
                    resultString.append("\t ").append(direction).append(" T: <").append(n.getInNodes().size()).append(" | ").append(n.getOutNodes().size()).append("> ").append(n.getName()).append("\n\r");
                    continue;
                }
                resultString.append("\t ").append(direction).append(" P: <").append(n.getInNodes().size()).append(" | ").append(n.getOutNodes().size()).append("> ").append(n.getName()).append("\n\r");
            }
        }
        int transitionNumberIn = 0;
        int transitionNumberOut = 0;
        int placeNumberIn = 0;
        int placeNumberOut = 0;
        int transitionNumberInWeight = 0;
        int transitionNumberOutWeight = 0;
        int placeNumberInWeight = 0;
        int placeNumberOutWeight = 0;
        for (Node n : this.overlord.getWorkspace().getProject().getNodes()) {
            if (n.getInArcs().size() <= 1 && n.getOutArcs().size() <= 1) continue;
            if (n.getType().equals((Object)PetriNetElement.PetriNetElementType.TRANSITION)) {
                transitionNumberIn += n.getInArcs().size();
                transitionNumberInWeight += n.getInArcs().stream().mapToInt(Arc::getWeight).sum();
                transitionNumberOut += n.getInArcs().size();
                transitionNumberOutWeight += n.getInArcs().stream().mapToInt(Arc::getWeight).sum();
                continue;
            }
            placeNumberIn += n.getInArcs().size();
            placeNumberInWeight += n.getInArcs().stream().mapToInt(Arc::getWeight).sum();
            placeNumberOut += n.getInArcs().size();
            placeNumberOutWeight += n.getInArcs().stream().mapToInt(Arc::getWeight).sum();
        }
        this.resultArea.setText(resultString.toString());
        this.overlord.reset.clearGraphColors();
    }

    private void clearLayers() {
        for (BranchStructure bs : this.bsl) {
            bs.root.branchColor = Color.LIGHT_GRAY;
            for (Node n : bs.borderNodes) {
                n.branchColor = null;
            }
            for (Arc a : this.calculateInternalArcs(bs.paths)) {
                a.arcDecoBox.layers.clear();
            }
        }
        this.overlord.getWorkspace().repaintAllGraphPanels();
    }

    private ArrayList<Arc> calculateInternalArcs(ArrayList<SubnetCalculator.Path> pathList) {
        ArrayList<Arc> listOfAllArcs = new ArrayList<Arc>();
        for (SubnetCalculator.Path path : pathList) {
            for (int i = 0; i < path.path.size() - 1; ++i) {
                Node startNode = path.path.get(i);
                Node endNode = path.path.get(i + 1);
                for (Arc arc : startNode.getOutArcs()) {
                    if (arc.getEndNode().getID() != endNode.getID()) continue;
                    listOfAllArcs.add(arc);
                }
            }
            for (Arc arc : path.endNode.getOutArcs()) {
                if (arc.getEndNode().getID() != path.startNode.getID()) continue;
                listOfAllArcs.add(arc);
            }
        }
        return listOfAllArcs;
    }

    private ArrayList<VertCounter> countVerticesDegrees() {
        ArrayList nodes = new ArrayList();
        ArrayList<VertCounter> counters = new ArrayList<VertCounter>();
        for (Node n : this.overlord.getWorkspace().getProject().getNodes()) {
            Integer degree = n.getInNodes().size() + n.getOutNodes().size();
            if (counters.stream().anyMatch(x -> x.deg.equals(degree))) {
                for (VertCounter vc : counters) {
                    if (!vc.deg.equals(degree)) continue;
                    if (n.getType().equals((Object)PetriNetElement.PetriNetElementType.TRANSITION)) {
                        ++vc.t;
                        continue;
                    }
                    ++vc.p;
                }
                continue;
            }
            VertCounter newDeg = new VertCounter(degree);
            if (n.getType().equals((Object)PetriNetElement.PetriNetElementType.TRANSITION)) {
                ++newDeg.t;
            } else {
                ++newDeg.p;
            }
            counters.add(newDeg);
        }
        counters.sort(new DegSort());
        return counters;
    }

    private void clearColors() {
        for (Arc a : this.overlord.getWorkspace().getProject().getArcs()) {
            a.arcDecoBox.layers.clear();
        }
        for (Node n : this.overlord.getWorkspace().getProject().getNodes()) {
            n.branchBorderColors = new ArrayList();
            n.branchColor = null;
        }
    }

    private class VertCounter {
        public Integer deg;
        public int t;
        public int p;

        VertCounter(int degree) {
            this.deg = degree;
            this.t = 0;
            this.p = 0;
        }

        public Integer getDeg() {
            return this.deg;
        }
    }

    public static class BranchStructure
    implements Serializable {
        Node root;
        ArrayList<Node> borderNodes;
        public ArrayList<SubnetCalculator.Path> paths;
        Color branchColor;

        public BranchStructure(Node r, ArrayList<Node> bn, ArrayList<SubnetCalculator.Path> p, Color c) {
            this.root = r;
            this.borderNodes = bn;
            this.branchColor = c;
            this.paths = p;
        }

        public BranchStructure(Node r, Color c) {
            this.root = r;
            this.branchColor = c;
            this.root.branchColor = c;
            this.paths = new ArrayList();
            this.borderNodes = new ArrayList();
            this.calcPaths();
            this.calcBorders(true);
            this.setElemetsColor();
        }

        public BranchStructure(Node r) {
            this.root = r;
            this.paths = new ArrayList();
            this.borderNodes = new ArrayList();
            this.calcPaths();
            this.calcBorders(false);
        }

        private void calcPaths() {
            ArrayList<Node> nodes;
            ArrayList<Node> startPath;
            for (Node m : this.root.getOutNodes()) {
                startPath = new ArrayList<Node>();
                startPath.add(this.root);
                nodes = this.calculatePath(m, startPath);
                if (nodes.get(nodes.size() - 1).getOutNodes().contains(nodes.get(0))) {
                    this.paths.add(new SubnetCalculator.Path(nodes.get(0), nodes.get(nodes.size() - 1), new ArrayList<Node>(nodes), true, false));
                    continue;
                }
                this.paths.add(new SubnetCalculator.Path(nodes.get(0), nodes.get(nodes.size() - 1), new ArrayList<Node>(nodes), false, false));
            }
            for (Node m : this.root.getInNodes()) {
                startPath = new ArrayList();
                startPath.add(this.root);
                nodes = this.calculatePathRevers(m, startPath);
                if (nodes.get(nodes.size() - 1).getInNodes().contains(nodes.get(0))) {
                    this.paths.add(new SubnetCalculator.Path(nodes.get(0), nodes.get(nodes.size() - 1), new ArrayList<Node>(nodes), true, true));
                    continue;
                }
                this.paths.add(new SubnetCalculator.Path(nodes.get(0), nodes.get(nodes.size() - 1), new ArrayList<Node>(nodes), false, true));
            }
        }

        private void setElemetsColor() {
            for (SubnetCalculator.Path p : this.paths) {
                for (int i = 0; i < p.path.size() - 1; ++i) {
                    for (Arc a : p.path.get(i).getOutArcs()) {
                        if (a.getEndNode().getID() != p.path.get(i + 1).getID()) continue;
                        a.arcDecoBox.layers.add(this.branchColor);
                    }
                    for (Arc a : p.path.get(i).getInArcs()) {
                        if (a.getStartNode().getID() != p.path.get(i + 1).getID()) continue;
                        a.arcDecoBox.layers.add(this.branchColor);
                    }
                }
            }
        }

        private void calcBorders(boolean isNotDeco) {
            for (SubnetCalculator.Path p : this.paths) {
                if (p.startNode.getID() == this.root.getID()) {
                    this.borderNodes.add(p.endNode);
                    continue;
                }
                this.borderNodes.add(p.startNode);
            }
            if (isNotDeco) {
                for (Node n : this.borderNodes) {
                    n.branchBorderColors.add(this.branchColor);
                }
            }
        }

        private ArrayList<Node> calculatePath(Node m, ArrayList<Node> path) {
            if (path.contains(m)) {
                return path;
            }
            path.add(m);
            if ((m.getOutNodes().size() < 2 || m.getInNodes().size() < 2) && m.getOutNodes().size() == 1 && m.getInNodes().size() == 1) {
                this.calculatePath(m.getOutNodes().get(0), path);
            }
            return path;
        }

        private ArrayList<Node> calculatePathRevers(Node m, ArrayList<Node> path) {
            if (path.contains(m)) {
                return path;
            }
            path.add(m);
            if ((m.getOutNodes().size() < 2 || m.getInNodes().size() < 2) && m.getInNodes().size() == 1 && m.getOutNodes().size() == 1) {
                this.calculatePathRevers(m.getInNodes().get(0), path);
            }
            return path;
        }
    }

    public class DegSort
    implements Comparator<VertCounter> {
        @Override
        public int compare(VertCounter o1, VertCounter o2) {
            return o1.getDeg().compareTo(o2.getDeg());
        }
    }

    public static class BranchStructureList
    implements Serializable {
        public ArrayList<BranchStructure> bsl;

        public BranchStructureList(ArrayList<BranchStructure> b) {
            this.bsl = b;
        }
    }
}

