/*
 * Decompiled with CFR 0.152.
 */
package holmes.windows.clusters;

import holmes.clusters.Clustering;
import holmes.clusters.ClusteringInfoMatrix;
import holmes.darkgui.GUIManager;
import holmes.files.clusters.CHmetricReader;
import holmes.files.clusters.ClusterReader;
import holmes.files.clusters.RClusteringParserToXLS;
import holmes.utilities.Tools;
import holmes.windows.clusters.HolmesClusterConfig;
import holmes.windows.clusters.HolmesClusterSubWindow;
import holmes.workspace.ExtensionFileFilter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.SpinnerNumberModel;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;

public class HolmesClusters
extends JFrame {
    private static final long serialVersionUID = -8420712475473581772L;
    private JTable table = new JTable();
    private DefaultTableModel tableModel;
    private int mode = 0;
    private ClusterTableRenderer tableRenderer = new ClusterTableRenderer(this.mode, 18);
    private JScrollPane scrollTablePane;
    private int subRowsSize = 0;
    private final HolmesClusters myself = this;
    private int clustersToGenerate;
    private ClusteringInfoMatrix dataTableCase56 = null;
    private String pathCSVfile = "";
    private String pathClustersDir = "";
    private ArrayList<String> commandsValidate;
    private HolmesClusterConfig minion;

    public HolmesClusters() {
        this.myself.setTitle("Cluster Analyzer");
        try {
            this.setIconImage(Tools.getImageFromIcon("/icons/holmesicon.png"));
        }
        catch (Exception ex) {
            GUIManager.getDefaultGUIManager().log("Error (390036959) | Exception:  " + ex.getMessage(), "error", true);
        }
        this.setVisible(false);
        this.clustersToGenerate = 20;
        this.initiateListeners();
        this.setDefaultCloseOperation(1);
        this.setLocation(20, 20);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setMinimumSize(new Dimension(1000, screenSize.height - 100));
        this.setMaximumSize(new Dimension(1000, screenSize.height - 100));
        this.setResizable(false);
        JPanel mainPanel = new JPanel();
        mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        mainPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 23;
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.1;
        gbc.weighty = 1.0;
        JPanel tablePanel = this.mode == 0 ? this.createTablePanelCase56() : new JPanel();
        tablePanel.setOpaque(true);
        mainPanel.add((Component)tablePanel, gbc);
        JPanel textPanel = this.createButtonsPanelCase56();
        gbc.gridx = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        mainPanel.add((Component)textPanel, gbc);
        this.commandsValidate = new ArrayList();
        this.commandsAddAll();
        this.setContentPane(mainPanel);
        this.pack();
        this.minion = new HolmesClusterConfig(this.commandsValidate, this.myself);
    }

    private JPanel createButtonsPanelCase56() {
        JPanel textPanel = new JPanel();
        textPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        textPanel.setLayout(new BoxLayout(textPanel, 1));
        JLabel clLabel = new JLabel("Generate clusters:");
        clLabel.setFont(new Font("Arial", 1, 11));
        clLabel.setAlignmentX(0.5f);
        textPanel.add(clLabel);
        SpinnerNumberModel spinnerClustersModel = new SpinnerNumberModel(20, 2, 300, 1);
        this.clustersToGenerate = 20;
        JSpinner spinnerClusters = new JSpinner(spinnerClustersModel);
        spinnerClusters.setPreferredSize(new Dimension(100, 30));
        spinnerClusters.setMinimumSize(new Dimension(100, 30));
        spinnerClusters.setMaximumSize(new Dimension(100, 30));
        spinnerClusters.addChangeListener(e -> {
            JSpinner spinner = (JSpinner)e.getSource();
            this.clustersToGenerate = (Integer)spinner.getValue();
        });
        spinnerClusters.setAlignmentX(0.5f);
        textPanel.add(spinnerClusters);
        JButton generateButton = this.createStandardButton("", Tools.getResIcon48("/icons/clustWindow/buttonGen56.png"));
        generateButton.setToolTipText("Generate all 56 clusterings for a selected number of clusters.");
        generateButton.addActionListener(actionEvent -> this.buttonGenerateClusterings(this.commandsValidate));
        generateButton.setAlignmentX(0.5f);
        textPanel.add(generateButton);
        textPanel.add(Box.createVerticalStrut(7));
        JButton generateCHButton = this.createStandardButton("", Tools.getResIcon48("/icons/clustWindow/buttonComputeCH.png"));
        generateCHButton.setToolTipText("Compute Cali\u0144ski-Harabasz metrics for a given number of clusters.");
        generateCHButton.addActionListener(actionEvent -> this.buttonComputeCHmetrics(this.commandsValidate));
        generateCHButton.setAlignmentX(0.5f);
        textPanel.add(generateCHButton);
        textPanel.add(Box.createVerticalStrut(7));
        JButton case56Button = this.createStandardButton("", Tools.getResIcon48("/icons/clustWindow/buttonLoadClusterDir.png"));
        case56Button.setToolTipText("Load 56 clusterings into table from the selected directory.");
        case56Button.addActionListener(actionEvent -> this.buttonLoadClusteringDirectory());
        case56Button.setAlignmentX(0.5f);
        textPanel.add(case56Button);
        textPanel.add(Box.createVerticalStrut(7));
        JButton loadCHButton = this.createStandardButton("", Tools.getResIcon48("/icons/clustWindow/buttonLoadCHDir.png"));
        loadCHButton.setToolTipText("Load Cali\u0144ski-Harabasz metrics from the selected directory.");
        loadCHButton.addActionListener(actionEvent -> this.buttonLoadCHmetricIntoTables());
        loadCHButton.setAlignmentX(0.5f);
        textPanel.add(loadCHButton);
        textPanel.add(Box.createVerticalStrut(7));
        JButton saveTableButton = this.createStandardButton("", Tools.getResIcon48("/icons/clustWindow/buttonSaveTable.png"));
        saveTableButton.setToolTipText("Save table data into the selected file");
        saveTableButton.addActionListener(actionEvent -> this.buttonSerializeDataTable());
        saveTableButton.setAlignmentX(0.5f);
        textPanel.add(saveTableButton);
        textPanel.add(Box.createVerticalStrut(7));
        JButton loadTableButton = this.createStandardButton("", Tools.getResIcon48("/icons/clustWindow/buttonLoadTable.png"));
        loadTableButton.setToolTipText("Load table data from the selected file");
        loadTableButton.addActionListener(actionEvent -> this.buttonDeserializeFile());
        loadTableButton.setAlignmentX(0.5f);
        textPanel.add(loadTableButton);
        textPanel.add(Box.createVerticalStrut(7));
        JButton excelExport = this.createStandardButton("", Tools.getResIcon48("/icons/clustWindow/buttonExportToExcel.png"));
        excelExport.setToolTipText("Export results files into Excel document.");
        excelExport.addActionListener(actionEvent -> this.buttonExportTableToExcel());
        excelExport.setAlignmentX(0.5f);
        textPanel.add(excelExport);
        textPanel.add(Box.createVerticalStrut(7));
        JButton configButton = this.createStandardButton("", Tools.getResIcon48("/icons/clustWindow/buttonConfig.png"));
        configButton.setToolTipText("R scripts run configurations");
        configButton.addActionListener(actionEvent -> this.minion.setVisible(true));
        configButton.setAlignmentX(0.5f);
        textPanel.add(configButton);
        textPanel.add(Box.createVerticalStrut(7));
        return textPanel;
    }

    private JButton createStandardButton(String text, Icon icon) {
        JButton resultButton = new JButton();
        resultButton.setLayout(new BorderLayout());
        JLabel tmp = new JLabel(text);
        tmp.setFont(new Font("Arial", 0, 8));
        resultButton.add((Component)tmp, "Last");
        resultButton.setPreferredSize(new Dimension(100, 60));
        resultButton.setMinimumSize(new Dimension(100, 60));
        resultButton.setMaximumSize(new Dimension(100, 60));
        resultButton.setIcon(icon);
        return resultButton;
    }

    public HolmesClusters(int mode) {
        this();
        this.mode = mode;
    }

    public void setClusterPath(String path) {
        this.pathClustersDir = path;
    }

    public String getClusterPath() {
        return this.pathClustersDir;
    }

    private JPanel createTablePanelCase56() {
        JPanel main = new JPanel();
        main.setLayout(new BorderLayout());
        this.setTableModel56();
        this.table.setDefaultRenderer(Object.class, this.tableRenderer);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 1) {
                    JTable target = (JTable)e.getSource();
                    int row = target.getSelectedRow();
                    int column = target.getSelectedColumn();
                    HolmesClusters.this.cellClickedEvent(row, column);
                }
            }
        });
        this.scrollTablePane = new JScrollPane(this.table);
        main.add(this.scrollTablePane);
        return main;
    }

    private void setTableModel56() {
        this.tableModel = new DefaultTableModel();
        this.tableModel.addColumn("Column1");
        this.tableModel.addColumn("Column2");
        this.tableModel.addColumn("Column3");
        this.tableModel.addColumn("Column4");
        this.tableModel.addColumn("Column5");
        this.tableModel.addColumn("Column6");
        this.tableModel.addColumn("Column7");
        this.tableModel.addColumn("Column8");
        this.tableModel.addColumn("Column9");
        this.tableModel.addColumn("Column10");
        this.tableModel.addColumn("Column11");
        this.tableModel.addColumn("Column12");
        this.tableModel.addColumn("Column13");
        this.tableModel.addColumn("Column14");
        this.tableModel.addColumn("Column15");
        this.tableModel.addColumn("Column16");
        this.tableModel.addColumn("Column17");
        this.tableModel.addColumn("Column18");
        this.tableModel.addColumn("Column19");
        this.tableModel.addColumn("Column20");
        this.tableModel.addColumn("Column21");
        this.tableModel.addColumn("Column22");
        this.table.setModel(this.tableModel);
        this.table.getColumnModel().getColumn(0).setHeaderValue("Metric:");
        this.table.getColumnModel().getColumn(1).setHeaderValue("");
        this.table.getColumnModel().getColumn(2).setHeaderValue("UPGMA");
        this.table.getColumnModel().getColumn(3).setHeaderValue("");
        this.table.getColumnModel().getColumn(4).setHeaderValue("");
        this.table.getColumnModel().getColumn(5).setHeaderValue("Centroid");
        this.table.getColumnModel().getColumn(6).setHeaderValue("");
        this.table.getColumnModel().getColumn(7).setHeaderValue("");
        this.table.getColumnModel().getColumn(8).setHeaderValue("Complete");
        this.table.getColumnModel().getColumn(9).setHeaderValue("");
        this.table.getColumnModel().getColumn(10).setHeaderValue("");
        this.table.getColumnModel().getColumn(11).setHeaderValue("McQuitty");
        this.table.getColumnModel().getColumn(12).setHeaderValue("");
        this.table.getColumnModel().getColumn(13).setHeaderValue("");
        this.table.getColumnModel().getColumn(14).setHeaderValue("Median");
        this.table.getColumnModel().getColumn(15).setHeaderValue("");
        this.table.getColumnModel().getColumn(16).setHeaderValue("");
        this.table.getColumnModel().getColumn(17).setHeaderValue("Single");
        this.table.getColumnModel().getColumn(18).setHeaderValue("");
        this.table.getColumnModel().getColumn(19).setHeaderValue("");
        this.table.getColumnModel().getColumn(20).setHeaderValue("Ward");
        this.table.getColumnModel().getColumn(21).setHeaderValue("");
        this.table.setFillsViewportHeight(true);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(80);
        for (int index = 1; index < this.table.getColumnCount(); ++index) {
            if ((index + 2) % 3 != 0) continue;
            this.table.getColumnModel().getColumn(index).setPreferredWidth(20);
            this.table.getColumnModel().getColumn(index + 1).setPreferredWidth(50);
            this.table.getColumnModel().getColumn(index + 2).setPreferredWidth(50);
            ++index;
            ++index;
        }
    }

    private void cellClickedEvent(int row, int column) {
        int sub = this.subRowsSize;
        if (column != 0 && row % (sub + 1) != 0) {
            try {
                int clusterNumber = Integer.parseInt(this.table.getModel().getValueAt(row, 0).toString());
                int algID = (column - 1) / 3;
                int headerRowNumber = row - (clusterNumber - 1);
                Clustering omg = this.dataTableCase56.getClustering((headerRowNumber /= this.subRowsSize + 1) * 7 + algID, clusterNumber - 2);
                new HolmesClusterSubWindow(this.myself, omg, 1);
            }
            catch (Exception ex) {
                GUIManager.getDefaultGUIManager().log("Critical error when recounting clicked cell.", "error", true);
            }
        }
    }

    public void registerDataCase56(ClusteringInfoMatrix newTable) {
        if (newTable == null) {
            return;
        }
        this.dataTableCase56 = newTable;
        this.subRowsSize = newTable.secondaryTablesMinNumber;
        int checkSize = newTable.mainTablesNumber;
        if (checkSize != 56) {
            GUIManager.getDefaultGUIManager().log("Invalid number of subtables. Operation terminated.", "error", true);
            return;
        }
        GUIManager.getDefaultGUIManager().log("Clearing old clusterings data table", "text", true);
        this.tableRenderer.setMode(this.mode);
        this.tableRenderer.setSubRows(this.subRowsSize);
        this.setTableModel56();
        String[] metricName = new String[]{"Correlation", "Pearson", "Binary", "Canberra", "Euclidean", "Manhattan", "Maximum", "Minkowski"};
        for (int metric = 0; metric < 8; ++metric) {
            Object[] data = new String[]{metricName[metric], "0:", "MSS", "C-H", "0:", "MSS", "C-H", "0:", "MSS", "C-H", "0:", "MSS", "C-H", "0:", "MSS", "C-H", "0:", "MSS", "C-H", "0:", "MSS", "C-H"};
            this.tableModel.addRow(data);
            for (int rows = 0; rows < this.subRowsSize; ++rows) {
                Object[] dataRow = new String[]{"", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""};
                dataRow[0] = "" + (rows + 2);
                for (int alg = 0; alg < 7; ++alg) {
                    int tableIndex = metric * 7 + alg;
                    dataRow[1 + alg * 3] = "" + this.dataTableCase56.getMatrix().get((int)tableIndex).get((int)rows).zeroClusters;
                    double val = this.dataTableCase56.getMatrix().get((int)tableIndex).get((int)rows).evalMSS;
                    String cuttedValue = this.cutValueMSS(val);
                    dataRow[1 + alg * 3 + 1] = cuttedValue;
                    double val2 = this.dataTableCase56.getMatrix().get((int)tableIndex).get((int)rows).evalCH;
                    String cuttedValue2 = this.cutValueCH(val2);
                    dataRow[1 + alg * 3 + 2] = cuttedValue2;
                }
                this.tableModel.addRow(dataRow);
            }
        }
        GUIManager.getDefaultGUIManager().log("New clustering data table has been successfully read.", "text", true);
        this.tableModel.fireTableDataChanged();
        this.table.revalidate();
        this.scrollTablePane.repaint();
    }

    private String cutValueMSS(double evalMSS) {
        DecimalFormatSymbols otherSymbols = new DecimalFormatSymbols(this.getLocale());
        otherSymbols.setDecimalSeparator('.');
        DecimalFormat df = new DecimalFormat("#.####", otherSymbols);
        return df.format(evalMSS);
    }

    private String cutValueCH(double evalCH) {
        DecimalFormatSymbols otherSymbols = new DecimalFormatSymbols(this.getLocale());
        otherSymbols.setDecimalSeparator('.');
        DecimalFormat df = new DecimalFormat("#.#", otherSymbols);
        return df.format(evalCH);
    }

    public Color getColor(double power) {
        double R = 255.0 * power / 100.0;
        double G = 255.0 * (100.0 - power) / 100.0;
        try {
            return new Color((int)R, (int)G, 0);
        }
        catch (Exception e) {
            return Color.white;
        }
    }

    private void buttonGenerateClusterings(ArrayList<String> commandsValidate) {
        if (this.clustersToGenerate > 1) {
            this.pathCSVfile = GUIManager.getDefaultGUIManager().io.generateClustersCase56(this.clustersToGenerate, commandsValidate);
            if (this.pathCSVfile == null) {
                this.pathCSVfile = "";
            } else {
                JOptionPane.showMessageDialog(null, "Clustering procedure for all cases initiated. This make take so time to finish.", "R computation initiated", 1);
            }
        }
    }

    private void buttonLoadClusteringDirectory() {
        String lastPath = GUIManager.getDefaultGUIManager().getLastPath();
        String choosenDir = Tools.selectDirectoryDialog(lastPath, "Select cluster dir", "Directory with 56 generated text R-clusters files.");
        if (choosenDir.equals("")) {
            return;
        }
        ClusteringInfoMatrix clusterMatrix = new ClusteringInfoMatrix();
        int result = clusterMatrix.readDataDirectory(choosenDir);
        if (result == -1) {
            JOptionPane.showMessageDialog(null, "Cluster reading failed. Possible wrong directory chosen.", "Error", 0);
        } else {
            this.registerDataCase56(clusterMatrix);
            this.setClusterPath(choosenDir);
        }
        this.pathCSVfile = choosenDir + "/cluster.csv";
        if (!Tools.ifExist(this.pathCSVfile)) {
            String msg = "Selected directory does not contain cluster.csv file. Further calculations may not be possible.";
            JOptionPane.showMessageDialog(null, "msg", "warning", 0);
            GUIManager.getDefaultGUIManager().log(msg, "warning", true);
        }
    }

    private void buttonExportTableToExcel() {
        try {
            String lastPath = GUIManager.getDefaultGUIManager().getLastPath();
            GUIManager.getDefaultGUIManager().log("Attempting to export cluster table to excel", "text", true);
            String dirPath = Tools.selectDirectoryDialog(lastPath, "Select cluster dir", "Directory with 56 generated R-clusters text files.");
            if (dirPath.equals("")) {
                return;
            }
            ClusterReader cr = new ClusterReader();
            if (cr.checkFiles(dirPath) == -2) {
                JOptionPane.showMessageDialog(null, "Directory does not contain a single cluster file.", "Error", 0);
                GUIManager.getDefaultGUIManager().log("Directory: " + dirPath + "does not contain even a single cluster file.", "error", true);
            }
            RClusteringParserToXLS r = new RClusteringParserToXLS();
            r.extractAllRClusteringToXLS(dirPath, dirPath + "//ClustersSummary.xls");
            File test = new File(dirPath + "//ClustersSummary.xls");
            if (test.exists()) {
                FileFilter[] filter = new FileFilter[]{new ExtensionFileFilter(".xls - Excel 2003", new String[]{"XLS"})};
                Object newLocation = Tools.selectFileDialog(dirPath, filter, "Save", "", "");
                if (((String)newLocation).equals("")) {
                    GUIManager.getDefaultGUIManager().log("Exporting table succeed. Created file: " + dirPath + "//ClustersSummary.xls", "text", true);
                } else {
                    if (!((String)newLocation).contains(".xls")) {
                        newLocation = (String)newLocation + ".xls";
                    }
                    Tools.copyFileByPath(dirPath + "//ClustersSummary.xls", (String)newLocation);
                    test.delete();
                    GUIManager.getDefaultGUIManager().log("Exporting table succeed. Created file: " + (String)newLocation, "text", true);
                }
            } else {
                String msg = "Unknown error, excel file does not exist.";
                GUIManager.getDefaultGUIManager().log(msg, "error", true);
            }
        }
        catch (Exception e) {
            String msg = "Excel export procedure failed for directory: " + this.getClusterPath();
            GUIManager.getDefaultGUIManager().log(msg, "error", true);
            GUIManager.getDefaultGUIManager().log(e.getMessage(), "error", true);
        }
    }

    private void buttonComputeCHmetrics(ArrayList<String> commandsValidate) {
        if (this.clustersToGenerate > 1) {
            String string = GUIManager.getDefaultGUIManager().io.generateAllCHindexes(this.clustersToGenerate, commandsValidate);
        }
    }

    private void buttonLoadCHmetricIntoTables() {
        String lastPath = GUIManager.getDefaultGUIManager().getLastPath();
        if (this.dataTableCase56 == null) {
            JOptionPane.showMessageDialog(null, "There is no table to fill.", "Warning", 1);
            return;
        }
        String dirPath = Tools.selectDirectoryDialog(lastPath, "Select directory", "Directory with 56 R-generated files containing Celi\u0144ski-Harabasz metrics");
        if (dirPath.equals("")) {
            return;
        }
        CHmetricReader chReader = new CHmetricReader();
        ArrayList<ArrayList<Double>> chDataCore = chReader.readCHmetricsDirectory(dirPath);
        this.integrateCHIntoDatabase(chDataCore);
    }

    private void integrateCHIntoDatabase(ArrayList<ArrayList<Double>> chDataCore) {
        int sizeCH;
        int size1Order = this.dataTableCase56.getMatrix().size();
        if (size1Order != (sizeCH = chDataCore.size()) || size1Order != 56) {
            return;
        }
        int clusters = this.dataTableCase56.getMatrix().get(0).size();
        for (int i = 0; i < size1Order; ++i) {
            for (int cl = 0; cl < clusters; ++cl) {
                try {
                    this.dataTableCase56.getMatrix().get((int)i).get((int)cl).evalCH = chDataCore.get(i).get(cl);
                    continue;
                }
                catch (Exception e) {
                    GUIManager.getDefaultGUIManager().log("Filling CH metric failed for subtable " + i + " row: " + cl, "error", true);
                    this.dataTableCase56.getMatrix().get((int)i).get((int)cl).evalCH = 0.0;
                }
            }
        }
        this.registerDataCase56(this.dataTableCase56);
    }

    private void buttonSerializeDataTable() {
        try {
            String lastPath = GUIManager.getDefaultGUIManager().getLastPath();
            FileFilter[] filter = new FileFilter[]{new ExtensionFileFilter("Holmes CLustering file (.hcl)", new String[]{"hcl", "acl"})};
            Object newLocation = Tools.selectFileDialog(lastPath, filter, "Save table", "", "");
            if (((String)newLocation).equals("")) {
                return;
            }
            if (!((String)newLocation).contains(".hcl")) {
                newLocation = (String)newLocation + ".hcl";
            }
            FileOutputStream fos = new FileOutputStream((String)newLocation);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(this.dataTableCase56);
            oos.close();
            fos.close();
        }
        catch (IOException ioe) {
            GUIManager.getDefaultGUIManager().log("Saving data table failed.", "error", true);
        }
    }

    private void buttonDeserializeFile() {
        ClusteringInfoMatrix clusterMatrix = new ClusteringInfoMatrix();
        String lastPath = GUIManager.getDefaultGUIManager().getLastPath();
        String newLocation = "";
        try {
            FileFilter[] filter = new FileFilter[]{new ExtensionFileFilter("Holmes CLustering file (.hcl)", new String[]{"hcl", "acl"})};
            newLocation = Tools.selectFileDialog(lastPath, filter, "Load table", "", "");
            if (newLocation.equals("")) {
                return;
            }
            File test = new File(newLocation);
            if (!test.exists()) {
                return;
            }
            FileInputStream fis = new FileInputStream(newLocation);
            ObjectInputStream ois = new ObjectInputStream(fis);
            clusterMatrix = (ClusteringInfoMatrix)ois.readObject();
            ois.close();
            fis.close();
            this.registerDataCase56(clusterMatrix);
        }
        catch (Exception ioe) {
            String msg = "Program was unable to load data table from " + newLocation;
            GUIManager.getDefaultGUIManager().log(msg, "error", true);
        }
    }

    private void initiateListeners() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }

            @Override
            public void windowStateChanged(WindowEvent e) {
            }

            @Override
            public void windowGainedFocus(WindowEvent e) {
            }

            @Override
            public void windowLostFocus(WindowEvent e) {
            }

            @Override
            public void windowActivated(WindowEvent e) {
            }
        });
    }

    public void resetWindow() {
        this.tableModel.setRowCount(0);
    }

    private void commandsAddAll() {
        this.commandsValidate.add("\"correlation\",\"average\"");
        this.commandsValidate.add("\"correlation\",\"centroid\"");
        this.commandsValidate.add("\"correlation\",\"complete\"");
        this.commandsValidate.add("\"correlation\",\"mcquitty\"");
        this.commandsValidate.add("\"correlation\",\"median\"");
        this.commandsValidate.add("\"correlation\",\"single\"");
        this.commandsValidate.add("\"correlation\",\"ward\"");
        this.commandsValidate.add("\"pearson\",\"average\"");
        this.commandsValidate.add("\"pearson\",\"centroid\"");
        this.commandsValidate.add("\"pearson\",\"complete\"");
        this.commandsValidate.add("\"pearson\",\"mcquitty\"");
        this.commandsValidate.add("\"pearson\",\"median\"");
        this.commandsValidate.add("\"pearson\",\"single\"");
        this.commandsValidate.add("\"pearson\",\"ward\"");
        this.commandsValidate.add("\"binary\",\"average\"");
        this.commandsValidate.add("\"binary\",\"centroid\"");
        this.commandsValidate.add("\"binary\",\"complete\"");
        this.commandsValidate.add("\"binary\",\"mcquitty\"");
        this.commandsValidate.add("\"binary\",\"median\"");
        this.commandsValidate.add("\"binary\",\"single\"");
        this.commandsValidate.add("\"binary\",\"ward.D\"");
        this.commandsValidate.add("\"canberra\",\"average\"");
        this.commandsValidate.add("\"canberra\",\"centroid\"");
        this.commandsValidate.add("\"canberra\",\"complete\"");
        this.commandsValidate.add("\"canberra\",\"mcquitty\"");
        this.commandsValidate.add("\"canberra\",\"median\"");
        this.commandsValidate.add("\"canberra\",\"single\"");
        this.commandsValidate.add("\"canberra\",\"ward.D\"");
        this.commandsValidate.add("\"euclidean\",\"average\"");
        this.commandsValidate.add("\"euclidean\",\"centroid\"");
        this.commandsValidate.add("\"euclidean\",\"complete\"");
        this.commandsValidate.add("\"euclidean\",\"mcquitty\"");
        this.commandsValidate.add("\"euclidean\",\"median\"");
        this.commandsValidate.add("\"euclidean\",\"single\"");
        this.commandsValidate.add("\"euclidean\",\"ward.D\"");
        this.commandsValidate.add("\"manhattan\",\"average\"");
        this.commandsValidate.add("\"manhattan\",\"centroid\"");
        this.commandsValidate.add("\"manhattan\",\"complete\"");
        this.commandsValidate.add("\"manhattan\",\"mcquitty\"");
        this.commandsValidate.add("\"manhattan\",\"median\"");
        this.commandsValidate.add("\"manhattan\",\"single\"");
        this.commandsValidate.add("\"manhattan\",\"ward.D\"");
        this.commandsValidate.add("\"maximum\",\"average\"");
        this.commandsValidate.add("\"maximum\",\"centroid\"");
        this.commandsValidate.add("\"maximum\",\"complete\"");
        this.commandsValidate.add("\"maximum\",\"mcquitty\"");
        this.commandsValidate.add("\"maximum\",\"median\"");
        this.commandsValidate.add("\"maximum\",\"single\"");
        this.commandsValidate.add("\"maximum\",\"ward.D\"");
        this.commandsValidate.add("\"minkowski\",\"average\"");
        this.commandsValidate.add("\"minkowski\",\"centroid\"");
        this.commandsValidate.add("\"minkowski\",\"complete\"");
        this.commandsValidate.add("\"minkowski\",\"mcquitty\"");
        this.commandsValidate.add("\"minkowski\",\"median\"");
        this.commandsValidate.add("\"minkowski\",\"single\"");
        this.commandsValidate.add("\"minkowski\",\"ward.D\"");
    }

    class ClusterTableRenderer
    implements TableCellRenderer {
        public DefaultTableCellRenderer DEFAULT_RENDERER = new DefaultTableCellRenderer();
        private int mode = 0;
        private int subRows = 0;

        public ClusterTableRenderer() {
        }

        public ClusterTableRenderer(int mode, int rows) {
            this();
            this.mode = mode;
            this.subRows = rows;
        }

        public void setSubRows(int rows) {
            this.subRows = rows;
        }

        public void setMode(int mode) {
            this.mode = mode;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (this.mode == 0) {
                return this.paintCellsCase56(value, isSelected, hasFocus, row, column);
            }
            return this.paintCellsCase56(value, isSelected, hasFocus, row, column);
        }

        private Component paintCellsCase56(Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component renderer = this.DEFAULT_RENDERER.getTableCellRendererComponent(HolmesClusters.this.table, value, isSelected, hasFocus, row, column);
            if (column == 0) {
                ((DefaultTableCellRenderer)renderer).setHorizontalAlignment(2);
                renderer.setFont(new Font("Arial", 1, 10));
                renderer.setBackground(Color.white);
            } else if (row == 0 || row % (this.subRows + 1) == 0) {
                ((DefaultTableCellRenderer)renderer).setHorizontalAlignment(0);
                renderer.setFont(new Font("Arial", 1, 10));
            } else {
                float cellValue;
                ((DefaultTableCellRenderer)renderer).setHorizontalAlignment(2);
                renderer.setFont(new Font("Arial", 0, 12));
                try {
                    cellValue = Float.parseFloat(value.toString());
                }
                catch (Exception e) {
                    cellValue = -1.0f;
                }
                if ((column + 2) % 3 == 0) {
                    if (cellValue >= 0.0f && cellValue < 5.0f) {
                        renderer.setBackground(new Color(51, 212, 62));
                    } else if (cellValue >= 5.0f && cellValue < 10.0f) {
                        renderer.setBackground(new Color(231, 242, 15));
                    } else {
                        renderer.setBackground(new Color(242, 52, 15));
                    }
                } else if ((column + 1) % 3 == 0) {
                    renderer.setBackground(this.getSimpleColor(cellValue *= 100.0f));
                } else {
                    ((DefaultTableCellRenderer)renderer).setHorizontalAlignment(4);
                    renderer.setBackground(Color.lightGray);
                    try {
                        int r = row % (this.subRows + 1);
                        if (r == 1) {
                            Object nextCell = HolmesClusters.this.table.getValueAt(row + 1, column);
                            float next = Float.parseFloat(nextCell.toString());
                            if (cellValue > next) {
                                renderer.setFont(new Font("Arial", 1, 12));
                            }
                        } else if (r == this.subRows) {
                            Object previousCell = HolmesClusters.this.table.getValueAt(row - 1, column);
                            float previous = Float.parseFloat(previousCell.toString());
                            if (cellValue > previous) {
                                renderer.setFont(new Font("Arial", 1, 12));
                            }
                        } else {
                            Object nextCell = HolmesClusters.this.table.getValueAt(row + 1, column);
                            Object previousCell = HolmesClusters.this.table.getValueAt(row - 1, column);
                            float next = Float.parseFloat(nextCell.toString());
                            float previous = Float.parseFloat(previousCell.toString());
                            if (cellValue > previous && cellValue > next) {
                                renderer.setFont(new Font("Arial", 1, 12));
                                renderer.setBackground(Color.gray);
                            }
                        }
                    }
                    catch (Exception ex) {
                        GUIManager.getDefaultGUIManager().log("Error (747155147) | Exception:  " + ex.getMessage(), "error", true);
                    }
                }
            }
            return renderer;
        }

        public Color getSimpleColor(double power) {
            Color result = power < 30.0 ? new Color(250, 2, 2) : (power < 40.0 ? new Color(240, 92, 12) : (power < 50.0 ? new Color(240, 171, 12) : (power < 60.0 ? new Color(173, 217, 13) : (power < 75.0 ? new Color(12, 232, 26) : new Color(1, 153, 19)))));
            return result;
        }
    }
}

