/*
 * Decompiled with CFR 0.152.
 */
package holmes.windows.clusters;

import holmes.darkgui.GUIManager;
import holmes.utilities.Tools;
import holmes.windows.clusters.HolmesClusters;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class HolmesClusterConfig
extends JFrame {
    private static final long serialVersionUID = 1694133455242675169L;
    private ArrayList<String> commandsValidate;
    private HolmesClusters boss;
    private JCheckBox corAvgCB;
    private JCheckBox corCentrCB;
    private JCheckBox corComplCB;
    private JCheckBox corMcQCB;
    private JCheckBox corMedCB;
    private JCheckBox corSingCB;
    private JCheckBox corWardCB;
    private JCheckBox pearAvgCB;
    private JCheckBox pearCentrCB;
    private JCheckBox pearComplCB;
    private JCheckBox pearMcQCB;
    private JCheckBox pearMedCB;
    private JCheckBox pearSingCB;
    private JCheckBox pearWardCB;
    private JCheckBox binAvgCB;
    private JCheckBox binCentrCB;
    private JCheckBox binComplCB;
    private JCheckBox binMcQCB;
    private JCheckBox binMedCB;
    private JCheckBox binSingCB;
    private JCheckBox binWardCB;
    private JCheckBox canAvgCB;
    private JCheckBox canCentrCB;
    private JCheckBox canComplCB;
    private JCheckBox canMcQCB;
    private JCheckBox canMedCB;
    private JCheckBox canSingCB;
    private JCheckBox canWardCB;
    private JCheckBox eucAvgCB;
    private JCheckBox eucCentrCB;
    private JCheckBox eucComplCB;
    private JCheckBox eucMcQCB;
    private JCheckBox eucMedCB;
    private JCheckBox eucSingCB;
    private JCheckBox eucWardCB;
    private JCheckBox manAvgCB;
    private JCheckBox manCentrCB;
    private JCheckBox manComplCB;
    private JCheckBox manMcQCB;
    private JCheckBox manMedCB;
    private JCheckBox manSingCB;
    private JCheckBox manWardCB;
    private JCheckBox maxAvgCB;
    private JCheckBox maxCentrCB;
    private JCheckBox maxComplCB;
    private JCheckBox maxMcQCB;
    private JCheckBox maxMedCB;
    private JCheckBox maxSingCB;
    private JCheckBox maxWardCB;
    private JCheckBox minAvgCB;
    private JCheckBox minCentrCB;
    private JCheckBox minComplCB;
    private JCheckBox minMcQCB;
    private JCheckBox minMedCB;
    private JCheckBox minSingCB;
    private JCheckBox minWardCB;

    public HolmesClusterConfig(ArrayList<String> comm, HolmesClusters parent) {
        try {
            this.setIconImage(Tools.getImageFromIcon("/icons/holmesicon.png"));
        }
        catch (Exception ex) {
            GUIManager.getDefaultGUIManager().log("Error (656756737) | Exception:  " + ex.getMessage(), "error", true);
        }
        this.commandsValidate = comm;
        this.boss = parent;
        this.setVisible(false);
        this.setTitle("Clustering config");
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(1050, 300));
        this.setLocation(15, 15);
        this.setDefaultCloseOperation(1);
        JPanel mainPanel = this.createMainPanel();
        this.add((Component)mainPanel, "Center");
        this.initiateListeners();
    }

    private JPanel createMainPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        JPanel upPanel = this.createUpPanel(0, 0, 1050, 50);
        JPanel bottomPanel = this.createBottomPanel(0, 130, 1050, 250);
        panel.add((Component)upPanel, "North");
        panel.add((Component)bottomPanel, "Center");
        panel.repaint();
        return panel;
    }

    private JPanel createUpPanel(int x, int y, int width, int height) {
        JPanel panel = new JPanel();
        panel.setLayout(null);
        panel.setBorder(BorderFactory.createTitledBorder("Search options"));
        panel.setLocation(x, y);
        panel.setPreferredSize(new Dimension(width, height));
        int posX = 10;
        int posY = 20;
        JButton cleanAllCB = new JButton("Clean All");
        cleanAllCB.setBounds(posX, posY, 140, 20);
        cleanAllCB.addActionListener(actionEvent -> {
            this.commandsValidate.clear();
            this.updateComponents();
        });
        cleanAllCB.setSelected(true);
        panel.add(cleanAllCB);
        JButton setAllCB = new JButton("Set All");
        setAllCB.setBounds(posX + 150, posY, 140, 20);
        setAllCB.addActionListener(actionEvent -> {
            this.commandsAddAll();
            this.updateComponents();
        });
        setAllCB.setSelected(true);
        panel.add(setAllCB);
        JButton pearsonsCB = new JButton("PearsonOnly");
        pearsonsCB.setBounds(posX + 300, posY, 140, 20);
        pearsonsCB.addActionListener(actionEvent -> {
            this.selectPearsonOnly();
            this.updateComponents();
        });
        pearsonsCB.setSelected(true);
        panel.add(pearsonsCB);
        return panel;
    }

    private JPanel createBottomPanel(int x, int y, int width, int height) {
        JPanel panel = new JPanel();
        panel.setLayout(null);
        panel.setBorder(BorderFactory.createTitledBorder("Cluster options"));
        panel.setLocation(x, y);
        panel.setPreferredSize(new Dimension(width, height));
        int posX = 10;
        int posY = 20;
        this.corAvgCB = new JCheckBox("CorPear-Average");
        this.corAvgCB.setBounds(posX, posY, 140, 20);
        this.corAvgCB.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            if (abstractButton.getModel().isSelected()) {
                if (!this.commandsValidate.contains("\"correlation\",\"average\"")) {
                    this.commandsValidate.add("\"correlation\",\"average\"");
                }
            } else {
                this.commandsValidate.remove("\"correlation\",\"average\"");
            }
        });
        this.corAvgCB.setSelected(true);
        panel.add(this.corAvgCB);
        this.corCentrCB = new JCheckBox("CorPear-Centroid");
        this.corCentrCB.setBounds(posX + 140, posY, 140, 20);
        this.corCentrCB.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            if (abstractButton.getModel().isSelected()) {
                if (!this.commandsValidate.contains("\"correlation\",\"centroid\"")) {
                    this.commandsValidate.add("\"correlation\",\"centroid\"");
                }
            } else {
                this.commandsValidate.remove("\"correlation\",\"centroid\"");
            }
        });
        this.corCentrCB.setSelected(true);
        panel.add(this.corCentrCB);
        this.corComplCB = new JCheckBox("CorPear-Complete");
        this.corComplCB.setBounds(posX + 280, posY, 140, 20);
        this.corComplCB.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            if (abstractButton.getModel().isSelected()) {
                if (!this.commandsValidate.contains("\"correlation\",\"complete\"")) {
                    this.commandsValidate.add("\"correlation\",\"complete\"");
                }
            } else {
                this.commandsValidate.remove("\"correlation\",\"complete\"");
            }
        });
        this.corComplCB.setSelected(true);
        panel.add(this.corComplCB);
        this.corMcQCB = new JCheckBox("CorPear-McQuitty");
        this.corMcQCB.setBounds(posX + 420, posY, 140, 20);
        this.corMcQCB.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            if (abstractButton.getModel().isSelected()) {
                if (!this.commandsValidate.contains("\"correlation\",\"mcquitty\"")) {
                    this.commandsValidate.add("\"correlation\",\"mcquitty\"");
                }
            } else {
                this.commandsValidate.remove("\"correlation\",\"mcquitty\"");
            }
        });
        this.corMcQCB.setSelected(true);
        panel.add(this.corMcQCB);
        this.corMedCB = new JCheckBox("CorPear-Median");
        this.corMedCB.setBounds(posX + 560, posY, 140, 20);
        this.corMedCB.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            if (abstractButton.getModel().isSelected()) {
                if (!this.commandsValidate.contains("\"correlation\",\"median\"")) {
                    this.commandsValidate.add("\"correlation\",\"median\"");
                }
            } else {
                this.commandsValidate.remove("\"correlation\",\"median\"");
            }
        });
        this.corMedCB.setSelected(true);
        panel.add(this.corMedCB);
        this.corSingCB = new JCheckBox("CorPear-Single");
        this.corSingCB.setBounds(posX + 700, posY, 140, 20);
        this.corSingCB.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            if (abstractButton.getModel().isSelected()) {
                if (!this.commandsValidate.contains("\"correlation\",\"single\"")) {
                    this.commandsValidate.add("\"correlation\",\"single\"");
                }
            } else {
                this.commandsValidate.remove("\"correlation\",\"single\"");
            }
        });
        this.corSingCB.setSelected(true);
        panel.add(this.corSingCB);
        this.corWardCB = new JCheckBox("CorPear-Ward");
        this.corWardCB.setBounds(posX + 840, posY, 140, 20);
        this.corWardCB.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            if (abstractButton.getModel().isSelected()) {
                if (!this.commandsValidate.contains("\"correlation\",\"ward\"")) {
                    this.commandsValidate.add("\"correlation\",\"ward\"");
                }
            } else {
                this.commandsValidate.remove("\"correlation\",\"ward\"");
            }
        });
        this.corWardCB.setSelected(true);
        panel.add(this.corWardCB);
        this.pearAvgCB = new JCheckBox("Pearson-Average");
        this.pearAvgCB.setBounds(posX, posY += 20, 140, 20);
        this.pearAvgCB.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            if (abstractButton.getModel().isSelected()) {
                if (!this.commandsValidate.contains("\"pearson\",\"average\"")) {
                    this.commandsValidate.add("\"pearson\",\"average\"");
                }
            } else {
                this.commandsValidate.remove("\"pearson\",\"average\"");
            }
        });
        this.pearAvgCB.setSelected(true);
        panel.add(this.pearAvgCB);
        this.pearCentrCB = new JCheckBox("Pearson-Centroid");
        this.pearCentrCB.setBounds(posX + 140, posY, 140, 20);
        this.pearCentrCB.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            if (abstractButton.getModel().isSelected()) {
                if (!this.commandsValidate.contains("\"pearson\",\"centroid\"")) {
                    this.commandsValidate.add("\"pearson\",\"centroid\"");
                }
            } else {
                this.commandsValidate.remove("\"pearson\",\"centroid\"");
            }
        });
        this.pearCentrCB.setSelected(true);
        panel.add(this.pearCentrCB);
        this.pearComplCB = new JCheckBox("Pearson-Complete");
        this.pearComplCB.setBounds(posX + 280, posY, 140, 20);
        this.pearComplCB.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            if (abstractButton.getModel().isSelected()) {
                if (!this.commandsValidate.contains("\"pearson\",\"complete\"")) {
                    this.commandsValidate.add("\"pearson\",\"complete\"");
                }
            } else {
                this.commandsValidate.remove("\"pearson\",\"complete\"");
            }
        });
        this.pearComplCB.setSelected(true);
        panel.add(this.pearComplCB);
        this.pearMcQCB = new JCheckBox("Pearson-McQuitty");
        this.pearMcQCB.setBounds(posX + 420, posY, 140, 20);
        this.pearMcQCB.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            if (abstractButton.getModel().isSelected()) {
                if (!this.commandsValidate.contains("\"pearson\",\"mcquitty\"")) {
                    this.commandsValidate.add("\"pearson\",\"mcquitty\"");
                }
            } else {
                this.commandsValidate.remove("\"pearson\",\"mcquitty\"");
            }
        });
        this.pearMcQCB.setSelected(true);
        panel.add(this.pearMcQCB);
        this.pearMedCB = new JCheckBox("Pearson-Median");
        this.pearMedCB.setBounds(posX + 560, posY, 140, 20);
        this.pearMedCB.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            if (abstractButton.getModel().isSelected()) {
                if (!this.commandsValidate.contains("\"pearson\",\"median\"")) {
                    this.commandsValidate.add("\"pearson\",\"median\"");
                }
            } else {
                this.commandsValidate.remove("\"pearson\",\"median\"");
            }
        });
        this.pearMedCB.setSelected(true);
        panel.add(this.pearMedCB);
        this.pearSingCB = new JCheckBox("Pearson-Single");
        this.pearSingCB.setBounds(posX + 700, posY, 140, 20);
        this.pearSingCB.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            if (abstractButton.getModel().isSelected()) {
                if (!this.commandsValidate.contains("\"pearson\",\"single\"")) {
                    this.commandsValidate.add("\"pearson\",\"single\"");
                }
            } else {
                this.commandsValidate.remove("\"pearson\",\"single\"");
            }
        });
        this.pearSingCB.setSelected(true);
        panel.add(this.pearSingCB);
        this.pearWardCB = new JCheckBox("Pearson-Ward");
        this.pearWardCB.setBounds(posX + 840, posY, 140, 20);
        this.pearWardCB.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            if (abstractButton.getModel().isSelected()) {
                if (!this.commandsValidate.contains("\"pearson\",\"ward\"")) {
                    this.commandsValidate.add("\"pearson\",\"ward\"");
                }
            } else {
                this.commandsValidate.remove("\"pearson\",\"ward\"");
            }
        });
        this.pearWardCB.setSelected(true);
        panel.add(this.pearWardCB);
        this.binAvgCB = new JCheckBox("Binary-Average");
        this.binAvgCB.setBounds(posX, posY += 20, 140, 20);
        this.binAvgCB.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            if (abstractButton.getModel().isSelected()) {
                if (!this.commandsValidate.contains("\"binary\",\"average\"")) {
                    this.commandsValidate.add("\"binary\",\"average\"");
                }
            } else {
                this.commandsValidate.remove("\"binary\",\"average\"");
            }
        });
        this.binAvgCB.setSelected(true);
        panel.add(this.binAvgCB);
        this.binCentrCB = new JCheckBox("Binary-Centroid");
        this.binCentrCB.setBounds(posX + 140, posY, 140, 20);
        this.binCentrCB.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            if (abstractButton.getModel().isSelected()) {
                if (!this.commandsValidate.contains("\"binary\",\"centroid\"")) {
                    this.commandsValidate.add("\"binary\",\"centroid\"");
                }
            } else {
                this.commandsValidate.remove("\"binary\",\"centroid\"");
            }
        });
        this.binCentrCB.setSelected(true);
        panel.add(this.binCentrCB);
        this.binComplCB = new JCheckBox("Binary-Complete");
        this.binComplCB.setBounds(posX + 280, posY, 140, 20);
        this.binComplCB.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            if (abstractButton.getModel().isSelected()) {
                if (!this.commandsValidate.contains("\"binary\",\"complete\"")) {
                    this.commandsValidate.add("\"binary\",\"complete\"");
                }
            } else {
                this.commandsValidate.remove("\"binary\",\"complete\"");
            }
        });
        this.binComplCB.setSelected(true);
        panel.add(this.binComplCB);
        this.binMcQCB = new JCheckBox("Binary-McQuitty");
        this.binMcQCB.setBounds(posX + 420, posY, 140, 20);
        this.binMcQCB.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            if (abstractButton.getModel().isSelected()) {
                if (!this.commandsValidate.contains("\"binary\",\"mcquitty\"")) {
                    this.commandsValidate.add("\"binary\",\"mcquitty\"");
                }
            } else {
                this.commandsValidate.remove("\"binary\",\"mcquitty\"");
            }
        });
        this.binMcQCB.setSelected(true);
        panel.add(this.binMcQCB);
        this.binMedCB = new JCheckBox("Binary-Median");
        this.binMedCB.setBounds(posX + 560, posY, 140, 20);
        this.binMedCB.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            if (abstractButton.getModel().isSelected()) {
                if (!this.commandsValidate.contains("\"binary\",\"median\"")) {
                    this.commandsValidate.add("\"binary\",\"median\"");
                }
            } else {
                this.commandsValidate.remove("\"binary\",\"median\"");
            }
        });
        this.binMedCB.setSelected(true);
        panel.add(this.binMedCB);
        this.binSingCB = new JCheckBox("Binary-Single");
        this.binSingCB.setBounds(posX + 700, posY, 140, 20);
        this.binSingCB.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            if (abstractButton.getModel().isSelected()) {
                if (!this.commandsValidate.contains("\"binary\",\"single\"")) {
                    this.commandsValidate.add("\"binary\",\"single\"");
                }
            } else {
                this.commandsValidate.remove("\"binary\",\"single\"");
            }
        });
        this.binSingCB.setSelected(true);
        panel.add(this.binSingCB);
        this.binWardCB = new JCheckBox("Binary-Ward");
        this.binWardCB.setBounds(posX + 840, posY, 140, 20);
        this.binWardCB.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            if (abstractButton.getModel().isSelected()) {
                if (!this.commandsValidate.contains("\"binary\",\"ward.D\"")) {
                    this.commandsValidate.add("\"binary\",\"ward.D\"");
                }
            } else {
                this.commandsValidate.remove("\"binary\",\"ward.D\"");
            }
        });
        this.binWardCB.setSelected(true);
        panel.add(this.binWardCB);
        this.canAvgCB = new JCheckBox("Canberra-Average");
        this.canAvgCB.setBounds(posX, posY += 20, 140, 20);
        this.canAvgCB.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            if (abstractButton.getModel().isSelected()) {
                if (!this.commandsValidate.contains("\"canberra\",\"average\"")) {
                    this.commandsValidate.add("\"canberra\",\"average\"");
                }
            } else {
                this.commandsValidate.remove("\"canberra\",\"average\"");
            }
        });
        this.canAvgCB.setSelected(true);
        panel.add(this.canAvgCB);
        this.canCentrCB = new JCheckBox("Canberra-Centroid");
        this.canCentrCB.setBounds(posX + 140, posY, 140, 20);
        this.canCentrCB.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            if (abstractButton.getModel().isSelected()) {
                if (!this.commandsValidate.contains("\"canberra\",\"centroid\"")) {
                    this.commandsValidate.add("\"canberra\",\"centroid\"");
                }
            } else {
                this.commandsValidate.remove("\"canberra\",\"centroid\"");
            }
        });
        this.canCentrCB.setSelected(true);
        panel.add(this.canCentrCB);
        this.canComplCB = new JCheckBox("Canberra-Complete");
        this.canComplCB.setBounds(posX + 280, posY, 140, 20);
        this.canComplCB.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            if (abstractButton.getModel().isSelected()) {
                if (!this.commandsValidate.contains("\"canberra\",\"complete\"")) {
                    this.commandsValidate.add("\"canberra\",\"complete\"");
                }
            } else {
                this.commandsValidate.remove("\"canberra\",\"complete\"");
            }
        });
        this.canComplCB.setSelected(true);
        panel.add(this.canComplCB);
        this.canMcQCB = new JCheckBox("Canberra-McQuitty");
        this.canMcQCB.setBounds(posX + 420, posY, 140, 20);
        this.canMcQCB.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            if (abstractButton.getModel().isSelected()) {
                if (!this.commandsValidate.contains("\"canberra\",\"mcquitty\"")) {
                    this.commandsValidate.add("\"canberra\",\"mcquitty\"");
                }
            } else {
                this.commandsValidate.remove("\"canberra\",\"mcquitty\"");
            }
        });
        this.canMcQCB.setSelected(true);
        panel.add(this.canMcQCB);
        this.canMedCB = new JCheckBox("Canberra-Median");
        this.canMedCB.setBounds(posX + 560, posY, 140, 20);
        this.canMedCB.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            if (abstractButton.getModel().isSelected()) {
                if (!this.commandsValidate.contains("\"canberra\",\"median\"")) {
                    this.commandsValidate.add("\"canberra\",\"median\"");
                }
            } else {
                this.commandsValidate.remove("\"canberra\",\"median\"");
            }
        });
        this.canMedCB.setSelected(true);
        panel.add(this.canMedCB);
        this.canSingCB = new JCheckBox("Canberra-Single");
        this.canSingCB.setBounds(posX + 700, posY, 140, 20);
        this.canSingCB.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            if (abstractButton.getModel().isSelected()) {
                if (!this.commandsValidate.contains("\"canberra\",\"single\"")) {
                    this.commandsValidate.add("\"canberra\",\"single\"");
                }
            } else {
                this.commandsValidate.remove("\"canberra\",\"single\"");
            }
        });
        this.canSingCB.setSelected(true);
        panel.add(this.canSingCB);
        this.canWardCB = new JCheckBox("Canberra-Ward");
        this.canWardCB.setBounds(posX + 840, posY, 140, 20);
        this.canWardCB.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            if (abstractButton.getModel().isSelected()) {
                if (!this.commandsValidate.contains("\"canberra\",\"ward.D\"")) {
                    this.commandsValidate.add("\"canberra\",\"ward.D\"");
                }
            } else {
                this.commandsValidate.remove("\"canberra\",\"ward.D\"");
            }
        });
        this.canWardCB.setSelected(true);
        panel.add(this.canWardCB);
        this.eucAvgCB = new JCheckBox("Euclidean-Average");
        this.eucAvgCB.setBounds(posX, posY += 20, 140, 20);
        this.eucAvgCB.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            if (abstractButton.getModel().isSelected()) {
                if (!this.commandsValidate.contains("\"euclidean\",\"average\"")) {
                    this.commandsValidate.add("\"euclidean\",\"average\"");
                }
            } else {
                this.commandsValidate.remove("\"euclidean\",\"average\"");
            }
        });
        this.eucAvgCB.setSelected(true);
        panel.add(this.eucAvgCB);
        this.eucCentrCB = new JCheckBox("Euclidean-Centroid");
        this.eucCentrCB.setBounds(posX + 140, posY, 140, 20);
        this.eucCentrCB.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            if (abstractButton.getModel().isSelected()) {
                if (!this.commandsValidate.contains("\"euclidean\",\"centroid\"")) {
                    this.commandsValidate.add("\"euclidean\",\"centroid\"");
                }
            } else {
                this.commandsValidate.remove("\"euclidean\",\"centroid\"");
            }
        });
        this.eucCentrCB.setSelected(true);
        panel.add(this.eucCentrCB);
        this.eucComplCB = new JCheckBox("Euclidean-Complete");
        this.eucComplCB.setBounds(posX + 280, posY, 140, 20);
        this.eucComplCB.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            if (abstractButton.getModel().isSelected()) {
                if (!this.commandsValidate.contains("\"euclidean\",\"complete\"")) {
                    this.commandsValidate.add("\"euclidean\",\"complete\"");
                }
            } else {
                this.commandsValidate.remove("\"euclidean\",\"complete\"");
            }
        });
        this.eucComplCB.setSelected(true);
        panel.add(this.eucComplCB);
        this.eucMcQCB = new JCheckBox("Euclidean-McQuitty");
        this.eucMcQCB.setBounds(posX + 420, posY, 140, 20);
        this.eucMcQCB.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            if (abstractButton.getModel().isSelected()) {
                if (!this.commandsValidate.contains("\"euclidean\",\"mcquitty\"")) {
                    this.commandsValidate.add("\"euclidean\",\"mcquitty\"");
                }
            } else {
                this.commandsValidate.remove("\"euclidean\",\"mcquitty\"");
            }
        });
        this.eucMcQCB.setSelected(true);
        panel.add(this.eucMcQCB);
        this.eucMedCB = new JCheckBox("Euclidean-Median");
        this.eucMedCB.setBounds(posX + 560, posY, 140, 20);
        this.eucMedCB.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            if (abstractButton.getModel().isSelected()) {
                if (!this.commandsValidate.contains("\"euclidean\",\"median\"")) {
                    this.commandsValidate.add("\"euclidean\",\"median\"");
                }
            } else {
                this.commandsValidate.remove("\"euclidean\",\"median\"");
            }
        });
        this.eucMedCB.setSelected(true);
        panel.add(this.eucMedCB);
        this.eucSingCB = new JCheckBox("Euclidean-Single");
        this.eucSingCB.setBounds(posX + 700, posY, 140, 20);
        this.eucSingCB.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            if (abstractButton.getModel().isSelected()) {
                if (!this.commandsValidate.contains("\"euclidean\",\"single\"")) {
                    this.commandsValidate.add("\"euclidean\",\"single\"");
                }
            } else {
                this.commandsValidate.remove("\"euclidean\",\"single\"");
            }
        });
        this.eucSingCB.setSelected(true);
        panel.add(this.eucSingCB);
        this.eucWardCB = new JCheckBox("Euclidean-Ward");
        this.eucWardCB.setBounds(posX + 840, posY, 140, 20);
        this.eucWardCB.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            if (abstractButton.getModel().isSelected()) {
                if (!this.commandsValidate.contains("\"euclidean\",\"ward.D\"")) {
                    this.commandsValidate.add("\"euclidean\",\"ward.D\"");
                }
            } else {
                this.commandsValidate.remove("\"euclidean\",\"ward.D\"");
            }
        });
        this.eucWardCB.setSelected(true);
        panel.add(this.eucWardCB);
        this.manAvgCB = new JCheckBox("Manhattan-Average");
        this.manAvgCB.setBounds(posX, posY += 20, 140, 20);
        this.manAvgCB.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            if (abstractButton.getModel().isSelected()) {
                if (!this.commandsValidate.contains("\"manhattan\",\"average\"")) {
                    this.commandsValidate.add("\"manhattan\",\"average\"");
                }
            } else {
                this.commandsValidate.remove("\"manhattan\",\"average\"");
            }
        });
        this.manAvgCB.setSelected(true);
        panel.add(this.manAvgCB);
        this.manCentrCB = new JCheckBox("Manhattan-Centroid");
        this.manCentrCB.setBounds(posX + 140, posY, 140, 20);
        this.manCentrCB.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            if (abstractButton.getModel().isSelected()) {
                if (!this.commandsValidate.contains("\"manhattan\",\"centroid\"")) {
                    this.commandsValidate.add("\"manhattan\",\"centroid\"");
                }
            } else {
                this.commandsValidate.remove("\"manhattan\",\"centroid\"");
            }
        });
        this.manCentrCB.setSelected(true);
        panel.add(this.manCentrCB);
        this.manComplCB = new JCheckBox("Manhattan-Complete");
        this.manComplCB.setBounds(posX + 280, posY, 140, 20);
        this.manComplCB.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            if (abstractButton.getModel().isSelected()) {
                if (!this.commandsValidate.contains("\"manhattan\",\"complete\"")) {
                    this.commandsValidate.add("\"manhattan\",\"complete\"");
                }
            } else {
                this.commandsValidate.remove("\"manhattan\",\"complete\"");
            }
        });
        this.manComplCB.setSelected(true);
        panel.add(this.manComplCB);
        this.manMcQCB = new JCheckBox("Manhattan-McQuitty");
        this.manMcQCB.setBounds(posX + 420, posY, 140, 20);
        this.manMcQCB.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            if (abstractButton.getModel().isSelected()) {
                if (!this.commandsValidate.contains("\"manhattan\",\"mcquitty\"")) {
                    this.commandsValidate.add("\"manhattan\",\"mcquitty\"");
                }
            } else {
                this.commandsValidate.remove("\"manhattan\",\"mcquitty\"");
            }
        });
        this.manMcQCB.setSelected(true);
        panel.add(this.manMcQCB);
        this.manMedCB = new JCheckBox("Manhattan-Median");
        this.manMedCB.setBounds(posX + 560, posY, 140, 20);
        this.manMedCB.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            if (abstractButton.getModel().isSelected()) {
                if (!this.commandsValidate.contains("\"manhattan\",\"median\"")) {
                    this.commandsValidate.add("\"manhattan\",\"median\"");
                }
            } else {
                this.commandsValidate.remove("\"manhattan\",\"median\"");
            }
        });
        this.manMedCB.setSelected(true);
        panel.add(this.manMedCB);
        this.manSingCB = new JCheckBox("Manhattan-Single");
        this.manSingCB.setBounds(posX + 700, posY, 140, 20);
        this.manSingCB.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            if (abstractButton.getModel().isSelected()) {
                if (!this.commandsValidate.contains("\"manhattan\",\"single\"")) {
                    this.commandsValidate.add("\"manhattan\",\"single\"");
                }
            } else {
                this.commandsValidate.remove("\"manhattan\",\"single\"");
            }
        });
        this.manSingCB.setSelected(true);
        panel.add(this.manSingCB);
        this.manWardCB = new JCheckBox("Manhattan-Ward");
        this.manWardCB.setBounds(posX + 840, posY, 140, 20);
        this.manWardCB.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            if (abstractButton.getModel().isSelected()) {
                if (!this.commandsValidate.contains("\"manhattan\",\"ward.D\"")) {
                    this.commandsValidate.add("\"manhattan\",\"ward.D\"");
                }
            } else {
                this.commandsValidate.remove("\"manhattan\",\"ward.D\"");
            }
        });
        this.manWardCB.setSelected(true);
        panel.add(this.manWardCB);
        this.maxAvgCB = new JCheckBox("Maximum-Average");
        this.maxAvgCB.setBounds(posX, posY += 20, 140, 20);
        this.maxAvgCB.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            if (abstractButton.getModel().isSelected()) {
                if (!this.commandsValidate.contains("\"maximum\",\"average\"")) {
                    this.commandsValidate.add("\"maximum\",\"average\"");
                }
            } else {
                this.commandsValidate.remove("\"maximum\",\"average\"");
            }
        });
        this.maxAvgCB.setSelected(true);
        panel.add(this.maxAvgCB);
        this.maxCentrCB = new JCheckBox("Maximum-Centroid");
        this.maxCentrCB.setBounds(posX + 140, posY, 140, 20);
        this.maxCentrCB.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            if (abstractButton.getModel().isSelected()) {
                if (!this.commandsValidate.contains("\"maximum\",\"centroid\"")) {
                    this.commandsValidate.add("\"maximum\",\"centroid\"");
                }
            } else {
                this.commandsValidate.remove("\"maximum\",\"centroid\"");
            }
        });
        this.maxCentrCB.setSelected(true);
        panel.add(this.maxCentrCB);
        this.maxComplCB = new JCheckBox("Maximum-Complete");
        this.maxComplCB.setBounds(posX + 280, posY, 140, 20);
        this.maxComplCB.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            if (abstractButton.getModel().isSelected()) {
                if (!this.commandsValidate.contains("\"maximum\",\"complete\"")) {
                    this.commandsValidate.add("\"maximum\",\"complete\"");
                }
            } else {
                this.commandsValidate.remove("\"maximum\",\"complete\"");
            }
        });
        this.maxComplCB.setSelected(true);
        panel.add(this.maxComplCB);
        this.maxMcQCB = new JCheckBox("Maximum-McQuitty");
        this.maxMcQCB.setBounds(posX + 420, posY, 140, 20);
        this.maxMcQCB.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            if (abstractButton.getModel().isSelected()) {
                if (!this.commandsValidate.contains("\"maximum\",\"mcquitty\"")) {
                    this.commandsValidate.add("\"maximum\",\"mcquitty\"");
                }
            } else {
                this.commandsValidate.remove("\"maximum\",\"mcquitty\"");
            }
        });
        this.maxMcQCB.setSelected(true);
        panel.add(this.maxMcQCB);
        this.maxMedCB = new JCheckBox("Maximum-Median");
        this.maxMedCB.setBounds(posX + 560, posY, 140, 20);
        this.maxMedCB.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            if (abstractButton.getModel().isSelected()) {
                if (!this.commandsValidate.contains("\"maximum\",\"median\"")) {
                    this.commandsValidate.add("\"maximum\",\"median\"");
                }
            } else {
                this.commandsValidate.remove("\"maximum\",\"median\"");
            }
        });
        this.maxMedCB.setSelected(true);
        panel.add(this.maxMedCB);
        this.maxSingCB = new JCheckBox("Maximum-Single");
        this.maxSingCB.setBounds(posX + 700, posY, 140, 20);
        this.maxSingCB.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            if (abstractButton.getModel().isSelected()) {
                if (!this.commandsValidate.contains("\"maximum\",\"single\"")) {
                    this.commandsValidate.add("\"maximum\",\"single\"");
                }
            } else {
                this.commandsValidate.remove("\"maximum\",\"single\"");
            }
        });
        this.maxSingCB.setSelected(true);
        panel.add(this.maxSingCB);
        this.maxWardCB = new JCheckBox("Maximum-Ward");
        this.maxWardCB.setBounds(posX + 840, posY, 140, 20);
        this.maxWardCB.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            if (abstractButton.getModel().isSelected()) {
                if (!this.commandsValidate.contains("\"maximum\",\"ward.D\"")) {
                    this.commandsValidate.add("\"maximum\",\"ward.D\"");
                }
            } else {
                this.commandsValidate.remove("\"maximum\",\"ward.D\"");
            }
        });
        this.maxWardCB.setSelected(true);
        panel.add(this.maxWardCB);
        this.minAvgCB = new JCheckBox("Minkowski-Average");
        this.minAvgCB.setBounds(posX, posY += 20, 140, 20);
        this.minAvgCB.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            if (abstractButton.getModel().isSelected()) {
                if (!this.commandsValidate.contains("\"minkowski\",\"average\"")) {
                    this.commandsValidate.add("\"minkowski\",\"average\"");
                }
            } else {
                this.commandsValidate.remove("\"minkowski\",\"average\"");
            }
        });
        this.minAvgCB.setSelected(true);
        panel.add(this.minAvgCB);
        this.minCentrCB = new JCheckBox("Minkowski-Centroid");
        this.minCentrCB.setBounds(posX + 140, posY, 140, 20);
        this.minCentrCB.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            if (abstractButton.getModel().isSelected()) {
                if (!this.commandsValidate.contains("\"minkowski\",\"centroid\"")) {
                    this.commandsValidate.add("\"minkowski\",\"centroid\"");
                }
            } else {
                this.commandsValidate.remove("\"minkowski\",\"centroid\"");
            }
        });
        this.minCentrCB.setSelected(true);
        panel.add(this.minCentrCB);
        this.minComplCB = new JCheckBox("Minkowski-Complete");
        this.minComplCB.setBounds(posX + 280, posY, 140, 20);
        this.minComplCB.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            if (abstractButton.getModel().isSelected()) {
                if (!this.commandsValidate.contains("\"minkowski\",\"complete\"")) {
                    this.commandsValidate.add("\"minkowski\",\"complete\"");
                }
            } else {
                this.commandsValidate.remove("\"minkowski\",\"complete\"");
            }
        });
        this.minComplCB.setSelected(true);
        panel.add(this.minComplCB);
        this.minMcQCB = new JCheckBox("Minkowski-McQuitty");
        this.minMcQCB.setBounds(posX + 420, posY, 140, 20);
        this.minMcQCB.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            if (abstractButton.getModel().isSelected()) {
                if (!this.commandsValidate.contains("\"minkowski\",\"mcquitty\"")) {
                    this.commandsValidate.add("\"minkowski\",\"mcquitty\"");
                }
            } else {
                this.commandsValidate.remove("\"minkowski\",\"mcquitty\"");
            }
        });
        this.minMcQCB.setSelected(true);
        panel.add(this.minMcQCB);
        this.minMedCB = new JCheckBox("Minkowski-Median");
        this.minMedCB.setBounds(posX + 560, posY, 140, 20);
        this.minMedCB.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            if (abstractButton.getModel().isSelected()) {
                if (!this.commandsValidate.contains("\"minkowski\",\"median\"")) {
                    this.commandsValidate.add("\"minkowski\",\"median\"");
                }
            } else {
                this.commandsValidate.remove("\"minkowski\",\"median\"");
            }
        });
        this.minMedCB.setSelected(true);
        panel.add(this.minMedCB);
        this.minSingCB = new JCheckBox("Minkowski-Single");
        this.minSingCB.setBounds(posX + 700, posY, 140, 20);
        this.minSingCB.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            if (abstractButton.getModel().isSelected()) {
                if (!this.commandsValidate.contains("\"minkowski\",\"single\"")) {
                    this.commandsValidate.add("\"minkowski\",\"single\"");
                }
            } else {
                this.commandsValidate.remove("\"minkowski\",\"single\"");
            }
        });
        this.minSingCB.setSelected(true);
        panel.add(this.minSingCB);
        this.minWardCB = new JCheckBox("Minkowski-Ward");
        this.minWardCB.setBounds(posX + 840, posY, 140, 20);
        this.minWardCB.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            if (abstractButton.getModel().isSelected()) {
                if (!this.commandsValidate.contains("\"minkowski\",\"ward.D\"")) {
                    this.commandsValidate.add("\"minkowski\",\"ward.D\"");
                }
            } else {
                this.commandsValidate.remove("\"minkowski\",\"ward.D\"");
            }
        });
        this.minWardCB.setSelected(true);
        panel.add(this.minWardCB);
        return panel;
    }

    private void initiateListeners() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                HolmesClusterConfig.this.boss.setEnabled(false);
                GUIManager.getDefaultGUIManager().getFrame().setEnabled(false);
                HolmesClusterConfig.this.updateComponents();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                if (HolmesClusterConfig.this.commandsValidate.size() == 0) {
                    JOptionPane.showMessageDialog(null, "At least one clustering method must be chosen.\nSelecting CorrelatedPearson-Average(UPGMA)", "Problem", 2);
                }
                HolmesClusterConfig.this.commandsValidate.add("\"correlation\",\"average\"");
                HolmesClusterConfig.this.boss.setEnabled(true);
                GUIManager.getDefaultGUIManager().getFrame().setEnabled(true);
            }
        });
    }

    private void updateComponents() {
        this.corAvgCB.setSelected(this.commandsValidate.contains("\"correlation\",\"average\""));
        this.corCentrCB.setSelected(this.commandsValidate.contains("\"correlation\",\"centroid\""));
        this.corComplCB.setSelected(this.commandsValidate.contains("\"correlation\",\"complete\""));
        this.corMcQCB.setSelected(this.commandsValidate.contains("\"correlation\",\"mcquitty\""));
        this.corMedCB.setSelected(this.commandsValidate.contains("\"correlation\",\"median\""));
        this.corSingCB.setSelected(this.commandsValidate.contains("\"correlation\",\"single\""));
        this.corWardCB.setSelected(this.commandsValidate.contains("\"correlation\",\"ward\""));
        this.pearAvgCB.setSelected(this.commandsValidate.contains("\"pearson\",\"average\""));
        this.pearCentrCB.setSelected(this.commandsValidate.contains("\"pearson\",\"centroid\""));
        this.pearComplCB.setSelected(this.commandsValidate.contains("\"pearson\",\"complete\""));
        this.pearMcQCB.setSelected(this.commandsValidate.contains("\"pearson\",\"mcquitty\""));
        this.pearMedCB.setSelected(this.commandsValidate.contains("\"pearson\",\"median\""));
        this.pearSingCB.setSelected(this.commandsValidate.contains("\"pearson\",\"single\""));
        this.pearWardCB.setSelected(this.commandsValidate.contains("\"pearson\",\"ward\""));
        this.binAvgCB.setSelected(this.commandsValidate.contains("\"binary\",\"average\""));
        this.binCentrCB.setSelected(this.commandsValidate.contains("\"binary\",\"centroid\""));
        this.binComplCB.setSelected(this.commandsValidate.contains("\"binary\",\"complete\""));
        this.binMcQCB.setSelected(this.commandsValidate.contains("\"binary\",\"mcquitty\""));
        this.binMedCB.setSelected(this.commandsValidate.contains("\"binary\",\"median\""));
        this.binSingCB.setSelected(this.commandsValidate.contains("\"binary\",\"single\""));
        this.binWardCB.setSelected(this.commandsValidate.contains("\"binary\",\"ward.D\""));
        this.canAvgCB.setSelected(this.commandsValidate.contains("\"canberra\",\"average\""));
        this.canCentrCB.setSelected(this.commandsValidate.contains("\"canberra\",\"centroid\""));
        this.canComplCB.setSelected(this.commandsValidate.contains("\"canberra\",\"complete\""));
        this.canMcQCB.setSelected(this.commandsValidate.contains("\"canberra\",\"mcquitty\""));
        this.canMedCB.setSelected(this.commandsValidate.contains("\"canberra\",\"median\""));
        this.canSingCB.setSelected(this.commandsValidate.contains("\"canberra\",\"single\""));
        this.canWardCB.setSelected(this.commandsValidate.contains("\"canberra\",\"ward.D\""));
        this.eucAvgCB.setSelected(this.commandsValidate.contains("\"euclidean\",\"average\""));
        this.eucCentrCB.setSelected(this.commandsValidate.contains("\"euclidean\",\"centroid\""));
        this.eucComplCB.setSelected(this.commandsValidate.contains("\"euclidean\",\"complete\""));
        this.eucMcQCB.setSelected(this.commandsValidate.contains("\"euclidean\",\"mcquitty\""));
        this.eucMedCB.setSelected(this.commandsValidate.contains("\"euclidean\",\"median\""));
        this.eucSingCB.setSelected(this.commandsValidate.contains("\"euclidean\",\"single\""));
        this.eucWardCB.setSelected(this.commandsValidate.contains("\"euclidean\",\"ward.D\""));
        this.manAvgCB.setSelected(this.commandsValidate.contains("\"manhattan\",\"average\""));
        this.manCentrCB.setSelected(this.commandsValidate.contains("\"manhattan\",\"centroid\""));
        this.manComplCB.setSelected(this.commandsValidate.contains("\"manhattan\",\"complete\""));
        this.manMcQCB.setSelected(this.commandsValidate.contains("\"manhattan\",\"mcquitty\""));
        this.manMedCB.setSelected(this.commandsValidate.contains("\"manhattan\",\"median\""));
        this.manSingCB.setSelected(this.commandsValidate.contains("\"manhattan\",\"single\""));
        this.manWardCB.setSelected(this.commandsValidate.contains("\"manhattan\",\"ward.D\""));
        this.maxAvgCB.setSelected(this.commandsValidate.contains("\"maximum\",\"average\""));
        this.maxCentrCB.setSelected(this.commandsValidate.contains("\"maximum\",\"centroid\""));
        this.maxComplCB.setSelected(this.commandsValidate.contains("\"maximum\",\"complete\""));
        this.maxMcQCB.setSelected(this.commandsValidate.contains("\"maximum\",\"mcquitty\""));
        this.maxMedCB.setSelected(this.commandsValidate.contains("\"maximum\",\"median\""));
        this.maxSingCB.setSelected(this.commandsValidate.contains("\"maximum\",\"single\""));
        this.maxWardCB.setSelected(this.commandsValidate.contains("\"maximum\",\"ward.D\""));
        this.minAvgCB.setSelected(this.commandsValidate.contains("\"minkowski\",\"average\""));
        this.minCentrCB.setSelected(this.commandsValidate.contains("\"minkowski\",\"centroid\""));
        this.minComplCB.setSelected(this.commandsValidate.contains("\"minkowski\",\"complete\""));
        this.minMcQCB.setSelected(this.commandsValidate.contains("\"minkowski\",\"mcquitty\""));
        this.minMedCB.setSelected(this.commandsValidate.contains("\"minkowski\",\"median\""));
        this.minSingCB.setSelected(this.commandsValidate.contains("\"minkowski\",\"single\""));
        this.minWardCB.setSelected(this.commandsValidate.contains("\"minkowski\",\"ward.D\""));
    }

    private void commandsAddAll() {
        this.commandsValidate.add("\"correlation\",\"average\"");
        this.commandsValidate.add("\"correlation\",\"centroid\"");
        this.commandsValidate.add("\"correlation\",\"complete\"");
        this.commandsValidate.add("\"correlation\",\"mcquitty\"");
        this.commandsValidate.add("\"correlation\",\"median\"");
        this.commandsValidate.add("\"correlation\",\"single\"");
        this.commandsValidate.add("\"correlation\",\"ward\"");
        this.commandsValidate.add("\"pearson\",\"average\"");
        this.commandsValidate.add("\"pearson\",\"centroid\"");
        this.commandsValidate.add("\"pearson\",\"complete\"");
        this.commandsValidate.add("\"pearson\",\"mcquitty\"");
        this.commandsValidate.add("\"pearson\",\"median\"");
        this.commandsValidate.add("\"pearson\",\"single\"");
        this.commandsValidate.add("\"pearson\",\"ward\"");
        this.commandsValidate.add("\"binary\",\"average\"");
        this.commandsValidate.add("\"binary\",\"centroid\"");
        this.commandsValidate.add("\"binary\",\"complete\"");
        this.commandsValidate.add("\"binary\",\"mcquitty\"");
        this.commandsValidate.add("\"binary\",\"median\"");
        this.commandsValidate.add("\"binary\",\"single\"");
        this.commandsValidate.add("\"binary\",\"ward.D\"");
        this.commandsValidate.add("\"canberra\",\"average\"");
        this.commandsValidate.add("\"canberra\",\"centroid\"");
        this.commandsValidate.add("\"canberra\",\"complete\"");
        this.commandsValidate.add("\"canberra\",\"mcquitty\"");
        this.commandsValidate.add("\"canberra\",\"median\"");
        this.commandsValidate.add("\"canberra\",\"single\"");
        this.commandsValidate.add("\"canberra\",\"ward.D\"");
        this.commandsValidate.add("\"euclidean\",\"average\"");
        this.commandsValidate.add("\"euclidean\",\"centroid\"");
        this.commandsValidate.add("\"euclidean\",\"complete\"");
        this.commandsValidate.add("\"euclidean\",\"mcquitty\"");
        this.commandsValidate.add("\"euclidean\",\"median\"");
        this.commandsValidate.add("\"euclidean\",\"single\"");
        this.commandsValidate.add("\"euclidean\",\"ward.D\"");
        this.commandsValidate.add("\"manhattan\",\"average\"");
        this.commandsValidate.add("\"manhattan\",\"centroid\"");
        this.commandsValidate.add("\"manhattan\",\"complete\"");
        this.commandsValidate.add("\"manhattan\",\"mcquitty\"");
        this.commandsValidate.add("\"manhattan\",\"median\"");
        this.commandsValidate.add("\"manhattan\",\"single\"");
        this.commandsValidate.add("\"manhattan\",\"ward.D\"");
        this.commandsValidate.add("\"maximum\",\"average\"");
        this.commandsValidate.add("\"maximum\",\"centroid\"");
        this.commandsValidate.add("\"maximum\",\"complete\"");
        this.commandsValidate.add("\"maximum\",\"mcquitty\"");
        this.commandsValidate.add("\"maximum\",\"median\"");
        this.commandsValidate.add("\"maximum\",\"single\"");
        this.commandsValidate.add("\"maximum\",\"ward.D\"");
        this.commandsValidate.add("\"minkowski\",\"average\"");
        this.commandsValidate.add("\"minkowski\",\"centroid\"");
        this.commandsValidate.add("\"minkowski\",\"complete\"");
        this.commandsValidate.add("\"minkowski\",\"mcquitty\"");
        this.commandsValidate.add("\"minkowski\",\"median\"");
        this.commandsValidate.add("\"minkowski\",\"single\"");
        this.commandsValidate.add("\"minkowski\",\"ward.D\"");
    }

    private void selectPearsonOnly() {
        this.commandsValidate.clear();
        this.commandsValidate.add("\"correlation\",\"average\"");
        this.commandsValidate.add("\"correlation\",\"centroid\"");
        this.commandsValidate.add("\"correlation\",\"complete\"");
        this.commandsValidate.add("\"correlation\",\"mcquitty\"");
        this.commandsValidate.add("\"correlation\",\"median\"");
        this.commandsValidate.add("\"correlation\",\"single\"");
        this.commandsValidate.add("\"correlation\",\"ward\"");
        this.commandsValidate.add("\"pearson\",\"average\"");
        this.commandsValidate.add("\"pearson\",\"centroid\"");
        this.commandsValidate.add("\"pearson\",\"complete\"");
        this.commandsValidate.add("\"pearson\",\"mcquitty\"");
        this.commandsValidate.add("\"pearson\",\"median\"");
        this.commandsValidate.add("\"pearson\",\"single\"");
        this.commandsValidate.add("\"pearson\",\"ward\"");
    }
}

